/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.facebook.presto.tests.DistributedQueryRunner;
import org.testng.annotations.Test;

public class TestLikeQueries
extends AbstractTestQueryFramework {
    @Override
    protected QueryRunner createQueryRunner() throws Exception {
        Session session = TestingSession.testSessionBuilder().setCatalog("test").setSchema("default").build();
        return new DistributedQueryRunner(session, 1);
    }

    @Test
    public void testLikeQueriesWithEscape() {
        this.assertQuery("SELECT IF('xT' LIKE '#_T' ESCAPE '#', c0, c1) FROM (values (true, false)) t(c0, c1)", "SELECT false");
        this.assertQuery("SELECT IF(c2 LIKE 'T' ESCAPE '#', c0, c1) FROM (values (true, false, 'T')) t(c0, c1, c2)", "SELECT true");
    }

    @Test
    public void testLikeQueriesWithInvalidEscape() {
        this.assertQueryFails("SELECT IF('T' LIKE '###T' ESCAPE '##', c0, c1) FROM (values (true, false)) t(c0, c1)", ".*Escape string must be a single character$");
        this.assertQueryFails("SELECT IF(c2 LIKE '' ESCAPE '', c0, c1) FROM (values (true, false, 'T')) t(c0, c1, c2)", ".*Escape string must be a single character$");
    }
}

