/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class AbstractTestNanQueries
extends AbstractTestQueryFramework {
    public static final String DOUBLE_NANS_TABLE_NAME = "double_nans_table";
    public static final String DOUBLE_NAN_FIRST_COLUMN = "_double_nan_first";
    public static final String DOUBLE_NAN_MIDDLE_COLUMN = "_double_nan_middle";
    public static final String DOUBLE_NAN_LAST_COLUMN = "_double_nan_last";
    public static final String REAL_NANS_TABLE_NAME = "real_nans_table";
    public static final String REAL_NAN_FIRST_COLUMN = "_real_nan_first";
    public static final String REAL_NAN_MIDDLE_COLUMN = "_real_nan_middle";
    public static final String REAL_NAN_LAST_COLUMN = "_real_nan_last";
    public static final String DISTINCT_TABLE_NAME = "distinct_nans_table";
    public static final String DOUBLE_DISTINCT1_COLUMN = "_double_distinct1";
    public static final String DOUBLE_DISTINCT2_COLUMN = "_double_distinct2";
    public static final String REAL_DISTINCT1_COLUMN = "_real_distinct1";
    public static final String REAL_DISTINCT2_COLUMN = "_real_distinct2";
    public static final String EXTRA_DISTINCT_COLUMN = "_extra_column";
    public static final String ARRAY_TABLE_NAME = "array_nans_table";
    public static final String SIMPLE_DOUBLE_ARRAY_COLUMN = "simple_double_array";
    public static final String SIMPLE_REAL_ARRAY_COLUMN = "simple_real_array";
    public static final String ARRAY_TABLE_NAME_NO_NULL = "array_nans_table_no_null";
    public static final String SIMPLE_DOUBLE_ARRAY_COLUMN_NO_NULL = "simple_double_array_no_null";
    public static final String SIMPLE_REAL_ARRAY_COLUMN_NO_NULL = "simple_real_array_no_null";
    public static final String MAP_TABLE_NAME = "map_nans_table";
    public static final String DOUBLE_MAP_COLUMN = "double_map";
    public static final String REAL_MAP_COLUMN = "real_map";

    @BeforeClass
    public void setup() {
        String createDoubleTableQuery = "CREATE TABLE double_nans_table AS SELECT * FROM (VALUES (nan(), 0.0, 1.0), (0.0, nan(), 2.0),( infinity(), 3.0,  0.0),( -4.0, 2.0, nan())) as t (_double_nan_first, _double_nan_middle, _double_nan_last)";
        this.assertUpdate(createDoubleTableQuery, 4L);
        String createFloatTableQuery = "CREATE TABLE real_nans_table AS SELECT * FROM (VALUES (CAST(nan() as REAL), CAST(0 AS REAL), CAST(1 AS REAL)), (CAST(0 as REAL), CAST(nan() AS REAL), CAST(2 AS REAL)),(CAST(infinity() AS REAL), CAST(3 AS REAL),  CAST(0 AS REAL)),( CAST(-4 AS REAL), CAST(2 AS REAL), CAST(nan() AS REAL))) as t (_real_nan_first, _real_nan_middle, _real_nan_last)";
        this.assertUpdate(createFloatTableQuery, 4L);
        String createDistinctTableQuery = "CREATE TABLE distinct_nans_table AS SELECT * FROM (VALUES (nan(), DOUBLE '0.0', CAST(nan() as REAL), REAL '0.0', 'a'),  (DOUBLE '0.0', nan(), REAL '0.0', CAST(nan() AS REAL), 'b'), (null, null, null, null, 'c'), (nan(), nan(), CAST(nan() as REAL), CAST(nan() as REAL), 'd'), (3.0, 3.0, REAL '3.0', REAL '3.0', 'e'), (0.0, 0.0, REAL '0.0', REAL '0.0', 'f'), (null, null, null, null, 'g'))AS t (_double_distinct1, _double_distinct2, _real_distinct1, _real_distinct2, _extra_column)";
        this.assertUpdate(createDistinctTableQuery, 7L);
        String createArrayTableQuery = "CREATE TABLE array_nans_table AS SELECT * FROM (VALUES (ARRAY[nan(), DOUBLE '0', DOUBLE '1', DOUBLE '-1'], ARRAY[cast(nan() AS REAL), REAL '0', REAL '1', REAL '-1']), (ARRAY[ DOUBLE '0', nan(), DOUBLE '1', DOUBLE '-1'], ARRAY[REAL '0', CAST(nan() AS REAL),  REAL '1', REAL '-1']), (ARRAY[ DOUBLE '0',  DOUBLE '1', DOUBLE '-1', nan()], ARRAY[REAL '0', REAL '1', REAL '-1',  CAST(nan() AS REAL)]), (ARRAY[null, nan(), DOUBLE '200'], ARRAY[null, CAST(nan() AS REAL), REAL '200']), (null, null), (ARRAY[nan(), nan()], ARRAY[CAST(nan() AS REAL), CAST(nan() AS REAL)]), (ARRAY[DOUBLE '0', DOUBLE '1', nan(), DOUBLE '-1', nan(), DOUBLE '1', DOUBLE '1', DOUBLE'0'], ARRAY [REAL '0', REAL '1', CAST(nan() AS REAL), REAL '-1', CAST(nan() AS REAL), REAL '1', REAL '1', REAL '0'])) AS t (simple_double_array, simple_real_array)";
        String createArrayTableNoNullQuery = "CREATE TABLE array_nans_table_no_null AS SELECT * FROM (VALUES (ARRAY[nan(), DOUBLE '0', DOUBLE '1', DOUBLE '-1'], ARRAY[cast(nan() AS REAL), REAL '0', REAL '1', REAL '-1']), (ARRAY[ DOUBLE '0', nan(), DOUBLE '1', DOUBLE '-1'], ARRAY[REAL '0', CAST(nan() AS REAL),  REAL '1', REAL '-1']), (ARRAY[ DOUBLE '0',  DOUBLE '1', DOUBLE '-1', nan()], ARRAY[REAL '0', REAL '1', REAL '-1',  CAST(nan() AS REAL)]), (ARRAY[null, nan(), DOUBLE '200'], ARRAY[null, CAST(nan() AS REAL), REAL '200']), (ARRAY[nan(), nan()], ARRAY[CAST(nan() AS REAL), CAST(nan() AS REAL)]), (ARRAY[DOUBLE '0', DOUBLE '1', nan(), DOUBLE '-1', nan(), DOUBLE '1', DOUBLE '1', DOUBLE'0'], ARRAY [REAL '0', REAL '1', CAST(nan() AS REAL), REAL '-1', CAST(nan() AS REAL), REAL '1', REAL '1', REAL '0'])) AS t (simple_double_array_no_null, simple_real_array_no_null)";
        this.assertUpdate(createArrayTableQuery, 7L);
        this.assertUpdate(createArrayTableNoNullQuery, 6L);
        String createMapTableQuery = "CREATE TABLE map_nans_table AS SELECT * FROM (VALUES (MAP(ARRAY[nan(), 1, 2], ARRAY[nan(), 100, 200]), MAP(ARRAY[CAST(nan() AS REAL), REAL '1', REAL '2'], ARRAY[CAST(nan() AS REAL), REAL '100', REAL '200'])),(MAP(ARRAY[2, nan(), 1], ARRAY[200, nan(), 100]), MAP(ARRAY[REAL '2', CAST(nan() AS REAL), REAL '1'], ARRAY[REAL '200', CAST(nan() AS REAL), REAL '100'])), (MAP(ARRAY[2, 1, nan()], ARRAY[200, 100, nan()]), MAP(ARRAY[REAL '2', REAL '1', CAST(nan() AS REAL)], ARRAY[REAL '200', REAL '100', CAST(nan() AS REAL)]))) AS t(double_map, real_map)";
        this.assertUpdate(createMapTableQuery, 3L);
    }

    @AfterClass
    public void tearDown() {
        this.assertUpdate("DROP TABLE double_nans_table");
        this.assertUpdate("DROP TABLE real_nans_table");
        this.assertUpdate("DROP TABLE distinct_nans_table");
        this.assertUpdate("DROP TABLE array_nans_table");
        this.assertUpdate("DROP TABLE map_nans_table");
    }

    @Test
    public void testDoubleLessThan() {
        this.assertQuery("SELECT nan() < 1.0", "SELECT false");
        this.assertQuery("SELECT infinity() < nan()", "SELECT true");
        this.assertQuery("SELECT nan() < infinity()", "SELECT false");
        this.assertQuery("SELECT nan() < nan()", "SELECT false");
        this.assertQuery(String.format("SELECT _double_nan_first < nan() from %s", DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES (false), (true), (true), (true))");
        this.assertQuery(String.format("SELECT nan() < _double_nan_first from %s", DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES (false), (false), (false), (false))");
    }

    @Test
    public void testRealLessThan() {
        this.assertQuery(String.format("SELECT _real_nan_first < CAST(nan() AS REAL) from %s", REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES (false), (true), (true), (true))");
        this.assertQuery(String.format("SELECT CAST(nan() AS REAL) < _real_nan_first from %s", REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES (false), (false), (false), (false))");
    }

    @Test
    public void testDoubleGreaterThan() {
        this.assertQuery("SELECT nan() > 1.0", "SELECT true");
        this.assertQuery("SELECT infinity() > nan()", "SELECT false");
        this.assertQuery("SELECT nan() > infinity()", "SELECT true");
        this.assertQuery("SELECT nan() > nan()", "SELECT false");
        this.assertQuery(String.format("SELECT _double_nan_first > nan() from %s", DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES (false), (false), (false), (false))");
        this.assertQuery(String.format("SELECT nan() > _double_nan_first from %s", DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES (false), (true), (true), (true))");
    }

    @Test
    public void testRealGreaterThan() {
        this.assertQuery(String.format("SELECT _real_nan_first > cast(nan() AS REAL) from %s", REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES (false), (false), (false), (false))");
        this.assertQuery(String.format("SELECT CAST(nan() AS REAL)> _real_nan_first from %s", REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES (false), (true), (true), (true))");
    }

    @Test
    public void testDoubleLessThanOrEqualTo() {
        this.assertQuery("SELECT nan() <= 1.0", "SELECT false");
        this.assertQuery("SELECT infinity() <= nan()", "SELECT true");
        this.assertQuery("SELECT nan() <= infinity()", "SELECT false");
        this.assertQuery("SELECT nan() <= nan()", "SELECT true");
        this.assertQuery(String.format("SELECT _double_nan_first <= nan() from %s", DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES (true), (true), (true), (true))");
        this.assertQuery(String.format("SELECT nan() <= _double_nan_first from %s", DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES (true), (false), (false), (false))");
    }

    @Test
    public void testRealLessThanOrEqualTo() {
        this.assertQuery(String.format("SELECT _real_nan_first <= CAST(nan() AS REAL) from %s", REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES (true), (true), (true), (true))");
        this.assertQuery(String.format("SELECT CAST(nan() AS REAL) <= _real_nan_first from %s", REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES (true), (false), (false), (false))");
    }

    @Test
    public void testDoubleGreaterThanOrEqualTo() {
        this.assertQuery("SELECT nan() >= 1.0", "SELECT true");
        this.assertQuery("SELECT infinity() >= nan()", "SELECT false");
        this.assertQuery("SELECT nan() >= infinity()", "SELECT true");
        this.assertQuery("SELECT nan() >= nan()", "SELECT true");
        this.assertQuery(String.format("SELECT _double_nan_first >= nan() from %s", DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES (true), (false), (false), (false))");
        this.assertQuery(String.format("SELECT nan() >= _double_nan_first from %s", DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES (true), (true), (true), (true))");
    }

    @Test
    public void testRealGreaterThanOrEqualTo() {
        this.assertQuery(String.format("SELECT _real_nan_first >= CAST(nan() AS REAL) from %s", REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES (true), (false), (false), (false))");
        this.assertQuery(String.format("SELECT CAST(nan() AS REAL) >= _real_nan_first from %s", REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES (true), (true), (true), (true))");
    }

    @Test
    public void testDoubleEquals() {
        this.assertQuery("SELECT nan() = nan()", "SELECT true");
        this.assertQuery("SELECT nan() = 3", "SELECT false");
        this.assertQuery(String.format("SELECT _double_nan_first = nan() from %s", DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES (true), (false), (false), (false))");
        this.assertQuery(String.format("SELECT nan() = _double_nan_first from %s", DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES (true), (false), (false), (false))");
    }

    @Test
    public void testRealEquals() {
        this.assertQuery(String.format("SELECT _real_nan_first = CAST(nan() AS REAL) from %s", REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES (true), (false), (false), (false))");
        this.assertQuery(String.format("SELECT CAST(nan() AS REAL) = _real_nan_first from %s", REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES (true), (false), (false), (false))");
    }

    @Test
    public void testDoubleNotEquals() {
        this.assertQuery("SELECT nan() <> nan()", "SELECT false");
        this.assertQuery("SELECT nan() <> 3", "SELECT true");
        this.assertQuery(String.format("SELECT _double_nan_first <> nan() from %s", DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES (false), (true), (true), (true))");
        this.assertQuery(String.format("SELECT nan() <> _double_nan_first from %s", DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES (false), (true), (true), (true))");
    }

    @Test
    public void testRealNotEquals() {
        this.assertQuery(String.format("SELECT _real_nan_first <> CAST(nan() AS REAL) from %s", REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES (false), (true), (true), (true))");
        this.assertQuery(String.format("SELECT CAST(nan() AS REAL) <> _real_nan_first from %s", REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES (false), (true), (true), (true))");
    }

    @Test
    public void testDoubleBetween() {
        this.assertQuery(String.format("SELECT nan() BETWEEN -infinity() AND _double_nan_first FROM %s", DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES (true), (false), (false), (false))");
        this.assertQuery(String.format("SELECT _double_nan_first BETWEEN -infinity() AND nan() FROM %s", DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES(true), (true), (true), (true))");
    }

    @Test
    public void testRealBetween() {
        this.assertQuery(String.format("SELECT CAST(nan() AS REAL) BETWEEN CAST(-infinity() AS REAL) AND _real_nan_first FROM %s", REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES (true), (false), (false), (false))");
        this.assertQuery(String.format("SELECT _real_nan_first BETWEEN CAST(-infinity() AS REAL) AND cast(nan() AS REAL) FROM %s", REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES(true), (true), (true), (true))");
    }

    @Test
    public void testDoubleIn() {
        this.assertQuery(String.format("SELECT nan() IN (1, 2, _double_nan_first) FROM %s", DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES (true), (false), (false), (false))");
        this.assertQuery(String.format("SELECT _double_nan_first IN (nan(), 0, 6)FROM %s", DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES(true), (true), (false), (false))");
    }

    @Test
    public void testRealIn() {
        this.assertQuery(String.format("SELECT CAST(nan() as REAL) IN (REAL '1', REAL '2', _real_nan_first) FROM %s", REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES (true), (false), (false), (false))");
        this.assertQuery(String.format("SELECT _real_nan_first IN (CAST(nan() as REAL), REAL '0', REAL '6')FROM %s", REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES(true), (true), (false), (false))");
    }

    @Test
    public void testDoubleNotIn() {
        this.assertQuery(String.format("SELECT nan() NOT IN (1, 2, _double_nan_first) FROM %s", DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES (false), (true), (true), (true))");
        this.assertQuery(String.format("SELECT _double_nan_first NOT IN (nan(), 0, 6)FROM %s", DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES(false), (false), (true), (true))");
    }

    @Test
    public void testRealNotIn() {
        this.assertQuery(String.format("SELECT CAST(nan() as REAL) NOT IN (REAL '1', REAL '2', _real_nan_first) FROM %s", REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES (false), (true), (true), (true))");
        this.assertQuery(String.format("SELECT _real_nan_first NOT IN (CAST(nan() as REAL), 0, 6)FROM %s", REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES(false), (false), (true), (true))");
    }

    @Test
    public void testSelectDistinct() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT DISTINCT _double_distinct1 FROM %s", DISTINCT_TABLE_NAME), "SELECT * FROM (VALUES(nan()), (0.0), (null), (3.0))");
        this.assertQueryWithSameQueryRunner(String.format("SELECT DISTINCT _real_distinct1 FROM %s", DISTINCT_TABLE_NAME), "SELECT * FROM (VALUES (CAST(nan() AS REAL)), (REAL '0.0'), (null), (REAL '3.0'))");
    }

    @Test
    public void testSelectDistinctAggregations() {
        Session markDistinct = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("use_mark_distinct", "true").build();
        this.assertQuery(markDistinct, String.format("SELECT count(DISTINCT _double_distinct1), count(_double_distinct1), count(*) FROM %s", DISTINCT_TABLE_NAME), "SELECT 3, 5, 7");
        this.assertQuery(markDistinct, String.format("SELECT count(DISTINCT _real_distinct1), count(_real_distinct1), count(*) FROM %s", DISTINCT_TABLE_NAME), "SELECT 3, 5, 7");
        Session noMarkDistinct = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("use_mark_distinct", "false").build();
        this.assertQuery(noMarkDistinct, String.format("SELECT count(DISTINCT _double_distinct1), count(_double_distinct1), count(*) FROM %s", DISTINCT_TABLE_NAME), "SELECT 3, 5, 7");
        this.assertQuery(noMarkDistinct, String.format("SELECT count(DISTINCT _real_distinct1), count(_real_distinct1), count(*) FROM %s", DISTINCT_TABLE_NAME), "SELECT 3, 5, 7");
    }

    @Test
    public void testGroupBy() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT _double_distinct1, count(*) FROM %s GROUP BY _double_distinct1", DISTINCT_TABLE_NAME), "SELECT * FROM (VALUES (nan(), BIGINT '2'), (0.0, BIGINT '2'), (null, BIGINT '2'), (3.0, BIGINT '1'))");
        this.assertQueryWithSameQueryRunner(String.format("SELECT _real_distinct1, count(*) FROM %s GROUP BY _real_distinct1", DISTINCT_TABLE_NAME), "SELECT * FROM (VALUES (CAST(nan() as REAL), BIGINT '2'), (REAL '0.0', BIGINT '2'), (null, BIGINT '2'), (REAL '3.0', BIGINT '1'))");
    }

    @Test
    public void testMin() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT min(%s), min(%s), min(%s) FROM %s", DOUBLE_NAN_FIRST_COLUMN, DOUBLE_NAN_MIDDLE_COLUMN, DOUBLE_NAN_LAST_COLUMN, DOUBLE_NANS_TABLE_NAME), "SELECT DOUBLE '-4.0', DOUBLE '0.0', DOUBLE '0.0'");
        this.assertQueryWithSameQueryRunner(String.format("SELECT min(%s), min(%s), min(%s) FROM %s", REAL_NAN_FIRST_COLUMN, REAL_NAN_MIDDLE_COLUMN, REAL_NAN_LAST_COLUMN, REAL_NANS_TABLE_NAME), "SELECT REAL '-4.0', REAL '0.0', REAL '0.0'");
    }

    @Test
    public void testDoubleArrayMinAgg() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT min(%s) FROM %s WHERE none_match(%s, x -> x IS NULL)", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME, SIMPLE_DOUBLE_ARRAY_COLUMN), "SELECT ARRAY[0, 1, -1, nan()]");
    }

    @Test
    public void testRealArrayMinAgg() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT min(%s) FROM %s WHERE none_match(%s, x -> x IS NULL)", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME, SIMPLE_REAL_ARRAY_COLUMN), "SELECT ARRAY[REAL'0', REAL '1', REAL '-1', CAST(nan() AS REAL)]");
    }

    @Test
    public void testDoubleArrayMaxAgg() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT max(%s) FROM %s WHERE none_match(%s, x -> x IS NULL)", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME, SIMPLE_DOUBLE_ARRAY_COLUMN), "SELECT ARRAY[nan(), nan()]");
    }

    @Test
    public void testRealArrayMaxAgg() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT max(%s) FROM %s WHERE none_match(%s, x -> x IS NULL)", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME, SIMPLE_REAL_ARRAY_COLUMN), "SELECT ARRAY[CAST(nan() AS REAL), CAST(nan() AS REAL)]");
    }

    @Test
    public void testMax() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT max(%s), max(%s), max(%s) FROM %s", DOUBLE_NAN_FIRST_COLUMN, DOUBLE_NAN_MIDDLE_COLUMN, DOUBLE_NAN_LAST_COLUMN, DOUBLE_NANS_TABLE_NAME), "SELECT nan(), nan(), nan()");
        this.assertQueryWithSameQueryRunner(String.format("SELECT max(%s), max(%s), max(%s) FROM %s", REAL_NAN_FIRST_COLUMN, REAL_NAN_MIDDLE_COLUMN, REAL_NAN_LAST_COLUMN, REAL_NANS_TABLE_NAME), "SELECT CAST(nan() AS REAL), CAST(nan() AS REAL), CAST(nan() AS REAL)");
    }

    @Test
    public void testMinN() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT min(%s, 2), min(%s, 2), min(%s, 2) FROM %s", DOUBLE_NAN_FIRST_COLUMN, DOUBLE_NAN_MIDDLE_COLUMN, DOUBLE_NAN_LAST_COLUMN, DOUBLE_NANS_TABLE_NAME), "SELECT ARRAY [DOUBLE '-4.0', DOUBLE '0.0'], Array [DOUBLE '0.0', DOUBLE '2.0'], ARRAY[DOUBLE '0.0', DOUBLE '1.0']");
        this.assertQueryWithSameQueryRunner(String.format("SELECT min(%s, 2), min(%s, 2), min(%s, 2) FROM %s", REAL_NAN_FIRST_COLUMN, REAL_NAN_MIDDLE_COLUMN, REAL_NAN_LAST_COLUMN, REAL_NANS_TABLE_NAME), "SELECT ARRAY [REAL '-4.0', REAL '0.0'], Array [REAL '0.0', REAL '2.0'], ARRAY[REAL '0.0', REAL '1.0']");
    }

    @Test
    public void testMaxN() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT max(%s, 2), max(%s, 2), max(%s, 2) FROM %s", DOUBLE_NAN_FIRST_COLUMN, DOUBLE_NAN_MIDDLE_COLUMN, DOUBLE_NAN_LAST_COLUMN, DOUBLE_NANS_TABLE_NAME), "SELECT ARRAY [nan(), infinity()], Array [nan(), 3.0], ARRAY[nan(), 2.0]");
        this.assertQueryWithSameQueryRunner(String.format("SELECT max(%s, 2), max(%s, 2), max(%s, 2) FROM %s", REAL_NAN_FIRST_COLUMN, REAL_NAN_MIDDLE_COLUMN, REAL_NAN_LAST_COLUMN, REAL_NANS_TABLE_NAME), "SELECT ARRAY [CAST(nan() AS REAL), CAST(infinity() AS REAL)], Array [CAST(nan() AS REAL), REAL '3.0'], ARRAY[CAST(nan() AS REAL), REAL '2.0']");
    }

    @Test
    public void testMinBy() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT min_by(%s, %s), min_by(%s, %s), min_by(%s, %s) FROM %s", DOUBLE_NAN_FIRST_COLUMN, DOUBLE_NAN_MIDDLE_COLUMN, DOUBLE_NAN_MIDDLE_COLUMN, DOUBLE_NAN_LAST_COLUMN, DOUBLE_NAN_LAST_COLUMN, DOUBLE_NAN_FIRST_COLUMN, DOUBLE_NANS_TABLE_NAME), "SELECT nan(), DOUBLE '3.0', nan()");
        this.assertQueryWithSameQueryRunner(String.format("SELECT min_by(%s, %s), min_by(%s, %s), min_by(%s, %s) FROM %s", REAL_NAN_FIRST_COLUMN, REAL_NAN_MIDDLE_COLUMN, REAL_NAN_MIDDLE_COLUMN, REAL_NAN_LAST_COLUMN, REAL_NAN_LAST_COLUMN, REAL_NAN_FIRST_COLUMN, REAL_NANS_TABLE_NAME), "SELECT CAST(nan() AS REAL), REAL'3.0', CAST(nan() AS REAL)");
    }

    @Test
    public void testMaxBy() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT max_by(%s, %s), max_by(%s, %s), max_by(%s, %s) FROM %s", DOUBLE_NAN_FIRST_COLUMN, DOUBLE_NAN_MIDDLE_COLUMN, DOUBLE_NAN_MIDDLE_COLUMN, DOUBLE_NAN_LAST_COLUMN, DOUBLE_NAN_LAST_COLUMN, DOUBLE_NAN_FIRST_COLUMN, DOUBLE_NANS_TABLE_NAME), "SELECT DOUBLE '0.0', DOUBLE '2.0', DOUBLE '1.0'");
        this.assertQueryWithSameQueryRunner(String.format("SELECT max_by(%s, %s), max_by(%s, %s), max_by(%s, %s) FROM %s", REAL_NAN_FIRST_COLUMN, REAL_NAN_MIDDLE_COLUMN, REAL_NAN_MIDDLE_COLUMN, REAL_NAN_LAST_COLUMN, REAL_NAN_LAST_COLUMN, REAL_NAN_FIRST_COLUMN, REAL_NANS_TABLE_NAME), "SELECT REAL '0.0', REAL'2.0', REAL '1.0'");
    }

    @Test
    public void testMinByN() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT min_by(%s, %s, 2), min_by(%s, %s, 2), min_by(%s, %s, 2) FROM %s", DOUBLE_NAN_FIRST_COLUMN, DOUBLE_NAN_MIDDLE_COLUMN, DOUBLE_NAN_MIDDLE_COLUMN, DOUBLE_NAN_LAST_COLUMN, DOUBLE_NAN_LAST_COLUMN, DOUBLE_NAN_FIRST_COLUMN, DOUBLE_NANS_TABLE_NAME), "SELECT ARRAY[nan(), DOUBLE '-4.0'], ARRAY[DOUBLE '3.0', DOUBLE '0.0'], ARRAY[nan(), DOUBLE '2.0']");
        this.assertQueryWithSameQueryRunner(String.format("SELECT min_by(%s, %s, 2), min_by(%s, %s, 2), min_by(%s, %s, 2) FROM %s", REAL_NAN_FIRST_COLUMN, REAL_NAN_MIDDLE_COLUMN, REAL_NAN_MIDDLE_COLUMN, REAL_NAN_LAST_COLUMN, REAL_NAN_LAST_COLUMN, REAL_NAN_FIRST_COLUMN, REAL_NANS_TABLE_NAME), "SELECT ARRAY[CAST(nan() AS REAL), REAL '-4.0'], ARRAY[REAL '3.0', REAL '0.0'], ARRAY[CAST(nan() AS REAL), REAL '2.0']");
    }

    @Test
    public void testMaxByN() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT max_by(%s, %s, 2), max_by(%s, %s, 2), max_by(%s, %s, 2) FROM %s", DOUBLE_NAN_FIRST_COLUMN, DOUBLE_NAN_MIDDLE_COLUMN, DOUBLE_NAN_MIDDLE_COLUMN, DOUBLE_NAN_LAST_COLUMN, DOUBLE_NAN_LAST_COLUMN, DOUBLE_NAN_FIRST_COLUMN, DOUBLE_NANS_TABLE_NAME), "SELECT ARRAY [DOUBLE '0.0', infinity()], ARRAY[DOUBLE '2.0', nan()], ARRAY[DOUBLE '1.0', DOUBLE '0.0']");
        this.assertQueryWithSameQueryRunner(String.format("SELECT max_by(%s, %s, 2), max_by(%s, %s, 2), max_by(%s, %s, 2) FROM %s", REAL_NAN_FIRST_COLUMN, REAL_NAN_MIDDLE_COLUMN, REAL_NAN_MIDDLE_COLUMN, REAL_NAN_LAST_COLUMN, REAL_NAN_LAST_COLUMN, REAL_NAN_FIRST_COLUMN, REAL_NANS_TABLE_NAME), "SELECT ARRAY [REAL '0.0', CAST(infinity() AS REAL)], ARRAY[REAL '2.0', CAST(nan() AS REAL)], ARRAY[REAL '1.0', REAL '0.0']");
    }

    @Test
    public void testGreatest() {
        this.assertQueryWithSameQueryRunner("SELECT GREATEST(1.5E0, nan())", "SELECT nan()");
        this.assertQueryWithSameQueryRunner(String.format("SELECT greatest(%s, %s, %s) FROM %s", DOUBLE_NAN_FIRST_COLUMN, DOUBLE_NAN_MIDDLE_COLUMN, DOUBLE_NAN_LAST_COLUMN, DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES (nan()), (nan()), (infinity()), (nan()))");
        this.assertQueryWithSameQueryRunner(String.format("SELECT greatest(%s, %s, %s) FROM %s", REAL_NAN_FIRST_COLUMN, REAL_NAN_MIDDLE_COLUMN, REAL_NAN_LAST_COLUMN, REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES (CAST(nan() AS REAL)), (CAST(nan() AS REAL)), CAST(infinity() AS REAL), (CAST(nan() AS REAL)))");
    }

    @Test
    public void testLeast() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT least(%s, %s, %s) FROM %s", DOUBLE_NAN_FIRST_COLUMN, DOUBLE_NAN_MIDDLE_COLUMN, DOUBLE_NAN_LAST_COLUMN, DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES (DOUBLE '0.0'), (DOUBLE '0.0'), (DOUBLE '0.0'), (DOUBLE '-4.0'))");
        this.assertQueryWithSameQueryRunner(String.format("SELECT least(%s, %s, %s) FROM %s", REAL_NAN_FIRST_COLUMN, REAL_NAN_MIDDLE_COLUMN, REAL_NAN_LAST_COLUMN, REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES (REAL '0.0'), (REAL '0.0'), (REAL'0.0'), REAL'-4.0')");
    }

    @Test
    public void testDoubleSetAgg() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT set_agg(%s), set_agg(%s) FROM %s", DOUBLE_DISTINCT1_COLUMN, DOUBLE_DISTINCT2_COLUMN, DISTINCT_TABLE_NAME), "SELECT ARRAY[nan(), 0.0, null, 3.0], ARRAY[0, nan(), null, 3.0]");
    }

    @Test
    public void testRealSetAgg() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT set_agg(%s), set_agg(%s) FROM %s", REAL_DISTINCT1_COLUMN, REAL_DISTINCT2_COLUMN, DISTINCT_TABLE_NAME), "SELECT ARRAY[cast(nan() as REAL), 0.0, null, REAL '3.0'], ARRAY[REAL '0.0', cast(nan() as REAL), null, REAL '3.0']");
    }

    @Test
    public void testDoubleSetUnion() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(set_union(%s)) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT ARRAY[-1, 0, 1, 200, nan(), null]");
    }

    @Test
    public void testRealSetUnion() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(set_union(%s)) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT ARRAY[REAL '-1', REAL '0', REAL '1', REAL '200', CAST(nan() AS REAL), null]");
    }

    @Test
    public void testDoubleHistogram() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT histogram(%s), histogram(%s) FROM %s", DOUBLE_DISTINCT1_COLUMN, DOUBLE_DISTINCT2_COLUMN, DISTINCT_TABLE_NAME), "SELECT MAP(ARRAY[nan(), 0.0, 3.0], ARRAY[BIGINT '2', BIGINT '2', BIGINT '1']), MAP(ARRAY[0.0, nan(),  3.0], ARRAY[BIGINT '2', BIGINT '2', BIGINT '1'])");
    }

    @Test
    public void testRealHistogram() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT histogram(%s), histogram(%s) FROM %s", REAL_DISTINCT1_COLUMN, REAL_DISTINCT2_COLUMN, DISTINCT_TABLE_NAME), "SELECT MAP(ARRAY[CAST(nan() AS REAL), REAL '0.0', 3.0], ARRAY[BIGINT '2', BIGINT '2', BIGINT '1']), MAP(ARRAY[REAL '0.0', CAST(nan() AS REAL), REAL '3.0'], ARRAY[BIGINT '2', BIGINT '2', BIGINT '1'])");
    }

    @Test
    public void testDoubleMapAgg() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(map_keys(map_agg(%1$s, %3$s))), array_sort(map_keys(map_agg(%2$s, %3$s)))  FROM %4$s WHERE %1$s IS NOT NULL AND %2$s IS NOT NULL", DOUBLE_DISTINCT1_COLUMN, DOUBLE_DISTINCT2_COLUMN, EXTRA_DISTINCT_COLUMN, DISTINCT_TABLE_NAME), "SELECT ARRAY[0.0, 3.0, nan()], ARRAY[0.0, 3.0, nan()]");
    }

    @Test
    public void testRealMapAgg() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(map_keys(map_agg(%1$s, %3$s))), array_sort(map_keys(map_agg(%2$s, %3$s)))  FROM %4$s WHERE %1$s IS NOT NULL AND %2$s IS NOT NULL", REAL_DISTINCT1_COLUMN, REAL_DISTINCT2_COLUMN, EXTRA_DISTINCT_COLUMN, DISTINCT_TABLE_NAME), "SELECT ARRAY[REAL '0.0', REAL '3.0', CAST(nan() AS REAL)], ARRAY[REAL '0.0', REAL '3.0', CAST(nan() AS REAL)]");
    }

    @Test
    public void testDoubleMapUnion() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(map_keys(map_union(%s))) FROM %s", DOUBLE_MAP_COLUMN, MAP_TABLE_NAME), "SELECT ARRAY[1, 2, nan()]");
    }

    @Test
    public void testRealMapUnion() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(map_keys(map_union(%s))) FROM %s", REAL_MAP_COLUMN, MAP_TABLE_NAME), "SELECT ARRAY[REAL '1', REAL '2', CAST(nan() AS REAL)]");
    }

    @Test
    public void testDoubleMapUnionSum() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT map_union_sum(%s) FROM %s", DOUBLE_MAP_COLUMN, MAP_TABLE_NAME), "SELECT MAP(ARRAY[1, 2, nan()], ARRAY[300, 600, nan()])");
    }

    @Test
    public void testRealMapUnionSum() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT map_union_sum(%s) FROM %s", REAL_MAP_COLUMN, MAP_TABLE_NAME), "SELECT MAP(ARRAY[REAL '1', REAL '2', CAST(nan() AS REAL)], ARRAY[REAL '300', REAL '600', CAST(nan() AS REAL)])");
    }

    @Test
    public void testDoubleMultimapAgg() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT multimap_agg(%1$s, %3$s), multimap_agg(%2$s, %3$s)  FROM %4$s WHERE %1$s IS NOT NULL AND %2$s IS NOT NULL", DOUBLE_DISTINCT1_COLUMN, DOUBLE_DISTINCT2_COLUMN, EXTRA_DISTINCT_COLUMN, DISTINCT_TABLE_NAME), "SELECT MAP(ARRAY[nan(), 0.0, 3.0], ARRAY[ARRAY['a', 'd'], ARRAY['b', 'f'], ARRAY['e']]), MAP(ARRAY[0.0, nan(), 3.0], ARRAY[ARRAY['a', 'f'], ARRAY['b', 'd'], ARRAY['e']])");
    }

    @Test
    public void testRealMultimapAgg() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT multimap_agg(%1$s, %3$s), multimap_agg(%2$s, %3$s)  FROM %4$s WHERE %1$s IS NOT NULL AND %2$s IS NOT NULL", REAL_DISTINCT1_COLUMN, REAL_DISTINCT2_COLUMN, EXTRA_DISTINCT_COLUMN, DISTINCT_TABLE_NAME), "SELECT MAP(ARRAY[CAST(nan() AS REAL), REAL '0.0', REAL '3.0'], ARRAY[ARRAY['a', 'd'], ARRAY['b', 'f'], ARRAY['e']]), MAP(ARRAY[REAL '0.0', CAST(nan() AS REAL), REAL '3.0'], ARRAY[ARRAY['a', 'f'], ARRAY['b', 'd'], ARRAY['e']])");
    }

    @Test
    public void testDoubleAllMatch() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT all_match(%s, x -> x = nan()) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (false), (false), (false), (null), (false), (true), (false))");
    }

    @Test
    public void testRealAllMatch() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT all_match(%s, x -> x = nan()) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (false), (false), (false), (null), (false), (true), (false))");
    }

    @Test
    public void testDoubleAnyMatch() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT any_match(%s, x -> x = nan()) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (true), (true), (true), (null), (true), (true), (true))");
    }

    @Test
    public void testRealAnyMatch() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT any_match(%s, x -> x = nan()) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (true), (true), (true), (null), (true), (true), (true))");
    }

    @Test
    public void testDoubleArrayDistinct() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(array_distinct(%s)) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[-1, 0, 1, nan()]), (ARRAY[-1, 0, 1, nan()]), (ARRAY[-1, 0, 1, nan()]), (ARRAY[200, nan(), null]), (null), (ARRAY[nan()]), (ARRAY[-1, 0, 1, nan()]))");
    }

    @Test
    public void testRealArrayDistinct() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(array_distinct(%s)) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[REAL '-1', REAL '0', REAL '1', CAST(nan() AS REAL)]), (ARRAY[REAL '-1', REAL '0', REAL '1', CAST(nan() AS REAL)]), (ARRAY[REAL '-1', REAL '0', REAL '1', CAST(nan() AS REAL)]), (ARRAY[REAL '200', CAST(nan() AS REAL), null]), (null), (ARRAY[CAST(nan() AS REAL)]), (ARRAY[REAL '-1', REAL '0', REAL '1', CAST(nan() AS REAL)]))");
    }

    @Test
    public void testDoubleArrayDuplicates() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(array_duplicates(%s)) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[]), (ARRAY[]), (ARRAY[]), (ARRAY[]), (null), (ARRAY[nan()]), (ARRAY[0, 1, nan()]))");
    }

    @Test
    public void testRealArrayDuplicates() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(array_duplicates(%s)) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[]), (ARRAY[]), (ARRAY[]), (ARRAY[]), (null), (ARRAY[CAST(nan() AS REAL)]), (ARRAY[REAL '0', REAL '1', CAST(nan() AS REAL)]))");
    }

    @Test
    public void testDoubleArrayExcept() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(array_except(%s, ARRAY[nan()])) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[DOUBLE '-1', DOUBLE '0', DOUBLE '1']), (ARRAY[DOUBLE '-1', DOUBLE '0', DOUBLE '1']), (ARRAY[DOUBLE '-1', DOUBLE '0', DOUBLE '1']), (ARRAY[DOUBLE '200', null]), (null), (ARRAY[]), (ARRAY[DOUBLE '-1', DOUBLE '0', DOUBLE '1']))");
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(array_except(ARRAY[nan()], %s)) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[]), (ARRAY[]), (ARRAY[]), (ARRAY[]), (null), (ARRAY[]), (ARRAY[]))");
    }

    @Test
    public void testRealArrayExcept() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(array_except(%s, ARRAY[CAST(nan() AS REAL)])) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[REAL '-1', REAL '0', REAL '1']), (ARRAY[REAL '-1', REAL '0', REAL '1']), (ARRAY[REAL '-1', REAL '0', REAL '1']), (ARRAY[REAL '200', null]), (null), (ARRAY[]), (ARRAY[REAL '-1', REAL '0', REAL '1']))");
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(array_except(ARRAY[cast(nan() AS REAL)], %s)) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[]), (ARRAY[]), (ARRAY[]), (ARRAY[]), (null), (ARRAY[]), (ARRAY[]))");
    }

    @Test
    public void testDoubleArrayFrequency() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_frequency(filter(%s, x -> x IS NOT NULL)) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (map(ARRAY[DOUBLE '-1', DOUBLE '0', DOUBLE '1', nan()], ARRAY[1, 1, 1, 1])), (map(ARRAY[DOUBLE '-1', DOUBLE '0', DOUBLE '1', nan()], ARRAY[1, 1, 1, 1])), (map(ARRAY[DOUBLE '-1', DOUBLE '0', DOUBLE '1', nan()], ARRAY[1, 1, 1, 1])), (map(ARRAY[DOUBLE '200', nan()], ARRAY[1, 1])), (null), (map(ARRAY[nan()], ARRAY[2])), (map(ARRAY[DOUBLE '-1', DOUBLE '0', DOUBLE '1', nan()], ARRAY[1, 2, 3, 2])))");
    }

    @Test
    public void testRealArrayFrequency() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_frequency(filter(%s, x -> x IS NOT NULL)) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (map(ARRAY[REAL '-1', REAL '0', REAL '1', CAST(nan() AS REAL)], ARRAY[1, 1, 1, 1])), (map(ARRAY[REAL '-1', REAL '0', REAL '1', CAST(nan() AS REAL)], ARRAY[1, 1, 1, 1])), (map(ARRAY[REAL '-1', REAL '0', REAL '1', CAST(nan() AS REAL)], ARRAY[1, 1, 1, 1])), (map(ARRAY[REAL '200', CAST(nan() AS REAL)], ARRAY[1, 1])), (null), (map(ARRAY[CAST(nan() AS REAL)], ARRAY[2])), (map(ARRAY[REAL '-1', REAL '0', REAL '1', CAST(nan() AS REAL)], ARRAY[1, 2, 3, 2])))");
    }

    @Test
    public void testDoubleArrayHasDuplicates() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_has_duplicates(%s) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (false), (false), (false), (false), (null), (true), (true))");
    }

    @Test
    public void testRealArrayHasDuplicates() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_has_duplicates(%s) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (false), (false), (false), (false), (null), (true), (true))");
    }

    @Test
    public void testDoubleArrayIntersect1() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(array_intersect(%s, ARRAY[nan()])) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[nan()]), (ARRAY[nan()]), (ARRAY[nan()]), (ARRAY[nan()]), (null), (ARRAY[nan()]), (ARRAY[nan()]))");
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(array_intersect(ARRAY[nan()], %s)) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[nan()]), (ARRAY[nan()]), (ARRAY[nan()]), (ARRAY[nan()]), (null), (ARRAY[nan()]), (ARRAY[nan()]))");
    }

    @Test
    public void testRealArrayIntersect() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(array_intersect(%s, ARRAY[nan()])) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[nan()]), (ARRAY[nan()]), (ARRAY[nan()]), (ARRAY[nan()]), (null), (ARRAY[nan()]), (ARRAY[nan()]))");
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(array_intersect(ARRAY[nan()], %s)) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[nan()]), (ARRAY[nan()]), (ARRAY[nan()]), (ARRAY[nan()]), (null), (ARRAY[nan()]), (ARRAY[nan()]))");
    }

    @Test
    public void testDoubleArrayIntersect2() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(array_intersect(array_agg(%s))) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT NULL");
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(array_intersect(array_agg(%s))) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN_NO_NULL, ARRAY_TABLE_NAME_NO_NULL), "SELECT * FROM (VALUES (ARRAY[nan()]))");
    }

    @Test
    public void testRealArrayIntersect2() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(array_intersect(array_agg(%s))) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT NULL");
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(array_intersect(array_agg(%s))) FROM %s", SIMPLE_REAL_ARRAY_COLUMN_NO_NULL, ARRAY_TABLE_NAME_NO_NULL), "SELECT * FROM (VALUES (ARRAY[CAST(nan() AS REAL)]))");
    }

    @Test
    public void testDoubleArrayLeastFrequent() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_least_frequent(%s) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[-1]), (ARRAY[-1]), (ARRAY[-1]), (ARRAY[200]), (null), (ARRAY[nan()]), (ARRAY[-1]))");
    }

    @Test
    public void testRealArrayLeastFrequent() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_least_frequent(%s) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[REAL '-1']), (ARRAY[REAL '-1']), (ARRAY[REAL '-1']), (ARRAY[REAL '200']), (null), (ARRAY[CAST(nan() AS REAL)]), (ARRAY[REAL '-1']))");
    }

    @Test
    public void testDoubleArrayLeastFrequentN() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_least_frequent(%s, 3) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[-1, 0 , 1]), (ARRAY[-1, 0, 1]), (ARRAY[-1, 0, 1]), (ARRAY[200, nan()]), (null), (ARRAY[nan()]), (ARRAY[-1, 0, nan()]))");
    }

    @Test
    public void testRealArrayLeastFrequentN() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_least_frequent(%s, 3) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[REAL '-1', REAL '0' , REAL '1']), (ARRAY[REAL '-1', REAL '0', REAL '1']), (ARRAY[REAL '-1', REAL '0', REAL '1']), (ARRAY[REAL '200', CAST(nan() AS REAL)]), (null), (ARRAY[CAST(nan() AS REAL)]), (ARRAY[REAL '-1', REAL '0', CAST(nan() AS REAL)]))");
    }

    @Test
    public void testDoubleArrayMax() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_max(%s) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (nan()), (nan()), (nan()), (null), (null), (nan()), (nan()))");
    }

    @Test
    public void testRealArrayMax() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_max(%s) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (CAST(nan() AS REAL)), (CAST(nan() AS REAL)), (CAST(nan() AS REAL)), (null), (null), (CAST(nan() AS REAL)), (CAST(nan() AS REAL)))");
    }

    @Test
    public void testDoubleArrayMaxBy() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_max_by(%s, x -> x + 1) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (nan()), (nan()), (nan()), (null), (null), (nan()), (nan()))");
    }

    @Test
    public void testRealArrayMaxBy() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_max_by(%s, x -> x +1) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (CAST(nan() AS REAL)), (CAST(nan() AS REAL)), (CAST(nan() AS REAL)), (null), (null), (CAST(nan() AS REAL)), (CAST(nan() AS REAL)))");
    }

    @Test
    public void testDoubleArrayMin() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_min(%s) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (-1), (-1), (-1), (null), (null), (nan()), (-1))");
    }

    @Test
    public void testRealArrayMin() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_min(%s) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (REAL '-1'), (REAL '-1'), (REAL '-1'), (null), (null), (CAST(nan() AS REAL)), (REAL '-1'))");
    }

    @Test
    public void testDoubleArrayMinBy() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_min_by(%s, x -> x + 1) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (-1), (-1), (-1), (null), (null), (nan()), (-1))");
    }

    @Test
    public void testRealArrayMinBy() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_min_by(%s, x -> x + 1) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (REAL '-1'), (REAL '-1'), (REAL '-1'), (null), (null), (CAST(nan() AS REAL)), (REAL '-1'))");
    }

    @Test
    public void testDoubleArrayPosition() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_position(%s, nan()) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (BIGINT '1'), (BIGINT '2'), (BIGINT '4'), (BIGINT '2'), (null), (BIGINT '1'), (BIGINT '3'))");
    }

    @Test
    public void testRealArrayPosition() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_position(%s, nan()) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (BIGINT '1'), (BIGINT '2'), (BIGINT '4'), (BIGINT '2'), (null), (BIGINT '1'), (BIGINT '3'))");
    }

    @Test
    public void testDoubleArrayPositionI() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_position(%s, nan(), 2) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (BIGINT '0'), (BIGINT '0'), (BIGINT '0'), (BIGINT '0'), (null), (BIGINT '2'), (BIGINT '5'))");
    }

    @Test
    public void testRealArrayPositionI() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_position(%s, nan(), 2) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (BIGINT '0'), (BIGINT '0'), (BIGINT '0'), (BIGINT '0'), (null), (BIGINT '2'), (BIGINT '5'))");
    }

    @Test
    public void testDoubleArrayRemove() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_remove(%s, nan()) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[DOUBLE '0', DOUBLE '1', DOUBLE '-1']), (ARRAY[DOUBLE '0', DOUBLE '1', DOUBLE '-1']), (ARRAY[DOUBLE '0', DOUBLE '1', DOUBLE '-1']), (ARRAY[null, DOUBLE '200']), (null), (ARRAY[]), (ARRAY[DOUBLE '0', DOUBLE '1', DOUBLE '-1', DOUBLE '1', DOUBLE '1', DOUBLE '0']))");
    }

    @Test
    public void testRealArrayRemove() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_remove(%s, CAST(nan() AS REAL)) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[REAL '0', REAL '1', REAL '-1']), (ARRAY[REAL '0', REAL '1', REAL '-1']), (ARRAY[REAL '0', REAL '1', REAL '-1']), (ARRAY[null, REAL '200']), (null), (ARRAY[]), (ARRAY[REAL '0', REAL '1', REAL '-1', REAL '1', REAL '1', REAL '0']))");
    }

    @Test
    public void testDoubleArraySort() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(%s) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[-1, 0, 1, nan()]), (ARRAY[-1, 0, 1, nan()]), (ARRAY[-1, 0, 1, nan()]), (ARRAY[200, nan(), null]), (null), (ARRAY[nan(), nan()]), (ARRAY[-1, 0, 0, 1, 1, 1, nan(), nan()]))");
    }

    @Test
    public void testRealArraySort() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(%s) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[REAL '-1', REAL '0', REAL '1', CAST(nan() AS REAL)]), (ARRAY[REAL '-1', REAL '0', REAL '1', CAST(nan() AS REAL)]), (ARRAY[REAL '-1', REAL '0', REAL '1', CAST(nan() AS REAL)]), (ARRAY[REAL '200', CAST(nan() AS REAL), null]), (null), (ARRAY[CAST(nan() AS REAL), CAST(nan() AS REAL)]), (ARRAY[REAL '-1', REAL '0', REAL '0', REAL '1', REAL '1', REAL '1', CAST(nan() AS REAL), CAST(nan() AS REAL)]))");
    }

    @Test
    public void testDoubleArraySortLambda() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(%s, (x, y) -> IF(x > y, 1, IF(x = y, 0, -1))) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[-1, 0, 1, nan()]), (ARRAY[-1, 0, 1, nan()]), (ARRAY[-1, 0, 1, nan()]), (ARRAY[200, nan(), null]), (null), (ARRAY[nan(), nan()]), (ARRAY[-1, 0, 0, 1, 1, 1, nan(), nan()]))");
    }

    @Test
    public void testRealArraySortLambda() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(%s, (x, y) -> IF(x > y, 1, IF(x = y, 0, -1))) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[REAL '-1', REAL '0', REAL '1', CAST(nan() AS REAL)]), (ARRAY[REAL '-1', REAL '0', REAL '1', CAST(nan() AS REAL)]), (ARRAY[REAL '-1', REAL '0', REAL '1', CAST(nan() AS REAL)]), (ARRAY[REAL '200', CAST(nan() AS REAL), null]), (null), (ARRAY[CAST(nan() AS REAL), CAST(nan() AS REAL)]), (ARRAY[REAL '-1', REAL '0', REAL '0', REAL'1', REAL '1', REAL '1', CAST(nan() AS REAL), CAST(nan() AS REAL)]))");
    }

    @Test
    public void testDoubleArraySortDesc() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort_desc(%s) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[nan(), 1, 0, -1]), (ARRAY[nan(), 1, 0, -1]), (ARRAY[nan(), 1, 0, -1]), (ARRAY[nan(), 200, null]), (null), (ARRAY[nan(), nan()]), (ARRAY[nan(), nan(), 1, 1, 1, 0, 0, -1]))");
    }

    @Test
    public void testRealArraySortDesc() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort_desc(%s) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[CAST(nan() AS REAL), REAL '1', REAL '0', REAL '-1']), (ARRAY[CAST(nan() AS REAL), REAL '1', REAL '0', REAL '-1']), (ARRAY[CAST(nan() AS REAL), REAL '1', REAL '0', REAL '-1']), (ARRAY[CAST(nan() AS REAL), REAL '200', null]), (null), (ARRAY[CAST(nan() AS REAL), CAST(nan() AS REAL)]), (ARRAY[CAST(nan() AS REAL), CAST(nan() AS REAL), REAL '1', REAL '1', REAL '1', REAL '0', REAL '0', REAL '-1']))");
    }

    @Test
    public void testDoubleArrayTopN() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_top_n(%s, 2) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[nan(), 1]), (ARRAY[nan(), 1]), (ARRAY[nan(), 1]), (ARRAY[nan(), 200]), (null), (ARRAY[nan(), nan()]), (ARRAY[nan(), nan()]))");
    }

    @Test
    public void testRealArrayTopN() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_top_n(%s, 2) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[CAST(nan() AS REAL), REAL '1']), (ARRAY[CAST(nan() AS REAL), REAL '1']), (ARRAY[CAST(nan() AS REAL), REAL '1']), (ARRAY[CAST(nan() AS REAL), REAL '200']), (null), (ARRAY[CAST(nan() AS REAL), CAST(nan() AS REAL)]), (ARRAY[CAST(nan() AS REAL), CAST(nan() AS REAL)]))");
    }

    @Test
    public void testDoubleArraysOverlap() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT arrays_overlap(%s, ARRAY[nan()]) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (true), (true), (true), (true), (null), (true), (true))");
        this.assertQueryWithSameQueryRunner(String.format("SELECT arrays_overlap(ARRAY[nan()], %s) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (true), (true), (true), (true), (null), (true), (true))");
    }

    @Test
    public void testRealArraysOverlap() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT arrays_overlap(%s, ARRAY[nan()]) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (true), (true), (true), (true), (null), (true), (true))");
        this.assertQueryWithSameQueryRunner(String.format("SELECT arrays_overlap(ARRAY[nan()], %s) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (true), (true), (true), (true), (null), (true), (true))");
    }

    @Test
    public void testDoubleArrayUnion() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(array_union(%s, ARRAY[nan()])) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[DOUBLE '-1', DOUBLE '0', DOUBLE '1', nan()]), (ARRAY[DOUBLE '-1', DOUBLE '0', DOUBLE '1', nan()]), (ARRAY[DOUBLE '-1', DOUBLE '0', DOUBLE '1', nan()]), (ARRAY[DOUBLE '200', nan(), null]), (null), (ARRAY[nan()]), (ARRAY[DOUBLE '-1', DOUBLE '0', DOUBLE '1', nan()]))");
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(array_union(ARRAY[nan()], %s)) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[DOUBLE '-1', DOUBLE '0', DOUBLE '1', nan()]), (ARRAY[DOUBLE '-1', DOUBLE '0', DOUBLE '1', nan()]), (ARRAY[DOUBLE '-1', DOUBLE '0', DOUBLE '1', nan()]), (ARRAY[DOUBLE '200', nan(), null]), (null), (ARRAY[nan()]), (ARRAY[DOUBLE '-1', DOUBLE '0', DOUBLE '1', nan()]))");
    }

    @Test
    public void testRealArrayUnion() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(array_union(%s, ARRAY[CAST(nan() AS REAL)])) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[REAL '-1', REAL '0', REAL '1', CAST(nan() AS REAL)]), (ARRAY[REAL '-1', REAL '0', REAL '1', CAST(nan() AS REAL)]), (ARRAY[REAL '-1', REAL '0', REAL '1', CAST(nan() AS REAL)]), (ARRAY[REAL '200', CAST(nan() AS REAL), null]), (null), (ARRAY[CAST(nan() AS REAL)]), (ARRAY[REAL '-1', REAL '0', REAL '1', CAST(nan() AS REAL)]))");
        this.assertQueryWithSameQueryRunner(String.format("SELECT array_sort(array_union(ARRAY[CAST(nan() AS REAL)], %s)) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[REAL '-1', REAL '0', REAL '1', CAST(nan() AS REAL)]), (ARRAY[REAL '-1', REAL '0', REAL '1', CAST(nan() AS REAL)]), (ARRAY[REAL '-1', REAL '0', REAL '1', CAST(nan() AS REAL)]), (ARRAY[REAL '200', CAST(nan() AS REAL), null]), (null), (ARRAY[CAST(nan() AS REAL)]), (ARRAY[REAL '-1', REAL '0', REAL '1', CAST(nan() AS REAL)]))");
    }

    @Test
    public void testDoubleContains() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT contains(%s, nan()) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (true), (true), (true), (true), (null), (true), (true))");
    }

    @Test
    public void testRealContains() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT contains(%s, CAST(nan() AS REAL)) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (true), (true), (true), (true), (null), (true), (true))");
    }

    @Test
    public void testDoubleNoneMatch() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT none_match(%s, x -> x = nan()) FROM %s", SIMPLE_DOUBLE_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (false), (false), (false), (null), (false), (false), (false))");
    }

    @Test
    public void testRealNoneMatch() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT none_match(%s, x -> x = nan()) FROM %s", SIMPLE_REAL_ARRAY_COLUMN, ARRAY_TABLE_NAME), "SELECT * FROM (VALUES (false), (false), (false), (null), (false), (false), (false))");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="Duplicate map keys \\(NaN\\) are not allowed")
    public void testDoubleMapDuplicateKeys() {
        this.computeActual("select MAP(array[1, nan(), nan()], array['a', 'b','c'])");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="Duplicate map keys \\(NaN\\) are not allowed")
    public void testRealMapDuplicateKeys() {
        this.computeActual("select MAP(array[REAL '1', CAST(nan() AS REAL), CAST(nan() AS REAL)], array['a', 'b','c'])");
    }

    @Test
    public void testDoubleMapAccessor() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT %s[nan()] FROM %s", DOUBLE_MAP_COLUMN, MAP_TABLE_NAME), "SELECT * FROM (VALUES (nan()), (nan()), (nan()))");
    }

    @Test
    public void testRealMapAccessor() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT %s[CAST(nan() AS REAL)] FROM %s", REAL_MAP_COLUMN, MAP_TABLE_NAME), "SELECT * FROM (VALUES (CAST(nan() AS REAL)), CAST(nan() AS REAL), CAST(nan() AS REAL))");
    }

    @Test
    public void testDoubleElementAt() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT element_at(%s, nan()) FROM %s", DOUBLE_MAP_COLUMN, MAP_TABLE_NAME), "SELECT * FROM (VALUES (nan()), (nan()), (nan()))");
    }

    @Test
    public void testRealElementAt() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT element_at(%s, nan()) FROM %s", REAL_MAP_COLUMN, MAP_TABLE_NAME), "SELECT * FROM (VALUES (CAST(nan() AS REAL)), CAST(nan() AS REAL), CAST(nan() AS REAL))");
    }

    @Test
    public void testDoubleMapSubset() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT map_subset(%s, ARRAY[nan()]) FROM %s", DOUBLE_MAP_COLUMN, MAP_TABLE_NAME), "SELECT * FROM (VALUES (MAP(ARRAY[nan()], ARRAY[nan()])), (MAP(ARRAY[nan()], ARRAY[nan()])), (MAP(ARRAY[nan()], ARRAY[nan()])))");
    }

    @Test
    public void testRealMapSubset() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT map_subset(%s, ARRAY[CAST(nan() AS REAL)]) FROM %s", REAL_MAP_COLUMN, MAP_TABLE_NAME), "SELECT * FROM (VALUES (MAP(ARRAY[CAST(nan() AS REAL)], ARRAY[CAST(nan() AS REAL)])), (MAP(ARRAY[CAST(nan() AS REAL)], ARRAY[CAST(nan() AS REAL)])), (MAP(ARRAY[CAST(nan() AS REAL)], ARRAY[CAST(nan() AS REAL)])))");
    }

    @Test
    public void testDoubleMapKeyExists() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT map_key_exists(%s, nan()) FROM %s", DOUBLE_MAP_COLUMN, MAP_TABLE_NAME), "SELECT * FROM (VALUES (true), (true), (true))");
    }

    @Test
    public void testRealMapKeyExists() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT map_key_exists(%s, CAST(nan() AS REAL)) FROM %s", REAL_MAP_COLUMN, MAP_TABLE_NAME), "SELECT * FROM (VALUES (true), (true), (true))");
    }

    @Test
    public void testDoubleMapToNKeys() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT map_top_n_keys(%s, 2) FROM %s", DOUBLE_MAP_COLUMN, MAP_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[nan(), 2]), (ARRAY[nan(), 2]), (ARRAY[nan(), 2]))");
    }

    @Test
    public void testRealMapToNKey() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT map_top_n_keys(%s, 2) FROM %s", REAL_MAP_COLUMN, MAP_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[CAST(nan() AS REAL), REAL '2']), (ARRAY[CAST(nan() AS REAL), REAL '2']), (ARRAY[CAST(nan() AS REAL), REAL '2']))");
    }

    @Test
    public void testDoubleMapKeysByTopNValues() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT map_keys_by_top_n_values(%s, 2) FROM %s", DOUBLE_MAP_COLUMN, MAP_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[nan(), 2]), (ARRAY[nan(), 2]), (ARRAY[nan(), 2]))");
    }

    @Test
    public void testRealMapKeysByTopNValues() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT map_keys_by_top_n_values(%s, 2) FROM %s", REAL_MAP_COLUMN, MAP_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[CAST(nan() AS REAL), REAL '2']), (ARRAY[CAST(nan() AS REAL), REAL '2']), (ARRAY[CAST(nan() AS REAL), REAL '2']))");
    }

    @Test
    public void testDoubleMapToN() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT map_top_n(%s, 2) FROM %s", DOUBLE_MAP_COLUMN, MAP_TABLE_NAME), "SELECT * FROM (VALUES (MAP(ARRAY[nan(), 2], ARRAY[nan(), 200])), (MAP(ARRAY[nan(), 2], ARRAY[nan(), 200])), (MAP(ARRAY[nan(), 2], ARRAY[nan(), 200])))");
    }

    @Test
    public void testRealMapToN() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT map_top_n(%s, 2) FROM %s", REAL_MAP_COLUMN, MAP_TABLE_NAME), "SELECT * FROM (VALUES (MAP(ARRAY[CAST(nan() AS REAL), REAL '2'], ARRAY[CAST(nan() AS REAL), REAL '200'])), (MAP(ARRAY[CAST(nan() AS REAL), REAL '2'], ARRAY[CAST(nan() AS REAL), REAL '200'])), (MAP(ARRAY[CAST(nan() AS REAL), REAL '2'], ARRAY[CAST(nan() AS REAL), REAL '200'])))");
    }

    @Test
    public void testRealMapToNKeys() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT map_top_n_keys(%s, 2) FROM %s", REAL_MAP_COLUMN, MAP_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[CAST(nan() AS REAL), REAL '2']), (ARRAY[CAST(nan() AS REAL), REAL '2']), (ARRAY[CAST(nan() AS REAL), REAL '2']))");
    }

    @Test
    public void testDoubleMapToNValues() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT map_top_n_values(%s, 2) FROM %s", DOUBLE_MAP_COLUMN, MAP_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[nan(), 200]), (ARRAY[nan(), 200]), (ARRAY[nan(), 200]))");
    }

    @Test
    public void testRealMapToNValues() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT map_top_n_values(%s, 2) FROM %s", REAL_MAP_COLUMN, MAP_TABLE_NAME), "SELECT * FROM (VALUES (ARRAY[CAST(nan() AS REAL), REAL '200']), (ARRAY[CAST(nan() AS REAL), REAL '200']), (ARRAY[CAST(nan() AS REAL), REAL '200']))");
    }

    @Test
    public void testDoubleOrderBy() {
        this.assertQueryOrderedWithSameQueryRunner(String.format("SELECT %s FROM %s ORDER BY 1", DOUBLE_NAN_FIRST_COLUMN, DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES(-4), (0), (infinity()), (nan()))");
        this.assertQueryOrderedWithSameQueryRunner(String.format("SELECT %s FROM %s ORDER BY 1 DESC", DOUBLE_NAN_FIRST_COLUMN, DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES(nan()), (infinity()), (0), (-4))");
    }

    @Test
    public void testRealOrderBy() {
        this.assertQueryOrderedWithSameQueryRunner(String.format("SELECT %s FROM %s ORDER BY 1", REAL_NAN_FIRST_COLUMN, REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES(REAL '-4'), (REAL '0'), (CAST(infinity() AS REAL)), (CAST(nan() AS REAL)))");
        this.assertQueryOrderedWithSameQueryRunner(String.format("SELECT %s FROM %s ORDER BY 1 DESC", REAL_NAN_FIRST_COLUMN, REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES(CAST(nan() AS REAL)), (CAST(infinity() AS REAL)), (REAL '0'), (REAL '-4'))");
    }

    @Test
    public void testDoubleOrderByLimit() {
        this.assertQueryOrderedWithSameQueryRunner(String.format("SELECT %s FROM %s ORDER BY 1 LIMIT 2", DOUBLE_NAN_FIRST_COLUMN, DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES(DOUBLE '-4.0'), (DOUBLE '0.0'))");
        this.assertQueryOrderedWithSameQueryRunner(String.format("SELECT %s FROM %s ORDER BY 1 DESC LIMIT 2", DOUBLE_NAN_FIRST_COLUMN, DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES(nan()), (infinity()))");
    }

    @Test
    public void testRealOrderByLimit() {
        this.assertQueryOrderedWithSameQueryRunner(String.format("SELECT %s FROM %s ORDER BY 1 LIMIT 2", REAL_NAN_FIRST_COLUMN, REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES(REAL '-4'), (REAL '0'))");
        this.assertQueryOrderedWithSameQueryRunner(String.format("SELECT %s FROM %s ORDER BY 1 DESC LIMIT 2", REAL_NAN_FIRST_COLUMN, REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES(CAST(nan() AS REAL)), (CAST(infinity() AS REAL)))");
    }

    @Test
    public void testDoubleInnerJoin() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT %1$s FROM (SELECT %1$s from %3$s) JOIN (SELECT %2$s FROM %3$s) on %1$s = %2$s", DOUBLE_NAN_MIDDLE_COLUMN, DOUBLE_NAN_LAST_COLUMN, DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES(DOUBLE '0'), (DOUBLE '2'), (nan()))");
    }

    @Test
    public void testRealInnerJoin() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT %1$s FROM (SELECT %1$s from %3$s) JOIN (SELECT %2$s FROM %3$s) on %1$s = %2$s", REAL_NAN_MIDDLE_COLUMN, REAL_NAN_LAST_COLUMN, REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES(REAL '0'), (REAL '2'), (CAST(nan() AS REAL)))");
    }

    @Test
    public void testDoubleLeftJoin() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT %1$s, %2$s FROM (SELECT %1$s from %3$s) LEFT JOIN (SELECT %2$s FROM %3$s) on %1$s = %2$s", DOUBLE_NAN_MIDDLE_COLUMN, DOUBLE_NAN_LAST_COLUMN, DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES(DOUBLE '0', DOUBLE '0'), (DOUBLE '2', DOUBLE '2'), (nan(), nan()), (DOUBLE '3', null))");
    }

    @Test
    public void testRealLeftJoin() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT %1$s, %2$s FROM (SELECT %1$s from %3$s) LEFT JOIN (SELECT %2$s FROM %3$s) on %1$s = %2$s", REAL_NAN_MIDDLE_COLUMN, REAL_NAN_LAST_COLUMN, REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES(REAL '0', REAL '0'), (REAL '2', REAL '2'), (CAST(nan() AS REAL), CAST(nan() AS REAL)), (REAL '3', null))");
    }

    @Test
    public void testDoubleRightJoin() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT %1$s, %2$s FROM (SELECT %1$s from %3$s) RIGHT JOIN (SELECT %2$s FROM %3$s) on %1$s = %2$s", DOUBLE_NAN_MIDDLE_COLUMN, DOUBLE_NAN_LAST_COLUMN, DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES(DOUBLE '0', DOUBLE '0'), (DOUBLE '2', DOUBLE '2'), (nan(), nan()), (null, DOUBLE '1'))");
    }

    @Test
    public void testRealRightJoin() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT %1$s, %2$s FROM (SELECT %1$s from %3$s) RIGHT JOIN (SELECT %2$s FROM %3$s) on %1$s = %2$s", REAL_NAN_MIDDLE_COLUMN, REAL_NAN_LAST_COLUMN, REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES(REAL '0', REAL '0'), (REAL '2', REAL '2'), (CAST(nan() AS REAL), CAST(nan() AS REAL)), (null, REAL '1'))");
    }

    @Test
    public void testDoubleFullJoin() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT %1$s, %2$s FROM (SELECT %1$s from %3$s) FULL OUTER JOIN (SELECT %2$s FROM %3$s) on %1$s = %2$s", DOUBLE_NAN_MIDDLE_COLUMN, DOUBLE_NAN_LAST_COLUMN, DOUBLE_NANS_TABLE_NAME), "SELECT * FROM (VALUES(DOUBLE '0', DOUBLE '0'), (DOUBLE '2', DOUBLE '2'), (nan(), nan()), (DOUBLE '3', null), (null, DOUBLE '1'))");
    }

    @Test
    public void testRealFullJoin() {
        this.assertQueryWithSameQueryRunner(String.format("SELECT %1$s, %2$s FROM (SELECT %1$s from %3$s) FULL OUTER JOIN (SELECT %2$s FROM %3$s) on %1$s = %2$s", REAL_NAN_MIDDLE_COLUMN, REAL_NAN_LAST_COLUMN, REAL_NANS_TABLE_NAME), "SELECT * FROM (VALUES(REAL '0', REAL '0'), (REAL '2', REAL '2'), (CAST(nan() AS REAL), CAST(nan() AS REAL)), (REAL '3', null), (null, REAL '1'))");
    }
}

