/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.testing.assertions.Assert;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.facebook.presto.tests.DistributedQueryRunner;
import com.facebook.presto.tests.QueryAssertions;
import com.facebook.presto.tests.QueryTemplate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import org.testng.annotations.Test;

public abstract class AbstractTestJoinQueries
extends AbstractTestQueryFramework {
    @Test
    public void testShuffledStatsWithInnerJoin() {
        if (!(this.getQueryRunner() instanceof DistributedQueryRunner) || ((Boolean)this.getQueryRunner().getDefaultSession().getSystemProperty("spill_enabled", Boolean.class)).booleanValue()) {
            return;
        }
        DistributedQueryRunner queryRunner = (DistributedQueryRunner)this.getQueryRunner();
        long ordersRows = this.getTableRowCount("orders");
        long lineitemRows = this.getTableRowCount("lineitem");
        String query = "SELECT a.orderkey, a.orderstatus, b.linenumber FROM orders a JOIN lineitem b ON a.orderkey = b.orderkey";
        Session partitionedJoin = Session.builder((Session)this.getSession()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinReorderingStrategy.NONE.name()).build();
        QueryId partitionQueryId = queryRunner.executeWithQueryId(partitionedJoin, query).getQueryId();
        QueryInfo partitionJoinQueryInfo = queryRunner.getQueryInfo(partitionQueryId);
        long expectedRawInputRows = ordersRows + lineitemRows;
        Assert.assertEquals((long)partitionJoinQueryInfo.getQueryStats().getRawInputPositions(), (long)expectedRawInputRows);
        long expectedOutputRows = lineitemRows;
        Assert.assertEquals((long)partitionJoinQueryInfo.getQueryStats().getOutputPositions(), (long)expectedOutputRows);
        long expectedPartitionJoinShuffledRows = lineitemRows + ordersRows + expectedOutputRows;
        Assert.assertEquals((long)partitionJoinQueryInfo.getQueryStats().getShuffledPositions(), (long)expectedPartitionJoinShuffledRows);
        Session broadcastJoin = Session.builder((Session)this.getSession()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinReorderingStrategy.NONE.name()).build();
        QueryId broadcastQueryId = queryRunner.executeWithQueryId(broadcastJoin, query).getQueryId();
        org.testng.Assert.assertNotEquals((Object)partitionQueryId, (Object)broadcastQueryId);
        QueryInfo broadcastJoinQueryInfo = queryRunner.getQueryInfo(broadcastQueryId);
        Assert.assertEquals((long)broadcastJoinQueryInfo.getQueryStats().getRawInputPositions(), (long)expectedRawInputRows);
        Assert.assertEquals((long)broadcastJoinQueryInfo.getQueryStats().getOutputPositions(), (long)expectedOutputRows);
        Assert.assertEquals((long)((broadcastJoinQueryInfo.getQueryStats().getShuffledPositions() - expectedOutputRows) % lineitemRows), (long)0L);
        org.testng.Assert.assertTrue((broadcastJoinQueryInfo.getQueryStats().getShuffledPositions() - expectedOutputRows >= lineitemRows ? 1 : 0) != 0);
        Assert.assertEquals((long)partitionJoinQueryInfo.getQueryStats().getRawInputPositions(), (long)broadcastJoinQueryInfo.getQueryStats().getRawInputPositions());
        org.testng.Assert.assertNotEquals((Object)partitionJoinQueryInfo.getQueryStats().getShuffledDataSize(), (Object)broadcastJoinQueryInfo.getQueryStats().getShuffledDataSize());
    }

    @Test
    public void testRowFieldAccessorInJoin() {
        this.assertQuery("SELECT t.a.col1, custkey, orderkey FROM (VALUES ROW(CAST(ROW(1, 11) AS ROW(col0 integer, col1 integer))), ROW(CAST(ROW(2, 22) AS ROW(col0 integer, col1 integer))), ROW(CAST(ROW(3, 33) AS ROW(col0 integer, col1 integer)))) t(a) INNER JOIN orders ON t.a.col0 = orders.orderkey", "SELECT * FROM VALUES (11, 370, 1), (22, 781, 2), (33, 1234, 3)");
    }

    @Test
    public void testJoinWithMultiFieldGroupBy() {
        this.assertQuery("SELECT orderstatus FROM lineitem JOIN (SELECT DISTINCT orderkey, orderstatus FROM orders) T on lineitem.orderkey = T.orderkey");
    }

    @Test
    public void testDistinctJoin() {
        this.assertQuery("SELECT COUNT(DISTINCT CAST(b.quantity AS BIGINT)), a.orderstatus FROM orders a JOIN lineitem b ON a.orderkey = b.orderkey GROUP BY a.orderstatus");
    }

    @Test(enabled=false)
    public void testLimitWithJoin() {
        MaterializedResult actual = this.computeActual("SELECT o1.orderkey, o2.orderkey FROM orders o1 JOIN orders o2 on o1.orderkey = o2.orderkey LIMIT 10");
        MaterializedResult all = this.computeActual("SELECT o1.orderkey, o2.orderkey FROM orders o1 JOIN  orders o2 on o1.orderkey = o2.orderkey");
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
        actual = this.computeActual("SELECT o1.orderkey, o2.orderkey FROM orders o1 LEFT OUTER JOIN orders o2 on o1.orderkey = o2.orderkey LIMIT 10");
        all = this.computeActual("SELECT o1.orderkey, o2.orderkey FROM orders o1 LEFT OUTER JOIN orders o2 on o1.orderkey = o2.orderkey");
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
        actual = this.computeActual("SELECT o1.orderkey, o2.orderkey FROM orders o1 RIGHT OUTER JOIN orders o2 on o1.orderkey = o2.orderkey LIMIT 10");
        all = this.computeActual("SELECT o1.orderkey, o2.orderkey FROM orders o1 RIGHT OUTER JOIN orders o2 on o1.orderkey = o2.orderkey");
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
        actual = this.computeActual("SELECT o1.orderkey, o2.orderkey FROM orders o1 FULL OUTER JOIN orders o2 on o1.orderkey = o2.orderkey LIMIT 10");
        all = this.computeActual("SELECT o1.orderkey, o2.orderkey FROM orders o1 FULL OUTER JOIN orders o2 on o1.orderkey = o2.orderkey");
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testJoinCoercion() {
        this.assertQuery("SELECT COUNT(*) FROM orders t JOIN (SELECT * FROM orders LIMIT 1) t2 ON sin(t2.custkey) = 0");
    }

    @Test
    public void testJoinCoercionOnEqualityComparison() {
        this.assertQuery("SELECT o.clerk, avg(o.shippriority), COUNT(l.linenumber) FROM orders o LEFT OUTER JOIN lineitem l ON o.orderkey=l.orderkey AND o.shippriority=1 GROUP BY o.clerk");
    }

    @Test
    public void testJoinWithLessThanInJoinClause() {
        this.assertQuery("SELECT n.nationkey, r.regionkey FROM region r JOIN nation n ON n.regionkey = r.regionkey AND n.name < r.name");
        this.assertQuery("SELECT l.suppkey, n.nationkey, l.partkey, n.regionkey FROM nation n JOIN lineitem l ON l.suppkey = n.nationkey AND l.partkey < n.regionkey");
        this.assertQuery("SELECT b FROM nation n, (VALUES (0, CAST(-1 AS BIGINT)), (0, NULL), (0, CAST(0 AS BIGINT))) t(a, b) WHERE n.regionkey - 100 < t.b AND n.nationkey = t.a", "VALUES -1, 0");
        this.assertQuery("SELECT b FROM nation n, (VALUES (0, NULL), (0, CAST(-1 AS BIGINT)), (0, CAST(0 AS BIGINT))) t(a, b) WHERE n.regionkey - 100 < t.b AND n.nationkey = t.a", "VALUES -1, 0");
        this.assertQuery("SELECT b FROM nation n, (VALUES (0, NULL), (0, NULL), (0, CAST(-1 AS BIGINT)), (0, NULL)) t(a, b) WHERE n.regionkey - 100 < t.b AND n.nationkey = t.a", "VALUES -1");
        this.assertQuery("SELECT b FROM nation n, (VALUES (0, NULL)) t(a, b) WHERE n.regionkey - 100 < t.b AND n.nationkey = t.a", "SELECT 1 WHERE FALSE");
        this.assertQuery("SELECT n.nationkey, r.regionkey FROM nation n JOIN region r ON n.regionkey = r.regionkey AND length(n.name) < length(substr(r.name, 5))");
        this.assertQuery("SELECT * FROM (VALUES (1,1),(2,1)) t1(a,b), (VALUES (1,1),(1,2),(2,1)) t2(x,y) WHERE a=x and b<=y", "VALUES (1,1,1,1), (1,1,1,2), (2,1,2,1)");
        this.assertQuery("SELECT * FROM (VALUES (1,1),(2,1)) t1(a,b), (VALUES (1,1),(1,2),(2,1)) t2(x,y) WHERE a=x and b<y", "VALUES (1,1,1,2)");
    }

    @Test
    public void testJoinWithGreaterThanInJoinClause() {
        this.assertQuery("SELECT n.nationkey, r.regionkey FROM region r JOIN nation n ON n.regionkey = r.regionkey AND n.name > r.name AND r.regionkey = 0");
        this.assertQuery("SELECT l.suppkey, n.nationkey, l.partkey, n.regionkey FROM nation n JOIN lineitem l ON l.suppkey = n.nationkey AND l.partkey > n.regionkey");
        this.assertQuery("SELECT b FROM nation n, (VALUES (0, CAST(-1 AS BIGINT)), (0, NULL), (0, CAST(0 AS BIGINT))) t(a, b) WHERE n.regionkey + 100 > t.b AND n.nationkey = t.a", "VALUES -1, 0");
        this.assertQuery("SELECT b FROM nation n, (VALUES (0, NULL), (0, CAST(-1 AS BIGINT)), (0, CAST(0 AS BIGINT))) t(a, b) WHERE n.regionkey + 100 > t.b AND n.nationkey = t.a", "VALUES -1, 0");
        this.assertQuery("SELECT b FROM nation n, (VALUES (0, NULL), (0, NULL), (0, CAST(-1 AS BIGINT)), (0, NULL)) t(a, b) WHERE n.regionkey + 100 > t.b AND n.nationkey = t.a", "VALUES -1");
        this.assertQuery("SELECT b FROM nation n, (VALUES (0, NULL)) t(a, b) WHERE n.regionkey + 100 > t.b AND n.nationkey = t.a", "SELECT 1 WHERE FALSE");
        this.assertQuery("SELECT n.nationkey, r.regionkey FROM nation n JOIN region r ON n.regionkey = r.regionkey AND length(n.name) > length(substr(r.name, 5))");
        this.assertQuery("SELECT * FROM (VALUES (1,1),(2,1)) t1(a,b), (VALUES (1,1),(1,2),(2,1)) t2(x,y) WHERE a=x and b>=y", "VALUES (1,1,1,1), (2,1,2,1)");
        this.assertQuery("SELECT * FROM (VALUES (1,1),(2,1)) t1(a,b), (VALUES (1,1),(1,2),(2,1)) t2(x,y) WHERE a=x and b>y", "SELECT 1 WHERE FALSE");
    }

    @Test
    public void testJoinWithRangePredicatesInJoinClause() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 16 = 0 AND partkey % 2 = 0) lineitem JOIN (SELECT * FROM orders WHERE orderkey % 16 = 0 AND custkey % 2 = 0) orders ON lineitem.orderkey % 8 = orders.orderkey % 8 AND lineitem.linenumber % 2 = 0 AND orders.custkey % 8 < 7 AND lineitem.suppkey % 10 < orders.custkey % 7 AND lineitem.suppkey % 7 > orders.custkey % 7");
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 16 = 0 AND partkey % 2 = 0) lineitem JOIN (SELECT * FROM orders WHERE orderkey % 16 = 0 AND custkey % 2 = 0) orders ON lineitem.orderkey % 8 = orders.orderkey % 8 AND lineitem.linenumber % 2 = 0 AND orders.custkey % 8 < lineitem.linenumber % 2 AND lineitem.suppkey % 10 < orders.custkey % 7 AND lineitem.suppkey % 7 > orders.custkey % 7");
    }

    @Test
    public void testJoinWithMultipleLessThanPredicatesDifferentOrders() {
        this.assertQuery("SELECT count(*) FROM lineitem l JOIN nation n ON l.suppkey % 5 = n.nationkey % 5 AND l.partkey % 3 < n.regionkey AND l.partkey % 3 + 1 < n.regionkey AND l.partkey % 3 + 2 < n.regionkey");
        this.assertQuery("SELECT count(*) FROM lineitem l JOIN nation n ON l.suppkey % 5 = n.nationkey % 5 AND l.partkey % 3 + 2 < n.regionkey AND l.partkey % 3 + 1 < n.regionkey AND l.partkey % 3 < n.regionkey");
        this.assertQuery("SELECT count(*) FROM lineitem l JOIN nation n ON l.suppkey % 5 = n.nationkey % 5 AND l.partkey % 3 > n.regionkey AND l.partkey % 3 + 1 > n.regionkey AND l.partkey % 3 + 2 > n.regionkey");
        this.assertQuery("SELECT count(*) FROM lineitem l JOIN nation n ON l.suppkey % 5 = n.nationkey % 5 AND l.partkey % 3 + 2 > n.regionkey AND l.partkey % 3 + 1 > n.regionkey AND l.partkey % 3 > n.regionkey");
    }

    @Test
    public void testJoinWithLessThanOnDatesInJoinClause() {
        this.assertQuery("SELECT o.orderkey, o.orderdate, l.shipdate FROM orders o JOIN lineitem l ON l.orderkey = o.orderkey AND l.shipdate < o.orderdate + INTERVAL '10' DAY", "SELECT o.orderkey, o.orderdate, l.shipdate FROM orders o JOIN lineitem l ON l.orderkey = o.orderkey AND l.shipdate < DATEADD('DAY', 10, o.orderdate)");
        this.assertQuery("SELECT o.orderkey, o.orderdate, l.shipdate FROM lineitem l JOIN orders o ON l.orderkey = o.orderkey AND l.shipdate < DATE_ADD('DAY', 10, o.orderdate)", "SELECT o.orderkey, o.orderdate, l.shipdate FROM orders o JOIN lineitem l ON l.orderkey = o.orderkey AND l.shipdate < DATEADD('DAY', 10, o.orderdate)");
        this.assertQuery("SELECT o.orderkey, o.orderdate, l.shipdate FROM orders o JOIN lineitem l ON o.orderkey=l.orderkey AND o.orderdate + INTERVAL '2' DAY <= l.shipdate AND l.shipdate < o.orderdate + INTERVAL '7' DAY", "SELECT o.orderkey, o.orderdate, l.shipdate FROM orders o JOIN lineitem l ON o.orderkey=l.orderkey AND DATEADD('DAY', 2, o.orderdate) <= l.shipdate AND l.shipdate < DATEADD('DAY', 7, o.orderdate)");
    }

    @Test
    public void testJoinWithNonDeterministicLessThan() {
        MaterializedRow actualRow = (MaterializedRow)Iterables.getOnlyElement((Iterable)this.computeActual("SELECT count(*) FROM customer c1 JOIN customer c2 ON c1.nationkey=c2.nationkey WHERE c1.custkey - RANDOM(CAST(c1.custkey AS BIGINT)) < c2.custkey").getMaterializedRows());
        Assert.assertEquals((int)actualRow.getFieldCount(), (int)1);
        long actualCount = (Long)actualRow.getField(0);
        MaterializedRow expectedAtLeastRow = (MaterializedRow)Iterables.getOnlyElement((Iterable)this.computeActual("SELECT count(*) FROM customer c1 JOIN customer c2 ON c1.nationkey=c2.nationkey WHERE c1.custkey < c2.custkey").getMaterializedRows());
        Assert.assertEquals((int)expectedAtLeastRow.getFieldCount(), (int)1);
        long expectedAtLeastCount = (Long)expectedAtLeastRow.getField(0);
        org.testng.Assert.assertTrue((actualCount > expectedAtLeastCount ? 1 : 0) != 0);
    }

    @Test
    public void testSimpleJoin() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey");
        this.assertQuery("SELECT COUNT(*) FROM (SELECT orderkey FROM lineitem WHERE orderkey < 1000) a JOIN (SELECT orderkey FROM orders WHERE orderkey < 2000) b ON NOT (a.orderkey <= b.orderkey)");
    }

    @Test
    public void testJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = 2");
    }

    @Test
    public void testJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON orders.orderkey = 2");
    }

    @Test
    public void testSimpleJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = 2");
    }

    @Test
    public void testSimpleJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = 2");
    }

    @Test
    public void testJoinDoubleClauseWithLeftOverlap() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = orders.custkey");
    }

    @Test
    public void testJoinDoubleClauseWithRightOverlap() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = lineitem.partkey");
    }

    @Test
    public void testJoinWithAlias() {
        this.assertQuery("SELECT * FROM (lineitem JOIN orders ON lineitem.orderkey = orders.orderkey) x");
    }

    @Test
    public void testJoinWithConstantExpression() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND 123 = 123");
    }

    @Test
    public void testJoinWithConstantTrueExpressionWithCoercion() {
        this.assertQuery("SELECT count(*) > 0 FROM nation JOIN region ON (cast(1.2 AS real) = CAST(1.2 AS decimal(2,1)))");
    }

    @Test
    public void testJoinWithCanonicalizedConstantTrueExpressionWithCoercion() {
        this.assertQuery("SELECT count(*) > 0 FROM nation JOIN region ON CAST((CASE WHEN (TRUE IS NOT NULL) THEN '1.2' ELSE '1.2' END) AS real) = CAST(1.2 AS decimal(2,1))");
    }

    @Test
    public void testJoinWithConstantPredicatePushDown() {
        this.assertQuery("SELECT\n  a.orderstatus\n  , a.clerk\nFROM (\n  SELECT DISTINCT orderstatus, clerk FROM orders\n) a\nINNER JOIN (\n  SELECT DISTINCT orderstatus, clerk FROM orders\n) b\nON\n  a.orderstatus = b.orderstatus\n  and a.clerk = b.clerk\nwhere a.orderstatus = 'F'\n");
    }

    @Test
    public void testJoinWithInferredFalseJoinClause() {
        this.assertQuery("SELECT COUNT(*)\nFROM orders\nJOIN lineitem\nON CAST(orders.orderkey AS VARCHAR) = CAST(lineitem.orderkey AS VARCHAR)\nWHERE orders.orderkey = 1 AND lineitem.orderkey = 2\n");
    }

    @Test
    public void testJoinUsing() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders USING (orderkey)", "SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testJoinCriteriaCoercion() {
        this.assertQuery("SELECT * FROM (VALUES (1.0, 2.0)) x (a, b) JOIN (VALUES (1, 3)) y (a, b) ON x.a = y.a", "VALUES (1.0, 2.0, 1, 3)");
        this.assertQuery("SELECT * FROM (VALUES (1, 2)) x (a, b) JOIN (VALUES (SMALLINT '1', SMALLINT '3')) y (a, b) ON x.a = y.a", "VALUES (1, 2, 1, 3)");
        this.assertQuery(String.format("SELECT * FROM    (VALUES (CAST(1 AS DECIMAL(%1$d,0)), 2)) x (a, b) ,    (VALUES (CAST(0 AS DECIMAL(%1$d,0)), SMALLINT '3')) y (a, b)  WHERE x.a = y.a + 1", 18), "VALUES (1, 2, 0, 3)");
        this.assertQuery(String.format("SELECT * FROM    (VALUES (CAST(1 AS DECIMAL(%1$d,0)), 2)) x (a, b)    INNER JOIN    (VALUES (CAST(0 AS DECIMAL(%1$d,0)), SMALLINT '3')) y (a, b)    ON x.a = y.a + 1", 18), "VALUES (1, 2, 0, 3)");
        this.assertQuery(String.format("SELECT * FROM    (VALUES (CAST(1 AS DECIMAL(%1$d,0)), 2)) x (a, b)    LEFT JOIN (VALUES (CAST(0 AS DECIMAL(%1$d,0)), SMALLINT '3')) y (a, b)    ON x.a = y.a + 1", 18), "VALUES (1, 2, 0, 3)");
        this.assertQuery(String.format("SELECT * FROM    (VALUES CAST(1 AS decimal(%d,0))) t1 (a),    (VALUES CAST(1 AS decimal(%d,0))) t2 (b)    WHERE a = b", 18, 19), "VALUES (1, 1)");
    }

    @Test
    public void testJoinWithReversedComparison() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON orders.orderkey = lineitem.orderkey");
    }

    @Test
    public void testJoinWithComplexExpressions() {
        this.assertQuery("SELECT SUM(custkey) FROM lineitem JOIN orders ON lineitem.orderkey = CAST(orders.orderkey AS BIGINT)");
    }

    @Test
    public void testJoinWithComplexExpressions2() {
        this.assertQuery("SELECT SUM(custkey) FROM lineitem JOIN orders ON lineitem.orderkey = CASE WHEN orders.custkey = 1 and orders.orderstatus = 'F' THEN orders.orderkey ELSE NULL END");
    }

    @Test
    public void testJoinWithComplexExpressions3() {
        this.assertQuery("SELECT SUM(custkey) FROM lineitem JOIN orders ON lineitem.orderkey + 1 = orders.orderkey + 1", "SELECT SUM(custkey) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey ");
        Session handleComplexEquiJoins = Session.builder((Session)this.getSession()).setSystemProperty("handle_complex_equi_joins", "true").build();
        this.assertQueryWithSameQueryRunner(handleComplexEquiJoins, "select c.custkey, ps.partkey, s.suppkey, o.orderkey from customer c,     partsupp ps,     orders o,     supplier s where s.suppkey = ps.suppkey     and c.custkey = o.custkey     and s.nationkey + ps.partkey = c.nationkey order by c.custkey, ps.partkey, s.suppkey, o.orderkey", this.noJoinReordering(), "select c.custkey, ps.partkey, s.suppkey, o.orderkey from (customer c inner join orders o ON c.custkey = o.custkey)     inner join      (partsupp ps inner join supplier s ON s.suppkey = ps.suppkey)     on s.nationkey + ps.partkey = c.nationkey order by c.custkey, ps.partkey, s.suppkey, o.orderkey");
    }

    @Test
    public void testJoinWithNormalization() {
        this.assertQuery("SELECT COUNT(*) FROM nation a JOIN nation b on not ((a.nationkey + b.nationkey) <> b.nationkey)");
        this.assertQuery("SELECT COUNT(*) FROM nation a JOIN nation b on not (a.nationkey <> b.nationkey)");
        this.assertQuery("SELECT COUNT(*) FROM nation a JOIN nation b on not (a.nationkey = b.nationkey)");
        this.assertQuery("SELECT COUNT(*) FROM nation a JOIN nation b on not (not CAST(a.nationkey AS boolean))");
        this.assertQuery("SELECT COUNT(*) FROM nation a JOIN nation b on not not not (a.nationkey = b.nationkey)");
    }

    @Test
    public void testSelfJoin() {
        this.assertQuery("SELECT COUNT(*) FROM orders a JOIN orders b on a.orderkey = b.orderkey");
    }

    @Test
    public void testWildcardFromJoin() {
        this.assertQuery("SELECT * FROM (SELECT orderkey, partkey FROM lineitem) a JOIN (SELECT orderkey, custkey FROM orders) b using (orderkey)", "SELECT a.orderkey, a.partkey, b.custkey FROM (SELECT orderkey, partkey FROM lineitem) a JOIN (SELECT orderkey, custkey FROM orders) b on a.orderkey = b.orderkey");
    }

    @Test
    public void testQualifiedWildcardFromJoin() {
        this.assertQuery("SELECT a.*, b.* FROM (SELECT orderkey, partkey FROM lineitem) a JOIN (SELECT orderkey, custkey FROM orders) b using (orderkey)", "SELECT a.partkey, b.custkey FROM (SELECT orderkey, partkey FROM lineitem) a JOIN (SELECT orderkey, custkey FROM orders) b on a.orderkey = b.orderkey");
    }

    @Test
    public void testJoinAggregations() {
        this.assertQuery("SELECT x + y FROM (   SELECT orderdate, COUNT(*) x FROM orders GROUP BY orderdate) a JOIN (   SELECT orderdate, COUNT(*) y FROM orders GROUP BY orderdate) b ON a.orderdate = b.orderdate");
    }

    @Test
    public void testNonEqualityJoin() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity + length(orders.comment) > 7");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND NOT lineitem.quantity > 2");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON NOT NOT lineitem.orderkey = orders.orderkey AND NOT NOT lineitem.quantity > 2");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND NOT NOT NOT lineitem.quantity > 2");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity > 2");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity <= 2");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity != 2");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.shipdate > orders.orderdate");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderdate < lineitem.shipdate");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.comment LIKE '%forges%'");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.comment LIKE lineitem.comment");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.comment LIKE '%forges%'");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.comment LIKE orders.comment");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.comment NOT LIKE '%forges%'");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.comment NOT LIKE lineitem.comment");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND NOT (orders.comment LIKE '%forges%')");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND NOT (orders.comment LIKE lineitem.comment)");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity + length(orders.comment) > 7");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND NULL");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) JOIN (VALUES 10, 11) t2(b) ON a > 1", "VALUES (2, 11), (2, 10)");
        this.assertQuery("SELECT COUNT(*) FROM (VALUES 1, 2) t1(a) JOIN (VALUES 10, 11) t2(b) ON a > 2", "VALUES (0)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) JOIN (VALUES 10, 11) t2(b) ON a+9 > b", "VALUES (2, 10)");
    }

    @Test
    public void testNonEqualityLeftJoin() {
        this.assertQuery("SELECT COUNT(*) FROM       (SELECT * FROM lineitem ORDER BY orderkey,linenumber LIMIT 5) l          LEFT OUTER JOIN       (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o          ON       o.custkey != 1000 WHERE o.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > 1000 WHERE orders.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > 1000.0 WHERE orders.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > orders.totalprice WHERE orders.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > lineitem.quantity WHERE orders.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity > 5 WHERE orders.orderkey IS NULL");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b > d", "VALUES (1, 2, 1, 1), (1, 1, NULL, NULL)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b < d", "VALUES (1, 1, 1, 2), (1, 2, NULL, NULL)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b > 2", "VALUES (1, 1, NULL,  NULL), (1, 2, NULL, NULL)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND d > 2", "VALUES (1, 1, NULL, NULL), (1, 2, NULL, NULL)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b > 0", "VALUES (1, 1, 1, 1), (1, 1, 1, 2), (1, 2, 1, 1), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND d > 0", "VALUES (1, 1, 1, 1), (1, 1, 1, 2), (1, 2, 1, 1), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND c = d", "VALUES (1, 1, 1, 1), (1, 2, 1, 1)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND c < d", "VALUES (1, 1, 1, 2), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON c = d", "VALUES (1, 1, 1, 1), (1, 2, 1, 1)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON c < d", "VALUES (1, 1, 1, 2), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) LEFT OUTER JOIN (VALUES 10, 11) t2(b) ON 1 = 1", "VALUES (1, 10), (1, 11), (2, 10), (2, 11)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) LEFT OUTER JOIN (VALUES 10, 11) t2(b) ON a > 1", "VALUES (1, NULL), (2, 11), (2, 10)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) LEFT OUTER JOIN (VALUES 10, 11) t2(b) ON b > 10", "VALUES (1, 11), (2, 11)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) LEFT OUTER JOIN (VALUES 10, 11) t2(b) ON a > b", "VALUES (1, NULL), (2, NULL)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) LEFT OUTER JOIN (VALUES 10, 11) t2(b) ON a < b", "VALUES (1, 10), (1, 11), (2, 10), (2, 11)");
        this.assertQuery("SELECT * FROM (VALUES 1) t1(a) LEFT OUTER JOIN (VALUES (1,2,2), (1,2,3), (1, 2, NULL)) t2(x,y,z) ON a=x AND y = z", "VALUES (1, 1, 2, 2)");
        this.assertQuery("SELECT 1 FROM (VALUES 1, 20) t1(a) LEFT OUTER JOIN (VALUES 10, 11) t2(b) ON a > b WHERE b IS NOT NULL", "VALUES (1), (1)");
    }

    @Test
    public void testNonEqualityJoinWithScalarRequiringSessionParameter() {
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND from_unixtime(b) > current_timestamp", "VALUES (1, 1, NULL, NULL), (1, 2, NULL, NULL)");
    }

    @Test
    public void testNonEqualityJoinWithTryInFilter() {
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d)              ON a=c AND TRY(1 / (b-a) != 1000)", "VALUES (1, 1, NULL, NULL), (1, 2, 1, 1), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d)              ON a=c AND TRY(1 / (b-a) != 1000 OR from_unixtime(b) > current_timestamp)", "VALUES (1, 1, NULL, NULL), (1, 2, 1, 1), (1, 2, 1, 2)");
    }

    @Test
    public void testLeftJoinWithEmptyInnerTable() {
        this.assertQuery("SELECT * FROM lineitem a LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) b ON a.orderkey = b.orderkey");
        this.assertQuery("SELECT * FROM lineitem a LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) b ON a.orderkey > b.orderkey");
        this.assertQuery("SELECT * FROM lineitem a LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) b ON 1 = 1");
        this.assertQuery("SELECT * FROM lineitem a LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) b ON b.orderkey > 1");
        this.assertQuery("SELECT * FROM lineitem a LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) b ON b.orderkey > b.totalprice");
    }

    @Test
    public void testRightJoinWithEmptyInnerTable() {
        this.assertQuery("SELECT * FROM orders b RIGHT JOIN (SELECT * FROM orders WHERE orderkey = rand()) a ON a.orderkey = b.orderkey");
        this.assertQuery("SELECT * FROM orders b LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) a ON a.orderkey > b.orderkey");
        this.assertQuery("SELECT * FROM orders b LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) a ON 1 = 1");
        this.assertQuery("SELECT * FROM orders b LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) a ON b.orderkey > 1");
        this.assertQuery("SELECT * FROM orders b LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) a ON b.orderkey > b.totalprice");
    }

    @Test
    public void testNonEqualityRightJoin() {
        this.assertQuery("SELECT COUNT(*) FROM       (SELECT * FROM lineitem ORDER BY orderkey,linenumber LIMIT 5) l          RIGHT OUTER JOIN       (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o          ON       l.quantity != 5 WHERE l.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity > 5 WHERE lineitem.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity > 5.0 WHERE lineitem.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity > lineitem.suppkey WHERE lineitem.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity*1000 > orders.totalprice WHERE lineitem.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.totalprice > 1000 WHERE lineitem.orderkey IS NULL");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b > d", "VALUES (1, 2, 1, 1), (NULL, NULL, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b < d", "VALUES (1, 1, 1, 2), (NULL, NULL, 1, 1)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b > 2", "VALUES (NULL, NULL, 1, 1), (NULL, NULL, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND d > 2", "VALUES (NULL, NULL, 1, 1), (NULL, NULL, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b > 0", "VALUES (1, 1, 1, 1), (1, 1, 1, 2), (1, 2, 1, 1), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND d > 0", "VALUES (1, 1, 1, 1), (1, 1, 1, 2), (1, 2, 1, 1), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND c = d", "VALUES (1, 2, 1, 1), (1, 1, 1, 1), (NULL, NULL, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND c < d", "VALUES (NULL, NULL, 1, 1), (1, 2, 1, 2), (1, 1, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON c = d", "VALUES (1, 1, 1, 1), (1, 2, 1, 1), (NULL, NULL, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON c < d", "VALUES (NULL, NULL, 1, 1), (1, 1, 1, 2), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) RIGHT OUTER JOIN (VALUES 10, 11) t2(b) ON 1 = 1", "VALUES (1, 10), (1, 11), (2, 10), (2, 11)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) RIGHT OUTER JOIN (VALUES 10, 11) t2(b) ON a > 1", "VALUES (2, 11), (2, 10)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) RIGHT OUTER JOIN (VALUES 10, 11) t2(b) ON b > 10", "VALUES (NULL, 10), (1, 11), (2, 11)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) RIGHT OUTER JOIN (VALUES 10, 11) t2(b) ON a > b", "VALUES (NULL, 10), (NULL, 11)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) RIGHT OUTER JOIN (VALUES 10, 11) t2(b) ON a < b", "VALUES (1, 10), (1, 11), (2, 10), (2, 11)");
    }

    @Test
    public void testJoinUsingSymbolsFromJustOneSideOfJoin() {
        this.assertQuery("SELECT b FROM (VALUES 1, 2) t1(a) RIGHT OUTER JOIN (VALUES 10, 11) t2(b) ON b > 10", "VALUES (10), (11), (11)");
        this.assertQuery("SELECT a FROM (VALUES 1, 2) t1(a) RIGHT OUTER JOIN (VALUES 10, 11) t2(b) ON a > 1", "VALUES (2), (2)");
        this.assertQuery("SELECT b FROM (VALUES 1, 2) t1(a) LEFT OUTER JOIN (VALUES 10, 11) t2(b) ON b > 10", "VALUES (11), (11)");
        this.assertQuery("SELECT a FROM (VALUES 1, 2) t1(a) LEFT OUTER JOIN (VALUES 10, 11) t2(b) ON a > 1", "VALUES (1), (2), (2)");
        this.assertQuery("SELECT a FROM (VALUES 1, 2) t1(a) JOIN (VALUES 10, 11) t2(b) ON a > 1", "VALUES (2), (2)");
        this.assertQuery("SELECT b FROM (VALUES 1, 2) t1(a) JOIN (VALUES 10, 11) t2(b) ON b > 10", "VALUES (11), (11)");
    }

    @Test
    public void testJoinsWithTrueJoinCondition() {
        this.assertQuery("SELECT * FROM (VALUES 0, 1) t1(a) JOIN (VALUES 10, 11) t2(b) ON TRUE", "VALUES (0, 10), (0, 11), (1, 10), (1, 11)");
        this.assertQuery("SELECT * FROM (SELECT 1 WHERE FALSE) t1(a) JOIN (VALUES 10, 11) t2(b) ON TRUE", "SELECT 1 WHERE FALSE");
        this.assertQuery("SELECT * FROM (VALUES 0, 1) t1(a) JOIN (SELECT 1 WHERE FALSE) t2(b) ON TRUE", "SELECT 1 WHERE FALSE");
        this.assertQuery("SELECT * FROM (SELECT 1 WHERE FALSE) t1(a) JOIN (SELECT 1 WHERE FALSE) t2(b) ON TRUE", "SELECT 1 WHERE FALSE");
        this.assertQuery("SELECT * FROM (VALUES 0, 1) t1(a) LEFT JOIN (VALUES 10, 11) t2(b) ON TRUE", "VALUES (0, 10), (0, 11), (1, 10), (1, 11)");
        this.assertQuery("SELECT * FROM (SELECT 1 WHERE FALSE) t1(a) LEFT JOIN (VALUES 10, 11) t2(b) ON TRUE", "SELECT 1 WHERE FALSE");
        this.assertQuery("SELECT * FROM (VALUES 0, 1) t1(a) LEFT JOIN (SELECT 1 WHERE FALSE) t2(b) ON TRUE", "VALUES (0, NULL), (1, NULL)");
        this.assertQuery("SELECT * FROM (SELECT 1 WHERE FALSE) t1(a) LEFT JOIN (SELECT 1 WHERE FALSE) t2(b) ON TRUE", "SELECT 1 WHERE FALSE");
        this.assertQuery("SELECT * FROM (VALUES 0, 1) t1(a) RIGHT JOIN (VALUES 10, 11) t2(b) ON TRUE", "VALUES (0, 10), (0, 11), (1, 10), (1, 11)");
        this.assertQuery("SELECT * FROM (SELECT 1 WHERE FALSE) t1(a) RIGHT JOIN (VALUES 10, 11) t2(b) ON TRUE", "VALUES (NULL, 10), (NULL, 11)");
        this.assertQuery("SELECT * FROM (VALUES 0, 1) t1(a) RIGHT JOIN (SELECT 1 WHERE FALSE) t2(b) ON TRUE", "SELECT 1 WHERE FALSE");
        this.assertQuery("SELECT * FROM (SELECT 1 WHERE FALSE) t1(a) RIGHT JOIN (SELECT 1 WHERE FALSE) t2(b) ON TRUE", "SELECT 1 WHERE FALSE");
        this.assertQuery("SELECT * FROM (VALUES 0, 1) t1(a) FULL JOIN (VALUES 10, 11) t2(b) ON TRUE", "VALUES (0, 10), (0, 11), (1, 10), (1, 11)");
        this.assertQuery("SELECT * FROM (SELECT 1 WHERE FALSE) t1(a) FULL JOIN (VALUES 10, 11) t2(b) ON TRUE", "VALUES (NULL, 10), (NULL, 11)");
        this.assertQuery("SELECT * FROM (VALUES 0, 1) t1(a) FULL JOIN (SELECT 1 WHERE FALSE) t2(b) ON TRUE", "VALUES (0, NULL), (1, NULL)");
        this.assertQuery("SELECT * FROM (SELECT 1 WHERE FALSE) t1(a) FULL JOIN (SELECT 1 WHERE FALSE) t2(b) ON TRUE", "SELECT 1 WHERE FALSE");
    }

    @Test
    public void testNonEqualityFullJoin() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity > 5 WHERE lineitem.orderkey IS NULL OR orders.orderkey IS NULL", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey AS o1, orders.orderkey AS o2 FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity > 5     UNION ALL SELECT lineitem.orderkey AS o1, orders.orderkey AS o2 FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity > 5     WHERE lineitem.orderkey IS NULL)  WHERE o1 IS NULL OR o2 IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > 1000 WHERE lineitem.orderkey IS NULL OR orders.orderkey IS NULL", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey AS o1, orders.orderkey AS o2 FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > 1000     UNION ALL SELECT lineitem.orderkey AS o1, orders.orderkey AS o2 FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > 1000     WHERE lineitem.orderkey IS NULL)  WHERE o1 IS NULL OR o2 IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > lineitem.quantity WHERE lineitem.orderkey IS NULL OR orders.orderkey IS NULL", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey AS o1, orders.orderkey AS o2 FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > lineitem.quantity     UNION ALL SELECT lineitem.orderkey AS o1, orders.orderkey AS o2 FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > lineitem.quantity     WHERE lineitem.orderkey IS NULL)  WHERE o1 IS NULL OR o2 IS NULL");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) FULL OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b > d", "VALUES (1, 2, 1, 1), (NULL, NULL, 1, 2), (1, 1, NULL, NULL)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) FULL OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b < d", "VALUES (1, 1, 1, 2), (NULL, NULL, 1, 1), (1, 2, NULL, NULL)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) FULL OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b > 2", "VALUES (NULL, NULL, 1, 1), (NULL, NULL, 1, 2), (1, 1, NULL, NULL), (1, 2, NULL, NULL)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) FULL OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND d > 2", "VALUES (NULL, NULL, 1, 1), (NULL, NULL, 1, 2), (1, 1, NULL, NULL), (1, 2, NULL, NULL)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) FULL OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b > 0", "VALUES (1, 1, 1, 1), (1, 1, 1, 2), (1, 2, 1, 1), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) FULL OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND d > 0", "VALUES (1, 1, 1, 1), (1, 1, 1, 2), (1, 2, 1, 1), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) FULL OUTER JOIN (VALUES 10, 11) t2(b) ON a > 1", "VALUES (2, 11), (2, 10), (1, NULL)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) FULL OUTER JOIN (VALUES 10, 11) t2(b) ON b > 10", "VALUES (NULL, 10), (1, 11), (2, 11)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) FULL OUTER JOIN (VALUES 10, 11) t2(b) ON a > b", "VALUES (NULL, 10), (NULL, 11), (1, NULL), (2, NULL)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) FULL OUTER JOIN (VALUES 10, 11) t2(b) ON a < b", "VALUES (1, 10), (1, 11), (2, 10), (2, 11)");
    }

    @Test
    public void testJoinOnMultipleFields() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.shipdate = orders.orderdate");
    }

    @Test
    public void testJoinUsingMultipleFields() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN (SELECT orderkey, orderdate shipdate FROM orders) T USING (orderkey, shipdate)", "SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.shipdate = orders.orderdate");
    }

    @Test
    public void testColocatedJoinWithLocalUnion() {
        this.assertQuery("SELECT count(*) FROM ((SELECT * FROM orders) union all (SELECT * FROM orders)) JOIN orders USING (orderkey)", "SELECT 2 * count(*) FROM orders");
    }

    @Test
    public void testJoinWithNonJoinExpression() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey = 1");
    }

    @Test
    public void testJoinWithNullValues() {
        this.assertQuery("SELECT *\nFROM (\n  SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM lineitem\n  WHERE partkey % 512 = 0\n) AS lineitem \nJOIN (\n  SELECT CASE WHEN orderkey % 2 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM orders\n  WHERE custkey % 512 = 0\n) AS orders\nON lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testJoinWithMultipleInSubqueryClauses() {
        QueryTemplate.Parameter type = QueryTemplate.parameter((String)"type").of("");
        QueryTemplate.Parameter condition = QueryTemplate.parameter((String)"condition").of("true");
        QueryTemplate queryTemplate = QueryTemplate.queryTemplate((String)"SELECT * FROM (VALUES 1,2,3,4) t(x) %type% JOIN (VALUES 1,2,3,5) t2(y) ON %condition%", (QueryTemplate.Parameter[])new QueryTemplate.Parameter[]{type, condition});
        QueryTemplate.Parameter twoDuplicatedInSubqueriesCondition = condition.of("(x in (VALUES 1,2,3)) = (y in (VALUES 1,2,3)) AND (x in (VALUES 1,2,4)) = (y in (VALUES 1,2,4))");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{twoDuplicatedInSubqueriesCondition}), "VALUES (1,1), (1,2), (2,2), (2,1), (3,3)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("(x in (VALUES 1,2)) = (y in (VALUES 1,2)) AND (x in (VALUES 1)) = (y in (VALUES 3))")}), "VALUES (2,2), (2,1), (3,5), (4,5)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("(x in (VALUES 1,2)) = (y in (VALUES 1,2)) AND (x in (VALUES 1)) != (y in (VALUES 3))")}), "VALUES (1,2), (1,1), (3, 3), (4,3)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("(x in (VALUES 1)) = (y in (VALUES 1)) AND (x in (SELECT 2)) != (y in (SELECT 2))")}), "VALUES (2,3), (2,5), (3, 2), (4,2)");
        QueryTemplate.Parameter left = type.of("left");
        QueryTemplate.Parameter right = type.of("right");
        QueryTemplate.Parameter full = type.of("full");
        for (QueryTemplate.Parameter joinType : ImmutableList.of((Object)left, (Object)right, (Object)full)) {
            for (String joinCondition : ImmutableList.of((Object)"x IN (VALUES 1)", (Object)"y in (VALUES 1)")) {
                this.assertQueryFails(queryTemplate.replace(new QueryTemplate.Parameter[]{joinType, condition.of(joinCondition)}), ".*IN with subquery predicate in join condition is not supported");
            }
        }
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{left, twoDuplicatedInSubqueriesCondition}), "VALUES (1,1), (1,2), (2,2), (2,1), (3,3), (4, null)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{right, twoDuplicatedInSubqueriesCondition}), "VALUES (1,1), (1,2), (2,2), (2,1), (3,3), (null, 5)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{full, twoDuplicatedInSubqueriesCondition}), "VALUES (1,1), (1,2), (2,2), (2,1), (3,3), (4, null), (null, 5)");
    }

    @Test
    public void testJoinWithInSubqueryToBeExecutedAsPostJoinFilter() {
        QueryTemplate.Parameter type = QueryTemplate.parameter((String)"type").of("");
        QueryTemplate.Parameter condition = QueryTemplate.parameter((String)"condition").of("true");
        QueryTemplate queryTemplate = QueryTemplate.queryTemplate((String)"SELECT * FROM (VALUES 1,2,3,4) t(x) %type% JOIN (VALUES 1,2,3,5) t2(y) ON %condition%", (QueryTemplate.Parameter[])new QueryTemplate.Parameter[]{type, condition});
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("(x+y in (VALUES 4))")}), "VALUES (1,3), (2,2), (3,1)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("(x+y in (VALUES 4)) AND (x*y in (VALUES 4,5))")}), "VALUES (2,2)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("(x+y in (VALUES 4,5)) AND (x*y IN (VALUES 4,5))")}), "VALUES (4,1), (2,2)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("(x+y in (VALUES 4,5)) AND (x in (VALUES 4,5)) != (y in (VALUES 4,5))")}), "VALUES (4,1)");
        for (QueryTemplate.Parameter joinType : type.of(new String[]{"left", "right", "full"})) {
            this.assertQueryFails(queryTemplate.replace(new QueryTemplate.Parameter[]{joinType, condition.of("(x+y in (VALUES 4,5)) AND (x in (VALUES 4,5)) != (y in (VALUES 4,5))")}), ".*IN with subquery predicate in join condition is not supported");
        }
    }

    @Test(enabled=false)
    public void testOuterJoinWithExpression() {
        this.assertQuery("SELECT o.orderkey FROM orders o RIGHT JOIN lineitem l ON l.orderkey * 2 + 1 = o.orderkey");
        this.assertQuery("SELECT o.orderkey FROM orders o RIGHT JOIN lineitem l ON l.orderkey * 5 - o.orderkey * 10 = 1");
        this.assertQuery("SELECT o.orderkey FROM orders o LEFT JOIN lineitem l ON l.orderkey * 2 + 1 = o.orderkey");
        this.assertQuery("SELECT o.orderkey FROM orders o LEFT JOIN lineitem l ON l.orderkey * 5 - o.orderkey * 10 = 1");
    }

    @Test
    public void testOuterJoinWithComplexCorrelatedSubquery() {
        QueryTemplate.Parameter type = QueryTemplate.parameter((String)"type");
        QueryTemplate.Parameter condition = QueryTemplate.parameter((String)"condition");
        QueryTemplate queryTemplate = QueryTemplate.queryTemplate((String)"SELECT * FROM (VALUES 1,2,3,4) t(x) %type% JOIN (VALUES 1,2,3,5) t2(y) ON %condition%", (QueryTemplate.Parameter[])new QueryTemplate.Parameter[]{type, condition});
        queryTemplate.replaceAll(query -> this.assertQueryFails((String)query, "line .*: .* is not supported"), new List[]{ImmutableList.of((Object)type.of("left"), (Object)type.of("right"), (Object)type.of("full")), ImmutableList.of((Object)condition.of("EXISTS(SELECT 1 WHERE x = y)"), (Object)condition.of("(SELECT x = y)"), (Object)condition.of("true IN (SELECT x = y)"))});
    }

    @Test
    public void testJoinWithMultipleScalarSubqueryClauses() {
        QueryTemplate.Parameter type = QueryTemplate.parameter((String)"type").of("");
        QueryTemplate.Parameter condition = QueryTemplate.parameter((String)"condition");
        QueryTemplate queryTemplate = QueryTemplate.queryTemplate((String)"SELECT * FROM (VALUES 1,2,3,4) t(x) %type% JOIN (VALUES 1,2,3,5) t2(y) ON %condition%", (QueryTemplate.Parameter[])new QueryTemplate.Parameter[]{type, condition});
        QueryTemplate.Parameter multipleScalarJoinCondition = condition.of("(x = (VALUES 1)) AND (y = (VALUES 2)) AND (x in (VALUES 2)) = (y in (VALUES 1))");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{multipleScalarJoinCondition}), "VALUES (1,2)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("(x = (VALUES 2)) = (y > (VALUES 0)) AND (x > (VALUES 1)) = (y < (VALUES 3))")}), "VALUES (2,2), (2,1)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("(x = (VALUES 1)) = (y = (VALUES 1)) AND (x = (SELECT 2)) != (y = (SELECT 3))")}), "VALUES (2,5), (2,2), (3,3), (4,3)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{type.of("left"), multipleScalarJoinCondition}), "VALUES (1,2), (2,null), (3, null), (4, null)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{type.of("right"), multipleScalarJoinCondition}), "VALUES (1,2), (null,1), (null, 3), (null, 5)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{type.of("full"), multipleScalarJoinCondition}), "VALUES (1,2), (2,null), (3, null), (4, null), (null,1), (null, 3), (null, 5)");
    }

    @Test
    public void testJoinWithScalarSubqueryToBeExecutedAsPostJoinFilter() {
        QueryTemplate.Parameter type = QueryTemplate.parameter((String)"type").of("");
        QueryTemplate.Parameter condition = QueryTemplate.parameter((String)"condition");
        QueryTemplate queryTemplate = QueryTemplate.queryTemplate((String)"SELECT * FROM (VALUES 1,2,3,4) t(x) %type% JOIN (VALUES 1,2,3,5) t2(y) ON %condition%", (QueryTemplate.Parameter[])new QueryTemplate.Parameter[]{type, condition});
        QueryTemplate.Parameter xPlusYEqualsSubqueryJoinCondition = condition.of("(x+y = (SELECT 4))");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{xPlusYEqualsSubqueryJoinCondition}), "VALUES (1,3), (2,2), (3,1)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("(x+y = (VALUES 4)) AND (x*y = (VALUES 4))")}), "VALUES (2,2)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("x+y > (VALUES 3) AND (x = (VALUES 3)) != (y = (VALUES 3))")}), "VALUES (3,1), (3,2), (1,3), (2,3), (4,3), (3,5)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("x+y >= (VALUES 5) AND (x = (VALUES 3)) != (y = (VALUES 3))")}), "VALUES (3,2), (2,3), (4,3), (3,5)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("x+y >= (VALUES 3) AND (x = (VALUES 5)) != (y = (VALUES 3))")}), "VALUES (1,3), (2,3), (3,3), (4,3)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("x+y >= (VALUES 3) AND (x = (VALUES 3)) != (y = (VALUES 5))")}), "VALUES (3,1), (3,2), (3,3), (1,5), (2,5), (4,5)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("x+y >= (VALUES 4) AND (x = (VALUES 3)) != (y = (VALUES 5))")}), "VALUES (3,1), (3,2), (3,3), (1,5), (2,5), (4,5)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{type.of("left"), xPlusYEqualsSubqueryJoinCondition}), "VALUES (1,3), (2,2), (3,1), (4, null)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{type.of("right"), xPlusYEqualsSubqueryJoinCondition}), "VALUES (1,3), (2,2), (3,1), (null, 5)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{type.of("full"), xPlusYEqualsSubqueryJoinCondition}), "VALUES (1,3), (2,2), (3,1), (4, null), (null, 5)");
    }

    @Test
    public void testJoinWithScalarSubqueryInOnClause() {
        this.assertQuery("SELECT count() FROM nation a INNER JOIN nation b ON a.name = (SELECT max(name) FROM nation) INNER JOIN nation c ON c.name = split_part(b.name,'<',2)", "SELECT 0");
    }

    @Test
    public void testJoinWithScalarSubqueryToBeExecutedAsPostJoinFilterWithEmptyInnerTable() {
        String noOutputQuery = "SELECT 1 WHERE false";
        QueryTemplate.Parameter type = QueryTemplate.parameter((String)"type").of("");
        QueryTemplate.Parameter condition = QueryTemplate.parameter((String)"condition");
        QueryTemplate queryTemplate = QueryTemplate.queryTemplate((String)("SELECT * FROM (" + noOutputQuery + ") t(x) %type% JOIN (VALUES 1) t2(y) ON %condition%"), (QueryTemplate.Parameter[])new QueryTemplate.Parameter[]{type});
        QueryTemplate.Parameter xPlusYEqualsSubqueryJoinCondition = condition.of("(x+y = (SELECT 4))");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{xPlusYEqualsSubqueryJoinCondition}), noOutputQuery);
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("(x+y = (VALUES 4)) AND (x*y = (VALUES 4))")}), noOutputQuery);
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{xPlusYEqualsSubqueryJoinCondition, type.of("left")}), noOutputQuery);
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{xPlusYEqualsSubqueryJoinCondition, type.of("right")}), "VALUES (null,1)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{xPlusYEqualsSubqueryJoinCondition, type.of("full")}), "VALUES (null,1)");
    }

    @Test
    public void testJoinWithExpressionsThatMayReturnNull() {
        this.assertQuery("SELECT *\nFROM (\n    SELECT a, nullif(a, 1)\n    FROM (VALUES 1) w(a)\n) t(a,b)\nJOIN (VALUES 1) u(x) ON t.a = u.x", "SELECT 1, NULL, 1");
        this.assertQuery("SELECT *\nFROM (\n    SELECT a, contains(array[2, null], a)\n    FROM (VALUES 1) w(a)\n) t(a,b)\nJOIN (VALUES 1) u(x) ON t.a = u.x\n", "SELECT 1, NULL, 1");
        this.assertQuery("SELECT *\nFROM (\n    SELECT a, array[null][a]\n    FROM (VALUES 1) w(a)\n) t(a,b)\nJOIN (VALUES 1) u(x) ON t.a = u.x", "SELECT 1, NULL, 1");
        this.assertQuery("SELECT *\nFROM (\n    SELECT a, try(a / 0)\n    FROM (VALUES 1) w(a)\n) t(a,b)\nJOIN (VALUES 1) u(x) ON t.a = u.x", "SELECT 1, NULL, 1");
    }

    @Test
    public void testLeftFilteredJoin() {
        this.assertQuery("SELECT custkey, linestatus, tax, totalprice, orderstatus FROM (SELECT * FROM lineitem WHERE orderkey % 2 = 0) a JOIN orders ON a.orderkey = orders.orderkey");
    }

    @Test
    public void testRightFilteredJoin() {
        this.assertQuery("SELECT custkey, linestatus, tax, totalprice, orderstatus FROM lineitem JOIN (SELECT *  FROM orders WHERE orderkey % 2 = 0) a ON lineitem.orderkey = a.orderkey");
    }

    @Test
    public void testJoinWithFullyPushedDownJoinClause() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON orders.custkey = 1 AND lineitem.orderkey = 1");
    }

    @Test
    public void testJoinPredicateMoveAround() {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM lineitem WHERE orderkey % 16 = 0 AND partkey % 2 = 0) lineitem\nJOIN (SELECT * FROM orders WHERE orderkey % 16 = 0 AND custkey % 2 = 0) orders\nON lineitem.orderkey % 8 = orders.orderkey % 8 AND lineitem.linenumber % 2 = 0\nWHERE orders.custkey % 8 < 7 AND orders.custkey % 8 = lineitem.orderkey % 8 AND lineitem.suppkey % 7 > orders.custkey % 7");
    }

    @Test
    public void testSimpleFullJoin() {
        this.assertQuery("SELECT a, b FROM (VALUES (1), (2)) t (a) FULL OUTER JOIN (VALUES (1), (3)) u (b) ON a = b", "SELECT * FROM (VALUES (1, 1), (2, NULL), (NULL, 3))");
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL JOIN orders ON lineitem.orderkey = orders.orderkey", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey UNION ALL SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey WHERE lineitem.orderkey IS NULL)");
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL OUTER JOIN orders ON lineitem.orderkey = orders.orderkey", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey UNION ALL SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey WHERE lineitem.orderkey IS NULL)");
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL JOIN orders ON lineitem.orderkey = orders.custkey", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.custkey UNION ALL SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.custkey WHERE lineitem.orderkey IS NULL)");
    }

    @Test
    public void testFullJoinNormalizedToLeft() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL JOIN orders ON lineitem.orderkey = orders.orderkey WHERE lineitem.orderkey IS NOT NULL", "SELECT COUNT(*) FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey WHERE lineitem.orderkey IS NOT NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL JOIN orders ON lineitem.orderkey = orders.custkey WHERE lineitem.orderkey IS NOT NULL", "SELECT COUNT(*) FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.custkey WHERE lineitem.orderkey IS NOT NULL");
    }

    @Test
    public void testFullJoinNormalizedToRight() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL JOIN orders ON lineitem.orderkey = orders.orderkey WHERE orders.orderkey IS NOT NULL", "SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey  WHERE orders.orderkey IS NOT NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL JOIN orders ON lineitem.orderkey = orders.custkey WHERE orders.custkey IS NOT NULL", "SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.custkey  WHERE orders.custkey IS NOT NULL");
    }

    @Test
    public void testFullJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem FULL JOIN orders ON lineitem.orderkey = 1024", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey, orders.orderkey AS o2 FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = 1024 UNION ALL SELECT lineitem.orderkey, orders.orderkey AS o2 FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = 1024 WHERE lineitem.orderkey IS NULL)");
    }

    @Test
    public void testFullJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem FULL JOIN orders ON orders.orderkey = 1024", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey, orders.orderkey AS o2 FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem LEFT OUTER JOIN orders ON orders.orderkey = 1024 UNION ALL SELECT lineitem.orderkey, orders.orderkey AS o2 FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem RIGHT OUTER JOIN orders ON orders.orderkey = 1024 WHERE lineitem.orderkey IS NULL)");
    }

    @Test
    public void testSimpleFullJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = 2", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = 2 UNION ALL SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = 2 WHERE lineitem.orderkey IS NULL)");
    }

    @Test
    public void testSimpleFullJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = 2", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = 2 UNION ALL SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = 2 WHERE lineitem.orderkey IS NULL)");
    }

    @Test
    public void testOuterJoinWithNullsOnProbe() {
        this.assertQuery("SELECT DISTINCT a.orderkey FROM (SELECT CASE WHEN orderkey > 10 THEN orderkey END orderkey FROM orders WHERE orderkey < 100) a RIGHT OUTER JOIN (SELECT * FROM orders WHERE orderkey < 100) b ON a.orderkey = b.orderkey");
        this.assertQuery("SELECT DISTINCT a.orderkey FROM (SELECT CASE WHEN orderkey > 2 THEN orderkey END orderkey FROM orders WHERE orderkey < 100) a FULL OUTER JOIN (SELECT * FROM orders WHERE orderkey < 100) b ON a.orderkey = b.orderkey", "SELECT DISTINCT orderkey FROM (SELECT a.orderkey FROM (SELECT CASE WHEN orderkey > 2 THEN orderkey END orderkey FROM orders WHERE orderkey < 100) a RIGHT OUTER JOIN (SELECT * FROM orders WHERE orderkey < 100) b ON a.orderkey = b.orderkey UNION ALL SELECT a.orderkey FROM(SELECT CASE WHEN orderkey > 2 THEN orderkey END orderkey FROM orders WHERE orderkey < 100) a LEFT OUTER JOIN (SELECT * FROM orders WHERE orderkey < 100) b ON a.orderkey = b.orderkey WHERE a.orderkey IS NULL)");
    }

    @Test
    public void testOuterJoinWithCommonExpression() {
        MaterializedResult actual = this.computeActual("SELECT count(1), count(one) FROM (values (1, 'a'), (2, 'a')) AS l(k, a) LEFT JOIN (SELECT k, 1 one FROM (values 1) AS r(k)) r ON l.k = r.k GROUP BY a");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{2L, 1L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testSimpleLeftJoin() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT JOIN orders ON lineitem.orderkey = orders.orderkey");
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey");
        this.assertQuery("SELECT x.val FROM (SELECT CAST(ROW(v) AS ROW(val integer)) FROM (VALUES 1, 2, 3) t(v)) ta (x) LEFT OUTER JOIN (SELECT CAST(ROW(v) AS ROW(val integer)) FROM (VALUES 1, 2, 3) t(v)) tb (y) ON x.val=y.val WHERE y.val=1", "SELECT 1");
    }

    @Test
    public void testLeftJoinNormalizedToInner() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT JOIN orders ON lineitem.orderkey = orders.orderkey WHERE orders.orderkey IS NOT NULL");
    }

    @Test
    public void testLeftJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem LEFT JOIN orders ON lineitem.orderkey = 1024");
    }

    @Test
    public void testLeftJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem LEFT JOIN orders ON orders.orderkey = 1024");
    }

    @Test
    public void testSimpleLeftJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = 2");
    }

    @Test
    public void testSimpleLeftJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = 2");
    }

    @Test
    public void testDoubleFilteredLeftJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem LEFT JOIN (SELECT * FROM orders WHERE orderkey % 1024 = 0) orders ON orders.orderkey = 1024");
    }

    @Test
    public void testDoubleFilteredLeftJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem LEFT JOIN (SELECT * FROM orders WHERE orderkey % 1024 = 0) orders ON lineitem.orderkey = 1024");
    }

    @Test
    public void testLeftJoinDoubleClauseWithLeftOverlap() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = orders.custkey");
    }

    @Test
    public void testLeftJoinDoubleClauseWithRightOverlap() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = lineitem.partkey");
    }

    @Test
    public void testBuildFilteredLeftJoin() {
        this.assertQuery(this.noJoinReordering(), "SELECT * FROM lineitem LEFT JOIN (SELECT * FROM orders WHERE orderkey % 2 = 0) a ON lineitem.orderkey = a.orderkey");
    }

    @Test
    public void testProbeFilteredLeftJoin() {
        this.assertQuery(this.noJoinReordering(), "SELECT * FROM (SELECT * FROM lineitem WHERE orderkey % 2 = 0) a LEFT JOIN orders ON a.orderkey = orders.orderkey");
    }

    @Test
    public void testLeftJoinPredicateMoveAround() {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM lineitem WHERE orderkey % 16 = 0 AND partkey % 2 = 0) lineitem\nLEFT JOIN (SELECT * FROM orders WHERE orderkey % 16 = 0 AND custkey % 2 = 0) orders\nON lineitem.orderkey % 8 = orders.orderkey % 8\nWHERE (orders.custkey % 8 < 7 OR orders.custkey % 8 IS NULL) AND orders.custkey % 8 = lineitem.orderkey % 8");
    }

    @Test
    public void testLeftJoinEqualityInference() {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM lineitem WHERE orderkey % 4 = 0 AND suppkey % 2 = partkey % 2 AND linenumber % 3 = orderkey % 3) lineitem\nLEFT JOIN (SELECT * FROM orders WHERE orderkey % 4 = 0) orders\nON lineitem.linenumber % 3 = orders.orderkey % 4 AND lineitem.orderkey % 3 = orders.custkey % 3\nWHERE lineitem.suppkey % 2 = lineitem.linenumber % 3");
    }

    @Test
    public void testLeftJoinWithNullValues() {
        this.assertQuery("SELECT *\nFROM (\n  SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM lineitem\n  WHERE partkey % 512 = 0\n) AS lineitem \nLEFT JOIN (\n  SELECT CASE WHEN orderkey % 2 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM orders\n  WHERE custkey % 512 = 0\n) AS orders\nON lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testSimpleRightJoin() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.orderkey");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.custkey");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.custkey");
    }

    @Test
    public void testRightJoinNormalizedToInner() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.orderkey WHERE lineitem.orderkey IS NOT NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.custkey WHERE lineitem.orderkey IS NOT NULL");
    }

    @Test
    public void testRightJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem RIGHT JOIN orders ON lineitem.orderkey = 1024");
    }

    @Test
    public void testRightJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem RIGHT JOIN orders ON orders.orderkey = 1024");
    }

    @Test
    public void testDoubleFilteredRightJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem RIGHT JOIN (SELECT * FROM orders WHERE orderkey % 1024 = 0) orders ON orders.orderkey = 1024");
    }

    @Test
    public void testDoubleFilteredRightJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem RIGHT JOIN (SELECT * FROM orders WHERE orderkey % 1024 = 0) orders ON lineitem.orderkey = 1024");
    }

    @Test
    public void testSimpleRightJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = 2");
    }

    @Test
    public void testSimpleRightJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = 2");
    }

    @Test
    public void testRightJoinDoubleClauseWithLeftOverlap() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = orders.custkey");
    }

    @Test
    public void testRightJoinDoubleClauseWithRightOverlap() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = lineitem.partkey");
    }

    @Test
    public void testBuildFilteredRightJoin() {
        this.assertQuery(this.noJoinReordering(), "SELECT custkey, linestatus, tax, totalprice, orderstatus FROM (SELECT * FROM lineitem WHERE orderkey % 2 = 0) a RIGHT JOIN orders ON a.orderkey = orders.orderkey");
    }

    @Test
    public void testProbeFilteredRightJoin() {
        this.assertQuery(this.noJoinReordering(), "SELECT custkey, linestatus, tax, totalprice, orderstatus FROM lineitem RIGHT JOIN (SELECT *  FROM orders WHERE orderkey % 2 = 0) a ON lineitem.orderkey = a.orderkey");
    }

    @Test
    public void testRightJoinPredicateMoveAround() {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM orders WHERE orderkey % 16 = 0 AND custkey % 2 = 0) orders\nRIGHT JOIN (SELECT * FROM lineitem WHERE orderkey % 16 = 0 AND partkey % 2 = 0) lineitem\nON lineitem.orderkey % 8 = orders.orderkey % 8\nWHERE (orders.custkey % 8 < 7 OR orders.custkey % 8 IS NULL) AND orders.custkey % 8 = lineitem.orderkey % 8");
    }

    @Test
    public void testRightJoinEqualityInference() {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM orders WHERE orderkey % 4 = 0) orders\nRIGHT JOIN (SELECT * FROM lineitem WHERE orderkey % 4 = 0 AND suppkey % 2 = partkey % 2 AND linenumber % 3 = orderkey % 3) lineitem\nON lineitem.linenumber % 3 = orders.orderkey % 4 AND lineitem.orderkey % 3 = orders.custkey % 3\nWHERE lineitem.suppkey % 2 = lineitem.linenumber % 3");
    }

    @Test
    public void testRightJoinWithNullValues() {
        this.assertQuery("SELECT lineitem.orderkey, orders.orderkey\nFROM (\n  SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM lineitem\n  WHERE partkey % 512 = 0\n) AS lineitem \nRIGHT JOIN (\n  SELECT CASE WHEN orderkey % 2 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM orders\n  WHERE custkey % 512 = 0\n) AS orders\nON lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testJoinWithStatefulFilterFunction() {
        this.assertQuery("SELECT *\nFROM (VALUES 1, 2) a(id)\nFULL JOIN (VALUES 2, 3) b(id)\nON (array_intersect(array[a.id], array[b.id]) = array[a.id])", "VALUES (1, null), (2, 2), (null, 3)");
    }

    @Test
    public void testJoinWithGroupByAsProbe() {
        this.assertQuery("SELECT   b.orderkey,   b.custkey,   a.custkey FROM (   SELECT custkey  FROM orders   GROUP BY custkey) a JOIN orders b   ON a.custkey = b.custkey ");
    }

    @Test
    public void testJoinEffectivePredicateWithNoRanges() {
        this.assertQuery("SELECT * FROM orders a    JOIN (SELECT * FROM orders WHERE orderkey IS NULL) b    ON a.orderkey = b.orderkey");
    }

    @Test
    public void testRowNumberJoin() {
        MaterializedResult actual = this.computeActual("SELECT a, rn\nFROM (\n    SELECT a, row_number() OVER (ORDER BY a) rn\n    FROM (VALUES (1), (2)) t (a)\n) a\nJOIN (VALUES (2)) b (b) ON a.a = b.b\nLIMIT 1");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{2, 2L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
        actual = this.computeActual("SELECT a, rn\nFROM (\n    SELECT a, row_number() OVER (PARTITION BY a ORDER BY a) rn\n    FROM (VALUES (1), (2), (1), (2)) t (a)\n) a\nJOIN (VALUES (2)) b (b) ON a.a = b.b\nLIMIT 2");
        expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{2, 1L}).row(new Object[]{2, 2L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testJoinUnaliasedSubqueries() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem) JOIN (SELECT * FROM orders) USING (orderkey)", "SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testWithSelfJoin() {
        this.assertQuery("WITH x AS (SELECT DISTINCT orderkey FROM orders ORDER BY orderkey LIMIT 10)\nSELECT count(*) FROM x a JOIN x b USING (orderkey)", "SELECT count(*)\nFROM (SELECT DISTINCT orderkey FROM orders ORDER BY orderkey LIMIT 10) a\nJOIN (SELECT DISTINCT orderkey FROM orders ORDER BY orderkey LIMIT 10) b ON a.orderkey = b.orderkey");
    }

    @Test
    public void testInSubqueryWithCrossJoin() {
        this.assertQuery("SELECT a FROM (VALUES (1),(2)) t(a) WHERE a IN (SELECT b FROM (VALUES (ARRAY[2])) AS t1 (a) CROSS JOIN UNNEST(a) AS t2(b))", "SELECT 2");
    }

    @Test
    public void testJoinProjectionPushDown() {
        this.assertQuery("SELECT *\nFROM\n  (SELECT orderkey, abs(orderkey) a FROM orders) t\nJOIN\n  (SELECT orderkey, abs(orderkey) a FROM orders) u\nON\n  t.orderkey = u.orderkey");
    }

    @Test
    public void testUnionWithJoin() {
        this.assertQuery("SELECT * FROM (   SELECT orderdate ds, orderkey FROM orders    UNION ALL    SELECT shipdate ds, orderkey FROM lineitem) a JOIN orders o ON (a.orderkey = o.orderkey)");
    }

    @Test
    public void testUnionWithAggregationAndJoin() {
        this.assertQuery("SELECT * FROM ( SELECT orderkey, count(*) FROM (   SELECT orderdate ds, orderkey FROM orders    UNION ALL    SELECT shipdate ds, orderkey FROM lineitem) a GROUP BY orderkey) t JOIN orders o ON (o.orderkey = t.orderkey)");
    }

    @Test
    public void testUnionWithJoinOnNonTranslatableSymbols() {
        this.assertQuery("SELECT *\nFROM (SELECT orderdate ds, orderkey\n      FROM orders\n      UNION ALL\n      SELECT shipdate ds, orderkey\n      FROM lineitem) a\nJOIN orders o\nON (substr(cast(a.ds AS VARCHAR), 6, 2) = substr(cast(o.orderdate AS VARCHAR), 6, 2) AND a.orderkey = o.orderkey)");
    }

    @Test
    public void testRandCrossJoins() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM orders ORDER BY rand() LIMIT 5) a CROSS JOIN (SELECT * FROM lineitem ORDER BY rand() LIMIT 5) b");
    }

    @Test
    public void testCrossJoins() {
        this.assertQuery("SELECT a.custkey, b.orderkey FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 5) a CROSS JOIN (SELECT * FROM lineitem ORDER BY orderkey LIMIT 5) b");
    }

    @Test
    public void testCrossJoinEmptyProbePage() {
        this.assertQuery("SELECT a.custkey, b.orderkey FROM (SELECT * FROM orders WHERE orderkey < 0) a CROSS JOIN (SELECT * FROM lineitem WHERE orderkey < 100) b");
    }

    @Test
    public void testCrossJoinEmptyBuildPage() {
        this.assertQuery("SELECT a.custkey, b.orderkey FROM (SELECT * FROM orders WHERE orderkey < 100) a CROSS JOIN (SELECT * FROM lineitem WHERE orderkey < 0) b");
    }

    @Test
    public void testSimpleCrossJoins() {
        this.assertQuery("SELECT * FROM (SELECT 1 a) x CROSS JOIN (SELECT 2 b) y");
    }

    @Test
    public void testCrossJoinsWithWhereClause() {
        this.assertQuery("SELECT a, b, c, d FROM (VALUES (1, 'a'), (2, 'b'), (3, 'c'), (4, 'd')) t1 (a, b) CROSS JOIN (VALUES (1, 1.1), (3, 3.3), (5, 5.5)) t2 (c, d) WHERE t1.a > t2.c", "SELECT * FROM (VALUES  (2, 'b', 1, 1.1), (3, 'c', 1, 1.1), (4, 'd', 1, 1.1), (4, 'd', 3, 3.3))");
    }

    @Test
    public void testCrossJoinsDifferentDataTypes() {
        this.assertQuery("SELECT * FROM (SELECT 'AAA' a1, 11 b1, 33.3 c1, true AS d1, 21 e1) x CROSS JOIN (SELECT 4444.4 a2, false AS b2, 'BBB' c2, 22 d2) y");
    }

    @Test
    public void testCrossJoinWithNulls() {
        this.assertQuery("SELECT a, b FROM (VALUES (1), (2)) t (a) CROSS JOIN (VALUES (1), (3)) u (b)", "SELECT * FROM (VALUES  (1, 1), (1, 3), (2, 1), (2, 3))");
        this.assertQuery("SELECT a, b FROM (VALUES (1), (2), (null)) t (a), (VALUES (11), (null), (13)) u (b)", "SELECT * FROM (VALUES (1, 11), (1, null), (1, 13), (2, 11), (2, null), (2, 13), (null, 11), (null, null), (null, 13))");
        this.assertQuery("SELECT a, b FROM (VALUES ('AA'), ('BB'), (null)) t (a), (VALUES ('111'), (null), ('333')) u (b)", "SELECT * FROM (VALUES ('AA', '111'), ('AA', null), ('AA', '333'), ('BB', '111'), ('BB', null), ('BB', '333'), (null, '111'), (null, null), (null, '333'))");
    }

    @Test
    public void testImplicitCrossJoin() {
        this.assertQuery("SELECT * FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 3) a, (SELECT * FROM orders ORDER BY orderkey LIMIT 4) b");
        this.assertQuery("SELECT * FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 5) a, (SELECT * FROM orders ORDER BY orderkey LIMIT 2) b");
        this.assertQuery("SELECT * FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 5) a, (SELECT * FROM orders ORDER BY orderkey LIMIT 5) b, (SELECT * FROM orders ORDER BY orderkey LIMIT 5) c ");
        this.assertQuery("SELECT l.orderkey, l.linenumber FROM orders o INNER JOIN lineitem l ON o.custkey = l.linenumber WHERE o.custkey IN (5) AND l.orderkey IN (7522)");
        this.assertQuery("SELECT o.custkey FROM orders o INNER JOIN lineitem l ON o.custkey = l.linenumber WHERE o.custkey IN (5) AND l.orderkey IN (7522)");
        this.assertQuery("SELECT COUNT(*) FROM orders o INNER JOIN lineitem l ON o.custkey = l.linenumber WHERE o.custkey IN (5) AND l.orderkey IN (7522)");
    }

    @Test
    public void testCrossJoinUnion() {
        this.assertQuery("SELECT t.c FROM (SELECT 1) CROSS JOIN (SELECT 0 AS c UNION ALL SELECT 1) t");
        this.assertQuery("SELECT a, b FROM (VALUES (1, 1)) CROSS JOIN (SELECT 0 AS a, 0 AS b UNION ALL SELECT 1, 1) t");
    }

    @Test
    public void testCrossJoinUnnestWithUnion() {
        this.assertQuery("SELECT col, COUNT(*)\nFROM ((\n    SELECT ARRAY[1, 2] AS a\n    UNION ALL\n    SELECT ARRAY[1, 3] AS a)  unionresult\n  CROSS JOIN UNNEST(unionresult.a) t(col))\nGROUP BY col", "SELECT * FROM VALUES (1, 2), (2, 1), (3, 1)");
    }

    @Test
    public void testJoinOnConstantExpression() {
        this.assertQuery("SELECT * FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 5) a    JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 5) b    ON 123 = 123");
    }

    @Test
    public void testSemiJoin() {
        this.assertQuery("SELECT linenumber, min(orderkey) FROM lineitem GROUP BY linenumber HAVING min(orderkey) IN (SELECT orderkey FROM orders WHERE orderkey > 1)");
        this.assertQuery("SELECT 10 in (SELECT orderkey FROM orders)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (2,2), (3, 3)) t(x, y) WHERE (x+y in (VALUES 4, 5)) AND (x*y in (VALUES 4, 5))", "VALUES (2,2)");
        this.assertQuery("SELECT 1.0 IN (SELECT 1), 1 IN (SELECT 1)");
        this.assertQuery("SELECT 1 WHERE 1 IN (SELECT 1) AND 1.0 IN (SELECT 1)");
        this.assertQuery("SELECT 1.0 in (values (1), (2), (3))", "SELECT true");
        this.assertQuery("SELECT CAST(1 AS decimal(3,2)) IN (SELECT CAST(1 AS decimal(3,1)))", "SELECT true");
        this.assertQuery("SELECT CAST(1 AS decimal(3,2)) IN (values (cast(1 AS decimal(3,1))), (cast (2 AS decimal(3,1))))", "SELECT true");
        this.assertQuery("SELECT 1 IN (SELECT 1), 2 IN (SELECT 1) WHERE 1 IN (SELECT 1)");
        this.assertQuery("SELECT (SELECT 1) IN (SELECT 1)");
        this.assertQuery("SELECT (SELECT 2) IN (1, (SELECT 2))");
        this.assertQuery("SELECT (2 + (SELECT 1)) IN (SELECT 1)");
        this.assertQuery("SELECT (1 IN (SELECT 1)) IN (SELECT TRUE)");
        this.assertQuery("SELECT ((SELECT 1) IN (SELECT 1)) IN (SELECT TRUE)");
        this.assertQuery("SELECT (EXISTS(SELECT 1)) IN (SELECT TRUE)");
        this.assertQuery("SELECT (1 = ANY(SELECT 1)) IN (SELECT TRUE)");
        this.assertQuery("SELECT *, o2.custkey\n  IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE orderkey % 5 = 0)\nFROM (SELECT * FROM orders WHERE custkey % 256 = 0) o1\nJOIN (SELECT * FROM orders WHERE custkey % 256 = 0) o2\n  ON (o1.orderkey IN (SELECT orderkey FROM lineitem WHERE orderkey % 4 = 0)) = (o2.orderkey IN (SELECT orderkey FROM lineitem WHERE orderkey % 4 = 0))\nWHERE o1.orderkey\n  IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE orderkey % 4 = 0)\nORDER BY o1.orderkey\n  IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE orderkey % 7 = 0)");
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE partkey % 4 = 0),\n  SUM(\n    CASE\n      WHEN orderkey\n        IN (\n          SELECT orderkey\n          FROM lineitem\n          WHERE suppkey % 4 = 0)\n      THEN 1\n      ELSE 0\n      END)\nFROM orders\nGROUP BY orderkey\n  IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE partkey % 4 = 0)\nHAVING SUM(\n  CASE\n    WHEN orderkey\n      IN (\n        SELECT orderkey\n        FROM lineitem\n        WHERE suppkey % 4 = 0)\n      THEN 1\n      ELSE 0\n      END) > 1");
    }

    @Test
    public void testJoinConstantPropagation() {
        this.assertQuery("SELECT x, y, COUNT(*)\nFROM (SELECT orderkey, 0 AS x FROM orders) a \nJOIN (SELECT orderkey, 1 AS y FROM orders) b \nON a.orderkey = b.orderkey\nGROUP BY 1, 2");
    }

    @Test
    public void testAntiJoin() {
        this.assertQuery("SELECT *, orderkey\n  NOT IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE orderkey % 3 = 0)\nFROM orders");
    }

    @Test
    public void testAntiJoinNullHandling() {
        this.assertQuery("WITH empty AS (SELECT 1 WHERE FALSE) SELECT 3 FROM (VALUES 1) WHERE NULL NOT IN (SELECT * FROM empty)", "VALUES 3");
        this.assertQuery("WITH empty AS (SELECT 1 WHERE FALSE) SELECT x FROM (VALUES NULL) t(x) WHERE x NOT IN (SELECT * FROM empty)", "VALUES NULL");
    }

    @Test
    public void testSemiJoinLimitPushDown() {
        this.assertQuery("SELECT COUNT(*)\nFROM (\n  SELECT orderkey\n  IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE orderkey % 2 = 0)\n  FROM orders\n  LIMIT 10)");
    }

    @Test
    public void testSemiJoinNullHandling() {
        this.assertQuery("WITH empty AS (SELECT 1 WHERE FALSE) SELECT 3 FROM (VALUES 1) WHERE NULL IN (SELECT * FROM empty)", "SELECT 0 WHERE FALSE");
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END\n    FROM lineitem)\nFROM orders");
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT orderkey\n    FROM lineitem)\nFROM (\n  SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM orders)");
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END\n    FROM lineitem)\nFROM (\n  SELECT CASE WHEN orderkey % 4 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM orders)");
    }

    @Test
    public void testSemiJoinWithGroupBy() {
        this.assertQuery("SELECT linenumber, min(orderkey), 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber");
        this.assertQuery("SELECT linenumber, min(orderkey), 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey) FROM lineitem GROUP BY linenumber, 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey) FROM lineitem GROUP BY linenumber HAVING 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey), 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)HAVING 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey), 6 IN (SELECT max(orderkey) FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, 6 IN (SELECT sum(orderkey) FROM orders WHERE orderkey < 5)");
        this.assertQuery("SELECT linenumber, min(orderkey) FROM lineitem GROUP BY linenumber, 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)HAVING 6 IN (SELECT orderkey FROM orders WHERE orderkey > 3)");
        this.assertQuery("SELECT linenumber, min(orderkey), 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, 6 IN (SELECT orderkey FROM orders WHERE orderkey < 5)HAVING 6 IN (SELECT orderkey FROM orders WHERE orderkey > 3)");
    }

    @Test
    public void testSemiJoinUnionNullHandling() {
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT CASE WHEN orderkey % 500 = 0 THEN NULL ELSE orderkey END\n    FROM orders\n    WHERE orderkey % 200 = 0\n    UNION ALL\n    SELECT CASE WHEN orderkey % 600 = 0 THEN NULL ELSE orderkey END\n    FROM orders\n    WHERE orderkey % 300 = 0\n  )\nFROM (\n  SELECT orderkey\n  FROM lineitem\n  WHERE orderkey % 100 = 0)");
    }

    @Test
    public void testSemiJoinAggregationNullHandling() {
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT CASE WHEN orderkey % 10 = 0 THEN NULL ELSE orderkey END\n    FROM lineitem\n    WHERE orderkey % 2 = 0\n    GROUP BY orderkey\n  )\nFROM (\n  SELECT orderkey\n  FROM orders\n  WHERE orderkey % 3 = 0)");
    }

    @Test
    public void testSemiJoinUnionAggregationNullHandling() {
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT CASE WHEN orderkey % 500 = 0 THEN NULL ELSE orderkey END\n    FROM lineitem\n    WHERE orderkey % 250 = 0\n    UNION ALL\n    SELECT CASE WHEN orderkey % 300 = 0 THEN NULL ELSE orderkey END\n    FROM lineitem\n    WHERE orderkey % 200 = 0\n    GROUP BY orderkey\n  )\nFROM (\n  SELECT orderkey\n  FROM orders\n  WHERE orderkey % 100 = 0)\n");
    }

    @Test
    public void testSemiJoinAggregationUnionNullHandling() {
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT orderkey\n    FROM (\n      SELECT CASE WHEN orderkey % 500 = 0 THEN NULL ELSE orderkey END AS orderkey\n      FROM orders\n      WHERE orderkey % 200 = 0\n      UNION ALL\n      SELECT CASE WHEN orderkey % 600 = 0 THEN NULL ELSE orderkey END AS orderkey\n      FROM orders\n      WHERE orderkey % 300 = 0\n    )\n    GROUP BY orderkey\n  )\nFROM (\n  SELECT orderkey\n  FROM lineitem\n  WHERE orderkey % 100 = 0)");
    }

    @Test
    public void testJoinPredicatePushdown() {
        this.assertQuery("SELECT COUNT(*)\nFROM lineitem \nJOIN (\n  SELECT * FROM orders\n) orders \nON lineitem.orderkey = orders.orderkey \nWHERE orders.orderkey % 4 = 0\n  AND lineitem.suppkey > orders.orderkey");
    }

    @Test
    public void testLeftJoinAsInnerPredicatePushdown() {
        this.assertQuery("SELECT COUNT(*)\nFROM lineitem \nLEFT JOIN (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders \nON lineitem.orderkey = orders.orderkey \nWHERE orders.orderkey % 4 = 0\n  AND (lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.custkey IS NULL)");
    }

    @Test
    public void testPlainLeftJoinPredicatePushdown() {
        this.assertQuery("SELECT COUNT(*)\nFROM lineitem \nLEFT JOIN (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders \nON lineitem.orderkey = orders.orderkey \nWHERE lineitem.orderkey % 4 = 0\n  AND (lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.orderkey IS NULL)");
    }

    @Test
    public void testLeftJoinPredicatePushdownWithSelfEquality() {
        this.assertQuery("SELECT COUNT(*)\nFROM lineitem \nLEFT JOIN (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders \nON lineitem.orderkey = orders.orderkey \nWHERE orders.orderkey = orders.orderkey\n  AND lineitem.orderkey % 4 = 0\n  AND (lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.orderkey IS NULL)");
    }

    @Test
    public void testLeftJoinPredicatePushdownWithNullConstant() {
        this.assertQuery("SELECT count(*)\nFROM orders a\nLEFT OUTER JOIN orders b\n  ON a.clerk = b.clerk\nWHERE a.orderpriority='5-LOW'\n  AND b.orderpriority='1-URGENT'\n  AND b.clerk is null\n  AND a.orderkey % 4 = 0\n");
    }

    @Test
    public void testRightJoinAsInnerPredicatePushdown() {
        this.assertQuery("SELECT COUNT(*)\nFROM (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders\nRIGHT JOIN lineitem\nON lineitem.orderkey = orders.orderkey \nWHERE orders.orderkey % 4 = 0\n  AND (lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.custkey IS NULL)");
    }

    @Test
    public void testPlainRightJoinPredicatePushdown() {
        this.assertQuery("SELECT COUNT(*)\nFROM (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders \nRIGHT JOIN lineitem\nON lineitem.orderkey = orders.orderkey \nWHERE lineitem.orderkey % 4 = 0\n  AND (lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.orderkey IS NULL)");
    }

    @Test
    public void testRightJoinPredicatePushdownWithSelfEquality() {
        this.assertQuery("SELECT COUNT(*)\nFROM (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders \nRIGHT JOIN lineitem\nON lineitem.orderkey = orders.orderkey \nWHERE orders.orderkey = orders.orderkey\n  AND lineitem.orderkey % 4 = 0\n  AND (lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.orderkey IS NULL)");
    }

    @Test
    public void testPredicatePushdownJoinEqualityGroups() {
        this.assertQuery("SELECT *\nFROM (\n  SELECT custkey custkey1, custkey%4 custkey1a, custkey%8 custkey1b, custkey%16 custkey1c\n  FROM orders\n) orders1 \nJOIN (\n  SELECT custkey custkey2, custkey%4 custkey2a, custkey%8 custkey2b\n  FROM orders\n) orders2 ON orders1.custkey1 = orders2.custkey2\nWHERE custkey2a = custkey2b\n  AND custkey1 = custkey1a\n  AND custkey2 = custkey2a\n  AND custkey1a = custkey1c\n  AND custkey1b = custkey1c\n  AND custkey1b % 2 = 0");
    }

    @Test
    public void testNonDeterministicJoinPredicatePushdown() {
        MaterializedResult materializedResult = this.computeActual("SELECT COUNT(*)\nFROM (\n  SELECT DISTINCT *\n  FROM (\n    SELECT 'abc' AS col1a, 500 AS col1b FROM lineitem LIMIT 1\n  ) table1\n  JOIN (\n    SELECT 'abc' AS col2a FROM lineitem LIMIT 1000000\n  ) table2\n  ON table1.col1a = table2.col2a\n  WHERE rand() * 1000 > table1.col1b\n)");
        MaterializedRow row = (MaterializedRow)Iterables.getOnlyElement((Iterable)materializedResult.getMaterializedRows());
        Assert.assertEquals((int)row.getFieldCount(), (int)1);
        long count = (Long)row.getField(0);
        org.testng.Assert.assertTrue((count > 0L && count < 1000000L ? 1 : 0) != 0);
    }

    @Test
    public void testSemiJoinPredicateMoveAround() {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM orders WHERE custkey % 2 = 0 AND orderkey % 3 = 0)\nWHERE orderkey\n  IN (\n    SELECT CASE WHEN orderkey % 7 = 0 THEN NULL ELSE orderkey END\n    FROM lineitem\n    WHERE partkey % 2 = 0)\n  AND\n    orderkey % 2 = 0");
    }

    @Test
    public void testExecuteUsingComplexJoinCriteria() {
        String query = "SELECT * FROM (VALUES 1) t(a) JOIN (VALUES 2) u(a) ON t.a + u.a < ?";
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", query).build();
        this.assertQuery(session, "EXECUTE my_query USING 5", "VALUES (1, 2)");
    }

    @Test
    public void testExecuteUsingWithSubqueryInJoin() {
        String query = "SELECT * FROM     (VALUES ?,2,3) t(x)   JOIN     (VALUES 1,2,3) t2(y)   ON (x in (VALUES 1,2,?)) = (y in (VALUES 1,2,3)) AND (x in (VALUES 1,?)) = (y in (VALUES 1,2))";
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", query).build();
        this.assertQuery(session, "EXECUTE my_query USING 1, 3, 2", "VALUES (1,1), (1,2), (2,2), (2,1), (3,3)");
    }

    @Test
    public void testLateralJoin() {
        this.assertQuery("SELECT name FROM nation, LATERAL (SELECT 1 WHERE false)", "SELECT 1 WHERE false");
        this.assertQuery("SELECT name FROM nation, LATERAL (SELECT 1)", "SELECT name FROM nation");
        this.assertQuery("SELECT name FROM nation, LATERAL (SELECT 1 WHERE name = 'ola')", "SELECT 1 WHERE false");
        this.assertQuery("SELECT nationkey, a FROM nation, LATERAL (SELECT max(region.name) FROM region WHERE region.regionkey <= nation.regionkey) t(a) ORDER BY nationkey LIMIT 1", "VALUES (0, 'AFRICA')");
        this.assertQuery("SELECT nationkey, a FROM nation, LATERAL (SELECT region.name || '_' FROM region WHERE region.regionkey = nation.regionkey) t(a) ORDER BY nationkey LIMIT 1", "VALUES (0, 'AFRICA_')");
        this.assertQuery("SELECT nationkey, a, b, name FROM nation, LATERAL (SELECT nationkey + 2 AS a), LATERAL (SELECT a * -1 AS b) ORDER BY b LIMIT 1", "VALUES (24, 26, -26, 'UNITED STATES')");
        this.assertQuery("SELECT * FROM region r, LATERAL (SELECT * FROM nation) n WHERE n.regionkey = r.regionkey", "SELECT * FROM region, nation WHERE nation.regionkey = region.regionkey");
        this.assertQuery("SELECT * FROM region, LATERAL (SELECT * FROM nation WHERE nation.regionkey = region.regionkey)", "SELECT * FROM region, nation WHERE nation.regionkey = region.regionkey");
        this.assertQuery("SELECT quantity, extendedprice, avg_price, low, high FROM lineitem, LATERAL (SELECT extendedprice / quantity AS avg_price) average_price, LATERAL (SELECT avg_price * 0.9 AS low) lower_bound, LATERAL (SELECT avg_price * 1.1 AS high) upper_bound ORDER BY extendedprice, quantity LIMIT 1", "VALUES (1.0, 904.0, 904.0, 813.6, 994.400)");
        this.assertQuery("SELECT y FROM (VALUES array[2, 3]) a(x) CROSS JOIN LATERAL(SELECT x[1]) b(y)", "SELECT 2");
        this.assertQuery("SELECT * FROM (VALUES 2) a(x) CROSS JOIN LATERAL(SELECT x + 1)", "SELECT 2, 3");
        this.assertQuery("SELECT * FROM (VALUES 2) a(x) CROSS JOIN LATERAL(SELECT x)", "SELECT 2, 2");
        this.assertQuery("SELECT * FROM (VALUES 2) a(x) CROSS JOIN LATERAL(SELECT x, x + 1)", "SELECT 2, 2, 3");
        this.assertQueryFails("SELECT * FROM (VALUES array[2, 2]) a(x) LEFT OUTER JOIN LATERAL(VALUES x) ON true", "line .*: LATERAL on other than the right side of CROSS JOIN is not supported");
        this.assertQueryFails("SELECT * FROM (VALUES array[2, 2]) a(x) RIGHT OUTER JOIN LATERAL(VALUES x) ON true", "line .*: LATERAL on other than the right side of CROSS JOIN is not supported");
        this.assertQueryFails("SELECT * FROM (VALUES array[2, 2]) a(x) FULL OUTER JOIN LATERAL(VALUES x) ON true", "line .*: LATERAL on other than the right side of CROSS JOIN is not supported");
    }

    @Test
    public void testJoinsWithNulls() {
        this.testJoinsWithNullsInternal(this.getSession());
        this.testJoinsWithNullsInternal(this.inferNullsFromJoinFiltersWithUseFunctionMetadata());
    }

    private void testJoinsWithNullsInternal(Session session) {
        this.assertQuery(session, "SELECT * FROM (VALUES 2, 3, null) a(x) INNER JOIN (VALUES 3, 4, null) b(x) ON a.x = b.x", "SELECT * FROM VALUES (3, 3)");
        this.assertQuery(session, "SELECT * FROM (VALUES 2, 3, null) a(x) LEFT JOIN (VALUES 3, 4, null) b(x) ON a.x = b.x", "SELECT * FROM VALUES (3, 3), (2, NULL), (NULL, NULL)");
        this.assertQuery(session, "SELECT * FROM (VALUES 2, 3, null) a(x) RIGHT JOIN (VALUES 3, 4, null) b(x) ON a.x = b.x", "SELECT * FROM VALUES (3, 3), (NULL, 4), (NULL, NULL)");
        this.assertQuery(session, "SELECT * FROM (VALUES 2, 3, null) a(x) FULL OUTER JOIN (VALUES 3, 4, null) b(x) ON a.x = b.x", "SELECT * FROM VALUES (3, 3), (NULL, 4), (2, NULL), (NULL, NULL), (NULL, NULL)");
        this.assertQuery(session, "SELECT * FROM (VALUES 2, 3, null) a(x) FULL OUTER JOIN (VALUES 3, 4, null) b(x) ON a.x = b.x WHERE a.x IS NULL", "SELECT * FROM VALUES (NULL, 4), (NULL, NULL), (NULL, NULL)");
        this.assertQuery(session, "SELECT * FROM (VALUES '1', '', '2', '3') a(x) INNER JOIN (VALUES 1, 2, 3) b(y) ON CAST(x AS int) = y WHERE x <> ''", "SELECT * FROM VALUES (1,1), (2,2), (3,3)");
        this.assertQuery(session, "select l.number from (VALUES 5) l(number) INNER JOIN (select sequence(1,number) as numArr from unnest(sequence(1,5)) AS x(number)) r ON l.number = r.numArr[5] WHERE CARDINALITY(r.numArr) = 5", "SELECT 5 as number");
        this.assertQuery(session, "select l.numArr[5] as result from (select repeat(number,cast(number as integer)) as numArr from unnest(sequence(1,5)) AS x(number)) l INNER JOIN (select repeat(number,cast(number as integer)) as numArr from unnest(sequence(5,10)) AS x(number)) r ON l.numArr[5] = r.numArr[5] WHERE CARDINALITY(l.numArr) >= 5 AND CARDINALITY(r.numArr) >= 5", "SELECT 5 as result");
        this.assertQuery(session, "SELECT 1 FROM ( VALUES ARRAY[ CAST(ROW(1) AS ROW(x INTEGER)), CAST(ROW(2) AS ROW(x INTEGER)) ], ARRAY[ CAST(ROW(4) AS ROW(x INTEGER)), CAST(ROW(5) AS ROW(x INTEGER)), CAST(ROW(6) AS ROW(x INTEGER)) ], ARRAY[], NULL ) l(f) INNER JOIN ( VALUES ARRAY[ CAST(ROW(1) AS ROW(x INTEGER)), CAST(ROW(5) AS ROW(x INTEGER)), CAST(ROW(3) AS ROW(x INTEGER)) ], ARRAY[CAST(ROW(7) AS ROW(x INTEGER))], ARRAY[], NULL ) r(f) ON l.f[2].x = r.f[2].x AND CARDINALITY(l.f) >= 2 AND CARDINALITY(r.f) >= 2", "select 1");
    }

    @Test
    public void testInnerJoinWithEmptyBuildSide() {
        MaterializedResult actual = this.computeActual(this.noJoinReordering(), "WITH small_part AS (SELECT * FROM part WHERE name = 'a') SELECT lineitem.orderkey FROM lineitem INNER JOIN small_part ON lineitem.partkey = small_part.partkey");
        Assert.assertEquals((int)actual.getRowCount(), (int)0);
        actual = this.computeActual(this.optimizeJoinForEmptyBuildRuntime(), "WITH small_part AS (SELECT * FROM part WHERE name = 'a') SELECT lineitem.orderkey FROM lineitem INNER JOIN small_part ON lineitem.partkey = small_part.partkey");
        Assert.assertEquals((int)actual.getRowCount(), (int)0);
    }

    @Test
    public void testRightJoinWithEmptyBuildSide() {
        this.assertQuery(this.noJoinReordering(), "WITH small_part AS (SELECT * FROM part WHERE name = 'a') SELECT lineitem.orderkey FROM lineitem RIGHT JOIN small_part ON lineitem.partkey = small_part.partkey");
        this.assertQuery(this.optimizeJoinForEmptyBuildRuntime(), "WITH small_part AS (SELECT * FROM part WHERE name = 'a') SELECT lineitem.orderkey FROM lineitem RIGHT JOIN small_part ON lineitem.partkey = small_part.partkey");
    }

    @Test
    public void testLeftJoinWithEmptyBuildSide() {
        this.assertQuery(this.noJoinReordering(), "WITH small_part AS (SELECT * FROM part WHERE name = 'a') SELECT lineitem.orderkey FROM lineitem LEFT JOIN small_part ON lineitem.partkey = small_part.partkey");
        this.assertQuery(this.optimizeJoinForEmptyBuildRuntime(), "WITH small_part AS (SELECT * FROM part WHERE name = 'a') SELECT lineitem.orderkey FROM lineitem LEFT JOIN small_part ON lineitem.partkey = small_part.partkey");
    }

    @Test
    public void testFullJoinWithEmptyBuildSide() {
        this.assertQuery(this.noJoinReordering(), "WITH small_part AS (SELECT * FROM part WHERE name = 'a') SELECT lineitem.orderkey FROM lineitem FULL OUTER JOIN small_part ON lineitem.partkey = small_part.partkey", "WITH small_part AS (SELECT * FROM part WHERE name = 'a') SELECT lineitem.orderkey FROM lineitem LEFT JOIN small_part ON lineitem.partkey = small_part.partkey");
        this.assertQuery(this.optimizeJoinForEmptyBuildRuntime(), "WITH small_part AS (SELECT * FROM part WHERE name = 'a') SELECT lineitem.orderkey FROM lineitem FULL OUTER JOIN small_part ON lineitem.partkey = small_part.partkey", "WITH small_part AS (SELECT * FROM part WHERE name = 'a') SELECT lineitem.orderkey FROM lineitem LEFT JOIN small_part ON lineitem.partkey = small_part.partkey");
    }

    @Test
    public void testInnerJoinWithEmptyProbeSide() {
        this.assertQuery(this.noJoinReordering(), "WITH small_part AS (SELECT * FROM part WHERE name = 'a') SELECT lineitem.orderkey FROM small_part INNER JOIN lineitem ON small_part.partkey = lineitem.partkey");
    }

    @Test
    public void testRightJoinWithEmptyProbeSide() {
        this.assertQuery(this.noJoinReordering(), "WITH small_part AS (SELECT * FROM part WHERE name = 'a') SELECT lineitem.orderkey FROM small_part RIGHT JOIN lineitem ON  small_part.partkey = lineitem.partkey");
    }

    @Test
    public void testJoinsWithNullInferencing() {
        Session joinsNullInferenceStrategy = this.inferNullsFromJoinFiltersWithUseFunctionMetadata();
        this.assertQuery(joinsNullInferenceStrategy, "select 1 from lineitem l, orders o where l.orderkey = o.orderkey");
        this.assertQuery(joinsNullInferenceStrategy, "select 1 from lineitem l join orders o on l.orderkey = o.orderkey and l.partkey = o.custkey");
        this.assertQuery(joinsNullInferenceStrategy, "select 1 from lineitem l join orders o on l.orderkey = o.orderkey, customer c where c.custkey = o.custkey");
        this.assertQuery(joinsNullInferenceStrategy, "select 1 from lineitem l left join orders o on l.orderkey = o.orderkey inner join customer c on o.custkey=c.custkey");
        this.assertQuery(joinsNullInferenceStrategy, "select 1 from lineitem l left join orders o on l.orderkey = o.orderkey and partkey - custkey > 10");
    }

    protected Session noJoinReordering() {
        return Session.builder((Session)this.getSession()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinReorderingStrategy.NONE.name()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).build();
    }

    protected Session optimizeJoinForEmptyBuildRuntime() {
        return Session.builder((Session)this.getSession()).setSystemProperty("optimize_join_probe_for_empty_build_runtime", "true").build();
    }

    private Session inferNullsFromJoinFiltersWithUseFunctionMetadata() {
        return Session.builder((Session)this.getSession()).setSystemProperty("joins_not_null_inference_strategy", "USE_FUNCTION_METADATA").build();
    }

    private long getTableRowCount(String tableName) {
        String countQuery = "SELECT COUNT(*) FROM " + tableName;
        MaterializedRow countRow = (MaterializedRow)Iterables.getOnlyElement((Iterable)this.getQueryRunner().execute(countQuery));
        int rowFieldCount = countRow.getFieldCount();
        Assert.assertEquals((int)rowFieldCount, (int)1);
        return (Long)countRow.getField(0);
    }
}

