/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.presto.functionNamespace.mysql.FunctionNamespaceDao;
import com.facebook.presto.functionNamespace.mysql.MySqlConnectionModule;
import com.facebook.presto.functionNamespace.mysql.MySqlFunctionNamespaceManagerConfig;
import com.facebook.presto.tests.H2ConnectionConfig;
import com.facebook.presto.tests.H2FunctionNamespaceDao;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.sql.DriverManager;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;

public class H2ConnectionModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        String databaseName = ((H2ConnectionConfig)this.buildConfigObject(H2ConnectionConfig.class)).getDatabaseName();
        Jdbi jdbi = MySqlConnectionModule.createJdbi(() -> DriverManager.getConnection(H2ConnectionModule.getJdbcUrl(databaseName)), (MySqlFunctionNamespaceManagerConfig)((MySqlFunctionNamespaceManagerConfig)this.buildConfigObject(MySqlFunctionNamespaceManagerConfig.class)));
        binder.bind(Jdbi.class).toInstance((Object)jdbi);
        binder.bind(HandleLifecycleManager.class).in(Scopes.SINGLETON);
        binder.bind(FunctionNamespaceDao.class).toProvider((Provider)new FunctionNamespaceDaoProvider()).in(Scopes.SINGLETON);
        binder.bind((TypeLiteral)new TypeLiteral<Class<? extends FunctionNamespaceDao>>(){}).toInstance(H2FunctionNamespaceDao.class);
    }

    public static String getJdbcUrl(String databaseName) {
        return String.format("jdbc:h2:mem:test%s;MODE=MySQL;DATABASE_TO_LOWER=TRUE", databaseName);
    }

    private static class FunctionNamespaceDaoProvider
    implements Provider<FunctionNamespaceDao> {
        private Injector injector;

        private FunctionNamespaceDaoProvider() {
        }

        @Inject
        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        public FunctionNamespaceDao get() {
            return (FunctionNamespaceDao)((HandleLifecycleManager)this.injector.getInstance(HandleLifecycleManager.class)).getHandle().attach(H2FunctionNamespaceDao.class);
        }
    }

    private static class HandleLifecycleManager {
        private final Handle handle;

        @Inject
        public HandleLifecycleManager(Jdbi jdbi) {
            this.handle = jdbi.open();
        }

        public Handle getHandle() {
            return this.handle;
        }

        @PreDestroy
        public void destroy() {
            this.handle.close();
        }
    }
}

