/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.client.IntervalDayTime;
import com.facebook.presto.client.IntervalYearMonth;
import com.facebook.presto.client.QueryData;
import com.facebook.presto.client.QueryStatusInfo;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintEnumType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Chars;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DistinctType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.JsonType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.SqlTimestamp;
import com.facebook.presto.common.type.TimeType;
import com.facebook.presto.common.type.TimeWithTimeZoneType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeWithName;
import com.facebook.presto.common.type.UuidType;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharEnumType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.server.testing.TestingPrestoServer;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.tests.AbstractTestingPrestoClient;
import com.facebook.presto.tests.ResultsSession;
import com.facebook.presto.type.IntervalDayTimeType;
import com.facebook.presto.type.IntervalYearMonthType;
import com.facebook.presto.type.IpAddressType;
import com.facebook.presto.type.SqlIntervalDayTime;
import com.facebook.presto.type.SqlIntervalYearMonth;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class TestingPrestoClient
extends AbstractTestingPrestoClient<MaterializedResult> {
    private static final DateTimeFormatter timeWithUtcZoneFormat = DateTimeFormatter.ofPattern("HH:mm:ss.SSS 'UTC'");
    private static final DateTimeFormatter timeWithZoneOffsetFormat = DateTimeFormatter.ofPattern("HH:mm:ss.SSS XXX");
    private static final DateTimeFormatter timestampWithTimeZoneFormat = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss.SSS VV");

    public TestingPrestoClient(TestingPrestoServer prestoServer, Session defaultSession) {
        super(prestoServer, defaultSession);
    }

    @Override
    protected ResultsSession<MaterializedResult> getResultSession(Session session) {
        return new MaterializedResultSession();
    }

    private static Function<List<Object>, MaterializedRow> dataToRow(List<Type> types) {
        return data -> {
            Preconditions.checkArgument((data.size() == types.size() ? 1 : 0) != 0, (Object)"columns size does not match types size");
            ArrayList<Object> row = new ArrayList<Object>();
            for (int i = 0; i < data.size(); ++i) {
                Object value = data.get(i);
                Type type = (Type)types.get(i);
                row.add(TestingPrestoClient.convertToRowValue(type, value));
            }
            return new MaterializedRow(5, row);
        };
    }

    private static Object convertToRowValue(Type type, Object value) {
        if (value == null) {
            return null;
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return value;
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return ((Number)value).byteValue();
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return ((Number)value).shortValue();
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return ((Number)value).intValue();
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return ((Number)value).longValue();
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return ((Number)value).doubleValue();
        }
        if (RealType.REAL.equals((Object)type)) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (type instanceof VarcharType) {
            return value;
        }
        if (Chars.isCharType((Type)type)) {
            return value;
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return value;
        }
        if (DateType.DATE.equals((Object)type)) {
            return DateTimeFormatter.ISO_LOCAL_DATE.parse((CharSequence)((String)value), LocalDate::from);
        }
        if (TimeType.TIME.equals((Object)type)) {
            return DateTimeFormatter.ISO_LOCAL_TIME.parse((CharSequence)((String)value), LocalTime::from);
        }
        if (TimeWithTimeZoneType.TIME_WITH_TIME_ZONE.equals((Object)type)) {
            try {
                return timeWithUtcZoneFormat.parse((CharSequence)((String)value), LocalTime::from).atOffset(ZoneOffset.UTC);
            }
            catch (DateTimeParseException e2) {
                return timeWithZoneOffsetFormat.parse((CharSequence)((String)value), OffsetTime::from);
            }
        }
        if (TimestampType.TIMESTAMP.equals((Object)type)) {
            return SqlTimestamp.JSON_MILLIS_FORMATTER.parse((CharSequence)((String)value), LocalDateTime::from);
        }
        if (TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE.equals((Object)type)) {
            return timestampWithTimeZoneFormat.parse((CharSequence)((String)value), ZonedDateTime::from);
        }
        if (IntervalDayTimeType.INTERVAL_DAY_TIME.equals((Object)type)) {
            return new SqlIntervalDayTime(IntervalDayTime.parseMillis((String)String.valueOf(value)));
        }
        if (IntervalYearMonthType.INTERVAL_YEAR_MONTH.equals((Object)type)) {
            return new SqlIntervalYearMonth(IntervalYearMonth.parseMonths((String)String.valueOf(value)));
        }
        if (IpAddressType.IPADDRESS.equals((Object)type)) {
            return value;
        }
        if (type instanceof ArrayType) {
            return ((List)value).stream().map(element -> TestingPrestoClient.convertToRowValue(((ArrayType)type).getElementType(), element)).collect(Collectors.toList());
        }
        if (type instanceof MapType) {
            return ((Map)value).entrySet().stream().collect(Collectors.toMap(e -> TestingPrestoClient.convertToRowValue(((MapType)type).getKeyType(), e.getKey()), e -> TestingPrestoClient.convertToRowValue(((MapType)type).getValueType(), e.getValue())));
        }
        if (type instanceof RowType) {
            if (value instanceof LinkedHashMap) {
                ArrayList data = new ArrayList(((Map)value).values());
                List fields = ((RowType)type).getFields();
                ArrayList<Object> rowValues = new ArrayList<Object>();
                for (int i = 0; i < fields.size(); ++i) {
                    rowValues.add(TestingPrestoClient.convertToRowValue(((RowType.Field)fields.get(i)).getType(), data.get(i)));
                }
                return rowValues;
            }
            Map data = (Map)value;
            RowType rowType = (RowType)type;
            return rowType.getFields().stream().map(field -> TestingPrestoClient.convertToRowValue(field.getType(), data.get(field.getName().get()))).collect(Collectors.toList());
        }
        if (type instanceof DecimalType) {
            return new BigDecimal((String)value);
        }
        if (type instanceof JsonType) {
            return value;
        }
        if (type instanceof UuidType) {
            return value;
        }
        if (type instanceof VarcharEnumType) {
            return value;
        }
        if (type instanceof BigintEnumType) {
            return ((Number)value).longValue();
        }
        if (type instanceof DistinctType) {
            return TestingPrestoClient.convertToRowValue(((DistinctType)type).getBaseType(), value);
        }
        if (type instanceof TypeWithName) {
            return TestingPrestoClient.convertToRowValue(((TypeWithName)type).getType(), value);
        }
        if (type.getTypeSignature().getBase().equals("ObjectId")) {
            return value;
        }
        if (JsonType.JSON.equals((Object)type)) {
            return value;
        }
        throw new AssertionError((Object)("unhandled type: " + type));
    }

    private class MaterializedResultSession
    implements ResultsSession<MaterializedResult> {
        private final ImmutableList.Builder<MaterializedRow> rows = ImmutableList.builder();
        private final AtomicReference<List<Type>> types = new AtomicReference();
        private final AtomicReference<Optional<String>> updateType = new AtomicReference(Optional.empty());
        private final AtomicReference<OptionalLong> updateCount = new AtomicReference<OptionalLong>(OptionalLong.empty());
        private final AtomicReference<List<PrestoWarning>> warnings = new AtomicReference<ImmutableList>(ImmutableList.of());

        private MaterializedResultSession() {
        }

        @Override
        public void setUpdateType(String type) {
            this.updateType.set(Optional.of(type));
        }

        @Override
        public void setUpdateCount(long count) {
            this.updateCount.set(OptionalLong.of(count));
        }

        @Override
        public void setWarnings(List<PrestoWarning> warnings) {
            this.warnings.set(warnings);
        }

        @Override
        public void addResults(QueryStatusInfo statusInfo, QueryData data) {
            if (this.types.get() == null && statusInfo.getColumns() != null) {
                this.types.set(TestingPrestoClient.this.getTypes(statusInfo.getColumns()));
            }
            if (data.getData() != null) {
                Preconditions.checkState((this.types.get() != null ? 1 : 0) != 0, (Object)"data received without types");
                this.rows.addAll(Iterables.transform((Iterable)data.getData(), (Function)TestingPrestoClient.dataToRow(this.types.get())));
            }
        }

        @Override
        public MaterializedResult build(Map<String, String> setSessionProperties, Set<String> resetSessionProperties) {
            Preconditions.checkState((this.types.get() != null ? 1 : 0) != 0, (Object)"never received types for the query");
            return new MaterializedResult((List)this.rows.build(), this.types.get(), setSessionProperties, resetSessionProperties, this.updateType.get(), this.updateCount.get(), this.warnings.get());
        }
    }
}

