/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.airlift.discovery.server.testing.TestingDiscoveryServer;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.JsonResponseHandler;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.http.client.jetty.JettyHttpClient;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.metadata.AllNodes;
import com.facebook.presto.metadata.Catalog;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.testing.TestingPrestoServer;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.NodePoolType;
import com.facebook.presto.spi.NodeState;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.eventlistener.EventListener;
import com.facebook.presto.split.PageSourceManager;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.facebook.presto.sql.planner.ConnectorPlanOptimizerManager;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.testing.TestingAccessControlManager;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tests.AbstractTestQueries;
import com.facebook.presto.tests.H2ConnectionModule;
import com.facebook.presto.tests.H2FunctionNamespaceManagerPlugin;
import com.facebook.presto.tests.ResultWithQueryId;
import com.facebook.presto.tests.TestingPrestoClient;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.Closer;
import com.google.inject.Module;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.intellij.lang.annotations.Language;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;

public class DistributedQueryRunner
implements QueryRunner {
    private static final Logger log = Logger.get(DistributedQueryRunner.class);
    private static final String ENVIRONMENT = "testing";
    private static final String DEFAULT_USER = "user";
    private static final SqlParserOptions DEFAULT_SQL_PARSER_OPTIONS = new SqlParserOptions();
    private final TestingDiscoveryServer discoveryServer;
    private final List<TestingPrestoServer> coordinators;
    private final int coordinatorCount;
    private final List<TestingPrestoServer> servers;
    private final List<Process> externalWorkers;
    private final List<Module> extraModules;
    private final Closer closer = Closer.create();
    private final HttpClient client = new JettyHttpClient();
    private final List<TestingPrestoClient> prestoClients;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private Optional<TestingPrestoServer> catalogServer = Optional.empty();
    private Optional<List<TestingPrestoServer>> resourceManagers;
    private final int resourceManagerCount;
    private final AtomicReference<Handle> testFunctionNamespacesHandle = new AtomicReference();

    @Deprecated
    public DistributedQueryRunner(Session defaultSession, int nodeCount) throws Exception {
        this(defaultSession, nodeCount, (Map<String, String>)ImmutableMap.of());
    }

    @Deprecated
    public DistributedQueryRunner(Session defaultSession, int nodeCount, Map<String, String> extraProperties) throws Exception {
        this(false, false, defaultSession, nodeCount, 1, 1, extraProperties, (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of(), DEFAULT_SQL_PARSER_OPTIONS, ENVIRONMENT, Optional.empty(), Optional.empty(), (List<Module>)ImmutableList.of());
    }

    public static Builder builder(Session defaultSession) {
        return new Builder(defaultSession);
    }

    private DistributedQueryRunner(boolean resourceManagerEnabled, boolean catalogServerEnabled, Session defaultSession, int nodeCount, int coordinatorCount, int resourceManagerCount, Map<String, String> extraProperties, Map<String, String> coordinatorProperties, Map<String, String> resourceManagerProperties, Map<String, String> catalogServerProperties, SqlParserOptions parserOptions, String environment, Optional<Path> dataDirectory, Optional<BiFunction<Integer, URI, Process>> externalWorkerLauncher, List<Module> extraModules) throws Exception {
        Objects.requireNonNull(defaultSession, "defaultSession is null");
        this.extraModules = Objects.requireNonNull(extraModules, "extraModules is null");
        try {
            long start = System.nanoTime();
            this.discoveryServer = new TestingDiscoveryServer(environment);
            this.coordinatorCount = coordinatorCount;
            this.resourceManagerCount = resourceManagerCount;
            this.closer.register(() -> DistributedQueryRunner.closeUnchecked((AutoCloseable)this.discoveryServer));
            log.info("Created TestingDiscoveryServer in %s", new Object[]{Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
            URI discoveryUrl = this.discoveryServer.getBaseUrl();
            log.info("Discovery URL %s", new Object[]{discoveryUrl});
            ImmutableList.Builder servers = ImmutableList.builder();
            ImmutableList.Builder coordinators = ImmutableList.builder();
            ImmutableList.Builder resourceManagers = ImmutableList.builder();
            HashMap<String, String> extraCoordinatorProperties = new HashMap<String, String>();
            if (externalWorkerLauncher.isPresent()) {
                ImmutableList.Builder externalWorkersBuilder = ImmutableList.builder();
                for (int i = 0; i < nodeCount; ++i) {
                    externalWorkersBuilder.add((Object)externalWorkerLauncher.get().apply(i, discoveryUrl));
                }
                this.externalWorkers = externalWorkersBuilder.build();
                this.closer.register(() -> {
                    for (Process worker : this.externalWorkers) {
                        worker.destroyForcibly();
                    }
                });
                extraCoordinatorProperties.put("node-scheduler.include-coordinator", "false");
            } else {
                this.externalWorkers = ImmutableList.of();
                for (int i = coordinatorCount + (resourceManagerEnabled ? resourceManagerCount : 0); i < nodeCount; ++i) {
                    NodePoolType workerPool = i % 2 == 0 ? NodePoolType.LEAF : NodePoolType.INTERMEDIATE;
                    HashMap<String, String> workerProperties = new HashMap<String, String>(extraProperties);
                    workerProperties.put("pool-type", workerPool.name());
                    TestingPrestoServer worker = (TestingPrestoServer)this.closer.register((Closeable)DistributedQueryRunner.createTestingPrestoServer(discoveryUrl, false, resourceManagerEnabled, false, catalogServerEnabled, false, workerProperties, parserOptions, environment, dataDirectory, extraModules));
                    servers.add((Object)worker);
                }
            }
            extraCoordinatorProperties.put("experimental.iterative-optimizer-enabled", "true");
            extraCoordinatorProperties.putAll(extraProperties);
            extraCoordinatorProperties.putAll(coordinatorProperties);
            if (resourceManagerEnabled) {
                for (int i = 0; i < resourceManagerCount; ++i) {
                    HashMap<String, String> rmProperties = new HashMap<String, String>(resourceManagerProperties);
                    if (resourceManagerProperties.get("raft.isEnabled") != null) {
                        int raftPort = Integer.valueOf(resourceManagerProperties.get("raft.port")) + i;
                        rmProperties.replace("raft.port", String.valueOf(raftPort));
                    }
                    TestingPrestoServer resourceManager = (TestingPrestoServer)this.closer.register((Closeable)DistributedQueryRunner.createTestingPrestoServer(discoveryUrl, true, true, false, false, false, rmProperties, parserOptions, environment, dataDirectory, extraModules));
                    servers.add((Object)resourceManager);
                    resourceManagers.add((Object)resourceManager);
                }
            }
            if (catalogServerEnabled) {
                this.catalogServer = Optional.of(this.closer.register((Closeable)DistributedQueryRunner.createTestingPrestoServer(discoveryUrl, false, false, true, true, false, catalogServerProperties, parserOptions, environment, dataDirectory, extraModules)));
                servers.add((Object)this.catalogServer.get());
            }
            for (int i = 0; i < coordinatorCount; ++i) {
                TestingPrestoServer coordinator = (TestingPrestoServer)this.closer.register((Closeable)DistributedQueryRunner.createTestingPrestoServer(discoveryUrl, false, resourceManagerEnabled, false, catalogServerEnabled, true, extraCoordinatorProperties, parserOptions, environment, dataDirectory, extraModules));
                servers.add((Object)coordinator);
                coordinators.add((Object)coordinator);
                extraCoordinatorProperties.remove("http-server.http.port");
            }
            this.servers = servers.build();
            this.coordinators = coordinators.build();
            this.resourceManagers = Optional.of(resourceManagers.build());
        }
        catch (Exception e) {
            try {
                throw this.closer.rethrow((Throwable)e, Exception.class);
            }
            catch (Throwable throwable) {
                this.closer.close();
                throw throwable;
            }
        }
        defaultSession = defaultSession.toSessionRepresentation().toSession(this.coordinators.get(0).getMetadata().getSessionPropertyManager());
        ImmutableList.Builder prestoClientsBuilder = ImmutableList.builder();
        for (int i = 0; i < coordinatorCount; ++i) {
            prestoClientsBuilder.add((Object)this.closer.register((Closeable)new TestingPrestoClient(this.coordinators.get(i), defaultSession)));
        }
        this.prestoClients = prestoClientsBuilder.build();
        long start = System.nanoTime();
        while (!this.allNodesGloballyVisible()) {
            Assertions.assertLessThan((Comparable)Duration.nanosSince((long)start), (Comparable)new Duration(30.0, TimeUnit.SECONDS));
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        log.info("Announced servers in %s", new Object[]{Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
        start = System.nanoTime();
        for (TestingPrestoServer server : this.servers) {
            server.getMetadata().registerBuiltInFunctions(AbstractTestQueries.CUSTOM_FUNCTIONS);
        }
        log.info("Added functions in %s", new Object[]{Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
        for (TestingPrestoServer server : this.servers) {
            Catalog bogusTestingCatalog = TestingSession.createBogusTestingCatalog((String)"testing_catalog");
            server.getCatalogManager().registerCatalog(bogusTestingCatalog);
            SessionPropertyManager sessionPropertyManager = server.getMetadata().getSessionPropertyManager();
            sessionPropertyManager.addSystemSessionProperties(AbstractTestQueries.TEST_SYSTEM_PROPERTIES);
            sessionPropertyManager.addConnectorSessionProperties(bogusTestingCatalog.getConnectorId(), AbstractTestQueries.TEST_CATALOG_PROPERTIES);
        }
    }

    public void waitForClusterToGetReady() throws InterruptedException {
        for (int i = 0; i < this.coordinators.size(); ++i) {
            NodeState state = NodeState.INACTIVE;
            while (state != NodeState.ACTIVE) {
                TimeUnit.MILLISECONDS.sleep(10L);
                state = this.getCoordinatorInfoState(i);
            }
        }
        int availableCoordinators = 0;
        if (this.getResourceManager().isPresent()) {
            while (availableCoordinators != this.coordinators.size()) {
                TimeUnit.MILLISECONDS.sleep(10L);
                availableCoordinators = this.getResourceManager().get().getNodeManager().getCoordinators().size();
            }
        }
    }

    private NodeState getCoordinatorInfoState(int coordinator) {
        URI uri = URI.create(this.getCoordinator(coordinator).getBaseUrl().toString() + "/v1/info/state");
        Request request = Request.Builder.prepareGet().setHeader("X-Presto-User", DEFAULT_USER).setUri(uri).build();
        NodeState state = (NodeState)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.jsonCodec(NodeState.class)));
        return state;
    }

    private static TestingPrestoServer createTestingPrestoServer(URI discoveryUri, boolean resourceManager, boolean resourceManagerEnabled, boolean catalogServer, boolean catalogServerEnabled, boolean coordinator, Map<String, String> extraProperties, SqlParserOptions parserOptions, String environment, Optional<Path> dataDirectory, List<Module> extraModules) throws Exception {
        long start = System.nanoTime();
        ImmutableMap.Builder propertiesBuilder = ImmutableMap.builder().put((Object)"query.client.timeout", (Object)"10m").put((Object)"exchange.http-client.idle-timeout", (Object)"1h").put((Object)"task.max-index-memory", (Object)"16kB").put((Object)"datasources", (Object)"system").put((Object)"distributed-index-joins-enabled", (Object)"true").put((Object)"exchange.checksum-enabled", (Object)"true");
        if (coordinator) {
            propertiesBuilder.put((Object)"node-scheduler.include-coordinator", (Object)extraProperties.getOrDefault("node-scheduler.include-coordinator", "true"));
            propertiesBuilder.put((Object)"join-distribution-type", (Object)"PARTITIONED");
        }
        HashMap<String, String> properties = new HashMap<String, String>((Map<String, String>)propertiesBuilder.build());
        properties.putAll(extraProperties);
        TestingPrestoServer server = new TestingPrestoServer(resourceManager, resourceManagerEnabled, catalogServer, catalogServerEnabled, coordinator, properties, environment, discoveryUri, parserOptions, extraModules, dataDirectory);
        String nodeRole = "worker";
        if (coordinator) {
            nodeRole = "coordinator";
        } else if (resourceManager) {
            nodeRole = "resourceManager";
        } else if (catalogServer) {
            nodeRole = "catalogServer";
        }
        log.info("Created %s TestingPrestoServer in %s: %s", new Object[]{nodeRole, Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit(), server.getBaseUrl()});
        return server;
    }

    private boolean allNodesGloballyVisible() {
        int expectedActiveNodesForRm = this.externalWorkers.size() + this.servers.size();
        int expectedActiveNodesForCoordinator = this.externalWorkers.size() + this.servers.size();
        for (TestingPrestoServer server : this.servers) {
            AllNodes allNodes = server.refreshNodes();
            int activeNodeCount = allNodes.getActiveNodes().size();
            if (allNodes.getInactiveNodes().isEmpty() && (!server.isCoordinator() || activeNodeCount == expectedActiveNodesForCoordinator) && (!server.isResourceManager() || activeNodeCount == expectedActiveNodesForRm)) continue;
            return false;
        }
        return true;
    }

    public TestingPrestoClient getRandomClient() {
        return this.prestoClients.get(this.getRandomCoordinatorIndex());
    }

    private int getRandomCoordinatorIndex() {
        return ThreadLocalRandom.current().nextInt(this.prestoClients.size());
    }

    public int getNodeCount() {
        return this.servers.size();
    }

    public Session getDefaultSession() {
        return this.getRandomClient().getDefaultSession();
    }

    public TransactionManager getTransactionManager() {
        Preconditions.checkState((this.coordinators.size() == 1 ? 1 : 0) != 0, (Object)"Expected a single coordinator");
        return this.coordinators.get(0).getTransactionManager();
    }

    public Metadata getMetadata() {
        Preconditions.checkState((this.coordinators.size() == 1 ? 1 : 0) != 0, (Object)"Expected a single coordinator");
        return this.coordinators.get(0).getMetadata();
    }

    public SplitManager getSplitManager() {
        Preconditions.checkState((this.coordinators.size() == 1 ? 1 : 0) != 0, (Object)"Expected a single coordinator");
        return this.coordinators.get(0).getSplitManager();
    }

    public PageSourceManager getPageSourceManager() {
        Preconditions.checkState((this.coordinators.size() == 1 ? 1 : 0) != 0, (Object)"Expected a single coordinator");
        return this.coordinators.get(0).getPageSourceManager();
    }

    public NodePartitioningManager getNodePartitioningManager() {
        Preconditions.checkState((this.coordinators.size() == 1 ? 1 : 0) != 0, (Object)"Expected a single coordinator");
        return this.coordinators.get(0).getNodePartitioningManager();
    }

    public ConnectorPlanOptimizerManager getPlanOptimizerManager() {
        Preconditions.checkState((this.coordinators.size() == 1 ? 1 : 0) != 0, (Object)"Expected a single coordinator");
        return this.coordinators.get(0).getPlanOptimizerManager();
    }

    public StatsCalculator getStatsCalculator() {
        Preconditions.checkState((this.coordinators.size() == 1 ? 1 : 0) != 0, (Object)"Expected a single coordinator");
        return this.coordinators.get(0).getStatsCalculator();
    }

    public Optional<EventListener> getEventListener() {
        Preconditions.checkState((this.coordinators.size() == 1 ? 1 : 0) != 0, (Object)"Expected a single coordinator");
        return this.coordinators.get(0).getEventListener();
    }

    public TestingAccessControlManager getAccessControl() {
        Preconditions.checkState((this.coordinators.size() == 1 ? 1 : 0) != 0, (Object)"Expected a single coordinator");
        return this.coordinators.get(0).getAccessControl();
    }

    public TestingPrestoServer getCoordinator() {
        Preconditions.checkState((this.coordinators.size() == 1 ? 1 : 0) != 0, (Object)"Expected a single coordinator");
        return this.coordinators.get(0);
    }

    public TestingPrestoServer getCoordinator(int coordinator) {
        Preconditions.checkState((coordinator < this.coordinators.size() ? 1 : 0) != 0, (Object)String.format("Expected coordinator index %d < %d", coordinator, this.coordinatorCount));
        return this.coordinators.get(coordinator);
    }

    public List<TestingPrestoServer> getCoordinators() {
        return this.coordinators;
    }

    public Optional<TestingPrestoServer> getResourceManager() {
        return this.resourceManagers.isPresent() && !this.resourceManagers.get().isEmpty() ? Optional.of(this.resourceManagers.get().get(0)) : Optional.empty();
    }

    public Optional<TestingPrestoServer> getCatalogServer() {
        return this.catalogServer;
    }

    public TestingPrestoServer getResourceManager(int resourceManager) {
        Preconditions.checkState((resourceManager < this.resourceManagers.get().size() ? 1 : 0) != 0, (Object)String.format("Expected resource manager index %d < %d", resourceManager, this.resourceManagerCount));
        return this.resourceManagers.get().get(resourceManager);
    }

    public List<TestingPrestoServer> getResourceManagers() {
        return this.resourceManagers.get();
    }

    public List<TestingPrestoServer> getCoordinatorWorkers() {
        return (List)this.getServers().stream().filter(server -> !server.isResourceManager()).collect(ImmutableList.toImmutableList());
    }

    public List<TestingPrestoServer> getServers() {
        return ImmutableList.copyOf(this.servers);
    }

    public void installPlugin(Plugin plugin) {
        this.installPlugin(plugin, false);
    }

    public void createCatalog(String catalogName, String connectorName) {
        this.createCatalog(catalogName, connectorName, (Map<String, String>)ImmutableMap.of());
    }

    public void createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        long start = System.nanoTime();
        HashSet<ConnectorId> connectorIds = new HashSet<ConnectorId>();
        for (TestingPrestoServer server : this.servers) {
            connectorIds.add(server.createCatalog(catalogName, connectorName, properties));
        }
        ConnectorId connectorId = (ConnectorId)Iterables.getOnlyElement(connectorIds);
        log.info("Created catalog %s (%s) in %s", new Object[]{catalogName, connectorId, Duration.nanosSince((long)start)});
        start = System.nanoTime();
        while (!this.isConnectorVisibleToAllNodes(connectorId)) {
            Assertions.assertLessThan((Comparable)Duration.nanosSince((long)start), (Comparable)new Duration(100.0, TimeUnit.SECONDS), (String)("waiting for connector " + connectorId + " to be initialized in every node"));
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        log.info("Announced catalog %s (%s) in %s", new Object[]{catalogName, connectorId, Duration.nanosSince((long)start)});
    }

    public void loadFunctionNamespaceManager(String functionNamespaceManagerName, String catalogName, Map<String, String> properties) {
        for (TestingPrestoServer server : this.servers) {
            server.getMetadata().getFunctionAndTypeManager().loadFunctionNamespaceManager(functionNamespaceManagerName, catalogName, properties);
        }
    }

    public void enableTestFunctionNamespaces(List<String> catalogNames, Map<String, String> additionalProperties) {
        this.enableTestFunctionNamespaces(catalogNames, additionalProperties, false);
    }

    public void enableTestFunctionNamespacesOnCoordinators(List<String> catalogNames, Map<String, String> additionalProperties) {
        this.enableTestFunctionNamespaces(catalogNames, additionalProperties, true);
    }

    public void createTestFunctionNamespace(String catalogName, String schemaName) {
        Preconditions.checkState((this.testFunctionNamespacesHandle.get() != null ? 1 : 0) != 0, (Object)"Test function namespaces not enabled");
        this.testFunctionNamespacesHandle.get().execute("INSERT INTO function_namespaces SELECT ?, ?", new Object[]{catalogName, schemaName});
    }

    private boolean isConnectorVisibleToAllNodes(ConnectorId connectorId) {
        if (!this.externalWorkers.isEmpty()) {
            return true;
        }
        for (TestingPrestoServer server : this.servers) {
            server.refreshNodes();
            Set activeNodesWithConnector = server.getActiveNodesWithConnector(connectorId);
            if ((!server.isCoordinator() || !server.nodeSchedulerIncludeCoordinator()) && !server.isResourceManager() || activeNodesWithConnector.size() == this.servers.size()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QualifiedObjectName> listTables(Session session, String catalog, String schema) {
        this.lock.readLock().lock();
        try {
            List<QualifiedObjectName> list = this.getRandomClient().listTables(session, catalog, schema);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(Session session, String table) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.getRandomClient().tableExists(session, table);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public MaterializedResult execute(@Language(value="SQL") String sql) {
        return this.execute(this.getRandomCoordinatorIndex(), sql);
    }

    public MaterializedResult execute(Session session, @Language(value="SQL") String sql) {
        return this.execute(this.getRandomCoordinatorIndex(), session, sql);
    }

    public ResultWithQueryId<MaterializedResult> executeWithQueryId(Session session, @Language(value="SQL") String sql) {
        return this.executeWithQueryId(this.getRandomCoordinatorIndex(), session, sql);
    }

    public QueryRunner.MaterializedResultWithPlan executeWithPlan(Session session, String sql, WarningCollector warningCollector) {
        ResultWithQueryId<MaterializedResult> resultWithQueryId = this.executeWithQueryId(session, sql);
        return new QueryRunner.MaterializedResultWithPlan(resultWithQueryId.getResult().toTestTypes(), this.getQueryPlan(resultWithQueryId.getQueryId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaterializedResult execute(int coordinator, @Language(value="SQL") String sql) {
        Preconditions.checkArgument((coordinator >= 0 && coordinator < this.coordinators.size() ? 1 : 0) != 0);
        this.lock.readLock().lock();
        try {
            MaterializedResult materializedResult = (MaterializedResult)this.prestoClients.get(coordinator).execute(sql).getResult();
            return materializedResult;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaterializedResult execute(int coordinator, Session session, @Language(value="SQL") String sql) {
        Preconditions.checkArgument((coordinator >= 0 && coordinator < this.coordinators.size() ? 1 : 0) != 0);
        this.lock.readLock().lock();
        try {
            MaterializedResult materializedResult = (MaterializedResult)this.prestoClients.get(coordinator).execute(session, sql).getResult();
            return materializedResult;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultWithQueryId<MaterializedResult> executeWithQueryId(int coordinator, Session session, @Language(value="SQL") String sql) {
        Preconditions.checkArgument((coordinator >= 0 && coordinator < this.coordinators.size() ? 1 : 0) != 0);
        this.lock.readLock().lock();
        try {
            ResultWithQueryId<MaterializedResult> resultWithQueryId = this.prestoClients.get(coordinator).execute(session, sql);
            return resultWithQueryId;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Plan createPlan(Session session, String sql, WarningCollector warningCollector) {
        QueryId queryId = this.executeWithQueryId(session, sql).getQueryId();
        Plan queryPlan = this.getQueryPlan(queryId);
        Preconditions.checkState((this.coordinators.size() == 1 ? 1 : 0) != 0, (Object)"Expected a single coordinator");
        this.coordinators.get(0).getQueryManager().cancelQuery(queryId);
        return queryPlan;
    }

    public List<BasicQueryInfo> getQueries() {
        Preconditions.checkState((this.coordinators.size() == 1 ? 1 : 0) != 0, (Object)"Expected a single coordinator");
        return this.coordinators.get(0).getQueryManager().getQueries();
    }

    public QueryInfo getQueryInfo(QueryId queryId) {
        Preconditions.checkState((this.coordinators.size() == 1 ? 1 : 0) != 0, (Object)"Expected a single coordinator");
        return this.coordinators.get(0).getQueryManager().getFullQueryInfo(queryId);
    }

    public Plan getQueryPlan(QueryId queryId) {
        Preconditions.checkState((this.coordinators.size() == 1 ? 1 : 0) != 0, (Object)"Expected a single coordinator");
        return this.coordinators.get(0).getQueryPlan(queryId);
    }

    public Lock getExclusiveLock() {
        return this.lock.writeLock();
    }

    public final synchronized void close() {
        this.cancelAllQueries();
        try {
            this.closer.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void cancelAllQueries() {
        for (TestingPrestoServer coordinator : this.coordinators) {
            QueryManager queryManager = coordinator.getQueryManager();
            for (BasicQueryInfo queryInfo : queryManager.getQueries()) {
                if (queryInfo.getState().isDone()) continue;
                queryManager.cancelQuery(queryInfo.getQueryId());
            }
        }
    }

    private void enableTestFunctionNamespaces(List<String> catalogNames, Map<String, String> additionalProperties, boolean coordinatorOnly) {
        Preconditions.checkState((this.testFunctionNamespacesHandle.get() == null ? 1 : 0) != 0, (Object)"Test function namespaces already enabled");
        String databaseName = String.valueOf(System.nanoTime()) + "_" + ThreadLocalRandom.current().nextInt();
        ImmutableMap properties = ImmutableMap.builder().put((Object)"database-name", (Object)databaseName).putAll(additionalProperties).build();
        this.installPlugin(new H2FunctionNamespaceManagerPlugin(), coordinatorOnly);
        for (String catalogName : catalogNames) {
            this.loadFunctionNamespaceManager("h2", catalogName, (Map<String, String>)properties, coordinatorOnly);
        }
        Handle handle = Jdbi.open((String)H2ConnectionModule.getJdbcUrl(databaseName));
        this.testFunctionNamespacesHandle.set(handle);
        this.closer.register((Closeable)handle);
    }

    private void loadFunctionNamespaceManager(String functionNamespaceManagerName, String catalogName, Map<String, String> properties, boolean coordinatorOnly) {
        for (TestingPrestoServer server : this.servers) {
            if (coordinatorOnly && !server.isCoordinator()) continue;
            server.getMetadata().getFunctionAndTypeManager().loadFunctionNamespaceManager(functionNamespaceManagerName, catalogName, properties);
        }
    }

    private void installPlugin(Plugin plugin, boolean coordinatorOnly) {
        long start = System.nanoTime();
        for (TestingPrestoServer server : this.servers) {
            if (coordinatorOnly && !server.isCoordinator()) continue;
            server.installPlugin(plugin);
        }
        log.info("Installed plugin %s in %s", new Object[]{plugin.getClass().getSimpleName(), Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
    }

    private static void closeUnchecked(AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    static /* synthetic */ SqlParserOptions access$000() {
        return DEFAULT_SQL_PARSER_OPTIONS;
    }

    public static class Builder {
        private Session defaultSession;
        private int nodeCount = 4;
        private int coordinatorCount = 1;
        private Map<String, String> extraProperties = ImmutableMap.of();
        private Map<String, String> coordinatorProperties = ImmutableMap.of();
        private Map<String, String> resourceManagerProperties = ImmutableMap.of();
        private Map<String, String> catalogServerProperties = ImmutableMap.of();
        private SqlParserOptions parserOptions = DistributedQueryRunner.access$000();
        private String environment = "testing";
        private Optional<Path> dataDirectory = Optional.empty();
        private Optional<BiFunction<Integer, URI, Process>> externalWorkerLauncher = Optional.empty();
        private boolean resourceManagerEnabled;
        private boolean catalogServerEnabled;
        private List<Module> extraModules = ImmutableList.of();
        private int resourceManagerCount = 1;

        protected Builder(Session defaultSession) {
            this.defaultSession = Objects.requireNonNull(defaultSession, "defaultSession is null");
        }

        public Builder amendSession(Function<Session.SessionBuilder, Session.SessionBuilder> amendSession) {
            Session.SessionBuilder builder = Session.builder((Session)this.defaultSession);
            this.defaultSession = amendSession.apply(builder).build();
            return this;
        }

        public Builder setNodeCount(int nodeCount) {
            this.nodeCount = nodeCount;
            return this;
        }

        public Builder setCoordinatorCount(int coordinatorCount) {
            this.coordinatorCount = coordinatorCount;
            return this;
        }

        public Builder setExtraProperties(Map<String, String> extraProperties) {
            this.extraProperties = extraProperties;
            return this;
        }

        public Builder setSingleExtraProperty(String key, String value) {
            return this.setExtraProperties((Map<String, String>)ImmutableMap.of((Object)key, (Object)value));
        }

        public Builder setCoordinatorProperties(Map<String, String> coordinatorProperties) {
            this.coordinatorProperties = coordinatorProperties;
            return this;
        }

        public Builder setResourceManagerProperties(Map<String, String> resourceManagerProperties) {
            this.resourceManagerProperties = resourceManagerProperties;
            return this;
        }

        public Builder setCatalogServerProperties(Map<String, String> catalogServerProperties) {
            this.catalogServerProperties = catalogServerProperties;
            return this;
        }

        public Builder setSingleCoordinatorProperty(String key, String value) {
            return this.setCoordinatorProperties((Map<String, String>)ImmutableMap.of((Object)key, (Object)value));
        }

        public Builder setParserOptions(SqlParserOptions parserOptions) {
            this.parserOptions = parserOptions;
            return this;
        }

        public Builder setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        public Builder setDataDirectory(Optional<Path> dataDirectory) {
            this.dataDirectory = Objects.requireNonNull(dataDirectory, "dataDirectory is null");
            return this;
        }

        public Builder setExternalWorkerLauncher(Optional<BiFunction<Integer, URI, Process>> externalWorkerLauncher) {
            this.externalWorkerLauncher = Objects.requireNonNull(externalWorkerLauncher, "externalWorkerLauncher is null");
            return this;
        }

        public Builder setResourceManagerEnabled(boolean resourceManagerEnabled) {
            this.resourceManagerEnabled = resourceManagerEnabled;
            return this;
        }

        public Builder setCatalogServerEnabled(boolean catalogServerEnabled) {
            this.catalogServerEnabled = catalogServerEnabled;
            return this;
        }

        public Builder setExtraModules(List<Module> extraModules) {
            this.extraModules = extraModules;
            return this;
        }

        public Builder setResourceManagerCount(int resourceManagerCount) {
            this.resourceManagerCount = resourceManagerCount;
            return this;
        }

        public DistributedQueryRunner build() throws Exception {
            return new DistributedQueryRunner(this.resourceManagerEnabled, this.catalogServerEnabled, this.defaultSession, this.nodeCount, this.coordinatorCount, this.resourceManagerCount, this.extraProperties, this.coordinatorProperties, this.resourceManagerProperties, this.catalogServerProperties, this.parserOptions, this.environment, this.dataDirectory, this.externalWorkerLauncher, this.extraModules);
        }
    }
}

