/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.tests.AbstractTestQueryFramework;
import org.testng.annotations.Test;

public abstract class AbstractTestTopNQueries
extends AbstractTestQueryFramework {
    @Test
    public void testUngroupedTopN() {
        this.assertQuery("SELECT custkey, totalprice from orders ORDER BY totalprice limit 3");
    }

    @Test
    public void testGroupedTopN() {
        this.assertQuery("SELECT * FROM (SELECT custkey, totalprice, ROW_NUMBER() OVER (PARTITION BY custkey order by totalprice) rn from orders) where rn < 3");
    }

    @Test
    public void testGroupedTopNRowNumber() {
        this.assertQuery("SELECT * FROM (SELECT custkey, totalprice, ROW_NUMBER() OVER (PARTITION BY custkey order by totalprice) rn from orders) where rn < 3");
    }

    @Test
    public void testGroupedTopWithAggregationAndMultiChannelGrouping() {
        this.assertQuery("SELECT * FROM ( SELECT  regionkey, RANK() OVER (PARTITION BY regionkey ORDER BY nation_count) r  FROM   ( SELECT R.regionkey, count(distinct nationkey) nation_count FROM        region R        JOIN nation N ON  R.regionkey=N.regionkey        GROUP BY R.regionkey   ))  WHERE r <= 2");
    }
}

