/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.Session;
import com.facebook.presto.operator.HashAggregationOperator;
import com.facebook.presto.operator.HashBuilderOperator;
import com.facebook.presto.operator.OperatorMemoryReservationSummary;
import com.facebook.presto.operator.TaskMemoryReservationSummary;
import com.facebook.presto.operator.WindowOperator;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public abstract class AbstractTestVerboseMemoryExceededErrors
extends AbstractTestQueryFramework {
    private static final int INVOCATION_COUNT = 1;

    @Override
    protected Session getSession() {
        return Session.builder((Session)super.getSession()).setSystemProperty("verbose_exceeded_memory_limit_errors_enabled", "true").setSystemProperty("use_mark_distinct", "false").build();
    }

    @Test(invocationCount=1)
    public void testAggregation() {
        this.assertMemoryExceededDetails("SELECT    linenumber,    ARRAY_AGG(comment),   MAP_AGG(comment, comment) FROM lineitem GROUP BY linenumber", HashAggregationOperator.class.getSimpleName(), Optional.empty());
        this.assertMemoryExceededDetails("SELECT    linenumber,    ARRAY_AGG(DISTINCT comment),   MAP_AGG(comment, comment) FROM lineitem GROUP BY linenumber", HashAggregationOperator.class.getSimpleName(), Optional.of("DISTINCT;"));
        this.assertMemoryExceededDetails("SELECT    linenumber,    ARRAY_AGG(comment ORDER BY comment),   MAP_AGG(comment, comment) FROM lineitem GROUP BY linenumber", HashAggregationOperator.class.getSimpleName(), Optional.of("ORDER_BY;"));
    }

    @Test(invocationCount=1)
    public void testJoin() {
        this.assertMemoryExceededDetails("SELECT    * FROM lineitem l1 INNER JOIN lineitem l2 ON l1.linenumber = l2.linenumber WHERE l1.quantity = 1.0", HashBuilderOperator.class.getSimpleName(), Optional.of("INNER;"));
        this.assertMemoryExceededDetails("SELECT    * FROM ( SELECT *  FROM lineitem  WHERE quantity = 1.0 ) l1 RIGHT OUTER JOIN lineitem l2 ON l1.linenumber = l2.linenumber ", HashBuilderOperator.class.getSimpleName(), Optional.of("RIGHT;"));
    }

    @Test(invocationCount=1)
    public void testWindow() {
        this.assertMemoryExceededDetails("SELECT    rank() OVER (ORDER BY comment DESC) AS rnk FROM lineitem", WindowOperator.class.getSimpleName(), Optional.empty());
    }

    private void assertMemoryExceededDetails(String sql, String expectedTopConsumerOperatorName, Optional<String> expectedTopConsumerOperatorInfo) {
        block3: {
            try {
                this.getQueryRunner().execute(Session.builder((Session)this.getSession()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinReorderingStrategy.ELIMINATE_CROSS_JOINS.name()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).build(), sql);
                Assert.fail((String)"query expected to fail");
            }
            catch (RuntimeException e) {
                Pattern p = Pattern.compile(".*Query exceeded per-node total memory limit of.*, Details: (.*)", 32);
                String message = e.getMessage();
                Matcher matcher = p.matcher(message);
                if (!matcher.matches()) {
                    Assert.fail((String)("Unexpected error message: " + message));
                }
                String detailsJson = matcher.group(1);
                List summaries = (List)JsonCodec.listJsonCodec(TaskMemoryReservationSummary.class).fromJson(detailsJson);
                Assert.assertEquals((String)((OperatorMemoryReservationSummary)((TaskMemoryReservationSummary)summaries.get(0)).getTopConsumers().get(0)).getType(), (String)expectedTopConsumerOperatorName);
                if (!expectedTopConsumerOperatorInfo.isPresent()) break block3;
                Assert.assertTrue((boolean)((OperatorMemoryReservationSummary)((TaskMemoryReservationSummary)summaries.get(0)).getTopConsumers().get(0)).getInfo().isPresent());
                Assertions.assertThat((String)((String)((OperatorMemoryReservationSummary)((TaskMemoryReservationSummary)summaries.get(0)).getTopConsumers().get(0)).getInfo().get())).contains(new CharSequence[]{expectedTopConsumerOperatorInfo.get()});
            }
        }
    }
}

