/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.statistics;

import com.facebook.presto.spi.plan.PlanNodeWithHash;
import com.facebook.presto.spi.statistics.HistoricalPlanStatistics;
import com.facebook.presto.spi.statistics.HistoryBasedPlanStatisticsProvider;
import com.facebook.presto.spi.statistics.PlanStatistics;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;

public class InMemoryHistoryBasedPlanStatisticsProvider
implements HistoryBasedPlanStatisticsProvider {
    private final Map<String, HistoricalPlanStatistics> cache = new ConcurrentHashMap<String, HistoricalPlanStatistics>();
    private final Semaphore semaphore = new Semaphore(1);

    public InMemoryHistoryBasedPlanStatisticsProvider() {
        this.semaphore.acquireUninterruptibly();
    }

    public String getName() {
        return "test";
    }

    public Map<PlanNodeWithHash, HistoricalPlanStatistics> getStats(List<PlanNodeWithHash> planNodeHashes) {
        return (Map)planNodeHashes.stream().collect(ImmutableMap.toImmutableMap(planNodeWithHash -> planNodeWithHash, planNodeWithHash -> {
            if (planNodeWithHash.getHash().isPresent()) {
                return this.cache.getOrDefault(planNodeWithHash.getHash().get(), new HistoricalPlanStatistics(PlanStatistics.empty()));
            }
            return new HistoricalPlanStatistics(PlanStatistics.empty());
        }));
    }

    public void putStats(Map<PlanNodeWithHash, HistoricalPlanStatistics> hashesAndStatistics) {
        hashesAndStatistics.forEach((planNodeWithHash, historicalPlanStatistics) -> {
            if (planNodeWithHash.getHash().isPresent()) {
                this.cache.put((String)planNodeWithHash.getHash().get(), (HistoricalPlanStatistics)historicalPlanStatistics);
            }
        });
        this.semaphore.release();
    }

    public void waitProcessQueryEvents() {
        try {
            Assert.assertTrue((boolean)this.semaphore.tryAcquire(10L, TimeUnit.SECONDS));
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)"Query events could not be processed in time");
        }
    }
}

