/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.statistics;

import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class StatsContext {
    private final Map<String, VariableReferenceExpression> columnVariables;

    public StatsContext(Map<String, VariableReferenceExpression> columnVariables) {
        this.columnVariables = ImmutableMap.copyOf(columnVariables);
    }

    public VariableReferenceExpression getVariableForColumn(String columnName) {
        Preconditions.checkArgument((boolean)this.columnVariables.containsKey(columnName), (Object)("no variable found for column '" + columnName + "'"));
        return this.columnVariables.get(columnName);
    }
}

