/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.BuiltInFunction;
import com.facebook.presto.metadata.FunctionListBuilder;
import com.facebook.presto.operator.scalar.ApplyFunction;
import com.facebook.presto.operator.scalar.InvokeFunction;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.function.SqlFunction;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.testing.TestingAccessControlManager;
import com.facebook.presto.testing.TestngUtils;
import com.facebook.presto.testing.assertions.Assert;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.facebook.presto.tests.CreateHll;
import com.facebook.presto.tests.CustomAdd;
import com.facebook.presto.tests.CustomRank;
import com.facebook.presto.tests.CustomSum;
import com.facebook.presto.tests.QueryAssertions;
import com.facebook.presto.tests.QueryTemplate;
import com.facebook.presto.tests.StatefulSleepingSum;
import com.facebook.presto.tests.StructuralTestUtil;
import com.facebook.presto.type.SqlIntervalDayTime;
import com.facebook.presto.type.SqlIntervalYearMonth;
import com.facebook.presto.type.UnknownType;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import io.airlift.tpch.TpchTable;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class AbstractTestQueries
extends AbstractTestQueryFramework {
    public static final List<SqlFunction> CUSTOM_FUNCTIONS = new FunctionListBuilder().aggregates(CustomSum.class).window(CustomRank.class).scalars(CustomAdd.class).scalars(CreateHll.class).functions(new BuiltInFunction[]{ApplyFunction.APPLY_FUNCTION, InvokeFunction.INVOKE_FUNCTION, StatefulSleepingSum.STATEFUL_SLEEPING_SUM}).getFunctions();
    public static final List<PropertyMetadata<?>> TEST_SYSTEM_PROPERTIES = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"test_string", (String)"test string property", (String)"test default", (boolean)false), (Object)PropertyMetadata.longProperty((String)"test_long", (String)"test long property", (Long)42L, (boolean)false));
    public static final List<PropertyMetadata<?>> TEST_CATALOG_PROPERTIES = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"connector_string", (String)"connector string property", (String)"connector default", (boolean)false), (Object)PropertyMetadata.longProperty((String)"connector_long", (String)"connector long property", (Long)33L, (boolean)false), (Object)PropertyMetadata.booleanProperty((String)"connector_boolean", (String)"connector boolean property", (Boolean)true, (boolean)false), (Object)PropertyMetadata.doubleProperty((String)"connector_double", (String)"connector double property", (Double)99.0, (boolean)false));
    private static final DateTimeFormatter ZONED_DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss.SSS VV");
    private static final String UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG = "line .*: Given correlated subquery is not supported";

    protected AbstractTestQueries(AbstractTestQueryFramework.QueryRunnerSupplier supplier) {
        super(supplier);
    }

    @Test
    public void testParsingError() {
        this.assertQueryFails("SELECT foo FROM", "line 1:16: mismatched input '<EOF>'. Expecting: .*");
    }

    @Test
    public void selectLargeInterval() {
        MaterializedResult result = this.computeActual("SELECT INTERVAL '30' DAY");
        Assert.assertEquals((int)result.getRowCount(), (int)1);
        Assert.assertEquals((Object)((MaterializedRow)result.getMaterializedRows().get(0)).getField(0), (Object)new SqlIntervalDayTime(30, 0, 0, 0, 0));
        result = this.computeActual("SELECT INTERVAL '32767' YEAR");
        Assert.assertEquals((int)result.getRowCount(), (int)1);
        Assert.assertEquals((Object)((MaterializedRow)result.getMaterializedRows().get(0)).getField(0), (Object)new SqlIntervalYearMonth(Short.MAX_VALUE, 0));
    }

    @Test
    public void selectNull() {
        this.assertQuery("SELECT NULL");
    }

    @Test
    public void testAggregationOverUnknown() {
        this.assertQuery("SELECT clerk, min(totalprice), max(totalprice), min(nullvalue), max(nullvalue) FROM (SELECT clerk, totalprice, null AS nullvalue FROM orders) GROUP BY clerk");
    }

    @Test
    public void testLimitIntMax() {
        this.assertQuery("SELECT orderkey FROM orders LIMIT 2147483647");
        this.assertQuery("SELECT orderkey FROM orders ORDER BY orderkey LIMIT 2147483647");
    }

    @Test
    public void testNonDeterministic() {
        MaterializedResult materializedResult = this.computeActual("SELECT rand() FROM orders LIMIT 10");
        long distinctCount = materializedResult.getMaterializedRows().stream().map(row -> row.getField(0)).distinct().count();
        org.testng.Assert.assertTrue((distinctCount >= 8L ? 1 : 0) != 0, (String)"rand() must produce different rows");
        materializedResult = this.computeActual("SELECT apply(1, x -> x + rand()) FROM orders LIMIT 10");
        distinctCount = materializedResult.getMaterializedRows().stream().map(row -> row.getField(0)).distinct().count();
        org.testng.Assert.assertTrue((distinctCount >= 8L ? 1 : 0) != 0, (String)"rand() must produce different rows");
    }

    @Test
    public void testLambdaCapture() {
        this.assertQuery("SELECT apply(0, x -> x + c1) FROM (VALUES 1) t(c1)", "VALUES 1");
        this.assertQuery("SELECT apply(0, x -> x + t.c1) FROM (VALUES 1) t(c1)", "VALUES 1");
        this.assertQuery("SELECT apply(c1, x -> x + c2) FROM (VALUES (1, 2), (3, 4), (5, 6)) t(c1, c2)", "VALUES 3, 7, 11");
        this.assertQuery("SELECT apply(c1 + 10, x -> apply(x + 100, y -> c1)) FROM (VALUES 1) t(c1)", "VALUES 1");
        this.assertQuery("SELECT apply(c1 + 10, x -> apply(x + 100, y -> t.c1)) FROM (VALUES 1) t(c1)", "VALUES 1");
        this.assertQuery("SELECT apply(CAST(ROW(10) AS ROW(x INTEGER)), r -> r.x)", "VALUES 10");
        this.assertQuery("SELECT apply(CAST(ROW(10) AS ROW(x INTEGER)), r -> r.x) FROM (VALUES 1) u(x)", "VALUES 10");
        this.assertQuery("SELECT apply(CAST(ROW(10) AS ROW(x INTEGER)), r -> r.x) FROM (VALUES 1) r(x)", "VALUES 10");
        this.assertQuery("SELECT apply(CAST(ROW(10) AS ROW(x INTEGER)), r -> apply(3, y -> y + r.x)) FROM (VALUES 1) u(x)", "VALUES 13");
        this.assertQuery("SELECT apply(CAST(ROW(10) AS ROW(x INTEGER)), r -> apply(3, y -> y + r.x)) FROM (VALUES 1) r(x)", "VALUES 13");
        this.assertQuery("SELECT apply(CAST(ROW(10) AS ROW(x INTEGER)), r -> apply(3, y -> y + r.x)) FROM (VALUES 'a') r(x)", "VALUES 13");
        this.assertQuery("SELECT apply(CAST(ROW(10) AS ROW(x INTEGER)), z -> apply(3, y -> y + r.x)) FROM (VALUES 1) r(x)", "VALUES 4");
        this.assertQuery("SELECT apply(1, x -> apply(10, y -> x)) FROM (VALUES 1000) t(x)", "VALUES 1");
        this.assertQuery("SELECT apply(1, x -> apply(10, y -> x)) FROM (VALUES 'abc') t(x)", "VALUES 1");
        this.assertQuery("SELECT apply(1, x -> apply(10, y -> apply(100, z -> x))) FROM (VALUES 1000) t(x)", "VALUES 1");
        this.assertQuery("SELECT apply(1, x -> apply(10, y -> apply(100, z -> x))) FROM (VALUES 'abc') t(x)", "VALUES 1");
        this.assertQuery("SELECT * FROM (VALUES true) t(x) left JOIN (VALUES 1001) t2(y) ON (apply(false, z -> apply(false, y -> x)))", "SELECT true, 1001");
    }

    @Test
    public void testLambdaInAggregationContext() {
        this.assertQuery("SELECT apply(sum(x), i -> i * i) FROM (VALUES 1, 2, 3, 4, 5) t(x)", "SELECT 225");
        this.assertQuery("SELECT apply(x, i -> i - 1), sum(y) FROM (VALUES (1, 10), (1, 20), (2, 50)) t(x,y) GROUP BY x", "VALUES (0, 30), (1, 50)");
        this.assertQuery("SELECT x, apply(sum(y), i -> i * 10) FROM (VALUES (1, 10), (1, 20), (2, 50)) t(x,y) GROUP BY x", "VALUES (1, 300), (2, 500)");
        this.assertQuery("SELECT apply(8, x -> x + 1) FROM (VALUES (1, 2)) t(x,y) GROUP BY y", "SELECT 9");
        this.assertQuery("SELECT apply(CAST(ROW(1) AS ROW(someField BIGINT)), x -> x.someField) FROM (VALUES (1,2)) t(x,y) GROUP BY y", "SELECT 1");
        this.assertQuery("SELECT apply(sum(x), x -> x * x) FROM (VALUES 1, 2, 3, 4, 5) t(x)", "SELECT 225");
        this.assertQuery("SELECT apply(sum(x), x -> apply(x, x -> x * x)) FROM (VALUES 1, 2, 3, 4, 5) t(x)", "SELECT 225");
    }

    @Test
    public void testLambdaInSubqueryContext() {
        this.assertQuery("SELECT apply(x, i -> i * i) FROM (SELECT 10 x)", "SELECT 100");
        this.assertQuery("SELECT apply((SELECT 10), i -> i * i)", "SELECT 100");
        this.assertQuery("SELECT apply(x, i -> i * x) FROM (SELECT 10 x)", "SELECT 100");
        this.assertQuery("SELECT apply(x, y -> y * x) FROM (SELECT 10 x, 3 y)", "SELECT 100");
        this.assertQuery("SELECT apply(x, z -> y * x) FROM (SELECT 10 x, 3 y)", "SELECT 30");
    }

    @Test
    public void testLambdaInValuesAndUnnest() {
        this.assertQuery("SELECT * FROM UNNEST(transform(sequence(1, 5), x -> x * x))", "SELECT * FROM (VALUES 1, 4, 9, 16, 25)");
        this.assertQuery("SELECT x[5] FROM (VALUES transform(sequence(1, 5), x -> x * x)) t(x)", "SELECT 25");
    }

    @Test
    public void testTryLambdaRepeated() {
        this.assertQuery("SELECT x + x FROM (SELECT apply(a, i -> i * i) x FROM (VALUES 3) t(a))", "SELECT 18");
        this.assertQuery("SELECT apply(a, i -> i * i) + apply(a, i -> i * i) FROM (VALUES 3) t(a)", "SELECT 18");
        this.assertQuery("SELECT apply(a, i -> i * i), apply(a, i -> i * i) FROM (VALUES 3) t(a)", "SELECT 9, 9");
        this.assertQuery("SELECT try(10 / a) + try(10 / a) FROM (VALUES 5) t(a)", "SELECT 4");
        this.assertQuery("SELECT try(10 / a), try(10 / a) FROM (VALUES 5) t(a)", "SELECT 2, 2");
    }

    @Test
    public void testTryLambdaWithCast() {
        this.assertQuery("SELECT IF(TRY(CAST(a AS INT)) IN (1, 5), TRY(CAST(b AS DOUBLE)), 0.0) FROM (VALUES (varchar'1', varchar'2.1'), (varchar'5', varchar'3.4')) t(a, b)", "VALUES 2.1, 3.4");
    }

    @Test
    public void testNonDeterministicFilter() {
        MaterializedResult materializedResult = this.computeActual("SELECT u FROM ( SELECT if(rand() > 0.5, 0, 1) AS u ) WHERE u <> u");
        Assert.assertEquals((int)materializedResult.getRowCount(), (int)0);
        materializedResult = this.computeActual("SELECT u, v FROM ( SELECT if(rand() > 0.5, 0, 1) AS u, 4*4 AS v ) WHERE u <> u and v > 10");
        Assert.assertEquals((int)materializedResult.getRowCount(), (int)0);
        materializedResult = this.computeActual("SELECT u, v, w FROM ( SELECT if(rand() > 0.5, 0, 1) AS u, 4*4 AS v, 'abc' AS w ) WHERE v > 10");
        Assert.assertEquals((int)materializedResult.getRowCount(), (int)1);
    }

    @Test
    public void testNonDeterministicProjection() {
        MaterializedResult materializedResult = this.computeActual("SELECT r, r + 1 FROM (SELECT rand(100) r FROM orders) LIMIT 10");
        Assert.assertEquals((int)materializedResult.getRowCount(), (int)10);
        for (MaterializedRow materializedRow : materializedResult) {
            Assert.assertEquals((int)materializedRow.getFieldCount(), (int)2);
            Assert.assertEquals((Object)(((Number)materializedRow.getField(0)).intValue() + 1), (Object)materializedRow.getField(1));
        }
    }

    @Test
    public void testMapSubscript() {
        this.assertQuery("SELECT map(array[1], array['aa'])[1]", "SELECT 'aa'");
        this.assertQuery("SELECT map(array['a'], array['aa'])['a']", "SELECT 'aa'");
        this.assertQuery("SELECT map(array[array[1,1]], array['a'])[array[1,1]]", "SELECT 'a'");
        this.assertQuery("SELECT map(array[(1,2)], array['a'])[(1,2)]", "SELECT 'a'");
    }

    @Test
    public void testRowSubscript() {
        this.assertQuery("SELECT ROW (1, 'a', true)[2]", "SELECT 'a'");
        this.assertQuery("SELECT r[2] FROM (VALUES (ROW (ROW (1, 'a', true)))) AS v(r)", "SELECT 'a'");
        this.assertQuery("SELECT r[1], r[2] FROM (SELECT ROW (name, regionkey) FROM nation ORDER BY name LIMIT 1) t(r)", "VALUES ('ALGERIA', 0)");
        this.assertQuery("SELECT (CAST (ROW (1, 'a', 2 ) AS ROW (field1 bigint, field2 varchar(1), field3 bigint)))[2]", "SELECT 'a'");
        this.assertQuery("SELECT ROW (1, 'a', ROW (false, 2, 'b'))[3][3]", "SELECT 'b'");
        this.assertQuery("SELECT orderstatus FROM orders WHERE ROW (orderkey, custkey)[1] = 100", "SELECT 'O'");
        this.assertQuery("SELECT n.name, r.name FROM nation n JOIN region r ON ROW (n.name, n.regionkey)[2] = ROW (r.name, r.regionkey)[2] ORDER BY n.name LIMIT 1", "VALUES ('ALGERIA', 'AFRICA')");
        this.assertQuery("SELECT apply(ROW (1, 2), r -> r[2])", "SELECT 2");
    }

    @Test
    public void testVarbinary() {
        this.assertQuery("SELECT LENGTH(x) FROM (SELECT from_base64('gw==') AS x)", "SELECT 1");
        this.assertQuery("SELECT LENGTH(from_base64('gw=='))", "SELECT 1");
    }

    @Test
    public void testRowFieldAccessor() {
        this.assertQuery("SELECT a FROM (VALUES ROW (CAST(ROW(1, 2) AS ROW(col0 integer, col1 integer)).col0)) AS t (a)", "SELECT 1");
        this.assertQuery("SELECT a.col0 FROM (VALUES ROW (CAST(ROW(1, 2) AS ROW(col0 integer, col1 integer)))) AS t (a)", "SELECT 1");
        this.assertQuery("SELECT a.col0 FROM (VALUES ROW (CAST(ROW(1.0E0, 2.0E0) AS ROW(col0 integer, col1 integer)))) AS t (a)", "SELECT 1.0");
        this.assertQuery("SELECT a.col0 FROM (VALUES ROW (CAST(ROW(TRUE, FALSE) AS ROW(col0 boolean, col1 boolean)))) AS t (a)", "SELECT TRUE");
        this.assertQuery("SELECT a.col1 FROM (VALUES ROW (CAST(ROW(1.0, 'kittens') AS ROW(col0 varchar, col1 varchar)))) AS t (a)", "SELECT 'kittens'");
        this.assertQuery("SELECT a.col2.col1 FROM (VALUES ROW(CAST(ROW(1.0, ARRAY[2], row(3, 4.0)) AS ROW(col0 double, col1 array(int), col2 row(col0 integer, col1 double))))) t(a)", "SELECT 4.0");
        this.assertQuery("SELECT CAST(row(1, t.x) AS row(col0 bigint, col1 bigint)).col1 FROM (VALUES 1, 2, 3) t(x)", "SELECT * FROM (VALUES 1, 2, 3)");
        this.assertQuery("SELECT Y.col1 FROM (SELECT CAST(row(1, t.x) AS row(col0 bigint, col1 bigint)) AS Y FROM (VALUES 1, 2, 3) t(x)) test_t", "SELECT * FROM (VALUES 1, 2, 3)");
        this.assertQuery("SELECT a.col1[2] FROM (VALUES ROW(CAST(ROW(1.0, ARRAY[22, 33, 44, 55], row(3, 4.0E0)) AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double))))) t(a)", "SELECT 33");
        this.assertQuery("SELECT a.col1[2].col0, a.col1[2].col1 FROM (VALUES ROW(cast(row(1.0, ARRAY[row(31, 4.1E0), row(32, 4.2E0)], row(3, 4.0E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double))))) t(a)", "SELECT 32, 4.2");
        this.assertQuery("SELECT CAST(row(11, 12) AS row(col0 bigint, col1 bigint)).col0", "SELECT 11");
    }

    @Test
    public void testRowFieldAccessorInAggregate() {
        this.assertQuery("SELECT a.col0, SUM(a.col1[2]), SUM(a.col2.col0), SUM(a.col2.col1) FROM (VALUES ROW(CAST(ROW(1.0, ARRAY[2, 13, 4], row(11, 4.1E0))   AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(2.0, ARRAY[2, 23, 4], row(12, 14.0E0))  AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(1.0, ARRAY[22, 33, 44], row(13, 5.0E0)) AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double))))) t(a) GROUP BY a.col0", "SELECT * FROM VALUES (1.0, 46, 24, 9.1), (2.0, 23, 12, 14.0)");
        this.assertQuery("SELECT a.col2.col0, SUM(a.col0), SUM(a.col1[2]), SUM(a.col2.col1) FROM (VALUES ROW(CAST(ROW(1.0, ARRAY[2, 13, 4], row(11, 4.1E0))   AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(2.0, ARRAY[2, 23, 4], row(11, 14.0E0))  AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(7.0, ARRAY[22, 33, 44], row(13, 5.0E0)) AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double))))) t(a) GROUP BY a.col2.col0", "SELECT * FROM VALUES (11, 3.0, 36, 18.1), (13, 7.0, 33, 5.0)");
        this.assertQuery("SELECT a.col1[1].col0, SUM(a.col0), SUM(a.col1[1].col1), SUM(a.col1[2].col0), SUM(a.col2.col1) FROM (VALUES ROW(CAST(ROW(1.0, ARRAY[row(31, 4.5E0), row(12, 4.2E0)], row(3, 4.0E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(3.1, ARRAY[row(41, 3.1E0), row(32, 4.2E0)], row(6, 6.0E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(2.2, ARRAY[row(31, 4.2E0), row(22, 4.2E0)], row(5, 4.0E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double))))) t(a) GROUP BY a.col1[1].col0", "SELECT * FROM VALUES (31, 3.2, 8.7, 34, 8.0), (41, 3.1, 3.1, 32, 6.0)");
        this.assertQuery("SELECT a.col1[1].col0, SUM(a.col0), SUM(a.col1[1].col1), SUM(a.col1[2].col0), SUM(a.col2.col1) FROM (VALUES ROW(CAST(ROW(2.2, ARRAY[row(31, 4.2E0), row(22, 4.2E0)], row(5, 4.0E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(1.0, ARRAY[row(31, 4.5E0), row(12, 4.2E0)], row(3, 4.1E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(3.1, ARRAY[row(41, 3.1E0), row(32, 4.2E0)], row(6, 6.0E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(3.3, ARRAY[row(41, 3.1E0), row(32, 4.2E0)], row(6, 6.0E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))) ) t(a) GROUP BY a.col1[1]", "SELECT * FROM VALUES (31, 2.2, 4.2, 22, 4.0), (31, 1.0, 4.5, 12, 4.1), (41, 6.4, 6.2, 64, 12.0)");
        this.assertQuery("SELECT a.col1[2], SUM(a.col0), SUM(a.col1[1]), SUM(a.col2.col1) FROM (VALUES ROW(CAST(ROW(1.0, ARRAY[2, 13, 4], row(11, 4.1E0))   AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(2.0, ARRAY[2, 13, 4], row(12, 14.0E0))  AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(7.0, ARRAY[22, 33, 44], row(13, 5.0E0)) AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double))))) t(a) GROUP BY a.col1[2]", "SELECT * FROM VALUES (13, 3.0, 4, 18.1), (33, 7.0, 22, 5.0)");
        this.assertQuery("SELECT a.col2.col0, SUM(a.col2.col1) FROM (VALUES ROW(CAST(ROW(2.2, ARRAY[row(31, 4.2E0), row(22, 4.2E0)], row(5, 4.0E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(1.0, ARRAY[row(31, 4.5E0), row(12, 4.2E0)], row(3, 4.1E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(3.1, ARRAY[row(41, 3.1E0), row(32, 4.2E0)], row(6, 6.0E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(3.3, ARRAY[row(41, 3.1E0), row(32, 4.2E0)], row(6, 6.0E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))) ) t(a) GROUP BY a.col2", "SELECT * FROM VALUES (5, 4.0), (3, 4.1), (6, 12.0)");
        this.assertQuery("SELECT a.col2.col0, a.col0, SUM(a.col2.col1) FROM (VALUES ROW(CAST(ROW(1.0, ARRAY[2, 13, 4], row(11, 4.1E0))   AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(2.0, ARRAY[2, 23, 4], row(11, 14.0E0))  AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(1.5, ARRAY[2, 13, 4], row(11, 4.1E0))   AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(1.5, ARRAY[2, 13, 4], row(11, 4.1E0))   AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(7.0, ARRAY[22, 33, 44], row(13, 5.0E0)) AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double))))) t(a) WHERE a.col1[2] < 30 GROUP BY 1, 2 ORDER BY 1", "SELECT * FROM VALUES (11, 1.0, 4.1), (11, 1.5, 8.2), (11, 2.0, 14.0)");
        this.assertQuery("SELECT a[1].col0, COUNT(1) FROM (VALUES (ROW(CAST(ARRAY[row(31, 4.2E0), row(22, 4.2E0)] AS ARRAY(ROW(col0 integer, col1 double))))), (ROW(CAST(ARRAY[row(31, 4.5E0), row(12, 4.2E0)] AS ARRAY(ROW(col0 integer, col1 double))))), (ROW(CAST(ARRAY[row(41, 3.1E0), row(32, 4.2E0)] AS ARRAY(ROW(col0 integer, col1 double))))), (ROW(CAST(ARRAY[row(31, 3.1E0), row(32, 4.2E0)] AS ARRAY(ROW(col0 integer, col1 double))))) ) t(a) GROUP BY 1 ORDER BY 2 DESC", "SELECT * FROM VALUES (31, 3), (41, 1)");
    }

    @Test
    public void testTryMapTransformValueFunction() {
        MaterializedResult actual = this.computeActual("SELECT COALESCE( TRY( TRANSFORM_VALUES( id, (k, v) -> k / v ) ) , MAP() )FROM ( VALUES (MAP(ARRAY[1, 2], ARRAY[0, 0])), (MAP(ARRAY[1, 2], ARRAY[1, 2])), (MAP(ARRAY[28, 56], ARRAY[2, 4])), (MAP(ARRAY[4, 5], ARRAY[0, 0])), (MAP(ARRAY[12, 72], ARRAY[3, 6]))) AS t (id)");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)}).row(new Object[]{ImmutableMap.of()}).row(new Object[]{ImmutableMap.of((Object)1, (Object)1, (Object)2, (Object)1)}).row(new Object[]{ImmutableMap.of((Object)28, (Object)14, (Object)56, (Object)14)}).row(new Object[]{ImmutableMap.of()}).row(new Object[]{ImmutableMap.of((Object)12, (Object)4, (Object)72, (Object)12)}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testRowFieldAccessorInWindowFunction() {
        this.assertQuery("SELECT a.col0, SUM(a.col1[1].col1) OVER(PARTITION BY a.col2.col0), SUM(a.col2.col1) OVER(PARTITION BY a.col2.col0) FROM (VALUES ROW(CAST(ROW(1.0, ARRAY[row(31, 14.5E0), row(12, 4.2E0)], row(3, 4.0E0))  AS ROW(col0 double, col1 array(ROW(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(2.2, ARRAY[row(41, 13.1E0), row(32, 4.2E0)], row(6, 6.0E0))  AS ROW(col0 double, col1 array(ROW(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(2.2, ARRAY[row(41, 17.1E0), row(45, 4.2E0)], row(7, 16.0E0)) AS ROW(col0 double, col1 array(ROW(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(2.2, ARRAY[row(41, 13.1E0), row(32, 4.2E0)], row(6, 6.0E0))  AS ROW(col0 double, col1 array(ROW(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(3.1, ARRAY[row(41, 13.1E0), row(32, 4.2E0)], row(6, 6.0E0))  AS ROW(col0 double, col1 array(ROW(col0 integer, col1 double)), col2 row(col0 integer, col1 double))))) t(a) ", "SELECT * FROM VALUES (1.0, 14.5, 4.0), (2.2, 39.3, 18.0), (2.2, 39.3, 18.0), (2.2, 17.1, 16.0), (3.1, 39.3, 18.0)");
        this.assertQuery("SELECT a.col1[1].col0, SUM(a.col0) OVER(PARTITION BY a.col1[1].col0), SUM(a.col1[1].col1) OVER(PARTITION BY a.col1[1].col0), SUM(a.col2.col1) OVER(PARTITION BY a.col1[1].col0) FROM (VALUES ROW(CAST(ROW(1.0, ARRAY[row(31, 14.5E0), row(12, 4.2E0)], row(3, 4.0E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(3.1, ARRAY[row(41, 13.1E0), row(32, 4.2E0)], row(6, 6.0E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(2.2, ARRAY[row(31, 14.2E0), row(22, 5.2E0)], row(5, 4.0E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double))))) t(a) WHERE a.col1[2].col1 > a.col2.col0", "SELECT * FROM VALUES (31, 3.2, 28.7, 8.0), (31, 3.2, 28.7, 8.0)");
    }

    @Test
    public void testRowFieldAccessorInJoin() {
        this.assertQuery("SELECT t.a.col1, custkey, orderkey FROM (VALUES ROW(CAST(ROW(1, 11) AS ROW(col0 integer, col1 integer))), ROW(CAST(ROW(2, 22) AS ROW(col0 integer, col1 integer))), ROW(CAST(ROW(3, 33) AS ROW(col0 integer, col1 integer)))) t(a) INNER JOIN orders ON t.a.col0 = orders.orderkey", "SELECT * FROM VALUES (11, 370, 1), (22, 781, 2), (33, 1234, 3)");
    }

    @Test
    public void testRowCast() {
        this.assertQuery("SELECT CAST(row(1, 2) AS row(aa bigint, bb boolean)).aa", "SELECT 1");
        this.assertQuery("SELECT CAST(row(1, 2) AS row(aa bigint, bb boolean)).bb", "SELECT true");
        this.assertQuery("SELECT CAST(row(1, 2) AS row(aa bigint, bb varchar)).bb", "SELECT '2'");
        this.assertQuery("SELECT CAST(row(true, array[0, 2]) AS row(aa boolean, bb array(boolean))).bb[1]", "SELECT false");
        this.assertQuery("SELECT CAST(row(0.1, array[0, 2], row(1, 0.5)) AS row(aa bigint, bb array(boolean), cc row(dd varchar, ee varchar))).cc.ee", "SELECT '0.5'");
        this.assertQuery("SELECT CAST(array[row(0.1, array[0, 2], row(1, 0.5))] AS array<row(aa bigint, bb array(boolean), cc row(dd varchar, ee varchar))>)[1].cc.ee", "SELECT '0.5'");
    }

    @Test
    public void testDereferenceInSubquery() {
        this.assertQuery("SELECT x FROM (   SELECT a.x   FROM (VALUES 1, 2, 3) a(x)) GROUP BY x", "SELECT * FROM VALUES 1, 2, 3");
        this.assertQuery("SELECT t2.*, max(t1.b) AS max_b FROM (VALUES (1, 'a'),  (2, 'b'), (1, 'c'), (3, 'd')) t1(a, b) INNER JOIN (VALUES 1, 2, 3, 4) t2(a) ON t1.a = t2.a GROUP BY t2.a", "SELECT * FROM VALUES (1, 'c'), (2, 'b'), (3, 'd')");
        this.assertQuery("SELECT t2.*, max(t1.b1) AS max_b1 FROM (VALUES (1, 'a'),  (2, 'b'), (1, 'c'), (3, 'd')) t1(a1, b1) INNER JOIN (VALUES (1, 11, 111), (2, 22, 222), (3, 33, 333), (4, 44, 444)) t2(a2, b2, c2) ON t1.a1 = t2.a2 GROUP BY t2.a2, t2.b2, t2.c2", "SELECT * FROM VALUES (1, 11, 111, 'c'), (2, 22, 222, 'b'), (3, 33, 333, 'd')");
        this.assertQuery("SELECT custkey, orders2 FROM (   SELECT x.custkey, SUM(x.orders) + 1 orders2    FROM (       SELECT x.custkey, COUNT(x.orderkey) orders       FROM orders x       WHERE x.custkey < 100       GROUP BY x.custkey    ) x    GROUP BY x.custkey) ORDER BY custkey");
    }

    @Test
    public void testDereferenceInFunctionCall() {
        this.assertQuery("SELECT COUNT(DISTINCT custkey) FROM (   SELECT x.custkey   FROM orders x   WHERE custkey < 100 ) t");
    }

    @Test
    public void testDereferenceInComparison() {
        this.assertQuery("SELECT orders.custkey, orders.orderkey FROM orders WHERE orders.custkey > orders.orderkey AND orders.custkey < 200.3");
    }

    @Test
    public void testMissingRowFieldInGroupBy() {
        this.assertQueryFails("SELECT a.col0, count(*) FROM (VALUES ROW(cast(ROW(1, 1) AS ROW(col0 integer, col1 integer)))) t(a)", "line 1:8: 'a.col0' must be an aggregate expression or appear in GROUP BY clause");
    }

    @Test
    public void testWhereWithRowField() {
        this.assertQuery("SELECT a.col0 FROM (VALUES ROW(CAST(ROW(1, 2) AS ROW(col0 integer, col1 integer)))) AS t (a) WHERE a.col0 > 0", "SELECT 1");
        this.assertQuery("SELECT SUM(a.col0) FROM (VALUES ROW(CAST(ROW(1, 2) AS ROW(col0 integer, col1 integer)))) AS t (a) WHERE a.col0 <= 0", "SELECT null");
        this.assertQuery("SELECT a.col0 FROM (VALUES ROW(CAST(ROW(1, 2) AS ROW(col0 integer, col1 integer)))) AS t (a) WHERE a.col0 < a.col1", "SELECT 1");
        this.assertQuery("SELECT SUM(a.col0) FROM (VALUES ROW(CAST(ROW(1, 2) AS ROW(col0 integer, col1 integer)))) AS t (a) WHERE a.col0 < a.col1", "SELECT 1");
        this.assertQuery("SELECT SUM(a.col0) FROM (VALUES ROW(CAST(ROW(1, 2) AS ROW(col0 integer, col1 integer)))) AS t (a) WHERE a.col0 > a.col1", "SELECT null");
    }

    @Test
    public void testUnnest() {
        this.assertQuery("SELECT 1 FROM (VALUES (ARRAY[1])) AS t (a) CROSS JOIN UNNEST(a)", "SELECT 1");
        this.assertQuery("SELECT x[1] FROM UNNEST(ARRAY[ARRAY[1, 2, 3]]) t(x)", "SELECT 1");
        this.assertQuery("SELECT x[1][2] FROM UNNEST(ARRAY[ARRAY[ARRAY[1, 2, 3]]]) t(x)", "SELECT 2");
        this.assertQuery("SELECT x[2] FROM UNNEST(ARRAY[MAP(ARRAY[1,2], ARRAY['hello', 'hi'])]) t(x)", "SELECT 'hi'");
        this.assertQuery("SELECT * FROM UNNEST(ARRAY[1, 2, 3])", "SELECT * FROM VALUES (1), (2), (3)");
        this.assertQuery("SELECT a FROM UNNEST(ARRAY[1, 2, 3]) t(a)", "SELECT * FROM VALUES (1), (2), (3)");
        this.assertQuery("SELECT a, b FROM UNNEST(ARRAY[1, 2], ARRAY[3, 4]) t(a, b)", "SELECT * FROM VALUES (1, 3), (2, 4)");
        this.assertQuery("SELECT a, b FROM UNNEST(ARRAY[1, 2, 3], ARRAY[4, 5]) t(a, b)", "SELECT * FROM VALUES (1, 4), (2, 5), (3, NULL)");
        this.assertQuery("SELECT a FROM UNNEST(ARRAY[1, 2, 3], ARRAY[4, 5]) t(a, b)", "SELECT * FROM VALUES 1, 2, 3");
        this.assertQuery("SELECT b FROM UNNEST(ARRAY[1, 2, 3], ARRAY[4, 5]) t(a, b)", "SELECT * FROM VALUES 4, 5, NULL");
        this.assertQuery("SELECT count(*) FROM UNNEST(ARRAY[1, 2, 3], ARRAY[4, 5])", "SELECT 3");
        this.assertQuery("SELECT a FROM UNNEST(ARRAY['kittens', 'puppies']) t(a)", "SELECT * FROM VALUES ('kittens'), ('puppies')");
        this.assertQuery("WITH unioned AS ( SELECT 1 UNION ALL SELECT 2 ) SELECT * FROM unioned CROSS JOIN UNNEST(ARRAY[3]) steps (step)", "SELECT * FROM (VALUES (1, 3), (2, 3))");
        this.assertQuery("SELECT c FROM UNNEST(ARRAY[1, 2, 3], ARRAY[4, 5]) t(a, b) CROSS JOIN (values (8), (9)) t2(c)", "SELECT * FROM VALUES 8, 8, 8, 9, 9, 9");
        this.assertQuery("SELECT a.custkey, t.e FROM (SELECT custkey, ARRAY[1, 2, 3] AS my_array FROM orders ORDER BY orderkey LIMIT 1) a CROSS JOIN UNNEST(my_array) t(e)", "SELECT * FROM (SELECT custkey FROM orders ORDER BY orderkey LIMIT 1) CROSS JOIN (VALUES (1), (2), (3))");
        this.assertQuery("SELECT a.custkey, t.e FROM (SELECT custkey, ARRAY[1, 2, 3] AS my_array FROM orders ORDER BY orderkey LIMIT 1) a, UNNEST(my_array) t(e)", "SELECT * FROM (SELECT custkey FROM orders ORDER BY orderkey LIMIT 1) CROSS JOIN (VALUES (1), (2), (3))");
        this.assertQuery("SELECT * FROM UNNEST(ARRAY[0, 1]) CROSS JOIN UNNEST(ARRAY[0, 1]) CROSS JOIN UNNEST(ARRAY[0, 1])", "SELECT * FROM VALUES (0, 0, 0), (0, 0, 1), (0, 1, 0), (0, 1, 1), (1, 0, 0), (1, 0, 1), (1, 1, 0), (1, 1, 1)");
        this.assertQuery("SELECT * FROM UNNEST(ARRAY[0, 1]), UNNEST(ARRAY[0, 1]), UNNEST(ARRAY[0, 1])", "SELECT * FROM VALUES (0, 0, 0), (0, 0, 1), (0, 1, 0), (0, 1, 1), (1, 0, 0), (1, 0, 1), (1, 1, 0), (1, 1, 1)");
        this.assertQuery("SELECT a, b FROM UNNEST(MAP(ARRAY[1,2], ARRAY['cat', 'dog'])) t(a, b)", "SELECT * FROM VALUES (1, 'cat'), (2, 'dog')");
        this.assertQuery("SELECT a, b FROM UNNEST(MAP(ARRAY[1,2], ARRAY['cat', NULL])) t(a, b)", "SELECT * FROM VALUES (1, 'cat'), (2, NULL)");
        this.assertQuery("SELECT 1 FROM (VALUES (ARRAY[1])) AS t (a) CROSS JOIN UNNEST(a) WITH ORDINALITY", "SELECT 1");
        this.assertQuery("SELECT * FROM UNNEST(ARRAY[1, 2, 3]) WITH ORDINALITY", "SELECT * FROM VALUES (1, 1), (2, 2), (3, 3)");
        this.assertQuery("SELECT b FROM UNNEST(ARRAY[10, 20, 30]) WITH ORDINALITY t(a, b)", "SELECT * FROM VALUES (1), (2), (3)");
        this.assertQuery("SELECT a, b, c FROM UNNEST(ARRAY[10, 20, 30], ARRAY[4, 5]) WITH ORDINALITY t(a, b, c)", "SELECT * FROM VALUES (10, 4, 1), (20, 5, 2), (30, NULL, 3)");
        this.assertQuery("SELECT a, b FROM UNNEST(ARRAY['kittens', 'puppies']) WITH ORDINALITY t(a, b)", "SELECT * FROM VALUES ('kittens', 1), ('puppies', 2)");
        this.assertQuery("SELECT c FROM UNNEST(ARRAY[1, 2, 3], ARRAY[4, 5]) WITH ORDINALITY t(a, b, c) CROSS JOIN (values (8), (9)) t2(d)", "SELECT * FROM VALUES 1, 1, 2, 2, 3, 3");
        this.assertQuery("SELECT a.custkey, t.e, t.f FROM (SELECT custkey, ARRAY[10, 20, 30] AS my_array FROM orders ORDER BY orderkey LIMIT 1) a CROSS JOIN UNNEST(my_array) WITH ORDINALITY t(e, f)", "SELECT * FROM (SELECT custkey FROM orders ORDER BY orderkey LIMIT 1) CROSS JOIN (VALUES (10, 1), (20, 2), (30, 3))");
        this.assertQuery("SELECT a.custkey, t.e, t.f FROM (SELECT custkey, ARRAY[10, 20, 30] AS my_array FROM orders ORDER BY orderkey LIMIT 1) a, UNNEST(my_array) WITH ORDINALITY t(e, f)", "SELECT * FROM (SELECT custkey FROM orders ORDER BY orderkey LIMIT 1) CROSS JOIN (VALUES (10, 1), (20, 2), (30, 3))");
        this.assertQuery("SELECT * FROM orders, UNNEST(ARRAY[1])", "SELECT orders.*, 1 FROM orders");
        this.assertQuery("SELECT a FROM (    SELECT l.arr AS arr FROM (        SELECT orderkey, ARRAY[1,2,3] AS arr FROM orders ORDER BY orderkey LIMIT 1) l    FULL OUTER JOIN (        SELECT orderkey, ARRAY[1,2,3] AS arr FROM orders ORDER BY orderkey LIMIT 1) o    ON l.orderkey = o.orderkey) CROSS JOIN UNNEST(arr) AS t (a)", "SELECT * FROM (VALUES (1), (2), (3))");
        this.assertQueryFails("SELECT * FROM (VALUES array[2, 2]) a(x) LEFT OUTER JOIN UNNEST(x) ON true", "line .*: UNNEST on other than the right side of CROSS JOIN is not supported");
        this.assertQueryFails("SELECT * FROM (VALUES array[2, 2]) a(x) RIGHT OUTER JOIN UNNEST(x) ON true", "line .*: UNNEST on other than the right side of CROSS JOIN is not supported");
        this.assertQueryFails("SELECT * FROM (VALUES array[2, 2]) a(x) FULL OUTER JOIN UNNEST(x) ON true", "line .*: UNNEST on other than the right side of CROSS JOIN is not supported");
    }

    @Test
    public void testArrays() {
        this.assertQuery("SELECT a[1] FROM (SELECT ARRAY[orderkey] AS a FROM orders ORDER BY orderkey) t", "SELECT orderkey FROM orders");
        this.assertQuery("SELECT a[1 + CAST(round(rand()) AS BIGINT)] FROM (SELECT ARRAY[orderkey, orderkey] AS a FROM orders ORDER BY orderkey) t", "SELECT orderkey FROM orders");
        this.assertQuery("SELECT a[1] + 1 FROM (SELECT ARRAY[orderkey] AS a FROM orders ORDER BY orderkey) t", "SELECT orderkey + 1 FROM orders");
        this.assertQuery("SELECT a[1] FROM (SELECT ARRAY[orderkey + 1] AS a FROM orders ORDER BY orderkey) t", "SELECT orderkey + 1 FROM orders");
        this.assertQuery("SELECT a[1][1] FROM (SELECT ARRAY[ARRAY[orderkey + 1]] AS a FROM orders ORDER BY orderkey) t", "SELECT orderkey + 1 FROM orders");
        this.assertQuery("SELECT CARDINALITY(a) FROM (SELECT ARRAY[orderkey, orderkey + 1] AS a FROM orders ORDER BY orderkey) t", "SELECT 2 FROM orders");
    }

    @Test
    public void testArrayAgg() {
        this.assertQuery("SELECT clerk, cardinality(array_agg(orderkey)) FROM orders GROUP BY clerk", "SELECT clerk, count(*) FROM orders GROUP BY clerk");
    }

    @Test
    public void testReduceAgg() {
        this.assertQuery("SELECT x, reduce_agg(y, 1, (a, b) -> a * b, (a, b) -> a * b) FROM (VALUES (1, 5), (1, 6), (1, 7), (2, 8), (2, 9), (3, 10)) AS t(x, y) GROUP BY x", "VALUES (1, 5 * 6 * 7), (2, 8 * 9), (3, 10)");
        this.assertQuery("SELECT x, reduce_agg(y, 0, (a, b) -> a + b, (a, b) -> a + b) FROM (VALUES (1, 5), (1, 6), (1, 7), (2, 8), (2, 9), (3, 10)) AS t(x, y) GROUP BY x", "VALUES (1, 5 + 6 + 7), (2, 8 + 9), (3, 10)");
        this.assertQuery("SELECT x, reduce_agg(y, 1, (a, b) -> a * b, (a, b) -> a * b) FROM (VALUES (1, CAST(5 AS DOUBLE)), (1, 6), (1, 7), (2, 8), (2, 9), (3, 10)) AS t(x, y) GROUP BY x", "VALUES (1, CAST(5 AS DOUBLE) * 6 * 7), (2, 8 * 9), (3, 10)");
        this.assertQuery("SELECT x, reduce_agg(y, 0, (a, b) -> a + b, (a, b) -> a + b) FROM (VALUES (1, CAST(5 AS DOUBLE)), (1, 6), (1, 7), (2, 8), (2, 9), (3, 10)) AS t(x, y) GROUP BY x", "VALUES (1, CAST(5 AS DOUBLE) + 6 + 7), (2, 8 + 9), (3, 10)");
    }

    @Test
    public void testRows() {
        this.assertQuery("SELECT JSON_FORMAT(CAST(ROW(1 + 2, CONCAT('a', 'b')) AS JSON))", "SELECT '[3,\"ab\"]'");
        this.assertQuery("SELECT JSON_FORMAT(CAST(ROW(a + b) AS JSON)) FROM (VALUES (1, 2)) AS t(a, b)", "SELECT '[3]'");
        this.assertQuery("SELECT JSON_FORMAT(CAST(ROW(1, ROW(9, a, ARRAY[], NULL), ROW(1, 2)) AS JSON)) FROM (VALUES ('a')) t(a)", "SELECT '[1,[9,\"a\",[],null],[1,2]]'");
        this.assertQuery("SELECT JSON_FORMAT(CAST(ROW(ROW(ROW(ROW(ROW(a, b), c), d), e), f) AS JSON)) FROM (VALUES (ROW(0, 1), 2, '3', NULL, ARRAY[5], ARRAY[])) t(a, b, c, d, e, f)", "SELECT '[[[[[[0,1],2],\"3\"],null],[5]],[]]'");
        this.assertQuery("SELECT JSON_FORMAT(CAST(ARRAY_AGG(ROW(a, b)) AS JSON)) FROM (VALUES (1, 2), (3, 4), (5, 6)) t(a, b)", "SELECT '[[1,2],[3,4],[5,6]]'");
        this.assertQuery("SELECT CONTAINS(ARRAY_AGG(ROW(a, b)), ROW(1, 2)) FROM (VALUES (1, 2), (3, 4), (5, 6)) t(a, b)", "SELECT TRUE");
        this.assertQuery("SELECT JSON_FORMAT(CAST(ARRAY_AGG(ROW(c, d)) AS JSON)) FROM (VALUES (ARRAY[1, 3, 5], ARRAY[2, 4, 6])) AS t(a, b) CROSS JOIN UNNEST(a, b) AS u(c, d)", "SELECT '[[1,2],[3,4],[5,6]]'");
        this.assertQuery("SELECT JSON_FORMAT(CAST(ROW(x, y, z) AS JSON)) FROM (VALUES ROW(1, NULL, '3')) t(x,y,z)", "SELECT '[1,null,\"3\"]'");
        this.assertQuery("SELECT JSON_FORMAT(CAST(ROW(x, y, z) AS JSON)) FROM (VALUES ROW(1, CAST(NULL AS INTEGER), '3')) t(x,y,z)", "SELECT '[1,null,\"3\"]'");
    }

    @Test
    public void testMaps() {
        this.assertQuery("SELECT m[max_key] FROM (SELECT map_agg(orderkey, orderkey) m, max(orderkey) max_key FROM orders)", "SELECT max(orderkey) FROM orders");
        this.assertQuery("SELECT JSON_FORMAT(CAST(TRY(MAP(ARRAY[NULL], ARRAY[x])) AS JSON)) FROM (VALUES 1, 2) t(x)", "SELECT * FROM (VALUES NULL, NULL)");
    }

    @Test
    public void testValues() {
        this.assertQuery("VALUES 1, 2, 3, 4");
        this.assertQuery("VALUES 1, 3, 2, 4 ORDER BY 1", "SELECT * FROM (VALUES 1, 3, 2, 4) ORDER BY 1");
        this.assertQuery("VALUES (1.1, 2, 'foo'), (sin(3.3), 2+2, 'bar')");
        this.assertQuery("VALUES (1.1, 2), (sin(3.3), 2+2) ORDER BY 1", "VALUES (sin(3.3), 2+2), (1.1, 2)");
        this.assertQuery("VALUES (1.1, 2), (sin(3.3), 2+2) LIMIT 1", "VALUES (1.1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1.1, 2), (sin(3.3), 2+2))");
        this.assertQuery("SELECT 1.1 in (VALUES (1.1), (2.2))", "VALUES (TRUE)");
        this.assertQuery("WITH a AS (VALUES (1.1, 2), (sin(3.3), 2+2)) SELECT * FROM a", "VALUES (1.1, 2), (sin(3.3), 2+2)");
        this.assertQuery("VALUES 1, 2.2, 3, 4.4");
        this.assertQuery("VALUES (1, 2), (3.3, 4.4)");
        this.assertQuery("VALUES true, 1.0 in (1, 2, 3)");
    }

    @Test
    public void testSpecialFloatingPointValues() {
        MaterializedResult actual = this.computeActual("SELECT nan(), infinity(), -infinity()");
        MaterializedRow row = (MaterializedRow)Iterables.getOnlyElement((Iterable)actual.getMaterializedRows());
        Assert.assertEquals((Object)row.getField(0), (Object)Double.NaN);
        Assert.assertEquals((Object)row.getField(1), (Object)Double.POSITIVE_INFINITY);
        Assert.assertEquals((Object)row.getField(2), (Object)Double.NEGATIVE_INFINITY);
    }

    @Test
    public void testMaxMinStringWithNulls() {
        this.assertQuery("SELECT custkey, MAX(NULLIF(orderstatus, 'O')), MIN(NULLIF(orderstatus, 'O')) FROM orders GROUP BY custkey");
    }

    @Test
    public void testApproxPercentile() {
        MaterializedResult raw = this.computeActual("SELECT orderstatus, orderkey, totalprice FROM orders");
        ArrayListMultimap orderKeyByStatus = ArrayListMultimap.create();
        ArrayListMultimap totalPriceByStatus = ArrayListMultimap.create();
        for (MaterializedRow row : raw.getMaterializedRows()) {
            orderKeyByStatus.put((Object)((String)row.getField(0)), (Object)((Number)row.getField(1)).longValue());
            totalPriceByStatus.put((Object)((String)row.getField(0)), (Object)((Double)row.getField(2)));
        }
        MaterializedResult actual = this.computeActual("SELECT orderstatus,    approx_percentile(orderkey, 0.5),    approx_percentile(totalprice, 0.5),   approx_percentile(orderkey, 2, 0.5),   approx_percentile(totalprice, 2, 0.5)\nFROM orders\nGROUP BY orderstatus");
        for (MaterializedRow row : actual.getMaterializedRows()) {
            String status = (String)row.getField(0);
            Long orderKey = ((Number)row.getField(1)).longValue();
            Double totalPrice = (Double)row.getField(2);
            Long orderKeyWeighted = ((Number)row.getField(3)).longValue();
            Double totalPriceWeighted = (Double)row.getField(4);
            List orderKeys = Ordering.natural().sortedCopy((Iterable)orderKeyByStatus.get((Object)status));
            List totalPrices = Ordering.natural().sortedCopy((Iterable)totalPriceByStatus.get((Object)status));
            org.testng.Assert.assertTrue((orderKey >= (Long)orderKeys.get((int)(0.49 * (double)orderKeys.size())) ? 1 : 0) != 0);
            org.testng.Assert.assertTrue((orderKey <= (Long)orderKeys.get((int)(0.51 * (double)orderKeys.size())) ? 1 : 0) != 0);
            org.testng.Assert.assertTrue((orderKeyWeighted >= (Long)orderKeys.get((int)(0.49 * (double)orderKeys.size())) ? 1 : 0) != 0);
            org.testng.Assert.assertTrue((orderKeyWeighted <= (Long)orderKeys.get((int)(0.51 * (double)orderKeys.size())) ? 1 : 0) != 0);
            org.testng.Assert.assertTrue((totalPrice >= (Double)totalPrices.get((int)(0.49 * (double)totalPrices.size())) ? 1 : 0) != 0);
            org.testng.Assert.assertTrue((totalPrice <= (Double)totalPrices.get((int)(0.51 * (double)totalPrices.size())) ? 1 : 0) != 0);
            org.testng.Assert.assertTrue((totalPriceWeighted >= (Double)totalPrices.get((int)(0.49 * (double)totalPrices.size())) ? 1 : 0) != 0);
            org.testng.Assert.assertTrue((totalPriceWeighted <= (Double)totalPrices.get((int)(0.51 * (double)totalPrices.size())) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testComplexQuery() {
        this.assertQueryOrdered("SELECT sum(orderkey), row_number() OVER (ORDER BY orderkey) FROM orders WHERE orderkey <= 10 GROUP BY orderkey HAVING sum(orderkey) >= 3 ORDER BY orderkey DESC LIMIT 3", "VALUES (7, 5), (6, 4), (5, 3)");
    }

    @Test
    public void testWhereNull() {
        this.assertQuery("SELECT custkey FROM orders WHERE custkey = custkey AND CAST(nullif(custkey, custkey) AS boolean) AND CAST(nullif(custkey, custkey) AS boolean)");
    }

    @Test
    public void testJoinWithMultiFieldGroupBy() {
        this.assertQuery("SELECT orderstatus FROM lineitem JOIN (SELECT DISTINCT orderkey, orderstatus FROM orders) T on lineitem.orderkey = T.orderkey");
    }

    @Test
    public void testDistinctMultipleFields() {
        this.assertQuery("SELECT DISTINCT custkey, orderstatus FROM orders");
    }

    @Test
    public void testDistinctJoin() {
        this.assertQuery("SELECT COUNT(DISTINCT CAST(b.quantity AS BIGINT)), a.orderstatus FROM orders a JOIN lineitem b ON a.orderkey = b.orderkey GROUP BY a.orderstatus");
    }

    @Test
    public void testArithmeticNegation() {
        this.assertQuery("SELECT -custkey FROM orders");
    }

    @Test
    public void testDistinct() {
        this.assertQuery("SELECT DISTINCT custkey FROM orders");
    }

    @Test
    public void testDistinctHaving() {
        this.assertQuery("SELECT COUNT(DISTINCT clerk) AS count FROM orders GROUP BY orderdate HAVING COUNT(DISTINCT clerk) > 1");
    }

    @Test
    public void testDistinctWindow() {
        MaterializedResult actual = this.computeActual("SELECT RANK() OVER (PARTITION BY orderdate ORDER BY COUNT(DISTINCT clerk)) rnk FROM orders GROUP BY orderdate, custkey ORDER BY rnk LIMIT 1");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1L}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testDistinctLimit() {
        this.assertQuery("SELECT DISTINCT orderstatus, custkey FROM (SELECT orderstatus, custkey FROM orders ORDER BY orderkey LIMIT 10) LIMIT 10");
        this.assertQuery("SELECT COUNT(*) FROM (SELECT DISTINCT orderstatus, custkey FROM orders LIMIT 10)");
        this.assertQuery("SELECT DISTINCT custkey, orderstatus FROM orders WHERE custkey = 1268 LIMIT 2");
        this.assertQuery("SELECT DISTINCT x FROM (VALUES 1) t(x) JOIN (VALUES 10, 20) u(a) ON t.x < u.a LIMIT 100", "SELECT 1");
    }

    @Test
    public void testDistinctWithOrderBy() {
        this.assertQueryOrdered("SELECT DISTINCT custkey FROM orders ORDER BY custkey LIMIT 10");
    }

    @Test
    public void testDistinctWithOrderByNotInSelect() {
        this.assertQueryFails("SELECT DISTINCT custkey FROM orders ORDER BY orderkey LIMIT 10", "line 1:1: For SELECT DISTINCT, ORDER BY expressions must appear in select list");
    }

    @Test
    public void testGroupByOrderByLimit() {
        this.assertQueryOrdered("SELECT custkey, SUM(totalprice) FROM orders GROUP BY custkey ORDER BY SUM(totalprice) DESC LIMIT 10");
    }

    @Test
    public void testLimitZero() {
        this.assertQuery("SELECT custkey, totalprice FROM orders LIMIT 0");
    }

    @Test
    public void testLimitAll() {
        this.assertQuery("SELECT custkey, totalprice FROM orders LIMIT ALL", "SELECT custkey, totalprice FROM orders");
    }

    @Test
    public void testRepeatedAggregations() {
        this.assertQuery("SELECT SUM(orderkey), SUM(orderkey) FROM orders");
    }

    @Test
    public void testRepeatedOutputs() {
        this.assertQuery("SELECT orderkey a, orderkey b FROM orders WHERE orderstatus = 'F'");
    }

    @Test
    public void testRepeatedOutputs2() {
        this.assertQuery("SELECT orderdate, orderdate, orderkey FROM orders");
    }

    @Test
    public void testLimit() {
        MaterializedResult actual = this.computeActual("SELECT orderkey FROM orders LIMIT 10");
        MaterializedResult all = this.computeExpected("SELECT orderkey FROM orders", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testLimitWithAggregation() {
        MaterializedResult actual = this.computeActual("SELECT custkey, SUM(CAST(totalprice * 100 AS BIGINT)) FROM orders GROUP BY custkey LIMIT 10");
        MaterializedResult all = this.computeExpected("SELECT custkey, SUM(CAST(totalprice * 100 AS BIGINT)) FROM orders GROUP BY custkey", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testLimitInInlineView() {
        MaterializedResult actual = this.computeActual("SELECT orderkey FROM (SELECT orderkey FROM orders LIMIT 100) T LIMIT 10");
        MaterializedResult all = this.computeExpected("SELECT orderkey FROM orders", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testLimitWithJoin() {
        MaterializedResult actual = this.computeActual("SELECT o1.orderkey, o2.orderkey FROM orders o1 JOIN orders o2 on o1.orderkey = o2.orderkey LIMIT 10");
        MaterializedResult all = this.computeActual("SELECT o1.orderkey, o2.orderkey FROM orders o1 JOIN  orders o2 on o1.orderkey = o2.orderkey");
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
        actual = this.computeActual("SELECT o1.orderkey, o2.orderkey FROM orders o1 LEFT OUTER JOIN orders o2 on o1.orderkey = o2.orderkey LIMIT 10");
        all = this.computeActual("SELECT o1.orderkey, o2.orderkey FROM orders o1 LEFT OUTER JOIN orders o2 on o1.orderkey = o2.orderkey");
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
        actual = this.computeActual("SELECT o1.orderkey, o2.orderkey FROM orders o1 RIGHT OUTER JOIN orders o2 on o1.orderkey = o2.orderkey LIMIT 10");
        all = this.computeActual("SELECT o1.orderkey, o2.orderkey FROM orders o1 RIGHT OUTER JOIN orders o2 on o1.orderkey = o2.orderkey");
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
        actual = this.computeActual("SELECT o1.orderkey, o2.orderkey FROM orders o1 FULL OUTER JOIN orders o2 on o1.orderkey = o2.orderkey LIMIT 10");
        all = this.computeActual("SELECT o1.orderkey, o2.orderkey FROM orders o1 FULL OUTER JOIN orders o2 on o1.orderkey = o2.orderkey");
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testCountAll() {
        this.assertQuery("SELECT COUNT(*) FROM orders");
        this.assertQuery("SELECT COUNT(42) FROM orders", "SELECT COUNT(*) FROM orders");
        this.assertQuery("SELECT COUNT(42 + 42) FROM orders", "SELECT COUNT(*) FROM orders");
        this.assertQuery("SELECT COUNT(null) FROM orders", "SELECT 0");
    }

    @Test
    public void testCountColumn() {
        this.assertQuery("SELECT COUNT(orderkey) FROM orders");
        this.assertQuery("SELECT COUNT(orderstatus) FROM orders");
        this.assertQuery("SELECT COUNT(orderdate) FROM orders");
        this.assertQuery("SELECT COUNT(1) FROM orders");
        this.assertQuery("SELECT COUNT(NULLIF(orderstatus, 'F')) FROM orders");
        this.assertQuery("SELECT COUNT(CAST(NULL AS BIGINT)) FROM orders");
    }

    @Test
    public void testWildcard() {
        this.assertQuery("SELECT * FROM orders");
    }

    @Test
    public void testMultipleWildcards() {
        this.assertQuery("SELECT *, 123, * FROM orders");
    }

    @Test
    public void testMixedWildcards() {
        this.assertQuery("SELECT *, orders.*, orderkey FROM orders");
    }

    @Test
    public void testQualifiedWildcardFromAlias() {
        this.assertQuery("SELECT T.* FROM orders T");
    }

    @Test
    public void testQualifiedWildcardFromInlineView() {
        this.assertQuery("SELECT T.* FROM (SELECT orderkey + custkey FROM orders) T");
    }

    @Test
    public void testQualifiedWildcard() {
        this.assertQuery("SELECT orders.* FROM orders");
    }

    @Test
    public void testAverageAll() {
        this.assertQuery("SELECT AVG(totalprice) FROM orders");
    }

    @Test
    public void testVariance() {
        this.assertQuery("SELECT VAR_SAMP(custkey) FROM orders");
        this.assertQuery("SELECT VAR_SAMP(custkey) FROM (SELECT custkey FROM orders ORDER BY custkey LIMIT 2) T");
        this.assertQuery("SELECT VAR_SAMP(custkey) FROM (SELECT custkey FROM orders ORDER BY custkey LIMIT 1) T");
        this.assertQuery("SELECT VAR_SAMP(custkey) FROM (SELECT custkey FROM orders LIMIT 0) T");
        this.assertQuery("SELECT VAR_SAMP(totalprice) FROM orders");
        this.assertQuery("SELECT VAR_SAMP(totalprice) FROM (SELECT totalprice FROM orders ORDER BY totalprice LIMIT 2) T");
        this.assertQuery("SELECT VAR_SAMP(totalprice) FROM (SELECT totalprice FROM orders ORDER BY totalprice LIMIT 1) T");
        this.assertQuery("SELECT VAR_SAMP(totalprice) FROM (SELECT totalprice FROM orders LIMIT 0) T");
    }

    @Test
    public void testVariancePop() {
        this.assertQuery("SELECT VAR_POP(custkey) FROM orders");
        this.assertQuery("SELECT VAR_POP(custkey) FROM (SELECT custkey FROM orders ORDER BY custkey LIMIT 2) T");
        this.assertQuery("SELECT VAR_POP(custkey) FROM (SELECT custkey FROM orders ORDER BY custkey LIMIT 1) T");
        this.assertQuery("SELECT VAR_POP(custkey) FROM (SELECT custkey FROM orders LIMIT 0) T");
        this.assertQuery("SELECT VAR_POP(totalprice) FROM orders");
        this.assertQuery("SELECT VAR_POP(totalprice) FROM (SELECT totalprice FROM orders ORDER BY totalprice LIMIT 2) T");
        this.assertQuery("SELECT VAR_POP(totalprice) FROM (SELECT totalprice FROM orders ORDER BY totalprice LIMIT 1) T");
        this.assertQuery("SELECT VAR_POP(totalprice) FROM (SELECT totalprice FROM orders LIMIT 0) T");
    }

    @Test
    public void testStdDev() {
        this.assertQuery("SELECT STDDEV_SAMP(custkey) FROM orders");
        this.assertQuery("SELECT STDDEV_SAMP(custkey) FROM (SELECT custkey FROM orders ORDER BY custkey LIMIT 2) T");
        this.assertQuery("SELECT STDDEV_SAMP(custkey) FROM (SELECT custkey FROM orders ORDER BY custkey LIMIT 1) T");
        this.assertQuery("SELECT STDDEV_SAMP(custkey) FROM (SELECT custkey FROM orders LIMIT 0) T");
        this.assertQuery("SELECT STDDEV_SAMP(totalprice) FROM orders");
        this.assertQuery("SELECT STDDEV_SAMP(totalprice) FROM (SELECT totalprice FROM orders ORDER BY totalprice LIMIT 2) T");
        this.assertQuery("SELECT STDDEV_SAMP(totalprice) FROM (SELECT totalprice FROM orders ORDER BY totalprice LIMIT 1) T");
        this.assertQuery("SELECT STDDEV_SAMP(totalprice) FROM (SELECT totalprice FROM orders LIMIT 0) T");
    }

    @Test
    public void testStdDevPop() {
        this.assertQuery("SELECT STDDEV_POP(custkey) FROM orders");
        this.assertQuery("SELECT STDDEV_POP(custkey) FROM (SELECT custkey FROM orders ORDER BY custkey LIMIT 2) T");
        this.assertQuery("SELECT STDDEV_POP(custkey) FROM (SELECT custkey FROM orders ORDER BY custkey LIMIT 1) T");
        this.assertQuery("SELECT STDDEV_POP(custkey) FROM (SELECT custkey FROM orders LIMIT 0) T");
        this.assertQuery("SELECT STDDEV_POP(totalprice) FROM orders");
        this.assertQuery("SELECT STDDEV_POP(totalprice) FROM (SELECT totalprice FROM orders ORDER BY totalprice LIMIT 2) T");
        this.assertQuery("SELECT STDDEV_POP(totalprice) FROM (SELECT totalprice FROM orders ORDER BY totalprice LIMIT 1) T");
        this.assertQuery("SELECT STDDEV_POP(totalprice) FROM (SELECT totalprice FROM orders LIMIT 0) T");
    }

    @Test
    public void testJoinCoercion() {
        this.assertQuery("SELECT COUNT(*) FROM orders t JOIN (SELECT * FROM orders LIMIT 1) t2 ON sin(t2.custkey) = 0");
    }

    @Test
    public void testJoinCoercionOnEqualityComparison() {
        this.assertQuery("SELECT o.clerk, avg(o.shippriority), COUNT(l.linenumber) FROM orders o LEFT OUTER JOIN lineitem l ON o.orderkey=l.orderkey AND o.shippriority=1 GROUP BY o.clerk");
    }

    @Test
    public void testRollupOverUnion() {
        this.assertQuery("SELECT orderstatus, sum(orderkey)\nFROM (SELECT orderkey, orderstatus\n      FROM orders\n      UNION ALL\n      SELECT orderkey, orderstatus\n      FROM orders) x\nGROUP BY ROLLUP (orderstatus)", "VALUES ('P', 21470000),\n('O', 439774330),\n('F', 438500670),\n(NULL, 899745000)");
        this.assertQuery("SELECT regionkey, count(*) FROM (   SELECT regionkey FROM nation    UNION ALL    SELECT * FROM (VALUES 2, 100) t(regionkey)) GROUP BY ROLLUP (regionkey)", "SELECT * FROM (VALUES  (0, 5), (1, 5), (2, 6), (3, 5), (4, 5), (100, 1), (NULL, 27))");
    }

    @Test
    public void testGrouping() {
        this.assertQuery("SELECT a, b AS t, sum(c), grouping(a, b) + grouping(a) FROM (VALUES ('h', 'j', 11), ('k', 'l', 7)) AS t (a, b, c) GROUP BY GROUPING SETS ( (a), (b)) ORDER BY grouping(b) ASC", "VALUES (NULL, 'j', 11, 3), (NULL, 'l', 7, 3), ('h', NULL, 11, 1), ('k', NULL, 7, 1)");
        this.assertQuery("SELECT a, sum(b), grouping(a) FROM (VALUES ('h', 11, 0), ('k', 7, 0)) AS t (a, b, c) GROUP BY GROUPING SETS (a)", "VALUES ('h', 11, 0), ('k', 7, 0)");
        this.assertQuery("SELECT a, b, sum(c), grouping(a, b) FROM (VALUES ('h', 'j', 11), ('k', 'l', 7) ) AS t (a, b, c) GROUP BY GROUPING SETS ( (a), (b)) HAVING grouping(a, b) > 1 ", "VALUES (NULL, 'j', 11, 2), (NULL, 'l', 7, 2)");
        this.assertQuery("SELECT a, grouping(a) * 1.0 FROM (VALUES (1) ) AS t (a) GROUP BY a", "VALUES (1, 0.0)");
        this.assertQuery("SELECT a, grouping(a), grouping(a) FROM (VALUES (1) ) AS t (a) GROUP BY a", "VALUES (1, 0, 0)");
        this.assertQuery("SELECT grouping(a) FROM (VALUES ('h', 'j', 11), ('k', 'l', 7)) AS t (a, b, c) GROUP BY GROUPING SETS (a,c), c*2", "VALUES (0), (1), (0), (1)");
    }

    @Test
    public void testGroupingWithFortyArguments() {
        String fortyLetterSequence = "aa, ab, ac, ad, ae, af, ag, ah, ai, aj, ak, al, am, an, ao, ap, aq, ar, asa, at, au, av, aw, ax, ay, az, ba, bb, bc, bd, be, bf, bg, bh, bi, bj, bk, bl, bm, bn";
        String fortyIntegers = "1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40";
        String groupingSet1 = "at, ab, am, bg, bn, ai, an";
        String groupingSet2 = "bb, ad, ae, bc, be, aj";
        String query = String.format("SELECT grouping(%s) FROM (VALUES (%s)) AS t(%s) GROUP BY GROUPING SETS ((%s), (%s), (%s))", fortyLetterSequence, fortyIntegers, fortyLetterSequence, fortyLetterSequence, groupingSet1, groupingSet2);
        this.assertQuery(query, "VALUES (0), (822283861886), (995358664191)");
    }

    @Test
    public void testGroupingInWindowFunction() {
        this.assertQuery("SELECT orderkey, custkey, sum(totalprice), grouping(orderkey)+grouping(custkey) AS g,        rank() OVER (PARTITION BY grouping(orderkey)+grouping(custkey),        CASE WHEN grouping(orderkey) = 0 THEN custkey END ORDER BY orderkey ASC) AS r FROM orders GROUP BY ROLLUP (orderkey, custkey) ORDER BY orderkey, custkey LIMIT 10", "VALUES (1, 370, 172799.49, 0, 1),        (1, NULL, 172799.49, 1, 1),        (2, 781, 38426.09, 0, 1),        (2, NULL, 38426.09, 1, 2),        (3, 1234, 205654.30, 0, 1),        (3, NULL, 205654.30, 1, 3),        (4, 1369, 56000.91, 0, 1),        (4, NULL, 56000.91, 1, 4),        (5, 445, 105367.67, 0, 1),        (5, NULL, 105367.67, 1, 5)");
    }

    @Test
    public void testGroupingInTableSubquery() {
        this.assertQuery("SELECT orderkey, custkey, sum(agg_price) AS outer_sum, grouping(orderkey, custkey), g FROM     (SELECT orderkey, custkey, sum(totalprice) AS agg_price, grouping(custkey, orderkey) AS g         FROM orders         GROUP BY orderkey, custkey         ORDER BY agg_price ASC         LIMIT 5) AS t GROUP BY GROUPING SETS ((orderkey, custkey), g) ORDER BY outer_sum", "VALUES (35271, 334, 874.89, 0, NULL),        (28647, 1351, 924.33, 0, NULL),        (58145, 862, 929.03, 0, NULL),        (8354, 634, 974.04, 0, NULL),        (37415, 301, 986.63, 0, NULL),        (NULL, NULL, 4688.92, 3, 0)");
        this.assertQuery("SELECT orderkey, custkey, g, sum(agg_price) AS outer_sum, grouping(orderkey, custkey) FROM     (SELECT orderkey, custkey, sum(totalprice) AS agg_price, grouping(custkey, orderkey) AS g      FROM orders      GROUP BY GROUPING SETS ((custkey), (orderkey))      ORDER BY agg_price ASC      LIMIT 5) AS t GROUP BY orderkey, custkey, g", "VALUES (28647, NULL, 2, 924.33, 0),        (8354, NULL, 2, 974.04, 0),        (37415, NULL, 2, 986.63, 0),        (58145, NULL, 2, 929.03, 0),        (35271, NULL, 2, 874.89, 0)");
        this.assertQuery("SELECT orderkey, custkey, sum(agg_price) AS outer_sum, grouping(orderkey, custkey) FROM    (SELECT orderkey, custkey, sum(totalprice) AS agg_price     FROM orders     GROUP BY GROUPING SETS ((custkey), (orderkey))     ORDER BY agg_price ASC NULLS FIRST) AS t GROUP BY orderkey, custkey ORDER BY outer_sum ASC NULLS FIRST LIMIT 5", "VALUES (35271, NULL, 874.89, 0),        (28647, NULL, 924.33, 0),        (58145, NULL, 929.03, 0),        (8354,  NULL, 974.04, 0),        (37415, NULL, 986.63, 0)");
    }

    @Test
    public void testIntersect() {
        this.assertQuery("SELECT regionkey FROM nation WHERE nationkey < 7 INTERSECT SELECT regionkey FROM nation WHERE nationkey > 21");
        this.assertQuery("SELECT regionkey FROM nation WHERE nationkey < 7 INTERSECT DISTINCT SELECT regionkey FROM nation WHERE nationkey > 21", "VALUES 1, 3");
        this.assertQuery("WITH wnation AS (SELECT nationkey, regionkey FROM nation) SELECT regionkey FROM wnation WHERE nationkey < 7 INTERSECT SELECT regionkey FROM wnation WHERE nationkey > 21", "VALUES 1, 3");
        this.assertQuery("SELECT num FROM (SELECT 1 AS num FROM nation WHERE nationkey=10 INTERSECT SELECT 1 FROM nation WHERE nationkey=20) T");
        this.assertQuery("SELECT nationkey, nationkey / 2 FROM (SELECT nationkey FROM nation WHERE nationkey < 10 INTERSECT SELECT nationkey FROM nation WHERE nationkey > 4) T WHERE nationkey % 2 = 0");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 INTERSECT SELECT regionkey FROM nation WHERE nationkey > 21) UNION SELECT 4");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 UNION SELECT regionkey FROM nation WHERE nationkey > 21) INTERSECT SELECT 1");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 INTERSECT SELECT regionkey FROM nation WHERE nationkey > 21) UNION ALL SELECT 3");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 INTERSECT SELECT regionkey FROM nation WHERE nationkey > 21) UNION ALL SELECT 3");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) INTERSECT SELECT * FROM (VALUES 1.0, 2)", "VALUES 1.0, 2.0");
        this.assertQuery("SELECT NULL, NULL INTERSECT SELECT NULL, NULL FROM nation");
        MaterializedResult emptyResult = this.computeActual("SELECT 100 INTERSECT (SELECT regionkey FROM nation WHERE nationkey <10)");
        Assert.assertEquals((int)emptyResult.getMaterializedRows().size(), (int)0);
    }

    @Test
    public void testIntersectWithAggregation() {
        this.assertQuery("SELECT COUNT(*) FROM nation INTERSECT SELECT COUNT(regionkey) FROM nation HAVING SUM(regionkey) IS NOT NULL");
        this.assertQuery("SELECT SUM(nationkey), COUNT(name) FROM (SELECT nationkey,name FROM nation INTERSECT SELECT regionkey, name FROM nation) n");
        this.assertQuery("SELECT COUNT(*) * 2 FROM nation INTERSECT (SELECT SUM(nationkey) FROM nation GROUP BY regionkey ORDER BY 1 LIMIT 2)");
        this.assertQuery("SELECT COUNT(a) FROM (SELECT nationkey AS a FROM (SELECT nationkey FROM nation INTERSECT SELECT regionkey FROM nation) n1 INTERSECT SELECT regionkey FROM nation) n2");
        this.assertQuery("SELECT COUNT(*), SUM(2), regionkey FROM (SELECT nationkey, regionkey FROM nation INTERSECT SELECT regionkey, regionkey FROM nation) n GROUP BY regionkey");
        this.assertQuery("SELECT COUNT(*) FROM (SELECT nationkey FROM nation INTERSECT SELECT 2) n1 INTERSECT SELECT regionkey FROM nation");
    }

    @Test
    public void testIntersectAllFails() {
        this.assertQueryFails("SELECT * FROM (VALUES 1, 2, 3, 4) INTERSECT ALL SELECT * FROM (VALUES 3, 4)", "line 1:35: INTERSECT ALL not yet implemented");
    }

    @Test
    public void testExcept() {
        this.assertQuery("SELECT regionkey FROM nation WHERE nationkey < 7 EXCEPT SELECT regionkey FROM nation WHERE nationkey > 21");
        this.assertQuery("SELECT regionkey FROM nation WHERE nationkey < 7 EXCEPT DISTINCT SELECT regionkey FROM nation WHERE nationkey > 21", "VALUES 0, 4");
        this.assertQuery("WITH wnation AS (SELECT nationkey, regionkey FROM nation) SELECT regionkey FROM wnation WHERE nationkey < 7 EXCEPT SELECT regionkey FROM wnation WHERE nationkey > 21", "VALUES 0, 4");
        this.assertQuery("SELECT num FROM (SELECT 1 AS num FROM nation WHERE nationkey=10 EXCEPT SELECT 2 FROM nation WHERE nationkey=20) T");
        this.assertQuery("SELECT nationkey, nationkey / 2 FROM (SELECT nationkey FROM nation WHERE nationkey < 10 EXCEPT SELECT nationkey FROM nation WHERE nationkey > 4) T WHERE nationkey % 2 = 0");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 EXCEPT SELECT regionkey FROM nation WHERE nationkey > 21) UNION SELECT 3");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 UNION SELECT regionkey FROM nation WHERE nationkey > 21) EXCEPT SELECT 1");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 EXCEPT SELECT regionkey FROM nation WHERE nationkey > 21) UNION ALL SELECT 4");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) EXCEPT SELECT * FROM (VALUES 3.0, 2)");
        this.assertQuery("SELECT NULL, NULL EXCEPT SELECT NULL, NULL FROM nation");
        this.assertQuery("(SELECT * FROM (VALUES 1) EXCEPT SELECT * FROM (VALUES 0))EXCEPT (SELECT * FROM (VALUES 1) EXCEPT SELECT * FROM (VALUES 1))");
        MaterializedResult emptyResult = this.computeActual("SELECT 0 EXCEPT (SELECT regionkey FROM nation WHERE nationkey <10)");
        Assert.assertEquals((int)emptyResult.getMaterializedRows().size(), (int)0);
    }

    @Test
    public void testExceptWithAggregation() {
        this.assertQuery("SELECT COUNT(*) FROM nation EXCEPT SELECT COUNT(regionkey) FROM nation WHERE regionkey < 3 HAVING SUM(regionkey) IS NOT NULL");
        this.assertQuery("SELECT SUM(nationkey), COUNT(name) FROM (SELECT nationkey, name FROM nation WHERE nationkey < 6 EXCEPT SELECT regionkey, name FROM nation) n");
        this.assertQuery("(SELECT SUM(nationkey) FROM nation GROUP BY regionkey ORDER BY 1 LIMIT 2) EXCEPT SELECT COUNT(*) * 2 FROM nation");
        this.assertQuery("SELECT COUNT(a) FROM (SELECT nationkey AS a FROM (SELECT nationkey FROM nation EXCEPT SELECT regionkey FROM nation) n1 EXCEPT SELECT regionkey FROM nation) n2");
        this.assertQuery("SELECT COUNT(*), SUM(2), regionkey FROM (SELECT nationkey, regionkey FROM nation EXCEPT SELECT regionkey, regionkey FROM nation) n GROUP BY regionkey HAVING regionkey < 3");
        this.assertQuery("SELECT COUNT(*) FROM (SELECT nationkey FROM nation EXCEPT SELECT 10) n1 EXCEPT SELECT regionkey FROM nation");
    }

    @Test
    public void testExceptAllFails() {
        this.assertQueryFails("SELECT * FROM (VALUES 1, 2, 3, 4) EXCEPT ALL SELECT * FROM (VALUES 3, 4)", "line 1:35: EXCEPT ALL not yet implemented");
    }

    @Test
    public void testSelectWithComparison() {
        this.assertQuery("SELECT orderkey FROM lineitem WHERE tax < discount");
    }

    @Test
    public void testInlineView() {
        this.assertQuery("SELECT orderkey, custkey FROM (SELECT orderkey, custkey FROM orders) U");
    }

    @Test
    public void testAliasedInInlineView() {
        this.assertQuery("SELECT x, y FROM (SELECT orderkey x, custkey y FROM orders) U");
    }

    @Test
    public void testInlineViewWithProjections() {
        this.assertQuery("SELECT x + 1, y FROM (SELECT orderkey * 10 x, custkey y FROM orders) u");
    }

    @Test
    public void testJoinWithLessThanInJoinClause() {
        this.assertQuery("SELECT n.nationkey, r.regionkey FROM region r JOIN nation n ON n.regionkey = r.regionkey AND n.name < r.name");
        this.assertQuery("SELECT l.suppkey, n.nationkey, l.partkey, n.regionkey FROM nation n JOIN lineitem l ON l.suppkey = n.nationkey AND l.partkey < n.regionkey");
        this.assertQuery("SELECT b FROM nation n, (VALUES (0, CAST(-1 AS BIGINT)), (0, NULL), (0, CAST(0 AS BIGINT))) t(a, b) WHERE n.regionkey - 100 < t.b AND n.nationkey = t.a", "VALUES -1, 0");
        this.assertQuery("SELECT b FROM nation n, (VALUES (0, NULL), (0, CAST(-1 AS BIGINT)), (0, CAST(0 AS BIGINT))) t(a, b) WHERE n.regionkey - 100 < t.b AND n.nationkey = t.a", "VALUES -1, 0");
        this.assertQuery("SELECT b FROM nation n, (VALUES (0, NULL), (0, NULL), (0, CAST(-1 AS BIGINT)), (0, NULL)) t(a, b) WHERE n.regionkey - 100 < t.b AND n.nationkey = t.a", "VALUES -1");
        this.assertQuery("SELECT b FROM nation n, (VALUES (0, NULL)) t(a, b) WHERE n.regionkey - 100 < t.b AND n.nationkey = t.a", "SELECT 1 WHERE FALSE");
        this.assertQuery("SELECT n.nationkey, r.regionkey FROM nation n JOIN region r ON n.regionkey = r.regionkey AND length(n.name) < length(substr(r.name, 5))");
        this.assertQuery("SELECT * FROM (VALUES (1,1),(2,1)) t1(a,b), (VALUES (1,1),(1,2),(2,1)) t2(x,y) WHERE a=x and b<=y", "VALUES (1,1,1,1), (1,1,1,2), (2,1,2,1)");
        this.assertQuery("SELECT * FROM (VALUES (1,1),(2,1)) t1(a,b), (VALUES (1,1),(1,2),(2,1)) t2(x,y) WHERE a=x and b<y", "VALUES (1,1,1,2)");
    }

    @Test
    public void testJoinWithGreaterThanInJoinClause() {
        this.assertQuery("SELECT n.nationkey, r.regionkey FROM region r JOIN nation n ON n.regionkey = r.regionkey AND n.name > r.name AND r.regionkey = 0");
        this.assertQuery("SELECT l.suppkey, n.nationkey, l.partkey, n.regionkey FROM nation n JOIN lineitem l ON l.suppkey = n.nationkey AND l.partkey > n.regionkey");
        this.assertQuery("SELECT b FROM nation n, (VALUES (0, CAST(-1 AS BIGINT)), (0, NULL), (0, CAST(0 AS BIGINT))) t(a, b) WHERE n.regionkey + 100 > t.b AND n.nationkey = t.a", "VALUES -1, 0");
        this.assertQuery("SELECT b FROM nation n, (VALUES (0, NULL), (0, CAST(-1 AS BIGINT)), (0, CAST(0 AS BIGINT))) t(a, b) WHERE n.regionkey + 100 > t.b AND n.nationkey = t.a", "VALUES -1, 0");
        this.assertQuery("SELECT b FROM nation n, (VALUES (0, NULL), (0, NULL), (0, CAST(-1 AS BIGINT)), (0, NULL)) t(a, b) WHERE n.regionkey + 100 > t.b AND n.nationkey = t.a", "VALUES -1");
        this.assertQuery("SELECT b FROM nation n, (VALUES (0, NULL)) t(a, b) WHERE n.regionkey + 100 > t.b AND n.nationkey = t.a", "SELECT 1 WHERE FALSE");
        this.assertQuery("SELECT n.nationkey, r.regionkey FROM nation n JOIN region r ON n.regionkey = r.regionkey AND length(n.name) > length(substr(r.name, 5))");
        this.assertQuery("SELECT * FROM (VALUES (1,1),(2,1)) t1(a,b), (VALUES (1,1),(1,2),(2,1)) t2(x,y) WHERE a=x and b>=y", "VALUES (1,1,1,1), (2,1,2,1)");
        this.assertQuery("SELECT * FROM (VALUES (1,1),(2,1)) t1(a,b), (VALUES (1,1),(1,2),(2,1)) t2(x,y) WHERE a=x and b>y", "SELECT 1 WHERE FALSE");
    }

    @Test
    public void testJoinWithRangePredicatesinJoinClause() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 16 = 0 AND partkey % 2 = 0) lineitem JOIN (SELECT * FROM orders WHERE orderkey % 16 = 0 AND custkey % 2 = 0) orders ON lineitem.orderkey % 8 = orders.orderkey % 8 AND lineitem.linenumber % 2 = 0 AND orders.custkey % 8 < 7 AND lineitem.suppkey % 10 < orders.custkey % 7 AND lineitem.suppkey % 7 > orders.custkey % 7");
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 16 = 0 AND partkey % 2 = 0) lineitem JOIN (SELECT * FROM orders WHERE orderkey % 16 = 0 AND custkey % 2 = 0) orders ON lineitem.orderkey % 8 = orders.orderkey % 8 AND lineitem.linenumber % 2 = 0 AND orders.custkey % 8 < lineitem.linenumber % 2 AND lineitem.suppkey % 10 < orders.custkey % 7 AND lineitem.suppkey % 7 > orders.custkey % 7");
    }

    @Test
    public void testJoinWithMultipleLessThanPredicatesDifferentOrders() {
        this.assertQuery("SELECT count(*) FROM lineitem l JOIN nation n ON l.suppkey % 5 = n.nationkey % 5 AND l.partkey % 3 < n.regionkey AND l.partkey % 3 + 1 < n.regionkey AND l.partkey % 3 + 2 < n.regionkey");
        this.assertQuery("SELECT count(*) FROM lineitem l JOIN nation n ON l.suppkey % 5 = n.nationkey % 5 AND l.partkey % 3 + 2 < n.regionkey AND l.partkey % 3 + 1 < n.regionkey AND l.partkey % 3 < n.regionkey");
        this.assertQuery("SELECT count(*) FROM lineitem l JOIN nation n ON l.suppkey % 5 = n.nationkey % 5 AND l.partkey % 3 > n.regionkey AND l.partkey % 3 + 1 > n.regionkey AND l.partkey % 3 + 2 > n.regionkey");
        this.assertQuery("SELECT count(*) FROM lineitem l JOIN nation n ON l.suppkey % 5 = n.nationkey % 5 AND l.partkey % 3 + 2 > n.regionkey AND l.partkey % 3 + 1 > n.regionkey AND l.partkey % 3 > n.regionkey");
    }

    @Test
    public void testJoinWithLessThanOnDatesInJoinClause() {
        this.assertQuery("SELECT o.orderkey, o.orderdate, l.shipdate FROM orders o JOIN lineitem l ON l.orderkey = o.orderkey AND l.shipdate < o.orderdate + INTERVAL '10' DAY", "SELECT o.orderkey, o.orderdate, l.shipdate FROM orders o JOIN lineitem l ON l.orderkey = o.orderkey AND l.shipdate < DATEADD('DAY', 10, o.orderdate)");
        this.assertQuery("SELECT o.orderkey, o.orderdate, l.shipdate FROM lineitem l JOIN orders o ON l.orderkey = o.orderkey AND l.shipdate < DATE_ADD('DAY', 10, o.orderdate)", "SELECT o.orderkey, o.orderdate, l.shipdate FROM orders o JOIN lineitem l ON l.orderkey = o.orderkey AND l.shipdate < DATEADD('DAY', 10, o.orderdate)");
        this.assertQuery("SELECT o.orderkey, o.orderdate, l.shipdate FROM orders o JOIN lineitem l ON o.orderkey=l.orderkey AND o.orderdate + INTERVAL '2' DAY <= l.shipdate AND l.shipdate < o.orderdate + INTERVAL '7' DAY", "SELECT o.orderkey, o.orderdate, l.shipdate FROM orders o JOIN lineitem l ON o.orderkey=l.orderkey AND DATEADD('DAY', 2, o.orderdate) <= l.shipdate AND l.shipdate < DATEADD('DAY', 7, o.orderdate)");
    }

    @Test
    public void testJoinWithNonDeterministicLessThan() {
        MaterializedRow actualRow = (MaterializedRow)Iterables.getOnlyElement((Iterable)this.computeActual("SELECT count(*) FROM customer c1 JOIN customer c2 ON c1.nationkey=c2.nationkey WHERE c1.custkey - RANDOM(CAST(c1.custkey AS BIGINT)) < c2.custkey").getMaterializedRows());
        Assert.assertEquals((int)actualRow.getFieldCount(), (int)1);
        long actualCount = (Long)actualRow.getField(0);
        MaterializedRow expectedAtLeastRow = (MaterializedRow)Iterables.getOnlyElement((Iterable)this.computeActual("SELECT count(*) FROM customer c1 JOIN customer c2 ON c1.nationkey=c2.nationkey WHERE c1.custkey < c2.custkey").getMaterializedRows());
        Assert.assertEquals((int)expectedAtLeastRow.getFieldCount(), (int)1);
        long expectedAtLeastCount = (Long)expectedAtLeastRow.getField(0);
        org.testng.Assert.assertTrue((actualCount > expectedAtLeastCount ? 1 : 0) != 0);
    }

    @Test
    public void testSimpleJoin() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey");
        this.assertQuery("SELECT COUNT(*) FROM (SELECT orderkey FROM lineitem WHERE orderkey < 1000) a JOIN (SELECT orderkey FROM orders WHERE orderkey < 2000) b ON NOT (a.orderkey <= b.orderkey)");
    }

    @Test
    public void testJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = 2");
    }

    @Test
    public void testJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON orders.orderkey = 2");
    }

    @Test
    public void testSimpleJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = 2");
    }

    @Test
    public void testSimpleJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = 2");
    }

    @Test
    public void testJoinDoubleClauseWithLeftOverlap() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = orders.custkey");
    }

    @Test
    public void testJoinDoubleClauseWithRightOverlap() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = lineitem.partkey");
    }

    @Test
    public void testJoinWithAlias() {
        this.assertQuery("SELECT * FROM (lineitem JOIN orders ON lineitem.orderkey = orders.orderkey) x");
    }

    @Test
    public void testJoinWithConstantExpression() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND 123 = 123");
    }

    @Test
    public void testJoinWithConstantTrueExpressionWithCoercion() {
        this.assertQuery("SELECT count(*) > 0 FROM nation JOIN region ON (cast(1.2 AS real) = CAST(1.2 AS decimal(2,1)))");
    }

    @Test
    public void testJoinWithCanonicalizedConstantTrueExpressionWithCoercion() {
        this.assertQuery("SELECT count(*) > 0 FROM nation JOIN region ON CAST((CASE WHEN (TRUE IS NOT NULL) THEN '1.2' ELSE '1.2' END) AS real) = CAST(1.2 AS decimal(2,1))");
    }

    @Test
    public void testJoinWithConstantPredicatePushDown() {
        this.assertQuery("SELECT\n  a.orderstatus\n  , a.clerk\nFROM (\n  SELECT DISTINCT orderstatus, clerk FROM orders\n) a\nINNER JOIN (\n  SELECT DISTINCT orderstatus, clerk FROM orders\n) b\nON\n  a.orderstatus = b.orderstatus\n  and a.clerk = b.clerk\nwhere a.orderstatus = 'F'\n");
    }

    @Test
    public void testJoinWithInferredFalseJoinClause() {
        this.assertQuery("SELECT COUNT(*)\nFROM orders\nJOIN lineitem\nON CAST(orders.orderkey AS VARCHAR) = CAST(lineitem.orderkey AS VARCHAR)\nWHERE orders.orderkey = 1 AND lineitem.orderkey = 2\n");
    }

    @Test
    public void testJoinUsing() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders USING (orderkey)", "SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testJoinCriteriaCoercion() {
        this.assertQuery("SELECT * FROM (VALUES (1.0, 2.0)) x (a, b) JOIN (VALUES (1, 3)) y (a, b) ON x.a = y.a", "VALUES (1.0, 2.0, 1, 3)");
        this.assertQuery("SELECT * FROM (VALUES (1, 2)) x (a, b) JOIN (VALUES (SMALLINT '1', SMALLINT '3')) y (a, b) ON x.a = y.a", "VALUES (1, 2, 1, 3)");
        this.assertQuery(String.format("SELECT * FROM    (VALUES (CAST(1 AS DECIMAL(%1$d,0)), 2)) x (a, b) ,    (VALUES (CAST(0 AS DECIMAL(%1$d,0)), SMALLINT '3')) y (a, b)  WHERE x.a = y.a + 1", 18), "VALUES (1, 2, 0, 3)");
        this.assertQuery(String.format("SELECT * FROM    (VALUES (CAST(1 AS DECIMAL(%1$d,0)), 2)) x (a, b)    INNER JOIN    (VALUES (CAST(0 AS DECIMAL(%1$d,0)), SMALLINT '3')) y (a, b)    ON x.a = y.a + 1", 18), "VALUES (1, 2, 0, 3)");
        this.assertQuery(String.format("SELECT * FROM    (VALUES (CAST(1 AS DECIMAL(%1$d,0)), 2)) x (a, b)    LEFT JOIN (VALUES (CAST(0 AS DECIMAL(%1$d,0)), SMALLINT '3')) y (a, b)    ON x.a = y.a + 1", 18), "VALUES (1, 2, 0, 3)");
        this.assertQuery(String.format("SELECT * FROM    (VALUES CAST(1 AS decimal(%d,0))) t1 (a),    (VALUES CAST(1 AS decimal(%d,0))) t2 (b)    WHERE a = b", 18, 19), "VALUES (1, 1)");
    }

    @Test
    public void testJoinWithReversedComparison() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON orders.orderkey = lineitem.orderkey");
    }

    @Test
    public void testJoinWithComplexExpressions() {
        this.assertQuery("SELECT SUM(custkey) FROM lineitem JOIN orders ON lineitem.orderkey = CAST(orders.orderkey AS BIGINT)");
    }

    @Test
    public void testJoinWithComplexExpressions2() {
        this.assertQuery("SELECT SUM(custkey) FROM lineitem JOIN orders ON lineitem.orderkey = CASE WHEN orders.custkey = 1 and orders.orderstatus = 'F' THEN orders.orderkey ELSE NULL END");
    }

    @Test
    public void testJoinWithComplexExpressions3() {
        this.assertQuery("SELECT SUM(custkey) FROM lineitem JOIN orders ON lineitem.orderkey + 1 = orders.orderkey + 1", "SELECT SUM(custkey) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey ");
    }

    @Test
    public void testJoinWithNormalization() {
        this.assertQuery("SELECT COUNT(*) FROM nation a JOIN nation b on not ((a.nationkey + b.nationkey) <> b.nationkey)");
        this.assertQuery("SELECT COUNT(*) FROM nation a JOIN nation b on not (a.nationkey <> b.nationkey)");
        this.assertQuery("SELECT COUNT(*) FROM nation a JOIN nation b on not (a.nationkey = b.nationkey)");
        this.assertQuery("SELECT COUNT(*) FROM nation a JOIN nation b on not (not CAST(a.nationkey AS boolean))");
        this.assertQuery("SELECT COUNT(*) FROM nation a JOIN nation b on not not not (a.nationkey = b.nationkey)");
    }

    @Test
    public void testSelfJoin() {
        this.assertQuery("SELECT COUNT(*) FROM orders a JOIN orders b on a.orderkey = b.orderkey");
    }

    @Test
    public void testWildcardFromJoin() {
        this.assertQuery("SELECT * FROM (SELECT orderkey, partkey FROM lineitem) a JOIN (SELECT orderkey, custkey FROM orders) b using (orderkey)", "SELECT a.orderkey, a.partkey, b.custkey FROM (SELECT orderkey, partkey FROM lineitem) a JOIN (SELECT orderkey, custkey FROM orders) b on a.orderkey = b.orderkey");
    }

    @Test
    public void testQualifiedWildcardFromJoin() {
        this.assertQuery("SELECT a.*, b.* FROM (SELECT orderkey, partkey FROM lineitem) a JOIN (SELECT orderkey, custkey FROM orders) b using (orderkey)", "SELECT a.partkey, b.custkey FROM (SELECT orderkey, partkey FROM lineitem) a JOIN (SELECT orderkey, custkey FROM orders) b on a.orderkey = b.orderkey");
    }

    @Test
    public void testJoinAggregations() {
        this.assertQuery("SELECT x + y FROM (   SELECT orderdate, COUNT(*) x FROM orders GROUP BY orderdate) a JOIN (   SELECT orderdate, COUNT(*) y FROM orders GROUP BY orderdate) b ON a.orderdate = b.orderdate");
    }

    @Test
    public void testNonEqualityJoin() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity + length(orders.comment) > 7");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND NOT lineitem.quantity > 2");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON NOT NOT lineitem.orderkey = orders.orderkey AND NOT NOT lineitem.quantity > 2");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND NOT NOT NOT lineitem.quantity > 2");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity > 2");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity <= 2");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity != 2");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.shipdate > orders.orderdate");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderdate < lineitem.shipdate");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.comment LIKE '%forges%'");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.comment LIKE lineitem.comment");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.comment LIKE '%forges%'");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.comment LIKE orders.comment");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.comment NOT LIKE '%forges%'");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.comment NOT LIKE lineitem.comment");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND NOT (orders.comment LIKE '%forges%')");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND NOT (orders.comment LIKE lineitem.comment)");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity + length(orders.comment) > 7");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND NULL");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) JOIN (VALUES 10, 11) t2(b) ON a > 1", "VALUES (2, 11), (2, 10)");
        this.assertQuery("SELECT COUNT(*) FROM (VALUES 1, 2) t1(a) JOIN (VALUES 10, 11) t2(b) ON a > 2", "VALUES (0)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) JOIN (VALUES 10, 11) t2(b) ON a+9 > b", "VALUES (2, 10)");
    }

    @Test
    public void testNonEqualityLeftJoin() {
        this.assertQuery("SELECT COUNT(*) FROM       (SELECT * FROM lineitem ORDER BY orderkey,linenumber LIMIT 5) l          LEFT OUTER JOIN       (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o          ON       o.custkey != 1000 WHERE o.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > 1000 WHERE orders.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > 1000.0 WHERE orders.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > orders.totalprice WHERE orders.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > lineitem.quantity WHERE orders.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity > 5 WHERE orders.orderkey IS NULL");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b > d", "VALUES (1, 2, 1, 1), (1, 1, NULL, NULL)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b < d", "VALUES (1, 1, 1, 2), (1, 2, NULL, NULL)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b > 2", "VALUES (1, 1, NULL,  NULL), (1, 2, NULL, NULL)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND d > 2", "VALUES (1, 1, NULL, NULL), (1, 2, NULL, NULL)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b > 0", "VALUES (1, 1, 1, 1), (1, 1, 1, 2), (1, 2, 1, 1), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND d > 0", "VALUES (1, 1, 1, 1), (1, 1, 1, 2), (1, 2, 1, 1), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND c = d", "VALUES (1, 1, 1, 1), (1, 2, 1, 1)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND c < d", "VALUES (1, 1, 1, 2), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON c = d", "VALUES (1, 1, 1, 1), (1, 2, 1, 1)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON c < d", "VALUES (1, 1, 1, 2), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) LEFT OUTER JOIN (VALUES 10, 11) t2(b) ON 1 = 1", "VALUES (1, 10), (1, 11), (2, 10), (2, 11)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) LEFT OUTER JOIN (VALUES 10, 11) t2(b) ON a > 1", "VALUES (1, NULL), (2, 11), (2, 10)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) LEFT OUTER JOIN (VALUES 10, 11) t2(b) ON b > 10", "VALUES (1, 11), (2, 11)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) LEFT OUTER JOIN (VALUES 10, 11) t2(b) ON a > b", "VALUES (1, NULL), (2, NULL)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) LEFT OUTER JOIN (VALUES 10, 11) t2(b) ON a < b", "VALUES (1, 10), (1, 11), (2, 10), (2, 11)");
        this.assertQuery("SELECT * FROM (VALUES 1) t1(a) LEFT OUTER JOIN (VALUES (1,2,2), (1,2,3), (1, 2, NULL)) t2(x,y,z) ON a=x AND y = z", "VALUES (1, 1, 2, 2)");
        this.assertQuery("SELECT 1 FROM (VALUES 1, 20) t1(a) LEFT OUTER JOIN (VALUES 10, 11) t2(b) ON a > b WHERE b IS NOT NULL", "VALUES (1), (1)");
    }

    @Test
    public void testNonEqalityJoinWithScalarRequiringSessionParameter() {
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND from_unixtime(b) > current_timestamp", "VALUES (1, 1, NULL, NULL), (1, 2, NULL, NULL)");
    }

    @Test
    public void testNonEqualityJoinWithTryInFilter() {
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d)              ON a=c AND TRY(1 / (b-a) != 1000)", "VALUES (1, 1, NULL, NULL), (1, 2, 1, 1), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d)              ON a=c AND TRY(1 / (b-a) != 1000 OR from_unixtime(b) > current_timestamp)", "VALUES (1, 1, NULL, NULL), (1, 2, 1, 1), (1, 2, 1, 2)");
    }

    @Test
    public void testLeftJoinWithEmptyInnerTable() {
        this.assertQuery("SELECT * FROM lineitem a LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) b ON a.orderkey = b.orderkey");
        this.assertQuery("SELECT * FROM lineitem a LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) b ON a.orderkey > b.orderkey");
        this.assertQuery("SELECT * FROM lineitem a LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) b ON 1 = 1");
        this.assertQuery("SELECT * FROM lineitem a LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) b ON b.orderkey > 1");
        this.assertQuery("SELECT * FROM lineitem a LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) b ON b.orderkey > b.totalprice");
    }

    @Test
    public void testRightJoinWithEmptyInnerTable() {
        this.assertQuery("SELECT * FROM orders b RIGHT JOIN (SELECT * FROM orders WHERE orderkey = rand()) a ON a.orderkey = b.orderkey");
        this.assertQuery("SELECT * FROM orders b LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) a ON a.orderkey > b.orderkey");
        this.assertQuery("SELECT * FROM orders b LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) a ON 1 = 1");
        this.assertQuery("SELECT * FROM orders b LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) a ON b.orderkey > 1");
        this.assertQuery("SELECT * FROM orders b LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) a ON b.orderkey > b.totalprice");
    }

    @Test
    public void testNonEqualityRightJoin() {
        this.assertQuery("SELECT COUNT(*) FROM       (SELECT * FROM lineitem ORDER BY orderkey,linenumber LIMIT 5) l          RIGHT OUTER JOIN       (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o          ON       l.quantity != 5 WHERE l.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity > 5 WHERE lineitem.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity > 5.0 WHERE lineitem.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity > lineitem.suppkey WHERE lineitem.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity*1000 > orders.totalprice WHERE lineitem.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.totalprice > 1000 WHERE lineitem.orderkey IS NULL");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b > d", "VALUES (1, 2, 1, 1), (NULL, NULL, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b < d", "VALUES (1, 1, 1, 2), (NULL, NULL, 1, 1)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b > 2", "VALUES (NULL, NULL, 1, 1), (NULL, NULL, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND d > 2", "VALUES (NULL, NULL, 1, 1), (NULL, NULL, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b > 0", "VALUES (1, 1, 1, 1), (1, 1, 1, 2), (1, 2, 1, 1), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND d > 0", "VALUES (1, 1, 1, 1), (1, 1, 1, 2), (1, 2, 1, 1), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND c = d", "VALUES (1, 2, 1, 1), (1, 1, 1, 1), (NULL, NULL, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND c < d", "VALUES (NULL, NULL, 1, 1), (1, 2, 1, 2), (1, 1, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON c = d", "VALUES (1, 1, 1, 1), (1, 2, 1, 1), (NULL, NULL, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON c < d", "VALUES (NULL, NULL, 1, 1), (1, 1, 1, 2), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) RIGHT OUTER JOIN (VALUES 10, 11) t2(b) ON 1 = 1", "VALUES (1, 10), (1, 11), (2, 10), (2, 11)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) RIGHT OUTER JOIN (VALUES 10, 11) t2(b) ON a > 1", "VALUES (2, 11), (2, 10)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) RIGHT OUTER JOIN (VALUES 10, 11) t2(b) ON b > 10", "VALUES (NULL, 10), (1, 11), (2, 11)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) RIGHT OUTER JOIN (VALUES 10, 11) t2(b) ON a > b", "VALUES (NULL, 10), (NULL, 11)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) RIGHT OUTER JOIN (VALUES 10, 11) t2(b) ON a < b", "VALUES (1, 10), (1, 11), (2, 10), (2, 11)");
    }

    @Test
    public void testJoinUsingSymbolsFromJustOneSideOfJoin() {
        this.assertQuery("SELECT b FROM (VALUES 1, 2) t1(a) RIGHT OUTER JOIN (VALUES 10, 11) t2(b) ON b > 10", "VALUES (10), (11), (11)");
        this.assertQuery("SELECT a FROM (VALUES 1, 2) t1(a) RIGHT OUTER JOIN (VALUES 10, 11) t2(b) ON a > 1", "VALUES (2), (2)");
        this.assertQuery("SELECT b FROM (VALUES 1, 2) t1(a) LEFT OUTER JOIN (VALUES 10, 11) t2(b) ON b > 10", "VALUES (11), (11)");
        this.assertQuery("SELECT a FROM (VALUES 1, 2) t1(a) LEFT OUTER JOIN (VALUES 10, 11) t2(b) ON a > 1", "VALUES (1), (2), (2)");
        this.assertQuery("SELECT a FROM (VALUES 1, 2) t1(a) JOIN (VALUES 10, 11) t2(b) ON a > 1", "VALUES (2), (2)");
        this.assertQuery("SELECT b FROM (VALUES 1, 2) t1(a) JOIN (VALUES 10, 11) t2(b) ON b > 10", "VALUES (11), (11)");
    }

    @Test
    public void testJoinsWithTrueJoinCondition() {
        this.assertQuery("SELECT * FROM (VALUES 0, 1) t1(a) JOIN (VALUES 10, 11) t2(b) ON TRUE", "VALUES (0, 10), (0, 11), (1, 10), (1, 11)");
        this.assertQuery("SELECT * FROM (SELECT 1 WHERE FALSE) t1(a) JOIN (VALUES 10, 11) t2(b) ON TRUE", "SELECT 1 WHERE FALSE");
        this.assertQuery("SELECT * FROM (VALUES 0, 1) t1(a) JOIN (SELECT 1 WHERE FALSE) t2(b) ON TRUE", "SELECT 1 WHERE FALSE");
        this.assertQuery("SELECT * FROM (SELECT 1 WHERE FALSE) t1(a) JOIN (SELECT 1 WHERE FALSE) t2(b) ON TRUE", "SELECT 1 WHERE FALSE");
        this.assertQuery("SELECT * FROM (VALUES 0, 1) t1(a) LEFT JOIN (VALUES 10, 11) t2(b) ON TRUE", "VALUES (0, 10), (0, 11), (1, 10), (1, 11)");
        this.assertQuery("SELECT * FROM (SELECT 1 WHERE FALSE) t1(a) LEFT JOIN (VALUES 10, 11) t2(b) ON TRUE", "SELECT 1 WHERE FALSE");
        this.assertQuery("SELECT * FROM (VALUES 0, 1) t1(a) LEFT JOIN (SELECT 1 WHERE FALSE) t2(b) ON TRUE", "VALUES (0, NULL), (1, NULL)");
        this.assertQuery("SELECT * FROM (SELECT 1 WHERE FALSE) t1(a) LEFT JOIN (SELECT 1 WHERE FALSE) t2(b) ON TRUE", "SELECT 1 WHERE FALSE");
        this.assertQuery("SELECT * FROM (VALUES 0, 1) t1(a) RIGHT JOIN (VALUES 10, 11) t2(b) ON TRUE", "VALUES (0, 10), (0, 11), (1, 10), (1, 11)");
        this.assertQuery("SELECT * FROM (SELECT 1 WHERE FALSE) t1(a) RIGHT JOIN (VALUES 10, 11) t2(b) ON TRUE", "VALUES (NULL, 10), (NULL, 11)");
        this.assertQuery("SELECT * FROM (VALUES 0, 1) t1(a) RIGHT JOIN (SELECT 1 WHERE FALSE) t2(b) ON TRUE", "SELECT 1 WHERE FALSE");
        this.assertQuery("SELECT * FROM (SELECT 1 WHERE FALSE) t1(a) RIGHT JOIN (SELECT 1 WHERE FALSE) t2(b) ON TRUE", "SELECT 1 WHERE FALSE");
        this.assertQuery("SELECT * FROM (VALUES 0, 1) t1(a) FULL JOIN (VALUES 10, 11) t2(b) ON TRUE", "VALUES (0, 10), (0, 11), (1, 10), (1, 11)");
        this.assertQuery("SELECT * FROM (SELECT 1 WHERE FALSE) t1(a) FULL JOIN (VALUES 10, 11) t2(b) ON TRUE", "VALUES (NULL, 10), (NULL, 11)");
        this.assertQuery("SELECT * FROM (VALUES 0, 1) t1(a) FULL JOIN (SELECT 1 WHERE FALSE) t2(b) ON TRUE", "VALUES (0, NULL), (1, NULL)");
        this.assertQuery("SELECT * FROM (SELECT 1 WHERE FALSE) t1(a) FULL JOIN (SELECT 1 WHERE FALSE) t2(b) ON TRUE", "SELECT 1 WHERE FALSE");
    }

    @Test
    public void testNonEqualityFullJoin() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity > 5 WHERE lineitem.orderkey IS NULL OR orders.orderkey IS NULL", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey AS o1, orders.orderkey AS o2 FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity > 5     UNION ALL SELECT lineitem.orderkey AS o1, orders.orderkey AS o2 FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity > 5     WHERE lineitem.orderkey IS NULL)  WHERE o1 IS NULL OR o2 IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > 1000 WHERE lineitem.orderkey IS NULL OR orders.orderkey IS NULL", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey AS o1, orders.orderkey AS o2 FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > 1000     UNION ALL SELECT lineitem.orderkey AS o1, orders.orderkey AS o2 FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > 1000     WHERE lineitem.orderkey IS NULL)  WHERE o1 IS NULL OR o2 IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > lineitem.quantity WHERE lineitem.orderkey IS NULL OR orders.orderkey IS NULL", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey AS o1, orders.orderkey AS o2 FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > lineitem.quantity     UNION ALL SELECT lineitem.orderkey AS o1, orders.orderkey AS o2 FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > lineitem.quantity     WHERE lineitem.orderkey IS NULL)  WHERE o1 IS NULL OR o2 IS NULL");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) FULL OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b > d", "VALUES (1, 2, 1, 1), (NULL, NULL, 1, 2), (1, 1, NULL, NULL)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) FULL OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b < d", "VALUES (1, 1, 1, 2), (NULL, NULL, 1, 1), (1, 2, NULL, NULL)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) FULL OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b > 2", "VALUES (NULL, NULL, 1, 1), (NULL, NULL, 1, 2), (1, 1, NULL, NULL), (1, 2, NULL, NULL)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) FULL OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND d > 2", "VALUES (NULL, NULL, 1, 1), (NULL, NULL, 1, 2), (1, 1, NULL, NULL), (1, 2, NULL, NULL)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) FULL OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b > 0", "VALUES (1, 1, 1, 1), (1, 1, 1, 2), (1, 2, 1, 1), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) FULL OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND d > 0", "VALUES (1, 1, 1, 1), (1, 1, 1, 2), (1, 2, 1, 1), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) FULL OUTER JOIN (VALUES 10, 11) t2(b) ON a > 1", "VALUES (2, 11), (2, 10), (1, NULL)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) FULL OUTER JOIN (VALUES 10, 11) t2(b) ON b > 10", "VALUES (NULL, 10), (1, 11), (2, 11)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) FULL OUTER JOIN (VALUES 10, 11) t2(b) ON a > b", "VALUES (NULL, 10), (NULL, 11), (1, NULL), (2, NULL)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) FULL OUTER JOIN (VALUES 10, 11) t2(b) ON a < b", "VALUES (1, 10), (1, 11), (2, 10), (2, 11)");
    }

    @Test
    public void testJoinOnMultipleFields() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.shipdate = orders.orderdate");
    }

    @Test
    public void testJoinUsingMultipleFields() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN (SELECT orderkey, orderdate shipdate FROM orders) T USING (orderkey, shipdate)", "SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.shipdate = orders.orderdate");
    }

    @Test
    public void testColocatedJoinWithLocalUnion() {
        this.assertQuery("SELECT count(*) FROM ((SELECT * FROM orders) union all (SELECT * FROM orders)) JOIN orders USING (orderkey)", "SELECT 2 * count(*) FROM orders");
    }

    @Test
    public void testJoinWithNonJoinExpression() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey = 1");
    }

    @Test
    public void testJoinWithNullValues() {
        this.assertQuery("SELECT *\nFROM (\n  SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM lineitem\n  WHERE partkey % 512 = 0\n) AS lineitem \nJOIN (\n  SELECT CASE WHEN orderkey % 2 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM orders\n  WHERE custkey % 512 = 0\n) AS orders\nON lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testJoinWithMultipleInSubqueryClauses() {
        QueryTemplate.Parameter type = QueryTemplate.parameter((String)"type").of("");
        QueryTemplate.Parameter condition = QueryTemplate.parameter((String)"condition").of("true");
        QueryTemplate queryTemplate = QueryTemplate.queryTemplate((String)"SELECT * FROM (VALUES 1,2,3,4) t(x) %type% JOIN (VALUES 1,2,3,5) t2(y) ON %condition%", (QueryTemplate.Parameter[])new QueryTemplate.Parameter[]{type, condition});
        QueryTemplate.Parameter twoDuplicatedInSubqueriesCondition = condition.of("(x in (VALUES 1,2,3)) = (y in (VALUES 1,2,3)) AND (x in (VALUES 1,2,4)) = (y in (VALUES 1,2,4))");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{twoDuplicatedInSubqueriesCondition}), "VALUES (1,1), (1,2), (2,2), (2,1), (3,3)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("(x in (VALUES 1,2)) = (y in (VALUES 1,2)) AND (x in (VALUES 1)) = (y in (VALUES 3))")}), "VALUES (2,2), (2,1), (3,5), (4,5)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("(x in (VALUES 1,2)) = (y in (VALUES 1,2)) AND (x in (VALUES 1)) != (y in (VALUES 3))")}), "VALUES (1,2), (1,1), (3, 3), (4,3)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("(x in (VALUES 1)) = (y in (VALUES 1)) AND (x in (SELECT 2)) != (y in (SELECT 2))")}), "VALUES (2,3), (2,5), (3, 2), (4,2)");
        QueryTemplate.Parameter left = type.of("left");
        QueryTemplate.Parameter right = type.of("right");
        QueryTemplate.Parameter full = type.of("full");
        for (QueryTemplate.Parameter joinType : ImmutableList.of((Object)left, (Object)right, (Object)full)) {
            for (String joinCondition : ImmutableList.of((Object)"x IN (VALUES 1)", (Object)"y in (VALUES 1)")) {
                this.assertQueryFails(queryTemplate.replace(new QueryTemplate.Parameter[]{joinType, condition.of(joinCondition)}), ".*IN with subquery predicate in join condition is not supported");
            }
        }
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{left, twoDuplicatedInSubqueriesCondition}), "VALUES (1,1), (1,2), (2,2), (2,1), (3,3), (4, null)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{right, twoDuplicatedInSubqueriesCondition}), "VALUES (1,1), (1,2), (2,2), (2,1), (3,3), (null, 5)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{full, twoDuplicatedInSubqueriesCondition}), "VALUES (1,1), (1,2), (2,2), (2,1), (3,3), (4, null), (null, 5)");
    }

    @Test
    public void testJoinWithInSubqueryToBeExecutedAsPostJoinFilter() {
        QueryTemplate.Parameter type = QueryTemplate.parameter((String)"type").of("");
        QueryTemplate.Parameter condition = QueryTemplate.parameter((String)"condition").of("true");
        QueryTemplate queryTemplate = QueryTemplate.queryTemplate((String)"SELECT * FROM (VALUES 1,2,3,4) t(x) %type% JOIN (VALUES 1,2,3,5) t2(y) ON %condition%", (QueryTemplate.Parameter[])new QueryTemplate.Parameter[]{type, condition});
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("(x+y in (VALUES 4))")}), "VALUES (1,3), (2,2), (3,1)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("(x+y in (VALUES 4)) AND (x*y in (VALUES 4,5))")}), "VALUES (2,2)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("(x+y in (VALUES 4,5)) AND (x*y IN (VALUES 4,5))")}), "VALUES (4,1), (2,2)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("(x+y in (VALUES 4,5)) AND (x in (VALUES 4,5)) != (y in (VALUES 4,5))")}), "VALUES (4,1)");
        for (QueryTemplate.Parameter joinType : type.of(new String[]{"left", "right", "full"})) {
            this.assertQueryFails(queryTemplate.replace(new QueryTemplate.Parameter[]{joinType, condition.of("(x+y in (VALUES 4,5)) AND (x in (VALUES 4,5)) != (y in (VALUES 4,5))")}), ".*IN with subquery predicate in join condition is not supported");
        }
    }

    @Test
    public void testOuterJoinWithComplexCorrelatedSubquery() {
        QueryTemplate.Parameter type = QueryTemplate.parameter((String)"type");
        QueryTemplate.Parameter condition = QueryTemplate.parameter((String)"condition");
        QueryTemplate queryTemplate = QueryTemplate.queryTemplate((String)"SELECT * FROM (VALUES 1,2,3,4) t(x) %type% JOIN (VALUES 1,2,3,5) t2(y) ON %condition%", (QueryTemplate.Parameter[])new QueryTemplate.Parameter[]{type, condition});
        queryTemplate.replaceAll(query -> this.assertQueryFails((String)query, "line .*: .* is not supported"), new List[]{ImmutableList.of((Object)type.of("left"), (Object)type.of("right"), (Object)type.of("full")), ImmutableList.of((Object)condition.of("EXISTS(SELECT 1 WHERE x = y)"), (Object)condition.of("(SELECT x = y)"), (Object)condition.of("true IN (SELECT x = y)"))});
    }

    @Test
    public void testJoinWithMultipleScalarSubqueryClauses() {
        QueryTemplate.Parameter type = QueryTemplate.parameter((String)"type").of("");
        QueryTemplate.Parameter condition = QueryTemplate.parameter((String)"condition");
        QueryTemplate queryTemplate = QueryTemplate.queryTemplate((String)"SELECT * FROM (VALUES 1,2,3,4) t(x) %type% JOIN (VALUES 1,2,3,5) t2(y) ON %condition%", (QueryTemplate.Parameter[])new QueryTemplate.Parameter[]{type, condition});
        QueryTemplate.Parameter multipleScalarJoinCondition = condition.of("(x = (VALUES 1)) AND (y = (VALUES 2)) AND (x in (VALUES 2)) = (y in (VALUES 1))");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{multipleScalarJoinCondition}), "VALUES (1,2)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("(x = (VALUES 2)) = (y > (VALUES 0)) AND (x > (VALUES 1)) = (y < (VALUES 3))")}), "VALUES (2,2), (2,1)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("(x = (VALUES 1)) = (y = (VALUES 1)) AND (x = (SELECT 2)) != (y = (SELECT 3))")}), "VALUES (2,5), (2,2), (3,3), (4,3)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{type.of("left"), multipleScalarJoinCondition}), "VALUES (1,2), (2,null), (3, null), (4, null)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{type.of("right"), multipleScalarJoinCondition}), "VALUES (1,2), (null,1), (null, 3), (null, 5)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{type.of("full"), multipleScalarJoinCondition}), "VALUES (1,2), (2,null), (3, null), (4, null), (null,1), (null, 3), (null, 5)");
    }

    @Test
    public void testJoinWithScalarSubqueryToBeExecutedAsPostJoinFilter() {
        QueryTemplate.Parameter type = QueryTemplate.parameter((String)"type").of("");
        QueryTemplate.Parameter condition = QueryTemplate.parameter((String)"condition");
        QueryTemplate queryTemplate = QueryTemplate.queryTemplate((String)"SELECT * FROM (VALUES 1,2,3,4) t(x) %type% JOIN (VALUES 1,2,3,5) t2(y) ON %condition%", (QueryTemplate.Parameter[])new QueryTemplate.Parameter[]{type, condition});
        QueryTemplate.Parameter xPlusYEqualsSubqueryJoinCondition = condition.of("(x+y = (SELECT 4))");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{xPlusYEqualsSubqueryJoinCondition}), "VALUES (1,3), (2,2), (3,1)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("(x+y = (VALUES 4)) AND (x*y = (VALUES 4))")}), "VALUES (2,2)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("x+y > (VALUES 3) AND (x = (VALUES 3)) != (y = (VALUES 3))")}), "VALUES (3,1), (3,2), (1,3), (2,3), (4,3), (3,5)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("x+y >= (VALUES 5) AND (x = (VALUES 3)) != (y = (VALUES 3))")}), "VALUES (3,2), (2,3), (4,3), (3,5)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("x+y >= (VALUES 3) AND (x = (VALUES 5)) != (y = (VALUES 3))")}), "VALUES (1,3), (2,3), (3,3), (4,3)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("x+y >= (VALUES 3) AND (x = (VALUES 3)) != (y = (VALUES 5))")}), "VALUES (3,1), (3,2), (3,3), (1,5), (2,5), (4,5)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("x+y >= (VALUES 4) AND (x = (VALUES 3)) != (y = (VALUES 5))")}), "VALUES (3,1), (3,2), (3,3), (1,5), (2,5), (4,5)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{type.of("left"), xPlusYEqualsSubqueryJoinCondition}), "VALUES (1,3), (2,2), (3,1), (4, null)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{type.of("right"), xPlusYEqualsSubqueryJoinCondition}), "VALUES (1,3), (2,2), (3,1), (null, 5)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{type.of("full"), xPlusYEqualsSubqueryJoinCondition}), "VALUES (1,3), (2,2), (3,1), (4, null), (null, 5)");
    }

    @Test
    public void testJoinWithScalarSubqueryInOnClause() {
        this.assertQuery("SELECT count() FROM nation a INNER JOIN nation b ON a.name = (SELECT max(name) FROM nation) INNER JOIN nation c ON c.name = split_part(b.name,'<',2)", "SELECT 0");
    }

    @Test
    public void testJoinWithScalarSubqueryToBeExecutedAsPostJoinFilterWithEmptyInnerTable() {
        String noOutputQuery = "SELECT 1 WHERE false";
        QueryTemplate.Parameter type = QueryTemplate.parameter((String)"type").of("");
        QueryTemplate.Parameter condition = QueryTemplate.parameter((String)"condition");
        QueryTemplate queryTemplate = QueryTemplate.queryTemplate((String)("SELECT * FROM (" + noOutputQuery + ") t(x) %type% JOIN (VALUES 1) t2(y) ON %condition%"), (QueryTemplate.Parameter[])new QueryTemplate.Parameter[]{type});
        QueryTemplate.Parameter xPlusYEqualsSubqueryJoinCondition = condition.of("(x+y = (SELECT 4))");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{xPlusYEqualsSubqueryJoinCondition}), noOutputQuery);
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{condition.of("(x+y = (VALUES 4)) AND (x*y = (VALUES 4))")}), noOutputQuery);
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{xPlusYEqualsSubqueryJoinCondition, type.of("left")}), noOutputQuery);
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{xPlusYEqualsSubqueryJoinCondition, type.of("right")}), "VALUES (null,1)");
        this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{xPlusYEqualsSubqueryJoinCondition, type.of("full")}), "VALUES (null,1)");
    }

    @Test
    public void testInUncorrelatedSubquery() {
        this.assertQuery("SELECT CASE WHEN false THEN 1 IN (VALUES 2) END", "SELECT NULL");
        this.assertQuery("SELECT x FROM (VALUES 2) t(x) WHERE MAP(ARRAY[8589934592], ARRAY[x]) IN (VALUES MAP(ARRAY[8589934592],ARRAY[2]))", "SELECT 2");
        this.assertQuery("SELECT a IN (VALUES 2), a FROM (VALUES (2)) t(a)", "SELECT TRUE, 2");
    }

    @Test
    public void testJoinWithExpressionsThatMayReturnNull() {
        this.assertQuery("SELECT *\nFROM (\n    SELECT a, nullif(a, 1)\n    FROM (VALUES 1) w(a)\n) t(a,b)\nJOIN (VALUES 1) u(x) ON t.a = u.x", "SELECT 1, NULL, 1");
        this.assertQuery("SELECT *\nFROM (\n    SELECT a, contains(array[2, null], a)\n    FROM (VALUES 1) w(a)\n) t(a,b)\nJOIN (VALUES 1) u(x) ON t.a = u.x\n", "SELECT 1, NULL, 1");
        this.assertQuery("SELECT *\nFROM (\n    SELECT a, array[null][a]\n    FROM (VALUES 1) w(a)\n) t(a,b)\nJOIN (VALUES 1) u(x) ON t.a = u.x", "SELECT 1, NULL, 1");
        this.assertQuery("SELECT *\nFROM (\n    SELECT a, try(a / 0)\n    FROM (VALUES 1) w(a)\n) t(a,b)\nJOIN (VALUES 1) u(x) ON t.a = u.x", "SELECT 1, NULL, 1");
    }

    @Test
    public void testLeftFilteredJoin() {
        this.assertQuery("SELECT custkey, linestatus, tax, totalprice, orderstatus FROM (SELECT * FROM lineitem WHERE orderkey % 2 = 0) a JOIN orders ON a.orderkey = orders.orderkey");
    }

    @Test
    public void testRightFilteredJoin() {
        this.assertQuery("SELECT custkey, linestatus, tax, totalprice, orderstatus FROM lineitem JOIN (SELECT *  FROM orders WHERE orderkey % 2 = 0) a ON lineitem.orderkey = a.orderkey");
    }

    @Test
    public void testJoinWithFullyPushedDownJoinClause() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON orders.custkey = 1 AND lineitem.orderkey = 1");
    }

    @Test
    public void testJoinPredicateMoveAround() {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM lineitem WHERE orderkey % 16 = 0 AND partkey % 2 = 0) lineitem\nJOIN (SELECT * FROM orders WHERE orderkey % 16 = 0 AND custkey % 2 = 0) orders\nON lineitem.orderkey % 8 = orders.orderkey % 8 AND lineitem.linenumber % 2 = 0\nWHERE orders.custkey % 8 < 7 AND orders.custkey % 8 = lineitem.orderkey % 8 AND lineitem.suppkey % 7 > orders.custkey % 7");
    }

    @Test
    public void testSimpleFullJoin() {
        this.assertQuery("SELECT a, b FROM (VALUES (1), (2)) t (a) FULL OUTER JOIN (VALUES (1), (3)) u (b) ON a = b", "SELECT * FROM (VALUES (1, 1), (2, NULL), (NULL, 3))");
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL JOIN orders ON lineitem.orderkey = orders.orderkey", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey UNION ALL SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey WHERE lineitem.orderkey IS NULL)");
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL OUTER JOIN orders ON lineitem.orderkey = orders.orderkey", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey UNION ALL SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey WHERE lineitem.orderkey IS NULL)");
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL JOIN orders ON lineitem.orderkey = orders.custkey", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.custkey UNION ALL SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.custkey WHERE lineitem.orderkey IS NULL)");
    }

    @Test
    public void testFullJoinNormalizedToLeft() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL JOIN orders ON lineitem.orderkey = orders.orderkey WHERE lineitem.orderkey IS NOT NULL", "SELECT COUNT(*) FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey WHERE lineitem.orderkey IS NOT NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL JOIN orders ON lineitem.orderkey = orders.custkey WHERE lineitem.orderkey IS NOT NULL", "SELECT COUNT(*) FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.custkey WHERE lineitem.orderkey IS NOT NULL");
    }

    @Test
    public void testFullJoinNormalizedToRight() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL JOIN orders ON lineitem.orderkey = orders.orderkey WHERE orders.orderkey IS NOT NULL", "SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey  WHERE orders.orderkey IS NOT NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL JOIN orders ON lineitem.orderkey = orders.custkey WHERE orders.custkey IS NOT NULL", "SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.custkey  WHERE orders.custkey IS NOT NULL");
    }

    @Test
    public void testFullJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem FULL JOIN orders ON lineitem.orderkey = 1024", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey, orders.orderkey AS o2 FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = 1024 UNION ALL SELECT lineitem.orderkey, orders.orderkey AS o2 FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = 1024 WHERE lineitem.orderkey IS NULL)");
    }

    @Test
    public void testFullJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem FULL JOIN orders ON orders.orderkey = 1024", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey, orders.orderkey AS o2 FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem LEFT OUTER JOIN orders ON orders.orderkey = 1024 UNION ALL SELECT lineitem.orderkey, orders.orderkey AS o2 FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem RIGHT OUTER JOIN orders ON orders.orderkey = 1024 WHERE lineitem.orderkey IS NULL)");
    }

    @Test
    public void testSimpleFullJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = 2", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = 2UNION ALL SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = 2WHERE lineitem.orderkey IS NULL)");
    }

    @Test
    public void testSimpleFullJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = 2", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = 2UNION ALL SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = 2WHERE lineitem.orderkey IS NULL)");
    }

    @Test
    public void testOuterJoinWithNullsOnProbe() {
        this.assertQuery("SELECT DISTINCT a.orderkey FROM (SELECT CASE WHEN orderkey > 10 THEN orderkey END orderkey FROM orders WHERE orderkey < 100) a RIGHT OUTER JOIN (SELECT * FROM orders WHERE orderkey < 100) b ON a.orderkey = b.orderkey");
        this.assertQuery("SELECT DISTINCT a.orderkey FROM (SELECT CASE WHEN orderkey > 2 THEN orderkey END orderkey FROM orders WHERE orderkey < 100) a FULL OUTER JOIN (SELECT * FROM orders WHERE orderkey < 100) b ON a.orderkey = b.orderkey", "SELECT DISTINCT orderkey FROM (SELECT a.orderkey FROM (SELECT CASE WHEN orderkey > 2 THEN orderkey END orderkey FROM orders WHERE orderkey < 100) a RIGHT OUTER JOIN (SELECT * FROM orders WHERE orderkey < 100) b ON a.orderkey = b.orderkey UNION ALL SELECT a.orderkey FROM(SELECT CASE WHEN orderkey > 2 THEN orderkey END orderkey FROM orders WHERE orderkey < 100) a LEFT OUTER JOIN (SELECT * FROM orders WHERE orderkey < 100) b ON a.orderkey = b.orderkey WHERE a.orderkey IS NULL)");
    }

    @Test
    public void testOuterJoinWithCommonExpression() {
        MaterializedResult actual = this.computeActual("SELECT count(1), count(one) FROM (values (1, 'a'), (2, 'a')) AS l(k, a) LEFT JOIN (SELECT k, 1 one FROM (values 1) AS r(k)) r ON l.k = r.k GROUP BY a");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{2L, 1L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testSimpleLeftJoin() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT JOIN orders ON lineitem.orderkey = orders.orderkey");
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey");
        this.assertQuery("SELECT x.val FROM (SELECT CAST(ROW(v) AS ROW(val integer)) FROM (VALUES 1, 2, 3) t(v)) ta (x) LEFT OUTER JOIN (SELECT CAST(ROW(v) AS ROW(val integer)) FROM (VALUES 1, 2, 3) t(v)) tb (y) ON x.val=y.val WHERE y.val=1", "SELECT 1");
    }

    @Test
    public void testLeftJoinNormalizedToInner() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT JOIN orders ON lineitem.orderkey = orders.orderkey WHERE orders.orderkey IS NOT NULL");
    }

    @Test
    public void testLeftJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem LEFT JOIN orders ON lineitem.orderkey = 1024");
    }

    @Test
    public void testLeftJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem LEFT JOIN orders ON orders.orderkey = 1024");
    }

    @Test
    public void testSimpleLeftJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = 2");
    }

    @Test
    public void testSimpleLeftJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = 2");
    }

    @Test
    public void testDoubleFilteredLeftJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem LEFT JOIN (SELECT * FROM orders WHERE orderkey % 1024 = 0) orders ON orders.orderkey = 1024");
    }

    @Test
    public void testDoubleFilteredLeftJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem LEFT JOIN (SELECT * FROM orders WHERE orderkey % 1024 = 0) orders ON lineitem.orderkey = 1024");
    }

    @Test
    public void testLeftJoinDoubleClauseWithLeftOverlap() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = orders.custkey");
    }

    @Test
    public void testLeftJoinDoubleClauseWithRightOverlap() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = lineitem.partkey");
    }

    @Test
    public void testBuildFilteredLeftJoin() {
        this.assertQuery(this.noJoinReordering(), "SELECT * FROM lineitem LEFT JOIN (SELECT * FROM orders WHERE orderkey % 2 = 0) a ON lineitem.orderkey = a.orderkey");
    }

    @Test
    public void testProbeFilteredLeftJoin() {
        this.assertQuery(this.noJoinReordering(), "SELECT * FROM (SELECT * FROM lineitem WHERE orderkey % 2 = 0) a LEFT JOIN orders ON a.orderkey = orders.orderkey");
    }

    @Test
    public void testLeftJoinPredicateMoveAround() {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM lineitem WHERE orderkey % 16 = 0 AND partkey % 2 = 0) lineitem\nLEFT JOIN (SELECT * FROM orders WHERE orderkey % 16 = 0 AND custkey % 2 = 0) orders\nON lineitem.orderkey % 8 = orders.orderkey % 8\nWHERE (orders.custkey % 8 < 7 OR orders.custkey % 8 IS NULL) AND orders.custkey % 8 = lineitem.orderkey % 8");
    }

    @Test
    public void testLeftJoinEqualityInference() {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM lineitem WHERE orderkey % 4 = 0 AND suppkey % 2 = partkey % 2 AND linenumber % 3 = orderkey % 3) lineitem\nLEFT JOIN (SELECT * FROM orders WHERE orderkey % 4 = 0) orders\nON lineitem.linenumber % 3 = orders.orderkey % 4 AND lineitem.orderkey % 3 = orders.custkey % 3\nWHERE lineitem.suppkey % 2 = lineitem.linenumber % 3");
    }

    @Test
    public void testLeftJoinWithNullValues() {
        this.assertQuery("SELECT *\nFROM (\n  SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM lineitem\n  WHERE partkey % 512 = 0\n) AS lineitem \nLEFT JOIN (\n  SELECT CASE WHEN orderkey % 2 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM orders\n  WHERE custkey % 512 = 0\n) AS orders\nON lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testSimpleRightJoin() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.orderkey");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.custkey");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.custkey");
    }

    @Test
    public void testRightJoinNormalizedToInner() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.orderkey WHERE lineitem.orderkey IS NOT NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.custkey WHERE lineitem.orderkey IS NOT NULL");
    }

    @Test
    public void testRightJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem RIGHT JOIN orders ON lineitem.orderkey = 1024");
    }

    @Test
    public void testRightJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem RIGHT JOIN orders ON orders.orderkey = 1024");
    }

    @Test
    public void testDoubleFilteredRightJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem RIGHT JOIN (SELECT * FROM orders WHERE orderkey % 1024 = 0) orders ON orders.orderkey = 1024");
    }

    @Test
    public void testDoubleFilteredRightJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem RIGHT JOIN (SELECT * FROM orders WHERE orderkey % 1024 = 0) orders ON lineitem.orderkey = 1024");
    }

    @Test
    public void testSimpleRightJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = 2");
    }

    @Test
    public void testSimpleRightJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = 2");
    }

    @Test
    public void testRightJoinDoubleClauseWithLeftOverlap() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = orders.custkey");
    }

    @Test
    public void testRightJoinDoubleClauseWithRightOverlap() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = lineitem.partkey");
    }

    @Test
    public void testBuildFilteredRightJoin() {
        this.assertQuery(this.noJoinReordering(), "SELECT custkey, linestatus, tax, totalprice, orderstatus FROM (SELECT * FROM lineitem WHERE orderkey % 2 = 0) a RIGHT JOIN orders ON a.orderkey = orders.orderkey");
    }

    @Test
    public void testProbeFilteredRightJoin() {
        this.assertQuery(this.noJoinReordering(), "SELECT custkey, linestatus, tax, totalprice, orderstatus FROM lineitem RIGHT JOIN (SELECT *  FROM orders WHERE orderkey % 2 = 0) a ON lineitem.orderkey = a.orderkey");
    }

    @Test
    public void testRightJoinPredicateMoveAround() {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM orders WHERE orderkey % 16 = 0 AND custkey % 2 = 0) orders\nRIGHT JOIN (SELECT * FROM lineitem WHERE orderkey % 16 = 0 AND partkey % 2 = 0) lineitem\nON lineitem.orderkey % 8 = orders.orderkey % 8\nWHERE (orders.custkey % 8 < 7 OR orders.custkey % 8 IS NULL) AND orders.custkey % 8 = lineitem.orderkey % 8");
    }

    @Test
    public void testRightJoinEqualityInference() {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM orders WHERE orderkey % 4 = 0) orders\nRIGHT JOIN (SELECT * FROM lineitem WHERE orderkey % 4 = 0 AND suppkey % 2 = partkey % 2 AND linenumber % 3 = orderkey % 3) lineitem\nON lineitem.linenumber % 3 = orders.orderkey % 4 AND lineitem.orderkey % 3 = orders.custkey % 3\nWHERE lineitem.suppkey % 2 = lineitem.linenumber % 3");
    }

    @Test
    public void testRightJoinWithNullValues() {
        this.assertQuery("SELECT lineitem.orderkey, orders.orderkey\nFROM (\n  SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM lineitem\n  WHERE partkey % 512 = 0\n) AS lineitem \nRIGHT JOIN (\n  SELECT CASE WHEN orderkey % 2 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM orders\n  WHERE custkey % 512 = 0\n) AS orders\nON lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testJoinWithStatefulFilterFunction() {
        this.assertQuery("SELECT *\nFROM (VALUES 1, 2) a(id)\nFULL JOIN (VALUES 2, 3) b(id)\nON (array_intersect(array[a.id], array[b.id]) = array[a.id])", "VALUES (1, null), (2, 2), (null, 3)");
    }

    @Test
    public void testChecksum() {
        this.assertQuery("SELECT to_hex(checksum(0))", "SELECT '0000000000000000'");
    }

    @Test
    public void testMaxBy() {
        this.assertQuery("SELECT MAX_BY(orderkey, totalprice) FROM orders", "SELECT orderkey FROM orders ORDER BY totalprice DESC LIMIT 1");
    }

    @Test
    public void testMaxByN() {
        this.assertQuery("SELECT y FROM (SELECT MAX_BY(orderkey, totalprice, 2) mx FROM orders) CROSS JOIN UNNEST(mx) u(y)", "SELECT orderkey FROM orders ORDER BY totalprice DESC LIMIT 2");
    }

    @Test
    public void testMinBy() {
        this.assertQuery("SELECT MIN_BY(orderkey, totalprice) FROM orders", "SELECT orderkey FROM orders ORDER BY totalprice ASC LIMIT 1");
        this.assertQuery("SELECT MIN_BY(a, ROW(b, c)) FROM (VALUES (1, 2, 3), (2, 2, 1)) AS t(a, b, c)", "SELECT 2");
    }

    @Test
    public void testMinByN() {
        this.assertQuery("SELECT y FROM (SELECT MIN_BY(orderkey, totalprice, 2) mx FROM orders) CROSS JOIN UNNEST(mx) u(y)", "SELECT orderkey FROM orders ORDER BY totalprice ASC LIMIT 2");
    }

    @Test
    public void testWindowImplicitCoercion() {
        this.assertQueryOrdered("SELECT orderkey, 1e0 / row_number() OVER (ORDER BY orderkey) FROM orders LIMIT 2", "VALUES (1, 1.0), (2, 0.5)");
    }

    @Test
    public void testWindowsSameOrdering() {
        MaterializedResult actual = this.computeActual("SELECT sum(quantity) OVER(PARTITION BY suppkey ORDER BY orderkey),min(tax) OVER(PARTITION BY suppkey ORDER BY shipdate)FROM lineitem ORDER BY 1 LIMIT 10");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE}).row(new Object[]{1.0, 0.0}).row(new Object[]{2.0, 0.0}).row(new Object[]{2.0, 0.0}).row(new Object[]{3.0, 0.0}).row(new Object[]{3.0, 0.0}).row(new Object[]{4.0, 0.0}).row(new Object[]{4.0, 0.0}).row(new Object[]{5.0, 0.0}).row(new Object[]{5.0, 0.0}).row(new Object[]{5.0, 0.0}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testWindowsPrefixPartitioning() {
        MaterializedResult actual = this.computeActual("SELECT max(tax) OVER(PARTITION BY suppkey, tax ORDER BY receiptdate),sum(quantity) OVER(PARTITION BY suppkey ORDER BY orderkey)FROM lineitem ORDER BY 2, 1 LIMIT 10");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE}).row(new Object[]{0.06, 1.0}).row(new Object[]{0.02, 2.0}).row(new Object[]{0.06, 2.0}).row(new Object[]{0.02, 3.0}).row(new Object[]{0.08, 3.0}).row(new Object[]{0.03, 4.0}).row(new Object[]{0.03, 4.0}).row(new Object[]{0.02, 5.0}).row(new Object[]{0.03, 5.0}).row(new Object[]{0.07, 5.0}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testWindowsDifferentPartitions() {
        MaterializedResult actual = this.computeActual("SELECT sum(quantity) OVER(PARTITION BY suppkey ORDER BY orderkey),count(discount) OVER(PARTITION BY partkey ORDER BY receiptdate),min(tax) OVER(PARTITION BY suppkey, tax ORDER BY receiptdate)FROM lineitem ORDER BY 1, 2 LIMIT 10");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT, DoubleType.DOUBLE}).row(new Object[]{1.0, 10L, 0.06}).row(new Object[]{2.0, 4L, 0.06}).row(new Object[]{2.0, 16L, 0.02}).row(new Object[]{3.0, 3L, 0.08}).row(new Object[]{3.0, 38L, 0.02}).row(new Object[]{4.0, 10L, 0.03}).row(new Object[]{4.0, 10L, 0.03}).row(new Object[]{5.0, 9L, 0.03}).row(new Object[]{5.0, 13L, 0.07}).row(new Object[]{5.0, 15L, 0.02}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testWindowsConstantExpression() {
        this.assertQueryOrdered("SELECT sum(size) OVER(PARTITION BY type ORDER BY brand),lag(partkey, 1) OVER(PARTITION BY type ORDER BY name)FROM part ORDER BY 1, 2 LIMIT 10", "VALUES (1, 315), (1, 881), (1, 1009), (3, 1087), (3, 1187), (3, 1529), (4, 969), (5, 151), (5, 505), (5, 872)");
    }

    @Test
    public void testDependentWindows() {
        String sql = "WITH t1 AS (SELECT extendedprice FROM lineitem ORDER BY orderkey, partkey LIMIT 2),t2 AS (SELECT extendedprice, sum(extendedprice) OVER() AS x FROM t1),t3 AS (SELECT max(x) OVER() FROM t2) SELECT * FROM t3";
        this.assertQuery(sql, "VALUES 59645.36, 59645.36");
    }

    @Test
    public void testWindowFunctionWithoutParameters() {
        MaterializedResult actual = this.computeActual("SELECT count() over(partition by custkey) FROM orders WHERE custkey < 3 ORDER BY custkey");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{9L}).row(new Object[]{9L}).row(new Object[]{9L}).row(new Object[]{9L}).row(new Object[]{9L}).row(new Object[]{9L}).row(new Object[]{9L}).row(new Object[]{9L}).row(new Object[]{9L}).row(new Object[]{10L}).row(new Object[]{10L}).row(new Object[]{10L}).row(new Object[]{10L}).row(new Object[]{10L}).row(new Object[]{10L}).row(new Object[]{10L}).row(new Object[]{10L}).row(new Object[]{10L}).row(new Object[]{10L}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testHaving() {
        this.assertQuery("SELECT orderstatus, sum(totalprice) FROM orders GROUP BY orderstatus HAVING orderstatus = 'O'");
    }

    @Test
    public void testHaving2() {
        this.assertQuery("SELECT custkey, sum(orderkey) FROM orders GROUP BY custkey HAVING sum(orderkey) > 400000");
    }

    @Test
    public void testHaving3() {
        this.assertQuery("SELECT custkey, sum(totalprice) * 2 FROM orders GROUP BY custkey");
        this.assertQuery("SELECT custkey, avg(totalprice + 5) FROM orders GROUP BY custkey");
        this.assertQuery("SELECT custkey, sum(totalprice) * 2 FROM orders GROUP BY custkey HAVING avg(totalprice + 5) > 10");
    }

    @Test
    public void testHavingWithoutGroupBy() {
        this.assertQuery("SELECT sum(orderkey) FROM orders HAVING sum(orderkey) > 400000");
    }

    @Test
    public void testJoinWithGroupByAsProbe() {
        this.assertQuery("SELECT   b.orderkey,   b.custkey,   a.custkey FROM (   SELECT custkey  FROM orders   GROUP BY custkey) a JOIN orders b   ON a.custkey = b.custkey ");
    }

    @Test
    public void testJoinEffectivePredicateWithNoRanges() {
        this.assertQuery("SELECT * FROM orders a    JOIN (SELECT * FROM orders WHERE orderkey IS NULL) b    ON a.orderkey = b.orderkey");
    }

    @Test
    public void testColumnAliases() {
        this.assertQuery("SELECT x, T.y, z + 1 FROM (SELECT custkey, orderstatus, totalprice FROM orders) T (x, y, z)", "SELECT custkey, orderstatus, totalprice + 1 FROM orders");
    }

    @Test
    public void testWindowFunctionWithImplicitCoercion() {
        this.assertQuery("SELECT *, 1.0 * sum(x) OVER () FROM (VALUES 1) t(x)", "SELECT 1, 1.0");
    }

    @Test
    public void testWindowFunctionsExpressions() {
        this.assertQueryOrdered("SELECT orderkey, orderstatus , row_number() OVER (ORDER BY orderkey * 2) *   row_number() OVER (ORDER BY orderkey DESC) + 100 FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) x ORDER BY orderkey LIMIT 5", "VALUES (1, 'O', 110), (2, 'O', 118), (3, 'F', 124), (4, 'O', 128), (5, 'F', 130)");
    }

    @Test
    public void testWindowFunctionsFromAggregate() {
        MaterializedResult actual = this.computeActual("SELECT * FROM (\n  SELECT orderstatus, clerk, sales\n  , rank() OVER (PARTITION BY x.orderstatus ORDER BY sales DESC) rnk\n  FROM (\n    SELECT orderstatus, clerk, sum(totalprice) sales\n    FROM orders\n    GROUP BY orderstatus, clerk\n   ) x\n) x\nWHERE rnk <= 2\nORDER BY orderstatus, rnk");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, DoubleType.DOUBLE, BigintType.BIGINT}).row(new Object[]{"F", "Clerk#000000090", 2784836.61, 1L}).row(new Object[]{"F", "Clerk#000000084", 2674447.15, 2L}).row(new Object[]{"O", "Clerk#000000500", 2569878.29, 1L}).row(new Object[]{"O", "Clerk#000000050", 2500162.92, 2L}).row(new Object[]{"P", "Clerk#000000071", 841820.99, 1L}).row(new Object[]{"P", "Clerk#000001000", 643679.49, 2L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testOrderByWindowFunction() {
        this.assertQueryOrdered("SELECT orderkey, row_number() OVER (ORDER BY orderkey) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) ORDER BY 2 DESC LIMIT 5", "VALUES (34, 10), (33, 9), (32, 8), (7, 7), (6, 6)");
    }

    @Test
    public void testSameWindowFunctionsTwoCoerces() {
        MaterializedResult actual = this.computeActual("SELECT 12.0E0 * row_number() OVER ()/row_number() OVER(),\nrow_number() OVER()\nFROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10)\nORDER BY 2 DESC\nLIMIT 5");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT}).row(new Object[]{12.0, 10L}).row(new Object[]{12.0, 9L}).row(new Object[]{12.0, 8L}).row(new Object[]{12.0, 7L}).row(new Object[]{12.0, 6L}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
        actual = this.computeActual("SELECT (MAX(x.a) OVER () - x.a) * 100.0E0 / MAX(x.a) OVER ()\nFROM (VALUES 1, 2, 3, 4) x(a)");
        expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{DoubleType.DOUBLE}).row(new Object[]{75.0}).row(new Object[]{50.0}).row(new Object[]{25.0}).row(new Object[]{0.0}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testRowNumberNoOptimization() {
        MaterializedResult actual = this.computeActual("SELECT orderkey, orderstatus FROM (\n   SELECT row_number() OVER () rn, orderkey, orderstatus\n   FROM orders\n) WHERE NOT rn <= 10");
        MaterializedResult all = this.computeExpected("SELECT orderkey, orderstatus FROM orders", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)(all.getMaterializedRows().size() - 10));
        QueryAssertions.assertContains(all, actual);
        actual = this.computeActual("SELECT orderkey, orderstatus FROM (\n   SELECT row_number() OVER () rn, orderkey, orderstatus\n   FROM orders\n) WHERE rn - 5 <= 10");
        all = this.computeExpected("SELECT orderkey, orderstatus FROM orders", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)15);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testRowNumberLimit() {
        MaterializedResult actual = this.computeActual("SELECT row_number() OVER (PARTITION BY orderstatus) rn, orderstatus\nFROM orders\nLIMIT 10");
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        actual = this.computeActual("SELECT row_number() OVER (PARTITION BY orderstatus ORDER BY orderkey) rn\nFROM orders\nLIMIT 10");
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        actual = this.computeActual("SELECT row_number() OVER () rn, orderstatus\nFROM orders\nLIMIT 10");
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        actual = this.computeActual("SELECT row_number() OVER (ORDER BY orderkey) rn\nFROM orders\nLIMIT 10");
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
    }

    @Test
    public void testRowNumberMultipleFilters() {
        MaterializedResult actual = this.computeActual("SELECT * FROM (   SELECT a, row_number() OVER (PARTITION BY a ORDER BY a) rn\n   FROM (VALUES (1), (1), (1), (2), (2), (3)) t (a)) t WHERE rn < 3 AND rn % 2 = 0 AND a = 2 LIMIT 2");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{2, 2L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testRowNumberSpecialFilters() {
        this.assertQueryReturnsEmptyResult("SELECT * FROM (   SELECT a, row_number() OVER (PARTITION BY a ORDER BY a) rn\n   FROM (VALUES (1), (1), (1), (2), (2), (3)) t (a)) t WHERE rn = -1");
        this.assertQueryReturnsEmptyResult("SELECT * FROM (   SELECT a, row_number() OVER (PARTITION BY a ORDER BY a) rn\n   FROM (VALUES (1), (1), (1), (2), (2), (3)) t (a)) t WHERE rn <= -1");
        this.assertQueryReturnsEmptyResult("SELECT * FROM (   SELECT a, row_number() OVER (PARTITION BY a ORDER BY a) rn\n   FROM (VALUES (1), (1), (1), (2), (2), (3)) t (a)) t WHERE rn = 0");
        this.assertQueryReturnsEmptyResult("SELECT * FROM (   SELECT a, row_number() OVER (PARTITION BY a) rn\n   FROM (VALUES (1), (1), (1), (2), (2), (3)) t (a)) t WHERE rn = -1");
        this.assertQueryReturnsEmptyResult("SELECT * FROM (   SELECT a, row_number() OVER (PARTITION BY a) rn\n   FROM (VALUES (1), (1), (1), (2), (2), (3)) t (a)) t WHERE rn <= -1");
        this.assertQueryReturnsEmptyResult("SELECT * FROM (   SELECT a, row_number() OVER (PARTITION BY a) rn\n   FROM (VALUES (1), (1), (1), (2), (2), (3)) t (a)) t WHERE rn = 0");
    }

    @Test
    public void testRowNumberFilterAndLimit() {
        MaterializedResult actual = this.computeActual("SELECT * FROM (SELECT a, row_number() OVER (PARTITION BY a ORDER BY a) rn\nFROM (VALUES (1), (2), (1), (2)) t (a)) t WHERE rn < 2 LIMIT 2");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{1, 1L}).row(new Object[]{2, 1L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
        actual = this.computeActual("SELECT * FROM (SELECT a, row_number() OVER (PARTITION BY a) rn\nFROM (VALUES (1), (2), (1), (2), (1)) t (a)) t WHERE rn < 3 LIMIT 2");
        expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{1, 1L}).row(new Object[]{1, 2L}).row(new Object[]{2, 1L}).row(new Object[]{2, 2L}).build();
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)2);
        QueryAssertions.assertContains(expected, actual);
    }

    @Test
    public void testRowNumberUnpartitionedFilter() {
        MaterializedResult actual = this.computeActual("SELECT orderkey, orderstatus FROM (\n   SELECT row_number() OVER () rn, orderkey, orderstatus\n   FROM orders\n) WHERE rn <= 5 AND orderstatus != 'Z'");
        MaterializedResult all = this.computeExpected("SELECT orderkey, orderstatus FROM orders", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)5);
        QueryAssertions.assertContains(all, actual);
        actual = this.computeActual("SELECT orderkey, orderstatus FROM (\n   SELECT row_number() OVER () rn, orderkey, orderstatus\n   FROM orders\n) WHERE rn < 5");
        all = this.computeExpected("SELECT orderkey, orderstatus FROM orders", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)4);
        QueryAssertions.assertContains(all, actual);
        actual = this.computeActual("SELECT orderkey, orderstatus FROM (\n   SELECT row_number() OVER () rn, orderkey, orderstatus\n   FROM orders\n) LIMIT 5");
        all = this.computeExpected("SELECT orderkey, orderstatus FROM orders", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)5);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testRowNumberPartitionedFilter() {
        MaterializedResult actual = this.computeActual("SELECT orderkey, orderstatus FROM (\n   SELECT row_number() OVER (PARTITION BY orderstatus) rn, orderkey, orderstatus\n   FROM orders\n) WHERE rn <= 5");
        MaterializedResult all = this.computeExpected("SELECT orderkey, orderstatus FROM orders", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)15);
        QueryAssertions.assertContains(all, actual);
        actual = this.computeActual("SELECT orderkey FROM (\n   SELECT row_number() OVER (PARTITION BY orderstatus) rn, orderkey\n   FROM orders\n) WHERE rn <= 5");
        all = this.computeExpected("SELECT orderkey FROM orders", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)15);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testRowNumberJoin() {
        MaterializedResult actual = this.computeActual("SELECT a, rn\nFROM (\n    SELECT a, row_number() OVER (ORDER BY a) rn\n    FROM (VALUES (1), (2)) t (a)\n) a\nJOIN (VALUES (2)) b (b) ON a.a = b.b\nLIMIT 1");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{2, 2L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
        actual = this.computeActual("SELECT a, rn\nFROM (\n    SELECT a, row_number() OVER (PARTITION BY a ORDER BY a) rn\n    FROM (VALUES (1), (2), (1), (2)) t (a)\n) a\nJOIN (VALUES (2)) b (b) ON a.a = b.b\nLIMIT 2");
        expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{2, 1L}).row(new Object[]{2, 2L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testRowNumberUnpartitionedFilterLimit() {
        this.assertQuery("SELECT row_number() OVER ()\nFROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey\nWHERE orders.orderkey = 10000\nLIMIT 20");
    }

    @Test
    public void testRowNumberPropertyDerivation() {
        this.assertQuery("SELECT orderkey, orderstatus, SUM(rn) OVER (PARTITION BY orderstatus) c FROM (    SELECT orderkey, orderstatus, row_number() OVER (PARTITION BY orderstatus) rn    FROM (        SELECT * FROM orders ORDER BY orderkey LIMIT 10    ) )", "VALUES (1, 'O', 21), (2, 'O', 21), (3, 'F', 10), (4, 'O', 21), (5, 'F', 10), (6, 'F', 10), (7, 'O', 21), (32, 'O', 21), (33, 'F', 10), (34, 'O', 21)");
    }

    @Test
    public void testWindowMapAgg() {
        MaterializedResult actual = this.computeActual("SELECT map_agg(orderkey, orderpriority) OVER(PARTITION BY orderstatus) FROM\n(SELECT * FROM orders ORDER BY orderkey LIMIT 5) t");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)VarcharType.createVarcharType((int)1))}).row(new Object[]{ImmutableMap.of((Object)1L, (Object)"5-LOW", (Object)2L, (Object)"1-URGENT", (Object)4L, (Object)"5-LOW")}).row(new Object[]{ImmutableMap.of((Object)1L, (Object)"5-LOW", (Object)2L, (Object)"1-URGENT", (Object)4L, (Object)"5-LOW")}).row(new Object[]{ImmutableMap.of((Object)1L, (Object)"5-LOW", (Object)2L, (Object)"1-URGENT", (Object)4L, (Object)"5-LOW")}).row(new Object[]{ImmutableMap.of((Object)3L, (Object)"5-LOW", (Object)5L, (Object)"5-LOW")}).row(new Object[]{ImmutableMap.of((Object)3L, (Object)"5-LOW", (Object)5L, (Object)"5-LOW")}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testWindowPropertyDerivation() {
        this.assertQuery("SELECT orderstatus, orderkey, SUM(s) OVER (PARTITION BY orderstatus), SUM(s) OVER (PARTITION BY orderstatus, orderkey), SUM(s) OVER (PARTITION BY orderstatus ORDER BY orderkey), SUM(s) OVER (ORDER BY orderstatus, orderkey) FROM (    SELECT orderkey, orderstatus, SUM(orderkey) OVER (ORDER BY orderstatus, orderkey) s    FROM (        SELECT * FROM orders ORDER BY orderkey LIMIT 10    ) )", "VALUES ('F', 3, 72, 3, 3, 3), ('F', 5, 72, 8, 11, 11), ('F', 6, 72, 14, 25, 25), ('F', 33, 72, 47, 72, 72), ('O', 1, 433, 48, 48, 120), ('O', 2, 433, 50, 98, 170), ('O', 4, 433, 54, 152, 224), ('O', 7, 433, 61, 213, 285), ('O', 32, 433, 93, 306, 378), ('O', 34, 433, 127, 433, 505)");
    }

    @Test
    public void testTopNUnpartitionedWindow() {
        MaterializedResult actual = this.computeActual("SELECT * FROM (\n   SELECT row_number() OVER (ORDER BY orderkey) rn, orderkey, orderstatus\n   FROM orders\n) WHERE rn <= 5");
        String sql = "SELECT row_number() OVER (), orderkey, orderstatus FROM orders ORDER BY orderkey LIMIT 5";
        MaterializedResult expected = this.computeExpected(sql, actual.getTypes());
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testTopNUnpartitionedLargeWindow() {
        MaterializedResult actual = this.computeActual("SELECT * FROM (\n   SELECT row_number() OVER (ORDER BY orderkey) rn, orderkey, orderstatus\n   FROM orders\n) WHERE rn <= 10000");
        String sql = "SELECT row_number() OVER (), orderkey, orderstatus FROM orders ORDER BY orderkey LIMIT 10000";
        MaterializedResult expected = this.computeExpected(sql, actual.getTypes());
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    @Test
    public void testTopNPartitionedWindow() {
        this.assertQuery("SELECT * FROM (    SELECT row_number() OVER (PARTITION BY orderstatus ORDER BY orderkey) rn, orderkey, orderstatus    FROM orders ) WHERE rn <= 2", "VALUES (1, 1, 'O'), (2, 2, 'O'), (1, 3, 'F'), (2, 5, 'F'), (1, 65, 'P'), (2, 197, 'P')");
        this.assertQuery("SELECT * FROM (    SELECT row_number() OVER (PARTITION BY orderstatus ORDER BY orderkey) rn, orderkey    FROM orders ) WHERE rn <= 2", "VALUES (1, 1), (2, 2), (1, 3), (2, 5), (1, 65), (2, 197)");
        this.assertQuery("SELECT * FROM (    SELECT row_number() OVER (PARTITION BY orderstatus ORDER BY orderkey) rn, orderstatus    FROM orders ) WHERE rn <= 2", "VALUES (1, 'O'), (2, 'O'), (1, 'F'), (2, 'F'), (1, 'P'), (2, 'P')");
    }

    @Test
    public void testTopNUnpartitionedWindowWithEqualityFilter() {
        this.assertQuery("SELECT * FROM (    SELECT row_number() OVER (ORDER BY orderkey) rn, orderkey, orderstatus    FROM orders ) WHERE rn = 2", "VALUES (2, 2, 'O')");
    }

    @Test
    public void testTopNUnpartitionedWindowWithCompositeFilter() {
        this.assertQuery("SELECT * FROM (    SELECT row_number() OVER (ORDER BY orderkey) rn, orderkey, orderstatus    FROM orders ) WHERE rn = 1 OR rn IN (3, 4) OR rn BETWEEN 6 AND 7", "VALUES (1, 1, 'O'), (3, 3, 'F'), (4, 4, 'O'), (6, 6, 'F'), (7, 7, 'O')");
    }

    @Test
    public void testTopNPartitionedWindowWithEqualityFilter() {
        this.assertQuery("SELECT * FROM (    SELECT row_number() OVER (PARTITION BY orderstatus ORDER BY orderkey) rn, orderkey, orderstatus    FROM orders ) WHERE rn = 2", "VALUES (2, 2, 'O'), (2, 5, 'F'), (2, 197, 'P')");
        this.assertQuery("SELECT * FROM (    SELECT row_number() OVER (PARTITION BY orderstatus ORDER BY orderkey) rn, orderkey    FROM orders ) WHERE rn = 2", "VALUES (2, 2), (2, 5), (2, 197)");
        this.assertQuery("SELECT * FROM (    SELECT row_number() OVER (PARTITION BY orderstatus ORDER BY orderkey) rn, orderstatus    FROM orders ) WHERE rn = 2", "VALUES (2, 'O'), (2, 'F'), (2, 'P')");
    }

    @Test
    public void testWindowFunctionWithGroupBy() {
        MaterializedResult actual = this.computeActual("SELECT *, rank() OVER (PARTITION BY x)\nFROM (SELECT 'foo' x)\nGROUP BY 1");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.createVarcharType((int)3), BigintType.BIGINT}).row(new Object[]{"foo", 1L}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testPartialPrePartitionedWindowFunction() {
        this.assertQueryOrdered("SELECT orderkey, COUNT(*) OVER (PARTITION BY orderkey, custkey) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) ORDER BY orderkey LIMIT 5", "VALUES (1, 1), (2, 1), (3, 1), (4, 1), (5, 1)");
    }

    @Test
    public void testFullPrePartitionedWindowFunction() {
        this.assertQueryOrdered("SELECT orderkey, COUNT(*) OVER (PARTITION BY orderkey) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) ORDER BY orderkey LIMIT 5", "VALUES (1, 1), (2, 1), (3, 1), (4, 1), (5, 1)");
    }

    @Test
    public void testPartialPreSortedWindowFunction() {
        this.assertQueryOrdered("SELECT orderkey, COUNT(*) OVER (ORDER BY orderkey, custkey) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) ORDER BY orderkey LIMIT 5", "VALUES (1, 1), (2, 2), (3, 3), (4, 4), (5, 5)");
    }

    @Test
    public void testFullPreSortedWindowFunction() {
        this.assertQueryOrdered("SELECT orderkey, COUNT(*) OVER (ORDER BY orderkey) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) ORDER BY orderkey LIMIT 5", "VALUES (1, 1), (2, 2), (3, 3), (4, 4), (5, 5)");
    }

    @Test
    public void testFullyPartitionedAndPartiallySortedWindowFunction() {
        this.assertQueryOrdered("SELECT orderkey, custkey, orderPriority, COUNT(*) OVER (PARTITION BY orderkey ORDER BY custkey, orderPriority) FROM (SELECT * FROM orders ORDER BY orderkey, custkey LIMIT 10) ORDER BY orderkey LIMIT 5", "VALUES (1, 370, '5-LOW', 1), (2, 781, '1-URGENT', 1), (3, 1234, '5-LOW', 1), (4, 1369, '5-LOW', 1), (5, 445, '5-LOW', 1)");
    }

    @Test
    public void testFullyPartitionedAndFullySortedWindowFunction() {
        this.assertQueryOrdered("SELECT orderkey, custkey, COUNT(*) OVER (PARTITION BY orderkey ORDER BY custkey) FROM (SELECT * FROM orders ORDER BY orderkey, custkey LIMIT 10) ORDER BY orderkey LIMIT 5", "VALUES (1, 370, 1), (2, 781, 1), (3, 1234, 1), (4, 1369, 1), (5, 445, 1)");
    }

    @Test
    public void testOrderByWindowFunctionWithNulls() {
        this.assertQueryOrdered("SELECT orderkey, row_number() OVER (ORDER BY nullif(orderkey, 3) NULLS FIRST) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) ORDER BY 2 ASC LIMIT 5", "VALUES (3, 1), (1, 2), (2, 3), (4, 4),(5, 5)");
        String nullsLastExpected = "VALUES (3, 10), (34, 9), (33, 8), (32, 7), (7, 6)";
        this.assertQueryOrdered("SELECT orderkey, row_number() OVER (ORDER BY nullif(orderkey, 3) NULLS LAST) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) ORDER BY 2 DESC LIMIT 5", nullsLastExpected);
        this.assertQueryOrdered("SELECT orderkey, row_number() OVER (ORDER BY nullif(orderkey, 3)) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) ORDER BY 2 DESC LIMIT 5", nullsLastExpected);
    }

    @Test
    public void testValueWindowFunctions() {
        this.assertQueryOrdered("SELECT * FROM (   SELECT orderkey, orderstatus     , first_value(orderkey + 1000) OVER (PARTITION BY orderstatus ORDER BY orderkey) fvalue     , nth_value(orderkey + 1000, 2) OVER (PARTITION BY orderstatus ORDER BY orderkey         ROWS BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING) nvalue     FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) x   ) x ORDER BY orderkey LIMIT 5", "VALUES (1, 'O', 1001, 1002), (2, 'O', 1001, 1002), (3, 'F', 1003, 1005), (4, 'O', 1001, 1002), (5, 'F', 1003, 1005)");
    }

    @Test
    public void testWindowFrames() {
        MaterializedResult actual = this.computeActual("SELECT * FROM (\n  SELECT orderkey, orderstatus\n    , sum(orderkey + 1000) OVER (PARTITION BY orderstatus ORDER BY orderkey\n        ROWS BETWEEN mod(custkey, 2) PRECEDING AND custkey / 500 FOLLOWING)\n    FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) x\n  ) x\nORDER BY orderkey LIMIT 5");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1L, "O", 1001L}).row(new Object[]{2L, "O", 3007L}).row(new Object[]{3L, "F", 3014L}).row(new Object[]{4L, "O", 4045L}).row(new Object[]{5L, "F", 2008L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testWindowNoChannels() {
        MaterializedResult actual = this.computeActual("SELECT rank() OVER ()\nFROM (SELECT * FROM orders LIMIT 10)\nLIMIT 3");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1L}).row(new Object[]{1L}).row(new Object[]{1L}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testInvalidWindowFunction() {
        this.assertQueryFails("SELECT abs(x) OVER ()\nFROM (VALUES (1), (2), (3)) t(x)", "line 1:1: Not a window function: abs");
    }

    @Test
    public void testScalarFunction() {
        this.assertQuery("SELECT SUBSTR('Quadratically', 5, 6)");
    }

    @Test
    public void testCast() {
        this.assertQuery("SELECT CAST('1' AS BIGINT)");
        this.assertQuery("SELECT CAST(totalprice AS BIGINT) FROM orders");
        this.assertQuery("SELECT CAST(orderkey AS DOUBLE) FROM orders");
        this.assertQuery("SELECT CAST(orderkey AS VARCHAR) FROM orders");
        this.assertQuery("SELECT CAST(orderkey AS BOOLEAN) FROM orders");
        this.assertQuery("SELECT try_cast('1' AS BIGINT)", "SELECT CAST('1' AS BIGINT)");
        this.assertQuery("SELECT try_cast(totalprice AS BIGINT) FROM orders", "SELECT CAST(totalprice AS BIGINT) FROM orders");
        this.assertQuery("SELECT try_cast(orderkey AS DOUBLE) FROM orders", "SELECT CAST(orderkey AS DOUBLE) FROM orders");
        this.assertQuery("SELECT try_cast(orderkey AS VARCHAR) FROM orders", "SELECT CAST(orderkey AS VARCHAR) FROM orders");
        this.assertQuery("SELECT try_cast(orderkey AS BOOLEAN) FROM orders", "SELECT CAST(orderkey AS BOOLEAN) FROM orders");
        this.assertQuery("SELECT try_cast('foo' AS BIGINT)", "SELECT CAST(null AS BIGINT)");
        this.assertQuery("SELECT try_cast(clerk AS BIGINT) FROM orders", "SELECT CAST(null AS BIGINT) FROM orders");
        this.assertQuery("SELECT try_cast(orderkey * orderkey AS VARCHAR) FROM orders", "SELECT CAST(orderkey * orderkey AS VARCHAR) FROM orders");
        this.assertQuery("SELECT try_cast(try_cast(orderkey AS VARCHAR) AS BIGINT) FROM orders", "SELECT orderkey FROM orders");
        this.assertQuery("SELECT try_cast(clerk AS VARCHAR) || try_cast(clerk AS VARCHAR) FROM orders", "SELECT clerk || clerk FROM orders");
        this.assertQuery("SELECT coalesce(try_cast('foo' AS BIGINT), 456)", "SELECT 456");
        this.assertQuery("SELECT coalesce(try_cast(clerk AS BIGINT), 456) FROM orders", "SELECT 456 FROM orders");
        this.assertQuery("SELECT CAST(x AS BIGINT) FROM (VALUES 1, 2, 3, NULL) t (x)", "VALUES 1, 2, 3, NULL");
        this.assertQuery("SELECT try_cast(x AS BIGINT) FROM (VALUES 1, 2, 3, NULL) t (x)", "VALUES 1, 2, 3, NULL");
    }

    @Test
    public void testNestedCast() {
        this.assertQuery("select cast(varchar_value as varchar(3)) || ' sfd' from (values ('9898.122')) t(varchar_value)", "VALUES '989 sfd'");
        this.assertQuery("select cast(cast(varchar_value as varchar(3)) as varchar(5)) from (values ('9898.122')) t(varchar_value)", "VALUES '989'");
    }

    @Test
    public void testInvalidCast() {
        this.assertQueryFails("SELECT CAST(1 AS DATE)", "line 1:8: Cannot cast integer to date");
    }

    @Test
    public void testInvalidCastInMultilineQuery() {
        this.assertQueryFails("SELECT CAST(totalprice AS BIGINT),\nCAST(2015 AS DATE),\nCAST(orderkey AS DOUBLE) FROM orders", "line 2:1: Cannot cast integer to date");
    }

    @Test
    public void testTryInvalidCast() {
        this.assertQuery("SELECT TRY(CAST('a' AS BIGINT))", "SELECT NULL");
    }

    @Test
    public void testConcatOperator() {
        this.assertQuery("SELECT '12' || '34'");
    }

    @Test
    public void testQuotedIdentifiers() {
        this.assertQuery("SELECT \"TOTALPRICE\" \"my price\" FROM \"ORDERS\"");
    }

    @Test
    public void testInvalidColumn() {
        this.assertQueryFails("SELECT * FROM lineitem l JOIN (SELECT orderkey_1, custkey FROM orders) o on l.orderkey = o.orderkey_1", "line 1:39: Column 'orderkey_1' cannot be resolved");
    }

    @Test
    public void testUnaliasedSubqueries() {
        this.assertQuery("SELECT orderkey FROM (SELECT orderkey FROM orders)");
    }

    @Test
    public void testUnaliasedSubqueries1() {
        this.assertQuery("SELECT a FROM (SELECT orderkey a FROM orders)");
    }

    @Test
    public void testJoinUnaliasedSubqueries() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem) JOIN (SELECT * FROM orders) USING (orderkey)", "SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testWith() {
        this.assertQuery("WITH a AS (SELECT * FROM orders) SELECT * FROM a", "SELECT * FROM orders");
        this.assertQuerySucceeds("WITH t(x, y, z) AS (TABLE region) SELECT * FROM t");
    }

    @Test
    public void testWithQualifiedPrefix() {
        this.assertQuery("WITH a AS (SELECT 123) SELECT a.* FROM a", "SELECT 123");
    }

    @Test
    public void testWithAliased() {
        this.assertQuery("WITH a AS (SELECT * FROM orders) SELECT * FROM a x", "SELECT * FROM orders");
    }

    @Test
    public void testReferenceToWithQueryInFromClause() {
        this.assertQuery("WITH a AS (SELECT * FROM orders)SELECT * FROM (   SELECT * FROM a)", "SELECT * FROM orders");
    }

    @Test
    public void testWithChaining() {
        this.assertQuery("WITH a AS (SELECT orderkey n FROM orders)\n, b AS (SELECT n + 1 n FROM a)\n, c AS (SELECT n + 1 n FROM b)\nSELECT n + 1 FROM c", "SELECT orderkey + 3 FROM orders");
    }

    @Test
    public void testWithSelfJoin() {
        this.assertQuery("WITH x AS (SELECT DISTINCT orderkey FROM orders ORDER BY orderkey LIMIT 10)\nSELECT count(*) FROM x a JOIN x b USING (orderkey)", "SELECT count(*)\nFROM (SELECT DISTINCT orderkey FROM orders ORDER BY orderkey LIMIT 10) a\nJOIN (SELECT DISTINCT orderkey FROM orders ORDER BY orderkey LIMIT 10) b ON a.orderkey = b.orderkey");
    }

    @Test
    public void testWithNestedSubqueries() {
        this.assertQuery("WITH a AS (\n  WITH aa AS (SELECT 123 x FROM orders LIMIT 1)\n  SELECT x y FROM aa\n), b AS (\n  WITH bb AS (\n    WITH bbb AS (SELECT y FROM a)\n    SELECT bbb.* FROM bbb\n  )\n  SELECT y z FROM bb\n)\nSELECT *\nFROM (\n  WITH q AS (SELECT z w FROM b)\n  SELECT j.*, k.*\n  FROM a j\n  JOIN q k ON (j.y = k.w)\n) t", "SELECT 123, 123 FROM orders LIMIT 1");
    }

    @Test
    public void testWithColumnAliasing() {
        this.assertQuery("WITH a (id) AS (SELECT 123) SELECT id FROM a", "SELECT 123");
        this.assertQuery("WITH t (a, b, c) AS (SELECT 1, custkey x, orderkey FROM orders) SELECT c, b, a FROM t", "SELECT orderkey, custkey, 1 FROM orders");
    }

    @Test
    public void testWithHiding() {
        this.assertQuery("WITH a AS (SELECT 1),      b AS (         WITH a AS (SELECT 2)         SELECT * FROM a    )SELECT * FROM b", "SELECT 2");
        this.assertQueryFails("WITH a AS (VALUES 1),      a AS (VALUES 2)SELECT * FROM a", "line 1:28: WITH query name 'a' specified more than once");
    }

    @Test
    public void testWithRecursive() {
        this.assertQueryFails("WITH RECURSIVE a AS (SELECT 123) SELECT * FROM a", "line 1:1: Recursive WITH queries are not supported");
    }

    @Test
    public void testCaseNoElse() {
        this.assertQuery("SELECT orderkey, CASE orderstatus WHEN 'O' THEN 'a' END FROM orders");
    }

    @Test
    public void testCaseNoElseInconsistentResultType() {
        this.assertQueryFails("SELECT orderkey, CASE orderstatus WHEN 'O' THEN 'a' WHEN '1' THEN 2 END FROM orders", "\\Qline 1:67: All CASE results must be the same type: varchar(1)\\E");
    }

    @Test
    public void testCaseWithSupertypeCast() {
        this.assertQuery(" SELECT CASE x WHEN 1 THEN CAST(1 AS decimal(4,1)) WHEN 2 THEN CAST(1 AS decimal(4,2)) ELSE CAST(1 AS decimal(4,3)) END FROM (values 1) t(x)", "SELECT 1.000");
    }

    @Test
    public void testIfExpression() {
        this.assertQuery("SELECT sum(IF(orderstatus = 'F', totalprice, 0.0)) FROM orders", "SELECT sum(CASE WHEN orderstatus = 'F' THEN totalprice ELSE 0.0 END) FROM orders");
        this.assertQuery("SELECT sum(IF(orderstatus = 'Z', totalprice)) FROM orders", "SELECT sum(CASE WHEN orderstatus = 'Z' THEN totalprice END) FROM orders");
        this.assertQuery("SELECT sum(IF(orderstatus = 'F', NULL, totalprice)) FROM orders", "SELECT sum(CASE WHEN orderstatus = 'F' THEN NULL ELSE totalprice END) FROM orders");
        this.assertQuery("SELECT IF(orderstatus = 'Z', orderkey / 0, orderkey) FROM orders", "SELECT CASE WHEN orderstatus = 'Z' THEN orderkey / 0 ELSE orderkey END FROM orders");
        this.assertQuery("SELECT sum(IF(NULLIF(orderstatus, 'F') <> 'F', totalprice, 5.1)) FROM orders", "SELECT sum(CASE WHEN NULLIF(orderstatus, 'F') <> 'F' THEN totalprice ELSE 5.1 END) FROM orders");
        this.assertQuery("SELECT if(true, CAST(1 AS decimal(2,1)), 1)", "SELECT 1.0");
    }

    @Test
    public void testIn() {
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (1, 2, 3)");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (1.5, 2.3)", "SELECT orderkey FROM orders LIMIT 0");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (1, 2E0, 3)");
        this.assertQuery("SELECT orderkey FROM orders WHERE totalprice IN (1, 2, 3)");
        this.assertQuery("SELECT x FROM (values 3, 100) t(x) WHERE x IN (2147483649)", "SELECT * WHERE false");
        this.assertQuery("SELECT x FROM (values 3, 100, 2147483648, 2147483649, 2147483650) t(x) WHERE x IN (2147483648, 2147483650)", "values 2147483648, 2147483650");
        this.assertQuery("SELECT x FROM (values 3, 100, 2147483648, 2147483649, 2147483650) t(x) WHERE x IN (3, 4, 2147483648, 2147483650)", "values 3, 2147483648, 2147483650");
        this.assertQuery("SELECT x FROM (values 1, 2, 3) t(x) WHERE x IN (1 + CAST(rand() < 0 AS bigint), 2 + CAST(rand() < 0 AS bigint))", "values 1, 2");
        this.assertQuery("SELECT x FROM (values 1, 2, 3, 4) t(x) WHERE x IN (1 + CAST(rand() < 0 AS bigint), 2 + CAST(rand() < 0 AS bigint), 4)", "values 1, 2, 4");
        this.assertQuery("SELECT x FROM (values 1, 2, 3, 4) t(x) WHERE x IN (4, 2, 1)", "values 1, 2, 4");
        this.assertQuery("SELECT x FROM (values 1, 2, 3, 2147483648) t(x) WHERE x IN (1 + CAST(rand() < 0 AS bigint), 2 + CAST(rand() < 0 AS bigint), 2147483648)", "values 1, 2, 2147483648");
        this.assertQuery("SELECT x IN (0) FROM (values 4294967296) t(x)", "values false");
        this.assertQuery("SELECT x IN (0, 4294967297 + CAST(rand() < 0 AS bigint)) FROM (values 4294967296, 4294967297) t(x)", "values false, true");
        this.assertQuery("SELECT NULL in (1, 2, 3)", "values null");
        this.assertQuery("SELECT 1 in (1, NULL, 3)", "values true");
        this.assertQuery("SELECT 2 in (1, NULL, 3)", "values null");
        this.assertQuery("SELECT x FROM (values DATE '1970-01-01', DATE '1970-01-03') t(x) WHERE x IN (DATE '1970-01-01')", "values DATE '1970-01-01'");
        Assert.assertEquals((Collection)this.computeActual("SELECT x FROM (values TIMESTAMP '1970-01-01 00:01:00+00:00', TIMESTAMP '1970-01-01 08:01:00+08:00', TIMESTAMP '1970-01-01 00:01:00+08:00') t(x) WHERE x IN (TIMESTAMP '1970-01-01 00:01:00+00:00')").getOnlyColumn().collect(Collectors.toList()), (Collection)ImmutableList.of((Object)this.zonedDateTime("1970-01-01 00:01:00.000 UTC"), (Object)this.zonedDateTime("1970-01-01 08:01:00.000 +08:00")));
        this.assertQuery("SELECT COUNT(*) FROM (values 1) t(x) WHERE x IN (null, 0)", "SELECT 0");
        this.assertQuery("SELECT d IN (DECIMAL '2.0', DECIMAL '30.0') FROM (VALUES (2.0E0)) t(d)", "SELECT true");
    }

    @Test
    public void testLargeIn() {
        String longValues = IntStream.range(0, 5000).mapToObj(Integer::toString).collect(Collectors.joining(", "));
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (" + longValues + ")");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey NOT IN (" + longValues + ")");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (mod(1000, orderkey), " + longValues + ")");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey NOT IN (mod(1000, orderkey), " + longValues + ")");
        String varcharValues = IntStream.range(0, 5000).mapToObj(i -> "'" + i + "'").collect(Collectors.joining(", "));
        this.assertQuery("SELECT orderkey FROM orders WHERE cast(orderkey AS VARCHAR) IN (" + varcharValues + ")");
        this.assertQuery("SELECT orderkey FROM orders WHERE cast(orderkey AS VARCHAR) NOT IN (" + varcharValues + ")");
        String arrayValues = IntStream.range(0, 5000).mapToObj(i -> String.format("ARRAY[%s, %s, %s]", i, i + 1, i + 2)).collect(Collectors.joining(", "));
        this.assertQuery("SELECT ARRAY[0, 0, 0] in (ARRAY[0, 0, 0], " + arrayValues + ")", "values true");
        this.assertQuery("SELECT ARRAY[0, 0, 0] in (" + arrayValues + ")", "values false");
    }

    @Test
    public void testNullOnLhsOfInPredicateAllowed() {
        this.assertQuery("SELECT NULL IN (1, 2, 3)", "SELECT NULL");
        this.assertQuery("SELECT NULL IN (SELECT 1)", "SELECT NULL");
        this.assertQuery("SELECT NULL IN (SELECT 1 WHERE FALSE)", "SELECT FALSE");
        this.assertQuery("SELECT x FROM (VALUES NULL) t(x) WHERE x IN (SELECT 1)", "SELECT 33 WHERE FALSE");
        this.assertQuery("SELECT NULL IN (SELECT CAST(NULL AS BIGINT))", "SELECT NULL");
        this.assertQuery("SELECT NULL IN (SELECT NULL WHERE FALSE)", "SELECT FALSE");
        this.assertQuery("SELECT NULL IN ((SELECT 1) UNION ALL (SELECT NULL))", "SELECT NULL");
        this.assertQuery("SELECT x IN (SELECT TRUE) FROM (SELECT * FROM (VALUES CAST(NULL AS BOOLEAN)) t(x) WHERE (x OR NULL) IS NULL)", "SELECT NULL");
        this.assertQuery("SELECT x IN (SELECT 1) FROM (SELECT * FROM (VALUES CAST(NULL AS INTEGER)) t(x) WHERE (x + 10 IS NULL) OR X = 2)", "SELECT NULL");
        this.assertQuery("SELECT x IN (SELECT 1 WHERE FALSE) FROM (SELECT * FROM (VALUES CAST(NULL AS INTEGER)) t(x) WHERE (x + 10 IS NULL) OR X = 2)", "SELECT FALSE");
    }

    @Test
    public void testInSubqueryWithCrossJoin() {
        this.assertQuery("SELECT a FROM (VALUES (1),(2)) t(a) WHERE a IN (SELECT b FROM (VALUES (ARRAY[2])) AS t1 (a) CROSS JOIN UNNEST(a) AS t2(b))", "SELECT 2");
    }

    @Test
    public void testDuplicateFields() {
        this.assertQuery("SELECT * FROM (SELECT orderkey, orderkey FROM orders)", "SELECT orderkey, orderkey FROM orders");
    }

    @Test
    public void testDuplicateColumnsInWindowOrderByClause() {
        MaterializedResult actual = this.computeActual("SELECT a, row_number() OVER (ORDER BY a ASC, a DESC) FROM (VALUES 3, 2, 1) t(a)");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{1, 1L}).row(new Object[]{2, 2L}).row(new Object[]{3, 3L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    @Test
    public void testWildcardFromSubquery() {
        this.assertQuery("SELECT * FROM (SELECT orderkey X FROM orders)");
    }

    @Test
    public void testCaseInsensitiveAttribute() {
        this.assertQuery("SELECT x FROM (SELECT orderkey X FROM orders)");
    }

    @Test
    public void testCaseInsensitiveAliasedRelation() {
        this.assertQuery("SELECT A.* FROM orders a");
    }

    @Test
    public void testCaseInsensitiveRowFieldReference() {
        this.assertQuery("SELECT a.Col0 FROM (VALUES row(cast(ROW(1,2) AS ROW(col0 integer, col1 integer)))) AS t (a)", "SELECT 1");
    }

    @Test
    public void testSubqueryBody() {
        this.assertQuery("(SELECT orderkey, custkey FROM orders)");
    }

    @Test
    public void testSubqueryBodyOrderLimit() {
        this.assertQueryOrdered("(SELECT orderkey AS a, custkey AS b FROM orders) ORDER BY a LIMIT 1");
    }

    @Test
    public void testSubqueryBodyProjectedOrderby() {
        this.assertQueryOrdered("(SELECT orderkey, custkey FROM orders) ORDER BY orderkey * -1");
    }

    @Test
    public void testSubqueryBodyDoubleOrderby() {
        this.assertQueryOrdered("(SELECT orderkey, custkey FROM orders ORDER BY custkey) ORDER BY orderkey");
    }

    @Test
    public void testNodeRoster() {
        List result = this.computeActual("SELECT * FROM system.runtime.nodes").getMaterializedRows();
        Assert.assertEquals((int)result.size(), (int)this.getNodeCount());
    }

    @Test
    public void testCountOnInternalTables() {
        List rows = this.computeActual("SELECT count(*) FROM system.runtime.nodes").getMaterializedRows();
        Assert.assertEquals((long)((Long)((MaterializedRow)rows.get(0)).getField(0)), (long)this.getNodeCount());
    }

    @Test
    public void testTransactionsTable() {
        List result = this.computeActual("SELECT * FROM system.runtime.transactions").getMaterializedRows();
        org.testng.Assert.assertTrue((result.size() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testDefaultExplainTextFormat() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getExplainPlan(query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testDefaultExplainGraphvizFormat() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (FORMAT GRAPHVIZ) " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getGraphvizExplainPlan(query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testLogicalExplain() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE LOGICAL) " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getExplainPlan(query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testIOExplain() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE IO) " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getExplainPlan(query, ExplainType.Type.IO));
    }

    @Test
    public void testLogicalExplainTextFormat() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE LOGICAL, FORMAT TEXT) " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getExplainPlan(query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testLogicalExplainGraphvizFormat() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE LOGICAL, FORMAT GRAPHVIZ) " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getGraphvizExplainPlan(query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testLogicalExplainJsonFormat() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE LOGICAL, FORMAT JSON) " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getJsonExplainPlan(query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testDistributedExplain() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE DISTRIBUTED) " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getExplainPlan(query, ExplainType.Type.DISTRIBUTED));
    }

    @Test
    public void testDistributedExplainTextFormat() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE DISTRIBUTED, FORMAT TEXT) " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getExplainPlan(query, ExplainType.Type.DISTRIBUTED));
    }

    @Test
    public void testDistributedExplainGraphvizFormat() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE DISTRIBUTED, FORMAT GRAPHVIZ) " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getGraphvizExplainPlan(query, ExplainType.Type.DISTRIBUTED));
    }

    @Test
    public void testDistributedExplainJsonFormat() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE DISTRIBUTED, FORMAT JSON) " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getJsonExplainPlan(query, ExplainType.Type.DISTRIBUTED));
    }

    @Test
    public void testExplainValidate() {
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE VALIDATE) SELECT 1");
        Assert.assertEquals((Object)result.getOnlyValue(), (Object)true);
    }

    @Test(expectedExceptions={Exception.class}, expectedExceptionsMessageRegExp="line 1:32: Column 'x' cannot be resolved")
    public void testExplainValidateThrows() {
        this.computeActual("EXPLAIN (TYPE VALIDATE) SELECT x");
    }

    @Test
    public void testExplainOfExplain() {
        String query = "EXPLAIN SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getExplainPlan(query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testExplainOfExplainAnalyze() {
        String query = "EXPLAIN ANALYZE SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getExplainPlan(query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testExplainDdl() {
        this.assertExplainDdl("CREATE TABLE foo (pk bigint)", "CREATE TABLE foo");
        this.assertExplainDdl("CREATE VIEW foo AS SELECT * FROM orders", "CREATE VIEW foo");
        this.assertExplainDdl("CREATE OR REPLACE FUNCTION testing.default.tan (x int) RETURNS double COMMENT 'tangent trigonometric function' LANGUAGE SQL DETERMINISTIC CALLED ON NULL INPUT RETURN sin(x) / cos(x)", "CREATE FUNCTION testing.default.tan");
        this.assertExplainDdl("ALTER FUNCTION testing.default.tan CALLED ON NULL INPUT", "ALTER FUNCTION testing.default.tan");
        this.assertExplainDdl("DROP FUNCTION IF EXISTS testing.default.tan (int)", "DROP FUNCTION testing.default.tan");
        this.assertExplainDdl("DROP TABLE orders");
        this.assertExplainDdl("DROP VIEW view");
        this.assertExplainDdl("ALTER TABLE orders RENAME TO new_name");
        this.assertExplainDdl("ALTER TABLE orders RENAME COLUMN orderkey TO new_column_name");
        this.assertExplainDdl("SET SESSION foo = 'bar'");
        this.assertExplainDdl("PREPARE my_query FROM SELECT * FROM orders", "PREPARE my_query");
        this.assertExplainDdl("DEALLOCATE PREPARE my_query");
        this.assertExplainDdl("RESET SESSION foo");
        this.assertExplainDdl("START TRANSACTION");
        this.assertExplainDdl("COMMIT");
        this.assertExplainDdl("ROLLBACK");
    }

    private void assertExplainDdl(String query) {
        this.assertExplainDdl(query, query);
    }

    private void assertExplainDdl(String query, String expected) {
        MaterializedResult result = this.computeActual("EXPLAIN " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)expected);
    }

    @Test
    public void testExplainExecute() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SELECT * FROM orders").build();
        MaterializedResult result = this.computeActual(session, "EXPLAIN (TYPE LOGICAL) EXECUTE my_query");
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getExplainPlan("SELECT * FROM orders", ExplainType.Type.LOGICAL));
    }

    @Test
    public void testExplainExecuteWithUsing() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SELECT * FROM orders WHERE orderkey < ?").build();
        MaterializedResult result = this.computeActual(session, "EXPLAIN (TYPE LOGICAL) EXECUTE my_query USING 7");
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getExplainPlan("SELECT * FROM orders WHERE orderkey < 7", ExplainType.Type.LOGICAL));
    }

    @Test
    public void testExplainSetSessionWithUsing() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SET SESSION foo = ?").build();
        MaterializedResult result = this.computeActual(session, "EXPLAIN (TYPE LOGICAL) EXECUTE my_query USING 7");
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)"SET SESSION foo = 7");
    }

    @Test
    public void testShowCatalogs() {
        MaterializedResult result = this.computeActual("SHOW CATALOGS");
        org.testng.Assert.assertTrue((boolean)result.getOnlyColumnAsSet().contains(this.getSession().getCatalog().get()));
    }

    @Test
    public void testShowCatalogsLike() {
        MaterializedResult result = this.computeActual(String.format("SHOW CATALOGS LIKE '%s'", this.getSession().getCatalog().get()));
        Assert.assertEquals((Set)result.getOnlyColumnAsSet(), (Set)ImmutableSet.of(this.getSession().getCatalog().get()));
    }

    @Test
    public void testShowSchemas() {
        MaterializedResult result = this.computeActual("SHOW SCHEMAS");
        org.testng.Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll((Collection<?>)ImmutableSet.of(this.getSession().getSchema().get(), (Object)"information_schema")));
    }

    @Test
    public void testShowSchemasFrom() {
        MaterializedResult result = this.computeActual(String.format("SHOW SCHEMAS FROM %s", this.getSession().getCatalog().get()));
        org.testng.Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll((Collection<?>)ImmutableSet.of(this.getSession().getSchema().get(), (Object)"information_schema")));
    }

    @Test
    public void testShowSchemasLike() {
        MaterializedResult result = this.computeActual(String.format("SHOW SCHEMAS LIKE '%s'", this.getSession().getSchema().get()));
        Assert.assertEquals((Set)result.getOnlyColumnAsSet(), (Set)ImmutableSet.of(this.getSession().getSchema().get()));
    }

    @Test
    public void testShowSchemasLikeWithEscape() {
        this.assertQueryFails("SHOW SCHEMAS IN foo LIKE '%$_%' ESCAPE", "line 1:39: mismatched input '<EOF>'. Expecting: <string>");
        this.assertQueryFails("SHOW SCHEMAS LIKE 't$_%' ESCAPE ''", "Escape string must be a single character");
        this.assertQueryFails("SHOW SCHEMAS LIKE 't$_%' ESCAPE '$$'", "Escape string must be a single character");
        Set allSchemas = this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet();
        Assert.assertEquals((Set)allSchemas, (Set)this.computeActual("SHOW SCHEMAS LIKE '%_%'").getOnlyColumnAsSet());
        Set result = this.computeActual("SHOW SCHEMAS LIKE '%$_%' ESCAPE '$'").getOnlyColumnAsSet();
        org.testng.Assert.assertNotEquals((Object)allSchemas, (Object)result);
        Assertions.assertThat((Iterable)result).contains(new Object[]{"information_schema"}).allMatch(schemaName -> ((String)schemaName).contains("_"));
    }

    @Test
    public void testShowTables() {
        ImmutableSet expectedTables = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)TpchTable.getTables(), TpchTable::getTableName));
        MaterializedResult result = this.computeActual("SHOW TABLES");
        org.testng.Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll((Collection<?>)expectedTables));
    }

    @Test
    public void testShowTablesFrom() {
        ImmutableSet expectedTables = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)TpchTable.getTables(), TpchTable::getTableName));
        String catalog = (String)this.getSession().getCatalog().get();
        String schema = (String)this.getSession().getSchema().get();
        MaterializedResult result = this.computeActual("SHOW TABLES FROM " + schema);
        org.testng.Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll((Collection<?>)expectedTables));
        result = this.computeActual("SHOW TABLES FROM " + catalog + "." + schema);
        org.testng.Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll((Collection<?>)expectedTables));
        this.assertQueryFails("SHOW TABLES FROM UNKNOWN", "line 1:1: Schema 'unknown' does not exist");
        this.assertQueryFails("SHOW TABLES FROM UNKNOWNCATALOG.UNKNOWNSCHEMA", "line 1:1: Catalog 'unknowncatalog' does not exist");
    }

    @Test
    public void testShowTablesLike() {
        Assertions.assertThat((Iterable)this.computeActual("SHOW TABLES LIKE 'or%'").getOnlyColumnAsSet()).contains(new Object[]{"orders"}).allMatch(tableName -> ((String)tableName).startsWith("or"));
    }

    @Test
    public void testShowTablesLikeWithEscape() {
        this.assertQueryFails("SHOW TABLES IN a LIKE '%$_%' ESCAPE", "line 1:36: mismatched input '<EOF>'. Expecting: <string>");
        this.assertQueryFails("SHOW TABLES LIKE 't$_%' ESCAPE ''", "Escape string must be a single character");
        this.assertQueryFails("SHOW TABLES LIKE 't$_%' ESCAPE '$$'", "Escape string must be a single character");
        Set allTables = this.computeActual("SHOW TABLES FROM information_schema").getOnlyColumnAsSet();
        Assert.assertEquals((Set)allTables, (Set)this.computeActual("SHOW TABLES FROM information_schema LIKE '%_%'").getOnlyColumnAsSet());
        Set result = this.computeActual("SHOW TABLES FROM information_schema LIKE '%$_%' ESCAPE '$'").getOnlyColumnAsSet();
        org.testng.Assert.assertNotEquals((Object)allTables, (Object)result);
        Assertions.assertThat((Iterable)result).contains(new Object[]{"table_privileges"}).allMatch(schemaName -> ((String)schemaName).contains("_"));
    }

    @Test
    public void testShowColumns() {
        MaterializedResult actual = this.computeActual("SHOW COLUMNS FROM orders");
        MaterializedResult expectedUnparametrizedVarchar = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", "", ""}).row(new Object[]{"custkey", "bigint", "", ""}).row(new Object[]{"orderstatus", "varchar", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", "date", "", ""}).row(new Object[]{"orderpriority", "varchar", "", ""}).row(new Object[]{"clerk", "varchar", "", ""}).row(new Object[]{"shippriority", "integer", "", ""}).row(new Object[]{"comment", "varchar", "", ""}).build();
        MaterializedResult expectedParametrizedVarchar = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", "", ""}).row(new Object[]{"custkey", "bigint", "", ""}).row(new Object[]{"orderstatus", "varchar(1)", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", "date", "", ""}).row(new Object[]{"orderpriority", "varchar(15)", "", ""}).row(new Object[]{"clerk", "varchar(15)", "", ""}).row(new Object[]{"shippriority", "integer", "", ""}).row(new Object[]{"comment", "varchar(79)", "", ""}).build();
        org.testng.Assert.assertTrue((actual.equals((Object)expectedParametrizedVarchar) || actual.equals((Object)expectedUnparametrizedVarchar) ? 1 : 0) != 0, (String)String.format("%s does not matche neither of %s and %s", actual, expectedParametrizedVarchar, expectedUnparametrizedVarchar));
    }

    @Test
    public void testAtTimeZone() {
        Assert.assertEquals((Object)this.computeScalar("SELECT TIMESTAMP '2012-10-31 01:00' AT TIME ZONE INTERVAL '07:09' hour to minute"), (Object)this.zonedDateTime("2012-10-30 18:09:00.000 +07:09"));
        Assert.assertEquals((Object)this.computeScalar("SELECT TIMESTAMP '2012-10-31 01:00' AT TIME ZONE 'Asia/Oral'"), (Object)this.zonedDateTime("2012-10-30 16:00:00.000 Asia/Oral"));
        Assert.assertEquals((Object)this.computeScalar("SELECT MIN(x) AT TIME ZONE 'America/Chicago' FROM (VALUES TIMESTAMP '1970-01-01 00:01:00+00:00') t(x)"), (Object)this.zonedDateTime("1969-12-31 18:01:00.000 America/Chicago"));
        Assert.assertEquals((Object)this.computeScalar("SELECT TIMESTAMP '2012-10-31 01:00' AT TIME ZONE '+07:09'"), (Object)this.zonedDateTime("2012-10-30 18:09:00.000 +07:09"));
        Assert.assertEquals((Object)this.computeScalar("SELECT TIMESTAMP '2012-10-31 01:00 UTC' AT TIME ZONE 'America/Los_Angeles'"), (Object)this.zonedDateTime("2012-10-30 18:00:00.000 America/Los_Angeles"));
        Assert.assertEquals((Object)this.computeScalar("SELECT TIMESTAMP '2012-10-31 01:00' AT TIME ZONE 'America/Los_Angeles'"), (Object)this.zonedDateTime("2012-10-30 04:00:00.000 America/Los_Angeles"));
        Assert.assertEquals((Set)this.computeActual("SELECT x AT TIME ZONE 'America/Los_Angeles' FROM (values TIMESTAMP '1970-01-01 00:01:00+00:00', TIMESTAMP '1970-01-01 08:01:00+08:00', TIMESTAMP '1969-12-31 16:01:00-08:00') t(x)").getOnlyColumnAsSet(), (Set)ImmutableSet.of((Object)this.zonedDateTime("1969-12-31 16:01:00.000 America/Los_Angeles")));
        Assert.assertEquals((Collection)this.computeActual("SELECT x AT TIME ZONE 'America/Los_Angeles' FROM (values TIMESTAMP '1970-01-01 00:01:00', TIMESTAMP '1970-01-01 08:01:00', TIMESTAMP '1969-12-31 16:01:00') t(x)").getOnlyColumn().collect(Collectors.toList()), (Collection)ImmutableList.of((Object)this.zonedDateTime("1970-01-01 03:01:00.000 America/Los_Angeles"), (Object)this.zonedDateTime("1970-01-01 11:01:00.000 America/Los_Angeles"), (Object)this.zonedDateTime("1969-12-31 19:01:00.000 America/Los_Angeles")));
        Assert.assertEquals((Object)this.computeScalar("SELECT min(x) AT TIME ZONE 'America/Los_Angeles' FROM (values TIMESTAMP '1970-01-01 00:01:00+00:00', TIMESTAMP '1970-01-01 08:01:00+08:00', TIMESTAMP '1969-12-31 16:01:00-08:00') t(x)"), (Object)this.zonedDateTime("1969-12-31 16:01:00.000 America/Los_Angeles"));
        Assert.assertEquals((Object)this.computeScalar("SELECT TIMESTAMP '2012-10-31 01:00' AT TIME ZONE 'America/Los_Angeles' AT TIME ZONE 'UTC'"), (Object)this.zonedDateTime("2012-10-30 11:00:00.000 UTC"));
        Assert.assertEquals((Object)this.computeScalar("SELECT TIMESTAMP '2012-10-31 01:00' AT TIME ZONE 'Asia/Tokyo' AT TIME ZONE 'America/Los_Angeles'"), (Object)this.zonedDateTime("2012-10-30 04:00:00.000 America/Los_Angeles"));
        Assert.assertEquals((Object)this.computeScalar("SELECT TIMESTAMP '2012-10-31 01:00' AT TIME ZONE 'America/Los_Angeles' AT TIME ZONE 'Asia/Shanghai'"), (Object)this.zonedDateTime("2012-10-30 19:00:00.000 Asia/Shanghai"));
        Assert.assertEquals((Object)this.computeScalar("SELECT min(x) AT TIME ZONE 'America/Los_Angeles' AT TIME ZONE 'UTC' FROM (values TIMESTAMP '1970-01-01 00:01:00+00:00', TIMESTAMP '1970-01-01 08:01:00+08:00', TIMESTAMP '1969-12-31 16:01:00-08:00') t(x)"), (Object)this.zonedDateTime("1970-01-01 00:01:00.000 UTC"));
        Assert.assertEquals((Object)this.computeScalar("SELECT * FROM (VALUES TIMESTAMP '2012-10-31 01:00' AT TIME ZONE 'Asia/Oral')"), (Object)this.zonedDateTime("2012-10-30 16:00:00.000 Asia/Oral"));
    }

    private ZonedDateTime zonedDateTime(String value) {
        return ZONED_DATE_TIME_FORMAT.parse((CharSequence)value, ZonedDateTime::from);
    }

    @Test
    public void testShowFunctions() {
        MaterializedResult result = this.computeActual("SHOW FUNCTIONS");
        ImmutableListMultimap functions = Multimaps.index((Iterable)result.getMaterializedRows(), input -> {
            Assert.assertEquals((int)input.getFieldCount(), (int)9);
            return (String)input.getField(0);
        });
        org.testng.Assert.assertTrue((boolean)functions.containsKey((Object)"avg"), (String)("Expected function names " + functions + " to contain 'avg'"));
        Assert.assertEquals((int)functions.get((Object)"avg").asList().size(), (int)6);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(0)).getField(1), (Object)"decimal(p,s)");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(0)).getField(2), (Object)"decimal(p,s)");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(0)).getField(3), (Object)"aggregate");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(1)).getField(1), (Object)"double");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(1)).getField(2), (Object)"bigint");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(1)).getField(3), (Object)"aggregate");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(2)).getField(1), (Object)"double");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(2)).getField(2), (Object)"double");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(2)).getField(3), (Object)"aggregate");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(3)).getField(1), (Object)"interval day to second");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(3)).getField(2), (Object)"interval day to second");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(3)).getField(3), (Object)"aggregate");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(4)).getField(1), (Object)"interval year to month");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(4)).getField(2), (Object)"interval year to month");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(4)).getField(3), (Object)"aggregate");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(5)).getField(1), (Object)"real");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(5)).getField(2), (Object)"real");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(5)).getField(3), (Object)"aggregate");
        org.testng.Assert.assertTrue((boolean)functions.containsKey((Object)"abs"), (String)("Expected function names " + functions + " to contain 'abs'"));
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"abs").asList().get(0)).getField(3), (Object)"scalar");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"abs").asList().get(0)).getField(4), (Object)true);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"abs").asList().get(0)).getField(6), (Object)false);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"abs").asList().get(0)).getField(7), (Object)true);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"abs").asList().get(0)).getField(8), (Object)"");
        org.testng.Assert.assertTrue((boolean)functions.containsKey((Object)"rand"), (String)("Expected function names " + functions + " to contain 'rand'"));
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"rand").asList().get(0)).getField(3), (Object)"scalar");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"rand").asList().get(0)).getField(4), (Object)false);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"rand").asList().get(0)).getField(6), (Object)false);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"rand").asList().get(0)).getField(7), (Object)true);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"rand").asList().get(0)).getField(8), (Object)"");
        org.testng.Assert.assertTrue((boolean)functions.containsKey((Object)"rank"), (String)("Expected function names " + functions + " to contain 'rank'"));
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"rank").asList().get(0)).getField(3), (Object)"window");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"rank").asList().get(0)).getField(4), (Object)true);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"rank").asList().get(0)).getField(6), (Object)false);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"rank").asList().get(0)).getField(7), (Object)true);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"rank").asList().get(0)).getField(8), (Object)"");
        org.testng.Assert.assertTrue((boolean)functions.containsKey((Object)"greatest"), (String)("Expected function names " + functions + " to contain 'greatest'"));
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"greatest").asList().get(0)).getField(3), (Object)"scalar");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"greatest").asList().get(0)).getField(4), (Object)true);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"greatest").asList().get(0)).getField(6), (Object)true);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"greatest").asList().get(0)).getField(7), (Object)true);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"greatest").asList().get(0)).getField(8), (Object)"");
        org.testng.Assert.assertTrue((boolean)functions.containsKey((Object)"split_part"), (String)("Expected function names " + functions + " to contain 'split_part'"));
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"split_part").asList().get(0)).getField(1), (Object)"varchar(x)");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"split_part").asList().get(0)).getField(2), (Object)"varchar(x), varchar(y), bigint");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"split_part").asList().get(0)).getField(3), (Object)"scalar");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"split_part").asList().get(0)).getField(4), (Object)true);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"split_part").asList().get(0)).getField(6), (Object)false);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"split_part").asList().get(0)).getField(7), (Object)true);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"split_part").asList().get(0)).getField(8), (Object)"");
        org.testng.Assert.assertFalse((boolean)functions.containsKey((Object)"like"), (String)("Expected function names " + functions + " not to contain 'like'"));
    }

    @Test
    public void testInformationSchemaFiltering() {
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_name = 'orders' LIMIT 1", "SELECT 'orders' table_name");
        this.assertQuery("SELECT table_name FROM information_schema.columns WHERE data_type = 'bigint' AND table_name = 'customer' and column_name = 'custkey' LIMIT 1", "SELECT 'customer' table_name");
    }

    @Test
    public void testInformationSchemaUppercaseName() {
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_catalog = 'LOCAL'", "SELECT '' WHERE false");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema = 'TINY'", "SELECT '' WHERE false");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_name = 'ORDERS'", "SELECT '' WHERE false");
    }

    @Test
    public void testSelectColumnOfNulls() {
        this.assertQueryOrdered("SELECT CAST(NULL AS VARCHAR), CAST(NULL AS BIGINT) FROM orders ORDER BY 1");
    }

    @Test
    public void testSelectCaseInsensitive() {
        this.assertQuery("SELECT ORDERKEY FROM ORDERS");
        this.assertQuery("SELECT OrDeRkEy FROM OrDeRs");
    }

    @Test
    public void testShowSession() {
        Session session = new Session(this.getSession().getQueryId(), Optional.empty(), this.getSession().isClientTransactionSupport(), this.getSession().getIdentity(), this.getSession().getSource(), this.getSession().getCatalog(), this.getSession().getSchema(), this.getSession().getTraceToken(), this.getSession().getTimeZoneKey(), this.getSession().getLocale(), this.getSession().getRemoteUserAddress(), this.getSession().getUserAgent(), this.getSession().getClientInfo(), this.getSession().getClientTags(), this.getSession().getResourceEstimates(), this.getSession().getStartTime(), (Map)ImmutableMap.builder().put((Object)"test_string", (Object)"foo string").put((Object)"test_long", (Object)"424242").build(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"testing_catalog", (Object)ImmutableMap.builder().put((Object)"connector_string", (Object)"bar string").put((Object)"connector_long", (Object)"11").build()), this.getQueryRunner().getMetadata().getSessionPropertyManager(), this.getSession().getPreparedStatements());
        MaterializedResult result = this.computeActual(session, "SHOW SESSION");
        ImmutableMap properties = Maps.uniqueIndex((Iterable)result.getMaterializedRows(), input -> {
            Assert.assertEquals((int)input.getFieldCount(), (int)5);
            return (String)input.getField(0);
        });
        Assert.assertEquals((Object)properties.get((Object)"test_string"), (Object)new MaterializedRow(1, new Object[]{"test_string", "foo string", "test default", "varchar", "test string property"}));
        Assert.assertEquals((Object)properties.get((Object)"test_long"), (Object)new MaterializedRow(1, new Object[]{"test_long", "424242", "42", "bigint", "test long property"}));
        Assert.assertEquals((Object)properties.get((Object)"testing_catalog.connector_string"), (Object)new MaterializedRow(1, new Object[]{"testing_catalog.connector_string", "bar string", "connector default", "varchar", "connector string property"}));
        Assert.assertEquals((Object)properties.get((Object)"testing_catalog.connector_long"), (Object)new MaterializedRow(1, new Object[]{"testing_catalog.connector_long", "11", "33", "bigint", "connector long property"}));
    }

    @Test
    public void testTry() {
        this.assertQuery("SELECT linenumber, sum(TRY(100/(CAST (tax*10 AS BIGINT)))) FROM lineitem GROUP BY linenumber", "SELECT linenumber, sum(100/(CAST (tax*10 AS BIGINT))) FROM lineitem WHERE CAST(tax*10 AS BIGINT) <> 0 GROUP BY linenumber");
        this.assertQuery("SELECT TRY(CAST(IF(round(totalprice) % 2 = 0, CAST(totalprice AS VARCHAR), '^&$' || CAST(totalprice AS VARCHAR)) AS DOUBLE)) FROM orders", "SELECT CASE WHEN round(totalprice) % 2 = 0 THEN totalprice ELSE null END FROM orders");
        this.assertQuery("SELECT COUNT(TRY(to_base(100, CAST(round(totalprice/100) AS BIGINT)))) FROM orders", "SELECT SUM(CASE WHEN CAST(round(totalprice/100) AS BIGINT) BETWEEN 2 AND 36 THEN 1 ELSE 0 END) FROM orders");
        this.assertQuery("SELECT COUNT(CAST(orderkey AS VARCHAR) || TRY(to_base(100, CAST(round(totalprice/100) AS BIGINT)))) FROM orders", "SELECT SUM(CASE WHEN CAST(round(totalprice/100) AS BIGINT) BETWEEN 2 AND 36 THEN 1 ELSE 0 END) FROM orders");
        this.assertQueryFails("SELECT TRY()", "line 1:8: The 'try' function must have exactly one argument");
        this.assertQueryFails("SELECT TRY(x) IS NULL FROM (SELECT 1/y AS x FROM (VALUES 1, 2, 3, 0, 4) t(y))", "/ by zero");
        this.assertQuery("SELECT x IS NULL FROM (SELECT TRY(1/y) AS x FROM (VALUES 3, 0, 4) t(y))", "VALUES false, true, false");
        this.assertQuery("SELECT TRY(apply(5, x -> x + 1) / 0)", "SELECT NULL");
        this.assertQuery("SELECT TRY(apply(5 + RANDOM(1), x -> x + 1) / 0)", "SELECT NULL");
        this.assertQuery("SELECT apply(5 + RANDOM(1), x -> x + TRY(1 / 0))", "SELECT NULL");
        this.assertQuery("SELECT JSON_FORMAT(TRY(JSON 'INVALID'))", "SELECT NULL");
        this.assertQuery("SELECT JSON_FORMAT(TRY (JSON_PARSE('INVALID')))", "SELECT NULL");
        this.assertQuery("SELECT TRY(CAST(NULL AS BIGINT))", "SELECT NULL");
        this.assertQuery("SELECT TRY(CAST('123' AS BIGINT))", "SELECT 123L");
        this.assertQuery("SELECT TRY(CAST('foo' AS BIGINT))", "SELECT NULL");
        this.assertQuery("SELECT TRY(CAST('foo' AS BIGINT)) + TRY(CAST('123' AS BIGINT))", "SELECT NULL");
        this.assertQuery("SELECT TRY(CAST(CAST(123 AS VARCHAR) AS BIGINT))", "SELECT 123L");
        this.assertQuery("SELECT COALESCE(CAST(CONCAT('123', CAST(123 AS VARCHAR)) AS BIGINT), 0)", "SELECT 123123L");
        this.assertQuery("SELECT TRY(CAST(CONCAT('hello', CAST(123 AS VARCHAR)) AS BIGINT))", "SELECT NULL");
        this.assertQuery("SELECT COALESCE(TRY(CAST(CONCAT('a', CAST(123 AS VARCHAR)) AS INTEGER)), 0)", "SELECT 0");
        this.assertQuery("SELECT COALESCE(TRY(CAST(CONCAT('a', CAST(123 AS VARCHAR)) AS BIGINT)), 0)", "SELECT 0L");
        this.assertQuery("SELECT 123 + TRY(ABS(-9223372036854775807 - 1))", "SELECT NULL");
        this.assertQuery("SELECT JSON_FORMAT(TRY(JSON '[]')) || '123'", "SELECT '[]123'");
        this.assertQuery("SELECT JSON_FORMAT(TRY(JSON 'INVALID')) || '123'", "SELECT NULL");
        this.assertQuery("SELECT TRY(2/1)", "SELECT 2");
        this.assertQuery("SELECT TRY(2/0)", "SELECT null");
        this.assertQuery("SELECT COALESCE(TRY(2/0), 0)", "SELECT 0");
        this.assertQuery("SELECT TRY(ABS(-2))", "SELECT 2");
    }

    @Test
    public void testTryNoMergeProjections() {
        this.assertQueryFails("SELECT TRY(x) FROM (SELECT 1/y AS x FROM (VALUES 1, 2, 3, 0, 4) t(y))", ".*");
    }

    @Test
    public void testNoFrom() {
        this.assertQuery("SELECT 1 + 2, 3 + 4");
    }

    @Test
    public void testTopNByMultipleFields() {
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY orderkey ASC, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY orderkey ASC, custkey DESC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY orderkey DESC, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY orderkey DESC, custkey DESC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY custkey ASC, orderkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY custkey ASC, orderkey DESC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY custkey DESC, orderkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY custkey DESC, orderkey DESC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC NULLS FIRST, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) DESC NULLS FIRST, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC NULLS LAST LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) DESC NULLS LAST, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC, custkey ASC LIMIT 10", "SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC NULLS LAST, custkey ASC LIMIT 10");
    }

    @Test
    public void testExchangeWithProjectionPushDown() {
        this.assertQuery("SELECT * FROM \n  (SELECT orderkey + 1 orderkey FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 100)) o \nJOIN \n  (SELECT orderkey + 1 orderkey FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 100)) o1 \nON (o.orderkey = o1.orderkey)");
    }

    @Test
    public void testUnionWithProjectionPushDown() {
        this.assertQuery("SELECT key + 5, status FROM (SELECT orderkey key, orderstatus status FROM orders UNION ALL SELECT orderkey key, linestatus status FROM lineitem)");
    }

    @Test
    public void testJoinProjectionPushDown() {
        this.assertQuery("SELECT *\nFROM\n  (SELECT orderkey, abs(orderkey) a FROM orders) t\nJOIN\n  (SELECT orderkey, abs(orderkey) a FROM orders) u\nON\n  t.orderkey = u.orderkey");
    }

    @Test
    public void testUnion() {
        this.assertQuery("SELECT orderkey FROM orders UNION SELECT custkey FROM orders");
        this.assertQuery("SELECT 123 UNION DISTINCT SELECT 123 UNION ALL SELECT 123");
        this.assertQuery("SELECT NULL UNION SELECT NULL");
        this.assertQuery("SELECT NULL, NULL UNION ALL SELECT NULL, NULL FROM nation");
        this.assertQuery("SELECT 'x', 'y' UNION ALL SELECT name, name FROM nation");
        this.assertQuery("SELECT orderkey FROM orders UNION ALL SELECT 123 UNION ALL (SELECT custkey FROM orders GROUP BY custkey)");
    }

    @Test
    public void testUnionDistinct() {
        this.assertQuery("SELECT orderkey FROM orders UNION DISTINCT SELECT custkey FROM orders");
    }

    @Test
    public void testUnionAll() {
        this.assertQuery("SELECT orderkey FROM orders UNION ALL SELECT custkey FROM orders");
    }

    @Test
    public void testUnionArray() {
        this.assertQuery("SELECT a[1] FROM (SELECT ARRAY[1] UNION ALL SELECT ARRAY[1]) t(a) LIMIT 1", "SELECT 1");
    }

    @Test
    public void testChainedUnionsWithOrder() {
        this.assertQueryOrdered("SELECT orderkey FROM orders UNION (SELECT custkey FROM orders UNION SELECT linenumber FROM lineitem) UNION ALL SELECT orderkey FROM lineitem ORDER BY orderkey");
    }

    @Test
    public void testUnionWithTopN() {
        this.assertQuery("SELECT * FROM (   SELECT regionkey FROM nation    UNION ALL    SELECT nationkey FROM nation) t(a) ORDER BY a LIMIT 1", "SELECT 0");
    }

    @Test
    public void testUnionWithJoin() {
        this.assertQuery("SELECT * FROM (   SELECT orderdate ds, orderkey FROM orders    UNION ALL    SELECT shipdate ds, orderkey FROM lineitem) a JOIN orders o ON (a.orderkey = o.orderkey)");
    }

    @Test
    public void testUnionWithAggregation() {
        this.assertQuery("SELECT regionkey, count(*) FROM (   SELECT regionkey FROM nation    UNION ALL    SELECT * FROM (VALUES 2, 100) t(regionkey)) GROUP BY regionkey", "SELECT * FROM (VALUES  (0, 5), (1, 5), (2, 6), (3, 5), (4, 5), (100, 1))");
        this.assertQuery("SELECT ds, count(*) FROM (   SELECT orderdate ds, orderkey FROM orders    UNION ALL    SELECT shipdate ds, orderkey FROM lineitem) a GROUP BY ds");
        this.assertQuery("SELECT ds, count(*) FROM (   SELECT orderdate ds, orderkey FROM orders    UNION    SELECT shipdate ds, orderkey FROM lineitem) a GROUP BY ds");
        this.assertQuery("SELECT ds, count(DISTINCT orderkey) FROM (   SELECT orderdate ds, orderkey FROM orders    UNION    SELECT shipdate ds, orderkey FROM lineitem) a GROUP BY ds");
        this.assertQuery("SELECT clerk, count(DISTINCT orderstatus) FROM (SELECT * FROM orders WHERE orderkey=0  UNION ALL SELECT * FROM orders WHERE orderkey<>0) GROUP BY clerk");
        this.assertQuery("SELECT count(clerk) FROM (SELECT clerk FROM orders WHERE orderkey=0  UNION ALL SELECT clerk FROM orders WHERE orderkey<>0) GROUP BY clerk");
        this.assertQuery("SELECT count(orderkey), sum(sc) FROM (    SELECT sum(custkey) sc, orderkey FROM (        SELECT custkey,orderkey, orderkey+1 FROM orders WHERE orderkey=0        UNION ALL         SELECT custkey,orderkey,orderkey+1 FROM orders WHERE orderkey<>0)     GROUP BY orderkey)");
        this.assertQuery("SELECT count(orderkey), sum(sc) FROM (\n    SELECT sum(custkey) sc, orderkey FROM (\n        SELECT custkey, orderkey, orderkey+1, orderstatus FROM orders WHERE orderkey=0\n        UNION ALL \n        SELECT custkey, orderkey, orderkey+1, orderstatus FROM orders WHERE orderkey<>0) \n    GROUP BY GROUPING SETS ((orderkey, orderstatus), (orderkey)))", "SELECT count(orderkey), sum(sc) FROM (\n    SELECT sum(custkey) sc, orderkey FROM (\n        SELECT custkey, orderkey, orderkey+1, orderstatus FROM orders WHERE orderkey=0\n        UNION ALL \n        SELECT custkey, orderkey, orderkey+1, orderstatus FROM orders WHERE orderkey<>0) \n    GROUP BY orderkey, orderstatus \n    \n    UNION ALL \n    \n    SELECT sum(custkey) sc, orderkey FROM (\n        SELECT custkey, orderkey, orderkey+1, orderstatus FROM orders WHERE orderkey=0\n        UNION ALL \n        SELECT custkey, orderkey, orderkey+1, orderstatus FROM orders WHERE orderkey<>0) \n    GROUP BY orderkey)");
    }

    @Test
    public void testUnionWithUnionAndAggregation() {
        this.assertQuery("SELECT count(*) FROM (SELECT 1 FROM nation GROUP BY regionkey UNION ALL SELECT 1 FROM (   SELECT 1 FROM nation    UNION ALL    SELECT 1 FROM nation))");
        this.assertQuery("SELECT count(*) FROM (SELECT 1 FROM (   SELECT 1 FROM nation    UNION ALL    SELECT 1 FROM nation)UNION ALL SELECT 1 FROM nation GROUP BY regionkey)");
    }

    @Test
    public void testUnionWithAggregationAndTableScan() {
        this.assertQuery("SELECT orderkey, 1 FROM orders UNION ALL SELECT orderkey, count(*) FROM orders GROUP BY 1", "SELECT orderkey, 1 FROM orders UNION ALL SELECT orderkey, count(*) FROM orders GROUP BY orderkey");
        this.assertQuery("SELECT orderkey, count(*) FROM orders GROUP BY 1 UNION ALL SELECT orderkey, 1 FROM orders", "SELECT orderkey, count(*) FROM orders GROUP BY orderkey UNION ALL SELECT orderkey, 1 FROM orders");
    }

    @Test
    public void testUnionWithAggregationAndJoin() {
        this.assertQuery("SELECT * FROM ( SELECT orderkey, count(*) FROM (   SELECT orderdate ds, orderkey FROM orders    UNION ALL    SELECT shipdate ds, orderkey FROM lineitem) a GROUP BY orderkey) t JOIN orders o ON (o.orderkey = t.orderkey)");
    }

    @Test
    public void testUnionWithJoinOnNonTranslateableSymbols() {
        this.assertQuery("SELECT *\nFROM (SELECT orderdate ds, orderkey\n      FROM orders\n      UNION ALL\n      SELECT shipdate ds, orderkey\n      FROM lineitem) a\nJOIN orders o\nON (substr(cast(a.ds AS VARCHAR), 6, 2) = substr(cast(o.orderdate AS VARCHAR), 6, 2) AND a.orderkey = o.orderkey)");
    }

    @Test
    public void testSubqueryUnion() {
        this.assertQueryOrdered("SELECT * FROM (SELECT orderkey FROM orders UNION SELECT custkey FROM orders UNION SELECT orderkey FROM orders) ORDER BY orderkey LIMIT 1000");
    }

    @Test
    public void testUnionWithFilterNotInSelect() {
        this.assertQuery("SELECT orderkey, orderdate FROM orders WHERE custkey < 1000 UNION ALL SELECT orderkey, shipdate FROM lineitem WHERE linenumber < 2000");
        this.assertQuery("SELECT orderkey, orderdate FROM orders UNION ALL SELECT orderkey, shipdate FROM lineitem WHERE linenumber < 2000");
        this.assertQuery("SELECT orderkey, orderdate FROM orders WHERE custkey < 1000 UNION ALL SELECT orderkey, shipdate FROM lineitem");
    }

    @Test
    public void testSelectOnlyUnion() {
        this.assertQuery("SELECT 123, 'foo' UNION ALL SELECT 999, 'bar'");
    }

    @Test
    public void testMultiColumnUnionAll() {
        this.assertQuery("SELECT * FROM orders UNION ALL SELECT * FROM orders");
    }

    @Test
    public void testUnionRequiringCoercion() {
        this.assertQuery("VALUES 1 UNION ALL VALUES 1.0, 2", "SELECT * FROM (VALUES 1) UNION ALL SELECT * FROM (VALUES 1.0, 2)");
        this.assertQuery("(VALUES 1) UNION ALL (VALUES 1.0, 2)", "SELECT * FROM (VALUES 1) UNION ALL SELECT * FROM (VALUES 1.0, 2)");
        this.assertQuery("SELECT 0, 0 UNION ALL SELECT 1.0, 0");
        this.assertQuery("SELECT 0, 0, 0, 0 UNION ALL SELECT 0.0, 0.0, 0, 0");
        this.assertQuery("SELECT * FROM (VALUES 1) UNION ALL SELECT * FROM (VALUES 1.0, 2)");
        this.assertQuery("SELECT * FROM (VALUES 1) UNION SELECT * FROM (VALUES 1.0, 2)", "VALUES 1.0, 2.0");
        this.assertQuery("SELECT * FROM (VALUES (2, 2)) UNION SELECT * FROM (VALUES (1, 1.0))");
        this.assertQuery("SELECT * FROM (VALUES (NULL, NULL)) UNION SELECT * FROM (VALUES (1, 1.0))");
        this.assertQuery("SELECT * FROM (VALUES (NULL, NULL)) UNION ALL SELECT * FROM (VALUES (NULL, 1.0))");
        this.assertQuery("SELECT a FROM (  (SELECT orderstatus AS a FROM orders LIMIT 1) UNION ALL   SELECT 'aaaa' AS a) WHERE  a = 'aaa'");
    }

    @Test
    public void testTableQuery() {
        this.assertQuery("TABLE orders", "SELECT * FROM orders");
    }

    @Test
    public void testTableQueryOrderLimit() {
        this.assertQueryOrdered("TABLE orders ORDER BY orderkey LIMIT 10", "SELECT * FROM orders ORDER BY orderkey LIMIT 10");
    }

    @Test
    public void testTableQueryInUnion() {
        this.assertQuery("(SELECT * FROM orders ORDER BY orderkey LIMIT 10) UNION ALL TABLE orders", "(SELECT * FROM orders ORDER BY orderkey LIMIT 10) UNION ALL SELECT * FROM orders");
    }

    @Test
    public void testTableAsSubquery() {
        this.assertQueryOrdered("(TABLE orders) ORDER BY orderkey", "(SELECT * FROM orders) ORDER BY orderkey");
    }

    @Test
    public void testLimitPushDown() {
        MaterializedResult actual = this.computeActual("(TABLE orders ORDER BY orderkey) UNION ALL SELECT * FROM orders WHERE orderstatus = 'F' UNION ALL (TABLE orders ORDER BY orderkey LIMIT 20) UNION ALL (TABLE orders LIMIT 5) UNION ALL TABLE orders LIMIT 10");
        MaterializedResult all = this.computeExpected("SELECT * FROM orders", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testUnaliasSymbolReferencesWithUnion() {
        this.assertQuery("SELECT 1, 1, 'a', 'a' UNION ALL SELECT 1, 2, 'a', 'b'");
    }

    @Test
    public void testRandCrossJoins() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM orders ORDER BY rand() LIMIT 5) a CROSS JOIN (SELECT * FROM lineitem ORDER BY rand() LIMIT 5) b");
    }

    @Test
    public void testCrossJoins() {
        this.assertQuery("SELECT a.custkey, b.orderkey FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 5) a CROSS JOIN (SELECT * FROM lineitem ORDER BY orderkey LIMIT 5) b");
    }

    @Test
    public void testCrossJoinEmptyProbePage() {
        this.assertQuery("SELECT a.custkey, b.orderkey FROM (SELECT * FROM orders WHERE orderkey < 0) a CROSS JOIN (SELECT * FROM lineitem WHERE orderkey < 100) b");
    }

    @Test
    public void testCrossJoinEmptyBuildPage() {
        this.assertQuery("SELECT a.custkey, b.orderkey FROM (SELECT * FROM orders WHERE orderkey < 100) a CROSS JOIN (SELECT * FROM lineitem WHERE orderkey < 0) b");
    }

    @Test
    public void testSimpleCrossJoins() {
        this.assertQuery("SELECT * FROM (SELECT 1 a) x CROSS JOIN (SELECT 2 b) y");
    }

    @Test
    public void testCrossJoinsWithWhereClause() {
        this.assertQuery("SELECT a, b, c, d FROM (VALUES (1, 'a'), (2, 'b'), (3, 'c'), (4, 'd')) t1 (a, b) CROSS JOIN (VALUES (1, 1.1), (3, 3.3), (5, 5.5)) t2 (c, d) WHERE t1.a > t2.c", "SELECT * FROM (VALUES  (2, 'b', 1, 1.1), (3, 'c', 1, 1.1), (4, 'd', 1, 1.1), (4, 'd', 3, 3.3))");
    }

    @Test
    public void testCrossJoinsDifferentDataTypes() {
        this.assertQuery("SELECT * FROM (SELECT 'AAA' a1, 11 b1, 33.3 c1, true AS d1, 21 e1) x CROSS JOIN (SELECT 4444.4 a2, false AS b2, 'BBB' c2, 22 d2) y");
    }

    @Test
    public void testCrossJoinWithNulls() {
        this.assertQuery("SELECT a, b FROM (VALUES (1), (2)) t (a) CROSS JOIN (VALUES (1), (3)) u (b)", "SELECT * FROM (VALUES  (1, 1), (1, 3), (2, 1), (2, 3))");
        this.assertQuery("SELECT a, b FROM (VALUES (1), (2), (null)) t (a), (VALUES (11), (null), (13)) u (b)", "SELECT * FROM (VALUES (1, 11), (1, null), (1, 13), (2, 11), (2, null), (2, 13), (null, 11), (null, null), (null, 13))");
        this.assertQuery("SELECT a, b FROM (VALUES ('AA'), ('BB'), (null)) t (a), (VALUES ('111'), (null), ('333')) u (b)", "SELECT * FROM (VALUES ('AA', '111'), ('AA', null), ('AA', '333'), ('BB', '111'), ('BB', null), ('BB', '333'), (null, '111'), (null, null), (null, '333'))");
    }

    @Test
    public void testImplicitCrossJoin() {
        this.assertQuery("SELECT * FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 3) a, (SELECT * FROM orders ORDER BY orderkey LIMIT 4) b");
        this.assertQuery("SELECT * FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 5) a, (SELECT * FROM orders ORDER BY orderkey LIMIT 2) b");
        this.assertQuery("SELECT * FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 5) a, (SELECT * FROM orders ORDER BY orderkey LIMIT 5) b, (SELECT * FROM orders ORDER BY orderkey LIMIT 5) c ");
        this.assertQuery("SELECT l.orderkey, l.linenumber FROM orders o INNER JOIN lineitem l ON o.custkey = l.linenumber WHERE o.custkey IN (5) AND l.orderkey IN (7522)");
        this.assertQuery("SELECT o.custkey FROM orders o INNER JOIN lineitem l ON o.custkey = l.linenumber WHERE o.custkey IN (5) AND l.orderkey IN (7522)");
        this.assertQuery("SELECT COUNT(*) FROM orders o INNER JOIN lineitem l ON o.custkey = l.linenumber WHERE o.custkey IN (5) AND l.orderkey IN (7522)");
    }

    @Test
    public void testCrossJoinUnion() {
        this.assertQuery("SELECT t.c FROM (SELECT 1) CROSS JOIN (SELECT 0 AS c UNION ALL SELECT 1) t");
        this.assertQuery("SELECT a, b FROM (VALUES (1, 1)) CROSS JOIN (SELECT 0 AS a, 0 AS b UNION ALL SELECT 1, 1) t");
    }

    @Test
    public void testCrossJoinUnnestWithUnion() {
        this.assertQuery("SELECT col, COUNT(*)\nFROM ((\n    SELECT ARRAY[1, 2] AS a\n    UNION ALL\n    SELECT ARRAY[1, 3] AS a)  unionresult\n  CROSS JOIN UNNEST(unionresult.a) t(col))\nGROUP BY col", "SELECT * FROM VALUES (1, 2), (2, 1), (3, 1)");
    }

    @Test
    public void testJoinOnConstantExpression() {
        this.assertQuery("SELECT * FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 5) a    JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 5) b    ON 123 = 123");
    }

    @Test
    public void testSemiJoin() {
        this.assertQuery("SELECT linenumber, min(orderkey) FROM lineitem GROUP BY linenumber HAVING min(orderkey) IN (SELECT orderkey FROM orders WHERE orderkey > 1)");
        this.assertQuery("SELECT 10 in (SELECT orderkey FROM orders)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (2,2), (3, 3)) t(x, y) WHERE (x+y in (VALUES 4, 5)) AND (x*y in (VALUES 4, 5))", "VALUES (2,2)");
        this.assertQuery("SELECT 1.0 IN (SELECT 1), 1 IN (SELECT 1)");
        this.assertQuery("SELECT 1 WHERE 1 IN (SELECT 1) AND 1.0 IN (SELECT 1)");
        this.assertQuery("SELECT 1.0 in (values (1), (2), (3))", "SELECT true");
        this.assertQuery("SELECT CAST(1 AS decimal(3,2)) IN (SELECT CAST(1 AS decimal(3,1)))", "SELECT true");
        this.assertQuery("SELECT CAST(1 AS decimal(3,2)) IN (values (cast(1 AS decimal(3,1))), (cast (2 AS decimal(3,1))))", "SELECT true");
        this.assertQuery("SELECT 1 IN (SELECT 1), 2 IN (SELECT 1) WHERE 1 IN (SELECT 1)");
        this.assertQuery("SELECT (SELECT 1) IN (SELECT 1)");
        this.assertQuery("SELECT (SELECT 2) IN (1, (SELECT 2))");
        this.assertQuery("SELECT (2 + (SELECT 1)) IN (SELECT 1)");
        this.assertQuery("SELECT (1 IN (SELECT 1)) IN (SELECT TRUE)");
        this.assertQuery("SELECT ((SELECT 1) IN (SELECT 1)) IN (SELECT TRUE)");
        this.assertQuery("SELECT (EXISTS(SELECT 1)) IN (SELECT TRUE)");
        this.assertQuery("SELECT (1 = ANY(SELECT 1)) IN (SELECT TRUE)");
        this.assertQuery("SELECT *, o2.custkey\n  IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE orderkey % 5 = 0)\nFROM (SELECT * FROM orders WHERE custkey % 256 = 0) o1\nJOIN (SELECT * FROM orders WHERE custkey % 256 = 0) o2\n  ON (o1.orderkey IN (SELECT orderkey FROM lineitem WHERE orderkey % 4 = 0)) = (o2.orderkey IN (SELECT orderkey FROM lineitem WHERE orderkey % 4 = 0))\nWHERE o1.orderkey\n  IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE orderkey % 4 = 0)\nORDER BY o1.orderkey\n  IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE orderkey % 7 = 0)");
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE partkey % 4 = 0),\n  SUM(\n    CASE\n      WHEN orderkey\n        IN (\n          SELECT orderkey\n          FROM lineitem\n          WHERE suppkey % 4 = 0)\n      THEN 1\n      ELSE 0\n      END)\nFROM orders\nGROUP BY orderkey\n  IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE partkey % 4 = 0)\nHAVING SUM(\n  CASE\n    WHEN orderkey\n      IN (\n        SELECT orderkey\n        FROM lineitem\n        WHERE suppkey % 4 = 0)\n      THEN 1\n      ELSE 0\n      END) > 1");
    }

    @Test
    public void testJoinConstantPropagation() {
        this.assertQuery("SELECT x, y, COUNT(*)\nFROM (SELECT orderkey, 0 AS x FROM orders) a \nJOIN (SELECT orderkey, 1 AS y FROM orders) b \nON a.orderkey = b.orderkey\nGROUP BY 1, 2");
    }

    @Test
    public void testAntiJoin() {
        this.assertQuery("SELECT *, orderkey\n  NOT IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE orderkey % 3 = 0)\nFROM orders");
    }

    @Test
    public void testAntiJoinNullHandling() {
        this.assertQuery("WITH empty AS (SELECT 1 WHERE FALSE) SELECT 3 FROM (VALUES 1) WHERE NULL NOT IN (SELECT * FROM empty)", "VALUES 3");
        this.assertQuery("WITH empty AS (SELECT 1 WHERE FALSE) SELECT x FROM (VALUES NULL) t(x) WHERE x NOT IN (SELECT * FROM empty)", "VALUES NULL");
    }

    @Test
    public void testSemiJoinLimitPushDown() {
        this.assertQuery("SELECT COUNT(*)\nFROM (\n  SELECT orderkey\n  IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE orderkey % 2 = 0)\n  FROM orders\n  LIMIT 10)");
    }

    @Test
    public void testSemiJoinNullHandling() {
        this.assertQuery("WITH empty AS (SELECT 1 WHERE FALSE) SELECT 3 FROM (VALUES 1) WHERE NULL IN (SELECT * FROM empty)", "SELECT 0 WHERE FALSE");
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END\n    FROM lineitem)\nFROM orders");
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT orderkey\n    FROM lineitem)\nFROM (\n  SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM orders)");
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END\n    FROM lineitem)\nFROM (\n  SELECT CASE WHEN orderkey % 4 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM orders)");
    }

    @Test
    public void testSemiJoinWithGroupBy() {
        this.assertQuery("SELECT linenumber, min(orderkey), 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber");
        this.assertQuery("SELECT linenumber, min(orderkey), 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey) FROM lineitem GROUP BY linenumber, 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey) FROM lineitem GROUP BY linenumber HAVING 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey), 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)HAVING 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey), 6 IN (SELECT max(orderkey) FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, 6 IN (SELECT sum(orderkey) FROM orders WHERE orderkey < 5)");
        this.assertQuery("SELECT linenumber, min(orderkey) FROM lineitem GROUP BY linenumber, 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)HAVING 6 IN (SELECT orderkey FROM orders WHERE orderkey > 3)");
        this.assertQuery("SELECT linenumber, min(orderkey), 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, 6 IN (SELECT orderkey FROM orders WHERE orderkey < 5)HAVING 6 IN (SELECT orderkey FROM orders WHERE orderkey > 3)");
    }

    @Test
    public void testSemiJoinUnionNullHandling() {
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT CASE WHEN orderkey % 500 = 0 THEN NULL ELSE orderkey END\n    FROM orders\n    WHERE orderkey % 200 = 0\n    UNION ALL\n    SELECT CASE WHEN orderkey % 600 = 0 THEN NULL ELSE orderkey END\n    FROM orders\n    WHERE orderkey % 300 = 0\n  )\nFROM (\n  SELECT orderkey\n  FROM lineitem\n  WHERE orderkey % 100 = 0)");
    }

    @Test
    public void testSemiJoinAggregationNullHandling() {
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT CASE WHEN orderkey % 10 = 0 THEN NULL ELSE orderkey END\n    FROM lineitem\n    WHERE orderkey % 2 = 0\n    GROUP BY orderkey\n  )\nFROM (\n  SELECT orderkey\n  FROM orders\n  WHERE orderkey % 3 = 0)");
    }

    @Test
    public void testSemiJoinUnionAggregationNullHandling() {
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT CASE WHEN orderkey % 500 = 0 THEN NULL ELSE orderkey END\n    FROM lineitem\n    WHERE orderkey % 250 = 0\n    UNION ALL\n    SELECT CASE WHEN orderkey % 300 = 0 THEN NULL ELSE orderkey END\n    FROM lineitem\n    WHERE orderkey % 200 = 0\n    GROUP BY orderkey\n  )\nFROM (\n  SELECT orderkey\n  FROM orders\n  WHERE orderkey % 100 = 0)\n");
    }

    @Test
    public void testSemiJoinAggregationUnionNullHandling() {
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT orderkey\n    FROM (\n      SELECT CASE WHEN orderkey % 500 = 0 THEN NULL ELSE orderkey END AS orderkey\n      FROM orders\n      WHERE orderkey % 200 = 0\n      UNION ALL\n      SELECT CASE WHEN orderkey % 600 = 0 THEN NULL ELSE orderkey END AS orderkey\n      FROM orders\n      WHERE orderkey % 300 = 0\n    )\n    GROUP BY orderkey\n  )\nFROM (\n  SELECT orderkey\n  FROM lineitem\n  WHERE orderkey % 100 = 0)");
    }

    @Test
    public void testSameInPredicateInProjectionAndFilter() {
        this.assertQuery("SELECT x IN (SELECT * FROM (VALUES 1))\nFROM (VALUES 1) t(x)\nWHERE x IN (SELECT * FROM (VALUES 1))", "SELECT 1");
        this.assertQuery("SELECT x IN (SELECT * FROM (VALUES 1))\nFROM (VALUES 2) t(x)\nWHERE x IN (SELECT * FROM (VALUES 1))", "SELECT 1 WHERE false");
    }

    @Test
    public void testScalarSubquery() {
        this.assertQuery("SELECT (SELECT (SELECT (SELECT 1)))");
        this.assertQuery("SELECT * FROM lineitem WHERE orderkey = \n(SELECT max(orderkey) FROM orders)");
        this.assertQuery("SELECT * FROM lineitem WHERE orderkey = \n(SELECT orderkey FROM orders WHERE 0=1)");
        this.assertQuery("SELECT * FROM lineitem WHERE \n(SELECT orderkey FROM orders WHERE 0=1) is null");
        this.assertQuery("SELECT * FROM lineitem WHERE \n(SELECT orderkey FROM orders WHERE 0=1) is not null");
        this.assertQuery("SELECT (SELECT 1) IN (1, 2, 3)");
        this.assertQuery("SELECT (SELECT 1) IN (   2, 3)");
        this.assertQuery("SELECT (SELECT 1) = (SELECT 3)");
        this.assertQuery("SELECT (SELECT 1) < (SELECT 3)");
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE (SELECT min(orderkey) FROM orders)<(SELECT max(orderkey) FROM orders)");
        this.assertQuery("SELECT (SELECT 1), (SELECT 2), (SELECT 3)");
        this.assertQuery("SELECT DISTINCT orderkey FROM lineitem WHERE orderkey BETWEEN   (SELECT avg(orderkey) FROM orders) - 10    AND   (SELECT avg(orderkey) FROM orders) + 10");
        this.assertQuery("SELECT o1.orderkey, COUNT(*) FROM orders o1 INNER JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o2 ON o1.orderkey BETWEEN (SELECT avg(orderkey) FROM orders) - 10 AND (SELECT avg(orderkey) FROM orders) + 10 GROUP BY o1.orderkey");
        this.assertQuery("SELECT o1.orderkey, COUNT(*) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o1 LEFT JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o2 ON o1.orderkey BETWEEN (SELECT avg(orderkey) FROM orders) - 10 AND (SELECT avg(orderkey) FROM orders) + 10 GROUP BY o1.orderkey");
        this.assertQuery("SELECT o1.orderkey, COUNT(*) FROM orders o1 RIGHT JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o2 ON o1.orderkey BETWEEN (SELECT avg(orderkey) FROM orders) - 10 AND (SELECT avg(orderkey) FROM orders) + 10 GROUP BY o1.orderkey");
        this.assertQuery("SELECT DISTINCT COUNT(*) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o1 FULL JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o2 ON o1.orderkey BETWEEN (SELECT avg(orderkey) FROM orders) - 10 AND (SELECT avg(orderkey) FROM orders) + 10 GROUP BY o1.orderkey", "VALUES 1, 10");
        this.assertQuery("SELECT orderkey, totalprice FROM orders ORDER BY (SELECT 2)");
        String multipleRowsErrorMsg = "Scalar sub-query has returned multiple rows";
        this.assertQueryFails("SELECT * FROM lineitem WHERE orderkey = (\nSELECT orderkey FROM orders ORDER BY totalprice)", multipleRowsErrorMsg);
        this.assertQueryFails("SELECT orderkey, totalprice FROM orders ORDER BY (VALUES 1, 2)", multipleRowsErrorMsg);
        this.assertQuery("SELECT custkey, (SELECT DISTINCT custkey FROM orders ORDER BY custkey LIMIT 1) FROM orders");
        this.assertQuery("SELECT 1.0/(SELECT 1), CAST(1.0 AS REAL)/(SELECT 1), 1/(SELECT 1)");
        this.assertQuery("SELECT 1.0 = (SELECT 1) AND 1 = (SELECT 1), 2.0 = (SELECT 1) WHERE 1.0 = (SELECT 1) AND 1 = (SELECT 1)");
        this.assertQuery("SELECT 1.0 = (SELECT 1), 2.0 = (SELECT 1), CAST(2.0 AS REAL) = (SELECT 1) WHERE 1.0 = (SELECT 1)");
        this.assertQuery("SELECT * FROM (VALUES 1) t(a) WHERE 1=(SELECT count(*) WHERE 1.0 = a)", "SELECT 1");
        this.assertQuery("SELECT * FROM (VALUES 1.0) t(a) WHERE 1=(SELECT count(*) WHERE 1 = a)", "SELECT 1.0");
    }

    @Test
    public void testExistsSubquery() {
        this.assertQuery("SELECT EXISTS(SELECT NOT EXISTS(SELECT EXISTS(SELECT 1)))");
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE EXISTS(SELECT max(orderkey) FROM orders)");
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE NOT EXISTS(SELECT max(orderkey) FROM orders)");
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE NOT EXISTS(SELECT orderkey FROM orders WHERE false)");
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE EXISTS(SELECT orderkey FROM orders WHERE false)");
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE NOT EXISTS(SELECT orderkey FROM orders WHERE false)");
        this.assertQuery("SELECT (EXISTS(SELECT 1)) IN (false)", "SELECT false");
        this.assertQuery("SELECT (NOT EXISTS(SELECT 1)) IN (false)", "SELECT true");
        this.assertQuery("SELECT (EXISTS(SELECT 1)) IN (true, false)", "SELECT true");
        this.assertQuery("SELECT (NOT EXISTS(SELECT 1)) IN (true, false)", "SELECT true");
        this.assertQuery("SELECT (EXISTS(SELECT 1 WHERE false)) IN (true, false)", "SELECT true");
        this.assertQuery("SELECT (NOT EXISTS(SELECT 1 WHERE false)) IN (true, false)", "SELECT true");
        this.assertQuery("SELECT (EXISTS(SELECT 1 WHERE false)) IN (false)", "SELECT true");
        this.assertQuery("SELECT (NOT EXISTS(SELECT 1 WHERE false)) IN (false)", "SELECT false");
        this.assertQuery("SELECT (EXISTS(SELECT 1)) = (EXISTS(SELECT 1)) WHERE NOT EXISTS(SELECT 1)", "SELECT true WHERE false");
        this.assertQuery("SELECT (EXISTS(SELECT 1)) = (EXISTS(SELECT 3)) WHERE NOT EXISTS(SELECT 1 WHERE false)", "SELECT true");
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE (EXISTS(SELECT min(orderkey) FROM orders))=(NOT EXISTS(SELECT orderkey FROM orders WHERE false))", "SELECT count(*) FROM lineitem");
        this.assertQuery("SELECT EXISTS(SELECT 1), EXISTS(SELECT 1), EXISTS(SELECT 3), NOT EXISTS(SELECT 1), NOT EXISTS(SELECT 1 WHERE false)");
        this.assertQuery("SELECT DISTINCT orderkey FROM lineitem WHERE EXISTS(SELECT avg(orderkey) FROM orders)");
        QueryTemplate.Parameter joinType = QueryTemplate.parameter((String)"join_type");
        QueryTemplate.Parameter condition = QueryTemplate.parameter((String)"condition");
        QueryTemplate queryTemplate = QueryTemplate.queryTemplate((String)"SELECT o1.orderkey, COUNT(*) FROM orders o1 %join_type% JOIN (SELECT * FROM orders LIMIT 10) o2 ON %condition% GROUP BY o1.orderkey ORDER BY o1.orderkey LIMIT 5", (QueryTemplate.Parameter[])new QueryTemplate.Parameter[]{joinType, condition});
        List conditions = condition.of(new String[]{"EXISTS(SELECT avg(orderkey) FROM orders)", "(SELECT avg(orderkey) FROM orders) > 3"});
        for (QueryTemplate.Parameter actualCondition : conditions) {
            for (QueryTemplate.Parameter actualJoinType : joinType.of(new String[]{"", "LEFT", "RIGHT"})) {
                this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{actualJoinType, actualCondition}));
            }
            this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{joinType.of("FULL"), actualCondition}), "VALUES (1, 10), (2, 10), (3, 10), (4, 10), (5, 10)");
        }
        this.assertQuery("SELECT orderkey, totalprice FROM orders ORDER BY EXISTS(SELECT 2)");
        this.assertQuery("SELECT orderkey, totalprice FROM orders ORDER BY NOT(EXISTS(SELECT 2))");
    }

    @Test
    public void testScalarSubqueryWithGroupBy() {
        this.assertQuery("SELECT linenumber, min(orderkey), (SELECT max(orderkey) FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber");
        this.assertQuery("SELECT linenumber, min(orderkey), (SELECT max(orderkey) FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, (SELECT max(orderkey) FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey) FROM lineitem GROUP BY linenumber, (SELECT max(orderkey) FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey) FROM lineitem GROUP BY linenumber HAVING min(orderkey) < (SELECT avg(orderkey) FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey), (SELECT max(orderkey) FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, (SELECT max(orderkey) FROM orders WHERE orderkey < 7)HAVING min(orderkey) < (SELECT max(orderkey) FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey), (SELECT max(orderkey) FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, (SELECT sum(orderkey) FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, max(orderkey), (SELECT min(orderkey) FROM orders WHERE orderkey < 5)FROM lineitem GROUP BY linenumber HAVING sum(orderkey) > (SELECT min(orderkey) FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey), (SELECT max(orderkey) FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, (SELECT count(orderkey) FROM orders WHERE orderkey < 7)HAVING min(orderkey) < (SELECT sum(orderkey) FROM orders WHERE orderkey < 7)");
    }

    @Test
    public void testOutputInEnforceSingleRow() {
        this.assertQuery("SELECT count(*) FROM (SELECT (SELECT 1))");
        this.assertQuery("SELECT * FROM (SELECT (SELECT 1))");
        this.assertQueryFails("SELECT * FROM (SELECT (SELECT 1, 2))", "line 1:23: Multiple columns returned by subquery are not yet supported. Found 2");
    }

    @Test
    public void testExistsSubqueryWithGroupBy() {
        this.assertQuery("SELECT linenumber, min(orderkey), EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber");
        this.assertQuery("SELECT linenumber, min(orderkey), EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey) FROM lineitem GROUP BY linenumber, EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey) FROM lineitem GROUP BY linenumber HAVING EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey), EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)HAVING EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey), EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, EXISTS(SELECT orderkey FROM orders WHERE orderkey < 17)");
        this.assertQuery("SELECT linenumber, max(orderkey), EXISTS(SELECT orderkey FROM orders WHERE orderkey < 5)FROM lineitem GROUP BY linenumber HAVING EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey), EXISTS(SELECT orderkey FROM orders WHERE orderkey < 17)FROM lineitem GROUP BY linenumber, EXISTS(SELECT orderkey FROM orders WHERE orderkey < 17)HAVING EXISTS(SELECT orderkey FROM orders WHERE orderkey < 27)");
    }

    @Test
    public void testCorrelatedScalarSubqueries() {
        this.assertQuery("SELECT (SELECT n.nationkey) FROM nation n");
        this.assertQuery("SELECT (SELECT 2 * n.nationkey) FROM nation n");
        this.assertQuery("SELECT nationkey FROM nation n WHERE 2 = (SELECT 2 * n.nationkey)");
        this.assertQuery("SELECT nationkey FROM nation n ORDER BY (SELECT 2 * n.nationkey)");
        this.assertQuery("SELECT max(n.regionkey), 2 * n.nationkey, (SELECT n.nationkey) FROM nation n GROUP BY n.nationkey");
        this.assertQuery("SELECT max(l.quantity), 2 * l.orderkey FROM lineitem l GROUP BY l.orderkey HAVING max(l.quantity) < (SELECT l.orderkey)");
        this.assertQuery("SELECT max(l.quantity), 2 * l.orderkey FROM lineitem l GROUP BY l.orderkey, (SELECT l.orderkey)");
        this.assertQuery("SELECT * FROM nation n1 JOIN nation n2 ON n1.nationkey = (SELECT n2.nationkey)");
        this.assertQueryFails("SELECT (SELECT l3.* FROM lineitem l2 CROSS JOIN (SELECT l1.orderkey) l3 LIMIT 1) FROM lineitem l1", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQuery("SELECT 1 FROM nation n WHERE 2 * nationkey - 1  = (SELECT * FROM (SELECT n.nationkey))", "SELECT 1");
        this.assertQuery("SELECT * FROM nation n WHERE 2 = (SELECT (SELECT 2 * n.nationkey))");
        this.assertQueryFails("SELECT (SELECT count(*) FROM (VALUES (7,1)) t(orderkey, value) WHERE orderkey = corr_key LIMIT 1) FROM (values 7) t(corr_key)", "line 1:9: Given correlated subquery is not supported");
    }

    @Test
    public void testCorrelatedNonAggregationScalarSubqueries() {
        String subqueryReturnedTooManyRows = "Scalar sub-query has returned multiple rows";
        this.assertQuery("SELECT (SELECT 1 WHERE a = 2) FROM (VALUES 1) t(a)", "SELECT null");
        this.assertQuery("SELECT (SELECT 2 WHERE a = 1) FROM (VALUES 1) t(a)", "SELECT 2");
        this.assertQueryFails("SELECT (SELECT 2 FROM (VALUES 3, 4) WHERE a = 1) FROM (VALUES 1) t(a)", subqueryReturnedTooManyRows);
        this.assertQueryFails("SELECT name FROM nation n WHERE 'AFRICA' = (SELECT 'bleh' FROM region WHERE regionkey > n.regionkey)", subqueryReturnedTooManyRows);
        this.assertQueryFails("SELECT name FROM nation n WHERE 'AFRICA' = (SELECT name FROM region WHERE regionkey > n.regionkey)", subqueryReturnedTooManyRows);
        this.assertQueryFails("SELECT name FROM nation n WHERE 1 = (SELECT 1 FROM region WHERE regionkey > n.regionkey)", subqueryReturnedTooManyRows);
        this.assertQueryFails("SELECT name FROM nation n WHERE 'AFRICA' = (SELECT n.name FROM region WHERE regionkey > n.regionkey)", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQuery("SELECT (SELECT 2 WHERE o.orderkey = 1) FROM orders o ORDER BY orderkey LIMIT 5", "VALUES 2, null, null, null, null");
        this.assertQueryFails("SELECT (SELECT o.orderkey WHERE o.orderkey = 1) FROM orders o ORDER BY orderkey LIMIT 5", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQueryFails("SELECT (SELECT o.orderkey * 2 WHERE o.orderkey = 1) FROM orders o ORDER BY orderkey LIMIT 5", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQueryFails("SELECT o.orderkey, (SELECT o.orderkey * 2 WHERE o.orderkey = 1) FROM orders o ORDER BY orderkey LIMIT 5", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQuery("SELECT name FROM nation n WHERE 'AFRICA' = (SELECT name FROM region WHERE regionkey = n.regionkey)");
        this.assertQueryFails("SELECT nationkey FROM nation n WHERE (SELECT n.regionkey * 2 FROM region r WHERE n.regionkey = r.regionkey) > 6", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQueryFails("SELECT nationkey FROM nation n WHERE (SELECT n.nationkey * 2 FROM region r WHERE n.regionkey = r.regionkey) > 6", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQuery("SELECT nationkey FROM nation n WHERE (SELECT regionkey * 2 FROM (SELECT regionkey FROM region r WHERE n.regionkey = r.regionkey)) > 6 ORDER BY 1 LIMIT 3", "VALUES 4, 10, 11");
        this.assertQuery("SELECT (SELECT name FROM nation WHERE nationkey = a) FROM (VALUES 1, 1, 2, 3) t(a)", "VALUES 'ARGENTINA', 'ARGENTINA', 'BRAZIL', 'CANADA'");
        this.assertQuery("SELECT (SELECT name FROM nation WHERE nationkey = a) FROM (VALUES 31) t(a)", "VALUES null");
        this.assertQuery("SELECT (SELECT r.name FROM nation n, region r WHERE r.regionkey = n.regionkey AND n.nationkey = a) FROM (VALUES 1) t(a)", "VALUES 'AMERICA'");
    }

    @Test
    public void testCorrelatedScalarSubqueriesWithScalarAggregationAndEqualityPredicatesInWhere() {
        this.assertQuery("SELECT (SELECT count(*) WHERE o.orderkey = 1) FROM orders o");
        this.assertQuery("SELECT count(*) FROM orders o WHERE 1 = (SELECT count(*) WHERE o.orderkey = 0)");
        this.assertQuery("SELECT * FROM orders o ORDER BY (SELECT count(*) WHERE o.orderkey = 0)");
        this.assertQuery("SELECT count(*) FROM nation n WHERE (SELECT count(*) FROM region r WHERE n.regionkey = r.regionkey) > 1");
        this.assertQueryFails("SELECT count(*) FROM nation n WHERE (SELECT avg(a) FROM (SELECT count(*) FROM region r WHERE n.regionkey = r.regionkey) t(a)) > 1", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQuery("SELECT (SELECT count(*) WHERE a = 1) FROM (VALUES 1, 1, 2, 3) t(a)", "VALUES true, true, false, false");
        this.assertQuery("SELECT max(o.totalprice), o.orderkey, (SELECT count(*) WHERE o.orderkey = 0) FROM orders o GROUP BY o.orderkey");
        this.assertQuery("SELECT max(o.totalprice), o.orderkey FROM orders o GROUP BY o.orderkey HAVING 1 = (SELECT count(*) WHERE o.orderkey = 0)");
        this.assertQuery("SELECT max(o.totalprice), o.orderkey FROM orders o GROUP BY o.orderkey, (SELECT count(*) WHERE o.orderkey = 0)");
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o1 JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o2 ON NOT 1 = (SELECT count(*) WHERE o1.orderkey = o2.orderkey)");
        this.assertQueryFails("SELECT count(*) FROM orders o1 LEFT JOIN orders o2 ON NOT 1 = (SELECT count(*) WHERE o1.orderkey = o2.orderkey)", "line .*: Correlated subquery in given context is not supported");
        this.assertQuery("SELECT count(*) FROM orders o WHERE 1 = (SELECT * FROM (SELECT (SELECT count(*) WHERE o.orderkey = 0)))", "SELECT count(*) FROM orders o WHERE o.orderkey = 0");
    }

    @Test
    public void testCorrelatedScalarSubqueriesWithScalarAggregation() {
        this.assertQuery("SELECT (SELECT round(3 * avg(i.a)) FROM (VALUES 1, 1, 1, 2, 2, 3, 4) i(a) WHERE i.a < o.a AND i.a < 4) FROM (VALUES 0, 3, 3, 5) o(a)", "VALUES null, 4, 4, 5");
        this.assertQuery("SELECT count(*) FROM orders o WHERE (SELECT avg(i.orderkey) FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0) > 100", "VALUES 14999");
        this.assertQuery("SELECT orderkey FROM orders o ORDER BY    (SELECT avg(i.orderkey) FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0),    orderkey LIMIT 1", "VALUES 1");
        this.assertQuery("SELECT max(o.orderdate), o.orderkey, (SELECT avg(i.orderkey) FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0) FROM orders o GROUP BY o.orderkey ORDER BY o.orderkey LIMIT 1", "VALUES ('1996-01-02', 1, 40000)");
        this.assertQuery("SELECT max(o.orderdate), o.orderkey FROM orders o GROUP BY o.orderkey HAVING 40000 < (SELECT avg(i.orderkey) FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0)ORDER BY o.orderkey LIMIT 1", "VALUES ('1996-07-24', 20000)");
        this.assertQuery("SELECT max(o.orderdate), o.orderkey FROM orders o GROUP BY o.orderkey, (SELECT avg(i.orderkey) FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0)ORDER BY o.orderkey LIMIT 1", "VALUES ('1996-01-02', 1)");
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o1 JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o2 ON NOT 1 = (SELECT avg(i.orderkey) FROM orders i WHERE o1.orderkey < o2.orderkey AND i.orderkey % 10000 = 0)");
        this.assertQueryFails("SELECT count(*) FROM orders o1 LEFT JOIN orders o2 ON NOT 1 = (SELECT avg(i.orderkey) FROM orders i WHERE o1.orderkey < o2.orderkey)", "line .*: Correlated subquery in given context is not supported");
        this.assertQuery("SELECT count(*) FROM orders o WHERE 100 < (SELECT * FROM (SELECT (SELECT avg(i.orderkey) FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0)))", "VALUES 14999");
        this.assertQuery("SELECT (SELECT avg(regionkey)  FROM nation n2 WHERE n2.nationkey = n1.nationkey),(SELECT avg(regionkey) FROM nation n3 WHERE n3.nationkey = n1.nationkey)FROM nation n1");
        this.assertQuery("SELECT(SELECT avg(regionkey) FROM nation n2  WHERE n2.nationkey = n1.nationkey),(SELECT avg(regionkey)+1  FROM nation n3  WHERE n3.nationkey = n1.nationkey)FROM nation n1");
        this.assertQuery("SELECT * FROM (VALUES (0),( 1), (2), (7)) AS v1(c1) WHERE v1.c1 > (SELECT count(c1) FROM (VALUES (0),( 1), (2)) AS v2(c1) WHERE v1.c1 = v2.c1)", "VALUES (2), (7)");
    }

    @Test
    public void testCorrelatedInPredicateSubqueries() {
        this.assertQuery("SELECT orderkey, clerk IN (SELECT clerk FROM orders s WHERE s.custkey = o.custkey AND s.orderkey < o.orderkey) FROM orders o");
        this.assertQuery("SELECT orderkey FROM orders o WHERE clerk IN (SELECT clerk FROM orders s WHERE s.custkey = o.custkey AND s.orderkey < o.orderkey)");
        this.assertQuery("SELECT t1.a, t1.b,   t1.b in (SELECT t2.b     FROM (values (2, 3), (2, 4), (3, 0), (30,NULL)) t2(a, b)     WHERE t1.a - 5 <= t2.a and t2.a <= t1.a and 0 <= t2.a) from (values (1,1), (2,4), (3,5), (4,NULL), (30,2), (40,NULL) ) t1(a, b) order by t1.a", "VALUES (1,1,FALSE), (2,4,TRUE), (3,5,FALSE), (4,NULL,NULL), (30,2,NULL), (40,NULL,FALSE)");
        this.assertQueryFails("SELECT orderkey FROM orders o WHERE clerk IN (SELECT clerk FROM orders s WHERE s.custkey = o.custkey AND s.orderkey < o.orderkey ORDER BY 1 LIMIT 1)", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQueryFails("SELECT 1 IN (SELECT l.orderkey) FROM lineitem l", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQueryFails("SELECT 1 IN (SELECT 2 * l.orderkey) FROM lineitem l", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQueryFails("SELECT * FROM lineitem l WHERE 1 IN (SELECT 2 * l.orderkey)", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQueryFails("SELECT * FROM lineitem l ORDER BY 1 IN (SELECT 2 * l.orderkey)", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQueryFails("SELECT max(l.quantity), 2 * l.orderkey, 1 IN (SELECT l.orderkey) FROM lineitem l GROUP BY l.orderkey", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQueryFails("SELECT max(l.quantity), 2 * l.orderkey FROM lineitem l GROUP BY l.orderkey HAVING max(l.quantity) IN (SELECT l.orderkey)", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQueryFails("SELECT max(l.quantity), 2 * l.orderkey FROM lineitem l GROUP BY l.orderkey, 1 IN (SELECT l.orderkey)", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQueryFails("SELECT * FROM lineitem l1 JOIN lineitem l2 ON l1.orderkey IN (SELECT l2.orderkey)", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQueryFails("SELECT * FROM lineitem l WHERE (SELECT * FROM (SELECT 1 IN (SELECT 2 * l.orderkey)))", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQueryFails("SELECT * FROM lineitem l WHERE true IN (SELECT 1 IN (SELECT 2 * l.orderkey))", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
    }

    @Test
    public void testCorrelatedExistsSubqueriesWithPrunedCorrelationSymbols() {
        this.assertQuery("SELECT EXISTS(SELECT o.orderkey) FROM orders o");
        this.assertQuery("SELECT count(*) FROM orders o WHERE EXISTS(SELECT o.orderkey)");
        this.assertQuery("SELECT * FROM orders o ORDER BY EXISTS(SELECT o.orderkey)");
        this.assertQuery("SELECT max(o.totalprice), o.orderkey, EXISTS(SELECT o.orderkey) FROM orders o GROUP BY o.orderkey");
        this.assertQuery("SELECT max(o.totalprice), o.orderkey FROM orders o GROUP BY o.orderkey HAVING EXISTS (SELECT o.orderkey)");
        this.assertQuery("SELECT max(o.totalprice), o.orderkey FROM orders o GROUP BY o.orderkey, EXISTS (SELECT o.orderkey)");
        this.assertQuery("SELECT * FROM orders o JOIN (SELECT * FROM lineitem ORDER BY orderkey LIMIT 2) l ON NOT EXISTS(SELECT o.orderkey = l.orderkey)");
        this.assertQuery("SELECT count(*) FROM orders o WHERE (SELECT * FROM (SELECT EXISTS(SELECT o.orderkey)))", "VALUES 15000");
    }

    @Test
    public void testCorrelatedExistsSubqueriesWithEqualityPredicatesInWhere() {
        this.assertQuery("SELECT EXISTS(SELECT 1 WHERE o.orderkey = 1) FROM orders o");
        this.assertQuery("SELECT EXISTS(SELECT null WHERE o.orderkey = 1) FROM orders o");
        this.assertQuery("SELECT count(*) FROM orders o WHERE EXISTS(SELECT 1 WHERE o.orderkey = 0)");
        this.assertQuery("SELECT * FROM orders o ORDER BY EXISTS(SELECT 1 WHERE o.orderkey = 0)");
        this.assertQuery("SELECT count(*) FROM orders o WHERE EXISTS (SELECT avg(l.orderkey) FROM lineitem l WHERE o.orderkey = l.orderkey)");
        this.assertQuery("SELECT count(*) FROM orders o WHERE EXISTS (SELECT avg(l.orderkey) FROM lineitem l WHERE o.orderkey = l.orderkey GROUP BY l.linenumber)");
        this.assertQueryFails("SELECT count(*) FROM orders o WHERE EXISTS (SELECT count(*) FROM lineitem l WHERE o.orderkey = l.orderkey HAVING count(*) > 3)", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQuery("SELECT EXISTS(SELECT 1 WHERE a = 1) FROM (VALUES 1, 1, 2, 3) t(a)", "VALUES true, true, false, false");
        this.assertQuery("SELECT max(o.totalprice), o.orderkey, EXISTS(SELECT 1 WHERE o.orderkey = 0) FROM orders o GROUP BY o.orderkey");
        this.assertQuery("SELECT max(o.totalprice), o.orderkey FROM orders o GROUP BY o.orderkey HAVING EXISTS (SELECT 1 WHERE o.orderkey = 0)");
        this.assertQuery("SELECT max(o.totalprice), o.orderkey FROM orders o GROUP BY o.orderkey, EXISTS (SELECT 1 WHERE o.orderkey = 0)");
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o1 JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o2 ON NOT EXISTS(SELECT 1 WHERE o1.orderkey = o2.orderkey)");
        this.assertQueryFails("SELECT count(*) FROM orders o1 LEFT JOIN orders o2 ON NOT EXISTS(SELECT 1 WHERE o1.orderkey = o2.orderkey)", "line .*: Correlated subquery in given context is not supported");
        this.assertQuery("SELECT count(*) FROM orders o WHERE (SELECT * FROM (SELECT EXISTS(SELECT 1 WHERE o.orderkey = 0)))", "SELECT count(*) FROM orders o WHERE o.orderkey = 0");
        this.assertQuery("SELECT count(*) FROM customer WHERE NOT EXISTS(SELECT * FROM orders WHERE orders.custkey=customer.custkey)", "VALUES 500");
    }

    @Test
    public void testCorrelatedExistsSubqueries() {
        this.assertQuery("SELECT EXISTS(SELECT 1 FROM (VALUES 1, 1, 1, 2, 2, 3, 4) i(a) WHERE i.a < o.a AND i.a < 4) FROM (VALUES 0, 3, 3, 5) o(a)", "VALUES false, true, true, true");
        this.assertQuery("SELECT EXISTS(SELECT 1 WHERE l.orderkey > 0 OR l.orderkey != 3) FROM lineitem l LIMIT 1");
        this.assertQuery("SELECT count(*) FROM orders o WHERE EXISTS(SELECT 1 FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 1000 = 0)", "VALUES 14999");
        this.assertQuery("SELECT count(*) FROM lineitem l WHERE EXISTS(SELECT 1 WHERE l.orderkey > 0 OR l.orderkey != 3)");
        this.assertQuery("SELECT orderkey FROM orders o ORDER BY EXISTS(SELECT 1 FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0)LIMIT 1", "VALUES 60000");
        this.assertQuery("SELECT orderkey FROM lineitem l ORDER BY EXISTS(SELECT 1 WHERE l.orderkey > 0 OR l.orderkey != 3)");
        this.assertQuery("SELECT max(o.orderdate), o.orderkey, EXISTS(SELECT 1 FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0) FROM orders o GROUP BY o.orderkey ORDER BY o.orderkey LIMIT 1", "VALUES ('1996-01-02', 1, true)");
        this.assertQuery("SELECT max(o.orderdate), o.orderkey FROM orders o GROUP BY o.orderkey HAVING EXISTS(SELECT 1 FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0)ORDER BY o.orderkey LIMIT 1", "VALUES ('1996-01-02', 1)");
        this.assertQuery("SELECT max(o.orderdate), o.orderkey FROM orders o GROUP BY o.orderkey, EXISTS(SELECT 1 FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0)ORDER BY o.orderkey LIMIT 1", "VALUES ('1996-01-02', 1)");
        this.assertQuery("SELECT max(l.quantity), l.orderkey, EXISTS(SELECT 1 WHERE l.orderkey > 0 OR l.orderkey != 3) FROM lineitem l GROUP BY l.orderkey");
        this.assertQuery("SELECT max(l.quantity), l.orderkey FROM lineitem l GROUP BY l.orderkey HAVING EXISTS (SELECT 1 WHERE l.orderkey > 0 OR l.orderkey != 3)");
        this.assertQuery("SELECT max(l.quantity), l.orderkey FROM lineitem l GROUP BY l.orderkey, EXISTS (SELECT 1 WHERE l.orderkey > 0 OR l.orderkey != 3)");
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o1 JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o2 ON NOT EXISTS(SELECT 1 FROM orders i WHERE o1.orderkey < o2.orderkey AND i.orderkey % 10000 = 0)");
        this.assertQueryFails("SELECT count(*) FROM orders o1 LEFT JOIN orders o2 ON NOT EXISTS(SELECT 1 FROM orders i WHERE o1.orderkey < o2.orderkey)", "line .*: Correlated subquery in given context is not supported");
        this.assertQuery("SELECT count(*) FROM orders o WHERE (SELECT * FROM (SELECT EXISTS(SELECT 1 FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0)))", "VALUES 14999");
        this.assertQuery("SELECT count(*) FROM orders o WHERE (SELECT * FROM (SELECT EXISTS(SELECT 1 WHERE o.orderkey > 10 OR o.orderkey != 3)))", "VALUES 14999");
    }

    @Test
    public void testTwoCorrelatedExistsSubqueries() {
        this.assertQuery("SELECT\n  count(*) AS numwait\nFROM\n  nation l1\nWHERE\n  EXISTS(\n    SELECT *\n    FROM\n      nation l2\n    WHERE\n      l2.nationkey = l1.nationkey\n  )\n  AND NOT EXISTS(\n    SELECT *\n    FROM\n      nation l3\n    WHERE\n      l3.nationkey= l1.nationkey\n  )\n", "VALUES 0");
    }

    @Test
    public void testPredicatePushdown() {
        this.assertQuery("SELECT *\nFROM (\n  SELECT orderkey+1 AS a FROM orders WHERE orderstatus = 'F' UNION ALL \n  SELECT orderkey FROM orders WHERE orderkey % 2 = 0 UNION ALL \n  (SELECT orderkey+custkey FROM orders ORDER BY orderkey LIMIT 10)\n) \nWHERE a < 20 OR a > 100 \nORDER BY a");
    }

    @Test
    public void testJoinPredicatePushdown() {
        this.assertQuery("SELECT COUNT(*)\nFROM lineitem \nJOIN (\n  SELECT * FROM orders\n) orders \nON lineitem.orderkey = orders.orderkey \nWHERE orders.orderkey % 4 = 0\n  AND lineitem.suppkey > orders.orderkey");
    }

    @Test
    public void testLeftJoinAsInnerPredicatePushdown() {
        this.assertQuery("SELECT COUNT(*)\nFROM lineitem \nLEFT JOIN (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders \nON lineitem.orderkey = orders.orderkey \nWHERE orders.orderkey % 4 = 0\n  AND (lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.custkey IS NULL)");
    }

    @Test
    public void testPlainLeftJoinPredicatePushdown() {
        this.assertQuery("SELECT COUNT(*)\nFROM lineitem \nLEFT JOIN (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders \nON lineitem.orderkey = orders.orderkey \nWHERE lineitem.orderkey % 4 = 0\n  AND (lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.orderkey IS NULL)");
    }

    @Test
    public void testLeftJoinPredicatePushdownWithSelfEquality() {
        this.assertQuery("SELECT COUNT(*)\nFROM lineitem \nLEFT JOIN (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders \nON lineitem.orderkey = orders.orderkey \nWHERE orders.orderkey = orders.orderkey\n  AND lineitem.orderkey % 4 = 0\n  AND (lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.orderkey IS NULL)");
    }

    @Test
    public void testLeftJoinPredicatePushdownWithNullConstant() {
        this.assertQuery("SELECT count(*)\nFROM orders a\nLEFT OUTER JOIN orders b\n  ON a.clerk = b.clerk\nWHERE a.orderpriority='5-LOW'\n  AND b.orderpriority='1-URGENT'\n  AND b.clerk is null\n  AND a.orderkey % 4 = 0\n");
    }

    @Test
    public void testRightJoinAsInnerPredicatePushdown() {
        this.assertQuery("SELECT COUNT(*)\nFROM (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders\nRIGHT JOIN lineitem\nON lineitem.orderkey = orders.orderkey \nWHERE orders.orderkey % 4 = 0\n  AND (lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.custkey IS NULL)");
    }

    @Test
    public void testPlainRightJoinPredicatePushdown() {
        this.assertQuery("SELECT COUNT(*)\nFROM (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders \nRIGHT JOIN lineitem\nON lineitem.orderkey = orders.orderkey \nWHERE lineitem.orderkey % 4 = 0\n  AND (lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.orderkey IS NULL)");
    }

    @Test
    public void testRightJoinPredicatePushdownWithSelfEquality() {
        this.assertQuery("SELECT COUNT(*)\nFROM (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders \nRIGHT JOIN lineitem\nON lineitem.orderkey = orders.orderkey \nWHERE orders.orderkey = orders.orderkey\n  AND lineitem.orderkey % 4 = 0\n  AND (lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.orderkey IS NULL)");
    }

    @Test
    public void testPredicatePushdownJoinEqualityGroups() {
        this.assertQuery("SELECT *\nFROM (\n  SELECT custkey custkey1, custkey%4 custkey1a, custkey%8 custkey1b, custkey%16 custkey1c\n  FROM orders\n) orders1 \nJOIN (\n  SELECT custkey custkey2, custkey%4 custkey2a, custkey%8 custkey2b\n  FROM orders\n) orders2 ON orders1.custkey1 = orders2.custkey2\nWHERE custkey2a = custkey2b\n  AND custkey1 = custkey1a\n  AND custkey2 = custkey2a\n  AND custkey1a = custkey1c\n  AND custkey1b = custkey1c\n  AND custkey1b % 2 = 0");
    }

    @Test
    public void testGroupByKeyPredicatePushdown() {
        this.assertQuery("SELECT *\nFROM (\n  SELECT custkey1, orderstatus1, SUM(totalprice1) totalprice, MAX(custkey2) maxcustkey\n  FROM (\n    SELECT *\n    FROM (\n      SELECT custkey custkey1, orderstatus orderstatus1, CAST(totalprice AS BIGINT) totalprice1, orderkey orderkey1\n      FROM orders\n    ) orders1 \n    JOIN (\n      SELECT custkey custkey2, orderstatus orderstatus2, CAST(totalprice AS BIGINT) totalprice2, orderkey orderkey2\n      FROM orders\n    ) orders2 ON orders1.orderkey1 = orders2.orderkey2\n  ) \n  GROUP BY custkey1, orderstatus1\n)\nWHERE custkey1 = maxcustkey\nAND maxcustkey % 2 = 0 \nAND orderstatus1 = 'F'\nAND totalprice > 10000\nORDER BY custkey1, orderstatus1, totalprice, maxcustkey");
    }

    @Test
    public void testNonDeterministicJoinPredicatePushdown() {
        MaterializedResult materializedResult = this.computeActual("SELECT COUNT(*)\nFROM (\n  SELECT DISTINCT *\n  FROM (\n    SELECT 'abc' AS col1a, 500 AS col1b FROM lineitem LIMIT 1\n  ) table1\n  JOIN (\n    SELECT 'abc' AS col2a FROM lineitem LIMIT 1000000\n  ) table2\n  ON table1.col1a = table2.col2a\n  WHERE rand() * 1000 > table1.col1b\n)");
        MaterializedRow row = (MaterializedRow)Iterables.getOnlyElement((Iterable)materializedResult.getMaterializedRows());
        Assert.assertEquals((int)row.getFieldCount(), (int)1);
        long count = (Long)row.getField(0);
        org.testng.Assert.assertTrue((count > 0L && count < 1000000L ? 1 : 0) != 0);
    }

    @Test
    public void testTrivialNonDeterministicPredicatePushdown() {
        this.assertQuery("SELECT COUNT(*) WHERE rand() >= 0");
    }

    @Test
    public void testNonDeterministicTableScanPredicatePushdown() {
        MaterializedResult materializedResult = this.computeActual("SELECT COUNT(*)\nFROM (\n  SELECT *\n  FROM lineitem\n  LIMIT 1000\n)\nWHERE rand() > 0.5");
        MaterializedRow row = (MaterializedRow)Iterables.getOnlyElement((Iterable)materializedResult.getMaterializedRows());
        Assert.assertEquals((int)row.getFieldCount(), (int)1);
        long count = (Long)row.getField(0);
        org.testng.Assert.assertTrue((count > 0L && count < 1000L ? 1 : 0) != 0);
    }

    @Test
    public void testNonDeterministicAggregationPredicatePushdown() {
        MaterializedResult materializedResult = this.computeActual("SELECT COUNT(*)\nFROM (\n  SELECT orderkey, COUNT(*)\n  FROM lineitem\n  GROUP BY orderkey\n  LIMIT 1000\n)\nWHERE rand() > 0.5");
        MaterializedRow row = (MaterializedRow)Iterables.getOnlyElement((Iterable)materializedResult.getMaterializedRows());
        Assert.assertEquals((int)row.getFieldCount(), (int)1);
        long count = (Long)row.getField(0);
        org.testng.Assert.assertTrue((count > 0L && count < 1000L ? 1 : 0) != 0);
    }

    @Test
    public void testSemiJoinPredicateMoveAround() {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM orders WHERE custkey % 2 = 0 AND orderkey % 3 = 0)\nWHERE orderkey\n  IN (\n    SELECT CASE WHEN orderkey % 7 = 0 THEN NULL ELSE orderkey END\n    FROM lineitem\n    WHERE partkey % 2 = 0)\n  AND\n    orderkey % 2 = 0");
    }

    @Test
    public void testUnionAllPredicateMoveAroundWithOverlappingProjections() {
        this.assertQuery("SELECT COUNT(*)\nFROM (\n  SELECT orderkey AS x, orderkey AS y\n  FROM orders\n  WHERE orderkey % 3 = 0\n  UNION ALL\n  SELECT orderkey AS x, orderkey AS y\n  FROM orders\n  WHERE orderkey % 2 = 0\n) a\nJOIN (\n  SELECT orderkey AS x, orderkey AS y\n  FROM orders\n) b\nON a.x = b.x");
    }

    @Test
    public void testTableSampleBernoulliBoundaryValues() {
        MaterializedResult fullSample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE BERNOULLI (100)");
        MaterializedResult emptySample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE BERNOULLI (0)");
        MaterializedResult all = this.computeExpected("SELECT orderkey FROM orders", fullSample.getTypes());
        QueryAssertions.assertContains(all, fullSample);
        Assert.assertEquals((int)emptySample.getMaterializedRows().size(), (int)0);
    }

    @Test
    public void testTableSampleBernoulli() {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        int total = this.computeExpected("SELECT orderkey FROM orders", (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT)).getMaterializedRows().size();
        for (int i = 0; i < 100; ++i) {
            List values = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE BERNOULLI (50)").getMaterializedRows();
            Assert.assertEquals((int)values.size(), (int)ImmutableSet.copyOf((Collection)values).size(), (String)"TABLESAMPLE produced duplicate rows");
            stats.addValue((double)values.size() * 1.0 / (double)total);
        }
        double mean = stats.getGeometricMean();
        org.testng.Assert.assertTrue((mean > 0.45 && mean < 0.55 ? 1 : 0) != 0, (String)String.format("Expected mean sampling rate to be ~0.5, but was %s", mean));
    }

    @Test
    public void testFunctionNotRegistered() {
        this.assertQueryFails("SELECT length(1)", "\\Qline 1:8: Unexpected parameters (integer) for function length. Expected:\\E.*");
    }

    @Test
    public void testFunctionArgumentTypeConstraint() {
        this.assertQueryFails("SELECT greatest(rgb(255, 0, 0))", "\\Qline 1:8: Unexpected parameters (color) for function greatest. Expected: greatest(E) E:orderable\\E.*");
    }

    @Test
    public void testTypeMismatch() {
        this.assertQueryFails("SELECT 1 <> 'x'", "\\Qline 1:10: '<>' cannot be applied to integer, varchar(1)\\E");
    }

    @Test
    public void testInvalidType() {
        this.assertQueryFails("SELECT CAST(null AS array(foo))", "\\Qline 1:8: Unknown type: array(foo)\\E");
    }

    @Test
    public void testInvalidTypeInfixOperator() {
        this.assertQueryFails("SELECT ('a' || 'z') + (3 * 4) / 5", "\\Qline 1:21: '+' cannot be applied to varchar, integer\\E");
    }

    @Test
    public void testInvalidTypeBetweenOperator() {
        this.assertQueryFails("SELECT 'a' BETWEEN 3 AND 'z'", "\\Qline 1:12: Cannot check if varchar(1) is BETWEEN integer and varchar(1)\\E");
    }

    @Test
    public void testInvalidTypeArray() {
        this.assertQueryFails("SELECT ARRAY[1, 2, 'a']", "\\Qline 1:20: All ARRAY elements must be the same type: integer\\E");
    }

    @Test
    public void testArrayShuffle() {
        List expected = IntStream.rangeClosed(1, 500).boxed().collect(Collectors.toList());
        HashSet<List> distinctResults = new HashSet<List>();
        distinctResults.add(expected);
        for (int i = 0; i < 3; ++i) {
            MaterializedResult results = this.computeActual(String.format("SELECT shuffle(ARRAY %s) FROM orders LIMIT 10", expected));
            List rows = results.getMaterializedRows();
            Assert.assertEquals((int)rows.size(), (int)10);
            for (MaterializedRow row : rows) {
                List actual = (List)row.getField(0);
                QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
                distinctResults.add(actual);
            }
        }
        org.testng.Assert.assertTrue((distinctResults.size() >= 24 ? 1 : 0) != 0, (String)"shuffle must produce at least 24 distinct results");
    }

    @Test
    public void testNonReservedTimeWords() {
        this.assertQuery("SELECT TIME, TIMESTAMP, DATE, INTERVAL FROM (SELECT 1 TIME, 2 TIMESTAMP, 3 DATE, 4 INTERVAL)", "SELECT 1, 2, 3, 4");
    }

    @Test
    public void testCustomAdd() {
        this.assertQuery("SELECT custom_add(orderkey, custkey) FROM orders", "SELECT orderkey + custkey FROM orders");
    }

    @Test
    public void testCustomSum() {
        String sql = "SELECT orderstatus, custom_sum(orderkey) FROM orders GROUP BY orderstatus";
        this.assertQuery(sql, sql.replace("custom_sum", "sum"));
    }

    @Test
    public void testCustomRank() {
        String sql = "SELECT orderstatus, clerk, sales\n, custom_rank() OVER (PARTITION BY orderstatus ORDER BY sales DESC) rnk\nFROM (\n  SELECT orderstatus, clerk, sum(totalprice) sales\n  FROM orders\n  GROUP BY orderstatus, clerk\n)\nORDER BY orderstatus, clerk";
        Assert.assertEquals((Iterable)this.computeActual(sql), (Iterable)this.computeActual(sql.replace("custom_rank", "rank")));
    }

    @Test
    public void testApproxSetBigint() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(approx_set(custkey)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1002L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetVarchar() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(approx_set(CAST(custkey AS VARCHAR))) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1024L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetDouble() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(approx_set(CAST(custkey AS DOUBLE))) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1014L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetBigintGroupBy() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(approx_set(custkey)) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 1001L}).row(new Object[]{"F", 998L}).row(new Object[]{"P", 304L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetVarcharGroupBy() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(approx_set(CAST(custkey AS VARCHAR))) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 1021L}).row(new Object[]{"F", 1019L}).row(new Object[]{"P", 304L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetDoubleGroupBy() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(approx_set(CAST(custkey AS DOUBLE))) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 1011L}).row(new Object[]{"F", 1011L}).row(new Object[]{"P", 304L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetWithNulls() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(approx_set(IF(orderstatus = 'O', custkey))) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{1001L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetOnlyNulls() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(approx_set(null)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{null}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetGroupByWithOnlyNullsInOneGroup() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(approx_set(IF(orderstatus != 'O', custkey))) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", null}).row(new Object[]{"F", 998L}).row(new Object[]{"P", 304L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetGroupByWithNulls() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(approx_set(IF(custkey % 2 <> 0, custkey))) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 499L}).row(new Object[]{"F", 496L}).row(new Object[]{"P", 153L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetBigintWithMaxError() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(approx_set(custkey, 0.01)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1000L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetVarcharWithMaxError() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(approx_set(CAST(custkey AS VARCHAR), 0.01)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1000L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetDoubleWithMaxError() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(approx_set(CAST(custkey AS DOUBLE), 0.01)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1000L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testMergeHyperLogLog() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(merge(create_hll(custkey))) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1002L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testMergeHyperLogLogGroupBy() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(merge(create_hll(custkey))) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 1001L}).row(new Object[]{"F", 998L}).row(new Object[]{"P", 304L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testMergeHyperLogLogWithNulls() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(merge(create_hll(IF(orderstatus = 'O', custkey)))) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1001L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testMergeHyperLogLogGroupByWithNulls() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(merge(create_hll(IF(orderstatus != 'O', custkey)))) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", null}).row(new Object[]{"F", 998L}).row(new Object[]{"P", 304L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testMergeHyperLogLogOnlyNulls() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(merge(CAST (null AS HyperLogLog))) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{null}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testEmptyApproxSet() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(empty_approx_set())");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{0L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testEmptyApproxSetWithMaxError() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(empty_approx_set(0.1))");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{0L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test(expectedExceptions={RuntimeException.class, PrestoException.class}, expectedExceptionsMessageRegExp="Max standard error must be in.*")
    public void testEmptyApproxSetWithMaxErrorOutsideBounds() {
        this.computeActual("SELECT cardinality(empty_approx_set(0.3))");
    }

    @Test
    public void testMergeEmptyApproxSet() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(merge(empty_approx_set())) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{0L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testMergeEmptyNonEmptyApproxSet() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(merge(c)) FROM (SELECT create_hll(custkey) c FROM orders UNION ALL SELECT empty_approx_set())");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1002L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testMergeEmptyNonEmptyApproxSetWithSameMaxError() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(merge(c)) FROM (SELECT create_hll(custkey, 0.1) c FROM orders UNION ALL SELECT empty_approx_set(0.1))");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1046L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test(expectedExceptions={RuntimeException.class, PrestoException.class}, expectedExceptionsMessageRegExp="Cannot merge HLLs with different number of buckets.*")
    public void testMergeEmptyNonEmptyApproxSetWithDifferentMaxError() {
        this.computeActual("SELECT cardinality(merge(c)) FROM (SELECT create_hll(custkey, 0.1) c FROM orders UNION ALL SELECT empty_approx_set(0.2))");
    }

    @Test
    public void testP4ApproxSetBigint() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(cast(approx_set(custkey) AS P4HYPERLOGLOG)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1002L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetVarchar() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(cast(approx_set(CAST(custkey AS VARCHAR)) AS P4HYPERLOGLOG)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1024L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetDouble() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(cast(approx_set(CAST(custkey AS DOUBLE)) AS P4HYPERLOGLOG)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1014L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetBigintGroupBy() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(cast(approx_set(custkey) AS P4HYPERLOGLOG)) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 1001L}).row(new Object[]{"F", 998L}).row(new Object[]{"P", 308L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetVarcharGroupBy() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(cast(approx_set(CAST(custkey AS VARCHAR)) AS P4HYPERLOGLOG)) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 1021L}).row(new Object[]{"F", 1019L}).row(new Object[]{"P", 302L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetDoubleGroupBy() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(cast(approx_set(CAST(custkey AS DOUBLE)) AS P4HYPERLOGLOG)) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 1011L}).row(new Object[]{"F", 1011L}).row(new Object[]{"P", 306L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetWithNulls() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(cast(approx_set(IF(orderstatus = 'O', custkey)) AS P4HYPERLOGLOG)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{1001L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetOnlyNulls() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(cast(approx_set(null) AS P4HYPERLOGLOG)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{null}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetGroupByWithOnlyNullsInOneGroup() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(cast(approx_set(IF(orderstatus != 'O', custkey)) AS P4HYPERLOGLOG)) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", null}).row(new Object[]{"F", 998L}).row(new Object[]{"P", 308L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetGroupByWithNulls() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(cast(approx_set(IF(custkey % 2 <> 0, custkey)) AS P4HYPERLOGLOG)) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 495L}).row(new Object[]{"F", 491L}).row(new Object[]{"P", 153L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testValuesWithNonTrivialType() {
        MaterializedResult actual = this.computeActual("VALUES (0E0/0E0, 1E0/0E0, -1E0/0E0)");
        List rows = actual.getMaterializedRows();
        Assert.assertEquals((int)rows.size(), (int)1);
        MaterializedRow row = (MaterializedRow)rows.get(0);
        org.testng.Assert.assertTrue((boolean)((Double)row.getField(0)).isNaN());
        Assert.assertEquals((Object)row.getField(1), (Object)Double.POSITIVE_INFINITY);
        Assert.assertEquals((Object)row.getField(2), (Object)Double.NEGATIVE_INFINITY);
    }

    @Test
    public void testValuesWithTimestamp() {
        MaterializedResult actual = this.computeActual("VALUES (current_timestamp, now())");
        List rows = actual.getMaterializedRows();
        Assert.assertEquals((int)rows.size(), (int)1);
        MaterializedRow row = (MaterializedRow)rows.get(0);
        Assert.assertEquals((Object)row.getField(0), (Object)row.getField(1));
    }

    @Test
    public void testValuesWithUnusedColumns() {
        MaterializedResult actual = this.computeActual("SELECT foo FROM (values (1, 2)) a(foo, bar)");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{1}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testFilterPushdownWithAggregation() {
        this.assertQuery("SELECT * FROM (SELECT count(*) FROM orders) WHERE 0=1");
        this.assertQuery("SELECT * FROM (SELECT count(*) FROM orders) WHERE null");
    }

    @Test
    public void testAccessControl() {
        this.assertAccessDenied("INSERT INTO orders SELECT * FROM orders", "Cannot insert into table .*.orders.*", TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.INSERT_TABLE));
        this.assertAccessDenied("DELETE FROM orders", "Cannot delete from table .*.orders.*", TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.DELETE_TABLE));
        this.assertAccessDenied("CREATE TABLE foo AS SELECT * FROM orders", "Cannot create table .*.foo.*", TestingAccessControlManager.privilege((String)"foo", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_TABLE));
        this.assertAccessDenied("SELECT * FROM nation", "Cannot select from columns \\[nationkey, regionkey, name, comment\\] in table .*.nation.*", TestingAccessControlManager.privilege((String)"nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessDenied("SELECT * FROM (SELECT * FROM nation)", "Cannot select from columns \\[nationkey, regionkey, name, comment\\] in table .*.nation.*", TestingAccessControlManager.privilege((String)"nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessDenied("SELECT name FROM (SELECT * FROM nation)", "Cannot select from columns \\[nationkey, regionkey, name, comment\\] in table .*.nation.*", TestingAccessControlManager.privilege((String)"nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessAllowed("SELECT name FROM nation", TestingAccessControlManager.privilege((String)"nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessDenied("SELECT n1.nationkey, n2.regionkey FROM nation n1, nation n2", "Cannot select from columns \\[nationkey, regionkey\\] in table .*.nation.*", TestingAccessControlManager.privilege((String)"nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessDenied("SELECT count(name) as c FROM nation where comment > 'abc' GROUP BY regionkey having max(nationkey) > 10", "Cannot select from columns \\[nationkey, regionkey, name, comment\\] in table .*.nation.*", TestingAccessControlManager.privilege((String)"nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessDenied("SELECT 1 FROM region, nation where region.regionkey = nation.nationkey", "Cannot select from columns \\[nationkey\\] in table .*.nation.*", TestingAccessControlManager.privilege((String)"nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessDenied("SELECT count(*) FROM nation", "Cannot select from columns \\[\\] in table .*.nation.*", TestingAccessControlManager.privilege((String)"nation", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessDenied("WITH t1 AS (SELECT * FROM nation) SELECT * FROM t1", "Cannot select from columns \\[nationkey, regionkey, name, comment\\] in table .*.nation.*", TestingAccessControlManager.privilege((String)"nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessAllowed("SELECT name AS my_alias FROM nation", TestingAccessControlManager.privilege((String)"my_alias", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessAllowed("SELECT my_alias from (SELECT name AS my_alias FROM nation)", TestingAccessControlManager.privilege((String)"my_alias", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessDenied("SELECT name AS my_alias FROM nation", "Cannot select from columns \\[name\\] in table .*.nation.*", TestingAccessControlManager.privilege((String)"name", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
    }

    @Test
    public void testEmptyInputForUnnest() {
        this.assertQuery("SELECT val FROM (SELECT DISTINCT vals FROM (values (array[2])) t(vals) WHERE false) tmp CROSS JOIN unnest(tmp.vals) tt(val)", "SELECT 1 WHERE 1=2");
    }

    @Test
    public void testCoercions() {
        this.assertQuery("SELECT length(NULL)");
        this.assertQuery("SELECT CAST('abc' AS VARCHAR(255)) || CAST('abc' AS VARCHAR(252))");
        this.assertQuery("SELECT CAST('abc' AS VARCHAR(255)) || 'abc'");
        this.assertQuery("SELECT CAST(1.1 AS DECIMAL(38,1)) + NULL");
        this.assertQuery("SELECT CAST(292 AS DECIMAL(38,1)) + CAST(292.1 AS DECIMAL(5,1))");
        QueryAssertions.assertEqualsIgnoreOrder(this.computeActual("SELECT ARRAY[CAST(282 AS DECIMAL(22,1)), CAST(282 AS DECIMAL(10,1))] || CAST(292 AS DECIMAL(5,1))"), this.computeActual("SELECT ARRAY[CAST(282 AS DECIMAL(22,1)), CAST(282 AS DECIMAL(10,1)), CAST(292 AS DECIMAL(5,1))]"));
        this.assertQuery("SELECT CAST(1.1 AS DECIMAL(38,1)) + CAST(292 AS BIGINT)");
        this.assertQuery("SELECT CAST(292 AS DECIMAL(38,1)) = CAST(292 AS BIGINT)");
        QueryAssertions.assertEqualsIgnoreOrder(this.computeActual("SELECT ARRAY[CAST(282 AS DECIMAL(22,1)), CAST(282 AS DECIMAL(10,1))] || CAST(292 AS BIGINT)"), this.computeActual("SELECT ARRAY[CAST(282 AS DECIMAL(22,1)), CAST(282 AS DECIMAL(10,1)), CAST(292 AS DECIMAL(19,0))]"));
        this.assertQuery("SELECT CAST(1.1 AS DECIMAL(38,1)) + CAST(1.1 AS DOUBLE)");
        this.assertQuery("SELECT CAST(1.1 AS DECIMAL(38,1)) = CAST(1.1 AS DOUBLE)");
        this.assertQuery("SELECT SIN(CAST(1.1 AS DECIMAL(38,1)))");
        QueryAssertions.assertEqualsIgnoreOrder(this.computeActual("SELECT ARRAY[CAST(282.1 AS DOUBLE), CAST(283.2 AS DOUBLE)] || CAST(101.3 AS DECIMAL(5,1))"), this.computeActual("SELECT ARRAY[CAST(282.1 AS DOUBLE), CAST(283.2 AS DOUBLE), CAST(101.3 AS DOUBLE)]"));
        this.assertQuery("SELECT CAST(1.1 AS DECIMAL(38,1)) + CAST(292 AS INTEGER)");
        this.assertQuery("SELECT CAST(292 AS DECIMAL(38,1)) = CAST(292 AS INTEGER)");
        QueryAssertions.assertEqualsIgnoreOrder(this.computeActual("SELECT ARRAY[CAST(282 AS DECIMAL(22,1)), CAST(282 AS DECIMAL(10,1))] || CAST(292 AS INTEGER)"), this.computeActual("SELECT ARRAY[CAST(282 AS DECIMAL(22,1)), CAST(282 AS DECIMAL(10,1)), CAST(292 AS DECIMAL(19,0))]"));
        this.assertQuery("SELECT CAST(1.1 AS DECIMAL(38,1)) + CAST(CAST(121 AS DECIMAL(30,1)) AS TINYINT)");
        this.assertQuery("SELECT CAST(292 AS DECIMAL(38,1)) = CAST(CAST(121 AS DECIMAL(30,1)) AS TINYINT)");
        this.assertQuery("SELECT CAST(1.1 AS DECIMAL(38,1)) + CAST(CAST(121 AS DECIMAL(30,1)) AS SMALLINT)");
        this.assertQuery("SELECT CAST(292 AS DECIMAL(38,1)) = CAST(CAST(121 AS DECIMAL(30,1)) AS SMALLINT)");
        this.assertQuery("SELECT * FROM (  SELECT t2.x || t2.z cc FROM (    SELECT *    FROM (VALUES (CAST('a' AS VARCHAR), CAST('c' AS VARCHAR))) t(x, z)  ) t2  JOIN (    SELECT *    FROM (VALUES (CAST('a' AS VARCHAR), CAST('c' AS VARCHAR))) u(x, z)    WHERE z='c'  ) u2  ON t2.z = u2.z) tt WHERE cc = 'ac'", "SELECT 'ac'");
        this.assertQuery("SELECT * FROM (  SELECT greatest (t.x, t.z) cc FROM (    SELECT *    FROM (VALUES (VARCHAR 'a', VARCHAR 'c')) t(x, z)  ) t  JOIN (    SELECT *    FROM (VALUES (VARCHAR 'a', VARCHAR 'c')) u(x, z)    WHERE z='c'  ) u  ON t.z = u.z)WHERE cc = 'c'", "SELECT 'c'");
        this.assertQuery("SELECT cc[1], cc[2] FROM ( SELECT * FROM (  SELECT array[t.x, t.z] cc FROM (    SELECT *    FROM (VALUES (VARCHAR 'a', VARCHAR 'c')) t(x, z)  ) t  JOIN (    SELECT *    FROM (VALUES (VARCHAR 'a', VARCHAR 'c')) u(x, z)    WHERE z='c'  ) u  ON t.z = u.z) WHERE cc = array['a', 'c'])", "SELECT 'a', 'c'");
        this.assertQuery("SELECT c = 'x'FROM (    SELECT 'x' AS c    UNION ALL    SELECT 'yy' AS c)");
    }

    @Test
    public void testExecute() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SELECT 123, 'abc'").build();
        this.assertQuery(session, "EXECUTE my_query", "SELECT 123, 'abc'");
    }

    @Test
    public void testExecuteUsing() {
        String query = "SELECT a + 1, count(?) FROM (VALUES 1, 2, 3, 2) t1(a) JOIN (VALUES 1, 2, 3, 4) t2(b) ON b < ? WHERE a < ? GROUP BY a + 1 HAVING count(1) > ?";
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", query).build();
        this.assertQuery(session, "EXECUTE my_query USING 1, 5, 4, 0", "VALUES (2, 4), (3, 8), (4, 4)");
    }

    @Test
    public void testExecuteUsingComplexJoinCriteria() {
        String query = "SELECT * FROM (VALUES 1) t(a) JOIN (VALUES 2) u(a) ON t.a + u.a < ?";
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", query).build();
        this.assertQuery(session, "EXECUTE my_query USING 5", "VALUES (1, 2)");
    }

    @Test
    public void testExecuteUsingWithSubquery() {
        String query = "SELECT ? in (SELECT orderkey FROM orders)";
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", query).build();
        this.assertQuery(session, "EXECUTE my_query USING 10", "SELECT 10 in (SELECT orderkey FROM orders)");
    }

    @Test
    public void testExecuteUsingWithSubqueryInJoin() {
        String query = "SELECT * FROM     (VALUES ?,2,3) t(x)   JOIN     (VALUES 1,2,3) t2(y)   ON (x in (VALUES 1,2,?)) = (y in (VALUES 1,2,3)) AND (x in (VALUES 1,?)) = (y in (VALUES 1,2))";
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", query).build();
        this.assertQuery(session, "EXECUTE my_query USING 1, 3, 2", "VALUES (1,1), (1,2), (2,2), (2,1), (3,3)");
    }

    @Test
    public void testExecuteWithParametersInGroupBy() {
        try {
            String query = "SELECT a + ?, count(1) FROM (VALUES 1, 2, 3, 2) t(a) GROUP BY a + ?";
            Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", query).build();
            this.computeActual(session, "EXECUTE my_query USING 1, 1");
            org.testng.Assert.fail((String)"parameters in GROUP BY and SELECT should fail");
        }
        catch (SemanticException e) {
            Assert.assertEquals((Object)e.getCode(), (Object)SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY);
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"line 1:10: '(a + ?)' must be an aggregate expression or appear in GROUP BY clause");
        }
    }

    @Test
    public void testExecuteNoSuchQuery() {
        this.assertQueryFails("EXECUTE my_query", "Prepared statement not found: my_query");
    }

    @Test
    public void testParametersNonPreparedStatement() {
        try {
            this.computeActual("SELECT ?, 1");
            org.testng.Assert.fail((String)"parameters not in prepared statements should fail");
        }
        catch (SemanticException e) {
            Assert.assertEquals((Object)e.getCode(), (Object)SemanticErrorCode.INVALID_PARAMETER_USAGE);
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"line 1:1: Incorrect number of parameters: expected 1 but found 0");
        }
    }

    @Test
    public void testDescribeInput() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SELECT ? FROM nation WHERE nationkey = ? and name < ?").build();
        MaterializedResult actual = this.computeActual(session, "DESCRIBE INPUT my_query");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR}).row(new Object[]{0, "unknown"}).row(new Object[]{1, "bigint"}).row(new Object[]{2, "varchar"}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    @Test
    public void testDescribeInputWithAggregation() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SELECT count(*) + ? FROM nation").build();
        MaterializedResult actual = this.computeActual(session, "DESCRIBE INPUT my_query");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR}).row(new Object[]{0, "bigint"}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    @Test
    public void testDescribeInputNoParameters() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SELECT * FROM nation").build();
        MaterializedResult actual = this.computeActual(session, "DESCRIBE INPUT my_query");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{UnknownType.UNKNOWN, UnknownType.UNKNOWN}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testDescribeInputNoSuchQuery() {
        this.assertQueryFails("DESCRIBE INPUT my_query", "Prepared statement not found: my_query");
    }

    @Test
    public void testQuantifiedComparison() {
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey = ANY (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey = ALL (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey <> ANY (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey <> ALL (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey = ALL (SELECT regionkey FROM region WHERE name IN ('ASIA'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey <> ALL (SELECT regionkey FROM region WHERE name IN ('ASIA'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey = ANY (SELECT regionkey FROM region WHERE name IN ('EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey <> ANY (SELECT regionkey FROM region WHERE name IN ('EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey < SOME (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey <= ANY (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey > ANY (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey >= SOME (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey < ALL (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey <= ALL (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey > ALL (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey >= ALL (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT 1.0 < ALL(SELECT 1), 1 < ALL(SELECT 1)");
        this.assertQuery("SELECT 1.0 < ANY(SELECT 1), 1 < ANY(SELECT 1)");
        this.assertQuery("SELECT 1.0 <= ALL(SELECT 1) WHERE 1 <= ALL(SELECT 1)");
        this.assertQuery("SELECT 1.0 <= ANY(SELECT 1) WHERE 1 <= ANY(SELECT 1)");
        this.assertQuery("SELECT 1.0 <= ALL(SELECT 1), 1 <= ALL(SELECT 1) WHERE 1 <= ALL(SELECT 1)");
        this.assertQuery("SELECT 1.0 <= ANY(SELECT 1), 1 <= ANY(SELECT 1) WHERE 1 <= ANY(SELECT 1)");
        this.assertQuery("SELECT 1.0 = ALL(SELECT 1) WHERE 1 = ALL(SELECT 1)");
        this.assertQuery("SELECT 1.0 = ANY(SELECT 1) WHERE 1 = ANY(SELECT 1)");
        this.assertQuery("SELECT 1.0 = ALL(SELECT 1), 2 = ALL(SELECT 1) WHERE 1 = ALL(SELECT 1)");
        this.assertQuery("SELECT 1.0 = ANY(SELECT 1), 2 = ANY(SELECT 1) WHERE 1 = ANY(SELECT 1)");
        this.assertQuery("SELECT CAST(1 AS decimal(3,2)) < ALL(SELECT CAST(1 AS decimal(3,1)))");
        this.assertQuery("SELECT CAST(1 AS decimal(3,2)) < ANY(SELECT CAST(1 AS decimal(3,1)))");
        this.assertQuery("SELECT CAST(1 AS decimal(3,2)) <= ALL(SELECT CAST(1 AS decimal(3,1)))");
        this.assertQuery("SELECT CAST(1 AS decimal(3,2)) <= ANY(SELECT CAST(1 AS decimal(3,1)))");
        this.assertQuery("SELECT CAST(1 AS decimal(3,2)) = ALL(SELECT CAST(1 AS decimal(3,1)))");
        this.assertQuery("SELECT CAST(1 AS decimal(3,2)) = ANY(SELECT CAST(1 AS decimal(3,1)))", "SELECT true");
        this.assertQuery("SELECT CAST(1 AS decimal(3,2)) <> ALL(SELECT CAST(1 AS decimal(3,1)))");
        this.assertQuery("SELECT CAST(1 AS decimal(3,2)) <> ANY(SELECT CAST(1 AS decimal(3,1)))");
    }

    @Test(dataProvider="quantified_comparisons_corner_cases")
    public void testQuantifiedComparisonCornerCases(String query) {
        this.assertQuery(query);
    }

    @DataProvider(name="quantified_comparisons_corner_cases")
    public Object[][] qualifiedComparisonsCornerCases() {
        return (Object[][])QueryTemplate.queryTemplate((String)"SELECT %value% %operator% %quantifier% (SELECT * FROM (%subquery%))", (QueryTemplate.Parameter[])new QueryTemplate.Parameter[0]).replaceAll(new List[]{QueryTemplate.parameter((String)"subquery").of(new String[]{"SELECT 1 WHERE false", "SELECT CAST(NULL AS INTEGER)", "VALUES (1), (NULL)"}), QueryTemplate.parameter((String)"quantifier").of(new String[]{"ALL", "ANY"}), QueryTemplate.parameter((String)"value").of(new String[]{"1", "NULL"}), QueryTemplate.parameter((String)"operator").of(new String[]{"=", "!=", "<", ">", "<=", ">="})}).collect(TestngUtils.toDataProvider());
    }

    @Test
    public void testPreparedStatementWithSubqueries() {
        List leftValues = QueryTemplate.parameter((String)"left").of(new String[]{"", "1 = ", "EXISTS", "1 IN", "1 = ANY", "1 = ALL", "2 <> ANY", "2 <> ALL", "0 < ALL", "0 < ANY", "1 <= ALL", "1 <= ANY"});
        QueryTemplate.queryTemplate((String)"SELECT %left% (SELECT 1 WHERE 2 = ?)", (QueryTemplate.Parameter[])new QueryTemplate.Parameter[0]).replaceAll(new List[]{leftValues}).forEach(query -> {
            Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", query).build();
            this.assertQuery(session, "EXECUTE my_query USING 2", "SELECT true");
        });
    }

    @Test
    public void testDescribeOutput() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SELECT * FROM nation").build();
        MaterializedResult actual = this.computeActual(session, "DESCRIBE OUTPUT my_query");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN}).row(new Object[]{"nationkey", session.getCatalog().get(), session.getSchema().get(), "nation", "bigint", 8, false}).row(new Object[]{"name", session.getCatalog().get(), session.getSchema().get(), "nation", "varchar(25)", 0, false}).row(new Object[]{"regionkey", session.getCatalog().get(), session.getSchema().get(), "nation", "bigint", 8, false}).row(new Object[]{"comment", session.getCatalog().get(), session.getSchema().get(), "nation", "varchar(152)", 0, false}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    @Test
    public void testDescribeOutputNamedAndUnnamed() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SELECT 1, name, regionkey AS my_alias FROM nation").build();
        MaterializedResult actual = this.computeActual(session, "DESCRIBE OUTPUT my_query");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN}).row(new Object[]{"_col0", "", "", "", "integer", 4, false}).row(new Object[]{"name", session.getCatalog().get(), session.getSchema().get(), "nation", "varchar(25)", 0, false}).row(new Object[]{"my_alias", session.getCatalog().get(), session.getSchema().get(), "nation", "bigint", 8, true}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    @Test
    public void testDescribeOutputNonSelect() {
        this.assertDescribeOutputRowCount("CREATE TABLE foo AS SELECT * FROM nation");
        this.assertDescribeOutputRowCount("DELETE FROM orders");
        this.assertDescribeOutputEmpty("CALL foo()");
        this.assertDescribeOutputEmpty("SET SESSION optimize_hash_generation=false");
        this.assertDescribeOutputEmpty("RESET SESSION optimize_hash_generation");
        this.assertDescribeOutputEmpty("START TRANSACTION");
        this.assertDescribeOutputEmpty("COMMIT");
        this.assertDescribeOutputEmpty("ROLLBACK");
        this.assertDescribeOutputEmpty("GRANT INSERT ON foo TO bar");
        this.assertDescribeOutputEmpty("REVOKE INSERT ON foo FROM bar");
        this.assertDescribeOutputEmpty("CREATE SCHEMA foo");
        this.assertDescribeOutputEmpty("ALTER SCHEMA foo RENAME TO bar");
        this.assertDescribeOutputEmpty("DROP SCHEMA foo");
        this.assertDescribeOutputEmpty("CREATE TABLE foo (x bigint)");
        this.assertDescribeOutputEmpty("ALTER TABLE foo ADD COLUMN y bigint");
        this.assertDescribeOutputEmpty("ALTER TABLE foo RENAME TO bar");
        this.assertDescribeOutputEmpty("DROP TABLE foo");
        this.assertDescribeOutputEmpty("CREATE VIEW foo AS SELECT * FROM nation");
        this.assertDescribeOutputEmpty("CREATE FUNCTION testing.default.tan (x int) RETURNS double COMMENT 'tangent trigonometric function' LANGUAGE SQL DETERMINISTIC CALLED ON NULL INPUT RETURN sin(x) / cos(x)");
        this.assertDescribeOutputEmpty("ALTER FUNCTION testing.default.tan CALLED ON NULL INPUT");
        this.assertDescribeOutputEmpty("DROP FUNCTION IF EXISTS testing.default.tan (int)");
        this.assertDescribeOutputEmpty("DROP VIEW foo");
        this.assertDescribeOutputEmpty("PREPARE test FROM SELECT * FROM orders");
        this.assertDescribeOutputEmpty("EXECUTE test");
        this.assertDescribeOutputEmpty("DEALLOCATE PREPARE test");
    }

    private void assertDescribeOutputRowCount(@Language(value="SQL") String sql) {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", sql).build();
        MaterializedResult actual = this.computeActual(session, "DESCRIBE OUTPUT my_query");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN}).row(new Object[]{"rows", "", "", "", "bigint", 8, false}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    private void assertDescribeOutputEmpty(@Language(value="SQL") String sql) {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", sql).build();
        MaterializedResult actual = this.computeActual(session, "DESCRIBE OUTPUT my_query");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    @Test
    public void testDescribeOutputShowTables() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SHOW TABLES").build();
        MaterializedResult actual = this.computeActual(session, "DESCRIBE OUTPUT my_query");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN}).row(new Object[]{"Table", session.getCatalog().get(), "information_schema", "tables", "varchar", 0, true}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    @Test
    public void testDescribeOutputOnAliasedColumnsAndExpressions() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SELECT count(*) AS this_is_aliased, 1 + 2 FROM nation").build();
        MaterializedResult actual = this.computeActual(session, "DESCRIBE OUTPUT my_query");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN}).row(new Object[]{"this_is_aliased", "", "", "", "bigint", 8, true}).row(new Object[]{"_col1", "", "", "", "integer", 4, false}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    @Test
    public void testDescribeOutputNoSuchQuery() {
        this.assertQueryFails("DESCRIBE OUTPUT my_query", "Prepared statement not found: my_query");
    }

    @Test
    public void testSubqueriesWithDisjunction() {
        List projections = QueryTemplate.parameter((String)"projection").of(new String[]{"count(*)", "*", "%condition%"});
        List conditions = QueryTemplate.parameter((String)"condition").of(new String[]{"nationkey IN (SELECT 1) OR TRUE", "EXISTS(SELECT 1) OR TRUE"});
        QueryTemplate.queryTemplate((String)"SELECT %projection% FROM nation WHERE %condition%", (QueryTemplate.Parameter[])new QueryTemplate.Parameter[0]).replaceAll(new List[]{projections, conditions}).forEach(this::assertQuery);
        QueryTemplate.queryTemplate((String)"SELECT %projection% FROM nation WHERE (%condition%) AND nationkey <3", (QueryTemplate.Parameter[])new QueryTemplate.Parameter[0]).replaceAll(new List[]{projections, conditions}).forEach(this::assertQuery);
        this.assertQuery("SELECT count(*) FROM nation WHERE (SELECT true FROM (SELECT 1) t(a) WHERE a = nationkey) OR TRUE", "SELECT 25");
        this.assertQuery("SELECT (SELECT true FROM (SELECT 1) t(a) WHERE a = nationkey) FROM nation WHERE (SELECT true FROM (SELECT 1) t(a) WHERE a = nationkey) OR TRUE ORDER BY nationkey LIMIT 2", "VALUES true, null");
    }

    @Test
    public void testAssignUniqueId() {
        String unionLineitem25Times = IntStream.range(0, 25).mapToObj(i -> "SELECT * FROM lineitem").collect(Collectors.joining(" UNION ALL "));
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM (   SELECT (SELECT count(*) WHERE c = 1)    FROM (SELECT CASE orderkey WHEN 1 THEN orderkey ELSE 1 END        FROM (" + unionLineitem25Times + ")) o(c)) result(a) WHERE a = 1)", "VALUES 1504375");
    }

    @Test
    public void testLateralJoin() {
        this.assertQuery("SELECT name FROM nation, LATERAL (SELECT 1 WHERE false)", "SELECT 1 WHERE false");
        this.assertQuery("SELECT name FROM nation, LATERAL (SELECT 1)", "SELECT name FROM nation");
        this.assertQuery("SELECT name FROM nation, LATERAL (SELECT 1 WHERE name = 'ola')", "SELECT 1 WHERE false");
        this.assertQuery("SELECT nationkey, a FROM nation, LATERAL (SELECT max(region.name) FROM region WHERE region.regionkey <= nation.regionkey) t(a) ORDER BY nationkey LIMIT 1", "VALUES (0, 'AFRICA')");
        this.assertQuery("SELECT nationkey, a FROM nation, LATERAL (SELECT region.name || '_' FROM region WHERE region.regionkey = nation.regionkey) t(a) ORDER BY nationkey LIMIT 1", "VALUES (0, 'AFRICA_')");
        this.assertQuery("SELECT nationkey, a, b, name FROM nation, LATERAL (SELECT nationkey + 2 AS a), LATERAL (SELECT a * -1 AS b) ORDER BY b LIMIT 1", "VALUES (24, 26, -26, 'UNITED STATES')");
        this.assertQuery("SELECT * FROM region r, LATERAL (SELECT * FROM nation) n WHERE n.regionkey = r.regionkey", "SELECT * FROM region, nation WHERE nation.regionkey = region.regionkey");
        this.assertQuery("SELECT * FROM region, LATERAL (SELECT * FROM nation WHERE nation.regionkey = region.regionkey)", "SELECT * FROM region, nation WHERE nation.regionkey = region.regionkey");
        this.assertQuery("SELECT quantity, extendedprice, avg_price, low, high FROM lineitem, LATERAL (SELECT extendedprice / quantity AS avg_price) average_price, LATERAL (SELECT avg_price * 0.9 AS low) lower_bound, LATERAL (SELECT avg_price * 1.1 AS high) upper_bound ORDER BY extendedprice, quantity LIMIT 1", "VALUES (1.0, 904.0, 904.0, 813.6, 994.400)");
        this.assertQuery("SELECT y FROM (VALUES array[2, 3]) a(x) CROSS JOIN LATERAL(SELECT x[1]) b(y)", "SELECT 2");
        this.assertQuery("SELECT * FROM (VALUES 2) a(x) CROSS JOIN LATERAL(SELECT x + 1)", "SELECT 2, 3");
        this.assertQuery("SELECT * FROM (VALUES 2) a(x) CROSS JOIN LATERAL(SELECT x)", "SELECT 2, 2");
        this.assertQuery("SELECT * FROM (VALUES 2) a(x) CROSS JOIN LATERAL(SELECT x, x + 1)", "SELECT 2, 2, 3");
        this.assertQueryFails("SELECT * FROM (VALUES array[2, 2]) a(x) LEFT OUTER JOIN LATERAL(VALUES x) ON true", "line .*: LATERAL on other than the right side of CROSS JOIN is not supported");
        this.assertQueryFails("SELECT * FROM (VALUES array[2, 2]) a(x) RIGHT OUTER JOIN LATERAL(VALUES x) ON true", "line .*: LATERAL on other than the right side of CROSS JOIN is not supported");
        this.assertQueryFails("SELECT * FROM (VALUES array[2, 2]) a(x) FULL OUTER JOIN LATERAL(VALUES x) ON true", "line .*: LATERAL on other than the right side of CROSS JOIN is not supported");
    }

    @Test
    public void testJoinsWithNulls() {
        Session sessionWithOptNulls = Session.builder((Session)this.getSession()).setSystemProperty("optimize_nulls_in_join", "true").build();
        this.testJoinsWithNullsInternal(this.getSession());
        this.testJoinsWithNullsInternal(sessionWithOptNulls);
    }

    private void testJoinsWithNullsInternal(Session session) {
        this.assertQuery(session, "SELECT * FROM (VALUES 2, 3, null) a(x) INNER JOIN (VALUES 3, 4, null) b(x) ON a.x = b.x", "SELECT * FROM VALUES (3, 3)");
        this.assertQuery(session, "SELECT * FROM (VALUES 2, 3, null) a(x) LEFT JOIN (VALUES 3, 4, null) b(x) ON a.x = b.x", "SELECT * FROM VALUES (3, 3), (2, NULL), (NULL, NULL)");
        this.assertQuery(session, "SELECT * FROM (VALUES 2, 3, null) a(x) RIGHT JOIN (VALUES 3, 4, null) b(x) ON a.x = b.x", "SELECT * FROM VALUES (3, 3), (NULL, 4), (NULL, NULL)");
        this.assertQuery(session, "SELECT * FROM (VALUES 2, 3, null) a(x) FULL OUTER JOIN (VALUES 3, 4, null) b(x) ON a.x = b.x", "SELECT * FROM VALUES (3, 3), (NULL, 4), (2, NULL), (NULL, NULL), (NULL, NULL)");
        this.assertQuery(session, "SELECT * FROM (VALUES 2, 3, null) a(x) FULL OUTER JOIN (VALUES 3, 4, null) b(x) ON a.x = b.x WHERE a.x IS NULL", "SELECT * FROM VALUES (NULL, 4), (NULL, NULL), (NULL, NULL)");
    }

    @Test
    public void testPruningCountAggregationOverScalar() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT SUM(orderkey) FROM orders)");
        this.assertQuery("SELECT COUNT(*) FROM (SELECT SUM(orderkey) FROM orders GROUP BY custkey)", "VALUES 1000");
        this.assertQuery("SELECT count(*) FROM (VALUES 2) t(a) GROUP BY a", "VALUES 1");
        this.assertQuery("SELECT a, count(*) FROM (VALUES 2) t(a) GROUP BY a", "VALUES (2, 1)");
        this.assertQuery("SELECT count(*) FROM (VALUES 2) t(a) GROUP BY a+1", "VALUES 1");
    }

    @Test
    public void testDefaultDecimalLiteralSwitch() {
        Session decimalLiteral = Session.builder((Session)this.getSession()).setSystemProperty("parse_decimal_literals_as_double", "false").build();
        MaterializedResult decimalColumnResult = this.computeActual(decimalLiteral, "SELECT 1.0");
        Assert.assertEquals((int)decimalColumnResult.getRowCount(), (int)1);
        Assert.assertEquals(decimalColumnResult.getTypes().get(0), (Object)DecimalType.createDecimalType((int)2, (int)1));
        Assert.assertEquals((Object)((MaterializedRow)decimalColumnResult.getMaterializedRows().get(0)).getField(0), (Object)new BigDecimal("1.0"));
        Session doubleLiteral = Session.builder((Session)this.getSession()).setSystemProperty("parse_decimal_literals_as_double", "true").build();
        MaterializedResult doubleColumnResult = this.computeActual(doubleLiteral, "SELECT 1.0");
        Assert.assertEquals((int)doubleColumnResult.getRowCount(), (int)1);
        Assert.assertEquals(doubleColumnResult.getTypes().get(0), (Object)DoubleType.DOUBLE);
        Assert.assertEquals((Object)((MaterializedRow)doubleColumnResult.getMaterializedRows().get(0)).getField(0), (Object)1.0);
    }

    @Test
    public void testInnerJoinWithEmptyBuildSide() {
        MaterializedResult actual = this.computeActual(this.noJoinReordering(), "WITH small_part AS (SELECT * FROM part WHERE name = 'a') SELECT lineitem.orderkey FROM lineitem INNER JOIN small_part ON lineitem.partkey = small_part.partkey");
        Assert.assertEquals((int)actual.getRowCount(), (int)0);
    }

    @Test
    public void testRightJoinWithEmptyBuildSide() {
        this.assertQuery(this.noJoinReordering(), "WITH small_part AS (SELECT * FROM part WHERE name = 'a') SELECT lineitem.orderkey FROM lineitem RIGHT JOIN small_part ON lineitem.partkey = small_part.partkey");
    }

    @Test
    public void testLeftJoinWithEmptyBuildSide() {
        this.assertQuery(this.noJoinReordering(), "WITH small_part AS (SELECT * FROM part WHERE name = 'a') SELECT lineitem.orderkey FROM lineitem LEFT JOIN small_part ON lineitem.partkey = small_part.partkey");
    }

    @Test
    public void testFullJoinWithEmptyBuildSide() {
        this.assertQuery(this.noJoinReordering(), "WITH small_part AS (SELECT * FROM part WHERE name = 'a') SELECT lineitem.orderkey FROM lineitem FULL OUTER JOIN small_part ON lineitem.partkey = small_part.partkey", "WITH small_part AS (SELECT * FROM part WHERE name = 'a') SELECT lineitem.orderkey FROM lineitem LEFT JOIN small_part ON lineitem.partkey = small_part.partkey");
    }

    @Test
    public void testInnerJoinWithEmptyProbeSide() {
        this.assertQuery(this.noJoinReordering(), "WITH small_part AS (SELECT * FROM part WHERE name = 'a') SELECT lineitem.orderkey FROM small_part INNER JOIN lineitem ON small_part.partkey = lineitem.partkey");
    }

    @Test
    public void testRightJoinWithEmptyProbeSide() {
        this.assertQuery(this.noJoinReordering(), "WITH small_part AS (SELECT * FROM part WHERE name = 'a') SELECT lineitem.orderkey FROM small_part RIGHT JOIN lineitem ON  small_part.partkey = lineitem.partkey");
    }

    @Test
    public void testLastValueIgnoreNulls() {
        this.assertQuery("WITH T AS (    SELECT        p,        v    FROM (        VALUES            (2, 2),            (1, 1),            (3, NULL)    ) T(p, v))SELECT    LAST_VALUE(v) IGNORE NULLS OVER (        PARTITION BY 1        ORDER BY            p ASC    )FROM T", "Values 1, 2, 2");
    }

    @Test
    public void testLargeBytecode() {
        StringBuilder stringBuilder = new StringBuilder("SELECT x FROM (SELECT orderkey x, custkey y from orders limit 10) WHERE CASE true ");
        for (int i = 0; i < 100; ++i) {
            stringBuilder.append(" when x in (");
            for (int j = 0; j < 20; ++j) {
                stringBuilder.append("random(" + (i * 100 + j) + "), ");
            }
            stringBuilder.append("random(" + i + ")) then x = random()");
        }
        stringBuilder.append("else x = random() end");
        this.assertQueryFails(stringBuilder.toString(), "Query results in large bytecode exceeding the limits imposed by JVM|Compiler failed");
    }

    @Test
    public void testInComplexTypes() {
        int i;
        StringBuilder query = new StringBuilder("select * from (values('a'), (null)) as t (name) where ROW('1', name) IN ( ");
        for (i = 2; i < 32; ++i) {
            query.append(String.format("ROW('1','%s'), ", i));
        }
        query.append("ROW('1', name), ROW('2',name), ROW('3',name))");
        this.assertQuerySucceeds(query.toString());
        query = new StringBuilder("select ROW(null_value) IN ( ");
        for (i = 0; i < 32; ++i) {
            query.append(String.format("ROW(%s), ", i));
        }
        query.append("ROW(32)) ");
        query.append("FROM (values(null)) as t (null_value)");
        this.assertQuery(query.toString(), "SELECT NULL");
    }

    @Test
    public void testRowExpressionInterpreterStackOverflow() {
        StringBuilder stringBuilder = new StringBuilder("SELECT  CASE");
        for (int i = 1; i <= 500; ++i) {
            stringBuilder.append(" when x = random(" + i + ") then " + i);
        }
        stringBuilder.append(" else x end from (select -1 x)");
        this.assertQuery(stringBuilder.toString(), "values -1");
    }

    @Test
    public void testSwitchOptimization() {
        this.assertQuery("select 1", "select 1");
        this.assertQuery("SELECT CASE WHEN x = 1 THEN 1 WHEN x = 5 THEN 5 WHEN x = IF(RANDOM() >= 0, 3, 5) THEN 10 ELSE -1 END FROM (SELECT ORDERKEY x FROM orders where orderkey <= 10)", "SELECT CASE x WHEN 1 THEN 1 WHEN 5 THEN 5 WHEN 3 THEN 10 ELSE -1 END FROM (SELECT ORDERKEY x FROM orders where orderkey <= 10)");
        this.assertQuery("SELECT CASE x WHEN 1 THEN 1 WHEN 5 THEN 5 WHEN 3 THEN 10 ELSE -1 END FROM (SELECT ORDERKEY x FROM orders where orderkey <= 10)", "SELECT CASE x WHEN 1 THEN 1 WHEN 5 THEN 5 WHEN 3 THEN 10 ELSE -1 END FROM (SELECT ORDERKEY x FROM orders where orderkey <= 10)");
    }

    @Test
    public void testSwitchReturnsNull() {
        this.assertQuery("SELECT CASE true WHEN random() < 0 THEN true END", "SELECT CAST(NULL AS BOOLEAN)");
        this.assertQuery("SELECT TRUE AND CAST(NULL AS BOOLEAN) AND RANDOM() >= 0", "SELECT CAST(NULL AS BOOLEAN)");
        this.assertQuery("SELECT TRUE AND CAST(NULL AS BOOLEAN) AND RANDOM() < 0", "SELECT FALSE");
        this.assertQuery("SELECT TRUE AND CAST(NULL AS BOOLEAN) IS NULL AND RANDOM() >= 0", "SELECT TRUE");
        this.assertQuery("SELECT 1 = ALL (SELECT CAST(NULL AS INTEGER))", "SELECT CAST(NULL AS BOOLEAN)");
    }

    @Test
    public void testAndInFilter() {
        this.assertQuery("SELECT count() from (select * from orders where orderkey < 10) where ((orderkey > 100 and custkey > 100) or (orderkey > 200 and custkey < 200))", "values 0");
        this.assertQuery("SELECT ((orderkey > 100 and custkey > 100) or (orderkey > 200 and custkey < 200)) from (select * from orders where orderkey < 10 limit 1)", "values false");
    }

    @Test
    public void testSetAgg() {
        String input = "(select 1 x, 2 y union all select 1 x, 2 y union all select 2 x, 1 y)";
        this.assertQuery("select count() from (select set_agg(x) = array_distinct(array_agg(x)) equals from (select 1 x, 2 y union all select 1 x, 2 y union all select 2 x, 1 y) group by y) where equals", "select count(distinct y) from (select 1 x, 2 y union all select 1 x, 2 y union all select 2 x, 1 y)");
        this.assertQuery("select count() from (select set_agg(orderkey) = array_agg(distinct orderkey) eq from orders group by custkey) where eq", "select count(distinct custkey) from orders");
        this.assertQuery("select cardinality(set_agg(orderkey)) from orders", "select count(distinct orderkey) from orders");
        this.assertQuery("select count() from (select set_agg(comment) = array_agg(distinct comment) eq from orders group by orderkey) where eq", "select count(distinct orderkey) from orders");
        this.assertQuery("select cardinality(set_agg(comment)) from orders", "select count(distinct comment) from orders");
        this.assertQuery("select count() from (select set_agg(cast(orderdate as date)) = array_agg(distinct cast(orderdate as date)) eq from orders group by orderkey) where eq", "select count(distinct orderkey) from orders");
        this.assertQuery("select cardinality(set_agg(cast(orderdate as date))) from orders", "select count(distinct orderdate) from orders");
    }

    @Test
    public void testRedundantProjection() {
        this.assertQuery("SELECT x, reduce(x, 0, (s, x) -> s + x, s -> s), reduce(x, 0, (s, x) -> s + x, s -> s) FROM (VALUES (array[1, 2, 3])) t(x)", "SELECT array[1, 2, 3], 6, 6");
        this.assertQuery("SELECT x, filter(x, v -> date(v) BETWEEN date'2020-01-01' AND date'2020-06-30'), filter(x, v -> date(v) BETWEEN date'2020-01-01' AND date_add('day', 2, date'2020-06-28')) FROM (VALUES (array['2020-03-01', '2020-07-01'])) t(x)", "SELECT array['2020-03-01', '2020-07-01'], array['2020-03-01'], array['2020-03-01']");
        this.assertQuerySucceeds("SELECT DISTINCT null AS a, NULL AS b, orderstatus FROM (SELECT orderstatus FROM orders GROUP BY orderstatus)");
    }

    @Test
    public void testComparisonWithLike() {
        this.assertQuery("SELECT t1.custkey, t2.comment FROM (SELECT * FROM orders WHERE (comment LIKE '%shipping_onsite%') = FALSE) t1 JOIN (SELECT * FROM orders WHERE (comment LIKE '%shipping_onsite%') = FALSE) t2 ON t1.orderkey=t2.orderkey");
    }

    @Test
    public void testSetUnion() {
        this.assertQuery("select set_union(x) from (values array[1, 2], array[3, 4], array[5, 6]) as t(x)", "select array[1, 2, 3, 4, 5, 6]");
        this.assertQuery("select set_union(x) from (values array[1, 2, 3], array[2, 3, 4], array[7, 8]) as t(x)", "select array[1, 2, 3, 4, 7, 8]");
        this.assertQuery("select group_id, set_union(numbers) from (values (1, array[1, 2]), (1, array[2, 3]), (2, array[4, 5]), (2, array[5, 6])) as t(group_id, numbers) group by group_id", "select group_id, numbers from (values (1, array[1, 2, 3]), (2, array[4, 5, 6])) as t(group_id, numbers)");
        this.assertQuery("select group_id, set_union(numbers) from (values (1, array[1, 2]), (2, array[2, 3]), (3, array[4, 5]), (4, array[5, 6])) as t(group_id, numbers) group by group_id", "select group_id, numbers from (values (1, array[1, 2]), (2, array[2, 3]), (3, array[4, 5]), (4, array[5, 6])) as t(group_id, numbers)");
        this.assertQuery("select set_union(x) from (values null, null, null) as t(x)", "select array[]");
        this.assertQuery("select set_union(x) from (values null, array[null], null) as t(x)", "select array[null]");
        this.assertQuery("select set_union(x) from (values array[1, 2, 3], array[null], null) as t(x)", "select array[1, 2, 3, null]");
        this.assertQuery("select set_union(x) from (values null, array[null], null) as t(x) where x != null", "select null");
    }

    @Test
    public void testMultipleSqlFunctionsWithLambda() {
        this.assertQuery("SELECT array_sum(zip_with(a, b, (x, y) -> x * y)), array_sum(zip_with(a, b, (x, y) -> x * y)) + array_sum(zip_with(a, a, (x, y) -> x * y)) FROM (VALUES (ARRAY[1, 2, 3], ARRAY[1, 0, 0])) t(a, b)", "SELECT 1, 15");
    }

    protected Session noJoinReordering() {
        return Session.builder((Session)this.getSession()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinReorderingStrategy.NONE.name()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).build();
    }
}

