/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;

public class StatefulSleepingSum
extends SqlScalarFunction {
    public static final StatefulSleepingSum STATEFUL_SLEEPING_SUM = new StatefulSleepingSum();

    private StatefulSleepingSum() {
        super(new Signature("stateful_sleeping_sum", FunctionKind.SCALAR, (List)ImmutableList.of((Object)Signature.typeVariable((String)"bigint")), (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"bigint"), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"double"), (Object)TypeSignature.parseTypeSignature((String)"bigint"), (Object)TypeSignature.parseTypeSignature((String)"bigint"), (Object)TypeSignature.parseTypeSignature((String)"bigint")), false));
    }

    public boolean isHidden() {
        return true;
    }

    public boolean isDeterministic() {
        return true;
    }

    public String getDescription() {
        return "testing not thread safe function";
    }

    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionManager functionManager) {
        int args = 4;
        return new ScalarFunctionImplementation(false, Collections.nCopies(args, ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementation.NullConvention)ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), Reflection.methodHandle(StatefulSleepingSum.class, (String)"statefulSleepingSum", (Class[])new Class[]{State.class, Double.TYPE, Long.TYPE, Long.TYPE, Long.TYPE}), Optional.of(Reflection.constructorMethodHandle(State.class, (Class[])new Class[0])));
    }

    public static long statefulSleepingSum(State state, double sleepProbability, long sleepDurationMillis, long a, long b) {
        int currentThreads = state.currentThreads.incrementAndGet();
        try {
            Preconditions.checkState((currentThreads == 1 ? 1 : 0) != 0, (String)"%s threads concurrently executing a stateful function", (int)currentThreads);
            if (ThreadLocalRandom.current().nextDouble() < sleepProbability) {
                Thread.sleep(sleepDurationMillis);
            }
            long l = a + b;
            return l;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted", e);
        }
        finally {
            state.currentThreads.decrementAndGet();
        }
    }

    public static class State {
        private final AtomicInteger currentThreads = new AtomicInteger();
    }
}

