/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.statistics;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TypeProvider;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public class StatsContext {
    private final Map<String, Symbol> columnSymbols;
    private final TypeProvider types;

    public StatsContext(Map<String, Symbol> columnSymbols, TypeProvider types) {
        this.columnSymbols = ImmutableMap.copyOf(columnSymbols);
        this.types = Objects.requireNonNull(types, "symbolTypes is null");
    }

    public Symbol getSymbolForColumn(String columnName) {
        Preconditions.checkArgument((boolean)this.columnSymbols.containsKey(columnName), (Object)("no symbol found for column '" + columnName + "'"));
        return this.columnSymbols.get(columnName);
    }

    public Type getTypeForSymbol(Symbol symbol) {
        return this.types.get(symbol);
    }
}

