/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.testing.TestingAccessControlManager;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.testing.assertions.Assert;
import com.facebook.presto.tests.AbstractTestQueries;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.facebook.presto.tests.DistributedQueryRunner;
import com.facebook.presto.tests.QueryAssertions;
import com.facebook.presto.tests.ResultWithQueryId;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.testing.Assertions;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.Test;

public abstract class AbstractTestDistributedQueries
extends AbstractTestQueries {
    protected AbstractTestDistributedQueries(AbstractTestQueryFramework.QueryRunnerSupplier supplier) {
        super(supplier);
    }

    protected boolean supportsViews() {
        return true;
    }

    @Test
    public void testSetSession() {
        MaterializedResult result = this.computeActual("SET SESSION test_string = 'bar'");
        org.testng.Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Map)result.getSetSessionProperties(), (Map)ImmutableMap.of((Object)"test_string", (Object)"bar"));
        result = this.computeActual(String.format("SET SESSION %s.connector_long = 999", "testing_catalog"));
        org.testng.Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Map)result.getSetSessionProperties(), (Map)ImmutableMap.of((Object)"testing_catalog.connector_long", (Object)"999"));
        result = this.computeActual(String.format("SET SESSION %s.connector_string = 'baz'", "testing_catalog"));
        org.testng.Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Map)result.getSetSessionProperties(), (Map)ImmutableMap.of((Object)"testing_catalog.connector_string", (Object)"baz"));
        result = this.computeActual(String.format("SET SESSION %s.connector_string = 'ban' || 'ana'", "testing_catalog"));
        org.testng.Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Map)result.getSetSessionProperties(), (Map)ImmutableMap.of((Object)"testing_catalog.connector_string", (Object)"banana"));
        result = this.computeActual(String.format("SET SESSION %s.connector_long = 444", "testing_catalog"));
        org.testng.Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Map)result.getSetSessionProperties(), (Map)ImmutableMap.of((Object)"testing_catalog.connector_long", (Object)"444"));
        result = this.computeActual(String.format("SET SESSION %s.connector_long = 111 + 111", "testing_catalog"));
        org.testng.Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Map)result.getSetSessionProperties(), (Map)ImmutableMap.of((Object)"testing_catalog.connector_long", (Object)"222"));
        result = this.computeActual(String.format("SET SESSION %s.connector_boolean = 111 < 3", "testing_catalog"));
        org.testng.Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Map)result.getSetSessionProperties(), (Map)ImmutableMap.of((Object)"testing_catalog.connector_boolean", (Object)"false"));
        result = this.computeActual(String.format("SET SESSION %s.connector_double = 11.1", "testing_catalog"));
        org.testng.Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Map)result.getSetSessionProperties(), (Map)ImmutableMap.of((Object)"testing_catalog.connector_double", (Object)"11.1"));
    }

    @Test
    public void testResetSession() {
        MaterializedResult result = this.computeActual(this.getSession(), "RESET SESSION test_string");
        org.testng.Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Set)result.getResetSessionProperties(), (Set)ImmutableSet.of((Object)"test_string"));
        result = this.computeActual(this.getSession(), String.format("RESET SESSION %s.connector_string", "testing_catalog"));
        org.testng.Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Set)result.getResetSessionProperties(), (Set)ImmutableSet.of((Object)"testing_catalog.connector_string"));
    }

    @Test
    public void testCreateTable() {
        this.assertUpdate("CREATE TABLE test_create (a bigint, b double, c varchar)");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_create"));
        this.assertTableColumnNames("test_create", "a", "b", "c");
        this.assertUpdate("DROP TABLE test_create");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_create"));
        this.assertQueryFails("CREATE TABLE test_create (a bad_type)", ".* Unknown type 'bad_type' for column 'a'");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_create"));
        this.assertUpdate("CREATE TABLE test_create_table_if_not_exists (a bigint, b varchar, c double)");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_create_table_if_not_exists"));
        this.assertTableColumnNames("test_create_table_if_not_exists", "a", "b", "c");
        this.assertUpdate("CREATE TABLE IF NOT EXISTS test_create_table_if_not_exists (d bigint, e varchar)");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_create_table_if_not_exists"));
        this.assertTableColumnNames("test_create_table_if_not_exists", "a", "b", "c");
        this.assertUpdate("DROP TABLE test_create_table_if_not_exists");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_create_table_if_not_exists"));
        this.assertUpdate("CREATE TABLE test_create_original (a bigint, b double, c varchar)");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_create_original"));
        this.assertTableColumnNames("test_create_original", "a", "b", "c");
        this.assertUpdate("CREATE TABLE test_create_like (LIKE test_create_original, d boolean, e varchar)");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_create_like"));
        this.assertTableColumnNames("test_create_like", "a", "b", "c", "d", "e");
        this.assertUpdate("DROP TABLE test_create_original");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_create_original"));
        this.assertUpdate("DROP TABLE test_create_like");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_create_like"));
    }

    @Test
    public void testCreateTableAsSelect() {
        this.assertUpdate("CREATE TABLE IF NOT EXISTS test_ctas AS SELECT name, regionkey FROM nation", "SELECT count(*) FROM nation");
        this.assertTableColumnNames("test_ctas", "name", "regionkey");
        this.assertUpdate("DROP TABLE test_ctas");
        this.assertUpdate("CREATE TABLE IF NOT EXISTS nation AS SELECT orderkey, discount FROM lineitem", 0L);
        this.assertTableColumnNames("nation", "nationkey", "name", "regionkey", "comment");
        this.assertCreateTableAsSelect("test_select", "SELECT orderdate, orderkey, totalprice FROM orders", "SELECT count(*) FROM orders");
        this.assertCreateTableAsSelect("test_group", "SELECT orderstatus, sum(totalprice) x FROM orders GROUP BY orderstatus", "SELECT count(DISTINCT orderstatus) FROM orders");
        this.assertCreateTableAsSelect("test_join", "SELECT count(*) x FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey", "SELECT 1");
        this.assertCreateTableAsSelect("test_limit", "SELECT orderkey FROM orders ORDER BY orderkey LIMIT 10", "SELECT 10");
        this.assertCreateTableAsSelect("test_unicode", "SELECT '\u2603' unicode", "SELECT 1");
        this.assertCreateTableAsSelect("test_with_data", "SELECT * FROM orders WITH DATA", "SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertCreateTableAsSelect("test_with_no_data", "SELECT * FROM orders WITH NO DATA", "SELECT * FROM orders LIMIT 0", "SELECT 0");
        this.assertCreateTableAsSelect("test_union_all", "SELECT orderdate, orderkey, totalprice FROM orders WHERE orderkey % 2 = 0 UNION ALL SELECT orderdate, orderkey, totalprice FROM orders WHERE orderkey % 2 = 1", "SELECT orderdate, orderkey, totalprice FROM orders", "SELECT count(*) FROM orders");
        this.assertCreateTableAsSelect(Session.builder((Session)this.getSession()).setSystemProperty("redistribute_writes", "true").build(), "test_union_all", "SELECT CAST(orderdate AS DATE) orderdate, orderkey, totalprice FROM orders UNION ALL SELECT DATE '2000-01-01', 1234567890, 1.23", "SELECT orderdate, orderkey, totalprice FROM orders UNION ALL SELECT DATE '2000-01-01', 1234567890, 1.23", "SELECT count(*) + 1 FROM orders");
        this.assertCreateTableAsSelect(Session.builder((Session)this.getSession()).setSystemProperty("redistribute_writes", "false").build(), "test_union_all", "SELECT CAST(orderdate AS DATE) orderdate, orderkey, totalprice FROM orders UNION ALL SELECT DATE '2000-01-01', 1234567890, 1.23", "SELECT orderdate, orderkey, totalprice FROM orders UNION ALL SELECT DATE '2000-01-01', 1234567890, 1.23", "SELECT count(*) + 1 FROM orders");
        this.assertExplainAnalyze("EXPLAIN ANALYZE CREATE TABLE analyze_test AS SELECT orderstatus FROM orders");
        this.assertQuery("SELECT * from analyze_test", "SELECT orderstatus FROM orders");
        this.assertUpdate("DROP TABLE analyze_test");
    }

    @Test
    public void testExplainAnalyze() {
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT * FROM orders");
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT count(*), clerk FROM orders GROUP BY clerk");
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT x + y FROM (   SELECT orderdate, COUNT(*) x FROM orders GROUP BY orderdate) a JOIN (   SELECT orderdate, COUNT(*) y FROM orders GROUP BY orderdate) b ON a.orderdate = b.orderdate");
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT *, o2.custkey\n  IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE orderkey % 5 = 0)\nFROM (SELECT * FROM orders WHERE custkey % 256 = 0) o1\nJOIN (SELECT * FROM orders WHERE custkey % 256 = 0) o2\n  ON (o1.orderkey IN (SELECT orderkey FROM lineitem WHERE orderkey % 4 = 0)) = (o2.orderkey IN (SELECT orderkey FROM lineitem WHERE orderkey % 4 = 0))\nWHERE o1.orderkey\n  IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE orderkey % 4 = 0)\nORDER BY o1.orderkey\n  IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE orderkey % 7 = 0)");
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT count(*), clerk FROM orders GROUP BY clerk UNION ALL SELECT sum(orderkey), clerk FROM orders GROUP BY clerk");
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW COLUMNS FROM orders");
        this.assertExplainAnalyze("EXPLAIN ANALYZE EXPLAIN SELECT count(*) FROM orders");
        this.assertExplainAnalyze("EXPLAIN ANALYZE EXPLAIN ANALYZE SELECT count(*) FROM orders");
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW FUNCTIONS");
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW TABLES");
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW SCHEMAS");
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW CATALOGS");
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW SESSION");
    }

    @Test
    public void testExplainAnalyzeVerbose() {
        this.assertExplainAnalyze("EXPLAIN ANALYZE VERBOSE SELECT * FROM orders");
        this.assertExplainAnalyze("EXPLAIN ANALYZE VERBOSE SELECT rank() OVER (PARTITION BY orderkey ORDER BY clerk DESC) FROM orders");
        this.assertExplainAnalyze("EXPLAIN ANALYZE VERBOSE SELECT rank() OVER (PARTITION BY orderkey ORDER BY clerk DESC) FROM orders WHERE orderkey < 0");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="EXPLAIN ANALYZE doesn't support statement type: DropTable")
    public void testExplainAnalyzeDDL() {
        this.computeActual("EXPLAIN ANALYZE DROP TABLE orders");
    }

    private void assertExplainAnalyze(@Language(value="SQL") String query) {
        String value = (String)this.computeActual(query).getOnlyValue();
        org.testng.Assert.assertTrue((boolean)value.matches("(?s:.*)CPU:.*, Input:.*, Output(?s:.*)"), (String)String.format("Expected output to contain \"CPU:.*, Input:.*, Output\", but it is %s", value));
    }

    protected void assertCreateTableAsSelect(String table, @Language(value="SQL") String query, @Language(value="SQL") String rowCountQuery) {
        this.assertCreateTableAsSelect(this.getSession(), table, query, query, rowCountQuery);
    }

    protected void assertCreateTableAsSelect(String table, @Language(value="SQL") String query, @Language(value="SQL") String expectedQuery, @Language(value="SQL") String rowCountQuery) {
        this.assertCreateTableAsSelect(this.getSession(), table, query, expectedQuery, rowCountQuery);
    }

    protected void assertCreateTableAsSelect(Session session, String table, @Language(value="SQL") String query, @Language(value="SQL") String expectedQuery, @Language(value="SQL") String rowCountQuery) {
        this.assertUpdate(session, "CREATE TABLE " + table + " AS " + query, rowCountQuery);
        this.assertQuery(session, "SELECT * FROM " + table, expectedQuery);
        this.assertUpdate(session, "DROP TABLE " + table);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, table));
    }

    @Test
    public void testRenameTable() {
        this.assertUpdate("CREATE TABLE test_rename AS SELECT 123 x", 1L);
        this.assertUpdate("ALTER TABLE test_rename RENAME TO test_rename_new");
        MaterializedResult materializedRows = this.computeActual("SELECT x FROM test_rename_new");
        Assert.assertEquals((Object)((MaterializedRow)Iterables.getOnlyElement((Iterable)materializedRows.getMaterializedRows())).getField(0), (Object)123);
        this.assertUpdate("ALTER TABLE test_rename_new RENAME TO TEST_RENAME");
        materializedRows = this.computeActual("SELECT x FROM test_rename");
        Assert.assertEquals((Object)((MaterializedRow)Iterables.getOnlyElement((Iterable)materializedRows.getMaterializedRows())).getField(0), (Object)123);
        this.assertUpdate("DROP TABLE test_rename");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_rename"));
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_rename_new"));
    }

    @Test
    public void testRenameColumn() {
        this.assertUpdate("CREATE TABLE test_rename_column AS SELECT 123 x", 1L);
        this.assertUpdate("ALTER TABLE test_rename_column RENAME COLUMN x TO y");
        MaterializedResult materializedRows = this.computeActual("SELECT y FROM test_rename_column");
        Assert.assertEquals((Object)((MaterializedRow)Iterables.getOnlyElement((Iterable)materializedRows.getMaterializedRows())).getField(0), (Object)123);
        this.assertUpdate("ALTER TABLE test_rename_column RENAME COLUMN y TO Z");
        materializedRows = this.computeActual("SELECT z FROM test_rename_column");
        Assert.assertEquals((Object)((MaterializedRow)Iterables.getOnlyElement((Iterable)materializedRows.getMaterializedRows())).getField(0), (Object)123);
        this.assertUpdate("DROP TABLE test_rename_column");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_rename_column"));
    }

    @Test
    public void testDropColumn() {
        this.assertUpdate("CREATE TABLE test_drop_column AS SELECT 123 x, 111 a", 1L);
        this.assertUpdate("ALTER TABLE test_drop_column DROP COLUMN x");
        this.assertQueryFails("SELECT x FROM test_drop_column", ".* Column 'x' cannot be resolved");
        this.assertQueryFails("ALTER TABLE test_drop_column DROP COLUMN a", ".* Cannot drop the only column in a table");
    }

    @Test
    public void testAddColumn() {
        this.assertUpdate("CREATE TABLE test_add_column AS SELECT 123 x", 1L);
        this.assertUpdate("CREATE TABLE test_add_column_a AS SELECT 234 x, 111 a", 1L);
        this.assertUpdate("CREATE TABLE test_add_column_ab AS SELECT 345 x, 222 a, 33.3E0 b", 1L);
        this.assertQueryFails("ALTER TABLE test_add_column ADD COLUMN x bigint", ".* Column 'x' already exists");
        this.assertQueryFails("ALTER TABLE test_add_column ADD COLUMN X bigint", ".* Column 'X' already exists");
        this.assertQueryFails("ALTER TABLE test_add_column ADD COLUMN q bad_type", ".* Unknown type 'bad_type' for column 'q'");
        this.assertUpdate("ALTER TABLE test_add_column ADD COLUMN a bigint");
        this.assertUpdate("INSERT INTO test_add_column SELECT * FROM test_add_column_a", 1L);
        MaterializedResult materializedRows = this.computeActual("SELECT x, a FROM test_add_column ORDER BY x");
        Assert.assertEquals((Object)((MaterializedRow)materializedRows.getMaterializedRows().get(0)).getField(0), (Object)123);
        Assert.assertEquals((Object)((MaterializedRow)materializedRows.getMaterializedRows().get(0)).getField(1), null);
        Assert.assertEquals((Object)((MaterializedRow)materializedRows.getMaterializedRows().get(1)).getField(0), (Object)234);
        Assert.assertEquals((Object)((MaterializedRow)materializedRows.getMaterializedRows().get(1)).getField(1), (Object)111L);
        this.assertUpdate("ALTER TABLE test_add_column ADD COLUMN b double");
        this.assertUpdate("INSERT INTO test_add_column SELECT * FROM test_add_column_ab", 1L);
        materializedRows = this.computeActual("SELECT x, a, b FROM test_add_column ORDER BY x");
        Assert.assertEquals((Object)((MaterializedRow)materializedRows.getMaterializedRows().get(0)).getField(0), (Object)123);
        Assert.assertEquals((Object)((MaterializedRow)materializedRows.getMaterializedRows().get(0)).getField(1), null);
        Assert.assertEquals((Object)((MaterializedRow)materializedRows.getMaterializedRows().get(0)).getField(2), null);
        Assert.assertEquals((Object)((MaterializedRow)materializedRows.getMaterializedRows().get(1)).getField(0), (Object)234);
        Assert.assertEquals((Object)((MaterializedRow)materializedRows.getMaterializedRows().get(1)).getField(1), (Object)111L);
        Assert.assertEquals((Object)((MaterializedRow)materializedRows.getMaterializedRows().get(1)).getField(2), null);
        Assert.assertEquals((Object)((MaterializedRow)materializedRows.getMaterializedRows().get(2)).getField(0), (Object)345);
        Assert.assertEquals((Object)((MaterializedRow)materializedRows.getMaterializedRows().get(2)).getField(1), (Object)222L);
        Assert.assertEquals((Object)((MaterializedRow)materializedRows.getMaterializedRows().get(2)).getField(2), (Object)33.3);
        this.assertUpdate("DROP TABLE test_add_column");
        this.assertUpdate("DROP TABLE test_add_column_a");
        this.assertUpdate("DROP TABLE test_add_column_ab");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_add_column"));
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_add_column_a"));
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_add_column_ab"));
    }

    @Test
    public void testInsert() {
        String query = "SELECT orderdate, orderkey, totalprice FROM orders";
        this.assertUpdate("CREATE TABLE test_insert AS " + query + " WITH NO DATA", 0L);
        this.assertQuery("SELECT count(*) FROM test_insert", "SELECT 0");
        this.assertUpdate("INSERT INTO test_insert " + query, "SELECT count(*) FROM orders");
        this.assertQuery("SELECT * FROM test_insert", query);
        this.assertUpdate("INSERT INTO test_insert (orderkey) VALUES (-1)", 1L);
        this.assertUpdate("INSERT INTO test_insert (orderkey) VALUES (null)", 1L);
        this.assertUpdate("INSERT INTO test_insert (orderdate) VALUES (DATE '2001-01-01')", 1L);
        this.assertUpdate("INSERT INTO test_insert (orderkey, orderdate) VALUES (-2, DATE '2001-01-02')", 1L);
        this.assertUpdate("INSERT INTO test_insert (orderdate, orderkey) VALUES (DATE '2001-01-03', -3)", 1L);
        this.assertUpdate("INSERT INTO test_insert (totalprice) VALUES (1234)", 1L);
        this.assertQuery("SELECT * FROM test_insert", query + " UNION ALL SELECT null, -1, null UNION ALL SELECT null, null, null UNION ALL SELECT DATE '2001-01-01', null, null UNION ALL SELECT DATE '2001-01-02', -2, null UNION ALL SELECT DATE '2001-01-03', -3, null UNION ALL SELECT null, null, 1234");
        this.assertUpdate("INSERT INTO test_insert (orderkey, orderdate, totalprice) SELECT orderkey, orderdate, totalprice FROM orders UNION ALL SELECT orderkey, orderdate, totalprice FROM orders", "SELECT 2 * count(*) FROM orders");
        this.assertUpdate("DROP TABLE test_insert");
        this.assertUpdate("CREATE TABLE test_insert (a ARRAY<DOUBLE>, b ARRAY<BIGINT>)");
        this.assertUpdate("INSERT INTO test_insert (a) VALUES (ARRAY[null])", 1L);
        this.assertUpdate("INSERT INTO test_insert (a) VALUES (ARRAY[1234])", 1L);
        this.assertQuery("SELECT a[1] FROM test_insert", "VALUES (null), (1234)");
        this.assertQueryFails("INSERT INTO test_insert (b) VALUES (ARRAY[1.23E1])", "Insert query has mismatched column types: .*");
        this.assertUpdate("DROP TABLE test_insert");
    }

    @Test
    public void testDelete() {
        this.assertUpdate("CREATE TABLE test_delete AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertUpdate("DELETE FROM test_delete WHERE orderkey % 2 = 0", "SELECT count(*) FROM orders WHERE orderkey % 2 = 0");
        this.assertQuery("SELECT * FROM test_delete", "SELECT * FROM orders WHERE orderkey % 2 <> 0");
        this.assertUpdate("DELETE FROM test_delete", "SELECT count(*) FROM orders WHERE orderkey % 2 <> 0");
        this.assertQuery("SELECT * FROM test_delete", "SELECT * FROM orders LIMIT 0");
        this.assertUpdate("DROP TABLE test_delete");
        this.assertUpdate("CREATE TABLE test_delete AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertUpdate("DELETE FROM test_delete WHERE custkey <= 100", "SELECT count(*) FROM orders WHERE custkey <= 100");
        this.assertQuery("SELECT * FROM test_delete", "SELECT * FROM orders WHERE custkey > 100");
        this.assertUpdate("DELETE FROM test_delete WHERE custkey <= 300", "SELECT count(*) FROM orders WHERE custkey > 100 AND custkey <= 300");
        this.assertQuery("SELECT * FROM test_delete", "SELECT * FROM orders WHERE custkey > 300");
        this.assertUpdate("DELETE FROM test_delete WHERE custkey <= 500", "SELECT count(*) FROM orders WHERE custkey > 300 AND custkey <= 500");
        this.assertQuery("SELECT * FROM test_delete", "SELECT * FROM orders WHERE custkey > 500");
        this.assertUpdate("DROP TABLE test_delete");
        this.assertUpdate("CREATE TABLE test_delete AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertUpdate("DELETE FROM test_delete WHERE orderstatus = 'O'", "SELECT count(*) FROM orders WHERE orderstatus = 'O'");
        this.assertQuery("SELECT * FROM test_delete", "SELECT * FROM orders WHERE orderstatus <> 'O'");
        this.assertUpdate("DROP TABLE test_delete");
        this.assertUpdate("CREATE TABLE test_delete AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertUpdate("DELETE FROM test_delete WHERE rand() < 0", 0L);
        this.assertUpdate("DELETE FROM test_delete WHERE orderkey < 0", 0L);
        this.assertUpdate("DROP TABLE test_delete");
        this.assertUpdate("CREATE TABLE test_delete AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertUpdate("DELETE FROM test_delete WHERE orderkey > 5 AND orderkey < 4", 0L);
        this.assertUpdate("DROP TABLE test_delete");
        this.assertUpdate("CREATE TABLE test_delete AS SELECT * FROM lineitem", "SELECT count(*) FROM lineitem");
        this.assertUpdate("DELETE FROM test_delete WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderstatus = 'F')", "SELECT count(*) FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderstatus = 'F')");
        this.assertQuery("SELECT * FROM test_delete", "SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderstatus <> 'F')");
        this.assertUpdate("DROP TABLE test_delete");
        this.assertUpdate("CREATE TABLE test_delete AS SELECT * FROM lineitem", "SELECT count(*) FROM lineitem");
        this.assertUpdate("DELETE FROM test_delete\nWHERE orderkey IN (SELECT orderkey FROM orders WHERE orderstatus = 'F')\n  AND orderkey IN (SELECT orderkey FROM orders WHERE custkey % 5 = 0)\n", "SELECT count(*) FROM lineitem\nWHERE orderkey IN (SELECT orderkey FROM orders WHERE orderstatus = 'F')\n  AND orderkey IN (SELECT orderkey FROM orders WHERE custkey % 5 = 0)");
        this.assertQuery("SELECT * FROM test_delete", "SELECT * FROM lineitem\nWHERE orderkey IN (SELECT orderkey FROM orders WHERE orderstatus <> 'F')\n  OR orderkey IN (SELECT orderkey FROM orders WHERE custkey % 5 <> 0)");
        this.assertUpdate("DROP TABLE test_delete");
        this.assertUpdate("CREATE TABLE test_delete AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertUpdate("DELETE FROM test_delete\nWHERE (orderkey IN (SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END FROM lineitem)) IS NULL\n", "SELECT count(*) FROM orders\nWHERE (orderkey IN (SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END FROM lineitem)) IS NULL\n");
        this.assertQuery("SELECT * FROM test_delete", "SELECT * FROM orders\nWHERE (orderkey IN (SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END FROM lineitem)) IS NOT NULL\n");
        this.assertUpdate("DROP TABLE test_delete");
        this.assertUpdate("CREATE TABLE test_delete AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertUpdate("DELETE FROM test_delete WHERE orderkey = (SELECT orderkey FROM orders ORDER BY orderkey LIMIT 1)", 1L);
        this.assertUpdate("DELETE FROM test_delete WHERE orderkey = (SELECT orderkey FROM orders WHERE false)", 0L);
        this.assertUpdate("DELETE FROM test_delete WHERE EXISTS(SELECT 1 WHERE false)", 0L);
        this.assertUpdate("DELETE FROM test_delete WHERE EXISTS(SELECT 1)", "SELECT count(*) - 1 FROM orders");
        this.assertUpdate("DROP TABLE test_delete");
        this.assertExplainAnalyze("EXPLAIN ANALYZE CREATE TABLE analyze_test AS SELECT CAST(orderstatus AS VARCHAR(15)) orderstatus FROM orders");
        this.assertQuery("SELECT * from analyze_test", "SELECT orderstatus FROM orders");
        this.assertExplainAnalyze("EXPLAIN ANALYZE INSERT INTO analyze_test SELECT clerk FROM orders");
        this.assertQuery("SELECT * from analyze_test", "SELECT orderstatus FROM orders UNION ALL SELECT clerk FROM orders");
        this.assertExplainAnalyze("EXPLAIN ANALYZE DELETE FROM analyze_test WHERE TRUE");
        this.assertQuery("SELECT COUNT(*) from analyze_test", "SELECT 0");
        this.assertUpdate("DROP TABLE analyze_test");
        this.assertUpdate("CREATE TABLE test_delete AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertAccessDenied("DELETE FROM test_delete where orderkey < 12", "Cannot select from columns \\[orderkey\\] in table or view .*.test_delete.*", TestingAccessControlManager.privilege((String)"orderkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessAllowed("DELETE FROM test_delete where orderkey < 12", TestingAccessControlManager.privilege((String)"orderdate", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessAllowed("DELETE FROM test_delete", TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
    }

    @Test
    public void testDropTableIfExists() {
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_drop_if_exists"));
        this.assertUpdate("DROP TABLE IF EXISTS test_drop_if_exists");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_drop_if_exists"));
    }

    @Test
    public void testView() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsViews());
        String query = "SELECT orderkey, orderstatus, totalprice / 2 half FROM orders";
        this.assertUpdate("CREATE VIEW test_view AS SELECT 123 x");
        this.assertUpdate("CREATE OR REPLACE VIEW test_view AS " + query);
        this.assertQuery("SELECT * FROM test_view", query);
        this.assertQuery("SELECT * FROM test_view a JOIN test_view b on a.orderkey = b.orderkey", String.format("SELECT * FROM (%s) a JOIN (%s) b ON a.orderkey = b.orderkey", query, query));
        this.assertQuery("WITH orders AS (SELECT * FROM orders LIMIT 0) SELECT * FROM test_view", query);
        String name = String.format("%s.%s.test_view", this.getSession().getCatalog().get(), this.getSession().getSchema().get());
        this.assertQuery("SELECT * FROM " + name, query);
        this.assertUpdate("DROP VIEW test_view");
    }

    @Test
    public void testViewCaseSensitivity() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsViews());
        this.computeActual("CREATE VIEW test_view_uppercase AS SELECT X FROM (SELECT 123 X)");
        this.computeActual("CREATE VIEW test_view_mixedcase AS SELECT XyZ FROM (SELECT 456 XyZ)");
        this.assertQuery("SELECT * FROM test_view_uppercase", "SELECT X FROM (SELECT 123 X)");
        this.assertQuery("SELECT * FROM test_view_mixedcase", "SELECT XyZ FROM (SELECT 456 XyZ)");
    }

    @Test
    public void testCompatibleTypeChangeForView() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsViews());
        this.assertUpdate("CREATE TABLE test_table_1 AS SELECT 'abcdefg' a", 1L);
        this.assertUpdate("CREATE VIEW test_view_1 AS SELECT a FROM test_table_1");
        this.assertQuery("SELECT * FROM test_view_1", "VALUES 'abcdefg'");
        this.assertUpdate("DROP TABLE test_table_1");
        this.assertUpdate("CREATE TABLE test_table_1 AS SELECT 'abc' a", 1L);
        this.assertQuery("SELECT * FROM test_view_1", "VALUES 'abc'");
        this.assertUpdate("DROP VIEW test_view_1");
        this.assertUpdate("DROP TABLE test_table_1");
    }

    @Test
    public void testCompatibleTypeChangeForView2() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsViews());
        this.assertUpdate("CREATE TABLE test_table_2 AS SELECT BIGINT '1' v", 1L);
        this.assertUpdate("CREATE VIEW test_view_2 AS SELECT * FROM test_table_2");
        this.assertQuery("SELECT * FROM test_view_2", "VALUES 1");
        this.assertUpdate("DROP TABLE test_table_2");
        this.assertUpdate("CREATE TABLE test_table_2 AS SELECT INTEGER '1' v", 1L);
        this.assertQuery("SELECT * FROM test_view_2 WHERE v = 1", "VALUES 1");
        this.assertUpdate("DROP VIEW test_view_2");
        this.assertUpdate("DROP TABLE test_table_2");
    }

    @Test
    public void testViewMetadata() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsViews());
        String query = "SELECT BIGINT '123' x, 'foo' y";
        this.assertUpdate("CREATE VIEW meta_test_view AS " + query);
        MaterializedResult actual = this.computeActual(String.format("SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = '%s'", this.getSession().getSchema().get()));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"customer", "BASE TABLE"}).row(new Object[]{"lineitem", "BASE TABLE"}).row(new Object[]{"meta_test_view", "VIEW"}).row(new Object[]{"nation", "BASE TABLE"}).row(new Object[]{"orders", "BASE TABLE"}).row(new Object[]{"part", "BASE TABLE"}).row(new Object[]{"partsupp", "BASE TABLE"}).row(new Object[]{"region", "BASE TABLE"}).row(new Object[]{"supplier", "BASE TABLE"}).build();
        QueryAssertions.assertContains(actual, expected);
        actual = this.computeActual("SHOW TABLES");
        MaterializedResult.Builder builder = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes());
        for (MaterializedRow row : expected.getMaterializedRows()) {
            builder.row(new Object[]{row.getField(0)});
        }
        expected = builder.build();
        QueryAssertions.assertContains(actual, expected);
        actual = this.computeActual(String.format("SELECT table_name, view_definition FROM information_schema.views WHERE table_schema = '%s'", this.getSession().getSchema().get()));
        expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"meta_test_view", this.formatSqlText(query)}).build();
        QueryAssertions.assertContains(actual, expected);
        actual = this.computeActual("SHOW COLUMNS FROM meta_test_view");
        expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"x", "bigint", "", ""}).row(new Object[]{"y", "varchar(3)", "", ""}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
        String expectedSql = this.formatSqlText(String.format("CREATE VIEW %s.%s.%s AS %s", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), "meta_test_view", query)).trim();
        actual = this.computeActual("SHOW CREATE VIEW meta_test_view");
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)actual.getOnlyColumnAsSet()), (Object)expectedSql);
        this.assertUpdate("DROP VIEW meta_test_view");
    }

    @Test
    public void testQueryLoggingCount() {
        QueryManager queryManager = ((DistributedQueryRunner)this.getQueryRunner()).getCoordinator().getQueryManager();
        this.executeExclusively(() -> {
            AbstractTestDistributedQueries.assertUntilTimeout(() -> Assert.assertEquals((Collection)queryManager.getAllQueryInfo().stream().filter(info -> !info.isFinalQueryInfo()).collect(Collectors.toList()), (Collection)ImmutableList.of()), new Duration(1.0, TimeUnit.MINUTES));
            long beforeCompletedQueriesCount = this.waitUntilStable(() -> queryManager.getStats().getCompletedQueries().getTotalCount(), new Duration(5.0, TimeUnit.SECONDS));
            long beforeSubmittedQueriesCount = queryManager.getStats().getSubmittedQueries().getTotalCount();
            this.assertUpdate("CREATE TABLE test_query_logging_count AS SELECT 1 foo_1, 2 foo_2_4", 1L);
            this.assertQuery("SELECT foo_1, foo_2_4 FROM test_query_logging_count", "SELECT 1, 2");
            this.assertUpdate("DROP TABLE test_query_logging_count");
            this.assertQueryFails("SELECT * FROM test_query_logging_count", ".*Table .* does not exist");
            AbstractTestDistributedQueries.assertUntilTimeout(() -> Assert.assertEquals((long)(queryManager.getStats().getCompletedQueries().getTotalCount() - beforeCompletedQueriesCount), (long)4L), new Duration(1.0, TimeUnit.MINUTES));
            Assert.assertEquals((long)(queryManager.getStats().getSubmittedQueries().getTotalCount() - beforeSubmittedQueriesCount), (long)4L);
        });
    }

    private <T> T waitUntilStable(Supplier<T> computation, Duration timeout) {
        T lastValue = computation.get();
        long start = System.nanoTime();
        while (!Thread.currentThread().isInterrupted() && Duration.nanosSince((long)start).compareTo(timeout) < 0) {
            Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            T currentValue = computation.get();
            if (currentValue.equals(lastValue)) {
                return currentValue;
            }
            lastValue = currentValue;
        }
        throw new UncheckedTimeoutException();
    }

    private static void assertUntilTimeout(Runnable assertion, Duration timeout) {
        long start = System.nanoTime();
        while (!Thread.currentThread().isInterrupted()) {
            try {
                assertion.run();
                return;
            }
            catch (AssertionError e) {
                if (Duration.nanosSince((long)start).compareTo(timeout) > 0) {
                    throw e;
                }
                Uninterruptibles.sleepUninterruptibly((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }
    }

    @Test
    public void testLargeQuerySuccess() {
        this.assertQuery("SELECT " + Joiner.on((String)" AND ").join(Collections.nCopies(500, "1 = 1")), "SELECT true");
    }

    @Test
    public void testShowSchemasFromOther() {
        MaterializedResult result = this.computeActual("SHOW SCHEMAS FROM tpch");
        org.testng.Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll((Collection<?>)ImmutableSet.of((Object)"information_schema", (Object)"tiny", (Object)"sf1")));
    }

    @Test
    public void testTableSampleSystemBoundaryValues() {
        MaterializedResult fullSample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE SYSTEM (100)");
        MaterializedResult emptySample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE SYSTEM (0)");
        MaterializedResult all = this.computeActual("SELECT orderkey FROM orders");
        QueryAssertions.assertContains(all, fullSample);
        Assert.assertEquals((int)emptySample.getMaterializedRows().size(), (int)0);
    }

    @Test
    public void testSymbolAliasing() {
        this.assertUpdate("CREATE TABLE test_symbol_aliasing AS SELECT 1 foo_1, 2 foo_2_4", 1L);
        this.assertQuery("SELECT foo_1, foo_2_4 FROM test_symbol_aliasing", "SELECT 1, 2");
        this.assertUpdate("DROP TABLE test_symbol_aliasing");
    }

    @Test
    public void testNonQueryAccessControl() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsViews());
        this.assertAccessDenied("SET SESSION query_max_memory = '10MB'", "Cannot set system session property query_max_memory", TestingAccessControlManager.privilege((String)"query_max_memory", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SET_SESSION));
        this.assertAccessDenied("CREATE TABLE foo (pk bigint)", "Cannot create table .*.foo.*", TestingAccessControlManager.privilege((String)"foo", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_TABLE));
        this.assertAccessDenied("DROP TABLE orders", "Cannot drop table .*.orders.*", TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.DROP_TABLE));
        this.assertAccessDenied("ALTER TABLE orders RENAME TO foo", "Cannot rename table .*.orders.* to .*.foo.*", TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.RENAME_TABLE));
        this.assertAccessDenied("ALTER TABLE orders ADD COLUMN foo bigint", "Cannot add a column to table .*.orders.*", TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.ADD_COLUMN));
        this.assertAccessDenied("ALTER TABLE orders DROP COLUMN foo", "Cannot drop a column from table .*.orders.*", TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.DROP_COLUMN));
        this.assertAccessDenied("ALTER TABLE orders RENAME COLUMN orderkey TO foo", "Cannot rename a column in table .*.orders.*", TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.RENAME_COLUMN));
        this.assertAccessDenied("CREATE VIEW foo as SELECT * FROM orders", "Cannot create view .*.foo.*", TestingAccessControlManager.privilege((String)"foo", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW));
        try {
            this.assertAccessDenied("SELECT 1", "Principal .* cannot become user " + this.getSession().getUser() + ".*", TestingAccessControlManager.privilege((String)this.getSession().getUser(), (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SET_USER));
        }
        catch (AssertionError e) {
            Assertions.assertContains((String)((Throwable)((Object)e)).getMessage(), (String)"statusCode=403");
        }
    }

    @Test
    public void testViewAccessControl() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsViews());
        Session viewOwnerSession = TestingSession.testSessionBuilder().setIdentity(new Identity("test_view_access_owner", Optional.empty())).setCatalog((String)this.getSession().getCatalog().get()).setSchema((String)this.getSession().getSchema().get()).build();
        this.assertAccessAllowed(viewOwnerSession, "CREATE VIEW test_view_access AS SELECT * FROM orders", TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS));
        this.assertAccessDenied("SELECT * FROM test_view_access", "View owner 'test_view_access_owner' cannot create view that selects from .*.orders.*", TestingAccessControlManager.privilege((String)viewOwnerSession.getUser(), (String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS));
        this.assertAccessAllowed(viewOwnerSession, "SELECT * FROM test_view_access", TestingAccessControlManager.privilege((String)viewOwnerSession.getUser(), (String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS));
        this.assertAccessAllowed("SELECT * FROM test_view_access", TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS));
        this.assertAccessAllowed("SELECT * FROM test_view_access", TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        Session nestedViewOwnerSession = TestingSession.testSessionBuilder().setIdentity(new Identity("test_nested_view_access_owner", Optional.empty())).setCatalog((String)this.getSession().getCatalog().get()).setSchema((String)this.getSession().getSchema().get()).build();
        this.assertAccessAllowed(nestedViewOwnerSession, "CREATE VIEW test_nested_view_access AS SELECT * FROM test_view_access", TestingAccessControlManager.privilege((String)"test_view_access", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS));
        this.assertAccessDenied("SELECT * FROM test_nested_view_access", "View owner 'test_nested_view_access_owner' cannot create view that selects from .*.test_view_access.*", TestingAccessControlManager.privilege((String)nestedViewOwnerSession.getUser(), (String)"test_view_access", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS));
        this.assertAccessAllowed("SELECT * FROM test_nested_view_access", TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)"test_view_access", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS));
        this.assertAccessAllowed("SELECT * FROM test_nested_view_access", TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)"test_view_access", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessDenied("SELECT * FROM test_view_access", "View owner 'test_view_access_owner' cannot create view that selects from .*.orders.*", TestingAccessControlManager.privilege((String)viewOwnerSession.getUser(), (String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_TABLE));
        this.assertAccessAllowed(viewOwnerSession, "SELECT * FROM test_view_access", TestingAccessControlManager.privilege((String)viewOwnerSession.getUser(), (String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_TABLE));
        this.assertAccessAllowed("SELECT * FROM test_view_access", TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_TABLE));
        this.assertAccessAllowed("SELECT * FROM test_view_access", TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_TABLE));
        this.assertAccessDenied("SELECT * FROM test_nested_view_access", "View owner 'test_nested_view_access_owner' cannot create view that selects from .*.test_view_access.*", TestingAccessControlManager.privilege((String)nestedViewOwnerSession.getUser(), (String)"test_view_access", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_VIEW));
        this.assertAccessAllowed("SELECT * FROM test_nested_view_access", TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)"test_view_access", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_VIEW));
        this.assertAccessAllowed("SELECT * FROM test_nested_view_access", TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)"test_view_access", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_VIEW));
        this.assertAccessAllowed(nestedViewOwnerSession, "DROP VIEW test_nested_view_access", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessAllowed(viewOwnerSession, "DROP VIEW test_view_access", new TestingAccessControlManager.TestingPrivilege[0]);
    }

    @Override
    @Test
    public void testJoinWithStatefulFilterFunction() {
        super.testJoinWithStatefulFilterFunction();
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("distributed_join", "true").build();
        long joinOutputRowCount = 60175L;
        this.assertQuery(session, String.format("SELECT count(*) FROM lineitem l LEFT OUTER JOIN orders o ON l.orderkey = o.orderkey AND stateful_sleeping_sum(%s, 100, l.linenumber, o.shippriority) > 0", 10.0 / (double)joinOutputRowCount), String.format("VALUES %s", joinOutputRowCount));
    }

    @Test
    public void testWrittenStats() {
        String sql = "CREATE TABLE test_written_stats AS SELECT * FROM nation";
        DistributedQueryRunner distributedQueryRunner = (DistributedQueryRunner)this.getQueryRunner();
        ResultWithQueryId<MaterializedResult> resultResultWithQueryId = distributedQueryRunner.executeWithQueryId(this.getSession(), sql);
        QueryInfo queryInfo = distributedQueryRunner.getQueryInfo(resultResultWithQueryId.getQueryId());
        Assert.assertEquals((long)queryInfo.getQueryStats().getOutputPositions(), (long)1L);
        Assert.assertEquals((long)queryInfo.getQueryStats().getWrittenPositions(), (long)25L);
        org.testng.Assert.assertTrue((queryInfo.getQueryStats().getLogicalWrittenDataSize().toBytes() > 0L ? 1 : 0) != 0);
        sql = "INSERT INTO test_written_stats SELECT * FROM nation LIMIT 10";
        resultResultWithQueryId = distributedQueryRunner.executeWithQueryId(this.getSession(), sql);
        queryInfo = distributedQueryRunner.getQueryInfo(resultResultWithQueryId.getQueryId());
        Assert.assertEquals((long)queryInfo.getQueryStats().getOutputPositions(), (long)1L);
        Assert.assertEquals((long)queryInfo.getQueryStats().getWrittenPositions(), (long)10L);
        org.testng.Assert.assertTrue((queryInfo.getQueryStats().getLogicalWrittenDataSize().toBytes() > 0L ? 1 : 0) != 0);
        this.assertUpdate("DROP TABLE test_written_stats");
    }

    @Test
    public void testComplexCast() {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("optimize_mixed_distinct_aggregations", "true").build();
        this.assertQuery(session, "WITH t(a, b) AS (VALUES (1, INTERVAL '1' SECOND)) SELECT count(DISTINCT a), CAST(max(b) AS VARCHAR) FROM t", "VALUES (1, '0 00:00:01.000')");
    }
}

