/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.statistics;

import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.SymbolStatsEstimate;
import com.facebook.presto.tests.statistics.Metric;
import com.facebook.presto.tests.statistics.StatsContext;
import java.util.Optional;
import java.util.OptionalDouble;

public final class Metrics {
    public static final Metric OUTPUT_ROW_COUNT = new Metric(){

        @Override
        public OptionalDouble getValueFromPlanNodeEstimate(PlanNodeStatsEstimate planNodeStatsEstimate, StatsContext statsContext) {
            return Metrics.asOptional(planNodeStatsEstimate.getOutputRowCount());
        }

        @Override
        public OptionalDouble getValueFromAggregationQueryResult(Object value) {
            return OptionalDouble.of(((Number)value).doubleValue());
        }

        @Override
        public String getComputingAggregationSql() {
            return "count(*)";
        }

        public String toString() {
            return "OUTPUT_ROW_COUNT";
        }
    };

    private Metrics() {
    }

    public static Metric nullsFraction(final String columnName) {
        return new Metric(){

            @Override
            public OptionalDouble getValueFromPlanNodeEstimate(PlanNodeStatsEstimate planNodeStatsEstimate, StatsContext statsContext) {
                return Metrics.asOptional(Metrics.getSymbolStatistics(planNodeStatsEstimate, columnName, statsContext).getNullsFraction());
            }

            @Override
            public OptionalDouble getValueFromAggregationQueryResult(Object value) {
                return OptionalDouble.of(((Number)value).doubleValue());
            }

            @Override
            public String getComputingAggregationSql() {
                return "(count(*) filter(where " + columnName + " is null)) / cast(count(*) as double)";
            }

            public String toString() {
                return "NULLS_FRACTION(" + columnName + ")";
            }
        };
    }

    public static Metric distinctValuesCount(final String columnName) {
        return new Metric(){

            @Override
            public OptionalDouble getValueFromPlanNodeEstimate(PlanNodeStatsEstimate planNodeStatsEstimate, StatsContext statsContext) {
                return Metrics.asOptional(Metrics.getSymbolStatistics(planNodeStatsEstimate, columnName, statsContext).getDistinctValuesCount());
            }

            @Override
            public OptionalDouble getValueFromAggregationQueryResult(Object value) {
                return OptionalDouble.of(((Number)value).doubleValue());
            }

            @Override
            public String getComputingAggregationSql() {
                return "count(distinct " + columnName + ")";
            }

            public String toString() {
                return "DISTINCT_VALUES_COUNT(" + columnName + ")";
            }
        };
    }

    public static Metric lowValue(final String columnName) {
        return new Metric(){

            @Override
            public OptionalDouble getValueFromPlanNodeEstimate(PlanNodeStatsEstimate planNodeStatsEstimate, StatsContext statsContext) {
                double lowValue = Metrics.getSymbolStatistics(planNodeStatsEstimate, columnName, statsContext).getLowValue();
                if (Double.isInfinite(lowValue)) {
                    return OptionalDouble.empty();
                }
                return OptionalDouble.of(lowValue);
            }

            @Override
            public OptionalDouble getValueFromAggregationQueryResult(Object value) {
                return Optional.ofNullable(value).map(Number.class::cast).map(Number::doubleValue).map(OptionalDouble::of).orElseGet(OptionalDouble::empty);
            }

            @Override
            public String getComputingAggregationSql() {
                return "try_cast(min(" + columnName + ") as double)";
            }

            public String toString() {
                return "LOW_VALUE(" + columnName + ")";
            }
        };
    }

    public static Metric highValue(final String columnName) {
        return new Metric(){

            @Override
            public OptionalDouble getValueFromPlanNodeEstimate(PlanNodeStatsEstimate planNodeStatsEstimate, StatsContext statsContext) {
                double highValue = Metrics.getSymbolStatistics(planNodeStatsEstimate, columnName, statsContext).getHighValue();
                if (Double.isInfinite(highValue)) {
                    return OptionalDouble.empty();
                }
                return OptionalDouble.of(highValue);
            }

            @Override
            public OptionalDouble getValueFromAggregationQueryResult(Object value) {
                return Optional.ofNullable(value).map(Number.class::cast).map(Number::doubleValue).map(OptionalDouble::of).orElseGet(OptionalDouble::empty);
            }

            @Override
            public String getComputingAggregationSql() {
                return "max(try_cast(" + columnName + " as double))";
            }

            public String toString() {
                return "HIGH_VALUE(" + columnName + ")";
            }
        };
    }

    private static SymbolStatsEstimate getSymbolStatistics(PlanNodeStatsEstimate planNodeStatsEstimate, String columnName, StatsContext statsContext) {
        return planNodeStatsEstimate.getSymbolStatistics(statsContext.getSymbolForColumn(columnName));
    }

    private static OptionalDouble asOptional(double value) {
        return Double.isNaN(value) ? OptionalDouble.empty() : OptionalDouble.of(value);
    }
}

