/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.planner.LogicalPlanner;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.planPrinter.PlanPrinter;
import com.facebook.presto.testing.LocalQueryRunner;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.testng.Assert;

public class PlanDeterminismChecker {
    private static final int MINIMUM_SUBSEQUENT_SAME_PLANS = 10;
    private final LocalQueryRunner localQueryRunner;
    private final Function<String, String> planEquivalenceFunction;

    public PlanDeterminismChecker(LocalQueryRunner localQueryRunner) {
        this(localQueryRunner, Function.identity());
    }

    public PlanDeterminismChecker(LocalQueryRunner localQueryRunner, Function<String, String> planEquivalenceFunction) {
        this.localQueryRunner = localQueryRunner;
        this.planEquivalenceFunction = planEquivalenceFunction;
    }

    public void checkPlanIsDeterministic(String sql) {
        this.checkPlanIsDeterministic(this.localQueryRunner.getDefaultSession(), sql);
    }

    public void checkPlanIsDeterministic(Session session, String sql) {
        IntStream.range(1, 10).mapToObj(attempt -> this.getPlanText(session, sql)).map(this.planEquivalenceFunction).reduce((previous, current) -> {
            Assert.assertEquals((String)previous, (String)current);
            return current;
        });
    }

    private String getPlanText(Session session, String sql) {
        return (String)this.localQueryRunner.inTransaction(session, transactionSession -> {
            Plan plan = this.localQueryRunner.createPlan(transactionSession, sql, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED);
            return PlanPrinter.textLogicalPlan((PlanNode)plan.getRoot(), (Map)plan.getTypes(), (Metadata)this.localQueryRunner.getMetadata(), (StatsCalculator)this.localQueryRunner.getStatsCalculator(), (CostCalculator)this.localQueryRunner.getCostCalculator(), (Session)transactionSession);
        });
    }
}

