/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.facebook.presto.tests.QueryAssertions;
import com.google.common.collect.ImmutableList;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AbstractTestIntegrationSmokeTest
extends AbstractTestQueryFramework {
    protected AbstractTestIntegrationSmokeTest(AbstractTestQueryFramework.QueryRunnerSupplier supplier) {
        super(supplier);
    }

    @Test
    public void testAggregateSingleColumn() throws Exception {
        this.assertQuery("SELECT SUM(orderkey) FROM ORDERS");
        this.assertQuery("SELECT SUM(totalprice) FROM ORDERS");
        this.assertQuery("SELECT MAX(comment) FROM ORDERS");
    }

    @Test
    public void testColumnsInReverseOrder() throws Exception {
        this.assertQuery("SELECT shippriority, clerk, totalprice FROM ORDERS");
    }

    @Test
    public void testCountAll() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM ORDERS");
    }

    @Test
    public void testExactPredicate() throws Exception {
        this.assertQuery("SELECT * FROM ORDERS WHERE orderkey = 10");
    }

    @Test
    public void testInListPredicate() throws Exception {
        this.assertQuery("SELECT * FROM ORDERS WHERE orderkey IN (10, 11, 20, 21)");
    }

    @Test
    public void testIsNullPredicate() throws Exception {
        this.assertQuery("SELECT * FROM ORDERS WHERE orderkey = 10 OR orderkey IS NULL");
    }

    @Test
    public void testMultipleRangesPredicate() throws Exception {
        this.assertQuery("SELECT * FROM ORDERS WHERE orderkey BETWEEN 10 AND 50 or orderkey BETWEEN 100 AND 150");
    }

    @Test
    public void testRangePredicate() throws Exception {
        this.assertQuery("SELECT * FROM ORDERS WHERE orderkey BETWEEN 10 AND 50");
    }

    @Test
    public void testSelectAll() throws Exception {
        this.assertQuery("SELECT * FROM ORDERS");
    }

    @Test
    public void testShowSchemas() throws Exception {
        MaterializedResult actualSchemas = this.computeActual("SHOW SCHEMAS").toTestTypes();
        MaterializedResult.Builder resultBuilder = MaterializedResult.resultBuilder((Session)this.getQueryRunner().getDefaultSession(), (Type[])new Type[]{VarcharType.VARCHAR}).row(new Object[]{this.getQueryRunner().getDefaultSession().getSchema().orElse("tpch")});
        QueryAssertions.assertContains(actualSchemas, resultBuilder.build());
    }

    @Test
    public void testShowTables() throws Exception {
        MaterializedResult actualTables = this.computeActual("SHOW TABLES").toTestTypes();
        MaterializedResult expectedTables = MaterializedResult.resultBuilder((Session)this.getQueryRunner().getDefaultSession(), (Type[])new Type[]{VarcharType.VARCHAR}).row(new Object[]{"orders"}).build();
        QueryAssertions.assertContains(actualTables, expectedTables);
    }

    @Test
    public void testDescribeTable() throws Exception {
        MaterializedResult actualColumns = this.computeActual("DESC ORDERS").toTestTypes();
        ImmutableList expectedColumnsPossibilities = ImmutableList.of((Object)this.getExpectedTableDescription(true, true), (Object)this.getExpectedTableDescription(true, false), (Object)this.getExpectedTableDescription(false, true), (Object)this.getExpectedTableDescription(false, false));
        Assert.assertTrue((boolean)expectedColumnsPossibilities.contains(actualColumns), (String)String.format("%s not in %s", actualColumns, expectedColumnsPossibilities));
    }

    @Test
    public void testDuplicatedRowCreateTable() {
        this.assertQueryFails("CREATE TABLE test (a integer, a integer)", "line 1:31: Column name 'a' specified more than once");
        this.assertQueryFails("CREATE TABLE test (a integer, orderkey integer, LIKE orders INCLUDING PROPERTIES)", "line 1:49: Column name 'orderkey' specified more than once");
        this.assertQueryFails("CREATE TABLE test (a integer, A integer)", "line 1:31: Column name 'A' specified more than once");
        this.assertQueryFails("CREATE TABLE test (a integer, OrderKey integer, LIKE orders INCLUDING PROPERTIES)", "line 1:49: Column name 'orderkey' specified more than once");
    }

    private MaterializedResult getExpectedTableDescription(boolean dateSupported, boolean parametrizedVarchar) {
        String orderDateType = dateSupported ? "date" : "varchar";
        if (parametrizedVarchar) {
            return MaterializedResult.resultBuilder((Session)this.getQueryRunner().getDefaultSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", "", ""}).row(new Object[]{"custkey", "bigint", "", ""}).row(new Object[]{"orderstatus", "varchar", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", orderDateType, "", ""}).row(new Object[]{"orderpriority", "varchar", "", ""}).row(new Object[]{"clerk", "varchar", "", ""}).row(new Object[]{"shippriority", "integer", "", ""}).row(new Object[]{"comment", "varchar", "", ""}).build();
        }
        return MaterializedResult.resultBuilder((Session)this.getQueryRunner().getDefaultSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", "", ""}).row(new Object[]{"custkey", "bigint", "", ""}).row(new Object[]{"orderstatus", "varchar(1)", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", orderDateType, "", ""}).row(new Object[]{"orderpriority", "varchar(15)", "", ""}).row(new Object[]{"clerk", "varchar(15)", "", ""}).row(new Object[]{"shippriority", "integer", "", ""}).row(new Object[]{"comment", "varchar(79)", "", ""}).build();
    }
}

