/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.statistics;

import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.tests.statistics.Metric;
import java.util.Optional;

public class MetricComparison {
    private final PlanNode planNode;
    private final Metric metric;
    private final Optional<Double> estimatedCost;
    private final Optional<Double> executionCost;
    private final double tolerance;

    public MetricComparison(PlanNode planNode, Metric metric, Optional<Double> estimatedCost, Optional<Double> executionCost, double tolerance) {
        this.planNode = planNode;
        this.metric = metric;
        this.estimatedCost = estimatedCost;
        this.executionCost = executionCost;
        this.tolerance = tolerance;
    }

    public Metric getMetric() {
        return this.metric;
    }

    public PlanNode getPlanNode() {
        return this.planNode;
    }

    public String toString() {
        return String.format("Metric [%s] - [%s] - estimated: [%s], real: [%s] - plan node: [%s]", new Object[]{this.metric, this.result(), this.print(this.estimatedCost), this.print(this.executionCost), this.planNode});
    }

    public Result result() {
        return this.estimatedCost.map(estimate -> this.executionCost.map(execution -> this.estimateMatchesReality((double)estimate, (double)execution) ? Result.MATCH : Result.DIFFER).orElse(Result.NO_BASELINE)).orElse(Result.NO_ESTIMATE);
    }

    private String print(Optional<Double> cost) {
        return cost.map(Object::toString).orElse("UNKNOWN");
    }

    private boolean estimateMatchesReality(double estimate, double execution) {
        return Math.abs(execution - estimate) / execution < this.tolerance;
    }

    public static enum Result {
        NO_ESTIMATE,
        NO_BASELINE,
        DIFFER,
        MATCH;

    }
}

