/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.statistics;

import com.facebook.presto.cost.PlanNodeCost;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.spi.statistics.Estimate;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.planPrinter.PlanNodeStats;
import com.facebook.presto.sql.planner.planPrinter.PlanNodeStatsSummarizer;
import com.facebook.presto.tests.statistics.Metric;
import com.facebook.presto.tests.statistics.MetricComparison;
import com.facebook.presto.util.MoreMaps;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MetricComparator {
    private final List<Metric> metrics = Arrays.asList(Metric.values());
    private final double tolerance = 0.1;

    public List<MetricComparison> getMetricComparisons(Plan queryPlan, StageInfo outputStageInfo) {
        return this.metrics.stream().flatMap(metric -> {
            Map estimates = queryPlan.getPlanNodeCosts();
            Map<PlanNodeId, PlanNodeCost> actuals = this.extractActualCosts(outputStageInfo);
            return estimates.entrySet().stream().map(entry -> {
                PlanNode node = this.planNodeForId(queryPlan, (PlanNodeId)entry.getKey());
                PlanNodeCost estimate = (PlanNodeCost)entry.getValue();
                Optional<PlanNodeCost> execution = Optional.ofNullable(actuals.get(node.getId()));
                return this.createMetricComparison((Metric)((Object)metric), node, estimate, execution);
            });
        }).collect(Collectors.toList());
    }

    private PlanNode planNodeForId(Plan queryPlan, PlanNodeId id) {
        return PlanNodeSearcher.searchFrom((PlanNode)queryPlan.getRoot()).where(node -> node.getId().equals((Object)id)).findOnlyElement();
    }

    private Map<PlanNodeId, PlanNodeCost> extractActualCosts(StageInfo outputStageInfo) {
        Stream<Map<PlanNodeId, PlanNodeStats>> stagesStatsStream = StageInfo.getAllStages(Optional.of(outputStageInfo)).stream().map(PlanNodeStatsSummarizer::aggregatePlanNodeStats);
        Map<PlanNodeId, PlanNodeStats> mergedStats = this.mergeStats(stagesStatsStream);
        return Maps.transformValues(mergedStats, this::toPlanNodeCost);
    }

    private Map<PlanNodeId, PlanNodeStats> mergeStats(Stream<Map<PlanNodeId, PlanNodeStats>> stagesStatsStream) {
        BinaryOperator allowNoDuplicates = (a, b) -> {
            throw new IllegalArgumentException("PlanNodeIds must be unique");
        };
        return MoreMaps.mergeMaps(stagesStatsStream, (BinaryOperator)allowNoDuplicates);
    }

    private PlanNodeCost toPlanNodeCost(PlanNodeStats operatorStats) {
        return PlanNodeCost.builder().setOutputRowCount(new Estimate((double)operatorStats.getPlanNodeOutputPositions())).setOutputSizeInBytes(new Estimate((double)operatorStats.getPlanNodeOutputDataSize().toBytes())).build();
    }

    private MetricComparison createMetricComparison(Metric metric, PlanNode node, PlanNodeCost estimate, Optional<PlanNodeCost> execution) {
        Optional<Double> estimatedCost = this.asOptional(metric.getValue(estimate));
        Optional<Double> executionCost = execution.flatMap(e -> this.asOptional(metric.getValue((PlanNodeCost)e)));
        return new MetricComparison(node, metric, estimatedCost, executionCost, 0.1);
    }

    private Optional<Double> asOptional(Estimate estimate) {
        return estimate.isValueUnknown() ? Optional.empty() : Optional.of(estimate.getValue());
    }
}

