/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.statistics;

import com.facebook.presto.cost.PlanNodeCost;
import com.facebook.presto.spi.statistics.Estimate;
import java.util.function.Function;

public enum Metric {
    OUTPUT_ROW_COUNT(PlanNodeCost::getOutputRowCount),
    OUTPUT_SIZE_BYTES(PlanNodeCost::getOutputSizeInBytes);

    private final Function<PlanNodeCost, Estimate> extractor;

    private Metric(Function<PlanNodeCost, Estimate> extractor) {
        this.extractor = extractor;
    }

    Estimate getValue(PlanNodeCost cost) {
        return this.extractor.apply(cost);
    }
}

