/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.tpch;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorIndexHandle;
import com.facebook.presto.spi.ConnectorResolvedIndex;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.tests.tpch.TpchIndexHandle;
import com.facebook.presto.tests.tpch.TpchIndexProvider;
import com.facebook.presto.tests.tpch.TpchIndexedData;
import com.facebook.presto.tpch.TpchMetadata;
import com.facebook.presto.tpch.TpchTableHandle;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class TpchIndexMetadata
extends TpchMetadata {
    private final TpchIndexedData indexedData;

    public TpchIndexMetadata(String connectorId, TpchIndexedData indexedData) {
        super(connectorId);
        this.indexedData = Objects.requireNonNull(indexedData, "indexedData is null");
    }

    public Optional<ConnectorResolvedIndex> resolveIndex(ConnectorSession session, ConnectorTableHandle tableHandle, Set<ColumnHandle> indexableColumns, Set<ColumnHandle> outputColumns, TupleDomain<ColumnHandle> tupleDomain) {
        TpchTableHandle tpchTableHandle = (TpchTableHandle)tableHandle;
        Map<ColumnHandle, NullableValue> fixedValues = ((Map)TupleDomain.extractFixedValues(tupleDomain).orElse(ImmutableMap.of())).entrySet().stream().filter(entry -> !indexableColumns.contains(entry.getKey())).filter(entry -> !((NullableValue)entry.getValue()).isNull()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ImmutableSet lookupColumnNames = ImmutableSet.builder().addAll(TpchIndexProvider.handleToNames((List<ColumnHandle>)ImmutableList.copyOf(indexableColumns))).addAll(TpchIndexProvider.handleToNames((List<ColumnHandle>)ImmutableList.copyOf(fixedValues.keySet()))).build();
        if (!this.indexedData.getIndexedTable(tpchTableHandle.getTableName(), tpchTableHandle.getScaleFactor(), (Set<String>)lookupColumnNames).isPresent()) {
            return Optional.empty();
        }
        TupleDomain filteredTupleDomain = tupleDomain;
        if (!tupleDomain.isNone()) {
            filteredTupleDomain = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)((Map)tupleDomain.getDomains().get()), (Predicate)Predicates.not((Predicate)Predicates.in(fixedValues.keySet()))));
        }
        TpchIndexHandle indexHandle = new TpchIndexHandle(tpchTableHandle.getTableName(), tpchTableHandle.getScaleFactor(), (Set<String>)lookupColumnNames, (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues(fixedValues));
        return Optional.of(new ConnectorResolvedIndex((ConnectorIndexHandle)indexHandle, filteredTupleDomain));
    }
}

