/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.discovery.client.DiscoveryModule;
import io.airlift.discovery.server.DiscoveryServerModule;
import io.airlift.http.server.testing.TestingHttpServer;
import io.airlift.http.server.testing.TestingHttpServerModule;
import io.airlift.jaxrs.JaxrsModule;
import io.airlift.jmx.testing.TestingJmxModule;
import io.airlift.json.JsonModule;
import io.airlift.node.testing.TestingNodeModule;
import io.airlift.testing.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.net.URI;
import java.util.Map;
import org.weakref.jmx.guice.MBeanModule;

public class TestingDiscoveryServer
implements Closeable {
    private final LifeCycleManager lifeCycleManager;
    private final TestingHttpServer server;
    private final File tempDir = Files.createTempDir();

    public TestingDiscoveryServer(String environment) throws Exception {
        ImmutableMap serverProperties = ImmutableMap.builder().put((Object)"static.db.location", (Object)this.tempDir.getAbsolutePath()).put((Object)"discovery.store-cache-ttl", (Object)"0ms").build();
        Bootstrap app = new Bootstrap(new Module[]{new MBeanModule(), new TestingNodeModule(environment), new TestingHttpServerModule(), new JsonModule(), new JaxrsModule(true), new DiscoveryServerModule(), new DiscoveryModule(), new TestingJmxModule()});
        Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties((Map)serverProperties).quiet().initialize();
        this.lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        this.server = (TestingHttpServer)injector.getInstance(TestingHttpServer.class);
    }

    public URI getBaseUrl() {
        return this.server.getBaseUrl();
    }

    @Override
    public void close() {
        try {
            if (this.lifeCycleManager != null) {
                this.lifeCycleManager.stop();
            }
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
        finally {
            FileUtils.deleteRecursively((File)this.tempDir);
        }
    }
}

