/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.metadata.AllNodes;
import com.facebook.presto.metadata.Catalog;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.server.testing.TestingPrestoServer;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.testing.TestingAccessControlManager;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tests.AbstractTestQueries;
import com.facebook.presto.tests.ResultWithQueryId;
import com.facebook.presto.tests.TestingDiscoveryServer;
import com.facebook.presto.tests.TestingPrestoClient;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.Closer;
import io.airlift.log.Logger;
import io.airlift.testing.Assertions;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.intellij.lang.annotations.Language;

public class DistributedQueryRunner
implements QueryRunner {
    private static final Logger log = Logger.get(DistributedQueryRunner.class);
    private static final String ENVIRONMENT = "testing";
    private final TestingDiscoveryServer discoveryServer;
    private final TestingPrestoServer coordinator;
    private final List<TestingPrestoServer> servers;
    private final Closer closer = Closer.create();
    private final TestingPrestoClient prestoClient;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public DistributedQueryRunner(Session defaultSession, int workersCount) throws Exception {
        this(defaultSession, workersCount, (Map<String, String>)ImmutableMap.of());
    }

    public DistributedQueryRunner(Session defaultSession, int workersCount, Map<String, String> extraProperties) throws Exception {
        this(defaultSession, workersCount, extraProperties, (Map<String, String>)ImmutableMap.of(), new SqlParserOptions());
    }

    public DistributedQueryRunner(Session defaultSession, int workersCount, Map<String, String> extraProperties, Map<String, String> coordinatorProperties, SqlParserOptions parserOptions) throws Exception {
        long start;
        Objects.requireNonNull(defaultSession, "defaultSession is null");
        try {
            start = System.nanoTime();
            this.discoveryServer = (TestingDiscoveryServer)this.closer.register((Closeable)new TestingDiscoveryServer(ENVIRONMENT));
            log.info("Created TestingDiscoveryServer in %s", new Object[]{Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
            ImmutableList.Builder servers = ImmutableList.builder();
            for (int i = 1; i < workersCount; ++i) {
                TestingPrestoServer worker = (TestingPrestoServer)this.closer.register((Closeable)DistributedQueryRunner.createTestingPrestoServer(this.discoveryServer.getBaseUrl(), false, extraProperties, parserOptions));
                servers.add((Object)worker);
            }
            ImmutableMap extraCoordinatorProperties = ImmutableMap.builder().put((Object)"optimizer.optimize-mixed-distinct-aggregations", (Object)"true").put((Object)"experimental.iterative-optimizer-enabled", (Object)"true").putAll(extraProperties).putAll(coordinatorProperties).build();
            this.coordinator = (TestingPrestoServer)this.closer.register((Closeable)DistributedQueryRunner.createTestingPrestoServer(this.discoveryServer.getBaseUrl(), true, (Map<String, String>)extraCoordinatorProperties, parserOptions));
            servers.add((Object)this.coordinator);
            this.servers = servers.build();
        }
        catch (Exception e) {
            try {
                throw this.closer.rethrow((Throwable)e, Exception.class);
            }
            catch (Throwable throwable) {
                this.closer.close();
                throw throwable;
            }
        }
        defaultSession = defaultSession.toSessionRepresentation().toSession(this.coordinator.getMetadata().getSessionPropertyManager());
        this.prestoClient = (TestingPrestoClient)this.closer.register((Closeable)new TestingPrestoClient(this.coordinator, defaultSession));
        start = System.nanoTime();
        while (!this.allNodesGloballyVisible()) {
            Assertions.assertLessThan((Comparable)Duration.nanosSince((long)start), (Comparable)new Duration(10.0, TimeUnit.SECONDS));
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        log.info("Announced servers in %s", new Object[]{Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
        start = System.nanoTime();
        for (TestingPrestoServer server : this.servers) {
            server.getMetadata().addFunctions(AbstractTestQueries.CUSTOM_FUNCTIONS);
        }
        log.info("Added functions in %s", new Object[]{Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
        for (TestingPrestoServer server : this.servers) {
            Catalog bogusTestingCatalog = TestingSession.createBogusTestingCatalog((String)"testing_catalog");
            server.getCatalogManager().registerCatalog(bogusTestingCatalog);
            SessionPropertyManager sessionPropertyManager = server.getMetadata().getSessionPropertyManager();
            sessionPropertyManager.addSystemSessionProperties(AbstractTestQueries.TEST_SYSTEM_PROPERTIES);
            sessionPropertyManager.addConnectorSessionProperties(bogusTestingCatalog.getConnectorId(), AbstractTestQueries.TEST_CATALOG_PROPERTIES);
        }
    }

    private static TestingPrestoServer createTestingPrestoServer(URI discoveryUri, boolean coordinator, Map<String, String> extraProperties, SqlParserOptions parserOptions) throws Exception {
        long start = System.nanoTime();
        ImmutableMap.Builder propertiesBuilder = ImmutableMap.builder().put((Object)"query.client.timeout", (Object)"10m").put((Object)"exchange.http-client.idle-timeout", (Object)"1h").put((Object)"compiler.interpreter-enabled", (Object)"false").put((Object)"task.max-index-memory", (Object)"16kB").put((Object)"datasources", (Object)"system").put((Object)"distributed-index-joins-enabled", (Object)"true").put((Object)"optimizer.optimize-mixed-distinct-aggregations", (Object)"true");
        if (coordinator) {
            propertiesBuilder.put((Object)"node-scheduler.include-coordinator", (Object)"true");
            propertiesBuilder.put((Object)"distributed-joins-enabled", (Object)"true");
        }
        HashMap<String, String> properties = new HashMap<String, String>((Map<String, String>)propertiesBuilder.build());
        properties.putAll(extraProperties);
        TestingPrestoServer server = new TestingPrestoServer(coordinator, properties, ENVIRONMENT, discoveryUri, parserOptions, (List)ImmutableList.of());
        log.info("Created TestingPrestoServer in %s", new Object[]{Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
        return server;
    }

    private boolean allNodesGloballyVisible() {
        for (TestingPrestoServer server : this.servers) {
            AllNodes allNodes = server.refreshNodes();
            if (allNodes.getInactiveNodes().isEmpty() && allNodes.getActiveNodes().size() == this.servers.size()) continue;
            return false;
        }
        return true;
    }

    public TestingPrestoClient getClient() {
        return this.prestoClient;
    }

    public int getNodeCount() {
        return this.servers.size();
    }

    public Session getDefaultSession() {
        return this.prestoClient.getDefaultSession();
    }

    public TransactionManager getTransactionManager() {
        return this.coordinator.getTransactionManager();
    }

    public Metadata getMetadata() {
        return this.coordinator.getMetadata();
    }

    public CostCalculator getCostCalculator() {
        return this.coordinator.getCostCalculator();
    }

    public TestingAccessControlManager getAccessControl() {
        return this.coordinator.getAccessControl();
    }

    public TestingPrestoServer getCoordinator() {
        return this.coordinator;
    }

    public List<TestingPrestoServer> getServers() {
        return ImmutableList.copyOf(this.servers);
    }

    public void installPlugin(Plugin plugin) {
        long start = System.nanoTime();
        for (TestingPrestoServer server : this.servers) {
            server.installPlugin(plugin);
        }
        log.info("Installed plugin %s in %s", new Object[]{plugin.getClass().getSimpleName(), Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
    }

    public void createCatalog(String catalogName, String connectorName) {
        this.createCatalog(catalogName, connectorName, (Map<String, String>)ImmutableMap.of());
    }

    public void createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        long start = System.nanoTime();
        HashSet<ConnectorId> connectorIds = new HashSet<ConnectorId>();
        for (TestingPrestoServer server : this.servers) {
            connectorIds.add(server.createCatalog(catalogName, connectorName, properties));
        }
        ConnectorId connectorId = (ConnectorId)Iterables.getOnlyElement(connectorIds);
        log.info("Created catalog %s (%s) in %s", new Object[]{catalogName, connectorId, Duration.nanosSince((long)start)});
        start = System.nanoTime();
        while (!this.isConnectionVisibleToAllNodes(connectorId)) {
            Assertions.assertLessThan((Comparable)Duration.nanosSince((long)start), (Comparable)new Duration(100.0, TimeUnit.SECONDS), (String)("waiting for connector " + connectorId + " to be initialized in every node"));
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Throwables.propagate((Throwable)e);
            }
        }
        log.info("Announced catalog %s (%s) in %s", new Object[]{catalogName, connectorId, Duration.nanosSince((long)start)});
    }

    private boolean isConnectionVisibleToAllNodes(ConnectorId connectorId) {
        for (TestingPrestoServer server : this.servers) {
            server.refreshNodes();
            Set activeNodesWithConnector = server.getActiveNodesWithConnector(connectorId);
            if (activeNodesWithConnector.size() == this.servers.size()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QualifiedObjectName> listTables(Session session, String catalog, String schema) {
        this.lock.readLock().lock();
        try {
            List<QualifiedObjectName> list = this.prestoClient.listTables(session, catalog, schema);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(Session session, String table) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.prestoClient.tableExists(session, table);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public MaterializedResult execute(@Language(value="SQL") String sql) {
        this.lock.readLock().lock();
        try {
            MaterializedResult materializedResult = (MaterializedResult)this.prestoClient.execute(sql).getResult();
            return materializedResult;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaterializedResult execute(Session session, @Language(value="SQL") String sql) {
        this.lock.readLock().lock();
        try {
            MaterializedResult materializedResult = (MaterializedResult)this.prestoClient.execute(session, sql).getResult();
            return materializedResult;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultWithQueryId<MaterializedResult> executeWithQueryId(Session session, @Language(value="SQL") String sql) {
        this.lock.readLock().lock();
        try {
            ResultWithQueryId<MaterializedResult> resultWithQueryId = this.prestoClient.execute(session, sql);
            return resultWithQueryId;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public QueryInfo getQueryInfo(QueryId queryId) {
        return this.coordinator.getQueryManager().getQueryInfo(queryId);
    }

    public Plan getQueryPlan(QueryId queryId) {
        return this.coordinator.getQueryManager().getQueryPlan(queryId);
    }

    public Lock getExclusiveLock() {
        return this.lock.writeLock();
    }

    public final void close() {
        this.cancelAllQueries();
        try {
            this.closer.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void cancelAllQueries() {
        QueryManager queryManager = this.coordinator.getQueryManager();
        for (QueryInfo queryInfo : queryManager.getAllQueryInfo()) {
            if (queryInfo.getState().isDone()) continue;
            queryManager.cancelQuery(queryInfo.getQueryId());
        }
    }
}

