/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.datatype;

import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Strings;
import java.util.Optional;
import java.util.function.Function;

public class DataType<T> {
    private String insertType;
    private Type prestoResultType;
    private Function<T, String> toLiteral;
    private Function<T, ?> toPrestoQueryResult;

    public static DataType<String> varcharDataType(int size) {
        return DataType.varcharDataType(size, "");
    }

    public static DataType<String> varcharDataType(int size, String properties) {
        return DataType.varcharDataType(Optional.of(size), properties);
    }

    public static DataType<String> varcharDataType() {
        return DataType.varcharDataType(Optional.empty(), "");
    }

    private static DataType<String> varcharDataType(Optional<Integer> length, String properties) {
        String prefix = length.map(size -> "varchar(" + size + ")").orElse("varchar");
        String suffix = properties.isEmpty() ? "" : " " + properties;
        VarcharType varcharType = length.map(VarcharType::createVarcharType).orElse(VarcharType.createUnboundedVarcharType());
        return DataType.stringDataType(prefix + suffix, (Type)varcharType);
    }

    public static DataType<String> stringDataType(String insertType, Type prestoResultType) {
        return DataType.dataType(insertType, prestoResultType, DataType::quote, Function.identity());
    }

    public static DataType<String> charDataType(int length) {
        return DataType.charDataType(length, "");
    }

    public static DataType<String> charDataType(int length, String properties) {
        String suffix = properties.isEmpty() ? "" : " " + properties;
        return DataType.charDataType("char(" + length + ")" + suffix, length);
    }

    public static DataType<String> charDataType(String insertType, int length) {
        return DataType.dataType(insertType, (Type)CharType.createCharType((long)length), DataType::quote, input -> Strings.padEnd((String)input, (int)length, (char)' '));
    }

    private static String quote(String value) {
        return "'" + value + "'";
    }

    public static <T> DataType<T> dataType(String insertType, Type prestoResultType, Function<T, String> toLiteral, Function<T, ?> toPrestoQueryResult) {
        return new DataType<T>(insertType, prestoResultType, toLiteral, toPrestoQueryResult);
    }

    private DataType(String insertType, Type prestoResultType, Function<T, String> toLiteral, Function<T, ?> toPrestoQueryResult) {
        this.insertType = insertType;
        this.prestoResultType = prestoResultType;
        this.toLiteral = toLiteral;
        this.toPrestoQueryResult = toPrestoQueryResult;
    }

    public String toLiteral(T inputValue) {
        return this.toLiteral.apply(inputValue);
    }

    public Object toPrestoQueryResult(T inputValue) {
        return this.toPrestoQueryResult.apply(inputValue);
    }

    public String getInsertType() {
        return this.insertType;
    }

    public Type getPrestoResultType() {
        return this.prestoResultType;
    }
}

