/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.H2QueryRunner;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.log.Logger;
import io.airlift.tpch.TpchTable;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;

public final class QueryAssertions {
    private static final Logger log = Logger.get(QueryAssertions.class);

    private QueryAssertions() {
    }

    public static void assertUpdate(QueryRunner queryRunner, Session session, @Language(value="SQL") String sql, OptionalLong count) {
        long start = System.nanoTime();
        MaterializedResult results = queryRunner.execute(session, sql);
        log.info("FINISHED in presto: %s", new Object[]{Duration.nanosSince((long)start)});
        if (!results.getUpdateType().isPresent()) {
            Assert.fail((String)"update type is not set");
        }
        if (results.getUpdateCount().isPresent()) {
            if (!count.isPresent()) {
                Assert.fail((String)"update count should not be present");
            }
            Assert.assertEquals((long)results.getUpdateCount().getAsLong(), (long)count.getAsLong(), (String)"update count");
        } else if (count.isPresent()) {
            Assert.fail((String)"update count is not present");
        }
    }

    public static void assertQuery(QueryRunner actualQueryRunner, Session session, @Language(value="SQL") String actual, H2QueryRunner h2QueryRunner, @Language(value="SQL") String expected, boolean ensureOrdering, boolean compareUpdate) {
        long start = System.nanoTime();
        MaterializedResult actualResults = null;
        try {
            actualResults = actualQueryRunner.execute(session, actual).toJdbcTypes();
        }
        catch (RuntimeException ex) {
            Assert.fail((String)("Execution of 'actual' query failed: " + actual), (Throwable)ex);
        }
        Duration actualTime = Duration.nanosSince((long)start);
        long expectedStart = System.nanoTime();
        MaterializedResult expectedResults = null;
        try {
            expectedResults = h2QueryRunner.execute(session, expected, actualResults.getTypes());
        }
        catch (RuntimeException ex) {
            Assert.fail((String)("Execution of 'expected' query failed: " + expected), (Throwable)ex);
        }
        log.info("FINISHED in presto: %s, h2: %s, total: %s", new Object[]{actualTime, Duration.nanosSince((long)expectedStart), Duration.nanosSince((long)start)});
        if (actualResults.getUpdateType().isPresent() || actualResults.getUpdateCount().isPresent()) {
            if (!actualResults.getUpdateType().isPresent()) {
                Assert.fail((String)("update count present without update type for query: \n" + actual));
            }
            if (!compareUpdate) {
                Assert.fail((String)("update type should not be present (use assertUpdate) for query: \n" + actual));
            }
        }
        List actualRows = actualResults.getMaterializedRows();
        List expectedRows = expectedResults.getMaterializedRows();
        if (compareUpdate) {
            if (!actualResults.getUpdateType().isPresent()) {
                Assert.fail((String)("update type not present for query: \n" + actual));
            }
            if (!actualResults.getUpdateCount().isPresent()) {
                Assert.fail((String)("update count not present for query: \n" + actual));
            }
            Assert.assertEquals((int)actualRows.size(), (int)1, (String)("For query: \n " + actual + "\n:"));
            Assert.assertEquals((int)expectedRows.size(), (int)1, (String)("For query: \n " + actual + "\n:"));
            MaterializedRow row = (MaterializedRow)expectedRows.get(0);
            Assert.assertEquals((int)row.getFieldCount(), (int)1, (String)("For query: \n " + actual + "\n:"));
            Assert.assertEquals((Object)row.getField(0), (Object)actualResults.getUpdateCount().getAsLong(), (String)("For query: \n " + actual + "\n:"));
        }
        if (ensureOrdering) {
            if (!actualRows.equals(expectedRows)) {
                Assert.assertEquals((Collection)actualRows, (Collection)expectedRows, (String)("For query: \n " + actual + "\n:"));
            }
        } else {
            QueryAssertions.assertEqualsIgnoreOrder(actualRows, expectedRows, "For query: \n " + actual);
        }
    }

    public static void assertEqualsIgnoreOrder(Iterable<?> actual, Iterable<?> expected) {
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected, null);
    }

    public static void assertEqualsIgnoreOrder(Iterable<?> actual, Iterable<?> expected, String message) {
        Assert.assertNotNull(actual, (String)"actual is null");
        Assert.assertNotNull(expected, (String)"expected is null");
        ImmutableMultiset actualSet = ImmutableMultiset.copyOf(actual);
        ImmutableMultiset expectedSet = ImmutableMultiset.copyOf(expected);
        if (!actualSet.equals((Object)expectedSet)) {
            Assert.fail((String)String.format("%snot equal\nActual %s rows:\n    %s\nExpected %s rows:\n    %s\n", message == null ? "" : message + "\n", actualSet.size(), Joiner.on((String)"\n    ").join(Iterables.limit((Iterable)actualSet, (int)100)), expectedSet.size(), Joiner.on((String)"\n    ").join(Iterables.limit((Iterable)expectedSet, (int)100))));
        }
    }

    public static void assertContainsEventually(Supplier<MaterializedResult> all, MaterializedResult expectedSubset, Duration timeout) {
        long start = System.nanoTime();
        while (!Thread.currentThread().isInterrupted()) {
            try {
                QueryAssertions.assertContains(all.get(), expectedSubset);
                return;
            }
            catch (AssertionError e) {
                if (Duration.nanosSince((long)start).compareTo(timeout) > 0) {
                    throw e;
                }
                Uninterruptibles.sleepUninterruptibly((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }
    }

    public static void assertContains(MaterializedResult all, MaterializedResult expectedSubset) {
        for (MaterializedRow row : expectedSubset.getMaterializedRows()) {
            if (all.getMaterializedRows().contains(row)) continue;
            Assert.fail((String)String.format("expected row missing: %s\nAll %s rows:\n    %s\nExpected subset %s rows:\n    %s\n", row, all.getMaterializedRows().size(), Joiner.on((String)"\n    ").join(Iterables.limit((Iterable)all, (int)100)), expectedSubset.getMaterializedRows().size(), Joiner.on((String)"\n    ").join(Iterables.limit((Iterable)expectedSubset, (int)100))));
        }
    }

    public static void copyTpchTables(QueryRunner queryRunner, String sourceCatalog, String sourceSchema, Session session, Iterable<TpchTable<?>> tables) {
        log.info("Loading data from %s.%s...", new Object[]{sourceCatalog, sourceSchema});
        long startTime = System.nanoTime();
        for (TpchTable<?> table : tables) {
            QueryAssertions.copyTable(queryRunner, sourceCatalog, sourceSchema, table.getTableName().toLowerCase(Locale.ENGLISH), session);
        }
        log.info("Loading from %s.%s complete in %s", new Object[]{sourceCatalog, sourceSchema, Duration.nanosSince((long)startTime).toString(TimeUnit.SECONDS)});
    }

    public static void copyTable(QueryRunner queryRunner, String sourceCatalog, String sourceSchema, String sourceTable, Session session) {
        QualifiedObjectName table = new QualifiedObjectName(sourceCatalog, sourceSchema, sourceTable);
        QueryAssertions.copyTable(queryRunner, table, session);
    }

    public static void copyTable(QueryRunner queryRunner, QualifiedObjectName table, Session session) {
        long start = System.nanoTime();
        log.info("Running import for %s", new Object[]{table.getObjectName()});
        String sql = String.format("CREATE TABLE %s AS SELECT * FROM %s", table.getObjectName(), table);
        long rows = (Long)((MaterializedRow)queryRunner.execute(session, sql).getMaterializedRows().get(0)).getField(0);
        log.info("Imported %s rows for %s in %s", new Object[]{rows, table.getObjectName(), Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
    }
}

