/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.FunctionListBuilder;
import com.facebook.presto.metadata.SqlFunction;
import com.facebook.presto.operator.scalar.ApplyFunction;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.testing.Arguments;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.testing.TestingAccessControlManager;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.facebook.presto.tests.CreateHll;
import com.facebook.presto.tests.CustomAdd;
import com.facebook.presto.tests.CustomRank;
import com.facebook.presto.tests.CustomSum;
import com.facebook.presto.tests.QueryAssertions;
import com.facebook.presto.tests.QueryTemplate;
import com.facebook.presto.type.SqlIntervalDayTime;
import com.facebook.presto.type.SqlIntervalYearMonth;
import com.facebook.presto.util.DateTimeZoneIndex;
import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import io.airlift.tpch.TpchTable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.intellij.lang.annotations.Language;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class AbstractTestQueries
extends AbstractTestQueryFramework {
    protected static final List<SqlFunction> CUSTOM_FUNCTIONS = new FunctionListBuilder().aggregate(CustomSum.class).window(CustomRank.class).scalars(CustomAdd.class).scalars(CreateHll.class).function((SqlFunction)ApplyFunction.APPLY_FUNCTION).getFunctions();
    public static final List<PropertyMetadata<?>> TEST_SYSTEM_PROPERTIES = ImmutableList.of((Object)PropertyMetadata.stringSessionProperty((String)"test_string", (String)"test string property", (String)"test default", (boolean)false), (Object)PropertyMetadata.longSessionProperty((String)"test_long", (String)"test long property", (Long)42L, (boolean)false));
    public static final List<PropertyMetadata<?>> TEST_CATALOG_PROPERTIES = ImmutableList.of((Object)PropertyMetadata.stringSessionProperty((String)"connector_string", (String)"connector string property", (String)"connector default", (boolean)false), (Object)PropertyMetadata.longSessionProperty((String)"connector_long", (String)"connector long property", (Long)33L, (boolean)false), (Object)PropertyMetadata.booleanSessionProperty((String)"connector_boolean", (String)"connector boolean property", (Boolean)true, (boolean)false), (Object)PropertyMetadata.doubleSessionProperty((String)"connector_double", (String)"connector double property", (Double)99.0, (boolean)false));

    protected AbstractTestQueries(AbstractTestQueryFramework.QueryRunnerSupplier supplier) {
        super(supplier);
    }

    @Test
    public void testParsingError() {
        this.assertQueryFails("SELECT foo FROM", "line 1:16: no viable alternative at input.*");
    }

    @Test
    public void selectLargeInterval() {
        MaterializedResult result = this.computeActual("SELECT INTERVAL '30' DAY");
        Assert.assertEquals((int)result.getRowCount(), (int)1);
        Assert.assertEquals((Object)((MaterializedRow)result.getMaterializedRows().get(0)).getField(0), (Object)new SqlIntervalDayTime(30, 0, 0, 0, 0));
        result = this.computeActual("SELECT INTERVAL '32767' YEAR");
        Assert.assertEquals((int)result.getRowCount(), (int)1);
        Assert.assertEquals((Object)((MaterializedRow)result.getMaterializedRows().get(0)).getField(0), (Object)new SqlIntervalYearMonth(Short.MAX_VALUE, 0));
    }

    @Test
    public void selectNull() {
        this.assertQuery("SELECT NULL", "SELECT NULL FROM (SELECT * FROM ORDERS LIMIT 1)");
    }

    @Test
    public void testLimitIntMax() {
        this.assertQuery("SELECT orderkey from orders LIMIT 2147483647");
        this.assertQuery("SELECT orderkey from orders ORDER BY orderkey LIMIT 2147483647");
    }

    @Test
    public void testNonDeterministic() {
        MaterializedResult materializedResult = this.computeActual("SELECT rand() FROM orders LIMIT 10");
        long distinctCount = materializedResult.getMaterializedRows().stream().map(row -> row.getField(0)).distinct().count();
        Assert.assertTrue((distinctCount >= 8L ? 1 : 0) != 0, (String)"rand() must produce different rows");
        materializedResult = this.computeActual("SELECT apply(1, x -> x + rand()) FROM orders LIMIT 10");
        distinctCount = materializedResult.getMaterializedRows().stream().map(row -> row.getField(0)).distinct().count();
        Assert.assertTrue((distinctCount >= 8L ? 1 : 0) != 0, (String)"rand() must produce different rows");
    }

    @Test
    public void testLambdaInAggregationContext() {
        this.assertQuery("SELECT apply(sum(x), i -> i * i) FROM (VALUES 1, 2, 3, 4, 5) t(x)", "SELECT 225");
        this.assertQuery("SELECT apply(x, i -> i - 1), sum(y) FROM (VALUES (1, 10), (1, 20), (2, 50)) t(x,y) group by x", "VALUES (0, 30), (1, 50)");
        this.assertQuery("SELECT x, apply(sum(y), i -> i * 10) FROM (VALUES (1, 10), (1, 20), (2, 50)) t(x,y) group by x", "VALUES (1, 300), (2, 500)");
    }

    @Test
    public void testLambdaInSubqueryContext() {
        this.assertQuery("SELECT apply(x, i -> i * i) FROM (SELECT 10 x)", "SELECT 100");
        this.assertQuery("SELECT apply((SELECT 10), i -> i * i)", "SELECT 100");
    }

    @Test
    public void testLambdaWithAggregation() {
        this.assertQueryFails("SELECT transform(ARRAY[1], x -> max(x))", ".* Lambda expression cannot contain aggregations or window functions: .*");
    }

    @Test
    public void testTryLambdaRepeated() {
        this.assertQuery("SELECT x + x FROM (SELECT apply(a, i -> i * i) x FROM (VALUES 3) t(a))", "SELECT 18");
        this.assertQuery("SELECT apply(a, i -> i * i) + apply(a, i -> i * i) FROM (VALUES 3) t(a)", "SELECT 18");
        this.assertQuery("SELECT apply(a, i -> i * i), apply(a, i -> i * i) FROM (VALUES 3) t(a)", "SELECT 9, 9");
        this.assertQuery("SELECT try(10 / a) + try(10 / a) FROM (VALUES 5) t(a)", "SELECT 4");
        this.assertQuery("SELECT try(10 / a), try(10 / a) FROM (VALUES 5) t(a)", "SELECT 2, 2");
    }

    @Test
    public void testNonDeterministicFilter() {
        MaterializedResult materializedResult = this.computeActual("SELECT u FROM ( SELECT if(rand() > 0.5, 0, 1) AS u ) WHERE u <> u");
        Assert.assertEquals((int)materializedResult.getRowCount(), (int)0);
        materializedResult = this.computeActual("SELECT u, v FROM ( SELECT if(rand() > 0.5, 0, 1) AS u, 4*4 as v ) WHERE u <> u and v > 10");
        Assert.assertEquals((int)materializedResult.getRowCount(), (int)0);
        materializedResult = this.computeActual("SELECT u, v, w FROM ( SELECT if(rand() > 0.5, 0, 1) AS u, 4*4 as v, 'abc' as w ) WHERE v > 10");
        Assert.assertEquals((int)materializedResult.getRowCount(), (int)1);
    }

    @Test
    public void testNonDeterministicProjection() {
        MaterializedResult materializedResult = this.computeActual("select r, r + 1 from (select rand(100) r from orders) limit 10");
        Assert.assertEquals((int)materializedResult.getRowCount(), (int)10);
        for (MaterializedRow materializedRow : materializedResult) {
            Assert.assertEquals((int)materializedRow.getFieldCount(), (int)2);
            Assert.assertEquals((Object)(((Number)materializedRow.getField(0)).intValue() + 1), (Object)materializedRow.getField(1));
        }
    }

    @Test
    public void testMapSubscript() {
        this.assertQuery("select map(array[1], array['aa'])[1]", "select 'aa'");
        this.assertQuery("select map(array['a'], array['aa'])['a']", "select 'aa'");
        this.assertQuery("select map(array[array[1,1]], array['a'])[array[1,1]]", "select 'a'");
        this.assertQuery("select map(array[(1,2)], array['a'])[(1,2)]", "select 'a'");
    }

    @Test
    public void testVarbinary() {
        this.assertQuery("SELECT LENGTH(x) FROM (SELECT from_base64('gw==') as x)", "SELECT 1");
        this.assertQuery("SELECT LENGTH(from_base64('gw=='))", "SELECT 1");
    }

    @Test
    public void testRowFieldAccessor() {
        this.assertQuery("SELECT a.col0 FROM (VALUES ROW (CAST(ROW(1, 2) AS ROW(col0 integer, col1 integer)))) AS t (a)", "SELECT 1");
        this.assertQuery("SELECT a.col0 FROM (VALUES ROW (CAST(ROW(1.0, 2.0) AS ROW(col0 integer, col1 integer)))) AS t (a)", "SELECT 1.0");
        this.assertQuery("SELECT a.col0 FROM (VALUES ROW (CAST(ROW(TRUE, FALSE) AS ROW(col0 boolean, col1 boolean)))) AS t (a)", "SELECT TRUE");
        this.assertQuery("SELECT a.col1 FROM (VALUES ROW (CAST(ROW(1.0, 'kittens') AS ROW(col0 varchar, col1 varchar)))) AS t (a)", "SELECT 'kittens'");
        this.assertQuery("SELECT a.col2.col1 FROM (VALUES ROW(CAST(ROW(1.0, ARRAY[2], row(3, 4.0)) AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double))))) t(a)", "SELECT 4.0");
        this.assertQuery("SELECT cast(row(1, t.x) as row(col0 bigint, col1 bigint)).col1 FROM (VALUES 1, 2, 3) t(x)", "SELECT * FROM (VALUES 1, 2, 3)");
        this.assertQuery("SELECT Y.col1 FROM (SELECT cast(row(1, t.x) as row(col0 bigint, col1 bigint)) AS Y FROM (VALUES 1, 2, 3) t(x)) test_t", "SELECT * FROM (VALUES 1, 2, 3)");
        this.assertQuery("SELECT a.col1[2] FROM (VALUES ROW(CAST(ROW(1.0, ARRAY[22, 33, 44, 55], row(3, 4.0)) AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double))))) t(a)", "SELECT 33");
        this.assertQuery("SELECT a.col1[2].col0, a.col1[2].col1 FROM (VALUES ROW(cast(row(1.0, ARRAY[row(31, 4.1), row(32, 4.2)], row(3, 4.0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double))))) t(a)", "SELECT 32, 4.2");
        this.assertQuery("SELECT cast(row(11, 12) as row(col0 bigint, col1 bigint)).col0", "SELECT 11");
    }

    @Test
    public void testRowFieldAccessorInAggregate() {
        this.assertQuery("SELECT a.col0, SUM(a.col1[2]), SUM(a.col2.col0), SUM(a.col2.col1) FROM (VALUES ROW(CAST(ROW(1.0, ARRAY[2, 13, 4], row(11, 4.1))   AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(2.0, ARRAY[2, 23, 4], row(12, 14.0))  AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(1.0, ARRAY[22, 33, 44], row(13, 5.0)) AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double))))) t(a) GROUP BY a.col0", "SELECT * FROM VALUES (1.0, 46, 24, 9.1), (2.0, 23, 12, 14.0)");
        this.assertQuery("SELECT a.col2.col0, SUM(a.col0), SUM(a.col1[2]), SUM(a.col2.col1) FROM (VALUES ROW(CAST(ROW(1.0, ARRAY[2, 13, 4], row(11, 4.1))   AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(2.0, ARRAY[2, 23, 4], row(11, 14.0))  AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(7.0, ARRAY[22, 33, 44], row(13, 5.0)) AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double))))) t(a) GROUP BY a.col2.col0", "SELECT * FROM VALUES (11, 3.0, 36, 18.1), (13, 7.0, 33, 5.0)");
        this.assertQuery("SELECT a.col1[1].col0, SUM(a.col0), SUM(a.col1[1].col1), SUM(a.col1[2].col0), SUM(a.col2.col1) FROM (VALUES ROW(CAST(ROW(1.0, ARRAY[row(31, 4.5), row(12, 4.2)], row(3, 4.0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(3.1, ARRAY[row(41, 3.1), row(32, 4.2)], row(6, 6.0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(2.2, ARRAY[row(31, 4.2), row(22, 4.2)], row(5, 4.0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double))))) t(a) GROUP BY a.col1[1].col0", "SELECT * FROM VALUES (31, 3.2, 8.7, 34, 8.0), (41, 3.1, 3.1, 32, 6.0)");
        this.assertQuery("SELECT a.col1[1].col0, SUM(a.col0), SUM(a.col1[1].col1), SUM(a.col1[2].col0), SUM(a.col2.col1) FROM (VALUES ROW(CAST(ROW(2.2, ARRAY[row(31, 4.2), row(22, 4.2)], row(5, 4.0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(1.0, ARRAY[row(31, 4.5), row(12, 4.2)], row(3, 4.1)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(3.1, ARRAY[row(41, 3.1), row(32, 4.2)], row(6, 6.0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(3.3, ARRAY[row(41, 3.1), row(32, 4.2)], row(6, 6.0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))) ) t(a) GROUP BY a.col1[1]", "SELECT * FROM VALUES (31, 2.2, 4.2, 22, 4.0), (31, 1.0, 4.5, 12, 4.1), (41, 6.4, 6.2, 64, 12.0)");
        this.assertQuery("SELECT a.col1[2], SUM(a.col0), SUM(a.col1[1]), SUM(a.col2.col1) FROM (VALUES ROW(CAST(ROW(1.0, ARRAY[2, 13, 4], row(11, 4.1))   AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(2.0, ARRAY[2, 13, 4], row(12, 14.0))  AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(7.0, ARRAY[22, 33, 44], row(13, 5.0)) AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double))))) t(a) GROUP BY a.col1[2]", "SELECT * FROM VALUES (13, 3.0, 4, 18.1), (33, 7.0, 22, 5.0)");
        this.assertQuery("SELECT a.col2.col0, SUM(a.col2.col1) FROM (VALUES ROW(CAST(ROW(2.2, ARRAY[row(31, 4.2), row(22, 4.2)], row(5, 4.0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(1.0, ARRAY[row(31, 4.5), row(12, 4.2)], row(3, 4.1)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(3.1, ARRAY[row(41, 3.1), row(32, 4.2)], row(6, 6.0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(3.3, ARRAY[row(41, 3.1), row(32, 4.2)], row(6, 6.0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))) ) t(a) GROUP BY a.col2", "SELECT * FROM VALUES (5, 4.0), (3, 4.1), (6, 12.0)");
        this.assertQuery("SELECT a.col2.col0, a.col0, SUM(a.col2.col1) FROM (VALUES ROW(CAST(ROW(1.0, ARRAY[2, 13, 4], row(11, 4.1))   AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(2.0, ARRAY[2, 23, 4], row(11, 14.0))  AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(1.5, ARRAY[2, 13, 4], row(11, 4.1))   AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(1.5, ARRAY[2, 13, 4], row(11, 4.1))   AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(7.0, ARRAY[22, 33, 44], row(13, 5.0)) AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double))))) t(a) WHERE a.col1[2] < 30 GROUP BY 1, 2 ORDER BY 1", "SELECT * FROM VALUES (11, 1.0, 4.1), (11, 1.5, 8.2), (11, 2.0, 14.0)");
        this.assertQuery("SELECT a[1].col0, COUNT(1) FROM (VALUES (ROW(CAST(ARRAY[row(31, 4.2), row(22, 4.2)] AS ARRAY(ROW(col0 integer, col1 double))))), (ROW(CAST(ARRAY[row(31, 4.5), row(12, 4.2)] AS ARRAY(ROW(col0 integer, col1 double))))), (ROW(CAST(ARRAY[row(41, 3.1), row(32, 4.2)] AS ARRAY(ROW(col0 integer, col1 double))))), (ROW(CAST(ARRAY[row(31, 3.1), row(32, 4.2)] AS ARRAY(ROW(col0 integer, col1 double))))) ) t(a) GROUP BY 1 ORDER BY 2 DESC", "SELECT * FROM VALUES (31, 3), (41, 1)");
    }

    @Test
    public void testRowFieldAccessorInWindowFunction() {
        this.assertQuery("SELECT a.col0, SUM(a.col1[1].col1) OVER(PARTITION BY a.col2.col0), SUM(a.col2.col1) OVER(PARTITION BY a.col2.col0) FROM (VALUES ROW(CAST(ROW(1.0, ARRAY[row(31, 14.5), row(12, 4.2)], row(3, 4.0))  AS ROW(col0 double, col1 array(ROW(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(2.2, ARRAY[row(41, 13.1), row(32, 4.2)], row(6, 6.0))  AS ROW(col0 double, col1 array(ROW(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(2.2, ARRAY[row(41, 17.1), row(45, 4.2)], row(7, 16.0)) AS ROW(col0 double, col1 array(ROW(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(2.2, ARRAY[row(41, 13.1), row(32, 4.2)], row(6, 6.0))  AS ROW(col0 double, col1 array(ROW(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(3.1, ARRAY[row(41, 13.1), row(32, 4.2)], row(6, 6.0))  AS ROW(col0 double, col1 array(ROW(col0 integer, col1 double)), col2 row(col0 integer, col1 double))))) t(a) ", "SELECT * FROM VALUES (1.0, 14.5, 4.0), (2.2, 39.3, 18.0), (2.2, 39.3, 18.0), (2.2, 17.1, 16.0), (3.1, 39.3, 18.0)");
        this.assertQuery("SELECT a.col1[1].col0, SUM(a.col0) OVER(PARTITION BY a.col1[1].col0), SUM(a.col1[1].col1) OVER(PARTITION BY a.col1[1].col0), SUM(a.col2.col1) OVER(PARTITION BY a.col1[1].col0) FROM (VALUES ROW(CAST(ROW(1.0, ARRAY[row(31, 14.5), row(12, 4.2)], row(3, 4.0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(3.1, ARRAY[row(41, 13.1), row(32, 4.2)], row(6, 6.0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(2.2, ARRAY[row(31, 14.2), row(22, 5.2)], row(5, 4.0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double))))) t(a) WHERE a.col1[2].col1 > a.col2.col0", "SELECT * FROM VALUES (31, 3.2, 28.7, 8.0), (31, 3.2, 28.7, 8.0)");
    }

    @Test
    public void testRowFieldAccessorInJoin() {
        this.assertQuery("SELECT t.a.col1, custkey, orderkey FROM (VALUES ROW(CAST(ROW(1, 11) AS ROW(col0 integer, col1 integer))), ROW(CAST(ROW(2, 22) AS ROW(col0 integer, col1 integer))), ROW(CAST(ROW(3, 33) AS ROW(col0 integer, col1 integer)))) t(a) INNER JOIN orders ON t.a.col0 = orders.orderkey", "SELECT * FROM VALUES (11, 370, 1), (22, 781, 2), (33, 1234, 3)");
    }

    @Test
    public void testRowCast() {
        this.assertQuery("SELECT cast(row(1, 2) as row(aa bigint, bb boolean)).aa", "SELECT 1");
        this.assertQuery("SELECT cast(row(1, 2) as row(aa bigint, bb boolean)).bb", "SELECT true");
        this.assertQuery("SELECT cast(row(1, 2) as row(aa bigint, bb varchar)).bb", "SELECT '2'");
        this.assertQuery("SELECT cast(row(true, array[0, 2]) as row(aa boolean, bb array(boolean))).bb[1]", "SELECT false");
        this.assertQuery("SELECT cast(row(0.1, array[0, 2], row(1, 0.5)) as row(aa bigint, bb array(boolean), cc row(dd varchar, ee varchar))).cc.ee", "SELECT '0.5'");
        this.assertQuery("SELECT cast(array[row(0.1, array[0, 2], row(1, 0.5))] as array<row(aa bigint, bb array(boolean), cc row(dd varchar, ee varchar))>)[1].cc.ee", "SELECT '0.5'");
    }

    @Test
    public void testDereferenceInSubquery() {
        this.assertQuery("SELECT x FROM (   SELECT a.x   FROM (VALUES 1, 2, 3) a(x)) GROUP BY x", "SELECT * FROM VALUES 1, 2, 3");
        this.assertQuery("SELECT t2.*, max(t1.b) as max_b FROM (VALUES (1, 'a'),  (2, 'b'), (1, 'c'), (3, 'd')) t1(a, b) INNER JOIN (VALUES 1, 2, 3, 4) t2(a) ON t1.a = t2.a GROUP BY t2.a", "SELECT * FROM VALUES (1, 'c'), (2, 'b'), (3, 'd')");
        this.assertQuery("SELECT t2.*, max(t1.b1) as max_b1 FROM (VALUES (1, 'a'),  (2, 'b'), (1, 'c'), (3, 'd')) t1(a1, b1) INNER JOIN (VALUES (1, 11, 111), (2, 22, 222), (3, 33, 333), (4, 44, 444)) t2(a2, b2, c2) ON t1.a1 = t2.a2 GROUP BY t2.a2, t2.b2, t2.c2", "SELECT * FROM VALUES (1, 11, 111, 'c'), (2, 22, 222, 'b'), (3, 33, 333, 'd')");
        this.assertQuery("SELECT custkey, orders2 FROM (   SELECT x.custkey, SUM(x.orders) + 1 orders2    FROM (       SELECT x.custkey, COUNT(x.orderkey) orders       FROM ORDERS x       WHERE x.custkey < 100       GROUP BY x.custkey    ) x    GROUP BY x.custkey) ORDER BY custkey");
    }

    @Test
    public void testDereferenceInFunctionCall() {
        this.assertQuery("SELECT COUNT(DISTINCT custkey) FROM (   SELECT x.custkey   FROM ORDERS x   WHERE custkey < 100 ) t");
    }

    @Test
    public void testDereferenceInComparison() {
        this.assertQuery("SELECT orders.custkey, orders.orderkey FROM ORDERS WHERE orders.custkey > orders.orderkey AND orders.custkey < 200.3");
    }

    @Test
    public void testMissingRowFieldInGroupBy() {
        this.assertQueryFails("SELECT a.col0, count(*) FROM (VALUES ROW(cast(ROW(1, 1) as ROW(col0 integer, col1 integer)))) t(a)", "line 1:8: '\"a\".\"col0\"' must be an aggregate expression or appear in GROUP BY clause");
    }

    @Test
    public void testWhereWithRowField() {
        this.assertQuery("SELECT a.col0 FROM (VALUES ROW(CAST(ROW(1, 2) AS ROW(col0 integer, col1 integer)))) AS t (a) WHERE a.col0 > 0", "SELECT 1");
        this.assertQuery("SELECT SUM(a.col0) FROM (VALUES ROW(CAST(ROW(1, 2) AS ROW(col0 integer, col1 integer)))) AS t (a) WHERE a.col0 <= 0", "SELECT null");
        this.assertQuery("SELECT a.col0 FROM (VALUES ROW(CAST(ROW(1, 2) AS ROW(col0 integer, col1 integer)))) AS t (a) WHERE a.col0 < a.col1", "SELECT 1");
        this.assertQuery("SELECT SUM(a.col0) FROM (VALUES ROW(CAST(ROW(1, 2) AS ROW(col0 integer, col1 integer)))) AS t (a) WHERE a.col0 < a.col1", "SELECT 1");
        this.assertQuery("SELECT SUM(a.col0) FROM (VALUES ROW(CAST(ROW(1, 2) AS ROW(col0 integer, col1 integer)))) AS t (a) WHERE a.col0 > a.col1", "SELECT null");
    }

    @Test
    public void testUnnest() {
        this.assertQuery("SELECT 1 FROM (VALUES (ARRAY[1])) AS t (a) CROSS JOIN UNNEST(a)", "SELECT 1");
        this.assertQuery("SELECT x[1] FROM UNNEST(ARRAY[ARRAY[1, 2, 3]]) t(x)", "SELECT 1");
        this.assertQuery("SELECT x[1][2] FROM UNNEST(ARRAY[ARRAY[ARRAY[1, 2, 3]]]) t(x)", "SELECT 2");
        this.assertQuery("SELECT x[2] FROM UNNEST(ARRAY[MAP(ARRAY[1,2], ARRAY['hello', 'hi'])]) t(x)", "SELECT 'hi'");
        this.assertQuery("SELECT * FROM UNNEST(ARRAY[1, 2, 3])", "SELECT * FROM VALUES (1), (2), (3)");
        this.assertQuery("SELECT a FROM UNNEST(ARRAY[1, 2, 3]) t(a)", "SELECT * FROM VALUES (1), (2), (3)");
        this.assertQuery("SELECT a, b FROM UNNEST(ARRAY[1, 2], ARRAY[3, 4]) t(a, b)", "SELECT * FROM VALUES (1, 3), (2, 4)");
        this.assertQuery("SELECT a, b FROM UNNEST(ARRAY[1, 2, 3], ARRAY[4, 5]) t(a, b)", "SELECT * FROM VALUES (1, 4), (2, 5), (3, NULL)");
        this.assertQuery("SELECT a FROM UNNEST(ARRAY[1, 2, 3], ARRAY[4, 5]) t(a, b)", "SELECT * FROM VALUES 1, 2, 3");
        this.assertQuery("SELECT b FROM UNNEST(ARRAY[1, 2, 3], ARRAY[4, 5]) t(a, b)", "SELECT * FROM VALUES 4, 5, NULL");
        this.assertQuery("SELECT count(*) FROM UNNEST(ARRAY[1, 2, 3], ARRAY[4, 5])", "SELECT 3");
        this.assertQuery("SELECT a FROM UNNEST(ARRAY['kittens', 'puppies']) t(a)", "SELECT * FROM VALUES ('kittens'), ('puppies')");
        this.assertQuery("SELECT c FROM UNNEST(ARRAY[1, 2, 3], ARRAY[4, 5]) t(a, b) CROSS JOIN (values (8), (9)) t2(c)", "SELECT * FROM VALUES 8, 8, 8, 9, 9, 9");
        this.assertQuery("SELECT a.custkey, t.e FROM (SELECT custkey, ARRAY[1, 2, 3] AS my_array FROM orders ORDER BY orderkey LIMIT 1) a CROSS JOIN UNNEST(my_array) t(e)", "SELECT * FROM (SELECT custkey FROM orders ORDER BY orderkey LIMIT 1) CROSS JOIN (VALUES (1), (2), (3))");
        this.assertQuery("SELECT a.custkey, t.e FROM (SELECT custkey, ARRAY[1, 2, 3] AS my_array FROM orders ORDER BY orderkey LIMIT 1) a, UNNEST(my_array) t(e)", "SELECT * FROM (SELECT custkey FROM orders ORDER BY orderkey LIMIT 1) CROSS JOIN (VALUES (1), (2), (3))");
        this.assertQuery("SELECT * FROM UNNEST(ARRAY[0, 1]) CROSS JOIN UNNEST(ARRAY[0, 1]) CROSS JOIN UNNEST(ARRAY[0, 1])", "SELECT * FROM VALUES (0, 0, 0), (0, 0, 1), (0, 1, 0), (0, 1, 1), (1, 0, 0), (1, 0, 1), (1, 1, 0), (1, 1, 1)");
        this.assertQuery("SELECT * FROM UNNEST(ARRAY[0, 1]), UNNEST(ARRAY[0, 1]), UNNEST(ARRAY[0, 1])", "SELECT * FROM VALUES (0, 0, 0), (0, 0, 1), (0, 1, 0), (0, 1, 1), (1, 0, 0), (1, 0, 1), (1, 1, 0), (1, 1, 1)");
        this.assertQuery("SELECT a, b FROM UNNEST(MAP(ARRAY[1,2], ARRAY['cat', 'dog'])) t(a, b)", "SELECT * FROM VALUES (1, 'cat'), (2, 'dog')");
        this.assertQuery("SELECT a, b FROM UNNEST(MAP(ARRAY[1,2], ARRAY['cat', NULL])) t(a, b)", "SELECT * FROM VALUES (1, 'cat'), (2, NULL)");
        this.assertQuery("SELECT 1 FROM (VALUES (ARRAY[1])) AS t (a) CROSS JOIN UNNEST(a) WITH ORDINALITY", "SELECT 1");
        this.assertQuery("SELECT * FROM UNNEST(ARRAY[1, 2, 3]) WITH ORDINALITY", "SELECT * FROM VALUES (1, 1), (2, 2), (3, 3)");
        this.assertQuery("SELECT b FROM UNNEST(ARRAY[10, 20, 30]) WITH ORDINALITY t(a, b)", "SELECT * FROM VALUES (1), (2), (3)");
        this.assertQuery("SELECT a, b, c FROM UNNEST(ARRAY[10, 20, 30], ARRAY[4, 5]) WITH ORDINALITY t(a, b, c)", "SELECT * FROM VALUES (10, 4, 1), (20, 5, 2), (30, NULL, 3)");
        this.assertQuery("SELECT a, b FROM UNNEST(ARRAY['kittens', 'puppies']) WITH ORDINALITY t(a, b)", "SELECT * FROM VALUES ('kittens', 1), ('puppies', 2)");
        this.assertQuery("SELECT c FROM UNNEST(ARRAY[1, 2, 3], ARRAY[4, 5]) WITH ORDINALITY t(a, b, c) CROSS JOIN (values (8), (9)) t2(d)", "SELECT * FROM VALUES 1, 1, 2, 2, 3, 3");
        this.assertQuery("SELECT a.custkey, t.e, t.f FROM (SELECT custkey, ARRAY[10, 20, 30] AS my_array FROM orders ORDER BY orderkey LIMIT 1) a CROSS JOIN UNNEST(my_array) WITH ORDINALITY t(e, f)", "SELECT * FROM (SELECT custkey FROM orders ORDER BY orderkey LIMIT 1) CROSS JOIN (VALUES (10, 1), (20, 2), (30, 3))");
        this.assertQuery("SELECT a.custkey, t.e, t.f FROM (SELECT custkey, ARRAY[10, 20, 30] AS my_array FROM orders ORDER BY orderkey LIMIT 1) a, UNNEST(my_array) WITH ORDINALITY t(e, f)", "SELECT * FROM (SELECT custkey FROM orders ORDER BY orderkey LIMIT 1) CROSS JOIN (VALUES (10, 1), (20, 2), (30, 3))");
        this.assertQuery("SELECT * FROM orders, UNNEST(ARRAY[1])", "SELECT orders.*, 1 FROM orders");
    }

    @Test
    public void testArrays() {
        this.assertQuery("SELECT a[1] FROM (SELECT ARRAY[orderkey] AS a FROM orders ORDER BY orderkey) t", "SELECT orderkey FROM orders");
        this.assertQuery("SELECT a[1 + cast(round(rand()) AS BIGINT)] FROM (SELECT ARRAY[orderkey, orderkey] AS a FROM orders ORDER BY orderkey) t", "SELECT orderkey FROM orders");
        this.assertQuery("SELECT a[1] + 1 FROM (SELECT ARRAY[orderkey] AS a FROM orders ORDER BY orderkey) t", "SELECT orderkey + 1 FROM orders");
        this.assertQuery("SELECT a[1] FROM (SELECT ARRAY[orderkey + 1] AS a FROM orders ORDER BY orderkey) t", "SELECT orderkey + 1 FROM orders");
        this.assertQuery("SELECT a[1][1] FROM (SELECT ARRAY[ARRAY[orderkey + 1]] AS a FROM orders ORDER BY orderkey) t", "SELECT orderkey + 1 FROM orders");
        this.assertQuery("SELECT CARDINALITY(a) FROM (SELECT ARRAY[orderkey, orderkey + 1] AS a FROM orders ORDER BY orderkey) t", "SELECT 2 FROM orders");
    }

    @Test
    public void testRows() {
        this.assertQuery("SELECT JSON_FORMAT(CAST(ROW(1 + 2, CONCAT('a', 'b')) AS JSON))", "SELECT '[3,\"ab\"]'");
        this.assertQuery("SELECT JSON_FORMAT(CAST(ROW(a + b) AS JSON)) FROM (VALUES (1, 2)) AS t(a, b)", "SELECT '[3]'");
        this.assertQuery("SELECT JSON_FORMAT(CAST(ROW(1, ROW(9, a, ARRAY[], NULL), ROW(1, 2)) AS JSON)) FROM (VALUES ('a')) t(a)", "SELECT '[1,[9,\"a\",[],null],[1,2]]'");
        this.assertQuery("SELECT JSON_FORMAT(CAST(ROW(ROW(ROW(ROW(ROW(a, b), c), d), e), f) AS JSON)) FROM (VALUES (ROW(0, 1), 2, '3', NULL, ARRAY[5], ARRAY[])) t(a, b, c, d, e, f)", "SELECT '[[[[[[0,1],2],\"3\"],null],[5]],[]]'");
        this.assertQuery("SELECT JSON_FORMAT(CAST(ARRAY_AGG(ROW(a, b)) AS JSON)) FROM (VALUES (1, 2), (3, 4), (5, 6)) t(a, b)", "SELECT '[[1,2],[3,4],[5,6]]'");
        this.assertQuery("SELECT CONTAINS(ARRAY_AGG(ROW(a, b)), ROW(1, 2)) FROM (VALUES (1, 2), (3, 4), (5, 6)) t(a, b)", "SELECT TRUE");
        this.assertQuery("SELECT JSON_FORMAT(CAST(ARRAY_AGG(ROW(c, d)) AS JSON)) FROM (VALUES (ARRAY[1, 3, 5], ARRAY[2, 4, 6])) AS t(a, b) CROSS JOIN UNNEST(a, b) AS u(c, d)", "SELECT '[[1,2],[3,4],[5,6]]'");
        this.assertQuery("SELECT JSON_FORMAT(CAST(ROW(x, y, z) AS JSON)) FROM (VALUES ROW(1, NULL, '3')) t(x,y,z)", "SELECT '[1,null,\"3\"]'");
        this.assertQuery("SELECT JSON_FORMAT(CAST(ROW(x, y, z) AS JSON)) FROM (VALUES ROW(1, CAST(NULL AS INTEGER), '3')) t(x,y,z)", "SELECT '[1,null,\"3\"]'");
    }

    @Test
    public void testMaps() {
        this.assertQuery("SELECT m[max_key] FROM (SELECT map_agg(orderkey, orderkey) m, max(orderkey) max_key FROM orders)", "SELECT max(orderkey) FROM orders");
    }

    @Test
    public void testValues() {
        this.assertQuery("VALUES 1, 2, 3, 4");
        this.assertQuery("VALUES 1, 3, 2, 4 ORDER BY 1", "SELECT * FROM (VALUES 1, 3, 2, 4) ORDER BY 1");
        this.assertQuery("VALUES (1.1, 2, 'foo'), (sin(3.3), 2+2, 'bar')");
        this.assertQuery("VALUES (1.1, 2), (sin(3.3), 2+2) ORDER BY 1", "VALUES (sin(3.3), 2+2), (1.1, 2)");
        this.assertQuery("VALUES (1.1, 2), (sin(3.3), 2+2) LIMIT 1", "VALUES (1.1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1.1, 2), (sin(3.3), 2+2))");
        this.assertQuery("SELECT * FROM (VALUES (1.1, 2), (sin(3.3), 2+2)) x (a, b) LEFT JOIN (VALUES (1.1, 2), (1.1, 2+2)) y (a, b) USING (a)", "VALUES (1.1, 2, 1.1, 4), (1.1, 2, 1.1, 2), (sin(3.3), 4, NULL, NULL)");
        this.assertQuery("SELECT 1.1 in (VALUES (1.1), (2.2))", "VALUES (TRUE)");
        this.assertQuery("WITH a AS (VALUES (1.1, 2), (sin(3.3), 2+2)) SELECT * FROM a", "VALUES (1.1, 2), (sin(3.3), 2+2)");
        this.assertQuery("VALUES 1, 2.2, 3, 4.4");
        this.assertQuery("VALUES (1, 2), (3.3, 4.4)");
        this.assertQuery("VALUES true, 1.0 in (1, 2, 3)");
    }

    @Test
    public void testSpecialFloatingPointValues() {
        MaterializedResult actual = this.computeActual("SELECT nan(), infinity(), -infinity()");
        MaterializedRow row = (MaterializedRow)Iterables.getOnlyElement((Iterable)actual.getMaterializedRows());
        Assert.assertEquals((Object)row.getField(0), (Object)Double.NaN);
        Assert.assertEquals((Object)row.getField(1), (Object)Double.POSITIVE_INFINITY);
        Assert.assertEquals((Object)row.getField(2), (Object)Double.NEGATIVE_INFINITY);
    }

    @Test
    public void testMaxMinStringWithNulls() {
        this.assertQuery("SELECT custkey, MAX(NULLIF(orderstatus, 'O')), MIN(NULLIF(orderstatus, 'O')) FROM orders GROUP BY custkey");
    }

    @Test
    public void testApproxPercentile() {
        MaterializedResult raw = this.computeActual("SELECT orderstatus, orderkey, totalprice FROM ORDERS");
        ArrayListMultimap orderKeyByStatus = ArrayListMultimap.create();
        ArrayListMultimap totalPriceByStatus = ArrayListMultimap.create();
        for (MaterializedRow row : raw.getMaterializedRows()) {
            orderKeyByStatus.put((Object)((String)row.getField(0)), (Object)((Long)row.getField(1)));
            totalPriceByStatus.put((Object)((String)row.getField(0)), (Object)((Double)row.getField(2)));
        }
        MaterializedResult actual = this.computeActual("SELECT orderstatus,    approx_percentile(orderkey, 0.5),    approx_percentile(totalprice, 0.5),   approx_percentile(orderkey, 2, 0.5),   approx_percentile(totalprice, 2, 0.5)\nFROM ORDERS\nGROUP BY orderstatus");
        for (MaterializedRow row : actual.getMaterializedRows()) {
            String status = (String)row.getField(0);
            Long orderKey = (Long)row.getField(1);
            Double totalPrice = (Double)row.getField(2);
            Long orderKeyWeighted = (Long)row.getField(3);
            Double totalPriceWeighted = (Double)row.getField(4);
            List orderKeys = Ordering.natural().sortedCopy((Iterable)orderKeyByStatus.get((Object)status));
            List totalPrices = Ordering.natural().sortedCopy((Iterable)totalPriceByStatus.get((Object)status));
            Assert.assertTrue((orderKey >= (Long)orderKeys.get((int)(0.49 * (double)orderKeys.size())) ? 1 : 0) != 0);
            Assert.assertTrue((orderKey <= (Long)orderKeys.get((int)(0.51 * (double)orderKeys.size())) ? 1 : 0) != 0);
            Assert.assertTrue((orderKeyWeighted >= (Long)orderKeys.get((int)(0.49 * (double)orderKeys.size())) ? 1 : 0) != 0);
            Assert.assertTrue((orderKeyWeighted <= (Long)orderKeys.get((int)(0.51 * (double)orderKeys.size())) ? 1 : 0) != 0);
            Assert.assertTrue((totalPrice >= (Double)totalPrices.get((int)(0.49 * (double)totalPrices.size())) ? 1 : 0) != 0);
            Assert.assertTrue((totalPrice <= (Double)totalPrices.get((int)(0.51 * (double)totalPrices.size())) ? 1 : 0) != 0);
            Assert.assertTrue((totalPriceWeighted >= (Double)totalPrices.get((int)(0.49 * (double)totalPrices.size())) ? 1 : 0) != 0);
            Assert.assertTrue((totalPriceWeighted <= (Double)totalPrices.get((int)(0.51 * (double)totalPrices.size())) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testComplexQuery() {
        MaterializedResult actual = this.computeActual("SELECT sum(orderkey), row_number() OVER (ORDER BY orderkey)\nFROM orders\nWHERE orderkey <= 10\nGROUP BY orderkey\nHAVING sum(orderkey) >= 3\nORDER BY orderkey DESC\nLIMIT 3");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{7L, 5L}).row(new Object[]{6L, 4L}).row(new Object[]{5L, 3L}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testWhereNull() {
        this.assertQuery("SELECT custkey FROM orders WHERE custkey = custkey AND cast(nullif(custkey, custkey) as boolean) AND cast(nullif(custkey, custkey) as boolean)");
    }

    @Test
    public void testSumOfNulls() {
        this.assertQuery("SELECT orderstatus, sum(CAST(NULL AS BIGINT)) FROM orders GROUP BY orderstatus");
    }

    @Test
    public void testAggregationWithSomeArgumentCasts() {
        this.assertQuery("SELECT APPROX_PERCENTILE(0.1, x), AVG(x), MIN(x) FROM (values 1, 1, 1) t(x)", "SELECT 0.1, 1.0, 1");
    }

    @Test
    public void testAggregationWithHaving() {
        this.assertQuery("SELECT a, count(1) FROM (VALUES 1, 2, 3, 2) t(a) GROUP BY a HAVING count(1) > 1", "SELECT 2, 2");
    }

    @Test
    public void testApproximateCountDistinct() {
        this.assertQuery("SELECT approx_distinct(custkey) FROM orders", "SELECT 996");
        this.assertQuery("SELECT approx_distinct(custkey, 0.023) FROM orders", "SELECT 996");
        this.assertQuery("SELECT approx_distinct(CAST(custkey AS DOUBLE)) FROM orders", "SELECT 1031");
        this.assertQuery("SELECT approx_distinct(CAST(custkey AS DOUBLE), 0.023) FROM orders", "SELECT 1031");
        this.assertQuery("SELECT approx_distinct(CAST(custkey AS VARCHAR)) FROM orders", "SELECT 1011");
        this.assertQuery("SELECT approx_distinct(CAST(custkey AS VARCHAR), 0.023) FROM orders", "SELECT 1011");
        this.assertQuery("SELECT approx_distinct(to_utf8(CAST(custkey AS VARCHAR))) FROM orders", "SELECT 1011");
        this.assertQuery("SELECT approx_distinct(to_utf8(CAST(custkey AS VARCHAR)), 0.023) FROM orders", "SELECT 1011");
    }

    @Test
    public void testApproximateCountDistinctGroupBy() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, approx_distinct(custkey) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 995L}).row(new Object[]{"F", 993L}).row(new Object[]{"P", 303L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testApproximateCountDistinctGroupByWithStandardError() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, approx_distinct(custkey, 0.023) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 995L}).row(new Object[]{"F", 993L}).row(new Object[]{"P", 303L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testCountBoolean() {
        this.assertQuery("SELECT COUNT(true) FROM orders");
    }

    @Test
    public void testJoinWithMultiFieldGroupBy() {
        this.assertQuery("SELECT orderstatus FROM lineitem JOIN (SELECT DISTINCT orderkey, orderstatus FROM ORDERS) T on lineitem.orderkey = T.orderkey");
    }

    @Test
    public void testGroupByRepeatedField() {
        this.assertQuery("SELECT sum(custkey) FROM orders GROUP BY orderstatus, orderstatus");
    }

    @Test
    public void testGroupByRepeatedField2() {
        this.assertQuery("SELECT count(*) FROM (select orderstatus a, orderstatus b FROM orders) GROUP BY a, b");
    }

    @Test
    public void testGroupByMultipleFieldsWithPredicateOnAggregationArgument() {
        this.assertQuery("SELECT custkey, orderstatus, MAX(orderkey) FROM ORDERS WHERE orderkey = 1 GROUP BY custkey, orderstatus");
    }

    @Test
    public void testReorderOutputsOfGroupByAggregation() {
        this.assertQuery("SELECT orderstatus, a, custkey, b FROM (SELECT custkey, orderstatus, -COUNT(*) a, MAX(orderkey) b FROM ORDERS WHERE orderkey = 1 GROUP BY custkey, orderstatus) T");
    }

    @Test
    public void testGroupAggregationOverNestedGroupByAggregation() {
        this.assertQuery("SELECT sum(custkey), max(orderstatus), min(c) FROM (SELECT orderstatus, custkey, COUNT(*) c FROM ORDERS GROUP BY orderstatus, custkey) T");
    }

    @Test
    public void test15WayGroupBy() {
        this.assertQuery("SELECT     orderkey + 1, orderkey + 2, orderkey + 3, orderkey + 4, orderkey + 5,     orderkey + 6, orderkey + 7, orderkey + 8, orderkey + 9, orderkey + 10,     count(*) FROM orders GROUP BY     orderkey + 1, orderkey + 2, orderkey + 3, orderkey + 4, orderkey + 5,     orderkey + 6, orderkey + 7, orderkey + 8, orderkey + 9, orderkey + 10");
    }

    @Test
    public void testDistinctMultipleFields() {
        this.assertQuery("SELECT DISTINCT custkey, orderstatus FROM ORDERS");
    }

    @Test
    public void testDistinctJoin() {
        this.assertQuery("SELECT COUNT(DISTINCT CAST(b.quantity AS BIGINT)), a.orderstatus FROM orders a JOIN lineitem b ON a.orderkey = b.orderkey GROUP BY a.orderstatus");
    }

    @Test
    public void testArithmeticNegation() {
        this.assertQuery("SELECT -custkey FROM orders");
    }

    @Test
    public void testDistinct() {
        this.assertQuery("SELECT DISTINCT custkey FROM orders");
    }

    @Test
    public void testDistinctGroupBy() {
        this.assertQuery("SELECT COUNT(DISTINCT clerk) as count, orderdate FROM orders GROUP BY orderdate ORDER BY count, orderdate");
    }

    @Test
    public void testSingleDistinctOptimizer() {
        this.assertQuery("SELECT custkey, orderstatus, COUNT(DISTINCT orderkey) FROM orders GROUP BY custkey, orderstatus");
        this.assertQuery("SELECT custkey, orderstatus, COUNT(DISTINCT orderkey), SUM(DISTINCT orderkey) FROM orders GROUP BY custkey, orderstatus");
        this.assertQuery("SELECT custkey, COUNT(DISTINCT orderstatus) FROM (   SELECT orders.custkey AS custkey, orders.orderstatus AS orderstatus    FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = lineitem.partkey    GROUP BY orders.custkey, orders.orderstatus) GROUP BY custkey");
        this.assertQuery("SELECT custkey, COUNT(DISTINCT orderkey), COUNT(DISTINCT orderstatus) FROM orders GROUP BY custkey");
        this.assertQuery("SELECT SUM(DISTINCT x) FROM (SELECT custkey, COUNT(DISTINCT orderstatus) x FROM orders GROUP BY custkey) t");
    }

    @Test
    public void testExtractDistinctAggregationOptimizer() {
        this.assertQuery("SELECT max(orderstatus), COUNT(orderkey), sum(DISTINCT orderkey) FROM orders");
        this.assertQuery("SELECT custkey, orderstatus, avg(shippriority), SUM(DISTINCT orderkey) FROM orders GROUP BY custkey, orderstatus");
        this.assertQuery("SELECT s, MAX(custkey), SUM(a) FROM (    SELECT custkey, avg(shippriority) as a, SUM(DISTINCT orderkey) as s FROM orders GROUP BY custkey, orderstatus) GROUP BY s");
        this.assertQuery("SELECT max(orderstatus), COUNT(distinct orderkey), sum(DISTINCT orderkey) FROM orders");
        this.assertQuery("SELECT max(orderstatus), COUNT(distinct shippriority), sum(DISTINCT orderkey) FROM orders");
        this.assertQuery("SELECT COUNT(tan(shippriority)), sum(DISTINCT orderkey) FROM orders");
        this.assertQuery("SELECT count(DISTINCT a), max(b) FROM (VALUES (row(1, 2), 3)) t(a, b)", "VALUES (1, 3)");
    }

    @Test
    public void testDistinctHaving() {
        this.assertQuery("SELECT COUNT(DISTINCT clerk) AS count FROM orders GROUP BY orderdate HAVING COUNT(DISTINCT clerk) > 1");
    }

    @Test
    public void testAggregationFilter() {
        this.assertQuery("SELECT sum(x) FILTER (WHERE y > 4) FROM (VALUES (1, 3), (2, 4), (2, 4), (4, 5)) t (x, y)", "SELECT 4");
        this.assertQuery("SELECT sum(x) FILTER (WHERE x > 1), sum(y) FILTER (WHERE y > 4) FROM (VALUES (1, 3), (2, 4), (2, 4), (4, 5)) t (x, y)", "SELECT 8, 5");
        this.assertQuery("SELECT sum(x) FILTER (WHERE x > 1), sum(x) FROM (VALUES (1), (2), (2), (4)) t (x)", "SELECT 8, 9");
        this.assertQuery("SELECT count(*) FILTER (WHERE x > 1), sum(x) FROM (VALUES (1, 3), (2, 4), (2, 4), (4, 5)) t (x, y)", "SELECT 3, 9");
        this.assertQuery("SELECT count(*) FILTER (WHERE x > 1), count(DISTINCT y) FROM (VALUES (1, 10), (2, 10), (3, 10), (4, 20)) t (x, y)", "SELECT 3, 2");
        this.assertQuery("SELECT sum(b) FILTER (WHERE true) FROM (SELECT count(*) FILTER (WHERE true) AS b)", "SELECT 1");
    }

    @Test
    public void testDistinctWindow() {
        MaterializedResult actual = this.computeActual("SELECT RANK() OVER (PARTITION BY orderdate ORDER BY COUNT(DISTINCT clerk)) rnk FROM orders GROUP BY orderdate, custkey ORDER BY rnk LIMIT 1");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1L}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testDistinctWhere() {
        this.assertQuery("SELECT COUNT(DISTINCT clerk) FROM orders WHERE LENGTH(clerk) > 5");
    }

    @Test
    public void testMultipleDifferentDistinct() {
        this.assertQuery("SELECT COUNT(DISTINCT orderstatus), SUM(DISTINCT custkey) FROM orders");
    }

    @Test
    public void testMultipleDistinct() {
        this.assertQuery("SELECT COUNT(DISTINCT custkey), SUM(DISTINCT custkey) FROM orders", "SELECT COUNT(*), SUM(custkey) FROM (SELECT DISTINCT custkey FROM orders) t");
    }

    @Test
    public void testComplexDistinct() {
        this.assertQuery("SELECT COUNT(DISTINCT custkey), SUM(DISTINCT custkey), SUM(DISTINCT custkey + 1.0), AVG(DISTINCT custkey), VARIANCE(DISTINCT custkey) FROM orders", "SELECT COUNT(*), SUM(custkey), SUM(custkey + 1.0), AVG(custkey), VARIANCE(custkey) FROM (SELECT DISTINCT custkey FROM orders) t");
    }

    @Test
    public void testDistinctLimit() {
        this.assertQuery("SELECT DISTINCT orderstatus, custkey FROM (SELECT orderstatus, custkey FROM orders ORDER BY orderkey LIMIT 10) LIMIT 10");
        this.assertQuery("SELECT COUNT(*) FROM (SELECT DISTINCT orderstatus, custkey FROM orders LIMIT 10)");
        this.assertQuery("SELECT DISTINCT custkey, orderstatus FROM orders WHERE custkey = 1268 LIMIT 2");
        this.assertQuery("SELECT DISTINCT x FROM (VALUES 1) t(x) JOIN (VALUES 10, 20) u(a) ON t.x < u.a LIMIT 100", "SELECT 1");
    }

    @Test
    public void testCountDistinct() {
        this.assertQuery("SELECT COUNT(DISTINCT custkey + 1) FROM orders", "SELECT COUNT(*) FROM (SELECT DISTINCT custkey + 1 FROM orders) t");
    }

    @Test
    public void testDistinctWithOrderBy() {
        this.assertQueryOrdered("SELECT DISTINCT custkey FROM orders ORDER BY custkey LIMIT 10");
    }

    @Test
    public void testDistinctWithOrderByNotInSelect() {
        this.assertQueryFails("SELECT DISTINCT custkey FROM orders ORDER BY orderkey LIMIT 10", "line 1:1: For SELECT DISTINCT, ORDER BY expressions must appear in select list");
    }

    @Test
    public void testOrderByLimit() {
        this.assertQueryOrdered("SELECT custkey, orderstatus FROM ORDERS ORDER BY orderkey DESC LIMIT 10");
    }

    @Test
    public void testOrderByExpressionWithLimit() {
        this.assertQueryOrdered("SELECT custkey, orderstatus FROM ORDERS ORDER BY orderkey + 1 DESC LIMIT 10");
    }

    @Test
    public void testOrderByWithOutputColumnReference() {
        this.assertQueryOrdered("SELECT a*2 AS b FROM (VALUES -1, 0, 2) t(a) ORDER BY b*-1", "VALUES 4, 0, -2");
        this.assertQueryOrdered("SELECT a*2 AS b FROM (VALUES -1, 0, 2) t(a) ORDER BY b", "VALUES -2, 0, 4");
        this.assertQueryOrdered("SELECT a*-2 AS a FROM (VALUES -1, 0, 2) t(a) ORDER BY a*-1", "VALUES 2, 0, -4");
        this.assertQueryOrdered("SELECT a*-2 AS a FROM (VALUES -1, 0, 2) t(a) ORDER BY t.a*-1", "VALUES -4, 0, 2");
        this.assertQueryOrdered("SELECT a*-2 FROM (VALUES -1, 0, 2) t(a) ORDER BY a*-1", "VALUES -4, 0, 2");
        this.assertQueryOrdered("SELECT a*-2 FROM (VALUES -1, 0, 2) t(a) ORDER BY t.a*-1", "VALUES -4, 0, 2");
        this.assertQueryOrdered("SELECT a, a* -1 AS a FROM (VALUES -1, 0, 2) t(a) ORDER BY t.a", "VALUES (-1, 1), (0, 0), (2, -2)");
        this.assertQueryOrdered("SELECT a, a* -2 AS b FROM (VALUES -1, 0, 2) t(a) ORDER BY a + b", "VALUES (2, -4), (0, 0), (-1, 2)");
        this.assertQueryOrdered("SELECT a as b, a* -2 AS a FROM (VALUES -1, 0, 2) t(a) ORDER BY a + b", "VALUES (2, -4), (0, 0), (-1, 2)");
        this.assertQueryOrdered("SELECT a* -2 AS a FROM (VALUES -1, 0, 2) t(a) ORDER BY a + t.a", "VALUES -4, 0, 2");
        this.assertQueryFails("SELECT a, a* -1 AS a FROM (VALUES -1, 0, 2) t(a) ORDER BY a", ".*'a' is ambiguous");
    }

    @Test
    public void testOrderByWithAggregation() throws Exception {
        this.assertQuery("SELECT x, sum(cast(x AS double))\nFROM (VALUES '1.0') t(x)\nGROUP BY x\nORDER BY sum(cast(x AS double))", "VALUES ('1.0', 1.0)");
    }

    @Test
    public void testGroupByOrderByLimit() {
        this.assertQueryOrdered("SELECT custkey, SUM(totalprice) FROM ORDERS GROUP BY custkey ORDER BY SUM(totalprice) DESC LIMIT 10");
    }

    @Test
    public void testLimitZero() {
        this.assertQuery("SELECT custkey, totalprice FROM orders LIMIT 0");
    }

    @Test
    public void testLimitAll() {
        this.assertQuery("SELECT custkey, totalprice FROM orders LIMIT ALL", "SELECT custkey, totalprice FROM orders");
    }

    @Test
    public void testOrderByLimitZero() {
        this.assertQuery("SELECT custkey, totalprice FROM orders ORDER BY orderkey LIMIT 0");
    }

    @Test
    public void testOrderByLimitAll() {
        this.assertQuery("SELECT custkey, totalprice FROM orders ORDER BY orderkey LIMIT ALL", "SELECT custkey, totalprice FROM orders ORDER BY orderkey");
    }

    @Test
    public void testRepeatedAggregations() {
        this.assertQuery("SELECT SUM(orderkey), SUM(orderkey) FROM ORDERS");
    }

    @Test
    public void testRepeatedOutputs() {
        this.assertQuery("SELECT orderkey a, orderkey b FROM ORDERS WHERE orderstatus = 'F'");
    }

    @Test
    public void testRepeatedOutputs2() {
        this.assertQuery("SELECT orderdate, orderdate, orderkey FROM orders");
    }

    @Test
    public void testLimit() {
        MaterializedResult actual = this.computeActual("SELECT orderkey FROM ORDERS LIMIT 10");
        MaterializedResult all = this.computeExpected("SELECT orderkey FROM ORDERS", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testAggregationWithLimit() {
        MaterializedResult actual = this.computeActual("SELECT custkey, SUM(totalprice) FROM ORDERS GROUP BY custkey LIMIT 10");
        MaterializedResult all = this.computeExpected("SELECT custkey, SUM(totalprice) FROM ORDERS GROUP BY custkey", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testLimitInInlineView() {
        MaterializedResult actual = this.computeActual("SELECT orderkey FROM (SELECT orderkey FROM ORDERS LIMIT 100) T LIMIT 10");
        MaterializedResult all = this.computeExpected("SELECT orderkey FROM ORDERS", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testCountAll() {
        this.assertQuery("SELECT COUNT(*) FROM ORDERS");
        this.assertQuery("SELECT COUNT(42) FROM ORDERS", "SELECT COUNT(*) FROM ORDERS");
        this.assertQuery("SELECT COUNT(42 + 42) FROM ORDERS", "SELECT COUNT(*) FROM ORDERS");
        this.assertQuery("SELECT COUNT(null) FROM ORDERS", "SELECT 0");
    }

    @Test
    public void testCountColumn() {
        this.assertQuery("SELECT COUNT(orderkey) FROM ORDERS");
        this.assertQuery("SELECT COUNT(orderstatus) FROM ORDERS");
        this.assertQuery("SELECT COUNT(orderdate) FROM ORDERS");
        this.assertQuery("SELECT COUNT(1) FROM ORDERS");
        this.assertQuery("SELECT COUNT(NULLIF(orderstatus, 'F')) FROM ORDERS");
        this.assertQuery("SELECT COUNT(CAST(NULL AS BIGINT)) FROM ORDERS");
    }

    @Test
    public void testWildcard() {
        this.assertQuery("SELECT * FROM ORDERS");
    }

    @Test
    public void testMultipleWildcards() {
        this.assertQuery("SELECT *, 123, * FROM ORDERS");
    }

    @Test
    public void testMixedWildcards() {
        this.assertQuery("SELECT *, orders.*, orderkey FROM orders");
    }

    @Test
    public void testQualifiedWildcardFromAlias() {
        this.assertQuery("SELECT T.* FROM ORDERS T");
    }

    @Test
    public void testQualifiedWildcardFromInlineView() {
        this.assertQuery("SELECT T.* FROM (SELECT orderkey + custkey FROM ORDERS) T");
    }

    @Test
    public void testQualifiedWildcard() {
        this.assertQuery("SELECT ORDERS.* FROM ORDERS");
    }

    @Test
    public void testAverageAll() {
        this.assertQuery("SELECT AVG(totalprice) FROM ORDERS");
    }

    @Test
    public void testVariance() {
        this.assertQuery("SELECT VAR_SAMP(custkey) FROM ORDERS");
        this.assertQuery("SELECT VAR_SAMP(custkey) FROM (SELECT custkey FROM ORDERS ORDER BY custkey LIMIT 2) T");
        this.assertQuery("SELECT VAR_SAMP(custkey) FROM (SELECT custkey FROM ORDERS ORDER BY custkey LIMIT 1) T");
        this.assertQuery("SELECT VAR_SAMP(custkey) FROM (SELECT custkey FROM ORDERS LIMIT 0) T");
        this.assertQuery("SELECT VAR_SAMP(totalprice) FROM ORDERS");
        this.assertQuery("SELECT VAR_SAMP(totalprice) FROM (SELECT totalprice FROM ORDERS ORDER BY totalprice LIMIT 2) T");
        this.assertQuery("SELECT VAR_SAMP(totalprice) FROM (SELECT totalprice FROM ORDERS ORDER BY totalprice LIMIT 1) T");
        this.assertQuery("SELECT VAR_SAMP(totalprice) FROM (SELECT totalprice FROM ORDERS LIMIT 0) T");
    }

    @Test
    public void testVariancePop() {
        this.assertQuery("SELECT VAR_POP(custkey) FROM ORDERS");
        this.assertQuery("SELECT VAR_POP(custkey) FROM (SELECT custkey FROM ORDERS ORDER BY custkey LIMIT 2) T");
        this.assertQuery("SELECT VAR_POP(custkey) FROM (SELECT custkey FROM ORDERS ORDER BY custkey LIMIT 1) T");
        this.assertQuery("SELECT VAR_POP(custkey) FROM (SELECT custkey FROM ORDERS LIMIT 0) T");
        this.assertQuery("SELECT VAR_POP(totalprice) FROM ORDERS");
        this.assertQuery("SELECT VAR_POP(totalprice) FROM (SELECT totalprice FROM ORDERS ORDER BY totalprice LIMIT 2) T");
        this.assertQuery("SELECT VAR_POP(totalprice) FROM (SELECT totalprice FROM ORDERS ORDER BY totalprice LIMIT 1) T");
        this.assertQuery("SELECT VAR_POP(totalprice) FROM (SELECT totalprice FROM ORDERS LIMIT 0) T");
    }

    @Test
    public void testStdDev() {
        this.assertQuery("SELECT STDDEV_SAMP(custkey) FROM ORDERS");
        this.assertQuery("SELECT STDDEV_SAMP(custkey) FROM (SELECT custkey FROM ORDERS ORDER BY custkey LIMIT 2) T");
        this.assertQuery("SELECT STDDEV_SAMP(custkey) FROM (SELECT custkey FROM ORDERS ORDER BY custkey LIMIT 1) T");
        this.assertQuery("SELECT STDDEV_SAMP(custkey) FROM (SELECT custkey FROM ORDERS LIMIT 0) T");
        this.assertQuery("SELECT STDDEV_SAMP(totalprice) FROM ORDERS");
        this.assertQuery("SELECT STDDEV_SAMP(totalprice) FROM (SELECT totalprice FROM ORDERS ORDER BY totalprice LIMIT 2) T");
        this.assertQuery("SELECT STDDEV_SAMP(totalprice) FROM (SELECT totalprice FROM ORDERS ORDER BY totalprice LIMIT 1) T");
        this.assertQuery("SELECT STDDEV_SAMP(totalprice) FROM (SELECT totalprice FROM ORDERS LIMIT 0) T");
    }

    @Test
    public void testStdDevPop() {
        this.assertQuery("SELECT STDDEV_POP(custkey) FROM ORDERS");
        this.assertQuery("SELECT STDDEV_POP(custkey) FROM (SELECT custkey FROM ORDERS ORDER BY custkey LIMIT 2) T");
        this.assertQuery("SELECT STDDEV_POP(custkey) FROM (SELECT custkey FROM ORDERS ORDER BY custkey LIMIT 1) T");
        this.assertQuery("SELECT STDDEV_POP(custkey) FROM (SELECT custkey FROM ORDERS LIMIT 0) T");
        this.assertQuery("SELECT STDDEV_POP(totalprice) FROM ORDERS");
        this.assertQuery("SELECT STDDEV_POP(totalprice) FROM (SELECT totalprice FROM ORDERS ORDER BY totalprice LIMIT 2) T");
        this.assertQuery("SELECT STDDEV_POP(totalprice) FROM (SELECT totalprice FROM ORDERS ORDER BY totalprice LIMIT 1) T");
        this.assertQuery("SELECT STDDEV_POP(totalprice) FROM (SELECT totalprice FROM ORDERS LIMIT 0) T");
    }

    @Test
    public void testCountAllWithPredicate() {
        this.assertQuery("SELECT COUNT(*) FROM ORDERS WHERE orderstatus = 'F'");
    }

    @Test
    public void testGroupByArray() {
        this.assertQuery("SELECT col[1], count FROM (SELECT ARRAY[custkey] col, COUNT(*) count FROM ORDERS GROUP BY 1 ORDER BY 1)", "SELECT custkey, COUNT(*) FROM orders GROUP BY custkey ORDER BY custkey");
    }

    @Test
    public void testGroupByMap() {
        this.assertQuery("SELECT col[1], count FROM (SELECT MAP(ARRAY[1], ARRAY[custkey]) col, COUNT(*) count FROM ORDERS GROUP BY 1)", "SELECT custkey, COUNT(*) FROM orders GROUP BY custkey");
    }

    @Test
    public void testGroupByComplexMap() {
        this.assertQuery("SELECT MAP_KEYS(x)[1] FROM (VALUES MAP(ARRAY['a'], ARRAY[ARRAY[1]]), MAP(ARRAY['b'], ARRAY[ARRAY[2]])) t(x) GROUP BY x", "SELECT * FROM (VALUES 'a', 'b')");
    }

    @Test
    public void testGroupByRow() {
        this.assertQuery("SELECT col.col1, count FROM (SELECT cast(row(custkey, custkey) as row(col0 bigint, col1 bigint)) col, COUNT(*) count FROM ORDERS GROUP BY 1)", "SELECT custkey, COUNT(*) FROM orders GROUP BY custkey");
    }

    @Test
    public void testJoinCoercion() {
        this.assertQuery("SELECT COUNT(*) FROM orders t join (SELECT * FROM orders LIMIT 1) t2 ON sin(t2.custkey) = 0");
    }

    @Test
    public void testJoinCoercionOnEqualityComparison() {
        this.assertQuery("SELECT o.clerk, avg(o.shippriority), COUNT(l.linenumber) FROM orders o LEFT OUTER JOIN lineitem l ON o.orderkey=l.orderkey AND o.shippriority=1 GROUP BY o.clerk");
    }

    @Test
    public void testGroupByNoAggregations() {
        this.assertQuery("SELECT custkey FROM ORDERS GROUP BY custkey");
    }

    @Test
    public void testGroupByCount() {
        this.assertQuery("SELECT orderstatus, COUNT(*) FROM ORDERS GROUP BY orderstatus", "SELECT orderstatus, CAST(COUNT(*) AS INTEGER) FROM orders GROUP BY orderstatus");
    }

    @Test
    public void testGroupByMultipleFields() {
        this.assertQuery("SELECT custkey, orderstatus, COUNT(*) FROM ORDERS GROUP BY custkey, orderstatus");
    }

    @Test
    public void testGroupByWithAlias() {
        this.assertQuery("SELECT orderdate x, COUNT(*) FROM orders GROUP BY orderdate", "SELECT orderdate x, CAST(COUNT(*) AS INTEGER) FROM orders GROUP BY orderdate");
    }

    @Test
    public void testGroupBySum() {
        this.assertQuery("SELECT suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY suppkey");
    }

    @Test
    public void testGroupByRequireIntegerCoercion() {
        this.assertQuery("SELECT partkey, COUNT(DISTINCT shipdate), SUM(linenumber) FROM lineitem GROUP BY partkey");
    }

    @Test
    public void testGroupByEmptyGroupingSet() {
        this.assertQuery("SELECT SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY ()", "SELECT SUM(CAST(quantity AS BIGINT)) FROM lineitem");
    }

    @Test
    public void testGroupByWithWildcard() {
        this.assertQuery("SELECT * FROM (SELECT orderkey FROM orders) t GROUP BY orderkey");
    }

    @Test
    public void testSingleGroupingSet() {
        this.assertQuery("SELECT linenumber, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY GROUPING SETS (linenumber)", "SELECT linenumber, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber");
    }

    @Test
    public void testGroupingSets() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY GROUPING SETS ((linenumber, suppkey), (suppkey))", "SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber, suppkey UNION SELECT NULL, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY suppkey");
    }

    @Test
    public void testGroupingSetsNoInput() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY GROUPING SETS ((linenumber, suppkey), (suppkey))", "SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY linenumber, suppkey UNION SELECT NULL, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY suppkey");
    }

    @Test
    public void testGroupingSetsWithGlobalAggregationNoInput() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY GROUPING SETS ((linenumber, suppkey), (suppkey), ())", "SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY linenumber, suppkey UNION SELECT NULL, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY suppkey UNION SELECT NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0");
    }

    @Test
    public void testGroupingSetsWithSingleDistinct() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(DISTINCT CAST(quantity AS BIGINT)) FROM lineitem GROUP BY GROUPING SETS ((linenumber, suppkey), (suppkey))", "SELECT linenumber, suppkey, SUM(DISTINCT CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber, suppkey UNION SELECT NULL, suppkey, SUM(DISTINCT CAST(quantity AS BIGINT)) FROM lineitem GROUP BY suppkey");
    }

    @Test
    public void testGroupingSetsWithMultipleDistinct() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(DISTINCT CAST(quantity AS BIGINT)), COUNT(DISTINCT linestatus) FROM lineitem GROUP BY GROUPING SETS ((linenumber, suppkey), (suppkey))", "SELECT linenumber, suppkey, SUM(DISTINCT CAST(quantity AS BIGINT)), COUNT(DISTINCT linestatus) FROM lineitem GROUP BY linenumber, suppkey UNION SELECT NULL, suppkey, SUM(DISTINCT CAST(quantity AS BIGINT)), COUNT(DISTINCT linestatus) FROM lineitem GROUP BY suppkey");
    }

    @Test
    public void testGroupingSetsWithMultipleDistinctNoInput() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(DISTINCT CAST(quantity AS BIGINT)), COUNT(DISTINCT linestatus) FROM lineitem WHERE quantity < 0 GROUP BY GROUPING SETS ((linenumber, suppkey), (suppkey))", "SELECT linenumber, suppkey, SUM(DISTINCT CAST(quantity AS BIGINT)), COUNT(DISTINCT linestatus) FROM lineitem WHERE quantity < 0 GROUP BY linenumber, suppkey UNION SELECT NULL, suppkey, SUM(DISTINCT CAST(quantity AS BIGINT)), COUNT(DISTINCT linestatus) FROM lineitem WHERE quantity < 0 GROUP BY suppkey");
    }

    @Test
    public void testGroupingSetsGrandTotalSet() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY GROUPING SETS ((linenumber, suppkey), ())", "SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber, suppkey UNION SELECT NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem");
    }

    @Test
    public void testGroupingSetsRepeatedSetsAll() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY GROUPING SETS ((), (linenumber, suppkey), (), (linenumber, suppkey))", "SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber, suppkey UNION ALL SELECT NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem UNION ALL SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber, suppkey UNION ALL SELECT NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem");
    }

    @Test
    public void testGroupingSetsRepeatedSetsAllNoInput() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY GROUPING SETS ((), (linenumber, suppkey), (), (linenumber, suppkey))", "SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY linenumber, suppkey UNION ALL SELECT NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 UNION ALL SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY linenumber, suppkey UNION ALL SELECT NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0");
    }

    @Test
    public void testGroupingSetsRepeatedSetsDistinct() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY DISTINCT GROUPING SETS ((), (linenumber, suppkey), (), (linenumber, suppkey))", "SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber, suppkey UNION ALL SELECT NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem");
    }

    @Test
    public void testGroupingSetsGrandTotalSetFirst() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY GROUPING SETS ((), (linenumber), (linenumber, suppkey))", "SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber, suppkey UNION ALL SELECT linenumber, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber UNION ALL SELECT NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem");
    }

    @Test
    public void testGroupingSetsOnlyGrandTotalSet() {
        this.assertQuery("SELECT SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY GROUPING SETS (())", "SELECT SUM(CAST(quantity AS BIGINT)) FROM lineitem");
    }

    @Test
    public void testGroupingSetsMultipleGrandTotalSets() {
        this.assertQuery("SELECT SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY GROUPING SETS ((), ())", "SELECT SUM(CAST(quantity AS BIGINT)) FROM lineitem UNION ALL SELECT SUM(CAST(quantity AS BIGINT)) FROM lineitem");
    }

    @Test
    public void testGroupingSetsMultipleGrandTotalSetsNoInput() {
        this.assertQuery("SELECT SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY GROUPING SETS ((), ())", "SELECT SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 UNION ALL SELECT SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0");
    }

    @Test
    public void testGroupingSetsAliasedGroupingColumns() {
        this.assertQuery("SELECT lna, lnb, SUM(quantity) FROM (SELECT linenumber lna, linenumber lnb, CAST(quantity AS BIGINT) quantity FROM lineitem) GROUP BY GROUPING SETS ((lna, lnb), (lna), (lnb), ())", "SELECT linenumber, linenumber, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber UNION ALL SELECT linenumber, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber UNION ALL SELECT NULL, linenumber, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber UNION ALL SELECT NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem");
    }

    @Test
    public void testGroupingSetMixedExpressionAndColumn() {
        this.assertQuery("SELECT suppkey, month(shipdate), SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY month(shipdate), ROLLUP(suppkey)", "SELECT suppkey, month(shipdate), SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY month(shipdate), suppkey UNION ALL SELECT NULL, month(shipdate), SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY month(shipdate)");
    }

    @Test
    public void testGroupingSetMixedExpressionAndOrdinal() {
        this.assertQuery("SELECT suppkey, month(shipdate), SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY 2, ROLLUP(suppkey)", "SELECT suppkey, month(shipdate), SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY month(shipdate), suppkey UNION ALL SELECT NULL, month(shipdate), SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY month(shipdate)");
    }

    @Test
    public void testGroupingSetSubsetAndPartitioning() {
        this.assertQuery("SELECT COUNT_IF(x IS NULL) FROM (SELECT x, y, COUNT(z) FROM (SELECT CAST(lineitem.orderkey AS BIGINT) x, lineitem.linestatus y, SUM(lineitem.quantity) z FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey GROUP BY 1, 2) GROUP BY GROUPING SETS ((x, y), ()))", "SELECT 1");
    }

    @Test
    public void testGroupingSetPredicatePushdown() {
        this.assertQuery("SELECT * FROM (SELECT COALESCE(orderpriority, 'ALL'), COALESCE(shippriority, -1) sp FROM (SELECT orderpriority, shippriority, COUNT(1) FROM orders GROUP BY GROUPING SETS ((orderpriority), (shippriority)))) WHERE sp=-1", "SELECT orderpriority, -1 FROM orders GROUP BY orderpriority");
    }

    @Test
    public void testGroupingSetsAggregateOnGroupedColumn() {
        this.assertQuery("SELECT orderpriority, COUNT(orderpriority) FROM orders GROUP BY ROLLUP (orderpriority)", "SELECT orderpriority, COUNT(orderpriority) FROM orders GROUP BY orderpriority UNION SELECT NULL, COUNT(orderpriority) FROM orders");
    }

    @Test
    public void testGroupingSetsMultipleAggregatesOnGroupedColumn() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(suppkey), COUNT(linenumber), SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY GROUPING SETS ((linenumber, suppkey), ())", "SELECT linenumber, suppkey, SUM(suppkey), COUNT(linenumber), SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber, suppkey UNION SELECT NULL, NULL, SUM(suppkey), COUNT(linenumber), SUM(CAST(quantity AS BIGINT)) FROM lineitem");
    }

    @Test
    public void testGroupingSetsMultipleAggregatesOnUngroupedColumn() {
        this.assertQuery("SELECT linenumber, suppkey, COUNT(CAST(quantity AS BIGINT)), SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY GROUPING SETS ((linenumber, suppkey), ())", "SELECT linenumber, suppkey, COUNT(CAST(quantity AS BIGINT)), SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber, suppkey UNION SELECT NULL, NULL, COUNT(CAST(quantity AS BIGINT)), SUM(CAST(quantity AS BIGINT)) FROM lineitem");
    }

    @Test
    public void testGroupingSetsMultipleAggregatesWithGroupedColumns() {
        this.assertQuery("SELECT linenumber, suppkey, COUNT(linenumber), SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY GROUPING SETS ((linenumber, suppkey), ())", "SELECT linenumber, suppkey, COUNT(linenumber), SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber, suppkey UNION SELECT NULL, NULL, COUNT(linenumber), SUM(CAST(quantity AS BIGINT)) FROM lineitem");
    }

    @Test
    public void testGroupingSetsWithSingleDistinctAndUnion() {
        this.assertQuery("SELECT suppkey, COUNT(DISTINCT linenumber) FROM (SELECT * FROM lineitem WHERE linenumber%2 = 0 UNION ALL SELECT * FROM lineitem WHERE linenumber%2 = 1) GROUP BY GROUPING SETS ((suppkey), ())", "SELECT suppkey, COUNT(DISTINCT linenumber) FROM lineitem GROUP BY suppkey UNION ALL SELECT NULL, COUNT(DISTINCT linenumber) FROM lineitem");
    }

    @Test
    public void testGroupingSetsWithSingleDistinctAndUnionGroupedArguments() {
        this.assertQuery("SELECT linenumber, COUNT(DISTINCT linenumber) FROM (SELECT * FROM lineitem WHERE linenumber%2 = 0 UNION ALL SELECT * FROM lineitem WHERE linenumber%2 = 1) GROUP BY GROUPING SETS ((linenumber), ())", "SELECT DISTINCT linenumber, 1 FROM lineitem UNION ALL SELECT NULL, COUNT(DISTINCT linenumber) FROM lineitem");
    }

    @Test
    public void testGroupingSetsWithMultipleDistinctAndUnion() {
        this.assertQuery("SELECT linenumber, COUNT(DISTINCT linenumber), SUM(DISTINCT suppkey) FROM (SELECT * FROM lineitem WHERE linenumber%2 = 0 UNION ALL SELECT * FROM lineitem WHERE linenumber%2 = 1) GROUP BY GROUPING SETS ((linenumber), ())", "SELECT linenumber, 1, SUM(DISTINCT suppkey) FROM lineitem GROUP BY linenumber UNION ALL SELECT NULL, COUNT(DISTINCT linenumber), SUM(DISTINCT suppkey) FROM lineitem");
    }

    @Test
    public void testRollup() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY ROLLUP (linenumber, suppkey)", "SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber, suppkey UNION ALL SELECT linenumber, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber UNION ALL SELECT NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem");
    }

    @Test
    public void testCube() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY CUBE (linenumber, suppkey)", "SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber, suppkey UNION ALL SELECT linenumber, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber UNION ALL SELECT NULL, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY suppkey UNION ALL SELECT NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem");
    }

    @Test
    public void testCubeNoInput() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY CUBE (linenumber, suppkey)", "SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY linenumber, suppkey UNION ALL SELECT linenumber, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY linenumber UNION ALL SELECT NULL, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY suppkey UNION ALL SELECT NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0");
    }

    @Test
    public void testGroupingCombinationsAll() {
        this.assertQuery("SELECT orderkey, partkey, suppkey, linenumber, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY orderkey, partkey, ROLLUP (suppkey, linenumber), CUBE (linenumber)", "SELECT orderkey, partkey, suppkey, linenumber, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY orderkey, suppkey, linenumber UNION ALL SELECT orderkey, partkey, suppkey, linenumber, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY orderkey, partkey, suppkey, linenumber UNION ALL SELECT orderkey, partkey, NULL, linenumber, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY orderkey, partkey, linenumber UNION ALL SELECT orderkey, partkey, suppkey, linenumber, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY orderkey, partkey, suppkey, linenumber UNION ALL SELECT orderkey, partkey, suppkey, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY orderkey, partkey, suppkey UNION ALL SELECT orderkey, partkey, NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY orderkey, partkey");
    }

    @Test
    public void testGroupingCombinationsDistinct() {
        this.assertQuery("SELECT orderkey, partkey, suppkey, linenumber, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY DISTINCT orderkey, partkey, ROLLUP (suppkey, linenumber), CUBE (linenumber)", "SELECT orderkey, partkey, suppkey, linenumber, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY orderkey, suppkey, linenumber UNION ALL SELECT orderkey, partkey, NULL, linenumber, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY orderkey, partkey, linenumber UNION ALL SELECT orderkey, partkey, suppkey, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY orderkey, partkey, suppkey UNION ALL SELECT orderkey, partkey, NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY orderkey, partkey");
    }

    @Test
    public void testRollupOverUnion() {
        this.assertQuery("SELECT orderstatus, sum(orderkey)\nFROM (SELECT orderkey, orderstatus\n      FROM orders\n      UNION ALL\n      SELECT orderkey, orderstatus\n      FROM orders) x\nGROUP BY ROLLUP (orderstatus)", "VALUES ('P', 21470000),\n('O', 439774330),\n('F', 438500670),\n(NULL, 899745000)");
    }

    @Test
    public void testIntersect() {
        this.assertQuery("SELECT regionkey FROM nation WHERE nationkey < 7 INTERSECT select regionkey FROM nation WHERE nationkey > 21");
        this.assertQuery("SELECT regionkey FROM nation WHERE nationkey < 7 INTERSECT DISTINCT SELECT regionkey FROM nation WHERE nationkey > 21", "VALUES 1, 3");
        this.assertQuery("WITH wnation AS (SELECT nationkey, regionkey FROM nation) SELECT regionkey FROM wnation WHERE nationkey < 7 INTERSECT SELECT regionkey FROM wnation WHERE nationkey > 21", "VALUES 1, 3");
        this.assertQuery("SELECT num FROM (SELECT 1 as num FROM nation WHERE nationkey=10 INTERSECT SELECT 1 FROM nation WHERE nationkey=20) T");
        this.assertQuery("SELECT nationkey, nationkey / 2 FROM (SELECT nationkey FROM nation WHERE nationkey < 10 INTERSECT SELECT nationkey FROM nation WHERE nationkey > 4) T WHERE nationkey % 2 = 0");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 INTERSECT SELECT regionkey FROM nation WHERE nationkey > 21) UNION SELECT 4");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 UNION SELECT regionkey FROM nation WHERE nationkey > 21) INTERSECT SELECT 1");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 INTERSECT SELECT regionkey FROM nation WHERE nationkey > 21) UNION ALL SELECT 3");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 INTERSECT SELECT regionkey FROM nation WHERE nationkey > 21) UNION ALL SELECT 3");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) INTERSECT SELECT * FROM (VALUES 1.0, 2)", "VALUES 1.0, 2.0");
        this.assertQuery("SELECT NULL, NULL INTERSECT SELECT NULL, NULL FROM nation");
        MaterializedResult emptyResult = this.computeActual("SELECT 100 INTERSECT (SELECT regionkey FROM nation WHERE nationkey <10)");
        Assert.assertEquals((int)emptyResult.getMaterializedRows().size(), (int)0);
    }

    @Test
    public void testIntersectWithAggregation() {
        this.assertQuery("SELECT COUNT(*) FROM nation INTERSECT SELECT COUNT(regionkey) FROM nation HAVING SUM(regionkey) IS NOT NULL");
        this.assertQuery("SELECT SUM(nationkey), COUNT(name) FROM (SELECT nationkey,name FROM nation INTERSECT SELECT regionkey, name FROM nation) n");
        this.assertQuery("SELECT COUNT(*) * 2 FROM nation INTERSECT (SELECT SUM(nationkey) FROM nation GROUP BY regionkey ORDER BY 1 LIMIT 2)");
        this.assertQuery("SELECT COUNT(a) FROM (SELECT nationkey AS a FROM (SELECT nationkey FROM nation INTERSECT SELECT regionkey FROM nation) n1 INTERSECT SELECT regionkey FROM nation) n2");
        this.assertQuery("SELECT COUNT(*), SUM(2), regionkey FROM (SELECT nationkey, regionkey FROM nation INTERSECT SELECT regionkey, regionkey FROM nation) n GROUP BY regionkey");
        this.assertQuery("SELECT COUNT(*) FROM (SELECT nationkey FROM nation INTERSECT SELECT 2) n1 INTERSECT SELECT regionkey FROM nation");
    }

    @Test
    public void testIntersectAllFails() {
        this.assertQueryFails("SELECT * FROM (VALUES 1, 2, 3, 4) INTERSECT ALL SELECT * FROM (VALUES 3, 4)", "line 1:35: INTERSECT ALL not yet implemented");
    }

    @Test
    public void testExcept() {
        this.assertQuery("SELECT regionkey FROM nation WHERE nationkey < 7 EXCEPT select regionkey FROM nation WHERE nationkey > 21");
        this.assertQuery("SELECT regionkey FROM nation WHERE nationkey < 7 EXCEPT DISTINCT SELECT regionkey FROM nation WHERE nationkey > 21", "VALUES 0, 4");
        this.assertQuery("WITH wnation AS (SELECT nationkey, regionkey FROM nation) SELECT regionkey FROM wnation WHERE nationkey < 7 EXCEPT SELECT regionkey FROM wnation WHERE nationkey > 21", "VALUES 0, 4");
        this.assertQuery("SELECT num FROM (SELECT 1 as num FROM nation WHERE nationkey=10 EXCEPT SELECT 2 FROM nation WHERE nationkey=20) T");
        this.assertQuery("SELECT nationkey, nationkey / 2 FROM (SELECT nationkey FROM nation WHERE nationkey < 10 EXCEPT SELECT nationkey FROM nation WHERE nationkey > 4) T WHERE nationkey % 2 = 0");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 EXCEPT SELECT regionkey FROM nation WHERE nationkey > 21) UNION SELECT 3");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 UNION SELECT regionkey FROM nation WHERE nationkey > 21) EXCEPT SELECT 1");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 EXCEPT SELECT regionkey FROM nation WHERE nationkey > 21) UNION ALL SELECT 4");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) EXCEPT SELECT * FROM (VALUES 3.0, 2)");
        this.assertQuery("SELECT NULL, NULL EXCEPT SELECT NULL, NULL FROM nation");
        this.assertQuery("(SELECT * FROM (VALUES 1) EXCEPT SELECT * FROM (VALUES 0))EXCEPT (SELECT * FROM (VALUES 1) EXCEPT SELECT * FROM (VALUES 1))");
        MaterializedResult emptyResult = this.computeActual("SELECT 0 EXCEPT (SELECT regionkey FROM nation WHERE nationkey <10)");
        Assert.assertEquals((int)emptyResult.getMaterializedRows().size(), (int)0);
    }

    @Test
    public void testExceptWithAggregation() {
        this.assertQuery("SELECT COUNT(*) FROM nation EXCEPT SELECT COUNT(regionkey) FROM nation where regionkey < 3 HAVING SUM(regionkey) IS NOT NULL");
        this.assertQuery("SELECT SUM(nationkey), COUNT(name) FROM (SELECT nationkey, name FROM nation where nationkey < 6 EXCEPT SELECT regionkey, name FROM nation) n");
        this.assertQuery("(SELECT SUM(nationkey) FROM nation GROUP BY regionkey ORDER BY 1 LIMIT 2) EXCEPT SELECT COUNT(*) * 2 FROM nation");
        this.assertQuery("SELECT COUNT(a) FROM (SELECT nationkey AS a FROM (SELECT nationkey FROM nation EXCEPT SELECT regionkey FROM nation) n1 EXCEPT SELECT regionkey FROM nation) n2");
        this.assertQuery("SELECT COUNT(*), SUM(2), regionkey FROM (SELECT nationkey, regionkey FROM nation EXCEPT SELECT regionkey, regionkey FROM nation) n GROUP BY regionkey HAVING regionkey < 3");
        this.assertQuery("SELECT COUNT(*) FROM (SELECT nationkey FROM nation EXCEPT SELECT 10) n1 EXCEPT SELECT regionkey FROM nation");
    }

    @Test
    public void testExceptAllFails() {
        this.assertQueryFails("SELECT * FROM (VALUES 1, 2, 3, 4) EXCEPT ALL SELECT * FROM (VALUES 3, 4)", "line 1:35: EXCEPT ALL not yet implemented");
    }

    @Test
    public void testCountAllWithComparison() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE tax < discount");
    }

    @Test
    public void testSelectWithComparison() {
        this.assertQuery("SELECT orderkey FROM lineitem WHERE tax < discount");
    }

    @Test
    public void testCountWithNotPredicate() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE NOT tax < discount");
    }

    @Test
    public void testCountWithNullPredicate() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE NULL");
    }

    @Test
    public void testCountWithIsNullPredicate() {
        this.assertQuery("SELECT COUNT(*) FROM orders WHERE NULLIF(orderstatus, 'F') IS NULL", "SELECT COUNT(*) FROM orders WHERE orderstatus = 'F' ");
    }

    @Test
    public void testCountWithIsNotNullPredicate() {
        this.assertQuery("SELECT COUNT(*) FROM orders WHERE NULLIF(orderstatus, 'F') IS NOT NULL", "SELECT COUNT(*) FROM orders WHERE orderstatus <> 'F' ");
    }

    @Test
    public void testCountWithNullIfPredicate() {
        this.assertQuery("SELECT COUNT(*) FROM orders WHERE NULLIF(orderstatus, 'F') = orderstatus ");
    }

    @Test
    public void testCountWithCoalescePredicate() {
        this.assertQuery("SELECT COUNT(*) FROM orders WHERE COALESCE(NULLIF(orderstatus, 'F'), 'bar') = 'bar'", "SELECT COUNT(*) FROM orders WHERE orderstatus = 'F'");
    }

    @Test
    public void testCountWithAndPredicate() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE tax < discount AND tax > 0.01 AND discount < 0.05");
    }

    @Test
    public void testCountWithOrPredicate() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE tax < 0.01 OR discount > 0.05");
    }

    @Test
    public void testCountWithInlineView() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT orderkey FROM lineitem) x");
    }

    @Test
    public void testNestedCount() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT orderkey, COUNT(*) FROM lineitem GROUP BY orderkey) x");
    }

    @Test
    public void testAggregationWithProjection() {
        this.assertQuery("SELECT sum(totalprice * 2) - sum(totalprice) FROM orders");
    }

    @Test
    public void testAggregationWithProjection2() {
        this.assertQuery("SELECT sum(totalprice * 2) + sum(totalprice * 2) FROM orders");
    }

    @Test
    public void testGroupByOnSupersetOfPartitioning() {
        this.assertQuery("SELECT orderdate, c, count(*) FROM (SELECT orderdate, count(*) c FROM orders GROUP BY orderdate) GROUP BY orderdate, c");
    }

    @Test
    public void testInlineView() {
        this.assertQuery("SELECT orderkey, custkey FROM (SELECT orderkey, custkey FROM ORDERS) U");
    }

    @Test
    public void testAliasedInInlineView() {
        this.assertQuery("SELECT x, y FROM (SELECT orderkey x, custkey y FROM ORDERS) U");
    }

    @Test
    public void testInlineViewWithProjections() {
        this.assertQuery("SELECT x + 1, y FROM (SELECT orderkey * 10 x, custkey y FROM ORDERS) u");
    }

    @Test
    public void testGroupByWithoutAggregation() {
        this.assertQuery("SELECT orderstatus FROM orders GROUP BY orderstatus");
    }

    @Test
    public void testNestedGroupByWithSameKey() {
        this.assertQuery("SELECT custkey, sum(t) FROM (SELECT custkey, count(*) t FROM orders GROUP BY custkey) GROUP BY custkey");
    }

    @Test
    public void testGroupByWithNulls() {
        this.assertQuery("SELECT key, COUNT(*) FROM (SELECT CASE   WHEN orderkey % 3 = 0 THEN NULL   WHEN orderkey % 5 = 0 THEN 0   ELSE orderkey   END as key FROM lineitem) GROUP BY key");
    }

    @Test
    public void testHistogram() {
        this.assertQuery("SELECT lines, COUNT(*) FROM (SELECT orderkey, COUNT(*) lines FROM lineitem GROUP BY orderkey) U GROUP BY lines");
    }

    @Test
    public void testSimpleJoin() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey");
        this.assertQuery("SELECT COUNT(*) FROM (SELECT orderkey FROM lineitem WHERE orderkey < 1000) a JOIN (SELECT orderkey FROM orders WHERE orderkey < 2000) b ON NOT (a.orderkey <= b.orderkey)");
    }

    @Test
    public void testJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = 2");
    }

    @Test
    public void testJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON orders.orderkey = 2");
    }

    @Test
    public void testSimpleJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = 2");
    }

    @Test
    public void testSimpleJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = 2");
    }

    @Test
    public void testJoinDoubleClauseWithLeftOverlap() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = orders.custkey");
    }

    @Test
    public void testJoinDoubleClauseWithRightOverlap() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = lineitem.partkey");
    }

    @Test
    public void testJoinWithAlias() {
        this.assertQuery("SELECT * FROM (lineitem JOIN orders ON lineitem.orderkey = orders.orderkey) x");
    }

    @Test
    public void testJoinWithConstantExpression() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND 123 = 123");
    }

    @Test
    public void testJoinWithConstantFalseExpressionWithCoercion() {
        MaterializedResult actual = this.computeActual("select count(*) > 0 from nation join region on (cast('a' as char(1)) = cast('a' as char(2)))");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BooleanType.BOOLEAN}).row(new Object[]{false}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testJoinWithConstantTrueExpressionWithCoercion() {
        this.assertQuery("select count(*) > 0 from nation join region on (cast(1.2 as real) = cast(1.2 as decimal(2,1)))");
    }

    @Test
    public void testJoinWithCanonicalizedConstantFalseExpressionWithCoercion() {
        MaterializedResult actual = this.computeActual("select count(*) > 0 from nation join region ON CAST((CASE WHEN (TRUE IS NOT NULL) THEN 'a' ELSE 'a' END) as char(1)) = CAST('a' as char(2))");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BooleanType.BOOLEAN}).row(new Object[]{false}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testJoinWithCanonicalizedConstantTrueExpressionWithCoercion() {
        this.assertQuery("select count(*) > 0 from nation join region ON CAST((CASE WHEN (TRUE IS NOT NULL) THEN '1.2' ELSE '1.2' END) as real) = CAST(1.2 as decimal(2,1))");
    }

    @Test
    public void testJoinWithConstantPredicatePushDown() {
        this.assertQuery("SELECT\n  a.orderstatus\n  , a.clerk\nFROM (\n  SELECT DISTINCT orderstatus, clerk FROM orders\n) a\nINNER JOIN (\n  SELECT DISTINCT orderstatus, clerk FROM orders\n) b\nON\n  a.orderstatus = b.orderstatus\n  and a.clerk = b.clerk\nwhere a.orderstatus = 'F'\n");
    }

    @Test
    public void testJoinWithInferredFalseJoinClause() {
        this.assertQuery("SELECT COUNT(*)\nFROM orders\nJOIN lineitem\nON CAST(orders.orderkey AS VARCHAR) = CAST(lineitem.orderkey AS VARCHAR)\nWHERE orders.orderkey = 1 AND lineitem.orderkey = 2\n");
    }

    @Test
    public void testJoinUsing() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem join orders using (orderkey)", "SELECT COUNT(*) FROM lineitem join orders on lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testJoinCriteriaCoercion() {
        this.assertQuery("SELECT * FROM (VALUES (1.0, 2.0)) x (a, b) JOIN (VALUES (1, 3)) y (a, b) USING(a)", "VALUES (1.0, 2.0, 1, 3)");
        this.assertQuery("SELECT * FROM (VALUES (1, 2)) x (a, b) JOIN (VALUES (CAST (1 AS SMALLINT), CAST(3 AS SMALLINT))) y (a, b) USING(a)", "VALUES (1, 2, 1, 3)");
        this.assertQuery("SELECT * FROM (VALUES (1.0, 2.0)) x (a, b) JOIN (VALUES (1, 3)) y (a, b) ON x.a = y.a", "VALUES (1.0, 2.0, 1, 3)");
        this.assertQuery("SELECT * FROM (VALUES (1, 2)) x (a, b) JOIN (VALUES (SMALLINT '1', SMALLINT '3')) y (a, b) ON x.a = y.a", "VALUES (1, 2, 1, 3)");
        this.assertQuery(String.format("SELECT * FROM    (VALUES (CAST(1 AS DECIMAL(%1$d,0)), 2)) x (a, b) ,    (VALUES (CAST(0 AS DECIMAL(%1$d,0)), SMALLINT '3')) y (a, b)  WHERE x.a = y.a + 1", 18), "VALUES (1, 2, 0, 3)");
        this.assertQuery(String.format("SELECT * FROM    (VALUES (CAST(1 AS DECIMAL(%1$d,0)), 2)) x (a, b)    INNER JOIN    (VALUES (CAST(0 AS DECIMAL(%1$d,0)), SMALLINT '3')) y (a, b)    ON x.a = y.a + 1", 18), "VALUES (1, 2, 0, 3)");
        this.assertQuery(String.format("SELECT * FROM    (VALUES (CAST(1 AS DECIMAL(%1$d,0)), 2)) x (a, b)    LEFT JOIN (VALUES (CAST(0 AS DECIMAL(%1$d,0)), SMALLINT '3')) y (a, b)    ON x.a = y.a + 1", 18), "VALUES (1, 2, 0, 3)");
        this.assertQuery(String.format("SELECT * FROM    (VALUES CAST(1 as decimal(%d,0))) t1 (a),    (VALUES CAST(1 as decimal(%d,0))) t2 (b)    WHERE a = b", 18, 19), "VALUES (1, 1)");
    }

    @Test
    public void testJoinWithReversedComparison() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON orders.orderkey = lineitem.orderkey");
    }

    @Test
    public void testJoinWithComplexExpressions() {
        this.assertQuery("SELECT SUM(custkey) FROM lineitem JOIN orders ON lineitem.orderkey = CAST(orders.orderkey AS BIGINT)");
    }

    @Test
    public void testJoinWithComplexExpressions2() {
        this.assertQuery("SELECT SUM(custkey) FROM lineitem JOIN orders ON lineitem.orderkey = CASE WHEN orders.custkey = 1 and orders.orderstatus = 'F' THEN orders.orderkey ELSE NULL END");
    }

    @Test
    public void testJoinWithComplexExpressions3() {
        this.assertQuery("SELECT SUM(custkey) FROM lineitem JOIN orders ON lineitem.orderkey + 1 = orders.orderkey + 1", "SELECT SUM(custkey) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey ");
    }

    @Test
    public void testJoinWithNormalization() {
        this.assertQuery("select COUNT(*) from nation a join nation b on not ((a.nationkey + b.nationkey) <> b.nationkey)");
        this.assertQuery("select COUNT(*) from nation a join nation b on not (a.nationkey <> b.nationkey)");
        this.assertQuery("select COUNT(*) from nation a join nation b on not (a.nationkey = b.nationkey)");
        this.assertQuery("select COUNT(*) from nation a join nation b on not (not cast(a.nationkey as boolean))");
        this.assertQuery("select COUNT(*) from nation a join nation b on not not not (a.nationkey = b.nationkey)");
    }

    @Test
    public void testSelfJoin() {
        this.assertQuery("SELECT COUNT(*) FROM orders a JOIN orders b on a.orderkey = b.orderkey");
    }

    @Test
    public void testWildcardFromJoin() {
        this.assertQuery("SELECT * FROM (select orderkey, partkey from lineitem) a join (select orderkey, custkey from orders) b using (orderkey)", "SELECT * FROM (select orderkey, partkey from lineitem) a join (select orderkey, custkey from orders) b on a.orderkey = b.orderkey");
    }

    @Test
    public void testQualifiedWildcardFromJoin() {
        this.assertQuery("SELECT a.*, b.* FROM (select orderkey, partkey from lineitem) a join (select orderkey, custkey from orders) b using (orderkey)", "SELECT a.*, b.* FROM (select orderkey, partkey from lineitem) a join (select orderkey, custkey from orders) b on a.orderkey = b.orderkey");
    }

    @Test
    public void testJoinAggregations() {
        this.assertQuery("SELECT x + y FROM (   SELECT orderdate, COUNT(*) x FROM orders GROUP BY orderdate) a JOIN (   SELECT orderdate, COUNT(*) y FROM orders GROUP BY orderdate) b ON a.orderdate = b.orderdate");
    }

    @Test
    public void testNonEqualityJoin() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity + length(orders.comment) > 7");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND NOT lineitem.quantity > 2");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON NOT NOT lineitem.orderkey = orders.orderkey AND NOT NOT lineitem.quantity > 2");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND NOT NOT NOT lineitem.quantity > 2");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity > 2");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity <= 2");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity != 2");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.shipdate > orders.orderdate");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderdate < lineitem.shipdate");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.comment LIKE '%forges%'");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.comment LIKE lineitem.comment");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.comment LIKE '%forges%'");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.comment LIKE orders.comment");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.comment NOT LIKE '%forges%'");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.comment NOT LIKE lineitem.comment");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND NOT (orders.comment LIKE '%forges%')");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND NOT (orders.comment LIKE lineitem.comment)");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity + length(orders.comment) > 7");
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND NULL");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) JOIN (VALUES 10, 11) t2(b) ON a > 1", "VALUES (2, 11), (2, 10)");
        this.assertQuery("SELECT COUNT(*) FROM (VALUES 1, 2) t1(a) JOIN (VALUES 10, 11) t2(b) ON a > 2", "VALUES (0)");
    }

    @Test
    public void testNonEqualityLeftJoin() {
        this.assertQuery("SELECT COUNT(*) FROM       (SELECT * FROM lineitem ORDER BY orderkey,linenumber LIMIT 5) l          LEFT OUTER JOIN       (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o          ON       o.custkey != 1000 WHERE o.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > 1000 WHERE orders.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > 1000.0 WHERE orders.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > orders.totalprice WHERE orders.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > lineitem.quantity WHERE orders.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity > 5 WHERE orders.orderkey IS NULL");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b > d", "VALUES (1, 2, 1, 1), (1, 1, NULL, NULL)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b < d", "VALUES (1, 1, 1, 2), (1, 2, NULL, NULL)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b > 2", "VALUES (1, 1, NULL,  NULL), (1, 2, NULL, NULL)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND d > 2", "VALUES (1, 1, NULL, NULL), (1, 2, NULL, NULL)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b > 0", "VALUES (1, 1, 1, 1), (1, 1, 1, 2), (1, 2, 1, 1), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND d > 0", "VALUES (1, 1, 1, 1), (1, 1, 1, 2), (1, 2, 1, 1), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND c = d", "VALUES (1, 1, 1, 1), (1, 2, 1, 1)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND c < d", "VALUES (1, 1, 1, 2), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON c = d", "VALUES (1, 1, 1, 1), (1, 2, 1, 1)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON c < d", "VALUES (1, 1, 1, 2), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) LEFT OUTER JOIN (VALUES 10, 11) t2(b) ON 1 = 1", "VALUES (1, 10), (1, 11), (2, 10), (2, 11)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) LEFT OUTER JOIN (VALUES 10, 11) t2(b) ON a > 1", "VALUES (1, NULL), (2, 11), (2, 10)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) LEFT OUTER JOIN (VALUES 10, 11) t2(b) ON b > 10", "VALUES (1, 11), (2, 11)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) LEFT OUTER JOIN (VALUES 10, 11) t2(b) ON a > b", "VALUES (1, NULL), (2, NULL)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) LEFT OUTER JOIN (VALUES 10, 11) t2(b) ON a < b", "VALUES (1, 10), (1, 11), (2, 10), (2, 11)");
        this.assertQuery("SELECT * FROM (VALUES 1) t1(a) LEFT OUTER JOIN (VALUES (1,2,2), (1,2,3), (1, 2, NULL)) t2(x,y,z) ON a=x AND y = z", "VALUES (1, 1, 2, 2)");
    }

    @Test
    public void testNonEqalityJoinWithScalarRequiringSessionParameter() {
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND from_unixtime(b) > current_timestamp", "VALUES (1, 1, NULL, NULL), (1, 2, NULL, NULL)");
    }

    @Test
    public void testNonEqualityJoinWithTryInFilter() {
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d)              ON a=c AND TRY(1 / (b-a) != 1000)", "VALUES (1, 1, NULL, NULL), (1, 2, 1, 1), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) LEFT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d)              ON a=c AND TRY(1 / (b-a) != 1000 OR from_unixtime(b) > current_timestamp)", "VALUES (1, 1, NULL, NULL), (1, 2, 1, 1), (1, 2, 1, 2)");
    }

    @Test
    public void testLeftJoinWithEmptyInnerTable() {
        this.assertQuery("SELECT * FROM lineitem a LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) b ON a.orderkey = b.orderkey");
        this.assertQuery("SELECT * FROM lineitem a LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) b ON a.orderkey > b.orderkey");
        this.assertQuery("SELECT * FROM lineitem a LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) b ON 1 = 1");
        this.assertQuery("SELECT * FROM lineitem a LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) b ON b.orderkey > 1");
        this.assertQuery("SELECT * FROM lineitem a LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) b ON b.orderkey > b.totalprice");
    }

    @Test
    public void testRightJoinWithEmptyInnerTable() {
        this.assertQuery("SELECT * FROM orders b RIGHT JOIN (SELECT * FROM orders WHERE orderkey = rand()) a ON a.orderkey = b.orderkey");
        this.assertQuery("SELECT * FROM orders b LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) a ON a.orderkey > b.orderkey");
        this.assertQuery("SELECT * FROM orders b LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) a ON 1 = 1");
        this.assertQuery("SELECT * FROM orders b LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) a ON b.orderkey > 1");
        this.assertQuery("SELECT * FROM orders b LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) a ON b.orderkey > b.totalprice");
    }

    @Test
    public void testNonEqualityRightJoin() {
        this.assertQuery("SELECT COUNT(*) FROM       (SELECT * FROM lineitem ORDER BY orderkey,linenumber LIMIT 5) l          RIGHT OUTER JOIN       (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o          ON       l.quantity != 5 WHERE l.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity > 5 WHERE lineitem.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity > 5.0 WHERE lineitem.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity > lineitem.suppkey WHERE lineitem.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity*1000 > orders.totalprice WHERE lineitem.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.totalprice > 1000 WHERE lineitem.orderkey IS NULL");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b > d", "VALUES (1, 2, 1, 1), (NULL, NULL, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b < d", "VALUES (1, 1, 1, 2), (NULL, NULL, 1, 1)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b > 2", "VALUES (NULL, NULL, 1, 1), (NULL, NULL, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND d > 2", "VALUES (NULL, NULL, 1, 1), (NULL, NULL, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b > 0", "VALUES (1, 1, 1, 1), (1, 1, 1, 2), (1, 2, 1, 1), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND d > 0", "VALUES (1, 1, 1, 1), (1, 1, 1, 2), (1, 2, 1, 1), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND c = d", "VALUES (1, 2, 1, 1), (1, 1, 1, 1), (NULL, NULL, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND c < d", "VALUES (NULL, NULL, 1, 1), (1, 2, 1, 2), (1, 1, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON c = d", "VALUES (1, 1, 1, 1), (1, 2, 1, 1), (NULL, NULL, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) RIGHT OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON c < d", "VALUES (NULL, NULL, 1, 1), (1, 1, 1, 2), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) RIGHT OUTER JOIN (VALUES 10, 11) t2(b) ON 1 = 1", "VALUES (1, 10), (1, 11), (2, 10), (2, 11)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) RIGHT OUTER JOIN (VALUES 10, 11) t2(b) ON a > 1", "VALUES (2, 11), (2, 10)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) RIGHT OUTER JOIN (VALUES 10, 11) t2(b) ON b > 10", "VALUES (NULL, 10), (1, 11), (2, 11)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) RIGHT OUTER JOIN (VALUES 10, 11) t2(b) ON a > b", "VALUES (NULL, 10), (NULL, 11)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) RIGHT OUTER JOIN (VALUES 10, 11) t2(b) ON a < b", "VALUES (1, 10), (1, 11), (2, 10), (2, 11)");
    }

    @Test
    public void testJoinUsingSymbolsFromJustOneSideOfJoin() {
        this.assertQuery("SELECT b FROM (VALUES 1, 2) t1(a) RIGHT OUTER JOIN (VALUES 10, 11) t2(b) ON b > 10", "VALUES (10), (11), (11)");
        this.assertQuery("SELECT a FROM (VALUES 1, 2) t1(a) RIGHT OUTER JOIN (VALUES 10, 11) t2(b) ON a > 1", "VALUES (2), (2)");
        this.assertQuery("SELECT b FROM (VALUES 1, 2) t1(a) LEFT OUTER JOIN (VALUES 10, 11) t2(b) ON b > 10", "VALUES (11), (11)");
        this.assertQuery("SELECT a FROM (VALUES 1, 2) t1(a) LEFT OUTER JOIN (VALUES 10, 11) t2(b) ON a > 1", "VALUES (1), (2), (2)");
        this.assertQuery("SELECT a FROM (VALUES 1, 2) t1(a) JOIN (VALUES 10, 11) t2(b) ON a > 1", "VALUES (2), (2)");
        this.assertQuery("SELECT b FROM (VALUES 1, 2) t1(a) JOIN (VALUES 10, 11) t2(b) ON b > 10", "VALUES (11), (11)");
    }

    @Test
    public void testJoinsWithTrueJoinCondition() {
        this.assertQuery("SELECT * FROM (VALUES 0, 1) t1(a) JOIN (VALUES 10, 11) t2(b) ON TRUE", "VALUES (0, 10), (0, 11), (1, 10), (1, 11)");
        this.assertQuery("SELECT * FROM (SELECT 1 WHERE FALSE) t1(a) JOIN (VALUES 10, 11) t2(b) ON TRUE", "SELECT 1 WHERE FALSE");
        this.assertQuery("SELECT * FROM (VALUES 0, 1) t1(a) JOIN (SELECT 1 WHERE FALSE) t2(b) ON TRUE", "SELECT 1 WHERE FALSE");
        this.assertQuery("SELECT * FROM (SELECT 1 WHERE FALSE) t1(a) JOIN (SELECT 1 WHERE FALSE) t2(b) ON TRUE", "SELECT 1 WHERE FALSE");
        this.assertQuery("SELECT * FROM (VALUES 0, 1) t1(a) LEFT JOIN (VALUES 10, 11) t2(b) ON TRUE", "VALUES (0, 10), (0, 11), (1, 10), (1, 11)");
        this.assertQuery("SELECT * FROM (SELECT 1 WHERE FALSE) t1(a) LEFT JOIN (VALUES 10, 11) t2(b) ON TRUE", "SELECT 1 WHERE FALSE");
        this.assertQuery("SELECT * FROM (VALUES 0, 1) t1(a) LEFT JOIN (SELECT 1 WHERE FALSE) t2(b) ON TRUE", "VALUES (0, NULL), (1, NULL)");
        this.assertQuery("SELECT * FROM (SELECT 1 WHERE FALSE) t1(a) LEFT JOIN (SELECT 1 WHERE FALSE) t2(b) ON TRUE", "SELECT 1 WHERE FALSE");
        this.assertQuery("SELECT * FROM (VALUES 0, 1) t1(a) RIGHT JOIN (VALUES 10, 11) t2(b) ON TRUE", "VALUES (0, 10), (0, 11), (1, 10), (1, 11)");
        this.assertQuery("SELECT * FROM (SELECT 1 WHERE FALSE) t1(a) RIGHT JOIN (VALUES 10, 11) t2(b) ON TRUE", "VALUES (NULL, 10), (NULL, 11)");
        this.assertQuery("SELECT * FROM (VALUES 0, 1) t1(a) RIGHT JOIN (SELECT 1 WHERE FALSE) t2(b) ON TRUE", "SELECT 1 WHERE FALSE");
        this.assertQuery("SELECT * FROM (SELECT 1 WHERE FALSE) t1(a) RIGHT JOIN (SELECT 1 WHERE FALSE) t2(b) ON TRUE", "SELECT 1 WHERE FALSE");
        this.assertQuery("SELECT * FROM (VALUES 0, 1) t1(a) FULL JOIN (VALUES 10, 11) t2(b) ON TRUE", "VALUES (0, 10), (0, 11), (1, 10), (1, 11)");
        this.assertQuery("SELECT * FROM (SELECT 1 WHERE FALSE) t1(a) FULL JOIN (VALUES 10, 11) t2(b) ON TRUE", "VALUES (NULL, 10), (NULL, 11)");
        this.assertQuery("SELECT * FROM (VALUES 0, 1) t1(a) FULL JOIN (SELECT 1 WHERE FALSE) t2(b) ON TRUE", "VALUES (0, NULL), (1, NULL)");
        this.assertQuery("SELECT * FROM (SELECT 1 WHERE FALSE) t1(a) FULL JOIN (SELECT 1 WHERE FALSE) t2(b) ON TRUE", "SELECT 1 WHERE FALSE");
    }

    @Test
    public void testNonEqualityFullJoin() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity > 5 WHERE lineitem.orderkey IS NULL OR orders.orderkey IS NULL", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey AS o1, orders.orderkey AS o2 FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity > 5     UNION ALL SELECT lineitem.orderkey AS o1, orders.orderkey AS o2 FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.quantity > 5     WHERE lineitem.orderkey IS NULL)  WHERE o1 IS NULL OR o2 IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > 1000 WHERE lineitem.orderkey IS NULL OR orders.orderkey IS NULL", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey AS o1, orders.orderkey AS o2 FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > 1000     UNION ALL SELECT lineitem.orderkey AS o1, orders.orderkey AS o2 FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > 1000     WHERE lineitem.orderkey IS NULL)  WHERE o1 IS NULL OR o2 IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > lineitem.quantity WHERE lineitem.orderkey IS NULL OR orders.orderkey IS NULL", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey AS o1, orders.orderkey AS o2 FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > lineitem.quantity     UNION ALL SELECT lineitem.orderkey AS o1, orders.orderkey AS o2 FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey > lineitem.quantity     WHERE lineitem.orderkey IS NULL)  WHERE o1 IS NULL OR o2 IS NULL");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) FULL OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b > d", "VALUES (1, 2, 1, 1), (NULL, NULL, 1, 2), (1, 1, NULL, NULL)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) FULL OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b < d", "VALUES (1, 1, 1, 2), (NULL, NULL, 1, 1), (1, 2, NULL, NULL)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) FULL OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b > 2", "VALUES (NULL, NULL, 1, 1), (NULL, NULL, 1, 2), (1, 1, NULL, NULL), (1, 2, NULL, NULL)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) FULL OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND d > 2", "VALUES (NULL, NULL, 1, 1), (NULL, NULL, 1, 2), (1, 1, NULL, NULL), (1, 2, NULL, NULL)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) FULL OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND b > 0", "VALUES (1, 1, 1, 1), (1, 1, 1, 2), (1, 2, 1, 1), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (1,2)) t1(a,b) FULL OUTER JOIN (VALUES (1,1), (1,2)) t2(c,d) ON a=c AND d > 0", "VALUES (1, 1, 1, 1), (1, 1, 1, 2), (1, 2, 1, 1), (1, 2, 1, 2)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) FULL OUTER JOIN (VALUES 10, 11) t2(b) ON a > 1", "VALUES (2, 11), (2, 10), (1, NULL)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) FULL OUTER JOIN (VALUES 10, 11) t2(b) ON b > 10", "VALUES (NULL, 10), (1, 11), (2, 11)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) FULL OUTER JOIN (VALUES 10, 11) t2(b) ON a > b", "VALUES (NULL, 10), (NULL, 11), (1, NULL), (2, NULL)");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) t1(a) FULL OUTER JOIN (VALUES 10, 11) t2(b) ON a < b", "VALUES (1, 10), (1, 11), (2, 10), (2, 11)");
    }

    @Test
    public void testJoinOnMultipleFields() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.shipdate = orders.orderdate");
    }

    @Test
    public void testJoinUsingMultipleFields() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN (SELECT orderkey, orderdate shipdate FROM ORDERS) T USING (orderkey, shipdate)", "SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.shipdate = orders.orderdate");
    }

    @Test
    public void testColocatedJoinWithLocalUnion() {
        this.assertQuery("select count(*) from ((select * from orders) union all (select * from orders)) join orders using (orderkey)", "select 2 * count(*) from orders");
    }

    @Test
    public void testJoinWithNonJoinExpression() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey = 1");
    }

    @Test
    public void testJoinWithNullValues() {
        this.assertQuery("SELECT *\nFROM (\n  SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM lineitem\n  WHERE partkey % 512 = 0\n) AS lineitem \nJOIN (\n  SELECT CASE WHEN orderkey % 2 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM orders\n  WHERE custkey % 512 = 0\n) AS orders\nON lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testJoinWithMultipleInSubqueryClauses() {
        QueryTemplate.Parameter type = QueryTemplate.parameter("type").of("");
        QueryTemplate.Parameter condition = QueryTemplate.parameter("condition").of("true");
        QueryTemplate queryTemplate = QueryTemplate.queryTemplate("SELECT * FROM (VALUES 1,2,3,4) t(x) %type% JOIN (VALUES 1,2,3,5) t2(y) ON %condition%", type, condition);
        QueryTemplate.Parameter twoDuplicatedInSubqueriesCondition = condition.of("(x in (VALUES 1,2,3)) = (y in (VALUES 1,2,3)) AND (x in (VALUES 1,2,4)) = (y in (VALUES 1,2,4))");
        this.assertQuery(queryTemplate.replace(twoDuplicatedInSubqueriesCondition), "VALUES (1,1), (1,2), (2,2), (2,1), (3,3)");
        this.assertQuery(queryTemplate.replace(condition.of("(x in (VALUES 1,2)) = (y in (VALUES 1,2)) AND (x in (VALUES 1)) = (y in (VALUES 3))")), "VALUES (2,2), (2,1), (3,5), (4,5)");
        this.assertQuery(queryTemplate.replace(condition.of("(x in (VALUES 1,2)) = (y in (VALUES 1,2)) AND (x in (VALUES 1)) != (y in (VALUES 3))")), "VALUES (1,2), (1,1), (3, 3), (4,3)");
        this.assertQuery(queryTemplate.replace(condition.of("(x in (VALUES 1)) = (y in (VALUES 1)) AND (x in (SELECT 2)) != (y in (SELECT 2))")), "VALUES (2,3), (2,5), (3, 2), (4,2)");
        QueryTemplate.Parameter left = type.of("left");
        QueryTemplate.Parameter right = type.of("right");
        QueryTemplate.Parameter full = type.of("full");
        for (QueryTemplate.Parameter joinType : ImmutableList.of((Object)left, (Object)right, (Object)full)) {
            for (String joinCondition : ImmutableList.of((Object)"x IN (VALUES 1)", (Object)"y in (VALUES 1)")) {
                this.assertQueryFails(queryTemplate.replace(joinType, condition.of(joinCondition)), ".*IN with subquery predicate in join condition is not supported");
            }
        }
        this.assertQuery(queryTemplate.replace(left, twoDuplicatedInSubqueriesCondition), "VALUES (1,1), (1,2), (2,2), (2,1), (3,3), (4, null)");
        this.assertQuery(queryTemplate.replace(right, twoDuplicatedInSubqueriesCondition), "VALUES (1,1), (1,2), (2,2), (2,1), (3,3), (null, 5)");
        this.assertQuery(queryTemplate.replace(full, twoDuplicatedInSubqueriesCondition), "VALUES (1,1), (1,2), (2,2), (2,1), (3,3), (4, null), (null, 5)");
    }

    @Test
    public void testJoinWithInSubqueryToBeExecutedAsPostJoinFilter() {
        QueryTemplate.Parameter type = QueryTemplate.parameter("type").of("");
        QueryTemplate.Parameter condition = QueryTemplate.parameter("condition").of("true");
        QueryTemplate queryTemplate = QueryTemplate.queryTemplate("SELECT * FROM (VALUES 1,2,3,4) t(x) %type% JOIN (VALUES 1,2,3,5) t2(y) ON %condition%", type, condition);
        this.assertQuery(queryTemplate.replace(condition.of("(x+y in (VALUES 4))")), "VALUES (1,3), (2,2), (3,1)");
        this.assertQuery(queryTemplate.replace(condition.of("(x+y in (VALUES 4)) AND (x*y in (VALUES 4,5))")), "VALUES (2,2)");
        this.assertQuery(queryTemplate.replace(condition.of("(x+y in (VALUES 4,5)) AND (x*y IN (VALUES 4,5))")), "VALUES (4,1), (2,2)");
        this.assertQuery(queryTemplate.replace(condition.of("(x+y in (VALUES 4,5)) AND (x in (VALUES 4,5)) != (y in (VALUES 4,5))")), "VALUES (4,1)");
        for (QueryTemplate.Parameter joinType : type.of("left", "right", "full")) {
            this.assertQueryFails(queryTemplate.replace(joinType, condition.of("(x+y in (VALUES 4,5)) AND (x in (VALUES 4,5)) != (y in (VALUES 4,5))")), ".*IN with subquery predicate in join condition is not supported");
        }
    }

    @Test
    public void testOuterJoinWithComplexCorrelatedSubquery() {
        QueryTemplate.Parameter type = QueryTemplate.parameter("type");
        QueryTemplate.Parameter condition = QueryTemplate.parameter("condition");
        QueryTemplate queryTemplate = QueryTemplate.queryTemplate("SELECT * FROM (VALUES 1,2,3,4) t(x) %type% JOIN (VALUES 1,2,3,5) t2(y) ON %condition%", type, condition);
        queryTemplate.replaceAll(query -> this.assertQueryFails((String)query, "line .*: .* is not supported"), new List[]{ImmutableList.of((Object)type.of("left"), (Object)type.of("right"), (Object)type.of("full")), ImmutableList.of((Object)condition.of("EXISTS(SELECT 1 WHERE x = y)"), (Object)condition.of("(SELECT x = y)"), (Object)condition.of("true IN (SELECT x = y)"))});
    }

    @Test
    public void testJoinWithMultipleScalarSubqueryClauses() {
        QueryTemplate.Parameter type = QueryTemplate.parameter("type").of("");
        QueryTemplate.Parameter condition = QueryTemplate.parameter("condition");
        QueryTemplate queryTemplate = QueryTemplate.queryTemplate("SELECT * FROM (VALUES 1,2,3,4) t(x) %type% JOIN (VALUES 1,2,3,5) t2(y) ON %condition%", type, condition);
        QueryTemplate.Parameter multipleScalarJoinCondition = condition.of("(x = (VALUES 1)) AND (y = (VALUES 2)) AND (x in (VALUES 2)) = (y in (VALUES 1))");
        this.assertQuery(queryTemplate.replace(multipleScalarJoinCondition), "VALUES (1,2)");
        this.assertQuery(queryTemplate.replace(condition.of("(x = (VALUES 2)) = (y > (VALUES 0)) AND (x > (VALUES 1)) = (y < (VALUES 3))")), "VALUES (2,2), (2,1)");
        this.assertQuery(queryTemplate.replace(condition.of("(x = (VALUES 1)) = (y = (VALUES 1)) AND (x = (SELECT 2)) != (y = (SELECT 3))")), "VALUES (2,5), (2,2), (3,3), (4,3)");
        this.assertQuery(queryTemplate.replace(type.of("left"), multipleScalarJoinCondition), "VALUES (1,2), (2,null), (3, null), (4, null)");
        this.assertQuery(queryTemplate.replace(type.of("right"), multipleScalarJoinCondition), "VALUES (1,2), (null,1), (null, 3), (null, 5)");
        this.assertQuery(queryTemplate.replace(type.of("full"), multipleScalarJoinCondition), "VALUES (1,2), (2,null), (3, null), (4, null), (null,1), (null, 3), (null, 5)");
    }

    @Test
    public void testJoinWithScalarSubqueryToBeExecutedAsPostJoinFilter() {
        QueryTemplate.Parameter type = QueryTemplate.parameter("type").of("");
        QueryTemplate.Parameter condition = QueryTemplate.parameter("condition");
        QueryTemplate queryTemplate = QueryTemplate.queryTemplate("SELECT * FROM (VALUES 1,2,3,4) t(x) %type% JOIN (VALUES 1,2,3,5) t2(y) ON %condition%", type, condition);
        QueryTemplate.Parameter xPlusYEqualsSubqueryJoinCondition = condition.of("(x+y = (SELECT 4))");
        this.assertQuery(queryTemplate.replace(xPlusYEqualsSubqueryJoinCondition), "VALUES (1,3), (2,2), (3,1)");
        this.assertQuery(queryTemplate.replace(condition.of("(x+y = (VALUES 4)) AND (x*y = (VALUES 4))")), "VALUES (2,2)");
        this.assertQuery(queryTemplate.replace(condition.of("x+y > (VALUES 3) AND (x = (VALUES 3)) != (y = (VALUES 3))")), "VALUES (3,1), (3,2), (1,3), (2,3), (4,3), (3,5)");
        this.assertQuery(queryTemplate.replace(condition.of("x+y >= (VALUES 5) AND (x = (VALUES 3)) != (y = (VALUES 3))")), "VALUES (3,2), (2,3), (4,3), (3,5)");
        this.assertQuery(queryTemplate.replace(condition.of("x+y >= (VALUES 3) AND (x = (VALUES 5)) != (y = (VALUES 3))")), "VALUES (1,3), (2,3), (3,3), (4,3)");
        this.assertQuery(queryTemplate.replace(condition.of("x+y >= (VALUES 3) AND (x = (VALUES 3)) != (y = (VALUES 5))")), "VALUES (3,1), (3,2), (3,3), (1,5), (2,5), (4,5)");
        this.assertQuery(queryTemplate.replace(condition.of("x+y >= (VALUES 4) AND (x = (VALUES 3)) != (y = (VALUES 5))")), "VALUES (3,1), (3,2), (3,3), (1,5), (2,5), (4,5)");
        this.assertQuery(queryTemplate.replace(type.of("left"), xPlusYEqualsSubqueryJoinCondition), "VALUES (1,3), (2,2), (3,1), (4, null)");
        this.assertQuery(queryTemplate.replace(type.of("right"), xPlusYEqualsSubqueryJoinCondition), "VALUES (1,3), (2,2), (3,1), (null, 5)");
        this.assertQuery(queryTemplate.replace(type.of("full"), xPlusYEqualsSubqueryJoinCondition), "VALUES (1,3), (2,2), (3,1), (4, null), (null, 5)");
    }

    @Test
    public void testJoinWithScalarSubqueryInOnClause() {
        this.assertQuery("SELECT count() FROM nation a INNER JOIN nation b ON a.name = (SELECT max(name) FROM nation) INNER JOIN nation c ON c.name = split_part(b.name,'<',2)", "SELECT 0");
    }

    @Test
    public void testJoinWithScalarSubqueryToBeExecutedAsPostJoinFilterWithEmptyInnerTable() {
        String noOutputQuery = "SELECT 1 WHERE false";
        QueryTemplate.Parameter type = QueryTemplate.parameter("type").of("");
        QueryTemplate.Parameter condition = QueryTemplate.parameter("condition");
        QueryTemplate queryTemplate = QueryTemplate.queryTemplate("SELECT * FROM (" + noOutputQuery + ") t(x) %type% JOIN (VALUES 1) t2(y) ON %condition%", type);
        QueryTemplate.Parameter xPlusYEqualsSubqueryJoinCondition = condition.of("(x+y = (SELECT 4))");
        this.assertQuery(queryTemplate.replace(xPlusYEqualsSubqueryJoinCondition), noOutputQuery);
        this.assertQuery(queryTemplate.replace(condition.of("(x+y = (VALUES 4)) AND (x*y = (VALUES 4))")), noOutputQuery);
        this.assertQuery(queryTemplate.replace(xPlusYEqualsSubqueryJoinCondition, type.of("left")), noOutputQuery);
        this.assertQuery(queryTemplate.replace(xPlusYEqualsSubqueryJoinCondition, type.of("right")), "VALUES (null,1)");
        this.assertQuery(queryTemplate.replace(xPlusYEqualsSubqueryJoinCondition, type.of("full")), "VALUES (null,1)");
    }

    @Test
    public void testInUncorrelatedSubquery() {
        this.assertQuery("SELECT CASE WHEN false THEN 1 IN (VALUES 2) END", "SELECT NULL");
        this.assertQuery("SELECT x FROM (VALUES 2) t(x) where MAP(ARRAY[8589934592], ARRAY[x]) IN (VALUES MAP(ARRAY[8589934592],ARRAY[2]))", "SELECT 2");
        this.assertQuery("SELECT a IN (VALUES 2), a FROM (VALUES (2)) t(a)", "SELECT TRUE, 2");
    }

    @Test
    public void testJoinWithExpressionsThatMayReturnNull() {
        this.assertQuery("SELECT *\nFROM (\n    SELECT a, nullif(a, 1)\n    FROM (VALUES 1) w(a)\n) t(a,b)\nJOIN (VALUES 1) u(x) ON t.a = u.x", "SELECT 1, NULL, 1");
        this.assertQuery("SELECT *\nFROM (\n    SELECT a, contains(array[2, null], a)\n    FROM (VALUES 1) w(a)\n) t(a,b)\nJOIN (VALUES 1) u(x) ON t.a = u.x\n", "SELECT 1, NULL, 1");
        this.assertQuery("SELECT *\nFROM (\n    SELECT a, array[null][a]\n    FROM (VALUES 1) w(a)\n) t(a,b)\nJOIN (VALUES 1) u(x) ON t.a = u.x", "SELECT 1, NULL, 1");
        this.assertQuery("SELECT *\nFROM (\n    SELECT a, try(a / 0)\n    FROM (VALUES 1) w(a)\n) t(a,b)\nJOIN (VALUES 1) u(x) ON t.a = u.x", "SELECT 1, NULL, 1");
    }

    @Test
    public void testLeftFilteredJoin() {
        this.assertQuery("SELECT custkey, linestatus, tax, totalprice, orderstatus FROM (SELECT * FROM lineitem WHERE orderkey % 2 = 0) a JOIN orders ON a.orderkey = orders.orderkey");
    }

    @Test
    public void testRightFilteredJoin() {
        this.assertQuery("SELECT custkey, linestatus, tax, totalprice, orderstatus FROM lineitem JOIN (SELECT *  FROM orders WHERE orderkey % 2 = 0) a ON lineitem.orderkey = a.orderkey");
    }

    @Test
    public void testJoinWithFullyPushedDownJoinClause() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON orders.custkey = 1 AND lineitem.orderkey = 1");
    }

    @Test
    public void testJoinPredicateMoveAround() {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM lineitem WHERE orderkey % 16 = 0 AND partkey % 2 = 0) lineitem\nJOIN (SELECT * FROM orders WHERE orderkey % 16 = 0 AND custkey % 2 = 0) orders\nON lineitem.orderkey % 8 = orders.orderkey % 8 AND lineitem.linenumber % 2 = 0\nWHERE orders.custkey % 8 < 7 AND orders.custkey % 8 = lineitem.orderkey % 8 AND lineitem.suppkey % 7 > orders.custkey % 7");
    }

    @Test
    public void testSimpleFullJoin() {
        this.assertQuery("SELECT a, b FROM (VALUES (1), (2)) t (a) FULL OUTER JOIN (VALUES (1), (3)) u (b) ON a = b", "SELECT * FROM (VALUES (1, 1), (2, NULL), (NULL, 3))");
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL JOIN orders ON lineitem.orderkey = orders.orderkey", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey UNION ALL SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey WHERE lineitem.orderkey IS NULL)");
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL OUTER JOIN orders ON lineitem.orderkey = orders.orderkey", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey UNION ALL SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey WHERE lineitem.orderkey IS NULL)");
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL JOIN orders ON lineitem.orderkey = orders.custkey", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.custkey UNION ALL SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.custkey WHERE lineitem.orderkey IS NULL)");
    }

    @Test
    public void testFullJoinNormalizedToLeft() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL JOIN orders ON lineitem.orderkey = orders.orderkey WHERE lineitem.orderkey IS NOT NULL", "SELECT COUNT(*) FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey WHERE lineitem.orderkey IS NOT NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL JOIN orders ON lineitem.orderkey = orders.custkey WHERE lineitem.orderkey IS NOT NULL", "SELECT COUNT(*) FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.custkey WHERE lineitem.orderkey IS NOT NULL");
    }

    @Test
    public void testFullJoinNormalizedToRight() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL JOIN orders ON lineitem.orderkey = orders.orderkey WHERE orders.orderkey IS NOT NULL", "SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey  WHERE orders.orderkey IS NOT NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL JOIN orders ON lineitem.orderkey = orders.custkey WHERE orders.custkey IS NOT NULL", "SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.custkey  WHERE orders.custkey IS NOT NULL");
    }

    @Test
    public void testFullJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem FULL JOIN orders ON lineitem.orderkey = 1024", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey, orders.orderkey AS o2 FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = 1024 UNION ALL SELECT lineitem.orderkey, orders.orderkey AS o2 FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = 1024 WHERE lineitem.orderkey IS NULL)");
    }

    @Test
    public void testFullJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem FULL JOIN orders ON orders.orderkey = 1024", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey, orders.orderkey AS o2 FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem LEFT OUTER JOIN orders ON orders.orderkey = 1024 UNION ALL SELECT lineitem.orderkey, orders.orderkey AS o2 FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem RIGHT OUTER JOIN orders ON orders.orderkey = 1024 WHERE lineitem.orderkey IS NULL)");
    }

    @Test
    public void testSimpleFullJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = 2", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = 2UNION ALL SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = 2WHERE lineitem.orderkey IS NULL)");
    }

    @Test
    public void testSimpleFullJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem FULL JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = 2", "SELECT COUNT(*) FROM (SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = 2UNION ALL SELECT lineitem.orderkey, orders.orderkey AS o2 FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = 2WHERE lineitem.orderkey IS NULL)");
    }

    @Test
    public void testOuterJoinWithNullsOnProbe() {
        this.assertQuery("SELECT DISTINCT a.orderkey FROM (SELECT CASE WHEN orderkey > 10 THEN orderkey END orderkey FROM orders WHERE orderkey < 100) a RIGHT OUTER JOIN (SELECT * FROM orders WHERE orderkey < 100) b ON a.orderkey = b.orderkey");
        this.assertQuery("SELECT DISTINCT a.orderkey FROM (SELECT CASE WHEN orderkey > 2 THEN orderkey END orderkey FROM orders WHERE orderkey < 100) a FULL OUTER JOIN (SELECT * FROM orders WHERE orderkey < 100) b ON a.orderkey = b.orderkey", "SELECT DISTINCT orderkey FROM (SELECT a.orderkey FROM (SELECT CASE WHEN orderkey > 2 THEN orderkey END orderkey FROM orders WHERE orderkey < 100) a RIGHT OUTER JOIN (SELECT * FROM orders WHERE orderkey < 100) b ON a.orderkey = b.orderkey UNION ALL SELECT a.orderkey FROM(SELECT CASE WHEN orderkey > 2 THEN orderkey END orderkey FROM orders WHERE orderkey < 100) a LEFT OUTER JOIN (SELECT * FROM orders WHERE orderkey < 100) b ON a.orderkey = b.orderkey WHERE a.orderkey IS NULL)");
    }

    @Test
    public void testOuterJoinWithCommonExpression() {
        MaterializedResult actual = this.computeActual("SELECT count(1), count(one) FROM (values (1, 'a'), (2, 'a')) as l(k, a) LEFT JOIN (select k, 1 one from (values 1) as r(k)) r ON l.k = r.k GROUP BY a");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{2L, 1L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testSimpleLeftJoin() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT JOIN orders ON lineitem.orderkey = orders.orderkey");
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey");
        this.assertQuery("SELECT x.val FROM (SELECT CAST(ROW(v) as ROW(val integer)) FROM (VALUES 1, 2, 3) t(v)) ta (x) LEFT OUTER JOIN (SELECT CAST(ROW(v) as ROW(val integer)) FROM (VALUES 1, 2, 3) t(v)) tb (y) ON x.val=y.val WHERE y.val=1", "SELECT 1");
    }

    @Test
    public void testLeftJoinNormalizedToInner() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT JOIN orders ON lineitem.orderkey = orders.orderkey WHERE orders.orderkey IS NOT NULL");
    }

    @Test
    public void testLeftJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem LEFT JOIN orders ON lineitem.orderkey = 1024");
    }

    @Test
    public void testLeftJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem LEFT JOIN orders ON orders.orderkey = 1024");
    }

    @Test
    public void testSimpleLeftJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = 2");
    }

    @Test
    public void testSimpleLeftJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = 2");
    }

    @Test
    public void testDoubleFilteredLeftJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem LEFT JOIN (SELECT * FROM orders WHERE orderkey % 1024 = 0) orders ON orders.orderkey = 1024");
    }

    @Test
    public void testDoubleFilteredLeftJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem LEFT JOIN (SELECT * FROM orders WHERE orderkey % 1024 = 0) orders ON lineitem.orderkey = 1024");
    }

    @Test
    public void testLeftJoinDoubleClauseWithLeftOverlap() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = orders.custkey");
    }

    @Test
    public void testLeftJoinDoubleClauseWithRightOverlap() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = lineitem.partkey");
    }

    @Test
    public void testBuildFilteredLeftJoin() {
        this.assertQuery("SELECT * FROM lineitem LEFT JOIN (SELECT * FROM orders WHERE orderkey % 2 = 0) a ON lineitem.orderkey = a.orderkey");
    }

    @Test
    public void testProbeFilteredLeftJoin() {
        this.assertQuery("SELECT * FROM (SELECT * FROM lineitem WHERE orderkey % 2 = 0) a LEFT JOIN orders ON a.orderkey = orders.orderkey");
    }

    @Test
    public void testLeftJoinPredicateMoveAround() {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM lineitem WHERE orderkey % 16 = 0 AND partkey % 2 = 0) lineitem\nLEFT JOIN (SELECT * FROM orders WHERE orderkey % 16 = 0 AND custkey % 2 = 0) orders\nON lineitem.orderkey % 8 = orders.orderkey % 8\nWHERE (orders.custkey % 8 < 7 OR orders.custkey % 8 IS NULL) AND orders.custkey % 8 = lineitem.orderkey % 8");
    }

    @Test
    public void testLeftJoinEqualityInference() {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM lineitem WHERE orderkey % 4 = 0 AND suppkey % 2 = partkey % 2 AND linenumber % 3 = orderkey % 3) lineitem\nLEFT JOIN (SELECT * FROM orders WHERE orderkey % 4 = 0) orders\nON lineitem.linenumber % 3 = orders.orderkey % 4 AND lineitem.orderkey % 3 = orders.custkey % 3\nWHERE lineitem.suppkey % 2 = lineitem.linenumber % 3");
    }

    @Test
    public void testLeftJoinWithNullValues() {
        this.assertQuery("SELECT *\nFROM (\n  SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM lineitem\n  WHERE partkey % 512 = 0\n) AS lineitem \nLEFT JOIN (\n  SELECT CASE WHEN orderkey % 2 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM orders\n  WHERE custkey % 512 = 0\n) AS orders\nON lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testSimpleRightJoin() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.orderkey");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.custkey");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.custkey");
    }

    @Test
    public void testRightJoinNormalizedToInner() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.orderkey WHERE lineitem.orderkey IS NOT NULL");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.custkey WHERE lineitem.orderkey IS NOT NULL");
    }

    @Test
    public void testRightJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem RIGHT JOIN orders ON lineitem.orderkey = 1024");
    }

    @Test
    public void testRightJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem RIGHT JOIN orders ON orders.orderkey = 1024");
    }

    @Test
    public void testDoubleFilteredRightJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem RIGHT JOIN (SELECT * FROM orders WHERE orderkey % 1024 = 0) orders ON orders.orderkey = 1024");
    }

    @Test
    public void testDoubleFilteredRightJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem RIGHT JOIN (SELECT * FROM orders WHERE orderkey % 1024 = 0) orders ON lineitem.orderkey = 1024");
    }

    @Test
    public void testSimpleRightJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = 2");
    }

    @Test
    public void testSimpleRightJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = 2");
    }

    @Test
    public void testRightJoinDoubleClauseWithLeftOverlap() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = orders.custkey");
    }

    @Test
    public void testRightJoinDoubleClauseWithRightOverlap() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = lineitem.partkey");
    }

    @Test
    public void testBuildFilteredRightJoin() {
        this.assertQuery("SELECT custkey, linestatus, tax, totalprice, orderstatus FROM (SELECT * FROM lineitem WHERE orderkey % 2 = 0) a RIGHT JOIN orders ON a.orderkey = orders.orderkey");
    }

    @Test
    public void testProbeFilteredRightJoin() {
        this.assertQuery("SELECT custkey, linestatus, tax, totalprice, orderstatus FROM lineitem RIGHT JOIN (SELECT *  FROM orders WHERE orderkey % 2 = 0) a ON lineitem.orderkey = a.orderkey");
    }

    @Test
    public void testRightJoinPredicateMoveAround() {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM orders WHERE orderkey % 16 = 0 AND custkey % 2 = 0) orders\nRIGHT JOIN (SELECT * FROM lineitem WHERE orderkey % 16 = 0 AND partkey % 2 = 0) lineitem\nON lineitem.orderkey % 8 = orders.orderkey % 8\nWHERE (orders.custkey % 8 < 7 OR orders.custkey % 8 IS NULL) AND orders.custkey % 8 = lineitem.orderkey % 8");
    }

    @Test
    public void testRightJoinEqualityInference() {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM orders WHERE orderkey % 4 = 0) orders\nRIGHT JOIN (SELECT * FROM lineitem WHERE orderkey % 4 = 0 AND suppkey % 2 = partkey % 2 AND linenumber % 3 = orderkey % 3) lineitem\nON lineitem.linenumber % 3 = orders.orderkey % 4 AND lineitem.orderkey % 3 = orders.custkey % 3\nWHERE lineitem.suppkey % 2 = lineitem.linenumber % 3");
    }

    @Test
    public void testRightJoinWithNullValues() {
        this.assertQuery("SELECT lineitem.orderkey, orders.orderkey\nFROM (\n  SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM lineitem\n  WHERE partkey % 512 = 0\n) AS lineitem \nRIGHT JOIN (\n  SELECT CASE WHEN orderkey % 2 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM orders\n  WHERE custkey % 512 = 0\n) AS orders\nON lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testJoinWithDuplicateRelations() {
        this.assertQuery("SELECT * FROM orders JOIN orders USING (orderkey)", "SELECT * FROM orders o1 JOIN orders o2 ON o1.orderkey = o2.orderkey");
        this.assertQuery("SELECT * FROM lineitem x JOIN orders x USING (orderkey)", "SELECT * FROM lineitem l JOIN orders o ON l.orderkey = o.orderkey");
    }

    @Test
    public void testJoinWithStatefulFilterFunction() {
        this.assertQuery("SELECT *\nFROM (VALUES 1, 2) a(id)\nFULL JOIN (VALUES 2, 3) b(id)\nON (array_intersect(array[a.id], array[b.id]) = array[a.id])", "VALUES (1, null), (2, 2), (null, 3)");
    }

    @Test
    public void testAggregationOverRigthJoinOverSingleStreamProbe() {
        this.assertQueryOrdered("SELECT\n  value\nFROM\n(\n    SELECT\n        key\n    FROM\n        (VALUES 'match') as a(key)\n        LEFT JOIN (SELECT * FROM (VALUES (0)) limit 0) AS x(ignored)\n        ON TRUE\n    GROUP BY 1\n) a\nRIGHT JOIN\n(\n    VALUES\n    ('match', 'value'),\n    ('no-match', 'value')\n) AS b(key, value)\nON a.key = b.key\nGROUP BY 1\n", "VALUES 'value'");
    }

    @Test
    public void testOrderBy() {
        this.assertQueryOrdered("SELECT orderstatus FROM orders ORDER BY orderstatus");
    }

    @Test
    public void testOrderBy2() {
        this.assertQueryOrdered("SELECT orderstatus FROM orders ORDER BY orderkey DESC");
    }

    @Test
    public void testOrderByMultipleFields() {
        this.assertQueryOrdered("SELECT custkey, orderstatus FROM orders ORDER BY custkey DESC, orderstatus");
    }

    @Test
    public void testOrderByWithNulls() {
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC NULLS FIRST, custkey ASC");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) DESC NULLS FIRST, custkey ASC");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC NULLS LAST, custkey ASC");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) DESC NULLS LAST, custkey ASC");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC, custkey ASC", "SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC NULLS LAST, custkey ASC");
    }

    @Test
    public void testOrderByAlias() {
        this.assertQueryOrdered("SELECT orderstatus x FROM orders ORDER BY x ASC");
    }

    @Test
    public void testOrderByAliasWithSameNameAsUnselectedColumn() {
        this.assertQueryOrdered("SELECT orderstatus orderdate FROM orders ORDER BY orderdate ASC");
    }

    @Test
    public void testOrderByOrdinal() {
        this.assertQueryOrdered("SELECT orderstatus, orderdate FROM orders ORDER BY 2, 1");
    }

    @Test
    public void testOrderByOrdinalWithWildcard() {
        this.assertQueryOrdered("SELECT * FROM orders ORDER BY 1");
    }

    @Test
    public void testGroupByOrdinal() {
        this.assertQuery("SELECT orderstatus, sum(totalprice) FROM orders GROUP BY 1", "SELECT orderstatus, sum(totalprice) FROM orders GROUP BY orderstatus");
    }

    @Test
    public void testGroupBySearchedCase() {
        this.assertQuery("SELECT CASE WHEN orderstatus = 'O' THEN 'a' ELSE 'b' END, count(*)\nFROM orders\nGROUP BY CASE WHEN orderstatus = 'O' THEN 'a' ELSE 'b' END");
        this.assertQuery("SELECT CASE WHEN orderstatus = 'O' THEN 'a' ELSE 'b' END, count(*)\nFROM orders\nGROUP BY 1", "SELECT CASE WHEN orderstatus = 'O' THEN 'a' ELSE 'b' END, count(*)\nFROM orders\nGROUP BY CASE WHEN orderstatus = 'O' THEN 'a' ELSE 'b' END");
    }

    @Test
    public void testGroupBySearchedCaseNoElse() {
        this.assertQuery("SELECT CASE WHEN orderstatus = 'O' THEN 'a' END, count(*)\nFROM orders\nGROUP BY CASE WHEN orderstatus = 'O' THEN 'a' END");
        this.assertQuery("SELECT CASE WHEN orderstatus = 'O' THEN 'a' END, count(*)\nFROM orders\nGROUP BY 1", "SELECT CASE WHEN orderstatus = 'O' THEN 'a' END, count(*)\nFROM orders\nGROUP BY CASE WHEN orderstatus = 'O' THEN 'a' END");
        this.assertQuery("SELECT CASE WHEN true THEN orderstatus END, count(*)\nFROM orders\nGROUP BY orderstatus");
    }

    @Test
    public void testGroupByCase() {
        this.assertQuery("SELECT CASE orderstatus WHEN 'O' THEN 'a' ELSE 'b' END, count(*)\nFROM orders\nGROUP BY CASE orderstatus WHEN 'O' THEN 'a' ELSE 'b' END");
        this.assertQuery("SELECT CASE orderstatus WHEN 'O' THEN 'a' ELSE 'b' END, count(*)\nFROM orders\nGROUP BY 1", "SELECT CASE orderstatus WHEN 'O' THEN 'a' ELSE 'b' END, count(*)\nFROM orders\nGROUP BY CASE orderstatus WHEN 'O' THEN 'a' ELSE 'b' END");
        this.assertQuery("SELECT CASE orderstatus WHEN 'O' THEN 'a' ELSE 'b' END, count(*)\nFROM orders\nGROUP BY orderstatus");
        this.assertQuery("SELECT CASE 'O' WHEN orderstatus THEN 'a' ELSE 'b' END, count(*)\nFROM orders\nGROUP BY orderstatus");
        this.assertQuery("SELECT CASE 1 WHEN 1 THEN orderstatus ELSE 'x' END, count(*)\nFROM orders\nGROUP BY orderstatus");
        this.assertQuery("SELECT CASE 1 WHEN 1 THEN 'x' ELSE orderstatus END, count(*)\nFROM orders\nGROUP BY orderstatus");
    }

    @Test
    public void testGroupByCaseNoElse() {
        this.assertQuery("SELECT CASE orderstatus WHEN 'O' THEN 'a' END, count(*)\nFROM orders\nGROUP BY CASE orderstatus WHEN 'O' THEN 'a' END");
        this.assertQuery("SELECT CASE orderstatus WHEN 'O' THEN 'a' END, count(*)\nFROM orders\nGROUP BY orderstatus");
        this.assertQuery("SELECT CASE 'O' WHEN orderstatus THEN 'a' END, count(*)\nFROM orders\nGROUP BY orderstatus");
        this.assertQuery("SELECT CASE 1 WHEN 1 THEN orderstatus END, count(*)\nFROM orders\nGROUP BY orderstatus");
    }

    @Test
    public void testGroupByCast() {
        this.assertQuery("SELECT CAST(orderkey AS VARCHAR), count(*) FROM orders GROUP BY CAST(orderkey AS VARCHAR)");
        this.assertQuery("SELECT CAST(orderkey AS VARCHAR), count(*) FROM orders GROUP BY 1", "SELECT CAST(orderkey AS VARCHAR), count(*) FROM orders GROUP BY CAST(orderkey AS VARCHAR)");
        this.assertQuery("SELECT CAST(orderkey AS VARCHAR), count(*) FROM orders GROUP BY orderkey");
    }

    @Test
    public void testGroupByCoalesce() {
        this.assertQuery("SELECT COALESCE(orderkey, custkey), count(*) FROM orders GROUP BY COALESCE(orderkey, custkey)");
        this.assertQuery("SELECT COALESCE(orderkey, custkey), count(*) FROM orders GROUP BY 1", "SELECT COALESCE(orderkey, custkey), count(*) FROM orders GROUP BY COALESCE(orderkey, custkey)");
        this.assertQuery("SELECT COALESCE(orderkey, 1), count(*) FROM orders GROUP BY orderkey");
        this.assertQuery("SELECT COALESCE(1, orderkey), count(*) FROM orders GROUP BY orderkey");
    }

    @Test
    public void testGroupByNullIf() {
        this.assertQuery("SELECT NULLIF(orderkey, custkey), count(*) FROM orders GROUP BY NULLIF(orderkey, custkey)");
        this.assertQuery("SELECT NULLIF(orderkey, custkey), count(*) FROM orders GROUP BY 1", "SELECT NULLIF(orderkey, custkey), count(*) FROM orders GROUP BY NULLIF(orderkey, custkey)");
        this.assertQuery("SELECT NULLIF(orderkey, 1), count(*) FROM orders GROUP BY orderkey");
        this.assertQuery("SELECT NULLIF(1, orderkey), count(*) FROM orders GROUP BY orderkey");
    }

    @Test
    public void testGroupByExtract() {
        this.assertQuery("SELECT EXTRACT(YEAR FROM now()), count(*) FROM orders GROUP BY EXTRACT(YEAR FROM now())");
        this.assertQuery("SELECT EXTRACT(YEAR FROM now()), count(*) FROM orders GROUP BY 1", "SELECT EXTRACT(YEAR FROM now()), count(*) FROM orders GROUP BY EXTRACT(YEAR FROM now())");
        this.assertQuery("SELECT EXTRACT(YEAR FROM now()), count(*) FROM orders GROUP BY now()");
    }

    @Test
    public void testGroupByNullConstant() {
        this.assertQuery("SELECT count(*)\nFROM (\n  SELECT cast(null as VARCHAR) constant, orderdate\n  FROM orders\n) a\ngroup by constant, orderdate\n");
    }

    @Test
    public void testChecksum() {
        this.assertQuery("SELECT to_hex(checksum(0))", "select '0000000000000000'");
    }

    @Test
    public void testMaxBy() {
        this.assertQuery("SELECT MAX_BY(orderkey, totalprice) FROM orders", "SELECT orderkey FROM orders ORDER BY totalprice DESC LIMIT 1");
    }

    @Test
    public void testMaxByN() {
        this.assertQuery("SELECT y FROM (SELECT MAX_BY(orderkey, totalprice, 2) mx FROM orders) CROSS JOIN UNNEST(mx) u(y)", "SELECT orderkey FROM orders ORDER BY totalprice DESC LIMIT 2");
    }

    @Test
    public void testMinBy() {
        this.assertQuery("SELECT MIN_BY(orderkey, totalprice) FROM orders", "SELECT orderkey FROM orders ORDER BY totalprice ASC LIMIT 1");
    }

    @Test
    public void testMinByN() {
        this.assertQuery("SELECT y FROM (SELECT MIN_BY(orderkey, totalprice, 2) mx FROM orders) CROSS JOIN UNNEST(mx) u(y)", "SELECT orderkey FROM orders ORDER BY totalprice ASC LIMIT 2");
    }

    @Test
    public void testGroupByBetween() {
        this.assertQuery("SELECT orderkey BETWEEN 1 AND 100 FROM orders GROUP BY orderkey BETWEEN 1 AND 100 ");
        this.assertQuery("SELECT CAST(orderkey BETWEEN 1 AND 100 AS BIGINT) FROM orders GROUP BY orderkey");
        this.assertQuery("SELECT CAST(50 BETWEEN orderkey AND 100 AS BIGINT) FROM orders GROUP BY orderkey");
        this.assertQuery("SELECT CAST(50 BETWEEN 1 AND orderkey AS BIGINT) FROM orders GROUP BY orderkey");
    }

    @Test
    public void testAggregationImplicitCoercion() {
        this.assertQuery("SELECT 1.0 / COUNT(*) FROM orders");
        this.assertQuery("SELECT custkey, 1.0 / COUNT(*) FROM orders GROUP BY custkey");
    }

    @Test
    public void testWindowImplicitCoercion() {
        MaterializedResult actual = this.computeActual("SELECT orderkey, 1.0 / row_number() OVER (ORDER BY orderkey) FROM orders LIMIT 2");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(new Object[]{1L, 1.0}).row(new Object[]{2L, 0.5}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testWindowsSameOrdering() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT sum(quantity) OVER(PARTITION BY suppkey ORDER BY orderkey),min(tax) OVER(PARTITION BY suppkey ORDER BY shipdate)FROM lineitem ORDER BY 1 LIMIT 10");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE}).row(new Object[]{1.0, 0.0}).row(new Object[]{2.0, 0.0}).row(new Object[]{2.0, 0.0}).row(new Object[]{3.0, 0.0}).row(new Object[]{3.0, 0.0}).row(new Object[]{4.0, 0.0}).row(new Object[]{4.0, 0.0}).row(new Object[]{5.0, 0.0}).row(new Object[]{5.0, 0.0}).row(new Object[]{5.0, 0.0}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testWindowsPrefixPartitioning() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT max(tax) OVER(PARTITION BY suppkey, tax ORDER BY receiptdate),sum(quantity) OVER(PARTITION BY suppkey ORDER BY orderkey)FROM lineitem ORDER BY 2, 1 LIMIT 10");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE}).row(new Object[]{0.06, 1.0}).row(new Object[]{0.02, 2.0}).row(new Object[]{0.06, 2.0}).row(new Object[]{0.02, 3.0}).row(new Object[]{0.08, 3.0}).row(new Object[]{0.03, 4.0}).row(new Object[]{0.03, 4.0}).row(new Object[]{0.02, 5.0}).row(new Object[]{0.03, 5.0}).row(new Object[]{0.07, 5.0}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testWindowsDifferentPartitions() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT sum(quantity) OVER(PARTITION BY suppkey ORDER BY orderkey),count(discount) OVER(PARTITION BY partkey ORDER BY receiptdate),min(tax) OVER(PARTITION BY suppkey, tax ORDER BY receiptdate)FROM lineitem ORDER BY 1, 2 LIMIT 10");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT, DoubleType.DOUBLE}).row(new Object[]{1.0, 10L, 0.06}).row(new Object[]{2.0, 4L, 0.06}).row(new Object[]{2.0, 16L, 0.02}).row(new Object[]{3.0, 3L, 0.08}).row(new Object[]{3.0, 38L, 0.02}).row(new Object[]{4.0, 10L, 0.03}).row(new Object[]{4.0, 10L, 0.03}).row(new Object[]{5.0, 9L, 0.03}).row(new Object[]{5.0, 13L, 0.07}).row(new Object[]{5.0, 15L, 0.02}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testWindowsConstantExpression() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT sum(size) OVER(PARTITION BY type ORDER BY brand),lag(partkey, 1) OVER(PARTITION BY type ORDER BY name)FROM part ORDER BY 1, 2 LIMIT 10");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{1L, 315L}).row(new Object[]{1L, 881L}).row(new Object[]{1L, 1009L}).row(new Object[]{3L, 1087L}).row(new Object[]{3L, 1187L}).row(new Object[]{3L, 1529L}).row(new Object[]{4L, 969L}).row(new Object[]{5L, 151L}).row(new Object[]{5L, 505L}).row(new Object[]{5L, 872L}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testDependentWindows() throws Exception {
        String sql = "WITH t1 AS (SELECT extendedprice FROM lineitem ORDER BY orderkey, partkey LIMIT 2),t2 AS (SELECT extendedprice, sum(extendedprice) OVER() AS x FROM t1),t3 AS (SELECT max(x) OVER() FROM t2) SELECT * FROM t3";
        this.assertQuery(sql, "VALUES 59645.36, 59645.36");
    }

    @Test
    public void testHaving() {
        this.assertQuery("SELECT orderstatus, sum(totalprice) FROM orders GROUP BY orderstatus HAVING orderstatus = 'O'");
    }

    @Test
    public void testHaving2() {
        this.assertQuery("SELECT custkey, sum(orderkey) FROM orders GROUP BY custkey HAVING sum(orderkey) > 400000");
    }

    @Test
    public void testHaving3() {
        this.assertQuery("SELECT custkey, sum(totalprice) * 2 FROM orders GROUP BY custkey");
        this.assertQuery("SELECT custkey, avg(totalprice + 5) FROM orders GROUP BY custkey");
        this.assertQuery("SELECT custkey, sum(totalprice) * 2 FROM orders GROUP BY custkey HAVING avg(totalprice + 5) > 10");
    }

    @Test
    public void testHavingWithoutGroupBy() {
        this.assertQuery("SELECT sum(orderkey) FROM orders HAVING sum(orderkey) > 400000");
    }

    @Test
    public void testGroupByAsJoinProbe() {
        this.assertQuery("SELECT   b.orderkey,   b.custkey,   a.custkey FROM (   SELECT custkey  FROM orders   GROUP BY custkey) a JOIN orders b   ON a.custkey = b.custkey ");
    }

    @Test
    public void testJoinEffectivePredicateWithNoRanges() {
        this.assertQuery("SELECT * FROM orders a    JOIN (SELECT * FROM orders WHERE orderkey IS NULL) b    ON a.orderkey = b.orderkey");
    }

    @Test
    public void testColumnAliases() {
        this.assertQuery("SELECT x, T.y, z + 1 FROM (SELECT custkey, orderstatus, totalprice FROM orders) T (x, y, z)", "SELECT custkey, orderstatus, totalprice + 1 FROM orders");
    }

    @Test
    public void testSameInputToAggregates() {
        this.assertQuery("SELECT max(a), max(b) FROM (SELECT custkey a, custkey b FROM orders) x");
    }

    @Test
    public void testWindowFunctionWithImplicitCoercion() {
        this.assertQuery("SELECT *, 1.0 * sum(x) OVER () FROM (VALUES 1) t(x)", "SELECT 1, 1.0");
    }

    @Test
    public void testWindowFunctionsExpressions() {
        MaterializedResult actual = this.computeActual("SELECT orderkey, orderstatus\n, row_number() OVER (ORDER BY orderkey * 2) *\n  row_number() OVER (ORDER BY orderkey DESC) + 100\nFROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) x\nORDER BY orderkey LIMIT 5");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1L, "O", 110L}).row(new Object[]{2L, "O", 118L}).row(new Object[]{3L, "F", 124L}).row(new Object[]{4L, "O", 128L}).row(new Object[]{5L, "F", 130L}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testWindowFunctionsFromAggregate() {
        MaterializedResult actual = this.computeActual("SELECT * FROM (\n  SELECT orderstatus, clerk, sales\n  , rank() OVER (PARTITION BY x.orderstatus ORDER BY sales DESC) rnk\n  FROM (\n    SELECT orderstatus, clerk, sum(totalprice) sales\n    FROM orders\n    GROUP BY orderstatus, clerk\n   ) x\n) x\nWHERE rnk <= 2\nORDER BY orderstatus, rnk");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, DoubleType.DOUBLE, BigintType.BIGINT}).row(new Object[]{"F", "Clerk#000000090", 2784836.61, 1L}).row(new Object[]{"F", "Clerk#000000084", 2674447.15, 2L}).row(new Object[]{"O", "Clerk#000000500", 2569878.29, 1L}).row(new Object[]{"O", "Clerk#000000050", 2500162.92, 2L}).row(new Object[]{"P", "Clerk#000000071", 841820.99, 1L}).row(new Object[]{"P", "Clerk#000001000", 643679.49, 2L}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testOrderByWindowFunction() {
        MaterializedResult actual = this.computeActual("SELECT orderkey, row_number() OVER (ORDER BY orderkey)\nFROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10)\nORDER BY 2 DESC\nLIMIT 5");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{34L, 10L}).row(new Object[]{33L, 9L}).row(new Object[]{32L, 8L}).row(new Object[]{7L, 7L}).row(new Object[]{6L, 6L}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testSameWindowFunctionsTwoCoerces() {
        MaterializedResult actual = this.computeActual("SELECT 12.0 * row_number() OVER ()/row_number() OVER(),\nrow_number() OVER()\nFROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10)\nORDER BY 2 DESC\nLIMIT 5");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{12.0, 10L}).row(new Object[]{12.0, 9L}).row(new Object[]{12.0, 8L}).row(new Object[]{12.0, 7L}).row(new Object[]{12.0, 6L}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
        actual = this.computeActual("SELECT (MAX(x.a) OVER () - x.a) * 100.0 / MAX(x.a) OVER ()\nFROM (VALUES 1, 2, 3, 4) x(a)");
        expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{DoubleType.DOUBLE}).row(new Object[]{75.0}).row(new Object[]{50.0}).row(new Object[]{25.0}).row(new Object[]{0.0}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testRowNumberNoOptimization() {
        MaterializedResult actual = this.computeActual("SELECT orderkey, orderstatus FROM (\n   SELECT row_number() OVER () rn, orderkey, orderstatus\n   FROM orders\n) WHERE NOT rn <= 10");
        MaterializedResult all = this.computeExpected("SELECT orderkey, orderstatus FROM ORDERS", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)(all.getMaterializedRows().size() - 10));
        QueryAssertions.assertContains(all, actual);
        actual = this.computeActual("SELECT orderkey, orderstatus FROM (\n   SELECT row_number() OVER () rn, orderkey, orderstatus\n   FROM orders\n) WHERE rn - 5 <= 10");
        all = this.computeExpected("SELECT orderkey, orderstatus FROM ORDERS", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)15);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testRowNumberLimit() {
        MaterializedResult actual = this.computeActual("SELECT row_number() OVER (PARTITION BY orderstatus) rn, orderstatus\nFROM orders\nLIMIT 10");
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        actual = this.computeActual("SELECT row_number() OVER (PARTITION BY orderstatus ORDER BY orderkey) rn\nFROM orders\nLIMIT 10");
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        actual = this.computeActual("SELECT row_number() OVER () rn, orderstatus\nFROM orders\nLIMIT 10");
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        actual = this.computeActual("SELECT row_number() OVER (ORDER BY orderkey) rn\nFROM orders\nLIMIT 10");
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
    }

    @Test
    public void testRowNumberMultipleFilters() {
        MaterializedResult actual = this.computeActual("SELECT * FROM (   SELECT a, row_number() OVER (PARTITION BY a ORDER BY a) rn\n   FROM (VALUES (1), (1), (1), (2), (2), (3)) t (a)) t WHERE rn < 3 AND rn % 2 = 0 AND a = 2 LIMIT 2");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{2, 2L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testRowNumberFilterAndLimit() {
        MaterializedResult actual = this.computeActual("SELECT * FROM (SELECT a, row_number() OVER (PARTITION BY a ORDER BY a) rn\nFROM (VALUES (1), (2), (1), (2)) t (a)) t WHERE rn < 2 LIMIT 2");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{1, 1L}).row(new Object[]{2, 1L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
        actual = this.computeActual("SELECT * FROM (SELECT a, row_number() OVER (PARTITION BY a) rn\nFROM (VALUES (1), (2), (1), (2), (1)) t (a)) t WHERE rn < 3 LIMIT 2");
        expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{1, 1L}).row(new Object[]{1, 2L}).row(new Object[]{2, 1L}).row(new Object[]{2, 2L}).build();
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)2);
        QueryAssertions.assertContains(expected, actual);
    }

    @Test
    public void testRowNumberUnpartitionedFilter() {
        MaterializedResult actual = this.computeActual("SELECT orderkey, orderstatus FROM (\n   SELECT row_number() OVER () rn, orderkey, orderstatus\n   FROM orders\n) WHERE rn <= 5 AND orderstatus != 'Z'");
        MaterializedResult all = this.computeExpected("SELECT orderkey, orderstatus FROM ORDERS", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)5);
        QueryAssertions.assertContains(all, actual);
        actual = this.computeActual("SELECT orderkey, orderstatus FROM (\n   SELECT row_number() OVER () rn, orderkey, orderstatus\n   FROM orders\n) WHERE rn < 5");
        all = this.computeExpected("SELECT orderkey, orderstatus FROM ORDERS", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)4);
        QueryAssertions.assertContains(all, actual);
        actual = this.computeActual("SELECT orderkey, orderstatus FROM (\n   SELECT row_number() OVER () rn, orderkey, orderstatus\n   FROM orders\n) LIMIT 5");
        all = this.computeExpected("SELECT orderkey, orderstatus FROM ORDERS", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)5);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testRowNumberPartitionedFilter() {
        MaterializedResult actual = this.computeActual("SELECT orderkey, orderstatus FROM (\n   SELECT row_number() OVER (PARTITION BY orderstatus) rn, orderkey, orderstatus\n   FROM orders\n) WHERE rn <= 5");
        MaterializedResult all = this.computeExpected("SELECT orderkey, orderstatus FROM ORDERS", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)15);
        QueryAssertions.assertContains(all, actual);
        actual = this.computeActual("SELECT orderkey FROM (\n   SELECT row_number() OVER (PARTITION BY orderstatus) rn, orderkey\n   FROM orders\n) WHERE rn <= 5");
        all = this.computeExpected("SELECT orderkey FROM ORDERS", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)15);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testRowNumberJoin() {
        MaterializedResult actual = this.computeActual("SELECT a, rn\nFROM (\n    SELECT a, row_number() OVER (ORDER BY a) rn\n    FROM (VALUES (1), (2)) t (a)\n) a\nJOIN (VALUES (2)) b (b) ON a.a = b.b\nLIMIT 1");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{2, 2L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
        actual = this.computeActual("SELECT a, rn\nFROM (\n    SELECT a, row_number() OVER (PARTITION BY a ORDER BY a) rn\n    FROM (VALUES (1), (2), (1), (2)) t (a)\n) a\nJOIN (VALUES (2)) b (b) ON a.a = b.b\nLIMIT 2");
        expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{2, 1L}).row(new Object[]{2, 2L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testRowNumberUnpartitionedFilterLimit() {
        this.assertQuery("SELECT row_number() OVER ()\nFROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey\nWHERE orders.orderkey = 10000\nLIMIT 20");
    }

    @Test
    public void testRowNumberPropertyDerivation() {
        MaterializedResult actual = this.computeActual("SELECT orderkey, orderstatus, SUM(rn) OVER (PARTITION BY orderstatus) c\nFROM (\n   SELECT orderkey, orderstatus, row_number() OVER (PARTITION BY orderstatus) rn\n   FROM (\n       SELECT * FROM orders ORDER BY orderkey LIMIT 10\n   )\n)");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1L, "O", 21L}).row(new Object[]{2L, "O", 21L}).row(new Object[]{3L, "F", 10L}).row(new Object[]{4L, "O", 21L}).row(new Object[]{5L, "F", 10L}).row(new Object[]{6L, "F", 10L}).row(new Object[]{7L, "O", 21L}).row(new Object[]{32L, "O", 21L}).row(new Object[]{33L, "F", 10L}).row(new Object[]{34L, "O", 21L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testWindowPropertyDerivation() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, orderkey,\nSUM(s) OVER (PARTITION BY orderstatus),\nSUM(s) OVER (PARTITION BY orderstatus, orderkey),\nSUM(s) OVER (PARTITION BY orderstatus ORDER BY orderkey),\nSUM(s) OVER (ORDER BY orderstatus, orderkey)\nFROM (\n   SELECT orderkey, orderstatus, SUM(orderkey) OVER (ORDER BY orderstatus, orderkey) s\n   FROM (\n       SELECT * FROM orders ORDER BY orderkey LIMIT 10\n   )\n)");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{"F", 3L, 72L, 3L, 3L, 3L}).row(new Object[]{"F", 5L, 72L, 8L, 11L, 11L}).row(new Object[]{"F", 6L, 72L, 14L, 25L, 25L}).row(new Object[]{"F", 33L, 72L, 47L, 72L, 72L}).row(new Object[]{"O", 1L, 433L, 48L, 48L, 120L}).row(new Object[]{"O", 2L, 433L, 50L, 98L, 170L}).row(new Object[]{"O", 4L, 433L, 54L, 152L, 224L}).row(new Object[]{"O", 7L, 433L, 61L, 213L, 285L}).row(new Object[]{"O", 32L, 433L, 93L, 306L, 378L}).row(new Object[]{"O", 34L, 433L, 127L, 433L, 505L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testTopNUnpartitionedWindow() {
        MaterializedResult actual = this.computeActual("SELECT * FROM (\n   SELECT row_number() OVER (ORDER BY orderkey) rn, orderkey, orderstatus\n   FROM orders\n) WHERE rn <= 5");
        String sql = "SELECT row_number() OVER (), orderkey, orderstatus FROM orders ORDER BY orderkey LIMIT 5";
        MaterializedResult expected = this.computeExpected(sql, actual.getTypes());
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testTopNUnpartitionedLargeWindow() {
        MaterializedResult actual = this.computeActual("SELECT * FROM (\n   SELECT row_number() OVER (ORDER BY orderkey) rn, orderkey, orderstatus\n   FROM orders\n) WHERE rn <= 10000");
        String sql = "SELECT row_number() OVER (), orderkey, orderstatus FROM orders ORDER BY orderkey LIMIT 10000";
        MaterializedResult expected = this.computeExpected(sql, actual.getTypes());
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    @Test
    public void testTopNPartitionedWindow() {
        MaterializedResult actual = this.computeActual("SELECT * FROM (\n   SELECT row_number() OVER (PARTITION BY orderstatus ORDER BY orderkey) rn, orderkey, orderstatus\n   FROM orders\n) WHERE rn <= 2");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, VarcharType.VARCHAR}).row(new Object[]{1L, 1L, "O"}).row(new Object[]{2L, 2L, "O"}).row(new Object[]{1L, 3L, "F"}).row(new Object[]{2L, 5L, "F"}).row(new Object[]{1L, 65L, "P"}).row(new Object[]{2L, 197L, "P"}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
        actual = this.computeActual("SELECT * FROM (\n   SELECT row_number() OVER (PARTITION BY orderstatus ORDER BY orderkey) rn, orderkey\n   FROM orders\n) WHERE rn <= 2");
        expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{1L, 1L}).row(new Object[]{2L, 2L}).row(new Object[]{1L, 3L}).row(new Object[]{2L, 5L}).row(new Object[]{1L, 65L}).row(new Object[]{2L, 197L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
        actual = this.computeActual("SELECT * FROM (\n   SELECT row_number() OVER (PARTITION BY orderstatus ORDER BY orderkey) rn, orderstatus\n   FROM orders\n) WHERE rn <= 2");
        expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR}).row(new Object[]{1L, "O"}).row(new Object[]{2L, "O"}).row(new Object[]{1L, "F"}).row(new Object[]{2L, "F"}).row(new Object[]{1L, "P"}).row(new Object[]{2L, "P"}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testTopNUnpartitionedWindowWithEqualityFilter() {
        MaterializedResult actual = this.computeActual("SELECT * FROM (\n   SELECT row_number() OVER (ORDER BY orderkey) rn, orderkey, orderstatus\n   FROM orders\n) WHERE rn = 2");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, VarcharType.VARCHAR}).row(new Object[]{2L, 2L, "O"}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testTopNUnpartitionedWindowWithCompositeFilter() {
        MaterializedResult actual = this.computeActual("SELECT * FROM (\n   SELECT row_number() OVER (ORDER BY orderkey) rn, orderkey, orderstatus\n   FROM orders\n) WHERE rn = 1 OR rn IN (3, 4) OR rn BETWEEN 6 AND 7");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, VarcharType.VARCHAR}).row(new Object[]{1L, 1L, "O"}).row(new Object[]{3L, 3L, "F"}).row(new Object[]{4L, 4L, "O"}).row(new Object[]{6L, 6L, "F"}).row(new Object[]{7L, 7L, "O"}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testTopNPartitionedWindowWithEqualityFilter() {
        MaterializedResult actual = this.computeActual("SELECT * FROM (\n   SELECT row_number() OVER (PARTITION BY orderstatus ORDER BY orderkey) rn, orderkey, orderstatus\n   FROM orders\n) WHERE rn = 2");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, VarcharType.VARCHAR}).row(new Object[]{2L, 2L, "O"}).row(new Object[]{2L, 5L, "F"}).row(new Object[]{2L, 197L, "P"}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
        actual = this.computeActual("SELECT * FROM (\n   SELECT row_number() OVER (PARTITION BY orderstatus ORDER BY orderkey) rn, orderkey\n   FROM orders\n) WHERE rn = 2");
        expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{2L, 2L}).row(new Object[]{2L, 5L}).row(new Object[]{2L, 197L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
        actual = this.computeActual("SELECT * FROM (\n   SELECT row_number() OVER (PARTITION BY orderstatus ORDER BY orderkey) rn, orderstatus\n   FROM orders\n) WHERE rn = 2");
        expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR}).row(new Object[]{2L, "O"}).row(new Object[]{2L, "F"}).row(new Object[]{2L, "P"}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testWindowFunctionWithGroupBy() {
        MaterializedResult actual = this.computeActual("SELECT *, rank() OVER (PARTITION BY x)\nFROM (SELECT 'foo' x)\nGROUP BY 1");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{"foo", 1L}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testPartialPrePartitionedWindowFunction() {
        MaterializedResult actual = this.computeActual("SELECT orderkey, COUNT(*) OVER (PARTITION BY orderkey, custkey)\nFROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10)\nORDER BY orderkey LIMIT 5");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{1L, 1L}).row(new Object[]{2L, 1L}).row(new Object[]{3L, 1L}).row(new Object[]{4L, 1L}).row(new Object[]{5L, 1L}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testFullPrePartitionedWindowFunction() {
        MaterializedResult actual = this.computeActual("SELECT orderkey, COUNT(*) OVER (PARTITION BY orderkey)\nFROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10)\nORDER BY orderkey LIMIT 5");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{1L, 1L}).row(new Object[]{2L, 1L}).row(new Object[]{3L, 1L}).row(new Object[]{4L, 1L}).row(new Object[]{5L, 1L}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testPartialPreSortedWindowFunction() {
        MaterializedResult actual = this.computeActual("SELECT orderkey, COUNT(*) OVER (ORDER BY orderkey, custkey)\nFROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10)\nORDER BY orderkey LIMIT 5");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{1L, 1L}).row(new Object[]{2L, 2L}).row(new Object[]{3L, 3L}).row(new Object[]{4L, 4L}).row(new Object[]{5L, 5L}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testFullPreSortedWindowFunction() {
        MaterializedResult actual = this.computeActual("SELECT orderkey, COUNT(*) OVER (ORDER BY orderkey)\nFROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10)\nORDER BY orderkey LIMIT 5");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{1L, 1L}).row(new Object[]{2L, 2L}).row(new Object[]{3L, 3L}).row(new Object[]{4L, 4L}).row(new Object[]{5L, 5L}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testFullyPartitionedAndPartiallySortedWindowFunction() {
        MaterializedResult actual = this.computeActual("SELECT orderkey, custkey, orderPriority, COUNT(*) OVER (PARTITION BY orderkey ORDER BY custkey, orderPriority)\nFROM (SELECT * FROM orders ORDER BY orderkey, custkey LIMIT 10)\nORDER BY orderkey LIMIT 5");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1L, 370L, "5-LOW", 1L}).row(new Object[]{2L, 781L, "1-URGENT", 1L}).row(new Object[]{3L, 1234L, "5-LOW", 1L}).row(new Object[]{4L, 1369L, "5-LOW", 1L}).row(new Object[]{5L, 445L, "5-LOW", 1L}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testFullyPartitionedAndFullySortedWindowFunction() {
        MaterializedResult actual = this.computeActual("SELECT orderkey, custkey, COUNT(*) OVER (PARTITION BY orderkey ORDER BY custkey)\nFROM (SELECT * FROM orders ORDER BY orderkey, custkey LIMIT 10)\nORDER BY orderkey LIMIT 5");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1L, 370L, 1L}).row(new Object[]{2L, 781L, 1L}).row(new Object[]{3L, 1234L, 1L}).row(new Object[]{4L, 1369L, 1L}).row(new Object[]{5L, 445L, 1L}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testOrderByWindowFunctionWithNulls() {
        MaterializedResult actual = this.computeActual("SELECT orderkey, row_number() OVER (ORDER BY nullif(orderkey, 3) NULLS FIRST)\nFROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10)\nORDER BY 2 ASC\nLIMIT 5");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{3L, 1L}).row(new Object[]{1L, 2L}).row(new Object[]{2L, 3L}).row(new Object[]{4L, 4L}).row(new Object[]{5L, 5L}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
        actual = this.computeActual("SELECT orderkey, row_number() OVER (ORDER BY nullif(orderkey, 3) NULLS LAST)\nFROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10)\nORDER BY 2 DESC\nLIMIT 5");
        expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{3L, 10L}).row(new Object[]{34L, 9L}).row(new Object[]{33L, 8L}).row(new Object[]{32L, 7L}).row(new Object[]{7L, 6L}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
        actual = this.computeActual("SELECT orderkey, row_number() OVER (ORDER BY nullif(orderkey, 3))\nFROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10)\nORDER BY 2 DESC\nLIMIT 5");
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testValueWindowFunctions() {
        MaterializedResult actual = this.computeActual("SELECT * FROM (\n  SELECT orderkey, orderstatus\n    , first_value(orderkey + 1000) OVER (PARTITION BY orderstatus ORDER BY orderkey) fvalue\n    , nth_value(orderkey + 1000, 2) OVER (PARTITION BY orderstatus ORDER BY orderkey\n        ROWS BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING) nvalue\n    FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) x\n  ) x\nORDER BY orderkey LIMIT 5");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{1L, "O", 1001L, 1002L}).row(new Object[]{2L, "O", 1001L, 1002L}).row(new Object[]{3L, "F", 1003L, 1005L}).row(new Object[]{4L, "O", 1001L, 1002L}).row(new Object[]{5L, "F", 1003L, 1005L}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testWindowFrames() {
        MaterializedResult actual = this.computeActual("SELECT * FROM (\n  SELECT orderkey, orderstatus\n    , sum(orderkey + 1000) OVER (PARTITION BY orderstatus ORDER BY orderkey\n        ROWS BETWEEN mod(custkey, 2) PRECEDING AND custkey / 500 FOLLOWING)\n    FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) x\n  ) x\nORDER BY orderkey LIMIT 5");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1L, "O", 1001L}).row(new Object[]{2L, "O", 3007L}).row(new Object[]{3L, "F", 3014L}).row(new Object[]{4L, "O", 4045L}).row(new Object[]{5L, "F", 2008L}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testWindowNoChannels() {
        MaterializedResult actual = this.computeActual("SELECT rank() OVER ()\nFROM (SELECT * FROM orders LIMIT 10)\nLIMIT 3");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1L}).row(new Object[]{1L}).row(new Object[]{1L}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testScalarFunction() {
        this.assertQuery("SELECT SUBSTR('Quadratically', 5, 6) FROM orders LIMIT 1");
    }

    @Test
    public void testCast() {
        this.assertQuery("SELECT CAST('1' AS BIGINT) FROM orders");
        this.assertQuery("SELECT CAST(totalprice AS BIGINT) FROM orders");
        this.assertQuery("SELECT CAST(orderkey AS DOUBLE) FROM orders");
        this.assertQuery("SELECT CAST(orderkey AS VARCHAR) FROM orders");
        this.assertQuery("SELECT CAST(orderkey AS BOOLEAN) FROM orders");
        this.assertQuery("SELECT try_cast('1' AS BIGINT) FROM orders", "SELECT CAST('1' AS BIGINT) FROM orders");
        this.assertQuery("SELECT try_cast(totalprice AS BIGINT) FROM orders", "SELECT CAST(totalprice AS BIGINT) FROM orders");
        this.assertQuery("SELECT try_cast(orderkey AS DOUBLE) FROM orders", "SELECT CAST(orderkey AS DOUBLE) FROM orders");
        this.assertQuery("SELECT try_cast(orderkey AS VARCHAR) FROM orders", "SELECT CAST(orderkey AS VARCHAR) FROM orders");
        this.assertQuery("SELECT try_cast(orderkey AS BOOLEAN) FROM orders", "SELECT CAST(orderkey AS BOOLEAN) FROM orders");
        this.assertQuery("SELECT try_cast('foo' AS BIGINT) FROM orders", "SELECT CAST(null AS BIGINT) FROM orders");
        this.assertQuery("SELECT try_cast(clerk AS BIGINT) FROM orders", "SELECT CAST(null AS BIGINT) FROM orders");
        this.assertQuery("SELECT try_cast(orderkey * orderkey AS VARCHAR) FROM orders", "SELECT CAST(orderkey * orderkey AS VARCHAR) FROM orders");
        this.assertQuery("SELECT try_cast(try_cast(orderkey AS VARCHAR) AS BIGINT) FROM orders", "SELECT orderkey FROM orders");
        this.assertQuery("SELECT try_cast(clerk AS VARCHAR) || try_cast(clerk AS VARCHAR) FROM orders", "SELECT clerk || clerk FROM orders");
        this.assertQuery("SELECT coalesce(try_cast('foo' AS BIGINT), 456) FROM orders", "SELECT 456 FROM orders");
        this.assertQuery("SELECT coalesce(try_cast(clerk AS BIGINT), 456) FROM orders", "SELECT 456 FROM orders");
        this.assertQuery("SELECT CAST(x AS BIGINT) FROM (VALUES 1, 2, 3, NULL) t (x)", "VALUES 1, 2, 3, NULL");
        this.assertQuery("SELECT try_cast(x AS BIGINT) FROM (VALUES 1, 2, 3, NULL) t (x)", "VALUES 1, 2, 3, NULL");
    }

    @Test
    public void testInvalidCast() {
        this.assertQueryFails("SELECT CAST(1 AS DATE) FROM orders", "line 1:8: Cannot cast integer to date");
    }

    @Test
    public void testInvalidCastInMultilineQuery() {
        this.assertQueryFails("SELECT CAST(totalprice AS BIGINT),\nCAST(2015 AS DATE),\nCAST(orderkey AS DOUBLE) FROM orders", "line 2:1: Cannot cast integer to date");
    }

    @Test
    public void testTryInvalidCast() {
        this.assertQuery("SELECT TRY(CAST('a' AS BIGINT))", "SELECT NULL");
    }

    @Test
    public void testConcatOperator() {
        this.assertQuery("SELECT '12' || '34' FROM orders LIMIT 1");
    }

    @Test
    public void testQuotedIdentifiers() {
        this.assertQuery("SELECT \"TOTALPRICE\" \"my price\" FROM \"ORDERS\"");
    }

    @Test
    public void testInvalidColumn() {
        this.assertQueryFails("select * from lineitem l join (select orderkey_1, custkey from orders) o on l.orderkey = o.orderkey_1", "line 1:39: Column 'orderkey_1' cannot be resolved");
    }

    @Test
    public void testUnaliasedSubqueries() {
        this.assertQuery("SELECT orderkey FROM (SELECT orderkey FROM orders)");
    }

    @Test
    public void testUnaliasedSubqueries1() {
        this.assertQuery("SELECT a FROM (SELECT orderkey a FROM orders)");
    }

    @Test
    public void testJoinUnaliasedSubqueries() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem) join (SELECT * FROM orders) using (orderkey)", "SELECT COUNT(*) FROM lineitem join orders on lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testWith() {
        this.assertQuery("WITH a AS (SELECT * FROM orders) SELECT * FROM a", "SELECT * FROM orders");
    }

    @Test
    public void testWithQualifiedPrefix() {
        this.assertQuery("WITH a AS (SELECT 123 FROM orders LIMIT 1)SELECT a.* FROM a", "SELECT 123 FROM orders LIMIT 1");
    }

    @Test
    public void testWithAliased() {
        this.assertQuery("WITH a AS (SELECT * FROM orders) SELECT * FROM a x", "SELECT * FROM orders");
    }

    @Test
    public void testReferenceToWithQueryInFromClause() {
        this.assertQuery("WITH a AS (SELECT * FROM orders)SELECT * FROM (   SELECT * FROM a)", "SELECT * FROM orders");
    }

    @Test
    public void testWithChaining() {
        this.assertQuery("WITH a AS (SELECT orderkey n FROM orders)\n, b AS (SELECT n + 1 n FROM a)\n, c AS (SELECT n + 1 n FROM b)\nSELECT n + 1 FROM c", "SELECT orderkey + 3 FROM orders");
    }

    @Test
    public void testWithSelfJoin() {
        this.assertQuery("WITH x AS (SELECT DISTINCT orderkey FROM orders ORDER BY orderkey LIMIT 10)\nSELECT count(*) FROM x a JOIN x b USING (orderkey)", "SELECT count(*)\nFROM (SELECT DISTINCT orderkey FROM orders ORDER BY orderkey LIMIT 10) a\nJOIN (SELECT DISTINCT orderkey FROM orders ORDER BY orderkey LIMIT 10) b ON a.orderkey = b.orderkey");
    }

    @Test
    public void testWithNestedSubqueries() {
        this.assertQuery("WITH a AS (\n  WITH aa AS (SELECT 123 x FROM orders LIMIT 1)\n  SELECT x y FROM aa\n), b AS (\n  WITH bb AS (\n    WITH bbb AS (SELECT y FROM a)\n    SELECT bbb.* FROM bbb\n  )\n  SELECT y z FROM bb\n)\nSELECT *\nFROM (\n  WITH q AS (SELECT z w FROM b)\n  SELECT j.*, k.*\n  FROM a j\n  JOIN q k ON (j.y = k.w)\n) t", "SELECT 123, 123 FROM orders LIMIT 1");
    }

    @Test
    public void testWithColumnAliasing() {
        this.assertQuery("WITH a (id) AS (SELECT 123 FROM orders LIMIT 1) SELECT id FROM a", "SELECT 123 FROM orders LIMIT 1");
        this.assertQuery("WITH t (a, b, c) AS (SELECT 1, custkey x, orderkey FROM orders) SELECT c, b, a FROM t", "SELECT orderkey, custkey, 1 FROM orders");
    }

    @Test
    public void testWithHiding() {
        this.assertQuery("WITH a AS (SELECT 1),      b AS (         WITH a AS (SELECT 2)         SELECT * FROM a    )SELECT * FROM b", "SELECT 2");
        this.assertQueryFails("WITH a AS (VALUES 1),      a AS (VALUES 2)SELECT * FROM a", "line 1:28: WITH query name 'a' specified more than once");
    }

    @Test
    public void testWithRecursive() {
        this.assertQueryFails("WITH RECURSIVE a AS (SELECT 123) SELECT * FROM a", "line 1:1: Recursive WITH queries are not supported");
    }

    @Test
    public void testCaseNoElse() {
        this.assertQuery("SELECT orderkey, CASE orderstatus WHEN 'O' THEN 'a' END FROM orders");
    }

    @Test
    public void testCaseNoElseInconsistentResultType() {
        this.assertQueryFails("SELECT orderkey, CASE orderstatus WHEN 'O' THEN 'a' WHEN '1' THEN 2 END FROM orders", "\\Qline 1:67: All CASE results must be the same type: varchar(1)\\E");
    }

    @Test
    public void testCaseWithSupertypeCast() {
        this.assertQuery(" SELECT CASE x WHEN 1 THEN cast(1 as decimal(4,1)) WHEN 2 THEN cast(1 as decimal(4,2)) ELSE cast(1 as decimal(4,3)) END FROM (values 1) t(x)", "SELECT 1.000");
    }

    @Test
    public void testIfExpression() {
        this.assertQuery("SELECT sum(IF(orderstatus = 'F', totalprice, 0.0)) FROM orders", "SELECT sum(CASE WHEN orderstatus = 'F' THEN totalprice ELSE 0.0 END) FROM orders");
        this.assertQuery("SELECT sum(IF(orderstatus = 'Z', totalprice)) FROM orders", "SELECT sum(CASE WHEN orderstatus = 'Z' THEN totalprice END) FROM orders");
        this.assertQuery("SELECT sum(IF(orderstatus = 'F', NULL, totalprice)) FROM orders", "SELECT sum(CASE WHEN orderstatus = 'F' THEN NULL ELSE totalprice END) FROM orders");
        this.assertQuery("SELECT IF(orderstatus = 'Z', orderkey / 0, orderkey) FROM orders", "SELECT CASE WHEN orderstatus = 'Z' THEN orderkey / 0 ELSE orderkey END FROM orders");
        this.assertQuery("SELECT sum(IF(NULLIF(orderstatus, 'F') <> 'F', totalprice, 5.1)) FROM orders", "SELECT sum(CASE WHEN NULLIF(orderstatus, 'F') <> 'F' THEN totalprice ELSE 5.1 END) FROM orders");
        this.assertQuery("SELECT if(true, cast(1 as decimal(2,1)), 1)", "SELECT 1.0");
    }

    @Test
    public void testIn() {
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (1, 2, 3)");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (1.5, 2.3)", "SELECT orderkey FROM orders LIMIT 0");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (1, 2.0, 3)");
        this.assertQuery("SELECT orderkey FROM orders WHERE totalprice IN (1, 2, 3)");
        this.assertQuery("SELECT x FROM (values 3, 100) t(x) WHERE x IN (2147483649)", "SELECT * WHERE false");
        this.assertQuery("SELECT x FROM (values 3, 100, 2147483648, 2147483649, 2147483650) t(x) WHERE x IN (2147483648, 2147483650)", "values 2147483648, 2147483650");
        this.assertQuery("SELECT x FROM (values 3, 100, 2147483648, 2147483649, 2147483650) t(x) WHERE x IN (3, 4, 2147483648, 2147483650)", "values 3, 2147483648, 2147483650");
        this.assertQuery("SELECT x FROM (values 1, 2, 3) t(x) WHERE x IN (1 + cast(rand() < 0 as bigint), 2 + cast(rand() < 0 as bigint))", "values 1, 2");
        this.assertQuery("SELECT x FROM (values 1, 2, 3, 4) t(x) WHERE x IN (1 + cast(rand() < 0 as bigint), 2 + cast(rand() < 0 as bigint), 4)", "values 1, 2, 4");
        this.assertQuery("SELECT x FROM (values 1, 2, 3, 4) t(x) WHERE x IN (4, 2, 1)", "values 1, 2, 4");
        this.assertQuery("SELECT x FROM (values 1, 2, 3, 2147483648) t(x) WHERE x IN (1 + cast(rand() < 0 as bigint), 2 + cast(rand() < 0 as bigint), 2147483648)", "values 1, 2, 2147483648");
        this.assertQuery("SELECT x IN (0) FROM (values 4294967296) t(x)", "values false");
        this.assertQuery("SELECT x IN (0, 4294967297 + cast(rand() < 0 as bigint)) FROM (values 4294967296, 4294967297) t(x)", "values false, true");
        this.assertQuery("SELECT NULL in (1, 2, 3)", "values null");
        this.assertQuery("SELECT 1 in (1, NULL, 3)", "values true");
        this.assertQuery("SELECT 2 in (1, NULL, 3)", "values null");
        this.assertQuery("SELECT x FROM (values DATE '1970-01-01', DATE '1970-01-03') t(x) WHERE x IN (DATE '1970-01-01')", "values DATE '1970-01-01'");
        this.assertQuery("SELECT x FROM (values TIMESTAMP '1970-01-01 00:01:00+00:00', TIMESTAMP '1970-01-01 08:01:00+08:00', TIMESTAMP '1970-01-01 00:01:00+08:00') t(x) WHERE x IN (TIMESTAMP '1970-01-01 00:01:00+00:00')", "values TIMESTAMP '1970-01-01 00:01:00+00:00', TIMESTAMP '1970-01-01 08:01:00+08:00'");
        this.assertQuery("SELECT COUNT(*) FROM (values 1) t(x) WHERE x IN (null, 0)", "SELECT 0");
        this.assertQuery("SELECT d IN (DECIMAL '2.0', DECIMAL '30.0') FROM (VALUES (DOUBLE '2.0')) t(d)", "SELECT true");
    }

    @Test
    public void testLargeIn() {
        String longValues = IntStream.range(0, 5000).mapToObj(Integer::toString).collect(Collectors.joining(", "));
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (" + longValues + ")");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey NOT IN (" + longValues + ")");
        String arrayValues = IntStream.range(0, 5000).mapToObj(i -> String.format("ARRAY[%s, %s, %s]", i, i + 1, i + 2)).collect(Collectors.joining(", "));
        this.assertQuery("SELECT ARRAY[0, 0, 0] in (ARRAY[0, 0, 0], " + arrayValues + ")", "values true");
        this.assertQuery("SELECT ARRAY[0, 0, 0] in (" + arrayValues + ")", "values false");
    }

    @Test
    public void testNullOnLhsOfInPredicateDisallowed() {
        String errorMessage = "\\QNULL values are not allowed on the probe side of SemiJoin operator\\E.*";
        this.assertQueryFails("SELECT NULL IN (SELECT 1)", errorMessage);
        this.assertQueryFails("SELECT x FROM (VALUES NULL) t(x) WHERE x IN (SELECT 1)", errorMessage);
    }

    @Test
    public void testInSubqueryWithCrossJoin() {
        this.assertQuery("SELECT a FROM (VALUES (1),(2)) t(a) WHERE a IN (SELECT b FROM (VALUES (ARRAY[2])) AS t1 (a) CROSS JOIN UNNEST(a) as t2(b))", "SELECT 2");
    }

    @Test
    public void testGroupByIf() {
        this.assertQuery("SELECT IF(orderkey between 1 and 5, 'orders', 'others'), sum(totalprice) FROM orders GROUP BY 1", "SELECT CASE WHEN orderkey BETWEEN 1 AND 5 THEN 'orders' ELSE 'others' END, sum(totalprice)\nFROM orders\nGROUP BY CASE WHEN orderkey BETWEEN 1 AND 5 THEN 'orders' ELSE 'others' END");
    }

    @Test
    public void testDuplicateFields() {
        this.assertQuery("SELECT * FROM (SELECT orderkey, orderkey FROM orders)", "SELECT orderkey, orderkey FROM orders");
    }

    @Test
    public void testDuplicateColumnsInWindowOrderByClause() {
        MaterializedResult actual = this.computeActual("SELECT a, row_number() OVER (ORDER BY a, a) FROM (VALUES 3, 2, 1) t(a)");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{1, 1L}).row(new Object[]{2, 2L}).row(new Object[]{3, 3L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    @Test
    public void testWildcardFromSubquery() {
        this.assertQuery("SELECT * FROM (SELECT orderkey X FROM orders)");
    }

    @Test
    public void testCaseInsensitiveOutputAliasInOrderBy() {
        this.assertQueryOrdered("SELECT orderkey X FROM orders ORDER BY x");
    }

    @Test
    public void testCaseInsensitiveAttribute() {
        this.assertQuery("SELECT x FROM (SELECT orderkey X FROM orders)");
    }

    @Test
    public void testCaseInsensitiveAliasedRelation() {
        this.assertQuery("SELECT A.* FROM orders a");
    }

    @Test
    public void testCaseInsensitiveRowFieldReference() {
        this.assertQuery("SELECT a.Col0 FROM (VALUES row(cast(ROW(1,2) as ROW(col0 integer, col1 integer)))) AS t (a)", "SELECT 1");
    }

    @Test
    public void testSubqueryBody() {
        this.assertQuery("(SELECT orderkey, custkey FROM ORDERS)");
    }

    @Test
    public void testSubqueryBodyOrderLimit() {
        this.assertQueryOrdered("(SELECT orderkey AS a, custkey AS b FROM ORDERS) ORDER BY a LIMIT 1");
    }

    @Test
    public void testSubqueryBodyProjectedOrderby() {
        this.assertQueryOrdered("(SELECT orderkey, custkey FROM ORDERS) ORDER BY orderkey * -1");
    }

    @Test
    public void testSubqueryBodyDoubleOrderby() {
        this.assertQueryOrdered("(SELECT orderkey, custkey FROM ORDERS ORDER BY custkey) ORDER BY orderkey");
    }

    @Test
    public void testNodeRoster() {
        List result = this.computeActual("SELECT * FROM system.runtime.nodes").getMaterializedRows();
        Assert.assertEquals((int)result.size(), (int)this.getNodeCount());
    }

    @Test
    public void testCountOnInternalTables() {
        List rows = this.computeActual("SELECT count(*) FROM system.runtime.nodes").getMaterializedRows();
        Assert.assertEquals((long)((Long)((MaterializedRow)rows.get(0)).getField(0)), (long)this.getNodeCount());
    }

    @Test
    public void testTransactionsTable() {
        List result = this.computeActual("SELECT * FROM system.runtime.transactions").getMaterializedRows();
        Assert.assertTrue((result.size() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testDefaultExplainTextFormat() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN " + query);
        Assert.assertEquals((String)((String)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet())), (String)this.getExplainPlan(query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testDefaultExplainGraphvizFormat() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (FORMAT GRAPHVIZ) " + query);
        Assert.assertEquals((String)((String)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet())), (String)this.getGraphvizExplainPlan(query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testLogicalExplain() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE LOGICAL) " + query);
        Assert.assertEquals((String)((String)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet())), (String)this.getExplainPlan(query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testLogicalExplainTextFormat() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE LOGICAL, FORMAT TEXT) " + query);
        Assert.assertEquals((String)((String)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet())), (String)this.getExplainPlan(query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testLogicalExplainGraphvizFormat() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE LOGICAL, FORMAT GRAPHVIZ) " + query);
        Assert.assertEquals((String)((String)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet())), (String)this.getGraphvizExplainPlan(query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testDistributedExplain() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE DISTRIBUTED) " + query);
        Assert.assertEquals((String)((String)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet())), (String)this.getExplainPlan(query, ExplainType.Type.DISTRIBUTED));
    }

    @Test
    public void testDistributedExplainTextFormat() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE DISTRIBUTED, FORMAT TEXT) " + query);
        Assert.assertEquals((String)((String)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet())), (String)this.getExplainPlan(query, ExplainType.Type.DISTRIBUTED));
    }

    @Test
    public void testDistributedExplainGraphvizFormat() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE DISTRIBUTED, FORMAT GRAPHVIZ) " + query);
        Assert.assertEquals((String)((String)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet())), (String)this.getGraphvizExplainPlan(query, ExplainType.Type.DISTRIBUTED));
    }

    @Test
    public void testExplainValidate() {
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE VALIDATE) SELECT 1");
        Assert.assertEquals((Object)result.getOnlyValue(), (Object)true);
    }

    @Test(expectedExceptions={Exception.class}, expectedExceptionsMessageRegExp="line 1:32: Column 'x' cannot be resolved")
    public void testExplainValidateThrows() {
        this.computeActual("EXPLAIN (TYPE VALIDATE) SELECT x");
    }

    @Test
    public void testExplainOfExplain() {
        String query = "EXPLAIN SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN " + query);
        Assert.assertEquals((String)((String)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet())), (String)this.getExplainPlan(query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testExplainOfExplainAnalyze() {
        String query = "EXPLAIN ANALYZE SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN " + query);
        Assert.assertEquals((String)((String)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet())), (String)this.getExplainPlan(query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testExplainDdl() {
        this.assertExplainDdl("CREATE TABLE foo (pk bigint)", "CREATE TABLE foo");
        this.assertExplainDdl("CREATE VIEW foo AS SELECT * FROM orders", "CREATE VIEW foo");
        this.assertExplainDdl("DROP TABLE orders");
        this.assertExplainDdl("DROP VIEW view");
        this.assertExplainDdl("ALTER TABLE orders RENAME TO new_name");
        this.assertExplainDdl("ALTER TABLE orders RENAME COLUMN orderkey TO new_column_name");
        this.assertExplainDdl("SET SESSION foo = 'bar'");
        this.assertExplainDdl("PREPARE my_query FROM SELECT * FROM orders", "PREPARE my_query");
        this.assertExplainDdl("DEALLOCATE PREPARE my_query");
        this.assertExplainDdl("RESET SESSION foo");
        this.assertExplainDdl("START TRANSACTION");
        this.assertExplainDdl("COMMIT");
        this.assertExplainDdl("ROLLBACK");
    }

    private void assertExplainDdl(String query) {
        this.assertExplainDdl(query, query);
    }

    private void assertExplainDdl(String query, String expected) {
        MaterializedResult result = this.computeActual("EXPLAIN " + query);
        Assert.assertEquals((String)((String)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet())), (String)expected);
    }

    @Test
    public void testExplainExecute() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SELECT * FROM orders").build();
        MaterializedResult result = this.computeActual(session, "EXPLAIN (TYPE LOGICAL) EXECUTE my_query");
        Assert.assertEquals((String)((String)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet())), (String)this.getExplainPlan("SELECT * FROM orders", ExplainType.Type.LOGICAL));
    }

    @Test
    public void testExplainExecuteWithUsing() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SELECT * FROM orders where orderkey < ?").build();
        MaterializedResult result = this.computeActual(session, "EXPLAIN (TYPE LOGICAL) EXECUTE my_query USING 7");
        Assert.assertEquals((String)((String)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet())), (String)this.getExplainPlan("SELECT * FROM orders where orderkey < 7", ExplainType.Type.LOGICAL));
    }

    @Test
    public void testExplainSetSessionWithUsing() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SET SESSION foo = ?").build();
        MaterializedResult result = this.computeActual(session, "EXPLAIN (TYPE LOGICAL) EXECUTE my_query USING 7");
        Assert.assertEquals((String)((String)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet())), (String)"SET SESSION foo = 7");
    }

    @Test
    public void testShowCatalogs() {
        MaterializedResult result = this.computeActual("SHOW CATALOGS");
        Assert.assertTrue((boolean)result.getOnlyColumnAsSet().contains(this.getSession().getCatalog().get()));
    }

    @Test
    public void testShowCatalogsLike() {
        MaterializedResult result = this.computeActual(String.format("SHOW CATALOGS LIKE '%s'", this.getSession().getCatalog().get()));
        Assert.assertEquals((Set)result.getOnlyColumnAsSet(), (Set)ImmutableSet.of(this.getSession().getCatalog().get()));
    }

    @Test
    public void testShowSchemas() {
        MaterializedResult result = this.computeActual("SHOW SCHEMAS");
        Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll((Collection<?>)ImmutableSet.of(this.getSession().getSchema().get(), (Object)"information_schema")));
    }

    @Test
    public void testShowSchemasFrom() {
        MaterializedResult result = this.computeActual(String.format("SHOW SCHEMAS FROM %s", this.getSession().getCatalog().get()));
        Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll((Collection<?>)ImmutableSet.of(this.getSession().getSchema().get(), (Object)"information_schema")));
    }

    @Test
    public void testShowSchemasLike() {
        MaterializedResult result = this.computeActual(String.format("SHOW SCHEMAS LIKE '%s'", this.getSession().getSchema().get()));
        Assert.assertEquals((Set)result.getOnlyColumnAsSet(), (Set)ImmutableSet.of(this.getSession().getSchema().get()));
    }

    @Test
    public void testShowTables() {
        ImmutableSet expectedTables = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)TpchTable.getTables(), (Function)TpchTable.tableNameGetter()));
        MaterializedResult result = this.computeActual("SHOW TABLES");
        Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll((Collection<?>)expectedTables));
    }

    @Test
    public void testShowTablesFrom() {
        ImmutableSet expectedTables = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)TpchTable.getTables(), (Function)TpchTable.tableNameGetter()));
        String catalog = (String)this.getSession().getCatalog().get();
        String schema = (String)this.getSession().getSchema().get();
        MaterializedResult result = this.computeActual("SHOW TABLES FROM " + schema);
        Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll((Collection<?>)expectedTables));
        result = this.computeActual("SHOW TABLES FROM " + catalog + "." + schema);
        Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll((Collection<?>)expectedTables));
        try {
            this.computeActual("SHOW TABLES FROM UNKNOWN");
            Assert.fail((String)"Showing tables in an unknown schema should fail");
        }
        catch (SemanticException e) {
            Assert.assertEquals((Object)e.getCode(), (Object)SemanticErrorCode.MISSING_SCHEMA);
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"line 1:1: Schema 'unknown' does not exist");
        }
    }

    @Test
    public void testShowTablesLike() {
        MaterializedResult result = this.computeActual("SHOW TABLES LIKE 'or%'");
        Assert.assertEquals((Set)result.getOnlyColumnAsSet(), (Set)ImmutableSet.of((Object)TpchTable.ORDERS.getTableName()));
    }

    @Test
    public void testShowColumns() {
        MaterializedResult actual = this.computeActual("SHOW COLUMNS FROM orders");
        MaterializedResult expectedUnparametrizedVarchar = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", "", ""}).row(new Object[]{"custkey", "bigint", "", ""}).row(new Object[]{"orderstatus", "varchar", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", "date", "", ""}).row(new Object[]{"orderpriority", "varchar", "", ""}).row(new Object[]{"clerk", "varchar", "", ""}).row(new Object[]{"shippriority", "integer", "", ""}).row(new Object[]{"comment", "varchar", "", ""}).build();
        MaterializedResult expectedParametrizedVarchar = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", "", ""}).row(new Object[]{"custkey", "bigint", "", ""}).row(new Object[]{"orderstatus", "varchar(1)", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", "date", "", ""}).row(new Object[]{"orderpriority", "varchar(15)", "", ""}).row(new Object[]{"clerk", "varchar(15)", "", ""}).row(new Object[]{"shippriority", "integer", "", ""}).row(new Object[]{"comment", "varchar(79)", "", ""}).build();
        Assert.assertTrue((actual.equals((Object)expectedParametrizedVarchar) || actual.equals((Object)expectedUnparametrizedVarchar) ? 1 : 0) != 0, (String)String.format("%s does not matche neither of %s and %s", actual, expectedParametrizedVarchar, expectedUnparametrizedVarchar));
    }

    @Test
    public void testAtTimeZone() {
        this.assertQuery("SELECT TIMESTAMP '2012-10-31 01:00' AT TIME ZONE INTERVAL '07:09' hour to minute", "SELECT TIMESTAMP '2012-10-30 18:00:00.000 America/Los_Angeles'");
        this.assertQuery("SELECT TIMESTAMP '2012-10-31 01:00' AT TIME ZONE 'Asia/Oral'", "SELECT TIMESTAMP '2012-10-30 18:00:00.000 America/Los_Angeles'");
        this.assertQuery("SELECT MIN(x) AT TIME ZONE 'America/Chicago' from (VALUES TIMESTAMP '1970-01-01 00:01:00+00:00') t(x)", "values TIMESTAMP '1970-01-01 00:01:00+00:00'");
        this.assertQuery("SELECT TIMESTAMP '2012-10-31 01:00' AT TIME ZONE '+07:09'", "SELECT TIMESTAMP '2012-10-30 18:00:00.000 America/Los_Angeles'");
        this.assertQuery("SELECT TIMESTAMP '2012-10-31 01:00 UTC' AT TIME ZONE 'America/Los_Angeles'", "SELECT TIMESTAMP '2012-10-30 18:00:00.000 America/Los_Angeles'");
        this.assertQuery("SELECT TIMESTAMP '2012-10-31 01:00' AT TIME ZONE 'America/Los_Angeles'", "SELECT TIMESTAMP '2012-10-30 18:00:00.000 America/Los_Angeles'");
        this.assertQuery("SELECT x AT TIME ZONE 'America/Los_Angeles' FROM (values TIMESTAMP '1970-01-01 00:01:00+00:00', TIMESTAMP '1970-01-01 08:01:00+08:00', TIMESTAMP '1969-12-31 16:01:00-08:00') t(x)", "values TIMESTAMP '1970-01-01 00:01:00+00:00', TIMESTAMP '1970-01-01 08:01:00+08:00', TIMESTAMP '1969-12-31 16:01:00-08:00'");
        this.assertQuery("SELECT x AT TIME ZONE 'America/Los_Angeles' FROM (values TIMESTAMP '1970-01-01 00:01:00', TIMESTAMP '1970-01-01 08:01:00', TIMESTAMP '1969-12-31 16:01:00') t(x)", "values TIMESTAMP '1969-12-31 16:01:00-08:00', TIMESTAMP '1970-01-01 00:01:00-08:00', TIMESTAMP '1969-12-31 08:01:00-08:00'");
        this.assertQuery("SELECT min(x) AT TIME ZONE 'America/Los_Angeles' FROM (values TIMESTAMP '1970-01-01 00:01:00+00:00', TIMESTAMP '1970-01-01 08:01:00+08:00', TIMESTAMP '1969-12-31 16:01:00-08:00') t(x)", "values TIMESTAMP '1969-12-31 16:01:00-08:00'");
        this.assertQuery("SELECT TIMESTAMP '2012-10-31 01:00' AT TIME ZONE 'America/Los_Angeles' AT TIME ZONE 'UTC'", "SELECT TIMESTAMP '2012-10-30 18:00:00.000 America/Los_Angeles'");
        this.assertQuery("SELECT TIMESTAMP '2012-10-31 01:00' AT TIME ZONE 'Asia/Tokyo' AT TIME ZONE 'America/Los_Angeles'", "SELECT TIMESTAMP '2012-10-30 18:00:00.000 America/Los_Angeles'");
        this.assertQuery("SELECT TIMESTAMP '2012-10-31 01:00' AT TIME ZONE 'America/Los_Angeles' AT TIME ZONE 'Asia/Shanghai'", "SELECT TIMESTAMP '2012-10-30 18:00:00.000 America/Los_Angeles'");
        this.assertQuery("SELECT min(x) AT TIME ZONE 'America/Los_Angeles' AT TIME ZONE 'UTC' FROM (values TIMESTAMP '1970-01-01 00:01:00+00:00', TIMESTAMP '1970-01-01 08:01:00+08:00', TIMESTAMP '1969-12-31 16:01:00-08:00') t(x)", "values TIMESTAMP '1969-12-31 16:01:00-08:00'");
        this.assertQuery("SELECT * from (VALUES TIMESTAMP '2012-10-31 01:00' AT TIME ZONE 'Asia/Oral')", "SELECT TIMESTAMP '2012-10-30 18:00:00.000 America/Los_Angeles'");
    }

    @Test
    public void testShowFunctions() {
        MaterializedResult result = this.computeActual("SHOW FUNCTIONS");
        ImmutableListMultimap functions = Multimaps.index((Iterable)result.getMaterializedRows(), input -> {
            Assert.assertEquals((int)input.getFieldCount(), (int)6);
            return (String)input.getField(0);
        });
        Assert.assertTrue((boolean)functions.containsKey((Object)"avg"), (String)("Expected function names " + functions + " to contain 'avg'"));
        Assert.assertEquals((int)functions.get((Object)"avg").asList().size(), (int)4);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(0)).getField(1), (Object)"decimal(p,s)");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(0)).getField(2), (Object)"decimal(p,s)");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(0)).getField(3), (Object)"aggregate");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(1)).getField(1), (Object)"double");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(1)).getField(2), (Object)"bigint");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(1)).getField(3), (Object)"aggregate");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(2)).getField(1), (Object)"double");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(2)).getField(2), (Object)"double");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(2)).getField(3), (Object)"aggregate");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(3)).getField(1), (Object)"real");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(3)).getField(2), (Object)"real");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(3)).getField(3), (Object)"aggregate");
        Assert.assertTrue((boolean)functions.containsKey((Object)"abs"), (String)("Expected function names " + functions + " to contain 'abs'"));
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"abs").asList().get(0)).getField(3), (Object)"scalar");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"abs").asList().get(0)).getField(4), (Object)true);
        Assert.assertTrue((boolean)functions.containsKey((Object)"rand"), (String)("Expected function names " + functions + " to contain 'rand'"));
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"rand").asList().get(0)).getField(3), (Object)"scalar");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"rand").asList().get(0)).getField(4), (Object)false);
        Assert.assertTrue((boolean)functions.containsKey((Object)"rank"), (String)("Expected function names " + functions + " to contain 'rank'"));
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"rank").asList().get(0)).getField(3), (Object)"window");
        Assert.assertTrue((boolean)functions.containsKey((Object)"rank"), (String)("Expected function names " + functions + " to contain 'split_part'"));
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"split_part").asList().get(0)).getField(1), (Object)"varchar(x)");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"split_part").asList().get(0)).getField(2), (Object)"varchar(x), varchar(y), bigint");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"split_part").asList().get(0)).getField(3), (Object)"scalar");
        Assert.assertFalse((boolean)functions.containsKey((Object)"like"), (String)("Expected function names " + functions + " not to contain 'like'"));
    }

    @Test
    public void testInformationSchemaFiltering() {
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_name = 'orders' LIMIT 1", "SELECT 'orders' table_name");
    }

    @Test
    public void testSelectColumnOfNulls() {
        this.assertQueryOrdered("SELECT \n CAST(NULL AS VARCHAR),\n CAST(NULL AS BIGINT)\nFROM ORDERS\n ORDER BY 1");
    }

    @Test
    public void testSelectCaseInsensitive() {
        this.assertQuery("SELECT ORDERKEY FROM ORDERS");
        this.assertQuery("SELECT OrDeRkEy FROM OrDeRs");
    }

    @Test
    public void testShowSession() {
        Session session = new Session(this.getSession().getQueryId(), Optional.empty(), this.getSession().isClientTransactionSupport(), this.getSession().getIdentity(), this.getSession().getSource(), this.getSession().getCatalog(), this.getSession().getSchema(), this.getSession().getTimeZoneKey(), this.getSession().getLocale(), this.getSession().getRemoteUserAddress(), this.getSession().getUserAgent(), this.getSession().getClientInfo(), this.getSession().getStartTime(), (Map)ImmutableMap.builder().put((Object)"test_string", (Object)"foo string").put((Object)"test_long", (Object)"424242").build(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"testing_catalog", (Object)ImmutableMap.builder().put((Object)"connector_string", (Object)"bar string").put((Object)"connector_long", (Object)"11").build()), this.getQueryRunner().getMetadata().getSessionPropertyManager(), this.getSession().getPreparedStatements());
        MaterializedResult result = this.computeActual(session, "SHOW SESSION");
        ImmutableMap properties = Maps.uniqueIndex((Iterable)result.getMaterializedRows(), input -> {
            Assert.assertEquals((int)input.getFieldCount(), (int)5);
            return (String)input.getField(0);
        });
        Assert.assertEquals((Object)properties.get((Object)"test_string"), (Object)new MaterializedRow(1, new Object[]{"test_string", "foo string", "test default", "varchar", "test string property"}));
        Assert.assertEquals((Object)properties.get((Object)"test_long"), (Object)new MaterializedRow(1, new Object[]{"test_long", "424242", "42", "bigint", "test long property"}));
        Assert.assertEquals((Object)properties.get((Object)"testing_catalog.connector_string"), (Object)new MaterializedRow(1, new Object[]{"testing_catalog.connector_string", "bar string", "connector default", "varchar", "connector string property"}));
        Assert.assertEquals((Object)properties.get((Object)"testing_catalog.connector_long"), (Object)new MaterializedRow(1, new Object[]{"testing_catalog.connector_long", "11", "33", "bigint", "connector long property"}));
    }

    @Test
    public void testTry() {
        this.assertQuery("SELECT linenumber, sum(TRY(100/(CAST (tax*10 AS BIGINT)))) FROM lineitem GROUP BY linenumber", "SELECT linenumber, sum(100/(CAST (tax*10 AS BIGINT))) FROM lineitem WHERE CAST(tax*10 AS BIGINT) <> 0 GROUP BY linenumber");
        this.assertQuery("SELECT TRY(CAST(IF(round(totalprice) % 2 = 0, CAST(totalprice AS VARCHAR), '^&$' || CAST(totalprice AS VARCHAR)) AS DOUBLE)) FROM orders", "SELECT CASE WHEN round(totalprice) % 2 = 0 THEN totalprice ELSE null END FROM orders");
        this.assertQuery("SELECT COUNT(TRY(to_base(100, CAST(round(totalprice/100) AS BIGINT)))) FROM orders", "SELECT SUM(CASE WHEN CAST(round(totalprice/100) AS BIGINT) BETWEEN 2 AND 36 THEN 1 ELSE 0 END) FROM orders");
        this.assertQuery("SELECT COUNT(CAST(orderkey AS VARCHAR) || TRY(to_base(100, CAST(round(totalprice/100) AS BIGINT)))) FROM orders", "SELECT SUM(CASE WHEN CAST(round(totalprice/100) AS BIGINT) BETWEEN 2 AND 36 THEN 1 ELSE 0 END) FROM orders");
        this.assertQueryFails("SELECT TRY()", "line 1:8: The 'try' function must have exactly one argument");
        this.assertQueryFails("SELECT TRY(x) IS NULL FROM (SELECT 1/y as x FROM (VALUES 1, 2, 3, 0, 4) t(y))", "/ by zero");
        this.assertQuery("SELECT x IS NULL FROM (SELECT TRY(1/y) as x FROM (VALUES 3, 0, 4) t(y))", "VALUES false, true, false");
    }

    @Test
    public void testTryNoMergeProjections() {
        this.assertQueryFails("SELECT TRY(x) FROM (SELECT 1/y as x FROM (VALUES 1, 2, 3, 0, 4) t(y))", ".*");
    }

    @Test
    public void testNoFrom() {
        this.assertQuery("SELECT 1 + 2, 3 + 4", "SELECT 1 + 2, 3 + 4 FROM orders LIMIT 1");
    }

    @Test
    public void testTopNByMultipleFields() {
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY orderkey ASC, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY orderkey ASC, custkey DESC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY orderkey DESC, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY orderkey DESC, custkey DESC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY custkey ASC, orderkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY custkey ASC, orderkey DESC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY custkey DESC, orderkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY custkey DESC, orderkey DESC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC NULLS FIRST, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) DESC NULLS FIRST, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC NULLS LAST LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) DESC NULLS LAST, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC, custkey ASC LIMIT 10", "SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC NULLS LAST, custkey ASC LIMIT 10");
    }

    @Test
    public void testExchangeWithProjectionPushDown() {
        this.assertQuery("SELECT * FROM \n  (SELECT orderkey + 1 orderkey FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 100)) o \nJOIN \n  (SELECT orderkey + 1 orderkey FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 100)) o1 \nON (o.orderkey = o1.orderkey)");
    }

    @Test
    public void testUnionWithProjectionPushDown() {
        this.assertQuery("SELECT key + 5, status FROM (SELECT orderkey key, orderstatus status FROM orders UNION ALL SELECT orderkey key, linestatus status FROM lineitem)");
    }

    @Test
    public void testJoinProjectionPushDown() {
        this.assertQuery("SELECT *\nFROM\n  (SELECT orderkey, abs(orderkey) a FROM orders) t\nJOIN\n  (SELECT orderkey, abs(orderkey) a FROM orders) u\nON\n  t.orderkey = u.orderkey");
    }

    @Test
    public void testUnion() {
        this.assertQuery("SELECT orderkey FROM orders UNION SELECT custkey FROM orders");
        this.assertQuery("SELECT 123 UNION DISTINCT SELECT 123 UNION ALL SELECT 123");
        this.assertQuery("SELECT NULL UNION SELECT NULL");
        this.assertQuery("SELECT NULL, NULL UNION ALL SELECT NULL, NULL FROM nation");
        this.assertQuery("SELECT 'x', 'y' UNION ALL SELECT name, name FROM nation");
        this.assertQuery("SELECT orderkey FROM orders UNION ALL SELECT 123 UNION ALL (SELECT custkey FROM orders GROUP BY custkey)");
    }

    @Test
    public void testUnionDistinct() {
        this.assertQuery("SELECT orderkey FROM orders UNION DISTINCT SELECT custkey FROM orders");
    }

    @Test
    public void testUnionAll() {
        this.assertQuery("SELECT orderkey FROM orders UNION ALL SELECT custkey FROM orders");
    }

    @Test
    public void testUnionArray() {
        this.assertQuery("SELECT a[1] FROM (SELECT ARRAY[1] UNION ALL SELECT ARRAY[1]) t(a) LIMIT 1", "SELECT 1");
    }

    @Test
    public void testChainedUnionsWithOrder() {
        this.assertQueryOrdered("SELECT orderkey FROM orders UNION (SELECT custkey FROM orders UNION SELECT linenumber FROM lineitem) UNION ALL SELECT orderkey FROM lineitem ORDER BY orderkey");
    }

    @Test
    public void testUnionWithJoin() {
        this.assertQuery("SELECT * FROM (   SELECT orderdate ds, orderkey FROM orders    UNION ALL    SELECT shipdate ds, orderkey FROM lineitem) a JOIN orders o ON (a.orderkey = o.orderkey)");
    }

    @Test
    public void testUnionWithAggregation() {
        this.assertQuery("SELECT ds, count(*) FROM (   SELECT orderdate ds, orderkey FROM orders    UNION ALL    SELECT shipdate ds, orderkey FROM lineitem) a GROUP BY ds");
        this.assertQuery("SELECT ds, count(*) FROM (   SELECT orderdate ds, orderkey FROM orders    UNION    SELECT shipdate ds, orderkey FROM lineitem) a GROUP BY ds");
        this.assertQuery("SELECT ds, count(DISTINCT orderkey) FROM (   SELECT orderdate ds, orderkey FROM orders    UNION    SELECT shipdate ds, orderkey FROM lineitem) a GROUP BY ds");
        this.assertQuery("SELECT clerk, count(DISTINCT orderstatus) FROM (SELECT * FROM orders WHERE orderkey=0  UNION ALL SELECT * FROM orders WHERE orderkey<>0) GROUP BY clerk");
        this.assertQuery("SELECT count(clerk) FROM (SELECT clerk FROM orders WHERE orderkey=0  UNION ALL SELECT clerk FROM orders WHERE orderkey<>0) GROUP BY clerk");
        this.assertQuery("SELECT count(orderkey), sum(sc) FROM (    SELECT sum(custkey) sc, orderkey FROM (        SELECT custkey,orderkey, orderkey+1 from orders where orderkey=0        UNION ALL         SELECT custkey,orderkey,orderkey+1 from orders where orderkey<>0)     GROUP BY orderkey)");
        this.assertQuery("SELECT count(orderkey), sum(sc) FROM (\n    SELECT sum(custkey) sc, orderkey FROM (\n        SELECT custkey, orderkey, orderkey+1, orderstatus from orders where orderkey=0\n        UNION ALL \n        SELECT custkey, orderkey, orderkey+1, orderstatus from orders where orderkey<>0) \n    GROUP BY GROUPING SETS ((orderkey, orderstatus), (orderkey)))", "SELECT count(orderkey), sum(sc) FROM (\n    SELECT sum(custkey) sc, orderkey FROM (\n        SELECT custkey, orderkey, orderkey+1, orderstatus from orders where orderkey=0\n        UNION ALL \n        SELECT custkey, orderkey, orderkey+1, orderstatus from orders where orderkey<>0) \n    GROUP BY orderkey, orderstatus \n    \n    UNION ALL \n    \n    SELECT sum(custkey) sc, orderkey FROM (\n        SELECT custkey, orderkey, orderkey+1, orderstatus from orders where orderkey=0\n        UNION ALL \n        SELECT custkey, orderkey, orderkey+1, orderstatus from orders where orderkey<>0) \n    GROUP BY orderkey)");
    }

    @Test
    public void testUnionWithAggregationAndJoin() {
        this.assertQuery("SELECT * FROM ( SELECT orderkey, count(*) FROM (   SELECT orderdate ds, orderkey FROM orders    UNION ALL    SELECT shipdate ds, orderkey FROM lineitem) a GROUP BY orderkey) t JOIN orders o ON (o.orderkey = t.orderkey)");
    }

    @Test
    public void testUnionWithJoinOnNonTranslateableSymbols() {
        this.assertQuery("SELECT *\nFROM (SELECT orderdate ds, orderkey\n      FROM orders\n      UNION ALL\n      SELECT shipdate ds, orderkey\n      FROM lineitem) a\nJOIN orders o\nON (substr(cast(a.ds AS VARCHAR), 6, 2) = substr(cast(o.orderdate AS VARCHAR), 6, 2) AND a.orderkey = o.orderkey)");
    }

    @Test
    public void testSubqueryUnion() {
        this.assertQueryOrdered("SELECT * FROM (SELECT orderkey FROM orders UNION SELECT custkey FROM orders UNION SELECT orderkey FROM orders) ORDER BY orderkey LIMIT 1000");
    }

    @Test
    public void testUnionWithFilterNotInSelect() {
        this.assertQuery("SELECT orderkey, orderdate FROM orders WHERE custkey < 1000 UNION ALL SELECT orderkey, shipdate FROM lineitem WHERE linenumber < 2000");
        this.assertQuery("SELECT orderkey, orderdate FROM orders UNION ALL SELECT orderkey, shipdate FROM lineitem WHERE linenumber < 2000");
        this.assertQuery("SELECT orderkey, orderdate FROM orders WHERE custkey < 1000 UNION ALL SELECT orderkey, shipdate FROM lineitem");
    }

    @Test
    public void testSelectOnlyUnion() {
        this.assertQuery("SELECT 123, 'foo' UNION ALL SELECT 999, 'bar'");
    }

    @Test
    public void testMultiColumnUnionAll() {
        this.assertQuery("SELECT * FROM orders UNION ALL SELECT * FROM orders");
    }

    @Test
    public void testUnionRequiringCoercion() {
        this.assertQuery("VALUES 1 UNION ALL VALUES 1.0, 2", "SELECT * FROM (VALUES 1) UNION ALL SELECT * FROM (VALUES 1.0, 2)");
        this.assertQuery("(VALUES 1) UNION ALL (VALUES 1.0, 2)", "SELECT * FROM (VALUES 1) UNION ALL SELECT * FROM (VALUES 1.0, 2)");
        this.assertQuery("SELECT 0, 0 UNION ALL SELECT 1.0, 0");
        this.assertQuery("SELECT 0, 0, 0, 0 UNION ALL SELECT 0.0, 0.0, 0, 0");
        this.assertQuery("SELECT * FROM (VALUES 1) UNION ALL SELECT * FROM (VALUES 1.0, 2)");
        this.assertQuery("SELECT * FROM (VALUES 1) UNION SELECT * FROM (VALUES 1.0, 2)", "VALUES 1.0, 2.0");
        this.assertQuery("SELECT * FROM (VALUES (2, 2)) UNION SELECT * FROM (VALUES (1, 1.0))");
        this.assertQuery("SELECT * FROM (VALUES (NULL, NULL)) UNION SELECT * FROM (VALUES (1, 1.0))");
        this.assertQuery("SELECT * FROM (VALUES (NULL, NULL)) UNION ALL SELECT * FROM (VALUES (NULL, 1.0))");
    }

    @Test
    public void testTableQuery() {
        this.assertQuery("TABLE orders", "SELECT * FROM orders");
    }

    @Test
    public void testTableQueryOrderLimit() {
        this.assertQueryOrdered("TABLE orders ORDER BY orderkey LIMIT 10", "SELECT * FROM orders ORDER BY orderkey LIMIT 10");
    }

    @Test
    public void testTableQueryInUnion() {
        this.assertQuery("(SELECT * FROM orders ORDER BY orderkey LIMIT 10) UNION ALL TABLE orders", "(SELECT * FROM orders ORDER BY orderkey LIMIT 10) UNION ALL SELECT * FROM orders");
    }

    @Test
    public void testTableAsSubquery() {
        this.assertQueryOrdered("(TABLE orders) ORDER BY orderkey", "(SELECT * FROM orders) ORDER BY orderkey");
    }

    @Test
    public void testLimitPushDown() {
        MaterializedResult actual = this.computeActual("(TABLE orders ORDER BY orderkey) UNION ALL SELECT * FROM orders WHERE orderstatus = 'F' UNION ALL (TABLE orders ORDER BY orderkey LIMIT 20) UNION ALL (TABLE orders LIMIT 5) UNION ALL TABLE orders LIMIT 10");
        MaterializedResult all = this.computeExpected("SELECT * FROM ORDERS", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testOrderLimitCompaction() {
        this.assertQueryOrdered("SELECT * FROM (SELECT * FROM orders ORDER BY orderkey) LIMIT 10");
    }

    @Test
    public void testUnaliasSymbolReferencesWithUnion() {
        this.assertQuery("SELECT 1, 1, 'a', 'a' UNION ALL SELECT 1, 2, 'a', 'b'");
    }

    @Test
    public void testRandCrossJoins() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM orders ORDER BY rand() LIMIT 5) a CROSS JOIN (SELECT * FROM lineitem ORDER BY rand() LIMIT 5) b");
    }

    @Test
    public void testCrossJoins() {
        this.assertQuery("SELECT a.custkey, b.orderkey FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 5) a CROSS JOIN (SELECT * FROM lineitem ORDER BY orderkey LIMIT 5) b");
    }

    @Test
    public void testCrossJoinEmptyProbePage() {
        this.assertQuery("SELECT a.custkey, b.orderkey FROM (SELECT * FROM orders WHERE orderkey < 0) a CROSS JOIN (SELECT * FROM lineitem WHERE orderkey < 100) b");
    }

    @Test
    public void testCrossJoinEmptyBuildPage() {
        this.assertQuery("SELECT a.custkey, b.orderkey FROM (SELECT * FROM orders WHERE orderkey < 100) a CROSS JOIN (SELECT * FROM lineitem WHERE orderkey < 0) b");
    }

    @Test
    public void testSimpleCrossJoins() {
        this.assertQuery("SELECT * FROM (SELECT 1 a) x CROSS JOIN (SELECT 2 b) y");
    }

    @Test
    public void testCrossJoinsWithWhereClause() {
        this.assertQuery("SELECT a, b, c, d FROM (VALUES (1, 'a'), (2, 'b'), (3, 'c'), (4, 'd')) t1 (a, b) CROSS JOIN (VALUES (1, 1.1), (3, 3.3), (5, 5.5)) t2 (c, d) WHERE t1.a > t2.c", "SELECT * FROM (VALUES  (2, 'b', 1, 1.1), (3, 'c', 1, 1.1), (4, 'd', 1, 1.1), (4, 'd', 3, 3.3))");
    }

    @Test
    public void testCrossJoinsDifferentDataTypes() {
        this.assertQuery("SELECT * FROM (SELECT 'AAA' a1, 11 b1, 33.3 c1, true as d1, 21 e1) x CROSS JOIN (SELECT 4444.4 a2, false as b2, 'BBB' c2, 22 d2) y");
    }

    @Test
    public void testCrossJoinWithNulls() {
        this.assertQuery("SELECT a, b FROM (VALUES (1), (2)) t (a) CROSS JOIN (VALUES (1), (3)) u (b)", "SELECT * FROM (VALUES  (1, 1), (1, 3), (2, 1), (2, 3))");
        this.assertQuery("SELECT a, b FROM (VALUES (1), (2), (null)) t (a), (VALUES (11), (null), (13)) u (b)", "SELECT * FROM (VALUES (1, 11), (1, null), (1, 13), (2, 11), (2, null), (2, 13), (null, 11), (null, null), (null, 13))");
        this.assertQuery("SELECT a, b FROM (VALUES ('AA'), ('BB'), (null)) t (a), (VALUES ('111'), (null), ('333')) u (b)", "SELECT * FROM (VALUES ('AA', '111'), ('AA', null), ('AA', '333'), ('BB', '111'), ('BB', null), ('BB', '333'), (null, '111'), (null, null), (null, '333'))");
    }

    @Test
    public void testImplicitCrossJoin() {
        this.assertQuery("SELECT * FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 3) a, (SELECT * FROM orders ORDER BY orderkey LIMIT 4) b");
        this.assertQuery("SELECT * FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 5) a, (SELECT * FROM orders ORDER BY orderkey LIMIT 2) b");
        this.assertQuery("SELECT * FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 5) a, (SELECT * FROM orders ORDER BY orderkey LIMIT 5) b, (SELECT * FROM orders ORDER BY orderkey LIMIT 5) c ");
        this.assertQuery("SELECT l.orderkey, l.linenumber FROM orders o INNER JOIN lineitem l ON o.custkey = l.linenumber WHERE o.custkey IN (5) AND l.orderkey IN (7522)");
        this.assertQuery("SELECT o.custkey FROM orders o INNER JOIN lineitem l ON o.custkey = l.linenumber WHERE o.custkey IN (5) AND l.orderkey IN (7522)");
        this.assertQuery("SELECT COUNT(*) FROM orders o INNER JOIN lineitem l ON o.custkey = l.linenumber WHERE o.custkey IN (5) AND l.orderkey IN (7522)");
    }

    @Test
    public void testCrossJoinUnion() {
        this.assertQuery("SELECT t.c FROM (SELECT 1) CROSS JOIN (SELECT 0 AS c UNION ALL SELECT 1) t");
        this.assertQuery("SELECT a, b FROM (VALUES (1, 1)) CROSS JOIN (SELECT 0 AS a, 0 AS b UNION ALL SELECT 1, 1) t");
    }

    @Test
    public void testCrossJoinUnnestWithUnion() {
        this.assertQuery("SELECT col, COUNT(*)\nFROM ((\n    SELECT ARRAY[1, 2] AS a\n    UNION ALL\n    SELECT ARRAY[1, 3] AS a)  unionresult\n  CROSS JOIN UNNEST(unionresult.a) t(col))\nGROUP BY col", "SELECT * FROM VALUES (1, 2), (2, 1), (3, 1)");
    }

    @Test
    public void testJoinOnConstantExpression() {
        this.assertQuery("SELECT * FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 5) a    JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 5) b    ON 123 = 123");
    }

    @Test
    public void testSemiJoin() {
        this.assertQuery("SELECT linenumber, min(orderkey) FROM lineitem GROUP BY linenumber HAVING min(orderkey) IN (SELECT orderkey FROM orders WHERE orderkey > 1)");
        this.assertQuery("SELECT 10 in (SELECT orderkey FROM orders)");
        this.assertQuery("SELECT * FROM (VALUES (1,1), (2,2), (3, 3)) t(x, y) WHERE (x+y in (VALUES 4, 5)) AND (x*y in (VALUES 4, 5))", "VALUES (2,2)");
        this.assertQuery("SELECT 1.0 IN (SELECT 1), 1 IN (SELECT 1)");
        this.assertQuery("SELECT 1 WHERE 1 IN (SELECT 1) AND 1.0 IN (SELECT 1)");
        this.assertQuery("select 1.0 in (values (1), (2), (3))", "SELECT true");
        this.assertQuery("SELECT cast(1 as decimal(3,2)) IN (SELECT cast(1 as decimal(3,1)))", "SELECT true");
        this.assertQuery("SELECT cast(1 as decimal(3,2)) IN (values (cast(1 as decimal(3,1))), (cast (2 as decimal(3,1))))", "SELECT true");
        this.assertQuery("SELECT 1 IN (SELECT 1), 2 IN (SELECT 1) WHERE 1 IN (SELECT 1)");
        this.assertQuery("SELECT *, o2.custkey\n  IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE orderkey % 5 = 0)\nFROM (SELECT * FROM orders WHERE custkey % 256 = 0) o1\nJOIN (SELECT * FROM orders WHERE custkey % 256 = 0) o2\n  ON (o1.orderkey IN (SELECT orderkey FROM lineitem WHERE orderkey % 4 = 0)) = (o2.orderkey IN (SELECT orderkey FROM lineitem WHERE orderkey % 4 = 0))\nWHERE o1.orderkey\n  IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE orderkey % 4 = 0)\nORDER BY o1.orderkey\n  IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE orderkey % 7 = 0)");
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE partkey % 4 = 0),\n  SUM(\n    CASE\n      WHEN orderkey\n        IN (\n          SELECT orderkey\n          FROM lineitem\n          WHERE suppkey % 4 = 0)\n      THEN 1\n      ELSE 0\n      END)\nFROM orders\nGROUP BY orderkey\n  IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE partkey % 4 = 0)\nHAVING SUM(\n  CASE\n    WHEN orderkey\n      IN (\n        SELECT orderkey\n        FROM lineitem\n        WHERE suppkey % 4 = 0)\n      THEN 1\n      ELSE 0\n      END) > 1");
    }

    @Test
    public void testJoinConstantPropagation() {
        this.assertQuery("SELECT x, y, COUNT(*)\nFROM (SELECT orderkey, 0 AS x FROM orders) a \nJOIN (SELECT orderkey, 1 AS y FROM orders) b \nON a.orderkey = b.orderkey\nGROUP BY 1, 2");
    }

    @Test
    public void testAntiJoin() {
        this.assertQuery("SELECT *, orderkey\n  NOT IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE orderkey % 3 = 0)\nFROM orders");
    }

    @Test
    public void testSemiJoinLimitPushDown() {
        this.assertQuery("SELECT COUNT(*)\nFROM (\n  SELECT orderkey\n  IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE orderkey % 2 = 0)\n  FROM orders\n  LIMIT 10)");
    }

    @Test(enabled=false)
    public void testSemiJoinNullHandling() {
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END\n    FROM lineitem)\nFROM orders");
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT orderkey\n    FROM lineitem)\nFROM (\n  SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM orders)");
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END\n    FROM lineitem)\nFROM (\n  SELECT CASE WHEN orderkey % 4 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM orders)");
    }

    @Test
    public void testSemiJoinWithGroupBy() {
        this.assertQuery("SELECT linenumber, min(orderkey), 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber");
        this.assertQuery("SELECT linenumber, min(orderkey), 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey) FROM lineitem GROUP BY linenumber, 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey) FROM lineitem GROUP BY linenumber HAVING 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey), 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)HAVING 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey), 6 IN (SELECT max(orderkey) FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, 6 IN (SELECT sum(orderkey) FROM orders WHERE orderkey < 5)");
        this.assertQuery("SELECT linenumber, min(orderkey) FROM lineitem GROUP BY linenumber, 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)HAVING 6 IN (SELECT orderkey FROM orders WHERE orderkey > 3)");
        this.assertQuery("SELECT linenumber, min(orderkey), 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, 6 IN (SELECT orderkey FROM orders WHERE orderkey < 5)HAVING 6 IN (SELECT orderkey FROM orders WHERE orderkey > 3)");
    }

    @Test
    public void testSemiJoinUnionNullHandling() {
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT CASE WHEN orderkey % 500 = 0 THEN NULL ELSE orderkey END\n    FROM orders\n    WHERE orderkey % 200 = 0\n    UNION ALL\n    SELECT CASE WHEN orderkey % 600 = 0 THEN NULL ELSE orderkey END\n    FROM orders\n    WHERE orderkey % 300 = 0\n  )\nFROM (\n  SELECT orderkey\n  FROM lineitem\n  WHERE orderkey % 100 = 0)");
    }

    @Test
    public void testSemiJoinAggregationNullHandling() {
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT CASE WHEN orderkey % 10 = 0 THEN NULL ELSE orderkey END\n    FROM lineitem\n    WHERE orderkey % 2 = 0\n    GROUP BY orderkey\n  )\nFROM (\n  SELECT orderkey\n  FROM orders\n  WHERE orderkey % 3 = 0)");
    }

    @Test
    public void testSemiJoinUnionAggregationNullHandling() {
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT CASE WHEN orderkey % 500 = 0 THEN NULL ELSE orderkey END\n    FROM lineitem\n    WHERE orderkey % 250 = 0\n    UNION ALL\n    SELECT CASE WHEN orderkey % 300 = 0 THEN NULL ELSE orderkey END\n    FROM lineitem\n    WHERE orderkey % 200 = 0\n    GROUP BY orderkey\n  )\nFROM (\n  SELECT orderkey\n  FROM orders\n  WHERE orderkey % 100 = 0)\n");
    }

    @Test
    public void testSemiJoinAggregationUnionNullHandling() {
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT orderkey\n    FROM (\n      SELECT CASE WHEN orderkey % 500 = 0 THEN NULL ELSE orderkey END AS orderkey\n      FROM orders\n      WHERE orderkey % 200 = 0\n      UNION ALL\n      SELECT CASE WHEN orderkey % 600 = 0 THEN NULL ELSE orderkey END AS orderkey\n      FROM orders\n      WHERE orderkey % 300 = 0\n    )\n    GROUP BY orderkey\n  )\nFROM (\n  SELECT orderkey\n  FROM lineitem\n  WHERE orderkey % 100 = 0)");
    }

    @Test
    public void testSameInPredicateInProjectionAndFilter() {
        this.assertQuery("SELECT x IN (SELECT * FROM (VALUES 1))\nFROM (VALUES 1) t(x)\nWHERE x IN (SELECT * FROM (VALUES 1))", "SELECT 1");
        this.assertQuery("SELECT x IN (SELECT * FROM (VALUES 1))\nFROM (VALUES 2) t(x)\nWHERE x IN (SELECT * FROM (VALUES 1))", "SELECT 1 WHERE false");
    }

    @Test
    public void testScalarSubquery() {
        this.assertQuery("SELECT (SELECT (SELECT (SELECT 1)))");
        this.assertQuery("SELECT * FROM lineitem WHERE orderkey = \n(SELECT max(orderkey) FROM orders)");
        this.assertQuery("SELECT * FROM lineitem WHERE orderkey = \n(SELECT orderkey FROM orders WHERE 0=1)");
        this.assertQuery("SELECT * FROM lineitem WHERE \n(SELECT orderkey FROM orders WHERE 0=1) is null");
        this.assertQuery("SELECT * FROM lineitem WHERE \n(SELECT orderkey FROM orders WHERE 0=1) is not null");
        this.assertQuery("SELECT (SELECT 1) IN (1, 2, 3)");
        this.assertQuery("SELECT (SELECT 1) IN (   2, 3)");
        this.assertQuery("SELECT (SELECT 1) = (SELECT 3)");
        this.assertQuery("SELECT (SELECT 1) < (SELECT 3)");
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE (SELECT min(orderkey) FROM orders)<(SELECT max(orderkey) FROM orders)");
        this.assertQuery("SELECT (SELECT 1), (SELECT 2), (SELECT 3)");
        this.assertQuery("SELECT DISTINCT orderkey FROM lineitem WHERE orderkey BETWEEN   (SELECT avg(orderkey) FROM orders) - 10    AND   (SELECT avg(orderkey) FROM orders) + 10");
        this.assertQuery("SELECT o1.orderkey, COUNT(*) FROM orders o1 INNER JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o2 ON o1.orderkey BETWEEN (SELECT avg(orderkey) FROM orders) - 10 AND (SELECT avg(orderkey) FROM orders) + 10 GROUP BY o1.orderkey");
        this.assertQuery("SELECT o1.orderkey, COUNT(*) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o1 LEFT JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o2 ON o1.orderkey BETWEEN (SELECT avg(orderkey) FROM orders) - 10 AND (SELECT avg(orderkey) FROM orders) + 10 GROUP BY o1.orderkey");
        this.assertQuery("SELECT o1.orderkey, COUNT(*) FROM orders o1 RIGHT JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o2 ON o1.orderkey BETWEEN (SELECT avg(orderkey) FROM orders) - 10 AND (SELECT avg(orderkey) FROM orders) + 10 GROUP BY o1.orderkey");
        this.assertQuery("SELECT DISTINCT COUNT(*) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o1 FULL JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o2 ON o1.orderkey BETWEEN (SELECT avg(orderkey) FROM orders) - 10 AND (SELECT avg(orderkey) FROM orders) + 10 GROUP BY o1.orderkey", "VALUES 1, 10");
        this.assertQuery("SELECT orderkey, totalprice FROM orders ORDER BY (SELECT 2)");
        String multipleRowsErrorMsg = "Scalar sub-query has returned multiple rows";
        this.assertQueryFails("SELECT * FROM lineitem WHERE orderkey = (\nSELECT orderkey FROM orders ORDER BY totalprice)", multipleRowsErrorMsg);
        this.assertQueryFails("SELECT orderkey, totalprice FROM orders ORDER BY (VALUES 1, 2)", multipleRowsErrorMsg);
        this.assertQuery("SELECT custkey, (SELECT DISTINCT custkey FROM orders ORDER BY custkey LIMIT 1) FROM orders");
        this.assertQuery("SELECT 1.0/(SELECT 1), CAST(1.0 AS REAL)/(SELECT 1), 1/(SELECT 1)");
        this.assertQuery("SELECT 1.0 = (SELECT 1) AND 1 = (SELECT 1), 2.0 = (SELECT 1) WHERE 1.0 = (SELECT 1) AND 1 = (SELECT 1)");
        this.assertQuery("SELECT 1.0 = (SELECT 1), 2.0 = (SELECT 1), CAST(2.0 AS REAL) = (SELECT 1) WHERE 1.0 = (SELECT 1)");
        this.assertQuery("SELECT * FROM (VALUES 1) t(a) WHERE 1=(SELECT count(*) WHERE 1.0 = a)", "SELECT 1");
        this.assertQuery("SELECT * FROM (VALUES 1.0) t(a) WHERE 1=(SELECT count(*) WHERE 1 = a)", "SELECT 1.0");
    }

    @Test
    public void testExistsSubquery() {
        this.assertQuery("SELECT EXISTS(SELECT NOT EXISTS(SELECT EXISTS(SELECT 1)))");
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE EXISTS(SELECT max(orderkey) FROM orders)");
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE NOT EXISTS(SELECT max(orderkey) FROM orders)");
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE NOT EXISTS(SELECT orderkey FROM orders WHERE false)");
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE EXISTS(SELECT orderkey FROM orders WHERE false)");
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE NOT EXISTS(SELECT orderkey FROM orders WHERE false)");
        this.assertQuery("SELECT (EXISTS(SELECT 1)) IN (false)", "SELECT false");
        this.assertQuery("SELECT (NOT EXISTS(SELECT 1)) IN (false)", "SELECT true");
        this.assertQuery("SELECT (EXISTS(SELECT 1)) IN (true, false)", "SELECT true");
        this.assertQuery("SELECT (NOT EXISTS(SELECT 1)) IN (true, false)", "SELECT true");
        this.assertQuery("SELECT (EXISTS(SELECT 1 WHERE false)) IN (true, false)", "SELECT true");
        this.assertQuery("SELECT (NOT EXISTS(SELECT 1 WHERE false)) IN (true, false)", "SELECT true");
        this.assertQuery("SELECT (EXISTS(SELECT 1 WHERE false)) IN (false)", "SELECT true");
        this.assertQuery("SELECT (NOT EXISTS(SELECT 1 WHERE false)) IN (false)", "SELECT false");
        this.assertQuery("SELECT (EXISTS(SELECT 1)) = (EXISTS(SELECT 1)) WHERE NOT EXISTS(SELECT 1)", "SELECT true WHERE false");
        this.assertQuery("SELECT (EXISTS(SELECT 1)) = (EXISTS(SELECT 3)) WHERE NOT EXISTS(SELECT 1 WHERE false)", "SELECT true");
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE (EXISTS(SELECT min(orderkey) FROM orders))=(NOT EXISTS(SELECT orderkey FROM orders WHERE false))", "SELECT count(*) FROM lineitem");
        this.assertQuery("SELECT EXISTS(SELECT 1), EXISTS(SELECT 1), EXISTS(SELECT 3), NOT EXISTS(SELECT 1), NOT EXISTS(SELECT 1 WHERE false)");
        this.assertQuery("SELECT DISTINCT orderkey FROM lineitem WHERE EXISTS(SELECT avg(orderkey) FROM orders)");
        QueryTemplate.Parameter joinType = QueryTemplate.parameter("join_type");
        QueryTemplate.Parameter condition = QueryTemplate.parameter("condition");
        QueryTemplate queryTemplate = QueryTemplate.queryTemplate("SELECT o1.orderkey, COUNT(*) FROM orders o1 %join_type% JOIN (SELECT * FROM orders LIMIT 10) o2 ON %condition% GROUP BY o1.orderkey ORDER BY o1.orderkey LIMIT 5", joinType, condition);
        List<QueryTemplate.Parameter> conditions = condition.of("EXISTS(SELECT avg(orderkey) FROM ORDERS)", "(SELECT avg(orderkey) FROM ORDERS) > 3");
        for (QueryTemplate.Parameter actualCondition : conditions) {
            for (QueryTemplate.Parameter actualJoinType : joinType.of("", "LEFT", "RIGHT")) {
                this.assertQuery(queryTemplate.replace(actualJoinType, actualCondition));
            }
            this.assertQuery(queryTemplate.replace(joinType.of("FULL"), actualCondition), "VALUES (1, 10), (2, 10), (3, 10), (4, 10), (5, 10)");
        }
        this.assertQuery("SELECT orderkey, totalprice FROM orders ORDER BY EXISTS(SELECT 2)");
        this.assertQuery("SELECT orderkey, totalprice FROM orders ORDER BY NOT(EXISTS(SELECT 2))");
    }

    @Test
    public void testScalarSubqueryWithGroupBy() {
        this.assertQuery("SELECT linenumber, min(orderkey), (SELECT max(orderkey) FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber");
        this.assertQuery("SELECT linenumber, min(orderkey), (SELECT max(orderkey) FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, (SELECT max(orderkey) FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey) FROM lineitem GROUP BY linenumber, (SELECT max(orderkey) FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey) FROM lineitem GROUP BY linenumber HAVING min(orderkey) < (SELECT avg(orderkey) FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey), (SELECT max(orderkey) FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, (SELECT max(orderkey) FROM orders WHERE orderkey < 7)HAVING min(orderkey) < (SELECT max(orderkey) FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey), (SELECT max(orderkey) FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, (SELECT sum(orderkey) FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, max(orderkey), (SELECT min(orderkey) FROM orders WHERE orderkey < 5)FROM lineitem GROUP BY linenumber HAVING sum(orderkey) > (SELECT min(orderkey) FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey), (SELECT max(orderkey) FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, (SELECT count(orderkey) FROM orders WHERE orderkey < 7)HAVING min(orderkey) < (SELECT sum(orderkey) FROM orders WHERE orderkey < 7)");
    }

    @Test
    public void testOutputInEnforceSingleRow() {
        this.assertQuery("SELECT count(*) FROM (SELECT (SELECT 1))");
        this.assertQuery("SELECT * FROM (SELECT (SELECT 1))");
        this.assertQueryFails("SELECT * FROM (SELECT (SELECT 1, 2))", "line 1:23: Multiple columns returned by subquery are not yet supported. Found 2");
    }

    @Test
    public void testExistsSubqueryWithGroupBy() {
        this.assertQuery("SELECT linenumber, min(orderkey), EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber");
        this.assertQuery("SELECT linenumber, min(orderkey), EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey) FROM lineitem GROUP BY linenumber, EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey) FROM lineitem GROUP BY linenumber HAVING EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey), EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)HAVING EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey), EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, EXISTS(SELECT orderkey FROM orders WHERE orderkey < 17)");
        this.assertQuery("SELECT linenumber, max(orderkey), EXISTS(SELECT orderkey FROM orders WHERE orderkey < 5)FROM lineitem GROUP BY linenumber HAVING EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey), EXISTS(SELECT orderkey FROM orders WHERE orderkey < 17)FROM lineitem GROUP BY linenumber, EXISTS(SELECT orderkey FROM orders WHERE orderkey < 17)HAVING EXISTS(SELECT orderkey FROM orders WHERE orderkey < 27)");
    }

    @Test
    public void testCorrelatedScalarSubqueries() {
        String errorMsg = "Unsupported correlated subquery type";
        this.assertQueryFails("SELECT (SELECT l.orderkey) FROM lineitem l", errorMsg);
        this.assertQueryFails("SELECT (SELECT 2 * l.orderkey) FROM lineitem l", errorMsg);
        this.assertQueryFails("SELECT * FROM lineitem l WHERE 1 = (SELECT 2 * l.orderkey)", errorMsg);
        this.assertQueryFails("SELECT * FROM lineitem l ORDER BY (SELECT 2 * l.orderkey)", errorMsg);
        this.assertQueryFails("SELECT max(l.quantity), 2 * l.orderkey, (SELECT l.orderkey) FROM lineitem l GROUP BY l.orderkey", errorMsg);
        this.assertQueryFails("SELECT max(l.quantity), 2 * l.orderkey FROM lineitem l GROUP BY l.orderkey HAVING max(l.quantity) < (SELECT l.orderkey)", errorMsg);
        this.assertQueryFails("SELECT max(l.quantity), 2 * l.orderkey FROM lineitem l GROUP BY l.orderkey, (SELECT l.orderkey)", errorMsg);
        this.assertQueryFails("SELECT * FROM lineitem l1 JOIN lineitem l2 ON l1.orderkey= (SELECT l2.orderkey)", errorMsg);
        this.assertQueryFails("SELECT (SELECT l3.* FROM lineitem l2 CROSS JOIN (SELECT l1.orderkey) l3 LIMIT 1) FROM lineitem l1", errorMsg);
        this.assertQueryFails("SELECT * FROM lineitem l WHERE 2 * l.orderkey = (SELECT * FROM (SELECT l.orderkey))", errorMsg);
        this.assertQueryFails("SELECT * FROM lineitem l WHERE 1 = (SELECT (SELECT 2 * l.orderkey))", errorMsg);
    }

    @Test
    public void testCorrelatedScalarSubqueriesWithCountScalarAggregationAndEqualityPredicatesInWhere() {
        this.assertQuery("SELECT (SELECT count(*) WHERE o.orderkey = 1) FROM orders o");
        this.assertQuery("SELECT count(*) FROM orders o WHERE 1 = (SELECT count(*) WHERE o.orderkey = 0)");
        this.assertQuery("SELECT * FROM orders o ORDER BY (SELECT count(*) WHERE o.orderkey = 0)");
        this.assertQuery("SELECT count(*) FROM nation n WHERE (SELECT count(*) FROM region r WHERE n.regionkey = r.regionkey) > 1");
        this.assertQueryFails("SELECT count(*) FROM nation n WHERE (SELECT count(*) FROM (SELECT count(*) FROM region r WHERE n.regionkey = r.regionkey)) > 1", "Unsupported correlated subquery type");
        this.assertQuery("SELECT (SELECT count(*) WHERE a = 1) FROM (VALUES 1, 1, 2, 3) t(a)", "VALUES true, true, false, false");
        this.assertQuery("SELECT max(o.totalprice), o.orderkey, (SELECT count(*) WHERE o.orderkey = 0) FROM orders o GROUP BY o.orderkey");
        this.assertQuery("SELECT max(o.totalprice), o.orderkey FROM orders o GROUP BY o.orderkey HAVING 1 = (SELECT count(*) WHERE o.orderkey = 0)");
        this.assertQuery("SELECT max(o.totalprice), o.orderkey FROM orders o GROUP BY o.orderkey, (SELECT count(*) WHERE o.orderkey = 0)");
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o1 JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o2 ON NOT 1 = (SELECT count(*) WHERE o1.orderkey = o2.orderkey)");
        this.assertQueryFails("SELECT count(*) FROM orders o1 LEFT JOIN orders o2 ON NOT 1 = (SELECT count(*) WHERE o1.orderkey = o2.orderkey)", "line .*: Correlated subquery in given context is not supported");
        this.assertQuery("SELECT count(*) FROM orders o WHERE 1 = (SELECT * FROM (SELECT (SELECT count(*) WHERE o.orderkey = 0)))", "SELECT count(*) FROM orders o WHERE o.orderkey = 0");
    }

    @Test
    public void testCorrelatedScalarSubqueriesWithScalarAggregation() {
        this.assertQuery("SELECT (SELECT round(3 * avg(i.a)) FROM (VALUES 1, 1, 1, 2, 2, 3, 4) i(a) WHERE i.a < o.a AND i.a < 4) FROM (VALUES 0, 3, 3, 5) o(a)", "VALUES null, 4, 4, 5");
        this.assertQuery("SELECT count(*) FROM orders o WHERE (SELECT avg(i.orderkey) FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0) > 100", "VALUES 14999");
        this.assertQuery("SELECT orderkey FROM orders o ORDER BY    (SELECT avg(i.orderkey) FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0),    orderkey LIMIT 1", "VALUES 1");
        this.assertQuery("SELECT max(o.orderdate), o.orderkey, (SELECT avg(i.orderkey) FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0) FROM orders o GROUP BY o.orderkey ORDER BY o.orderkey LIMIT 1", "VALUES ('1996-01-02', 1, 40000.0)");
        this.assertQuery("SELECT max(o.orderdate), o.orderkey FROM orders o GROUP BY o.orderkey HAVING 40000 < (SELECT avg(i.orderkey) FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0)ORDER BY o.orderkey LIMIT 1", "VALUES ('1996-07-24', 20000)");
        this.assertQuery("SELECT max(o.orderdate), o.orderkey FROM orders o GROUP BY o.orderkey, (SELECT avg(i.orderkey) FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0)ORDER BY o.orderkey LIMIT 1", "VALUES ('1996-01-02', 1)");
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o1 JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o2 ON NOT 1 = (SELECT avg(i.orderkey) FROM orders i WHERE o1.orderkey < o2.orderkey AND i.orderkey % 10000 = 0)");
        this.assertQueryFails("SELECT count(*) FROM orders o1 LEFT JOIN orders o2 ON NOT 1 = (SELECT avg(i.orderkey) FROM orders i WHERE o1.orderkey < o2.orderkey)", "line .*: Correlated subquery in given context is not supported");
        this.assertQuery("SELECT count(*) FROM orders o WHERE 100 < (SELECT * FROM (SELECT (SELECT avg(i.orderkey) FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0)))", "VALUES 14999");
        this.assertQuery("SELECT (SELECT avg(regionkey)  FROM nation n2 WHERE n2.nationkey = n1.nationkey),(SELECT avg(regionkey) FROM nation n3 WHERE n3.nationkey = n1.nationkey)FROM nation n1");
        this.assertQuery("SELECT(SELECT avg(regionkey) FROM nation n2  WHERE n2.nationkey = n1.nationkey),(SELECT avg(regionkey)+1  FROM nation n3  WHERE n3.nationkey = n1.nationkey)FROM nation n1");
    }

    @Test
    public void testCorrelatedInPredicateSubqueries() {
        String errorMsg = "Unsupported correlated subquery type";
        this.assertQueryFails("SELECT 1 IN (SELECT l.orderkey) FROM lineitem l", errorMsg);
        this.assertQueryFails("SELECT 1 IN (SELECT 2 * l.orderkey) FROM lineitem l", errorMsg);
        this.assertQueryFails("SELECT * FROM lineitem l WHERE 1 IN (SELECT 2 * l.orderkey)", errorMsg);
        this.assertQueryFails("SELECT * FROM lineitem l ORDER BY 1 IN (SELECT 2 * l.orderkey)", errorMsg);
        this.assertQueryFails("SELECT max(l.quantity), 2 * l.orderkey, 1 IN (SELECT l.orderkey) FROM lineitem l GROUP BY l.orderkey", errorMsg);
        this.assertQueryFails("SELECT max(l.quantity), 2 * l.orderkey FROM lineitem l GROUP BY l.orderkey HAVING max(l.quantity) IN (SELECT l.orderkey)", errorMsg);
        this.assertQueryFails("SELECT max(l.quantity), 2 * l.orderkey FROM lineitem l GROUP BY l.orderkey, 1 IN (SELECT l.orderkey)", errorMsg);
        this.assertQueryFails("SELECT * FROM lineitem l1 JOIN lineitem l2 ON l1.orderkey IN (SELECT l2.orderkey)", errorMsg);
        this.assertQueryFails("SELECT * FROM lineitem l WHERE (SELECT * FROM (SELECT 1 IN (SELECT 2 * l.orderkey)))", errorMsg);
        this.assertQueryFails("SELECT * FROM lineitem l WHERE true IN (SELECT 1 IN (SELECT 2 * l.orderkey))", errorMsg);
    }

    @Test
    public void testCorrelatedExistsSubqueriesWithPrunedCorrelationSymbols() {
        this.assertQuery("SELECT EXISTS(SELECT o.orderkey) FROM orders o");
        this.assertQuery("SELECT count(*) FROM orders o WHERE EXISTS(SELECT o.orderkey)");
        this.assertQuery("SELECT * FROM orders o ORDER BY EXISTS(SELECT o.orderkey)");
        this.assertQuery("SELECT max(o.totalprice), o.orderkey, EXISTS(SELECT o.orderkey) FROM orders o GROUP BY o.orderkey");
        this.assertQuery("SELECT max(o.totalprice), o.orderkey FROM orders o GROUP BY o.orderkey HAVING EXISTS (SELECT o.orderkey)");
        this.assertQuery("SELECT max(o.totalprice), o.orderkey FROM orders o GROUP BY o.orderkey, EXISTS (SELECT o.orderkey)");
        this.assertQuery("SELECT * FROM orders o JOIN (SELECT * FROM lineitem ORDER BY orderkey LIMIT 2) l ON NOT EXISTS(SELECT o.orderkey = l.orderkey)");
        this.assertQuery("SELECT count(*) FROM orders o WHERE (SELECT * FROM (SELECT EXISTS(SELECT o.orderkey)))", "VALUES 15000");
    }

    @Test
    public void testCorrelatedExistsSubqueriesWithEqualityPredicatesInWhere() {
        this.assertQuery("SELECT EXISTS(SELECT 1 WHERE o.orderkey = 1) FROM orders o");
        this.assertQuery("SELECT EXISTS(SELECT null WHERE o.orderkey = 1) FROM orders o");
        this.assertQuery("SELECT count(*) FROM orders o WHERE EXISTS(SELECT 1 WHERE o.orderkey = 0)");
        this.assertQuery("SELECT * FROM orders o ORDER BY EXISTS(SELECT 1 WHERE o.orderkey = 0)");
        this.assertQuery("SELECT count(*) FROM orders o WHERE EXISTS (SELECT avg(l.orderkey) FROM lineitem l WHERE o.orderkey = l.orderkey)");
        this.assertQueryFails("SELECT count(*) FROM orders o WHERE EXISTS (SELECT avg(l.orderkey) FROM lineitem l WHERE o.orderkey = l.orderkey GROUP BY l.linenumber)", "Unsupported correlated subquery type");
        this.assertQueryFails("SELECT count(*) FROM orders o WHERE EXISTS (SELECT count(*) FROM lineitem l WHERE o.orderkey = l.orderkey HAVING count(*) > 3)", "Unsupported correlated subquery type");
        this.assertQuery("SELECT EXISTS(SELECT 1 WHERE a = 1) FROM (VALUES 1, 1, 2, 3) t(a)", "VALUES true, true, false, false");
        this.assertQuery("SELECT max(o.totalprice), o.orderkey, EXISTS(SELECT 1 WHERE o.orderkey = 0) FROM orders o GROUP BY o.orderkey");
        this.assertQuery("SELECT max(o.totalprice), o.orderkey FROM orders o GROUP BY o.orderkey HAVING EXISTS (SELECT 1 WHERE o.orderkey = 0)");
        this.assertQuery("SELECT max(o.totalprice), o.orderkey FROM orders o GROUP BY o.orderkey, EXISTS (SELECT 1 WHERE o.orderkey = 0)");
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o1 JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o2 ON NOT EXISTS(SELECT 1 WHERE o1.orderkey = o2.orderkey)");
        this.assertQueryFails("SELECT count(*) FROM orders o1 LEFT JOIN orders o2 ON NOT EXISTS(SELECT 1 WHERE o1.orderkey = o2.orderkey)", "line .*: Correlated subquery in given context is not supported");
        this.assertQuery("SELECT count(*) FROM orders o WHERE (SELECT * FROM (SELECT EXISTS(SELECT 1 WHERE o.orderkey = 0)))", "SELECT count(*) FROM orders o WHERE o.orderkey = 0");
    }

    @Test
    public void testCorrelatedExistsSubqueries() {
        this.assertQuery("SELECT EXISTS(SELECT 1 FROM (VALUES 1, 1, 1, 2, 2, 3, 4) i(a) WHERE i.a < o.a AND i.a < 4) FROM (VALUES 0, 3, 3, 5) o(a)", "VALUES false, true, true, true");
        this.assertQuery("SELECT count(*) FROM orders o WHERE EXISTS(SELECT 1 FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 1000 = 0)", "VALUES 14999");
        this.assertQuery("SELECT orderkey FROM orders o ORDER BY EXISTS(SELECT 1 FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0)LIMIT 1", "VALUES 60000");
        this.assertQuery("SELECT max(o.orderdate), o.orderkey, EXISTS(SELECT 1 FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0) FROM orders o GROUP BY o.orderkey ORDER BY o.orderkey LIMIT 1", "VALUES ('1996-01-02', 1, true)");
        this.assertQuery("SELECT max(o.orderdate), o.orderkey FROM orders o GROUP BY o.orderkey HAVING EXISTS(SELECT 1 FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0)ORDER BY o.orderkey LIMIT 1", "VALUES ('1996-01-02', 1)");
        this.assertQuery("SELECT max(o.orderdate), o.orderkey FROM orders o GROUP BY o.orderkey, EXISTS(SELECT 1 FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0)ORDER BY o.orderkey LIMIT 1", "VALUES ('1996-01-02', 1)");
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o1 JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o2 ON NOT EXISTS(SELECT 1 FROM orders i WHERE o1.orderkey < o2.orderkey AND i.orderkey % 10000 = 0)");
        this.assertQueryFails("SELECT count(*) FROM orders o1 LEFT JOIN orders o2 ON NOT EXISTS(SELECT 1 FROM orders i WHERE o1.orderkey < o2.orderkey)", "line .*: Correlated subquery in given context is not supported");
        this.assertQuery("SELECT count(*) FROM orders o WHERE (SELECT * FROM (SELECT EXISTS(SELECT 1 FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0)))", "VALUES 14999");
    }

    @Test
    public void testUnsupportedCorrelatedExistsSubqueries() {
        String errorMsg = "Unsupported correlated subquery type";
        this.assertQueryFails("SELECT EXISTS(SELECT 1 WHERE l.orderkey > 0 OR l.orderkey != 3) FROM lineitem l", errorMsg);
        this.assertQueryFails("SELECT count(*) FROM lineitem l WHERE EXISTS(SELECT 1 WHERE l.orderkey > 0 OR l.orderkey != 3)", errorMsg);
        this.assertQueryFails("SELECT * FROM lineitem l ORDER BY EXISTS(SELECT 1 WHERE l.orderkey > 0 OR l.orderkey != 3)", errorMsg);
        this.assertQueryFails("SELECT max(l.quantity), l.orderkey, EXISTS(SELECT 1 WHERE l.orderkey > 0 OR l.orderkey != 3) FROM lineitem l GROUP BY l.orderkey", errorMsg);
        this.assertQueryFails("SELECT max(l.quantity), l.orderkey FROM lineitem l GROUP BY l.orderkey HAVING EXISTS (SELECT 1 WHERE l.orderkey > 0 OR l.orderkey != 3)", errorMsg);
        this.assertQueryFails("SELECT max(l.quantity), l.orderkey FROM lineitem l GROUP BY l.orderkey, EXISTS (SELECT 1 WHERE l.orderkey > 0 OR l.orderkey != 3)", errorMsg);
        this.assertQueryFails("SELECT * FROM lineitem l1 JOIN lineitem l2 ON NOT EXISTS(SELECT 1 WHERE l1.orderkey != l2.orderkey OR l1.orderkey = 3)", errorMsg);
        this.assertQueryFails("SELECT count(*) FROM lineitem l WHERE (SELECT * FROM (SELECT EXISTS(SELECT 1 WHERE l.orderkey > 0 OR l.orderkey != 3)))", errorMsg);
    }

    @Test
    public void testTwoCorrelatedExistsSubqueries() {
        this.assertQuery("SELECT\n  count(*) AS numwait\nFROM\n  nation l1\nWHERE\n  EXISTS(\n    SELECT *\n    FROM\n      nation l2\n    WHERE\n      l2.nationkey = l1.nationkey\n  )\n  AND NOT EXISTS(\n    SELECT *\n    FROM\n      nation l3\n    WHERE\n      l3.nationkey= l1.nationkey\n  )\n", "VALUES 0");
    }

    @Test
    public void testPredicatePushdown() {
        this.assertQuery("SELECT *\nFROM (\n  SELECT orderkey+1 as a FROM orders WHERE orderstatus = 'F' UNION ALL \n  SELECT orderkey FROM orders WHERE orderkey % 2 = 0 UNION ALL \n  (SELECT orderkey+custkey FROM orders ORDER BY orderkey LIMIT 10)\n) \nWHERE a < 20 OR a > 100 \nORDER BY a");
    }

    @Test
    public void testJoinPredicatePushdown() {
        this.assertQuery("SELECT COUNT(*)\nFROM lineitem \nJOIN (\n  SELECT * FROM orders\n) orders \nON lineitem.orderkey = orders.orderkey \nWHERE orders.orderkey % 4 = 0\n  AND lineitem.suppkey > orders.orderkey");
    }

    @Test
    public void testLeftJoinAsInnerPredicatePushdown() {
        this.assertQuery("SELECT COUNT(*)\nFROM lineitem \nLEFT JOIN (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders \nON lineitem.orderkey = orders.orderkey \nWHERE orders.orderkey % 4 = 0\n  AND (lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.custkey IS NULL)");
    }

    @Test
    public void testPlainLeftJoinPredicatePushdown() {
        this.assertQuery("SELECT COUNT(*)\nFROM lineitem \nLEFT JOIN (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders \nON lineitem.orderkey = orders.orderkey \nWHERE lineitem.orderkey % 4 = 0\n  AND (lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.orderkey IS NULL)");
    }

    @Test
    public void testLeftJoinPredicatePushdownWithSelfEquality() {
        this.assertQuery("SELECT COUNT(*)\nFROM lineitem \nLEFT JOIN (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders \nON lineitem.orderkey = orders.orderkey \nWHERE orders.orderkey = orders.orderkey\n  AND lineitem.orderkey % 4 = 0\n  AND (lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.orderkey IS NULL)");
    }

    @Test
    public void testLeftJoinPredicatePushdownWithNullConstant() {
        this.assertQuery("SELECT count(*)\nFROM orders a\nLEFT OUTER JOIN orders b\n  ON a.clerk = b.clerk\nWHERE a.orderpriority='5-LOW'\n  AND b.orderpriority='1-URGENT'\n  AND b.clerk is null\n  AND a.orderkey % 4 = 0\n");
    }

    @Test
    public void testRightJoinAsInnerPredicatePushdown() {
        this.assertQuery("SELECT COUNT(*)\nFROM (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders\nRIGHT JOIN lineitem\nON lineitem.orderkey = orders.orderkey \nWHERE orders.orderkey % 4 = 0\n  AND (lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.custkey IS NULL)");
    }

    @Test
    public void testPlainRightJoinPredicatePushdown() {
        this.assertQuery("SELECT COUNT(*)\nFROM (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders \nRIGHT JOIN lineitem\nON lineitem.orderkey = orders.orderkey \nWHERE lineitem.orderkey % 4 = 0\n  AND (lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.orderkey IS NULL)");
    }

    @Test
    public void testRightJoinPredicatePushdownWithSelfEquality() {
        this.assertQuery("SELECT COUNT(*)\nFROM (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders \nRIGHT JOIN lineitem\nON lineitem.orderkey = orders.orderkey \nWHERE orders.orderkey = orders.orderkey\n  AND lineitem.orderkey % 4 = 0\n  AND (lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.orderkey IS NULL)");
    }

    @Test
    public void testPredicatePushdownJoinEqualityGroups() {
        this.assertQuery("SELECT *\nFROM (\n  SELECT custkey custkey1, custkey%4 custkey1a, custkey%8 custkey1b, custkey%16 custkey1c\n  FROM orders\n) orders1 \nJOIN (\n  SELECT custkey custkey2, custkey%4 custkey2a, custkey%8 custkey2b\n  FROM orders\n) orders2 ON orders1.custkey1 = orders2.custkey2\nWHERE custkey2a = custkey2b\n  AND custkey1 = custkey1a\n  AND custkey2 = custkey2a\n  AND custkey1a = custkey1c\n  AND custkey1b = custkey1c\n  AND custkey1b % 2 = 0");
    }

    @Test
    public void testGroupByKeyPredicatePushdown() {
        this.assertQuery("SELECT *\nFROM (\n  SELECT custkey1, orderstatus1, SUM(totalprice1) totalprice, MAX(custkey2) maxcustkey\n  FROM (\n    SELECT *\n    FROM (\n      SELECT custkey custkey1, orderstatus orderstatus1, CAST(totalprice AS BIGINT) totalprice1, orderkey orderkey1\n      FROM orders\n    ) orders1 \n    JOIN (\n      SELECT custkey custkey2, orderstatus orderstatus2, CAST(totalprice AS BIGINT) totalprice2, orderkey orderkey2\n      FROM orders\n    ) orders2 ON orders1.orderkey1 = orders2.orderkey2\n  ) \n  GROUP BY custkey1, orderstatus1\n)\nWHERE custkey1 = maxcustkey\nAND maxcustkey % 2 = 0 \nAND orderstatus1 = 'F'\nAND totalprice > 10000\nORDER BY custkey1, orderstatus1, totalprice, maxcustkey");
    }

    @Test
    public void testNonDeterministicJoinPredicatePushdown() {
        MaterializedResult materializedResult = this.computeActual("SELECT COUNT(*)\nFROM (\n  SELECT DISTINCT *\n  FROM (\n    SELECT 'abc' as col1a, 500 as col1b FROM lineitem limit 1\n  ) table1\n  JOIN (\n    SELECT 'abc' as col2a FROM lineitem limit 1000000\n  ) table2\n  ON table1.col1a = table2.col2a\n  WHERE rand() * 1000 > table1.col1b\n)");
        MaterializedRow row = (MaterializedRow)Iterables.getOnlyElement((Iterable)materializedResult.getMaterializedRows());
        Assert.assertEquals((int)row.getFieldCount(), (int)1);
        long count = (Long)row.getField(0);
        Assert.assertTrue((count > 0L && count < 1000000L ? 1 : 0) != 0);
    }

    @Test
    public void testTrivialNonDeterministicPredicatePushdown() {
        this.assertQuery("SELECT COUNT(*) WHERE rand() >= 0");
    }

    @Test
    public void testNonDeterministicTableScanPredicatePushdown() {
        MaterializedResult materializedResult = this.computeActual("SELECT COUNT(*)\nFROM (\n  SELECT *\n  FROM lineitem\n  LIMIT 1000\n)\nWHERE rand() > 0.5");
        MaterializedRow row = (MaterializedRow)Iterables.getOnlyElement((Iterable)materializedResult.getMaterializedRows());
        Assert.assertEquals((int)row.getFieldCount(), (int)1);
        long count = (Long)row.getField(0);
        Assert.assertTrue((count > 0L && count < 1000L ? 1 : 0) != 0);
    }

    @Test
    public void testNonDeterministicAggregationPredicatePushdown() {
        MaterializedResult materializedResult = this.computeActual("SELECT COUNT(*)\nFROM (\n  SELECT orderkey, COUNT(*)\n  FROM lineitem\n  GROUP BY orderkey\n  LIMIT 1000\n)\nWHERE rand() > 0.5");
        MaterializedRow row = (MaterializedRow)Iterables.getOnlyElement((Iterable)materializedResult.getMaterializedRows());
        Assert.assertEquals((int)row.getFieldCount(), (int)1);
        long count = (Long)row.getField(0);
        Assert.assertTrue((count > 0L && count < 1000L ? 1 : 0) != 0);
    }

    @Test
    public void testSemiJoinPredicateMoveAround() {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM orders WHERE custkey % 2 = 0 AND orderkey % 3 = 0)\nWHERE orderkey\n  IN (\n    SELECT CASE WHEN orderkey % 7 = 0 THEN NULL ELSE orderkey END\n    FROM lineitem\n    WHERE partkey % 2 = 0)\n  AND\n    orderkey % 2 = 0");
    }

    @Test
    public void testUnionAllPredicateMoveAroundWithOverlappingProjections() {
        this.assertQuery("SELECT COUNT(*)\nFROM (\n  SELECT orderkey AS x, orderkey as y\n  FROM orders\n  WHERE orderkey % 3 = 0\n  UNION ALL\n  SELECT orderkey AS x, orderkey as y\n  FROM orders\n  WHERE orderkey % 2 = 0\n) a\nJOIN (\n  SELECT orderkey AS x, orderkey as y\n  FROM orders\n) b\nON a.x = b.x");
    }

    @Test
    public void testTableSampleBernoulliBoundaryValues() {
        MaterializedResult fullSample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE BERNOULLI (100)");
        MaterializedResult emptySample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE BERNOULLI (0)");
        MaterializedResult all = this.computeExpected("SELECT orderkey FROM orders", fullSample.getTypes());
        QueryAssertions.assertContains(all, fullSample);
        Assert.assertEquals((int)emptySample.getMaterializedRows().size(), (int)0);
    }

    @Test
    public void testTableSampleBernoulli() {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        int total = this.computeExpected("SELECT orderkey FROM orders", (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT)).getMaterializedRows().size();
        for (int i = 0; i < 100; ++i) {
            List values = this.computeActual("SELECT orderkey FROM ORDERS TABLESAMPLE BERNOULLI (50)").getMaterializedRows();
            Assert.assertEquals((int)values.size(), (int)ImmutableSet.copyOf((Collection)values).size(), (String)"TABLESAMPLE produced duplicate rows");
            stats.addValue((double)values.size() * 1.0 / (double)total);
        }
        double mean = stats.getGeometricMean();
        Assert.assertTrue((mean > 0.45 && mean < 0.55 ? 1 : 0) != 0, (String)String.format("Expected mean sampling rate to be ~0.5, but was %s", mean));
    }

    @Test
    public void testFunctionNotRegistered() {
        this.assertQueryFails("SELECT length(1)", "\\Qline 1:8: Unexpected parameters (integer) for function length. Expected:\\E.*");
    }

    @Test
    public void testFunctionArgumentTypeConstraint() {
        this.assertQueryFails("SELECT greatest(rgb(255, 0, 0))", "\\Qline 1:8: Unexpected parameters (color) for function greatest. Expected: greatest(E) E:orderable\\E.*");
    }

    @Test
    public void testTypeMismatch() {
        this.assertQueryFails("SELECT 1 <> 'x'", "\\Qline 1:10: '<>' cannot be applied to integer, varchar(1)\\E");
    }

    @Test
    public void testInvalidType() {
        this.assertQueryFails("SELECT CAST(null AS array(foo))", "\\Qline 1:8: Unknown type: array(foo)\\E");
    }

    @Test
    public void testInvalidTypeInfixOperator() {
        this.assertQueryFails("SELECT ('a' || 'z') + (3 * 4) / 5", "\\Qline 1:21: '+' cannot be applied to varchar, integer\\E");
    }

    @Test
    public void testInvalidTypeBetweenOperator() {
        this.assertQueryFails("SELECT 'a' BETWEEN 3 AND 'z'", "\\Qline 1:12: Cannot check if varchar(1) is BETWEEN integer and varchar(1)\\E");
    }

    @Test
    public void testInvalidTypeArray() {
        this.assertQueryFails("SELECT ARRAY[1, 2, 'a']", "\\Qline 1:20: All ARRAY elements must be the same type: integer\\E");
    }

    @Test
    public void testTimeLiterals() {
        MaterializedResult.Builder builder = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{DateType.DATE, TimeType.TIME, TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, TimestampType.TIMESTAMP, TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE});
        DateTimeZone sessionTimeZone = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)this.getSession().getTimeZoneKey());
        DateTimeZone utcPlus6 = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)360L));
        builder.row(new Object[]{new Date(new DateTime(2013, 3, 22, 0, 0, sessionTimeZone).getMillis()), new Time(new DateTime(1970, 1, 1, 3, 4, 5, sessionTimeZone).getMillisOfDay()), new Time(new DateTime(1970, 1, 1, 3, 4, 5, utcPlus6).getMillis()), new Timestamp(new DateTime(1960, 1, 22, 3, 4, 5, sessionTimeZone).getMillis()), new Timestamp(new DateTime(1960, 1, 22, 3, 4, 5, utcPlus6).getMillis())});
        MaterializedResult actual = this.computeActual("SELECT DATE '2013-03-22', TIME '3:04:05', TIME '3:04:05 +06:00', TIMESTAMP '1960-01-22 3:04:05', TIMESTAMP '1960-01-22 3:04:05 +06:00'");
        Assert.assertEquals((Iterable)actual, (Iterable)builder.build());
    }

    @Test
    public void testArrayShuffle() {
        List expected = IntStream.rangeClosed(1, 500).boxed().collect(Collectors.toList());
        HashSet<List> distinctResults = new HashSet<List>();
        distinctResults.add(expected);
        for (int i = 0; i < 3; ++i) {
            MaterializedResult results = this.computeActual(String.format("SELECT shuffle(ARRAY %s) from orders limit 10", expected));
            List rows = results.getMaterializedRows();
            Assert.assertTrue((rows.size() == 10 ? 1 : 0) != 0);
            for (MaterializedRow row : rows) {
                List actual = (List)row.getField(0);
                QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
                distinctResults.add(actual);
            }
        }
        Assert.assertTrue((distinctResults.size() >= 24 ? 1 : 0) != 0, (String)"shuffle must produce at least 24 distinct results");
    }

    @Test
    public void testNonReservedTimeWords() {
        this.assertQuery("SELECT TIME, TIMESTAMP, DATE, INTERVAL\nFROM (SELECT 1 TIME, 2 TIMESTAMP, 3 DATE, 4 INTERVAL)");
    }

    @Test
    public void testCustomAdd() {
        this.assertQuery("SELECT custom_add(orderkey, custkey) FROM orders", "SELECT orderkey + custkey FROM orders");
    }

    @Test
    public void testCustomSum() {
        String sql = "SELECT orderstatus, custom_sum(orderkey) FROM orders GROUP BY orderstatus";
        this.assertQuery(sql, sql.replace("custom_sum", "sum"));
    }

    @Test
    public void testCustomRank() {
        String sql = "SELECT orderstatus, clerk, sales\n, custom_rank() OVER (PARTITION BY orderstatus ORDER BY sales DESC) rnk\nFROM (\n  SELECT orderstatus, clerk, sum(totalprice) sales\n  FROM orders\n  GROUP BY orderstatus, clerk\n)\nORDER BY orderstatus, clerk";
        Assert.assertEquals((Iterable)this.computeActual(sql), (Iterable)this.computeActual(sql.replace("custom_rank", "rank")));
    }

    @Test
    public void testApproxSetBigint() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(approx_set(custkey)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1002L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetVarchar() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(approx_set(CAST(custkey AS VARCHAR))) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1024L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetDouble() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(approx_set(CAST(custkey AS DOUBLE))) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1014L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetBigintGroupBy() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(approx_set(custkey)) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 1001L}).row(new Object[]{"F", 998L}).row(new Object[]{"P", 304L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetVarcharGroupBy() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(approx_set(CAST(custkey AS VARCHAR))) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 1021L}).row(new Object[]{"F", 1019L}).row(new Object[]{"P", 304L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetDoubleGroupBy() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(approx_set(CAST(custkey AS DOUBLE))) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 1011L}).row(new Object[]{"F", 1011L}).row(new Object[]{"P", 304L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetWithNulls() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(approx_set(IF(orderstatus = 'O', custkey))) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{1001L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetOnlyNulls() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(approx_set(null)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{null}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetGroupByWithOnlyNullsInOneGroup() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(approx_set(IF(orderstatus != 'O', custkey))) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", null}).row(new Object[]{"F", 998L}).row(new Object[]{"P", 304L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetGroupByWithNulls() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(approx_set(IF(custkey % 2 <> 0, custkey))) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 499L}).row(new Object[]{"F", 496L}).row(new Object[]{"P", 153L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testMergeHyperLogLog() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(merge(create_hll(custkey))) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1002L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testMergeHyperLogLogGroupBy() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(merge(create_hll(custkey))) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 1001L}).row(new Object[]{"F", 998L}).row(new Object[]{"P", 304L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testMergeHyperLogLogWithNulls() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(merge(create_hll(IF(orderstatus = 'O', custkey)))) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1001L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testMergeHyperLogLogGroupByWithNulls() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(merge(create_hll(IF(orderstatus != 'O', custkey)))) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", null}).row(new Object[]{"F", 998L}).row(new Object[]{"P", 304L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testMergeHyperLogLogOnlyNulls() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(merge(null)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{null}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testEmptyApproxSet() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(empty_approx_set())");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{0L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testMergeEmptyApproxSet() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(merge(empty_approx_set())) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{0L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testMergeEmptyNonEmptyApproxSet() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(merge(c)) FROM (SELECT create_hll(custkey) c FROM ORDERS UNION ALL SELECT empty_approx_set())");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1002L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetBigint() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(cast(approx_set(custkey) AS P4HYPERLOGLOG)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1002L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetVarchar() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(cast(approx_set(CAST(custkey AS VARCHAR)) AS P4HYPERLOGLOG)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1024L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetDouble() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(cast(approx_set(CAST(custkey AS DOUBLE)) AS P4HYPERLOGLOG)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1014L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetBigintGroupBy() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(cast(approx_set(custkey) AS P4HYPERLOGLOG)) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 1001L}).row(new Object[]{"F", 998L}).row(new Object[]{"P", 308L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetVarcharGroupBy() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(cast(approx_set(CAST(custkey AS VARCHAR)) AS P4HYPERLOGLOG)) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 1021L}).row(new Object[]{"F", 1019L}).row(new Object[]{"P", 302L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetDoubleGroupBy() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(cast(approx_set(CAST(custkey AS DOUBLE)) AS P4HYPERLOGLOG)) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 1011L}).row(new Object[]{"F", 1011L}).row(new Object[]{"P", 306L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetWithNulls() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(cast(approx_set(IF(orderstatus = 'O', custkey)) AS P4HYPERLOGLOG)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{1001L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetOnlyNulls() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(cast(approx_set(null) AS P4HYPERLOGLOG)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{null}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetGroupByWithOnlyNullsInOneGroup() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(cast(approx_set(IF(orderstatus != 'O', custkey)) AS P4HYPERLOGLOG)) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", null}).row(new Object[]{"F", 998L}).row(new Object[]{"P", 308L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetGroupByWithNulls() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(cast(approx_set(IF(custkey % 2 <> 0, custkey)) AS P4HYPERLOGLOG)) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 495L}).row(new Object[]{"F", 491L}).row(new Object[]{"P", 153L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testValuesWithNonTrivialType() {
        MaterializedResult actual = this.computeActual("VALUES (0.0/0.0, 1.0/0.0, -1.0/0.0)");
        List rows = actual.getMaterializedRows();
        Assert.assertEquals((int)rows.size(), (int)1);
        MaterializedRow row = (MaterializedRow)rows.get(0);
        Assert.assertTrue((boolean)((Double)row.getField(0)).isNaN());
        Assert.assertEquals((Object)row.getField(1), (Object)Double.POSITIVE_INFINITY);
        Assert.assertEquals((Object)row.getField(2), (Object)Double.NEGATIVE_INFINITY);
    }

    @Test
    public void testValuesWithTimestamp() {
        MaterializedResult actual = this.computeActual("VALUES (current_timestamp, now())");
        List rows = actual.getMaterializedRows();
        Assert.assertEquals((int)rows.size(), (int)1);
        MaterializedRow row = (MaterializedRow)rows.get(0);
        Assert.assertEquals((Object)row.getField(0), (Object)row.getField(1));
    }

    @Test
    public void testValuesWithUnusedColumns() {
        MaterializedResult actual = this.computeActual("SELECT foo from (values (1, 2)) a(foo, bar)");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{1}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testFilterPushdownWithAggregation() {
        this.assertQuery("SELECT * FROM (SELECT count(*) FROM orders) WHERE 0=1");
        this.assertQuery("SELECT * FROM (SELECT count(*) FROM orders) WHERE null");
    }

    @Test
    public void testAccessControl() {
        this.assertAccessDenied("SELECT COUNT(true) FROM orders", "Cannot select from table .*.orders.*", TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_TABLE));
        this.assertAccessDenied("INSERT INTO orders SELECT * FROM orders", "Cannot insert into table .*.orders.*", TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.INSERT_TABLE));
        this.assertAccessDenied("DELETE FROM orders", "Cannot delete from table .*.orders.*", TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.DELETE_TABLE));
        this.assertAccessDenied("CREATE TABLE foo AS SELECT * FROM orders", "Cannot create table .*.foo.*", TestingAccessControlManager.privilege((String)"foo", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_TABLE));
    }

    @Test
    public void testEmptyInputForUnnest() {
        this.assertQuery("select val from (select distinct vals from (values (array[2])) t(vals) where false) tmp cross join unnest(tmp.vals) tt(val)", "select 1 where 1=2");
    }

    @Test
    public void testCoercions() {
        this.assertQuery("SELECT length(NULL)");
        this.assertQuery("SELECT CAST('abc' AS VARCHAR(255)) || CAST('abc' AS VARCHAR(252))");
        this.assertQuery("SELECT CAST('abc' AS VARCHAR(255)) || 'abc'");
        this.assertQuery("SELECT CAST(1.1 AS DECIMAL(38,1)) + NULL");
        this.assertQuery("SELECT CAST(292 AS DECIMAL(38,1)) + CAST(292.1 AS DECIMAL(5,1))");
        QueryAssertions.assertEqualsIgnoreOrder(this.computeActual("SELECT ARRAY[CAST(282 AS DECIMAL(22,1)), CAST(282 AS DECIMAL(10,1))] || CAST(292 AS DECIMAL(5,1))"), this.computeActual("SELECT ARRAY[CAST(282 AS DECIMAL(22,1)), CAST(282 AS DECIMAL(10,1)), CAST(292 AS DECIMAL(5,1))]"));
        this.assertQuery("SELECT CAST(1.1 AS DECIMAL(38,1)) + CAST(292 AS BIGINT)");
        this.assertQuery("SELECT CAST(292 AS DECIMAL(38,1)) = CAST(292 AS BIGINT)");
        QueryAssertions.assertEqualsIgnoreOrder(this.computeActual("SELECT ARRAY[CAST(282 AS DECIMAL(22,1)), CAST(282 AS DECIMAL(10,1))] || CAST(292 AS BIGINT)"), this.computeActual("SELECT ARRAY[CAST(282 AS DECIMAL(22,1)), CAST(282 AS DECIMAL(10,1)), CAST(292 AS DECIMAL(19,0))]"));
        this.assertQuery("SELECT CAST(1.1 AS DECIMAL(38,1)) + CAST(1.1 AS DOUBLE)");
        this.assertQuery("SELECT CAST(1.1 AS DECIMAL(38,1)) = CAST(1.1 AS DOUBLE)");
        this.assertQuery("SELECT SIN(CAST(1.1 AS DECIMAL(38,1)))");
        QueryAssertions.assertEqualsIgnoreOrder(this.computeActual("SELECT ARRAY[CAST(282.1 AS DOUBLE), CAST(283.2 AS DOUBLE)] || CAST(101.3 AS DECIMAL(5,1))"), this.computeActual("SELECT ARRAY[CAST(282.1 AS DOUBLE), CAST(283.2 AS DOUBLE), CAST(101.3 AS DOUBLE)]"));
        this.assertQuery("SELECT CAST(1.1 AS DECIMAL(38,1)) + CAST(292 AS INTEGER)");
        this.assertQuery("SELECT CAST(292 AS DECIMAL(38,1)) = CAST(292 AS INTEGER)");
        QueryAssertions.assertEqualsIgnoreOrder(this.computeActual("SELECT ARRAY[CAST(282 AS DECIMAL(22,1)), CAST(282 AS DECIMAL(10,1))] || CAST(292 AS INTEGER)"), this.computeActual("SELECT ARRAY[CAST(282 AS DECIMAL(22,1)), CAST(282 AS DECIMAL(10,1)), CAST(292 AS DECIMAL(19,0))]"));
        this.assertQuery("SELECT CAST(1.1 AS DECIMAL(38,1)) + CAST(CAST(121 AS DECIMAL(30,1)) AS TINYINT)");
        this.assertQuery("SELECT CAST(292 AS DECIMAL(38,1)) = CAST(CAST(121 AS DECIMAL(30,1)) AS TINYINT)");
        this.assertQuery("SELECT CAST(1.1 AS DECIMAL(38,1)) + CAST(CAST(121 AS DECIMAL(30,1)) AS SMALLINT)");
        this.assertQuery("SELECT CAST(292 AS DECIMAL(38,1)) = CAST(CAST(121 AS DECIMAL(30,1)) AS SMALLINT)");
        this.assertQuery("SELECT * FROM (  SELECT t2.x || t2.z cc FROM (    SELECT *    FROM (VALUES (CAST('a' as VARCHAR), CAST('c' as VARCHAR))) t(x, z)  ) t2  JOIN (    SELECT *    FROM (VALUES (CAST('a' as VARCHAR), CAST('c' as VARCHAR))) u(x, z)    WHERE z='c'  ) u2  ON t2.z = u2.z) tt WHERE cc = 'ac'", "SELECT 'ac'");
        this.assertQuery("SELECT * FROM (  SELECT greatest (t.x, t.z) cc FROM (    SELECT *    FROM (VALUES (VARCHAR 'a', VARCHAR 'c')) t(x, z)  ) t  JOIN (    SELECT *    FROM (VALUES (VARCHAR 'a', VARCHAR 'c')) u(x, z)    WHERE z='c'  ) u  ON t.z = u.z)WHERE cc = 'c'", "SELECT 'c'");
        this.assertQuery("SELECT cc[1], cc[2] FROM ( SELECT * FROM (  SELECT array[t.x, t.z] cc FROM (    SELECT *    FROM (VALUES (VARCHAR 'a', VARCHAR 'c')) t(x, z)  ) t  JOIN (    SELECT *    FROM (VALUES (VARCHAR 'a', VARCHAR 'c')) u(x, z)    WHERE z='c'  ) u  ON t.z = u.z) WHERE cc = array['a', 'c'])", "SELECT 'a', 'c'");
        this.assertQuery("SELECT c = 'x'FROM (    SELECT 'x' as c    UNION ALL    SELECT 'yy' as c)");
    }

    @Test
    public void testExecute() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SELECT 123, 'abc'").build();
        this.assertQuery(session, "EXECUTE my_query", "SELECT 123, 'abc'");
    }

    @Test
    public void testExecuteUsing() {
        String query = "SELECT a + 1, count(?) FROM (VALUES 1, 2, 3, 2) t1(a) JOIN (VALUES 1, 2, 3, 4) t2(b) ON b < ? WHERE a < ? GROUP BY a + 1 HAVING count(1) > ?";
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", query).build();
        this.assertQuery(session, "EXECUTE my_query USING 1, 5, 4, 0", "VALUES (2, 4), (3, 8), (4, 4)");
    }

    @Test
    public void testExecuteUsingComplexJoinCriteria() {
        String query = "SELECT * FROM (VALUES 1) t(a) JOIN (VALUES 2) u(a) ON t.a + u.a < ?";
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", query).build();
        this.assertQuery(session, "EXECUTE my_query USING 5", "VALUES (1, 2)");
    }

    @Test
    public void testExecuteUsingWithSubquery() {
        String query = "SELECT ? in (SELECT orderkey FROM orders)";
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", query).build();
        this.assertQuery(session, "EXECUTE my_query USING 10", "SELECT 10 in (SELECT orderkey FROM orders)");
    }

    @Test
    public void testExecuteUsingWithSubqueryInJoin() {
        String query = "SELECT * FROM     (VALUES ?,2,3) t(x)   JOIN     (VALUES 1,2,3) t2(y)   ON (x in (VALUES 1,2,?)) = (y in (VALUES 1,2,3)) AND (x in (VALUES 1,?)) = (y in (VALUES 1,2))";
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", query).build();
        this.assertQuery(session, "EXECUTE my_query USING 1, 3, 2", "VALUES (1,1), (1,2), (2,2), (2,1), (3,3)");
    }

    @Test
    public void testExecuteWithParametersInGroupBy() {
        try {
            String query = "SELECT a + ?, count(1) FROM (VALUES 1, 2, 3, 2) t(a) GROUP BY a + ?";
            Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", query).build();
            this.computeActual(session, "EXECUTE my_query USING 1, 1");
            Assert.fail((String)"parameters in group by and select should fail");
        }
        catch (SemanticException e) {
            Assert.assertEquals((Object)e.getCode(), (Object)SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY);
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"line 1:10: '(\"a\" + ?)' must be an aggregate expression or appear in GROUP BY clause");
        }
    }

    @Test
    public void testExecuteNoSuchQuery() {
        this.assertQueryFails("EXECUTE my_query", "Prepared statement not found: my_query");
    }

    @Test
    public void testParametersNonPreparedStatement() {
        try {
            this.computeActual("SELECT ?, 1");
            Assert.fail((String)"parameters not in prepared statements should fail");
        }
        catch (SemanticException e) {
            Assert.assertEquals((Object)e.getCode(), (Object)SemanticErrorCode.INVALID_PARAMETER_USAGE);
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"line 1:1: Incorrect number of parameters: expected 1 but found 0");
        }
    }

    @Test
    public void testDescribeInput() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "select ? from nation where nationkey = ? and name < ?").build();
        MaterializedResult actual = this.computeActual(session, "DESCRIBE INPUT my_query");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR}).row(new Object[]{0, "unknown"}).row(new Object[]{1, "bigint"}).row(new Object[]{2, "varchar"}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    @Test
    public void testDescribeInputWithAggregation() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "select count(*) + ? from nation").build();
        MaterializedResult actual = this.computeActual(session, "DESCRIBE INPUT my_query");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR}).row(new Object[]{0, "bigint"}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    @Test
    public void testDescribeInputNoParameters() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "select * from nation").build();
        MaterializedResult actual = this.computeActual(session, "DESCRIBE INPUT my_query");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testDescribeInputNoSuchQuery() {
        this.assertQueryFails("DESCRIBE INPUT my_query", "Prepared statement not found: my_query");
    }

    @Test
    public void testQuantifiedComparison() {
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey = ANY (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey = ALL (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey <> ANY (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey <> ALL (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey = ALL (SELECT regionkey FROM region WHERE name IN ('ASIA'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey <> ALL (SELECT regionkey FROM region WHERE name IN ('ASIA'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey = ANY (SELECT regionkey FROM region WHERE name IN ('EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey <> ANY (SELECT regionkey FROM region WHERE name IN ('EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey < SOME (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey <= ANY (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey > ANY (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey >= SOME (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey < ALL (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey <= ALL (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey > ALL (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey >= ALL (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT 1.0 < ALL(SELECT 1), 1 < ALL(SELECT 1)");
        this.assertQuery("SELECT 1.0 < ANY(SELECT 1), 1 < ANY(SELECT 1)");
        this.assertQuery("SELECT 1.0 <= ALL(SELECT 1) WHERE 1 <= ALL(SELECT 1)");
        this.assertQuery("SELECT 1.0 <= ANY(SELECT 1) WHERE 1 <= ANY(SELECT 1)");
        this.assertQuery("SELECT 1.0 <= ALL(SELECT 1), 1 <= ALL(SELECT 1) WHERE 1 <= ALL(SELECT 1)");
        this.assertQuery("SELECT 1.0 <= ANY(SELECT 1), 1 <= ANY(SELECT 1) WHERE 1 <= ANY(SELECT 1)");
        this.assertQuery("SELECT 1.0 = ALL(SELECT 1) WHERE 1 = ALL(SELECT 1)");
        this.assertQuery("SELECT 1.0 = ANY(SELECT 1) WHERE 1 = ANY(SELECT 1)");
        this.assertQuery("SELECT 1.0 = ALL(SELECT 1), 2 = ALL(SELECT 1) WHERE 1 = ALL(SELECT 1)");
        this.assertQuery("SELECT 1.0 = ANY(SELECT 1), 2 = ANY(SELECT 1) WHERE 1 = ANY(SELECT 1)");
        this.assertQuery("SELECT cast(1 as decimal(3,2)) < ALL(SELECT cast(1 as decimal(3,1)))");
        this.assertQuery("SELECT cast(1 as decimal(3,2)) < ANY(SELECT cast(1 as decimal(3,1)))");
        this.assertQuery("SELECT cast(1 as decimal(3,2)) <= ALL(SELECT cast(1 as decimal(3,1)))");
        this.assertQuery("SELECT cast(1 as decimal(3,2)) <= ANY(SELECT cast(1 as decimal(3,1)))");
        this.assertQuery("SELECT cast(1 as decimal(3,2)) = ALL(SELECT cast(1 as decimal(3,1)))");
        this.assertQuery("SELECT cast(1 as decimal(3,2)) = ANY(SELECT cast(1 as decimal(3,1)))", "SELECT true");
        this.assertQuery("SELECT cast(1 as decimal(3,2)) <> ALL(SELECT cast(1 as decimal(3,1)))");
        this.assertQuery("SELECT cast(1 as decimal(3,2)) <> ANY(SELECT cast(1 as decimal(3,1)))");
    }

    @Test(dataProvider="quantified_comparisons_corner_cases")
    public void testQuantifiedComparisonCornerCases(String query) {
        this.assertQuery(query);
    }

    @DataProvider(name="quantified_comparisons_corner_cases")
    public Object[][] qualifiedComparisonsCornerCases() {
        Stream<String> queries = QueryTemplate.queryTemplate("SELECT %value% %operator% %quantifier% (SELECT * FROM (%subquery%))", new QueryTemplate.Parameter[0]).replaceAll(QueryTemplate.parameter("subquery").of("SELECT 1 WHERE false", "SELECT CAST(NULL AS INTEGER)", "VALUES (1), (NULL)"), QueryTemplate.parameter("quantifier").of("ALL", "ANY"), QueryTemplate.parameter("value").of("1", "NULL"), QueryTemplate.parameter("operator").of("=", "!=", "<", ">", "<=", ">="));
        ImmutableList excludedInPredicateQueries = ImmutableList.of((Object)"SELECT NULL != ALL (SELECT * FROM (SELECT 1 WHERE false))", (Object)"SELECT NULL = ANY (SELECT * FROM (SELECT 1 WHERE false))", (Object)"SELECT NULL != ALL (SELECT * FROM (SELECT CAST(NULL AS INTEGER)))", (Object)"SELECT NULL = ANY (SELECT * FROM (SELECT CAST(NULL AS INTEGER)))", (Object)"SELECT NULL = ANY (SELECT * FROM (VALUES (1), (NULL)))", (Object)"SELECT NULL != ALL (SELECT * FROM (VALUES (1), (NULL)))");
        Predicate<String> isExcluded = ((List)excludedInPredicateQueries)::contains;
        return Arguments.toArgumentsArrays(queries.filter(isExcluded.negate()).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0})));
    }

    @Test
    public void testPreparedStatementWithSubqueries() {
        List<QueryTemplate.Parameter> leftValues = QueryTemplate.parameter("left").of("", "1 = ", "EXISTS", "1 IN", "1 = ANY", "1 = ALL", "2 <> ANY", "2 <> ALL", "0 < ALL", "0 < ANY", "1 <= ALL", "1 <= ANY");
        QueryTemplate.queryTemplate("SELECT %left% (SELECT 1 WHERE 2 = ?)", new QueryTemplate.Parameter[0]).replaceAll(leftValues).forEach(query -> {
            Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", query).build();
            this.assertQuery(session, "EXECUTE my_query USING 2", "SELECT true");
        });
    }

    @Test
    public void testDescribeOutput() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SELECT * FROM nation").build();
        MaterializedResult actual = this.computeActual(session, "DESCRIBE OUTPUT my_query");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN}).row(new Object[]{"nationkey", session.getCatalog().get(), session.getSchema().get(), "nation", "bigint", 8, false}).row(new Object[]{"name", session.getCatalog().get(), session.getSchema().get(), "nation", "varchar(25)", 0, false}).row(new Object[]{"regionkey", session.getCatalog().get(), session.getSchema().get(), "nation", "bigint", 8, false}).row(new Object[]{"comment", session.getCatalog().get(), session.getSchema().get(), "nation", "varchar(152)", 0, false}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    @Test
    public void testDescribeOutputNamedAndUnnamed() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "select 1, name, regionkey as my_alias from nation").build();
        MaterializedResult actual = this.computeActual(session, "DESCRIBE OUTPUT my_query");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN}).row(new Object[]{"_col0", "", "", "", "integer", 4, false}).row(new Object[]{"name", session.getCatalog().get(), session.getSchema().get(), "nation", "varchar(25)", 0, false}).row(new Object[]{"my_alias", session.getCatalog().get(), session.getSchema().get(), "nation", "bigint", 8, true}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    @Test
    public void testDescribeOutputNonSelect() {
        this.assertDescribeOutputRowCount("CREATE TABLE foo AS SELECT * FROM nation");
        this.assertDescribeOutputRowCount("DELETE FROM orders");
        this.assertDescribeOutputEmpty("CALL foo()");
        this.assertDescribeOutputEmpty("SET SESSION optimize_hash_generation=false");
        this.assertDescribeOutputEmpty("RESET SESSION optimize_hash_generation");
        this.assertDescribeOutputEmpty("START TRANSACTION");
        this.assertDescribeOutputEmpty("COMMIT");
        this.assertDescribeOutputEmpty("ROLLBACK");
        this.assertDescribeOutputEmpty("GRANT INSERT ON foo TO bar");
        this.assertDescribeOutputEmpty("REVOKE INSERT ON foo FROM bar");
        this.assertDescribeOutputEmpty("CREATE SCHEMA foo");
        this.assertDescribeOutputEmpty("ALTER SCHEMA foo RENAME TO bar");
        this.assertDescribeOutputEmpty("DROP SCHEMA foo");
        this.assertDescribeOutputEmpty("CREATE TABLE foo (x bigint)");
        this.assertDescribeOutputEmpty("ALTER TABLE foo ADD COLUMN y bigint");
        this.assertDescribeOutputEmpty("ALTER TABLE foo RENAME TO bar");
        this.assertDescribeOutputEmpty("DROP TABLE foo");
        this.assertDescribeOutputEmpty("CREATE VIEW foo AS SELECT * FROM nation");
        this.assertDescribeOutputEmpty("DROP VIEW foo");
        this.assertDescribeOutputEmpty("PREPARE test FROM SELECT * FROM orders");
        this.assertDescribeOutputEmpty("EXECUTE test");
        this.assertDescribeOutputEmpty("DEALLOCATE PREPARE test");
    }

    private void assertDescribeOutputRowCount(@Language(value="SQL") String sql) {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", sql).build();
        MaterializedResult actual = this.computeActual(session, "DESCRIBE OUTPUT my_query");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN}).row(new Object[]{"rows", "", "", "", "bigint", 8, false}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    private void assertDescribeOutputEmpty(@Language(value="SQL") String sql) {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", sql).build();
        MaterializedResult actual = this.computeActual(session, "DESCRIBE OUTPUT my_query");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    @Test
    public void testDescribeOutputShowTables() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SHOW TABLES").build();
        MaterializedResult actual = this.computeActual(session, "DESCRIBE OUTPUT my_query");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN}).row(new Object[]{"Table", session.getCatalog().get(), "information_schema", "tables", "varchar", 0, true}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    @Test
    public void testDescribeOutputOnAliasedColumnsAndExpressions() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "select count(*) as this_is_aliased, 1 + 2 from nation").build();
        MaterializedResult actual = this.computeActual(session, "DESCRIBE OUTPUT my_query");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN}).row(new Object[]{"this_is_aliased", "", "", "", "bigint", 8, true}).row(new Object[]{"_col1", "", "", "", "integer", 4, false}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    @Test
    public void testDescribeOutputNoSuchQuery() {
        this.assertQueryFails("DESCRIBE OUTPUT my_query", "Prepared statement not found: my_query");
    }

    @Test
    public void testSubqueriesWithDisjunction() {
        List<QueryTemplate.Parameter> projections = QueryTemplate.parameter("projection").of("count(*)", "*", "%condition%");
        List<QueryTemplate.Parameter> conditions = QueryTemplate.parameter("condition").of("nationkey IN (SELECT 1) OR TRUE", "EXISTS(SELECT 1) OR TRUE");
        QueryTemplate.queryTemplate("SELECT %projection% FROM nation WHERE %condition%", new QueryTemplate.Parameter[0]).replaceAll(projections, conditions).forEach(this::assertQuery);
        QueryTemplate.queryTemplate("SELECT %projection% FROM nation WHERE (%condition%) AND nationkey <3", new QueryTemplate.Parameter[0]).replaceAll(projections, conditions).forEach(this::assertQuery);
        this.assertQuery("SELECT count(*) FROM nation WHERE (SELECT true FROM (SELECT 1) t(a) WHERE a = nationkey) OR TRUE", "SELECT 25");
        this.assertQueryFails("SELECT (SELECT true FROM (SELECT 1) t(a) WHERE a = nationkey) FROM nation WHERE (SELECT true FROM (SELECT 1) t(a) WHERE a = nationkey) OR TRUE", "Unsupported correlated subquery type");
    }

    @Test
    public void testAssignUniqueId() {
        String unionLineitem50Times = IntStream.range(0, 50).mapToObj(i -> "SELECT * FROM lineitem").collect(Collectors.joining(" UNION ALL "));
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM (   SELECT (SELECT count(*) WHERE c = 1)    FROM (SELECT CASE orderkey WHEN 1 THEN orderkey ELSE 1 END        FROM (" + unionLineitem50Times + ")) o(c)) result(a) WHERE a = 1)", "VALUES 3008750");
    }
}

