/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.sql;

import com.facebook.presto.tests.sql.SqlExecutor;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class JdbcSqlExecutor
implements SqlExecutor {
    private final String jdbcUrl;

    public JdbcSqlExecutor(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    @Override
    public void execute(String sql) {
        try (Connection connection = DriverManager.getConnection(this.jdbcUrl);
             Statement statement = connection.createStatement();){
            statement.execute(sql);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error executing sql:\n" + sql, e);
        }
    }
}

