/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.tpch;

import com.facebook.presto.spi.ConnectorIndex;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.tests.tpch.TpchIndexedData;
import com.google.common.base.Function;
import java.util.Objects;

class TpchConnectorIndex
implements ConnectorIndex {
    private final Function<RecordSet, RecordSet> keyFormatter;
    private final Function<RecordSet, RecordSet> outputFormatter;
    private final TpchIndexedData.IndexedTable indexedTable;

    public TpchConnectorIndex(Function<RecordSet, RecordSet> keyFormatter, Function<RecordSet, RecordSet> outputFormatter, TpchIndexedData.IndexedTable indexedTable) {
        this.keyFormatter = Objects.requireNonNull(keyFormatter, "keyFormatter is null");
        this.outputFormatter = Objects.requireNonNull(outputFormatter, "outputFormatter is null");
        this.indexedTable = Objects.requireNonNull(indexedTable, "indexedTable is null");
    }

    public RecordSet lookup(RecordSet rawInputRecordSet) {
        RecordSet inputRecordSet = (RecordSet)this.keyFormatter.apply((Object)rawInputRecordSet);
        RecordSet rawOutputRecordSet = this.indexedTable.lookupKeys(inputRecordSet);
        return (RecordSet)this.outputFormatter.apply((Object)rawOutputRecordSet);
    }
}

