/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.AllNodes;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.server.testing.TestingPrestoServer;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.testing.TestingAccessControlManager;
import com.facebook.presto.tests.AbstractTestQueries;
import com.facebook.presto.tests.TestingPrestoClient;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Closeables;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.intellij.lang.annotations.Language;

public final class StandaloneQueryRunner
implements QueryRunner {
    private final TestingPrestoServer server;
    private final TestingPrestoClient prestoClient;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public StandaloneQueryRunner(Session defaultSession) throws Exception {
        Objects.requireNonNull(defaultSession, "defaultSession is null");
        try {
            this.server = StandaloneQueryRunner.createTestingPrestoServer();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
        this.prestoClient = new TestingPrestoClient(this.server, defaultSession);
        this.refreshNodes();
        this.server.getMetadata().addFunctions(AbstractTestQueries.CUSTOM_FUNCTIONS);
        SessionPropertyManager sessionPropertyManager = this.server.getMetadata().getSessionPropertyManager();
        sessionPropertyManager.addSystemSessionProperties(AbstractTestQueries.TEST_SYSTEM_PROPERTIES);
        sessionPropertyManager.addConnectorSessionProperties("catalog", AbstractTestQueries.TEST_CATALOG_PROPERTIES);
    }

    public MaterializedResult execute(@Language(value="SQL") String sql) {
        this.lock.readLock().lock();
        try {
            MaterializedResult materializedResult = (MaterializedResult)this.prestoClient.execute(sql);
            return materializedResult;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaterializedResult execute(Session session, @Language(value="SQL") String sql) {
        this.lock.readLock().lock();
        try {
            MaterializedResult materializedResult = (MaterializedResult)this.prestoClient.execute(session, sql);
            return materializedResult;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void close() {
        Closeables.closeQuietly((Closeable[])new Closeable[]{this.prestoClient});
        Closeables.closeQuietly((Closeable[])new Closeable[]{this.server});
    }

    public int getNodeCount() {
        return 1;
    }

    public Session getDefaultSession() {
        return this.prestoClient.getDefaultSession();
    }

    public TransactionManager getTransactionManager() {
        return this.server.getTransactionManager();
    }

    public Metadata getMetadata() {
        return this.server.getMetadata();
    }

    public TestingAccessControlManager getAccessControl() {
        return this.server.getAccessControl();
    }

    public TestingPrestoServer getServer() {
        return this.server;
    }

    public void refreshNodes() {
        AllNodes allNodes;
        do {
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        } while ((allNodes = this.server.refreshNodes()).getActiveNodes().isEmpty());
    }

    private void refreshNodes(ConnectorId connectorId) {
        Set activeNodesWithConnector;
        do {
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        } while ((activeNodesWithConnector = this.server.getActiveNodesWithConnector(connectorId)).isEmpty());
    }

    public void installPlugin(Plugin plugin) {
        this.server.installPlugin(plugin);
    }

    public void createCatalog(String catalogName, String connectorName) {
        this.createCatalog(catalogName, connectorName, (Map<String, String>)ImmutableMap.of());
    }

    public void createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        ConnectorId connectorId = this.server.createCatalog(catalogName, connectorName, properties);
        this.refreshNodes(connectorId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QualifiedObjectName> listTables(Session session, String catalog, String schema) {
        this.lock.readLock().lock();
        try {
            List<QualifiedObjectName> list = this.prestoClient.listTables(session, catalog, schema);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(Session session, String table) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.prestoClient.tableExists(session, table);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Lock getExclusiveLock() {
        return this.lock.writeLock();
    }

    private static TestingPrestoServer createTestingPrestoServer() throws Exception {
        ImmutableMap.Builder properties = ImmutableMap.builder().put((Object)"query.client.timeout", (Object)"10m").put((Object)"exchange.http-client.read-timeout", (Object)"1h").put((Object)"compiler.interpreter-enabled", (Object)"false").put((Object)"node-scheduler.min-candidates", (Object)"1").put((Object)"datasources", (Object)"system");
        return new TestingPrestoServer(true, (Map)properties.build(), null, null, new SqlParserOptions(), (List)ImmutableList.of());
    }
}

