/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.PlanOptimizers;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.testing.TestingAccessControlManager;
import com.facebook.presto.tests.H2QueryRunner;
import com.facebook.presto.tests.QueryAssertions;
import com.facebook.presto.transaction.TransactionBuilder;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.AfterClass;

public abstract class AbstractTestQueryFramework {
    protected final H2QueryRunner h2QueryRunner;
    protected final QueryRunner queryRunner;
    private final SqlParser sqlParser;

    protected AbstractTestQueryFramework(QueryRunner queryRunner) {
        this.queryRunner = queryRunner;
        this.h2QueryRunner = new H2QueryRunner();
        this.sqlParser = new SqlParser();
    }

    @AfterClass(alwaysRun=true)
    public void close() throws Exception {
        try {
            this.h2QueryRunner.close();
        }
        finally {
            this.queryRunner.close();
        }
    }

    protected Session getSession() {
        return this.queryRunner.getDefaultSession();
    }

    public final int getNodeCount() {
        return this.queryRunner.getNodeCount();
    }

    protected MaterializedResult computeActual(@Language(value="SQL") String sql) {
        return this.computeActual(this.getSession(), sql);
    }

    protected MaterializedResult computeActual(Session session, @Language(value="SQL") String sql) {
        return this.queryRunner.execute(session, sql).toJdbcTypes();
    }

    protected void assertQuery(@Language(value="SQL") String sql) throws Exception {
        this.assertQuery(this.getSession(), sql);
    }

    protected void assertQuery(Session session, @Language(value="SQL") String sql) throws Exception {
        QueryAssertions.assertQuery(this.queryRunner, session, sql, this.h2QueryRunner, sql, false, false);
    }

    public void assertQueryOrdered(@Language(value="SQL") String sql) throws Exception {
        QueryAssertions.assertQuery(this.queryRunner, this.getSession(), sql, this.h2QueryRunner, sql, true, false);
    }

    protected void assertQuery(@Language(value="SQL") String actual, @Language(value="SQL") String expected) throws Exception {
        QueryAssertions.assertQuery(this.queryRunner, this.getSession(), actual, this.h2QueryRunner, expected, false, false);
    }

    protected void assertQuery(Session session, @Language(value="SQL") String actual, @Language(value="SQL") String expected) throws Exception {
        QueryAssertions.assertQuery(this.queryRunner, session, actual, this.h2QueryRunner, expected, false, false);
    }

    protected void assertQueryOrdered(@Language(value="SQL") String actual, @Language(value="SQL") String expected) throws Exception {
        this.assertQueryOrdered(this.getSession(), actual, expected);
    }

    protected void assertQueryOrdered(Session session, @Language(value="SQL") String actual, @Language(value="SQL") String expected) throws Exception {
        QueryAssertions.assertQuery(this.queryRunner, session, actual, this.h2QueryRunner, expected, true, false);
    }

    protected void assertUpdate(@Language(value="SQL") String actual, @Language(value="SQL") String expected) throws Exception {
        this.assertUpdate(this.getSession(), actual, expected);
    }

    protected void assertUpdate(Session session, @Language(value="SQL") String actual, @Language(value="SQL") String expected) throws Exception {
        QueryAssertions.assertQuery(this.queryRunner, session, actual, this.h2QueryRunner, expected, false, true);
    }

    protected void assertUpdate(@Language(value="SQL") String sql) {
        this.assertUpdate(this.getSession(), sql);
    }

    protected void assertUpdate(Session session, @Language(value="SQL") String sql) {
        QueryAssertions.assertUpdate(this.queryRunner, session, sql, OptionalLong.empty());
    }

    protected void assertUpdate(@Language(value="SQL") String sql, long count) {
        this.assertUpdate(this.getSession(), sql, count);
    }

    protected void assertUpdate(Session session, @Language(value="SQL") String sql, long count) {
        QueryAssertions.assertUpdate(this.queryRunner, session, sql, OptionalLong.of(count));
    }

    protected void assertQueryFails(@Language(value="SQL") String sql, @Language(value="RegExp") String expectedMessageRegExp) {
        this.assertQueryFails(this.getSession(), sql, expectedMessageRegExp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertQueryFails(Session session, @Language(value="SQL") String sql, @Language(value="RegExp") String expectedMessageRegExp) {
        this.queryRunner.getExclusiveLock().lock();
        try {
            this.queryRunner.execute(session, sql);
            Assert.fail((String)String.format("Expected query to fail: %s", sql));
        }
        catch (RuntimeException ex) {
            AbstractTestQueryFramework.assertExceptionMessage(sql, ex, expectedMessageRegExp);
        }
        finally {
            this.queryRunner.getExclusiveLock().unlock();
        }
    }

    public void assertApproximateQuery(Session session, @Language(value="SQL") String actual, @Language(value="SQL") String expected) throws Exception {
        QueryAssertions.assertApproximateQuery(this.queryRunner, session, actual, this.h2QueryRunner, expected);
    }

    protected void assertAccessAllowed(@Language(value="SQL") String sql, TestingAccessControlManager.TestingPrivilege ... deniedPrivileges) throws Exception {
        this.assertAccessAllowed(this.getSession(), sql, deniedPrivileges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertAccessAllowed(Session session, @Language(value="SQL") String sql, TestingAccessControlManager.TestingPrivilege ... deniedPrivileges) throws Exception {
        this.queryRunner.getExclusiveLock().lock();
        try {
            this.queryRunner.getAccessControl().deny(deniedPrivileges);
            this.queryRunner.execute(session, sql);
        }
        finally {
            this.queryRunner.getAccessControl().reset();
            this.queryRunner.getExclusiveLock().unlock();
        }
    }

    protected void assertAccessDenied(@Language(value="SQL") String sql, @Language(value="RegExp") String exceptionsMessageRegExp, TestingAccessControlManager.TestingPrivilege ... deniedPrivileges) throws Exception {
        this.assertAccessDenied(this.getSession(), sql, exceptionsMessageRegExp, deniedPrivileges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertAccessDenied(Session session, @Language(value="SQL") String sql, @Language(value="RegExp") String exceptionsMessageRegExp, TestingAccessControlManager.TestingPrivilege ... deniedPrivileges) throws Exception {
        this.queryRunner.getExclusiveLock().lock();
        try {
            this.queryRunner.getAccessControl().deny(deniedPrivileges);
            this.queryRunner.execute(session, sql);
            Assert.fail((String)("Expected " + AccessDeniedException.class.getSimpleName()));
        }
        catch (RuntimeException e) {
            AbstractTestQueryFramework.assertExceptionMessage(sql, e, ".*Access Denied: " + exceptionsMessageRegExp);
        }
        finally {
            this.queryRunner.getAccessControl().reset();
            this.queryRunner.getExclusiveLock().unlock();
        }
    }

    protected void assertTableColumnNames(String tableName, String ... columnNames) {
        MaterializedResult result = this.computeActual("DESCRIBE " + tableName);
        ImmutableList expected = ImmutableList.copyOf((Object[])columnNames);
        List actual = (List)result.getMaterializedRows().stream().map(row -> (String)row.getField(0)).collect(ImmutableCollectors.toImmutableList());
        Assert.assertEquals((Collection)actual, (Collection)expected);
    }

    private static void assertExceptionMessage(String sql, Exception exception, @Language(value="RegExp") String regex) {
        if (!exception.getMessage().matches(regex)) {
            Assert.fail((String)String.format("Expected exception message '%s' to match '%s' for query: %s", exception.getMessage(), regex, sql));
        }
    }

    protected MaterializedResult computeExpected(@Language(value="SQL") String sql, List<? extends Type> resultTypes) {
        return this.h2QueryRunner.execute(this.getSession(), sql, resultTypes);
    }

    protected String formatSqlText(String sql) {
        return SqlFormatter.formatSql((Node)this.sqlParser.createStatement(sql), Optional.empty());
    }

    public String getExplainPlan(String query, ExplainType.Type planType) {
        QueryExplainer explainer = this.getQueryExplainer();
        return (String)TransactionBuilder.transaction((TransactionManager)this.queryRunner.getTransactionManager()).singleStatement().execute(this.queryRunner.getDefaultSession(), session -> explainer.getPlan(session, this.sqlParser.createStatement(query), planType, Collections.emptyList()));
    }

    public String getGraphvizExplainPlan(String query, ExplainType.Type planType) {
        QueryExplainer explainer = this.getQueryExplainer();
        return (String)TransactionBuilder.transaction((TransactionManager)this.queryRunner.getTransactionManager()).singleStatement().execute(this.queryRunner.getDefaultSession(), session -> explainer.getGraphvizPlan(session, this.sqlParser.createStatement(query), planType, Collections.emptyList()));
    }

    private QueryExplainer getQueryExplainer() {
        Metadata metadata = this.queryRunner.getMetadata();
        FeaturesConfig featuresConfig = new FeaturesConfig().setExperimentalSyntaxEnabled(true).setOptimizeHashGeneration(true);
        boolean forceSingleNode = this.queryRunner.getNodeCount() == 1;
        List optimizers = new PlanOptimizers(metadata, this.sqlParser, featuresConfig, forceSingleNode).get();
        return new QueryExplainer(optimizers, metadata, (AccessControl)this.queryRunner.getAccessControl(), this.sqlParser, (Map)ImmutableMap.of(), featuresConfig.isExperimentalSyntaxEnabled());
    }
}

