/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.testing.TestingAccessControlManager;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.facebook.presto.tests.QueryAssertions;
import com.google.common.collect.ImmutableList;
import io.airlift.testing.Assertions;
import java.util.Objects;
import java.util.Optional;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AbstractTestIntegrationSmokeTest
extends AbstractTestQueryFramework {
    private final Optional<Session> sampledSession;

    protected AbstractTestIntegrationSmokeTest(QueryRunner queryRunner) {
        this(queryRunner, Optional.empty());
    }

    protected AbstractTestIntegrationSmokeTest(QueryRunner queryRunner, Session sampledSession) {
        this(queryRunner, Optional.of(Objects.requireNonNull(sampledSession, "sampledSession is null")));
    }

    private AbstractTestIntegrationSmokeTest(QueryRunner queryRunner, Optional<Session> sampledSession) {
        super(queryRunner);
        this.sampledSession = Objects.requireNonNull(sampledSession, "sampledSession is null");
    }

    @Test
    public void testAggregateSingleColumn() throws Exception {
        this.assertQuery("SELECT SUM(orderkey) FROM ORDERS");
        this.assertQuery("SELECT SUM(totalprice) FROM ORDERS");
        this.assertQuery("SELECT MAX(comment) FROM ORDERS");
    }

    @Test
    public void testApproximateQuerySum() throws Exception {
        this.assertApproximateQuery("SELECT SUM(totalprice) FROM orders APPROXIMATE AT 99.999 CONFIDENCE", "SELECT 2 * SUM(totalprice) FROM orders");
    }

    @Test
    public void testColumnsInReverseOrder() throws Exception {
        this.assertQuery("SELECT shippriority, clerk, totalprice FROM ORDERS");
    }

    @Test
    public void testCountAll() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM ORDERS");
    }

    @Test
    public void testExactPredicate() throws Exception {
        this.assertQuery("SELECT * FROM ORDERS WHERE orderkey = 10");
    }

    @Test
    public void testInListPredicate() throws Exception {
        this.assertQuery("SELECT * FROM ORDERS WHERE orderkey IN (10, 11, 20, 21)");
    }

    @Test
    public void testIsNullPredicate() throws Exception {
        this.assertQuery("SELECT * FROM ORDERS WHERE orderkey = 10 OR orderkey IS NULL");
    }

    @Test
    public void testMultipleRangesPredicate() throws Exception {
        this.assertQuery("SELECT * FROM ORDERS WHERE orderkey BETWEEN 10 AND 50 or orderkey BETWEEN 100 AND 150");
    }

    @Test
    public void testRangePredicate() throws Exception {
        this.assertQuery("SELECT * FROM ORDERS WHERE orderkey BETWEEN 10 AND 50");
    }

    @Test
    public void testSelectAll() throws Exception {
        this.assertQuery("SELECT * FROM ORDERS");
    }

    @Test
    public void testTableSampleSystem() throws Exception {
        if (!this.sampledSession.isPresent()) {
            return;
        }
        int total = this.computeActual("SELECT orderkey FROM orders").getMaterializedRows().size();
        boolean sampleSizeFound = false;
        for (int i = 0; i < 100; ++i) {
            int sampleSize = this.computeActual("SELECT orderkey FROM ORDERS TABLESAMPLE SYSTEM (50)").getMaterializedRows().size();
            if (sampleSize <= 0 || sampleSize >= total) continue;
            sampleSizeFound = true;
            break;
        }
        Assert.assertTrue((boolean)sampleSizeFound, (String)"Table sample returned unexpected number of rows");
    }

    @Test
    public void testShowSchemas() throws Exception {
        MaterializedResult actualSchemas = this.computeActual("SHOW SCHEMAS").toJdbcTypes();
        MaterializedResult.Builder resultBuilder = MaterializedResult.resultBuilder((Session)this.queryRunner.getDefaultSession(), (Type[])new Type[]{VarcharType.VARCHAR}).row(new Object[]{"tpch"});
        if (this.sampledSession.isPresent()) {
            resultBuilder.row(new Object[]{"tpch_sampled"});
        }
        QueryAssertions.assertContains(actualSchemas, resultBuilder.build());
    }

    @Test
    public void testShowTables() throws Exception {
        MaterializedResult actualTables = this.computeActual("SHOW TABLES").toJdbcTypes();
        MaterializedResult expectedTables = MaterializedResult.resultBuilder((Session)this.queryRunner.getDefaultSession(), (Type[])new Type[]{VarcharType.VARCHAR}).row(new Object[]{"orders"}).build();
        QueryAssertions.assertContains(actualTables, expectedTables);
    }

    @Test
    public void testDescribeTable() throws Exception {
        MaterializedResult actualColumns = this.computeActual("DESC ORDERS").toJdbcTypes();
        ImmutableList expectedColumnsPossibilities = ImmutableList.of((Object)this.getExpectedTableDescription(true, true), (Object)this.getExpectedTableDescription(true, false), (Object)this.getExpectedTableDescription(false, true), (Object)this.getExpectedTableDescription(false, false));
        Assert.assertTrue((boolean)expectedColumnsPossibilities.contains(actualColumns), (String)String.format("%s not in %s", actualColumns, expectedColumnsPossibilities));
    }

    @Test
    public void testNonQueryAccessControl() throws Exception {
        this.assertAccessDenied("SET SESSION query_max_memory = '10MB'", "Cannot set system session property query_max_memory", TestingAccessControlManager.privilege((String)"query_max_memory", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SET_SESSION));
        this.assertAccessDenied("CREATE TABLE foo (pk bigint)", "Cannot create table .*.foo.*", TestingAccessControlManager.privilege((String)"foo", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_TABLE));
        this.assertAccessDenied("DROP TABLE orders", "Cannot drop table .*.orders.*", TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.DROP_TABLE));
        this.assertAccessDenied("ALTER TABLE orders RENAME TO foo", "Cannot rename table .*.orders.* to .*.foo.*", TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.RENAME_TABLE));
        this.assertAccessDenied("ALTER TABLE orders ADD COLUMN foo bigint", "Cannot add a column to table .*.orders.*", TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.ADD_COLUMN));
        this.assertAccessDenied("ALTER TABLE orders RENAME COLUMN orderkey TO foo", "Cannot rename a column in table .*.orders.*", TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.RENAME_COLUMN));
        this.assertAccessDenied("CREATE VIEW foo as SELECT * FROM orders", "Cannot create view .*.foo.*", TestingAccessControlManager.privilege((String)"foo", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW));
        try {
            this.assertAccessDenied("SELECT 1", "Principal .* cannot become user " + this.getSession().getUser() + ".*", TestingAccessControlManager.privilege((String)this.getSession().getUser(), (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SET_USER));
        }
        catch (AssertionError e) {
            Assertions.assertContains((String)((Throwable)((Object)e)).getMessage(), (String)"statusCode=403");
        }
    }

    @Test
    public void testViewAccessControl() throws Exception {
        Session viewOwnerSession = TestingSession.testSessionBuilder().setIdentity(new Identity("test_view_access_owner", Optional.empty())).setCatalog((String)this.getSession().getCatalog().get()).setSchema((String)this.getSession().getSchema().get()).build();
        this.assertAccessDenied(viewOwnerSession, "CREATE VIEW test_view_access AS SELECT * FROM orders", "Cannot select from table .*.orders.*", TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_TABLE));
        this.assertAccessAllowed(viewOwnerSession, "CREATE VIEW test_view_access AS SELECT * FROM orders", TestingAccessControlManager.privilege((String)"bogus", (String)"bogus privilege to disable security", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_TABLE));
        this.assertAccessDenied("SELECT * FROM test_view_access", "Cannot select from table .*.orders.*", TestingAccessControlManager.privilege((String)viewOwnerSession.getUser(), (String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_TABLE));
        this.assertAccessAllowed("SELECT * FROM test_view_access", TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_TABLE));
        this.assertAccessAllowed("SELECT * FROM test_view_access", TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_TABLE));
        Session nestedViewOwnerSession = TestingSession.testSessionBuilder().setIdentity(new Identity("test_nested_view_access_owner", Optional.empty())).setCatalog((String)this.getSession().getCatalog().get()).setSchema((String)this.getSession().getSchema().get()).build();
        this.assertAccessDenied(nestedViewOwnerSession, "CREATE VIEW test_nested_view_access AS SELECT * FROM test_view_access", "Cannot select from view .*.test_view_access.*", TestingAccessControlManager.privilege((String)"test_view_access", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_VIEW));
        this.assertAccessAllowed(nestedViewOwnerSession, "CREATE VIEW test_nested_view_access AS SELECT * FROM test_view_access", TestingAccessControlManager.privilege((String)"bogus", (String)"bogus privilege to disable security", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_TABLE));
        this.assertAccessDenied("SELECT * FROM test_nested_view_access", "Cannot select from view .*.test_view_access.*", TestingAccessControlManager.privilege((String)nestedViewOwnerSession.getUser(), (String)"test_view_access", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_VIEW));
        this.assertAccessAllowed("SELECT * FROM test_nested_view_access", TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)"test_view_access", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_VIEW));
        this.assertAccessAllowed("SELECT * FROM test_nested_view_access", TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)"test_view_access", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_VIEW));
        this.assertAccessAllowed(nestedViewOwnerSession, "DROP VIEW test_nested_view_access", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessAllowed(viewOwnerSession, "DROP VIEW test_view_access", new TestingAccessControlManager.TestingPrivilege[0]);
    }

    private MaterializedResult getExpectedTableDescription(boolean dateSupported, boolean parametrizedVarchar) {
        String orderDateType = dateSupported ? "date" : "varchar";
        if (parametrizedVarchar) {
            return MaterializedResult.resultBuilder((Session)this.queryRunner.getDefaultSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", ""}).row(new Object[]{"custkey", "bigint", ""}).row(new Object[]{"orderstatus", "varchar", ""}).row(new Object[]{"totalprice", "double", ""}).row(new Object[]{"orderdate", orderDateType, ""}).row(new Object[]{"orderpriority", "varchar", ""}).row(new Object[]{"clerk", "varchar", ""}).row(new Object[]{"shippriority", "integer", ""}).row(new Object[]{"comment", "varchar", ""}).build();
        }
        return MaterializedResult.resultBuilder((Session)this.queryRunner.getDefaultSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", ""}).row(new Object[]{"custkey", "bigint", ""}).row(new Object[]{"orderstatus", "varchar(1)", ""}).row(new Object[]{"totalprice", "double", ""}).row(new Object[]{"orderdate", orderDateType, ""}).row(new Object[]{"orderpriority", "varchar(15)", ""}).row(new Object[]{"clerk", "varchar(15)", ""}).row(new Object[]{"shippriority", "integer", ""}).row(new Object[]{"comment", "varchar(79)", ""}).build();
    }

    protected void assertApproximateQuery(@Language(value="SQL") String actual, @Language(value="SQL") String expected) throws Exception {
        if (this.sampledSession.isPresent()) {
            this.assertApproximateQuery(this.sampledSession.get(), actual, expected);
        }
    }
}

