/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.procedure.Procedure;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.testing.ProcedureTester;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class TestingProcedures {
    private final ProcedureTester tester;
    private final TypeManager typeManager;

    public TestingProcedures(ProcedureTester tester, TypeManager typeManager) {
        this.tester = Objects.requireNonNull(tester, "tester is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    @UsedByGeneratedCode
    public void simple() {
        this.tester.recordCalled("simple", new Object[0]);
    }

    @UsedByGeneratedCode
    public void args(long x, double y, String z, boolean q) {
        this.tester.recordCalled("args", new Object[]{x, y, z, q});
    }

    @UsedByGeneratedCode
    public void nulls(Long x, String y) {
        this.tester.recordCalled("nulls", new Object[]{x, y});
    }

    @UsedByGeneratedCode
    public void arrays(List<Long> x, List<String> y) {
        this.tester.recordCalled("arrays", new Object[]{x, y});
    }

    @UsedByGeneratedCode
    public void nested(List<List<Long>> x) {
        this.tester.recordCalled("nested", new Object[]{x});
    }

    @UsedByGeneratedCode
    public void sessionFirst(ConnectorSession session, long x) {
        Objects.requireNonNull(session, "session is null");
        this.tester.recordCalled("session_first", new Object[]{x});
    }

    @UsedByGeneratedCode
    public void sessionLast(String x, ConnectorSession session) {
        Objects.requireNonNull(session, "session is null");
        this.tester.recordCalled("session_last", new Object[]{x});
    }

    @UsedByGeneratedCode
    public void exception() {
        this.tester.recordCalled("exception", new Object[0]);
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "test exception from procedure");
    }

    @UsedByGeneratedCode
    public void error() {
        this.tester.recordCalled("error", new Object[0]);
        throw new RuntimeException("test error from procedure");
    }

    public List<Procedure> getProcedures(String schema) {
        return ImmutableList.builder().add((Object)this.procedure(schema, "test_simple", "simple", (List<Procedure.Argument>)ImmutableList.of())).add((Object)this.procedure(schema, "test_args", "args", (List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("x", (Type)BigintType.BIGINT), (Object)new Procedure.Argument("y", (Type)DoubleType.DOUBLE), (Object)new Procedure.Argument("z", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("q", (Type)BooleanType.BOOLEAN)))).add((Object)this.procedure(schema, "test_nulls", "nulls", (List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("x", (Type)BigintType.BIGINT), (Object)new Procedure.Argument("y", (Type)VarcharType.VARCHAR)))).add((Object)this.procedure(schema, "test_arrays", "arrays", (List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("x", this.arrayType((Type)BigintType.BIGINT)), (Object)new Procedure.Argument("y", this.arrayType((Type)VarcharType.VARCHAR))))).add((Object)this.procedure(schema, "test_nested", "nested", (List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("x", this.arrayType(this.arrayType((Type)BigintType.BIGINT)))))).add((Object)this.procedure(schema, "test_session_first", "sessionFirst", (List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("x", (Type)BigintType.BIGINT)))).add((Object)this.procedure(schema, "test_session_last", "sessionLast", (List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("x", (Type)VarcharType.VARCHAR)))).add((Object)this.procedure(schema, "test_exception", "exception", (List<Procedure.Argument>)ImmutableList.of())).add((Object)this.procedure(schema, "test_error", "error", (List<Procedure.Argument>)ImmutableList.of())).build();
    }

    private Type arrayType(Type elementType) {
        return this.typeManager.getParameterizedType("array", (List)ImmutableList.of((Object)elementType.getTypeSignature()), (List)ImmutableList.of());
    }

    private Procedure procedure(String schema, String name, String methodName, List<Procedure.Argument> arguments) {
        return new Procedure(schema, name, arguments, this.handle(methodName));
    }

    private MethodHandle handle(String name) {
        List methods = Arrays.asList(this.getClass().getMethods()).stream().filter(method -> method.getName().equals(name)).collect(Collectors.toList());
        Preconditions.checkArgument((!methods.isEmpty() ? 1 : 0) != 0, (String)"no matching methods: %s", (Object[])new Object[]{name});
        Preconditions.checkArgument((methods.size() == 1 ? 1 : 0) != 0, (String)"multiple matching methods: %s", (Object[])new Object[]{methods});
        Method method2 = (Method)methods.get(0);
        try {
            return MethodHandles.lookup().unreflect(method2).bindTo(this);
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

