/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.server.testing.TestingPrestoServer;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateTimeEncoding;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.tests.AbstractTestingPrestoClient;
import com.facebook.presto.tests.ResultsSession;
import com.facebook.presto.util.DateTimeUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.log.Logger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class TestingPrestoClient
extends AbstractTestingPrestoClient<MaterializedResult> {
    private static final Logger log = Logger.get((String)"TestQueries");

    public TestingPrestoClient(TestingPrestoServer prestoServer, Session defaultSession) {
        super(prestoServer, defaultSession);
    }

    @Override
    protected ResultsSession<MaterializedResult> getResultSession(Session session) {
        return new MaterializedResultSession(session);
    }

    private static Function<List<Object>, MaterializedRow> dataToRow(TimeZoneKey timeZoneKey, List<Type> types) {
        return data -> {
            Preconditions.checkArgument((data.size() == types.size() ? 1 : 0) != 0, (Object)"columns size does not match types size");
            ArrayList row = new ArrayList();
            for (int i = 0; i < data.size(); ++i) {
                Object value = data.get(i);
                if (value == null) {
                    row.add(null);
                    continue;
                }
                Type type = (Type)types.get(i);
                if (BooleanType.BOOLEAN.equals((Object)type)) {
                    row.add(value);
                    continue;
                }
                if (BigintType.BIGINT.equals((Object)type)) {
                    row.add(((Number)value).longValue());
                    continue;
                }
                if (DoubleType.DOUBLE.equals((Object)type)) {
                    row.add(((Number)value).doubleValue());
                    continue;
                }
                if (VarcharType.VARCHAR.equals((Object)type)) {
                    row.add(value);
                    continue;
                }
                if (VarbinaryType.VARBINARY.equals((Object)type)) {
                    row.add(value);
                    continue;
                }
                if (DateType.DATE.equals((Object)type)) {
                    int days = DateTimeUtils.parseDate((String)((String)value));
                    row.add(new Date(TimeUnit.DAYS.toMillis(days)));
                    continue;
                }
                if (TimeType.TIME.equals((Object)type)) {
                    row.add(new Time(DateTimeUtils.parseTime((TimeZoneKey)timeZoneKey, (String)((String)value))));
                    continue;
                }
                if (TimeWithTimeZoneType.TIME_WITH_TIME_ZONE.equals((Object)type)) {
                    row.add(new Time(DateTimeEncoding.unpackMillisUtc((long)DateTimeUtils.parseTimeWithTimeZone((String)((String)value)))));
                    continue;
                }
                if (TimestampType.TIMESTAMP.equals((Object)type)) {
                    row.add(new Timestamp(DateTimeUtils.parseTimestampWithoutTimeZone((TimeZoneKey)timeZoneKey, (String)((String)value))));
                    continue;
                }
                if (TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE.equals((Object)type)) {
                    row.add(new Timestamp(DateTimeEncoding.unpackMillisUtc((long)DateTimeUtils.parseTimestampWithTimeZone((TimeZoneKey)timeZoneKey, (String)((String)value)))));
                    continue;
                }
                throw new AssertionError((Object)("unhandled type: " + type));
            }
            return new MaterializedRow(5, row);
        };
    }

    private class MaterializedResultSession
    implements ResultsSession<MaterializedResult> {
        private final ImmutableList.Builder<MaterializedRow> rows = ImmutableList.builder();
        private final AtomicBoolean loggedUri = new AtomicBoolean(false);
        private final AtomicReference<List<Type>> types = new AtomicReference();
        private final AtomicReference<Optional<String>> updateType = new AtomicReference(Optional.empty());
        private final AtomicReference<OptionalLong> updateCount = new AtomicReference<OptionalLong>(OptionalLong.empty());
        private final TimeZoneKey timeZoneKey;

        private MaterializedResultSession(Session session) {
            this.timeZoneKey = session.getTimeZoneKey();
        }

        @Override
        public void setUpdateType(String type) {
            this.updateType.set(Optional.of(Objects.requireNonNull("update type is null")));
        }

        @Override
        public void setUpdateCount(long count) {
            this.updateCount.set(OptionalLong.of(count));
        }

        @Override
        public void addResults(QueryResults results) {
            if (!this.loggedUri.getAndSet(true)) {
                log.info("Query %s: %s?pretty", new Object[]{results.getId(), results.getInfoUri()});
            }
            if (this.types.get() == null && results.getColumns() != null) {
                this.types.set(TestingPrestoClient.this.getTypes(results.getColumns()));
            }
            if (results.getData() != null) {
                Preconditions.checkState((this.types.get() != null ? 1 : 0) != 0, (Object)"data received without types");
                this.rows.addAll(Iterables.transform((Iterable)results.getData(), (Function)TestingPrestoClient.dataToRow(this.timeZoneKey, this.types.get())));
            }
        }

        @Override
        public MaterializedResult build(Map<String, String> setSessionProperties, Set<String> resetSessionProperties) {
            Preconditions.checkState((this.types.get() != null ? 1 : 0) != 0, (Object)"never received types for the query");
            return new MaterializedResult((List)this.rows.build(), this.types.get(), setSessionProperties, resetSessionProperties, this.updateType.get(), this.updateCount.get());
        }
    }
}

