/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestApproximateQueries;
import com.facebook.presto.tests.QueryAssertions;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AbstractTestDistributedQueries
extends AbstractTestApproximateQueries {
    protected AbstractTestDistributedQueries(QueryRunner queryRunner) {
        super(queryRunner);
    }

    protected AbstractTestDistributedQueries(QueryRunner queryRunner, Session sampledSession) {
        super(queryRunner, sampledSession);
    }

    @Test
    public void testSetSession() throws Exception {
        MaterializedResult result = this.computeActual("SET SESSION test_string = 'bar'");
        Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Map)result.getSetSessionProperties(), (Map)ImmutableMap.of((Object)"test_string", (Object)"bar"));
        result = this.computeActual("SET SESSION connector.connector_long = 999");
        Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Map)result.getSetSessionProperties(), (Map)ImmutableMap.of((Object)"connector.connector_long", (Object)"999"));
        result = this.computeActual("SET SESSION connector.connector_string = 'baz'");
        Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Map)result.getSetSessionProperties(), (Map)ImmutableMap.of((Object)"connector.connector_string", (Object)"baz"));
        result = this.computeActual("SET SESSION connector.connector_string = 'ban' || 'ana'");
        Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Map)result.getSetSessionProperties(), (Map)ImmutableMap.of((Object)"connector.connector_string", (Object)"banana"));
        result = this.computeActual("SET SESSION connector.connector_long = 444");
        Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Map)result.getSetSessionProperties(), (Map)ImmutableMap.of((Object)"connector.connector_long", (Object)"444"));
        result = this.computeActual("SET SESSION connector.connector_long = 111 + 111");
        Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Map)result.getSetSessionProperties(), (Map)ImmutableMap.of((Object)"connector.connector_long", (Object)"222"));
        result = this.computeActual("SET SESSION connector.connector_boolean = 111 < 3");
        Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Map)result.getSetSessionProperties(), (Map)ImmutableMap.of((Object)"connector.connector_boolean", (Object)"false"));
        result = this.computeActual("SET SESSION connector.connector_double = 11.1");
        Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Map)result.getSetSessionProperties(), (Map)ImmutableMap.of((Object)"connector.connector_double", (Object)"11.1"));
    }

    @Test
    public void testResetSession() throws Exception {
        MaterializedResult result = this.computeActual(this.getSession(), "RESET SESSION test_string");
        Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Set)result.getResetSessionProperties(), (Set)ImmutableSet.of((Object)"test_string"));
        result = this.computeActual(this.getSession(), "RESET SESSION connector.connector_string");
        Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Set)result.getResetSessionProperties(), (Set)ImmutableSet.of((Object)"connector.connector_string"));
    }

    @Test
    public void testCreateTable() throws Exception {
        this.assertUpdate("CREATE TABLE test_create (a bigint, b double, c varchar)");
        Assert.assertTrue((boolean)this.queryRunner.tableExists(this.getSession(), "test_create"));
        this.assertTableColumnNames("test_create", "a", "b", "c");
        this.assertUpdate("DROP TABLE test_create");
        Assert.assertFalse((boolean)this.queryRunner.tableExists(this.getSession(), "test_create"));
        this.assertUpdate("CREATE TABLE test_create_table_if_not_exists (a bigint, b varchar, c double)");
        Assert.assertTrue((boolean)this.queryRunner.tableExists(this.getSession(), "test_create_table_if_not_exists"));
        this.assertTableColumnNames("test_create_table_if_not_exists", "a", "b", "c");
        this.assertUpdate("CREATE TABLE IF NOT EXISTS test_create_table_if_not_exists (d bigint, e varchar)");
        Assert.assertTrue((boolean)this.queryRunner.tableExists(this.getSession(), "test_create_table_if_not_exists"));
        this.assertTableColumnNames("test_create_table_if_not_exists", "a", "b", "c");
        this.assertUpdate("DROP TABLE test_create_table_if_not_exists");
        Assert.assertFalse((boolean)this.queryRunner.tableExists(this.getSession(), "test_create_table_if_not_exists"));
    }

    @Test
    public void testCreateTableAsSelect() throws Exception {
        this.assertCreateTableAsSelect("test_select", "SELECT orderdate, orderkey, totalprice FROM orders", "SELECT count(*) FROM orders");
        this.assertCreateTableAsSelect("test_group", "SELECT orderstatus, sum(totalprice) x FROM orders GROUP BY orderstatus", "SELECT count(DISTINCT orderstatus) FROM orders");
        this.assertCreateTableAsSelect("test_join", "SELECT count(*) x FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey", "SELECT 1");
        this.assertCreateTableAsSelect("test_limit", "SELECT orderkey FROM orders ORDER BY orderkey LIMIT 10", "SELECT 10");
        this.assertCreateTableAsSelect("test_unicode", "SELECT '\u2603' unicode", "SELECT 1");
        this.assertCreateTableAsSelect("test_with_data", "SELECT * FROM orders WITH DATA", "SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertCreateTableAsSelect("test_with_no_data", "SELECT * FROM orders WITH NO DATA", "SELECT * FROM orders LIMIT 0", "SELECT 0");
        this.assertCreateTableAsSelect("test_sampled", "SELECT orderkey FROM tpch_sampled.tiny.orders ORDER BY orderkey LIMIT 10", "SELECT orderkey FROM orders ORDER BY orderkey LIMIT 10", "SELECT 10");
        this.assertCreateTableAsSelect("test_union_all", "SELECT orderdate, orderkey, totalprice FROM orders WHERE orderkey % 2 = 0 UNION ALL SELECT orderdate, orderkey, totalprice FROM orders WHERE orderkey % 2 = 1", "SELECT orderdate, orderkey, totalprice FROM orders", "SELECT count(*) FROM orders");
        this.assertCreateTableAsSelect(this.getSession().withSystemProperty("redistribute_writes", "true"), "test_union_all", "SELECT orderdate, orderkey, totalprice FROM orders UNION ALL SELECT DATE '2000-01-01', 1234567890, 1.23", "SELECT orderdate, orderkey, totalprice FROM orders UNION ALL SELECT DATE '2000-01-01', 1234567890, 1.23", "SELECT count(*) + 1 FROM orders");
        this.assertCreateTableAsSelect(this.getSession().withSystemProperty("redistribute_writes", "false"), "test_union_all", "SELECT orderdate, orderkey, totalprice FROM orders UNION ALL SELECT DATE '2000-01-01', 1234567890, 1.23", "SELECT orderdate, orderkey, totalprice FROM orders UNION ALL SELECT DATE '2000-01-01', 1234567890, 1.23", "SELECT count(*) + 1 FROM orders");
    }

    private void assertCreateTableAsSelect(String table, @Language(value="SQL") String query, @Language(value="SQL") String rowCountQuery) throws Exception {
        this.assertCreateTableAsSelect(this.getSession(), table, query, query, rowCountQuery);
    }

    private void assertCreateTableAsSelect(String table, @Language(value="SQL") String query, @Language(value="SQL") String expectedQuery, @Language(value="SQL") String rowCountQuery) throws Exception {
        this.assertCreateTableAsSelect(this.getSession(), table, query, expectedQuery, rowCountQuery);
    }

    private void assertCreateTableAsSelect(Session session, String table, @Language(value="SQL") String query, @Language(value="SQL") String expectedQuery, @Language(value="SQL") String rowCountQuery) throws Exception {
        this.assertUpdate(session, "CREATE TABLE " + table + " AS " + query, rowCountQuery);
        this.assertQuery(session, "SELECT * FROM " + table, expectedQuery);
        this.assertUpdate(session, "DROP TABLE " + table);
        Assert.assertFalse((boolean)this.queryRunner.tableExists(session, table));
    }

    @Test
    public void testRenameTable() throws Exception {
        this.assertUpdate("CREATE TABLE test_rename AS SELECT 123 x", 1L);
        this.assertUpdate("ALTER TABLE test_rename RENAME TO test_rename_new");
        MaterializedResult materializedRows = this.computeActual("SELECT x FROM test_rename_new");
        Assert.assertEquals((Object)((MaterializedRow)Iterables.getOnlyElement((Iterable)materializedRows.getMaterializedRows())).getField(0), (Object)123L);
        this.assertUpdate("ALTER TABLE test_rename_new RENAME TO TEST_RENAME");
        materializedRows = this.computeActual("SELECT x FROM test_rename");
        Assert.assertEquals((Object)((MaterializedRow)Iterables.getOnlyElement((Iterable)materializedRows.getMaterializedRows())).getField(0), (Object)123L);
        this.assertUpdate("DROP TABLE test_rename");
        Assert.assertFalse((boolean)this.queryRunner.tableExists(this.getSession(), "test_rename"));
        Assert.assertFalse((boolean)this.queryRunner.tableExists(this.getSession(), "test_rename_new"));
    }

    @Test
    public void testRenameColumn() throws Exception {
        this.assertUpdate("CREATE TABLE test_rename_column AS SELECT 123 x", 1L);
        this.assertUpdate("ALTER TABLE test_rename_column RENAME COLUMN x TO y");
        MaterializedResult materializedRows = this.computeActual("SELECT y FROM test_rename_column");
        Assert.assertEquals((Object)((MaterializedRow)Iterables.getOnlyElement((Iterable)materializedRows.getMaterializedRows())).getField(0), (Object)123L);
        this.assertUpdate("ALTER TABLE test_rename_column RENAME COLUMN y TO Z");
        materializedRows = this.computeActual("SELECT z FROM test_rename_column");
        Assert.assertEquals((Object)((MaterializedRow)Iterables.getOnlyElement((Iterable)materializedRows.getMaterializedRows())).getField(0), (Object)123L);
        this.assertUpdate("DROP TABLE test_rename_column");
        Assert.assertFalse((boolean)this.queryRunner.tableExists(this.getSession(), "test_rename_column"));
    }

    @Test
    public void testAddColumn() throws Exception {
        this.assertUpdate("CREATE TABLE test_add_column AS SELECT 123 x", 1L);
        this.assertUpdate("CREATE TABLE test_add_column_a AS SELECT 234 x, 111 a", 1L);
        this.assertUpdate("CREATE TABLE test_add_column_ab AS SELECT 345 x, 222 a, 33.3 b", 1L);
        this.assertUpdate("ALTER TABLE test_add_column ADD COLUMN a bigint");
        this.assertUpdate("INSERT INTO test_add_column SELECT * FROM test_add_column_a", 1L);
        MaterializedResult materializedRows = this.computeActual("SELECT x, a FROM test_add_column ORDER BY x");
        Assert.assertEquals((Object)((MaterializedRow)materializedRows.getMaterializedRows().get(0)).getField(0), (Object)123L);
        Assert.assertEquals((Object)((MaterializedRow)materializedRows.getMaterializedRows().get(0)).getField(1), null);
        Assert.assertEquals((Object)((MaterializedRow)materializedRows.getMaterializedRows().get(1)).getField(0), (Object)234L);
        Assert.assertEquals((Object)((MaterializedRow)materializedRows.getMaterializedRows().get(1)).getField(1), (Object)111L);
        this.assertUpdate("ALTER TABLE test_add_column ADD COLUMN b double");
        this.assertUpdate("INSERT INTO test_add_column SELECT * FROM test_add_column_ab", 1L);
        materializedRows = this.computeActual("SELECT x, a, b FROM test_add_column ORDER BY x");
        Assert.assertEquals((Object)((MaterializedRow)materializedRows.getMaterializedRows().get(0)).getField(0), (Object)123L);
        Assert.assertEquals((Object)((MaterializedRow)materializedRows.getMaterializedRows().get(0)).getField(1), null);
        Assert.assertEquals((Object)((MaterializedRow)materializedRows.getMaterializedRows().get(0)).getField(2), null);
        Assert.assertEquals((Object)((MaterializedRow)materializedRows.getMaterializedRows().get(1)).getField(0), (Object)234L);
        Assert.assertEquals((Object)((MaterializedRow)materializedRows.getMaterializedRows().get(1)).getField(1), (Object)111L);
        Assert.assertEquals((Object)((MaterializedRow)materializedRows.getMaterializedRows().get(1)).getField(2), null);
        Assert.assertEquals((Object)((MaterializedRow)materializedRows.getMaterializedRows().get(2)).getField(0), (Object)345L);
        Assert.assertEquals((Object)((MaterializedRow)materializedRows.getMaterializedRows().get(2)).getField(1), (Object)222L);
        Assert.assertEquals((Object)((MaterializedRow)materializedRows.getMaterializedRows().get(2)).getField(2), (Object)33.3);
        this.assertUpdate("DROP TABLE test_add_column");
        this.assertUpdate("DROP TABLE test_add_column_a");
        this.assertUpdate("DROP TABLE test_add_column_ab");
        Assert.assertFalse((boolean)this.queryRunner.tableExists(this.getSession(), "test_add_column"));
        Assert.assertFalse((boolean)this.queryRunner.tableExists(this.getSession(), "test_add_column_a"));
        Assert.assertFalse((boolean)this.queryRunner.tableExists(this.getSession(), "test_add_column_ab"));
    }

    @Test
    public void testInsert() throws Exception {
        String query = "SELECT orderdate, orderkey FROM orders";
        this.assertUpdate("CREATE TABLE test_insert AS " + query + " WITH NO DATA", 0L);
        this.assertQuery("SELECT count(*) FROM test_insert", "SELECT 0");
        this.assertUpdate("INSERT INTO test_insert " + query, "SELECT count(*) FROM orders");
        this.assertQuery("SELECT * FROM test_insert", query);
        this.assertUpdate("INSERT INTO test_insert (orderkey) VALUES (-1)", 1L);
        this.assertUpdate("INSERT INTO test_insert (orderdate) VALUES (DATE '2001-01-01')", 1L);
        this.assertUpdate("INSERT INTO test_insert (orderkey, orderdate) VALUES (-2, DATE '2001-01-02')", 1L);
        this.assertUpdate("INSERT INTO test_insert (orderdate, orderkey) VALUES (DATE '2001-01-03', -3)", 1L);
        this.assertQuery("SELECT * FROM test_insert", query + " UNION ALL SELECT null, -1" + " UNION ALL SELECT DATE '2001-01-01', null" + " UNION ALL SELECT DATE '2001-01-02', -2" + " UNION ALL SELECT DATE '2001-01-03', -3");
        this.assertUpdate("DROP TABLE test_insert");
    }

    @Test
    public void testDelete() throws Exception {
        this.assertUpdate("CREATE TABLE test_delete AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertUpdate("DELETE FROM test_delete WHERE orderkey % 2 = 0", "SELECT count(*) FROM orders WHERE orderkey % 2 = 0");
        this.assertQuery("SELECT * FROM test_delete", "SELECT * FROM orders WHERE orderkey % 2 <> 0");
        this.assertUpdate("DELETE FROM test_delete", "SELECT count(*) FROM orders WHERE orderkey % 2 <> 0");
        this.assertQuery("SELECT * FROM test_delete", "SELECT * FROM orders LIMIT 0");
        this.assertUpdate("DROP TABLE test_delete");
        this.assertUpdate("CREATE TABLE test_delete AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertUpdate("DELETE FROM test_delete WHERE custkey <= 100", "SELECT count(*) FROM orders WHERE custkey <= 100");
        this.assertQuery("SELECT * FROM test_delete", "SELECT * FROM orders WHERE custkey > 100");
        this.assertUpdate("DELETE FROM test_delete WHERE custkey <= 300", "SELECT count(*) FROM orders WHERE custkey > 100 AND custkey <= 300");
        this.assertQuery("SELECT * FROM test_delete", "SELECT * FROM orders WHERE custkey > 300");
        this.assertUpdate("DELETE FROM test_delete WHERE custkey <= 500", "SELECT count(*) FROM orders WHERE custkey > 300 AND custkey <= 500");
        this.assertQuery("SELECT * FROM test_delete", "SELECT * FROM orders WHERE custkey > 500");
        this.assertUpdate("DROP TABLE test_delete");
        this.assertUpdate("CREATE TABLE test_delete AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertUpdate("DELETE FROM test_delete WHERE orderstatus = 'O'", "SELECT count(*) FROM orders WHERE orderstatus = 'O'");
        this.assertQuery("SELECT * FROM test_delete", "SELECT * FROM orders WHERE orderstatus <> 'O'");
        this.assertUpdate("DROP TABLE test_delete");
        this.assertUpdate("CREATE TABLE test_delete AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertUpdate("DELETE FROM test_delete WHERE rand() < 0", 0L);
        this.assertUpdate("DROP TABLE test_delete");
        this.assertUpdate("CREATE TABLE test_delete AS SELECT * FROM lineitem", "SELECT count(*) FROM lineitem");
        this.assertUpdate("DELETE FROM test_delete WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderstatus = 'F')", "SELECT count(*) FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderstatus = 'F')");
        this.assertQuery("SELECT * FROM test_delete", "SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderstatus <> 'F')");
        this.assertUpdate("DROP TABLE test_delete");
        this.assertUpdate("CREATE TABLE test_delete AS SELECT * FROM lineitem", "SELECT count(*) FROM lineitem");
        this.assertUpdate("DELETE FROM test_delete\nWHERE orderkey IN (SELECT orderkey FROM orders WHERE orderstatus = 'F')\n  AND orderkey IN (SELECT orderkey FROM orders WHERE custkey % 5 = 0)\n", "SELECT count(*) FROM lineitem\nWHERE orderkey IN (SELECT orderkey FROM orders WHERE orderstatus = 'F')\n  AND orderkey IN (SELECT orderkey FROM orders WHERE custkey % 5 = 0)");
        this.assertQuery("SELECT * FROM test_delete", "SELECT * FROM lineitem\nWHERE orderkey IN (SELECT orderkey FROM orders WHERE orderstatus <> 'F')\n  OR orderkey IN (SELECT orderkey FROM orders WHERE custkey % 5 <> 0)");
        this.assertUpdate("DROP TABLE test_delete");
        this.assertUpdate("CREATE TABLE test_delete AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertUpdate("DELETE FROM test_delete\nWHERE (orderkey IN (SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END FROM lineitem)) IS NULL\n", "SELECT count(*) FROM orders\nWHERE (orderkey IN (SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END FROM lineitem)) IS NULL\n");
        this.assertQuery("SELECT * FROM test_delete", "SELECT * FROM orders\nWHERE (orderkey IN (SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END FROM lineitem)) IS NOT NULL\n");
        this.assertUpdate("DROP TABLE test_delete");
    }

    @Test
    public void testDropTableIfExists() throws Exception {
        Assert.assertFalse((boolean)this.queryRunner.tableExists(this.getSession(), "test_drop_if_exists"));
        this.assertUpdate("DROP TABLE IF EXISTS test_drop_if_exists");
        Assert.assertFalse((boolean)this.queryRunner.tableExists(this.getSession(), "test_drop_if_exists"));
    }

    @Test
    public void testView() throws Exception {
        String query = "SELECT orderkey, orderstatus, totalprice / 2 half FROM orders";
        this.assertUpdate("CREATE VIEW test_view AS SELECT 123 x");
        this.assertUpdate("CREATE OR REPLACE VIEW test_view AS " + query);
        this.assertQuery("SELECT * FROM test_view", query);
        this.assertQuery("SELECT * FROM test_view a JOIN test_view b on a.orderkey = b.orderkey", String.format("SELECT * FROM (%s) a JOIN (%s) b ON a.orderkey = b.orderkey", query, query));
        this.assertQuery("WITH orders AS (SELECT * FROM orders LIMIT 0) SELECT * FROM test_view", query);
        String name = String.format("%s.%s.test_view", this.getSession().getCatalog().get(), this.getSession().getSchema().get());
        this.assertQuery("SELECT * FROM " + name, query);
        this.assertUpdate("DROP VIEW test_view");
    }

    @Test
    public void testViewMetadata() throws Exception {
        String query = "SELECT 123 x, 'foo' y";
        this.assertUpdate("CREATE VIEW meta_test_view AS " + query);
        MaterializedResult actual = this.computeActual(String.format("SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = '%s'", this.getSession().getSchema().get()));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"customer", "BASE TABLE"}).row(new Object[]{"lineitem", "BASE TABLE"}).row(new Object[]{"meta_test_view", "VIEW"}).row(new Object[]{"nation", "BASE TABLE"}).row(new Object[]{"orders", "BASE TABLE"}).row(new Object[]{"part", "BASE TABLE"}).row(new Object[]{"partsupp", "BASE TABLE"}).row(new Object[]{"region", "BASE TABLE"}).row(new Object[]{"supplier", "BASE TABLE"}).build();
        QueryAssertions.assertContains(actual, expected);
        actual = this.computeActual("SHOW TABLES");
        MaterializedResult.Builder builder = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes());
        for (MaterializedRow row : expected.getMaterializedRows()) {
            builder.row(new Object[]{row.getField(0)});
        }
        expected = builder.build();
        QueryAssertions.assertContains(actual, expected);
        actual = this.computeActual(String.format("SELECT table_name, view_definition FROM information_schema.views WHERE table_schema = '%s'", this.getSession().getSchema().get()));
        expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"meta_test_view", SqlFormatter.formatSql((Node)new SqlParser().createStatement(query))}).build();
        QueryAssertions.assertContains(actual, expected);
        actual = this.computeActual("SHOW COLUMNS FROM meta_test_view");
        expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BooleanType.BOOLEAN, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row(new Object[]{"x", "bigint", true, false, ""}).row(new Object[]{"y", "varchar", true, false, ""}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
        this.assertUpdate("DROP VIEW meta_test_view");
    }

    @Test
    public void testLargeQuerySuccess() throws Exception {
        this.assertQuery("SELECT " + Joiner.on((String)" AND ").join(Collections.nCopies(500, "1 = 1")), "SELECT true");
    }

    @Test
    public void testShowSchemasFromOther() throws Exception {
        MaterializedResult result = this.computeActual("SHOW SCHEMAS FROM tpch");
        ImmutableSet schemaNames = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)result.getMaterializedRows(), this.onlyColumnGetter()));
        Assert.assertTrue((boolean)schemaNames.containsAll((Collection)ImmutableSet.of((Object)"information_schema", (Object)"tiny", (Object)"sf1")));
    }

    @Test
    public void testTableSampleSystem() throws Exception {
        int total = this.computeActual("SELECT orderkey FROM orders").getMaterializedRows().size();
        boolean sampleSizeFound = false;
        for (int i = 0; i < 100; ++i) {
            int sampleSize = this.computeActual("SELECT orderkey FROM ORDERS TABLESAMPLE SYSTEM (50)").getMaterializedRows().size();
            if (sampleSize <= 0 || sampleSize >= total) continue;
            sampleSizeFound = true;
            break;
        }
        Assert.assertTrue((boolean)sampleSizeFound, (String)"Table sample returned unexpected number of rows");
    }

    @Test
    public void testTableSampleSystemBoundaryValues() throws Exception {
        MaterializedResult fullSample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE SYSTEM (100)");
        MaterializedResult emptySample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE SYSTEM (0)");
        MaterializedResult all = this.computeActual("SELECT orderkey FROM orders");
        QueryAssertions.assertContains(all, fullSample);
        Assert.assertEquals((int)emptySample.getMaterializedRows().size(), (int)0);
    }

    @Override
    @Test
    public void testTableSamplePoissonizedRescaled() throws Exception {
        MaterializedResult sample = this.computeActual("SELECT * FROM orders TABLESAMPLE POISSONIZED (10) RESCALED");
        MaterializedResult all = this.computeExpected("SELECT * FROM orders", sample.getTypes());
        Assert.assertTrue((!sample.getMaterializedRows().isEmpty() ? 1 : 0) != 0);
        QueryAssertions.assertContains(all, sample);
    }

    @Test
    public void testSymbolAliasing() throws Exception {
        this.assertUpdate("CREATE TABLE test_symbol_aliasing AS SELECT 1 foo_1, 2 foo_2_4", 1L);
        this.assertQuery("SELECT foo_1, foo_2_4 FROM test_symbol_aliasing", "SELECT 1, 2");
        this.assertUpdate("DROP TABLE test_symbol_aliasing");
    }

    private void assertTableColumnNames(String tableName, String ... columnNames) {
        MaterializedResult result = this.computeActual("DESCRIBE " + tableName);
        ImmutableList expected = ImmutableList.copyOf((Object[])columnNames);
        List actual = (List)result.getMaterializedRows().stream().map(row -> (String)row.getField(0)).collect(ImmutableCollectors.toImmutableList());
        Assert.assertEquals((Collection)actual, (Collection)expected);
    }
}

