/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.client.ClientSession;
import com.facebook.presto.client.Column;
import com.facebook.presto.client.QueryError;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.client.StatementClient;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.server.testing.TestingPrestoServer;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.tests.ResultsSession;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.json.JsonCodec;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.intellij.lang.annotations.Language;

public abstract class AbstractTestingPrestoClient<T>
implements Closeable {
    private static final JsonCodec<QueryResults> QUERY_RESULTS_CODEC = JsonCodec.jsonCodec(QueryResults.class);
    private final TestingPrestoServer prestoServer;
    private final Session defaultSession;
    private final HttpClient httpClient;

    protected AbstractTestingPrestoClient(TestingPrestoServer prestoServer, Session defaultSession) {
        this.prestoServer = Objects.requireNonNull(prestoServer, "prestoServer is null");
        this.defaultSession = Objects.requireNonNull(defaultSession, "defaultSession is null");
        this.httpClient = new JettyHttpClient(new HttpClientConfig().setConnectTimeout(new Duration(1.0, TimeUnit.DAYS)).setIdleTimeout(new Duration(10.0, TimeUnit.DAYS)));
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    protected abstract ResultsSession<T> getResultSession(Session var1);

    public T execute(@Language(value="SQL") String sql) {
        return this.execute(this.defaultSession, sql);
    }

    public T execute(Session session, @Language(value="SQL") String sql) {
        ResultsSession<T> resultsSession = this.getResultSession(session);
        ClientSession clientSession = session.toClientSession(this.prestoServer.getBaseUrl(), true, new Duration(2.0, TimeUnit.MINUTES));
        Throwable throwable = null;
        try (StatementClient client = new StatementClient(this.httpClient, QUERY_RESULTS_CODEC, clientSession, sql);){
            QueryResults results;
            while (client.isValid()) {
                results = client.current();
                resultsSession.addResults(results);
                client.advance();
            }
            if (!client.isFailed()) {
                results = client.finalResults();
                if (results.getUpdateType() != null) {
                    resultsSession.setUpdateType(results.getUpdateType());
                }
                if (results.getUpdateCount() != null) {
                    resultsSession.setUpdateCount(results.getUpdateCount());
                }
                T t = resultsSession.build(client.getSetSessionProperties(), client.getResetSessionProperties());
                return t;
            }
            try {
                QueryError error = client.finalResults().getError();
                assert (error != null);
                if (error.getFailureInfo() != null) {
                    throw error.getFailureInfo().toException();
                }
                throw new RuntimeException("Query failed: " + error.getMessage());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public List<QualifiedObjectName> listTables(Session session, String catalog, String schema) {
        return this.prestoServer.getMetadata().listTables(session, new QualifiedTablePrefix(catalog, schema));
    }

    public boolean tableExists(Session session, String table) {
        return MetadataUtil.tableExists((Metadata)this.prestoServer.getMetadata(), (Session)session, (String)table);
    }

    public Session getDefaultSession() {
        return this.defaultSession;
    }

    public TestingPrestoServer getServer() {
        return this.prestoServer;
    }

    protected List<Type> getTypes(List<Column> columns) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(columns, this.columnTypeGetter()));
    }

    protected Function<Column, Type> columnTypeGetter() {
        return column -> {
            String typeName = column.getType();
            Type type = this.prestoServer.getMetadata().getType(TypeSignature.parseTypeSignature((String)typeName));
            if (type == null) {
                throw new AssertionError((Object)("Unhandled type: " + typeName));
            }
            return type;
        };
    }
}

