/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.tpch;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorIndex;
import com.facebook.presto.spi.ConnectorIndexHandle;
import com.facebook.presto.spi.ConnectorIndexResolver;
import com.facebook.presto.spi.ConnectorResolvedIndex;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.split.MappedRecordSet;
import com.facebook.presto.tests.tpch.AppendingRecordSet;
import com.facebook.presto.tests.tpch.TpchConnectorIndex;
import com.facebook.presto.tests.tpch.TpchIndexHandle;
import com.facebook.presto.tests.tpch.TpchIndexedData;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchTableHandle;
import com.facebook.presto.util.Types;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class TpchIndexResolver
implements ConnectorIndexResolver {
    private final String connectorId;
    private final TpchIndexedData indexedData;

    public TpchIndexResolver(String connectorId, TpchIndexedData indexedData) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.indexedData = Objects.requireNonNull(indexedData, "indexedData is null");
    }

    public ConnectorResolvedIndex resolveIndex(ConnectorSession session, ConnectorTableHandle tableHandle, Set<ColumnHandle> indexableColumns, TupleDomain<ColumnHandle> tupleDomain) {
        TpchTableHandle tpchTableHandle = (TpchTableHandle)Types.checkType((Object)tableHandle, TpchTableHandle.class, (String)"tableHandle");
        Map<ColumnHandle, NullableValue> fixedValues = ((Map)TupleDomain.extractFixedValues(tupleDomain).orElse(ImmutableMap.of())).entrySet().stream().filter(entry -> !indexableColumns.contains(entry.getKey())).filter(entry -> !((NullableValue)entry.getValue()).isNull()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(Iterables.transform(indexableColumns, TpchIndexResolver.columnNameGetter()));
        builder.addAll(Iterables.transform(fixedValues.keySet(), TpchIndexResolver.columnNameGetter()));
        ImmutableSet lookupColumnNames = builder.build();
        if (!this.indexedData.getIndexedTable(tpchTableHandle.getTableName(), tpchTableHandle.getScaleFactor(), (Set<String>)lookupColumnNames).isPresent()) {
            return null;
        }
        TupleDomain filteredTupleDomain = tupleDomain;
        if (!tupleDomain.isNone()) {
            filteredTupleDomain = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)((Map)tupleDomain.getDomains().get()), (Predicate)Predicates.not((Predicate)Predicates.in(fixedValues.keySet()))));
        }
        return new ConnectorResolvedIndex((ConnectorIndexHandle)new TpchIndexHandle(this.connectorId, tpchTableHandle.getTableName(), tpchTableHandle.getScaleFactor(), (Set<String>)lookupColumnNames, (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues(fixedValues)), filteredTupleDomain);
    }

    public ConnectorIndex getIndex(ConnectorSession session, ConnectorIndexHandle indexHandle, List<ColumnHandle> lookupSchema, List<ColumnHandle> outputSchema) {
        TpchIndexHandle tpchIndexHandle = (TpchIndexHandle)Types.checkType((Object)indexHandle, TpchIndexHandle.class, (String)"indexHandle");
        Map fixedValues = (Map)TupleDomain.extractFixedValues(tpchIndexHandle.getFixedValues()).get();
        Preconditions.checkArgument((!Iterables.any(lookupSchema, (Predicate)Predicates.in(fixedValues.keySet())) ? 1 : 0) != 0, (Object)"Lookup columnHandles are not expected to overlap with the fixed value predicates");
        ImmutableList fixedValueColumns = ImmutableList.copyOf(fixedValues.keySet());
        ArrayList<Object> rawFixedValues = new ArrayList<Object>(fixedValueColumns.size());
        ArrayList<Type> rawFixedTypes = new ArrayList<Type>(fixedValueColumns.size());
        for (ColumnHandle fixedValueColumn : fixedValueColumns) {
            rawFixedValues.add(((NullableValue)fixedValues.get(fixedValueColumn)).getValue());
            rawFixedTypes.add(((TpchColumnHandle)fixedValueColumn).getType());
        }
        ImmutableList finalLookupSchema = ImmutableList.builder().addAll(lookupSchema).addAll((Iterable)fixedValueColumns).build();
        Optional<TpchIndexedData.IndexedTable> indexedTable = this.indexedData.getIndexedTable(tpchIndexHandle.getTableName(), tpchIndexHandle.getScaleFactor(), tpchIndexHandle.getIndexColumnNames());
        Preconditions.checkState((boolean)indexedTable.isPresent());
        TpchIndexedData.IndexedTable table = indexedTable.get();
        List<Integer> keyRemap = TpchIndexResolver.computeRemap(TpchIndexResolver.handleToNames((List<ColumnHandle>)finalLookupSchema), table.getKeyColumns());
        Function keyFormatter = key -> new MappedRecordSet((RecordSet)new AppendingRecordSet((RecordSet)key, (List<Object>)rawFixedValues, (List<Type>)rawFixedTypes), keyRemap);
        List<Integer> outputRemap = TpchIndexResolver.computeRemap(table.getOutputColumns(), TpchIndexResolver.handleToNames(outputSchema));
        Function outputFormatter = output -> new MappedRecordSet(output, outputRemap);
        return new TpchConnectorIndex((Function<RecordSet, RecordSet>)keyFormatter, (Function<RecordSet, RecordSet>)outputFormatter, table);
    }

    private static List<Integer> computeRemap(List<String> startSchema, List<String> endSchema) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String columnName : endSchema) {
            int index = startSchema.indexOf(columnName);
            Preconditions.checkArgument((index != -1 ? 1 : 0) != 0, (String)"Column name in end that is not in the start: %s", (Object[])new Object[]{columnName});
            builder.add((Object)index);
        }
        return builder.build();
    }

    private static List<String> handleToNames(List<ColumnHandle> columnHandles) {
        return Lists.transform(columnHandles, TpchIndexResolver.columnNameGetter());
    }

    private static Function<ColumnHandle, String> columnNameGetter() {
        return columnHandle -> ((TpchColumnHandle)Types.checkType((Object)columnHandle, TpchColumnHandle.class, (String)"columnHandle")).getColumnName();
    }
}

