/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.InterleavedBlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.TypeJsonUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;

public final class StructuralTestUtil {
    private StructuralTestUtil() {
    }

    public static boolean arrayBlocksEqual(Type elementType, Block block1, Block block2) {
        if (block1.getPositionCount() != block2.getPositionCount()) {
            return false;
        }
        for (int i = 0; i < block1.getPositionCount(); ++i) {
            if (block1.isNull(i) != block2.isNull(i)) {
                return false;
            }
            if (block1.isNull(i) || elementType.equalTo(block1, i, block2, i)) continue;
            return false;
        }
        return true;
    }

    public static boolean mapBlocksEqual(Type keyType, Type valueType, Block block1, Block block2) {
        if (block1.getPositionCount() != block2.getPositionCount()) {
            return false;
        }
        for (int i = 0; i < block1.getPositionCount(); i += 2) {
            if (block1.isNull(i) != block2.isNull(i) || block1.isNull(i + 1) != block2.isNull(i + 1)) {
                return false;
            }
            if (!block1.isNull(i) && !keyType.equalTo(block1, i, block2, i)) {
                return false;
            }
            if (block1.isNull(i + 1) || valueType.equalTo(block1, i + 1, block2, i + 1)) continue;
            return false;
        }
        return true;
    }

    public static Block arrayBlockOf(Type elementType, Object ... values) {
        BlockBuilder blockBuilder = elementType.createBlockBuilder(new BlockBuilderStatus(), 1024);
        for (Object value : values) {
            TypeJsonUtils.appendToBlockBuilder((Type)elementType, (Object)value, (BlockBuilder)blockBuilder);
        }
        return blockBuilder.build();
    }

    public static Block mapBlockOf(Type keyType, Type valueType, Object key, Object value) {
        InterleavedBlockBuilder blockBuilder = new InterleavedBlockBuilder((List)ImmutableList.of((Object)keyType, (Object)valueType), new BlockBuilderStatus(), 1024);
        TypeJsonUtils.appendToBlockBuilder((Type)keyType, (Object)key, (BlockBuilder)blockBuilder);
        TypeJsonUtils.appendToBlockBuilder((Type)valueType, (Object)value, (BlockBuilder)blockBuilder);
        return blockBuilder.build();
    }

    public static Block rowBlockOf(List<Type> parameterTypes, Object ... values) {
        InterleavedBlockBuilder blockBuilder = new InterleavedBlockBuilder(parameterTypes, new BlockBuilderStatus(), 1024);
        for (int i = 0; i < values.length; ++i) {
            TypeJsonUtils.appendToBlockBuilder((Type)parameterTypes.get(i), (Object)values[i], (BlockBuilder)blockBuilder);
        }
        return blockBuilder.build();
    }
}

