/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.index.IndexManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.PlanOptimizersFactory;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.testing.TestingAccessControlManager;
import com.facebook.presto.tests.H2QueryRunner;
import com.facebook.presto.tests.QueryAssertions;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.AfterClass;

public abstract class AbstractTestQueryFramework {
    protected final H2QueryRunner h2QueryRunner;
    protected final QueryRunner queryRunner;
    private final SqlParser sqlParser;

    protected AbstractTestQueryFramework(QueryRunner queryRunner) {
        this.queryRunner = queryRunner;
        this.h2QueryRunner = new H2QueryRunner();
        this.sqlParser = new SqlParser();
    }

    @AfterClass(alwaysRun=true)
    private void close() throws Exception {
        try {
            this.h2QueryRunner.close();
        }
        finally {
            this.queryRunner.close();
        }
    }

    protected Session getSession() {
        return this.queryRunner.getDefaultSession();
    }

    public final int getNodeCount() {
        return this.queryRunner.getNodeCount();
    }

    protected MaterializedResult computeActual(@Language(value="SQL") String sql) {
        return this.computeActual(this.getSession(), sql);
    }

    protected MaterializedResult computeActual(Session session, @Language(value="SQL") String sql) {
        return this.queryRunner.execute(session, sql).toJdbcTypes();
    }

    protected void assertQuery(@Language(value="SQL") String sql) throws Exception {
        this.assertQuery(this.getSession(), sql);
    }

    protected void assertQuery(Session session, @Language(value="SQL") String sql) throws Exception {
        QueryAssertions.assertQuery(this.queryRunner, session, sql, this.h2QueryRunner, sql, false);
    }

    public void assertQueryOrdered(@Language(value="SQL") String sql) throws Exception {
        QueryAssertions.assertQuery(this.queryRunner, this.getSession(), sql, this.h2QueryRunner, sql, true);
    }

    protected void assertQuery(@Language(value="SQL") String actual, @Language(value="SQL") String expected) throws Exception {
        QueryAssertions.assertQuery(this.queryRunner, this.getSession(), actual, this.h2QueryRunner, expected, false);
    }

    protected void assertQuery(Session session, @Language(value="SQL") String actual, @Language(value="SQL") String expected) throws Exception {
        QueryAssertions.assertQuery(this.queryRunner, session, actual, this.h2QueryRunner, expected, false);
    }

    protected void assertQueryOrdered(@Language(value="SQL") String actual, @Language(value="SQL") String expected) throws Exception {
        this.assertQueryOrdered(this.getSession(), actual, expected);
    }

    protected void assertQueryOrdered(Session session, @Language(value="SQL") String actual, @Language(value="SQL") String expected) throws Exception {
        QueryAssertions.assertQuery(this.queryRunner, session, actual, this.h2QueryRunner, expected, true);
    }

    protected void assertQueryTrue(@Language(value="SQL") String sql) throws Exception {
        this.assertQuery(sql, "SELECT true");
    }

    public void assertApproximateQuery(Session session, @Language(value="SQL") String actual, @Language(value="SQL") String expected) throws Exception {
        QueryAssertions.assertApproximateQuery(this.queryRunner, session, actual, this.h2QueryRunner, expected);
    }

    protected void assertAccessAllowed(@Language(value="SQL") String sql, TestingAccessControlManager.TestingPrivilege ... deniedPrivileges) throws Exception {
        this.assertAccessAllowed(this.getSession(), sql, deniedPrivileges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertAccessAllowed(Session session, @Language(value="SQL") String sql, TestingAccessControlManager.TestingPrivilege ... deniedPrivileges) throws Exception {
        this.queryRunner.getExclusiveLock().lock();
        try {
            this.queryRunner.getAccessControl().deny(deniedPrivileges);
            this.queryRunner.execute(session, sql);
        }
        finally {
            this.queryRunner.getAccessControl().reset();
            this.queryRunner.getExclusiveLock().unlock();
        }
    }

    protected void assertAccessDenied(@Language(value="SQL") String sql, @Language(value="RegExp") String exceptionsMessageRegExp, TestingAccessControlManager.TestingPrivilege ... deniedPrivileges) throws Exception {
        this.assertAccessDenied(this.getSession(), sql, exceptionsMessageRegExp, deniedPrivileges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertAccessDenied(Session session, @Language(value="SQL") String sql, @Language(value="RegExp") String exceptionsMessageRegExp, TestingAccessControlManager.TestingPrivilege ... deniedPrivileges) throws Exception {
        this.queryRunner.getExclusiveLock().lock();
        try {
            this.queryRunner.getAccessControl().deny(deniedPrivileges);
            this.queryRunner.execute(session, sql);
            Assert.fail((String)("Expected " + AccessDeniedException.class.getSimpleName()));
        }
        catch (RuntimeException e) {
            AbstractTestQueryFramework.assertExceptionMessage(e, exceptionsMessageRegExp);
        }
        finally {
            this.queryRunner.getAccessControl().reset();
            this.queryRunner.getExclusiveLock().unlock();
        }
    }

    private static void assertExceptionMessage(Exception exception, @Language(value="RegExp") String exceptionMessagePattern) {
        String regex = ".*Access Denied: " + exceptionMessagePattern;
        if (!exception.getMessage().matches(regex)) {
            Assert.fail((String)String.format("Expected exception message '%s' to match '%s'", exception.getMessage(), regex));
        }
    }

    protected MaterializedResult computeExpected(@Language(value="SQL") String sql, List<? extends Type> resultTypes) {
        return this.h2QueryRunner.execute(this.getSession(), sql, resultTypes);
    }

    public Function<MaterializedRow, String> onlyColumnGetter() {
        return input -> {
            Assert.assertEquals((int)input.getFieldCount(), (int)1);
            return (String)input.getField(0);
        };
    }

    public String getExplainPlan(String query, ExplainType.Type planType) {
        QueryExplainer explainer = this.getQueryExplainer();
        return explainer.getPlan(this.queryRunner.getDefaultSession(), this.sqlParser.createStatement(query), planType);
    }

    public String getGraphvizExplainPlan(String query, ExplainType.Type planType) {
        QueryExplainer explainer = this.getQueryExplainer();
        return explainer.getGraphvizPlan(this.queryRunner.getDefaultSession(), this.sqlParser.createStatement(query), planType);
    }

    private QueryExplainer getQueryExplainer() {
        Metadata metadata = this.queryRunner.getMetadata();
        FeaturesConfig featuresConfig = new FeaturesConfig().setExperimentalSyntaxEnabled(true).setOptimizeHashGeneration(true);
        boolean forceSingleNode = this.queryRunner.getNodeCount() == 1;
        List optimizers = new PlanOptimizersFactory(metadata, this.sqlParser, new IndexManager(), featuresConfig, forceSingleNode).get();
        return new QueryExplainer(optimizers, metadata, (AccessControl)this.queryRunner.getAccessControl(), this.sqlParser, (Map)ImmutableMap.of(), featuresConfig.isExperimentalSyntaxEnabled());
    }
}

