/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.tpch;

import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.tests.tpch.ConcatRecordSet;
import com.facebook.presto.tests.tpch.MaterializedTuple;
import com.facebook.presto.tests.tpch.MaterializedTupleRecordSet;
import com.facebook.presto.tests.tpch.TpchIndexSpec;
import com.facebook.presto.tests.tpch.TpchScaledTable;
import com.facebook.presto.tpch.TpchMetadata;
import com.facebook.presto.tpch.TpchRecordSetProvider;
import com.facebook.presto.tpch.TpchTableHandle;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import io.airlift.slice.Slice;
import io.airlift.tpch.TpchTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class TpchIndexedData {
    private final Map<Set<TpchScaledColumn>, IndexedTable> indexedTables;

    public TpchIndexedData(String connectorId, TpchIndexSpec tpchIndexSpec) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        Objects.requireNonNull(tpchIndexSpec, "tpchIndexSpec is null");
        TpchMetadata tpchMetadata = new TpchMetadata(connectorId);
        TpchRecordSetProvider tpchRecordSetProvider = new TpchRecordSetProvider();
        ImmutableMap.Builder indexedTablesBuilder = ImmutableMap.builder();
        Set<TpchScaledTable> tables = tpchIndexSpec.listIndexedTables();
        for (TpchScaledTable table : tables) {
            SchemaTableName tableName = new SchemaTableName("sf" + table.getScaleFactor(), table.getTableName());
            TpchTableHandle tableHandle = tpchMetadata.getTableHandle(null, tableName);
            LinkedHashMap columnHandles = new LinkedHashMap(tpchMetadata.getColumnHandles(null, (ConnectorTableHandle)tableHandle));
            for (Set<String> columnNames : tpchIndexSpec.getColumnIndexes(table)) {
                ImmutableList keyColumnNames = ImmutableList.copyOf(columnNames);
                ImmutableSet keyColumns = FluentIterable.from((Iterable)keyColumnNames).transform(TpchScaledColumn.columnFunction(table)).toSet();
                TpchTable tpchTable = TpchTable.getTable((String)table.getTableName());
                RecordSet recordSet = tpchRecordSetProvider.getRecordSet(tpchTable, (List)ImmutableList.copyOf(columnHandles.values()), table.getScaleFactor(), 0, 1);
                IndexedTable indexedTable = TpchIndexedData.indexTable(recordSet, (List<String>)ImmutableList.copyOf(columnHandles.keySet()), (List<String>)keyColumnNames);
                indexedTablesBuilder.put((Object)keyColumns, (Object)indexedTable);
            }
        }
        this.indexedTables = indexedTablesBuilder.build();
    }

    public Optional<IndexedTable> getIndexedTable(String tableName, double scaleFactor, Set<String> indexColumnNames) {
        TpchScaledTable table = new TpchScaledTable(tableName, scaleFactor);
        ImmutableSet indexColumns = FluentIterable.from(indexColumnNames).transform(TpchScaledColumn.columnFunction(table)).toSet();
        return Optional.ofNullable(this.indexedTables.get(indexColumns));
    }

    private static <T> List<T> extractPositionValues(final List<T> values, List<Integer> positions) {
        return Lists.transform(positions, (Function)new Function<Integer, T>(){

            public T apply(Integer position) {
                Preconditions.checkPositionIndex((int)position, (int)values.size());
                return values.get(position);
            }
        });
    }

    private static IndexedTable indexTable(RecordSet recordSet, final List<String> outputColumns, List<String> keyColumns) {
        ImmutableList keyPositions = FluentIterable.from(keyColumns).transform((Function)new Function<String, Integer>(){

            public Integer apply(String columnName) {
                int position = outputColumns.indexOf(columnName);
                Preconditions.checkState((position != -1 ? 1 : 0) != 0);
                return position;
            }
        }).toList();
        ImmutableListMultimap.Builder indexedValuesBuilder = ImmutableListMultimap.builder();
        List outputTypes = recordSet.getColumnTypes();
        List keyTypes = TpchIndexedData.extractPositionValues(outputTypes, (List<Integer>)keyPositions);
        RecordCursor cursor = recordSet.cursor();
        while (cursor.advanceNextPosition()) {
            List<Object> values = TpchIndexedData.extractValues(cursor, outputTypes);
            List<Object> keyValues = TpchIndexedData.extractPositionValues(values, (List<Integer>)keyPositions);
            indexedValuesBuilder.put((Object)new MaterializedTuple(keyValues), (Object)new MaterializedTuple(values));
        }
        return new IndexedTable(keyColumns, keyTypes, outputColumns, outputTypes, (ListMultimap)indexedValuesBuilder.build());
    }

    private static List<Object> extractValues(RecordCursor cursor, List<Type> types) {
        ArrayList<Object> list = new ArrayList<Object>(types.size());
        for (int i = 0; i < types.size(); ++i) {
            list.add(TpchIndexedData.extractObject(cursor, i, types.get(i)));
        }
        return list;
    }

    private static Object extractObject(RecordCursor cursor, int field, Type type) {
        if (cursor.isNull(field)) {
            return null;
        }
        Class javaType = type.getJavaType();
        if (javaType == Boolean.TYPE) {
            return cursor.getBoolean(field);
        }
        if (javaType == Long.TYPE) {
            return cursor.getLong(field);
        }
        if (javaType == Double.TYPE) {
            return cursor.getDouble(field);
        }
        if (javaType == Slice.class) {
            return cursor.getSlice(field).toStringUtf8();
        }
        throw new AssertionError((Object)("Unsupported type: " + type));
    }

    private static class TpchScaledColumn {
        private final TpchScaledTable table;
        private final String columnName;

        private TpchScaledColumn(TpchScaledTable table, String columnName) {
            this.table = Objects.requireNonNull(table, "table is null");
            this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        }

        public static Function<String, TpchScaledColumn> columnFunction(final TpchScaledTable table) {
            return new Function<String, TpchScaledColumn>(){

                public TpchScaledColumn apply(String columnName) {
                    return new TpchScaledColumn(table, columnName);
                }
            };
        }

        public int hashCode() {
            return Objects.hash(this.table, this.columnName);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TpchScaledColumn other = (TpchScaledColumn)obj;
            return Objects.equals(this.table, other.table) && Objects.equals(this.columnName, other.columnName);
        }
    }

    public static class IndexedTable {
        private final List<String> keyColumnNames;
        private final List<Type> keyTypes;
        private final List<String> outputColumnNames;
        private final List<Type> outputTypes;
        private final ListMultimap<MaterializedTuple, MaterializedTuple> keyToValues;

        private IndexedTable(List<String> keyColumnNames, List<Type> keyTypes, List<String> outputColumnNames, List<Type> outputTypes, ListMultimap<MaterializedTuple, MaterializedTuple> keyToValues) {
            this.keyColumnNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(keyColumnNames, "keyColumnNames is null"));
            this.keyTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(keyTypes, "keyTypes is null"));
            this.outputColumnNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputColumnNames, "outputColumnNames is null"));
            this.outputTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputTypes, "outputTypes is null"));
            this.keyToValues = ImmutableListMultimap.copyOf((Multimap)((Multimap)Objects.requireNonNull(keyToValues, "keyToValues is null")));
        }

        public List<String> getKeyColumns() {
            return this.keyColumnNames;
        }

        public List<String> getOutputColumns() {
            return this.outputColumnNames;
        }

        public RecordSet lookupKeys(RecordSet recordSet) {
            Preconditions.checkArgument((boolean)recordSet.getColumnTypes().equals(this.keyTypes), (Object)"Input RecordSet keys do not match expected key type");
            Iterable outputRecordSets = Iterables.transform(IndexedTable.tupleIterable(recordSet), (Function)new Function<MaterializedTuple, RecordSet>(){

                public RecordSet apply(MaterializedTuple key) {
                    for (Object value : key.getValues()) {
                        if (value != null) continue;
                        throw new IllegalArgumentException("TPCH index does not support null values");
                    }
                    return this.lookupKey(key);
                }
            });
            return new ConcatRecordSet(outputRecordSets, this.outputTypes);
        }

        public RecordSet lookupKey(MaterializedTuple tupleKey) {
            return new MaterializedTupleRecordSet(this.keyToValues.get((Object)tupleKey), this.outputTypes);
        }

        private static Iterable<MaterializedTuple> tupleIterable(final RecordSet recordSet) {
            return new Iterable<MaterializedTuple>(){

                @Override
                public Iterator<MaterializedTuple> iterator() {
                    return new AbstractIterator<MaterializedTuple>(){
                        private final RecordCursor cursor;
                        {
                            this.cursor = recordSet.cursor();
                        }

                        protected MaterializedTuple computeNext() {
                            if (!this.cursor.advanceNextPosition()) {
                                return (MaterializedTuple)this.endOfData();
                            }
                            return new MaterializedTuple(TpchIndexedData.extractValues(this.cursor, recordSet.getColumnTypes()));
                        }
                    };
                }
            };
        }
    }
}

