/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.tpch;

import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.tests.tpch.IndexedTpchConnectorFactory;
import com.facebook.presto.tests.tpch.TpchIndexSpec;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;

public class IndexedTpchPlugin
implements Plugin {
    private NodeManager nodeManager;
    private TpchIndexSpec indexSpec;

    public IndexedTpchPlugin(TpchIndexSpec indexSpec) {
        this.indexSpec = (TpchIndexSpec)Preconditions.checkNotNull((Object)indexSpec, (Object)"indexSpec is null");
    }

    public IndexedTpchPlugin() {
        this(TpchIndexSpec.NO_INDEXES);
    }

    @Inject
    public void setNodeManager(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    public <T> List<T> getServices(Class<T> type) {
        if (type == ConnectorFactory.class) {
            Preconditions.checkNotNull((Object)this.nodeManager, (Object)"nodeManager is null");
            return ImmutableList.of(type.cast(new IndexedTpchConnectorFactory(this.nodeManager, this.indexSpec, 4)));
        }
        return ImmutableList.of();
    }
}

