/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.client.Column;
import com.facebook.presto.client.QueryError;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.client.StatementClient;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.server.testing.TestingPrestoServer;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.tests.ResultsSession;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.json.JsonCodec;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.intellij.lang.annotations.Language;

public abstract class AbstractTestingPrestoClient<T>
implements Closeable {
    private static final JsonCodec<QueryResults> QUERY_RESULTS_CODEC = JsonCodec.jsonCodec(QueryResults.class);
    private final TestingPrestoServer prestoServer;
    private final Session defaultSession;
    private final HttpClient httpClient;

    protected AbstractTestingPrestoClient(TestingPrestoServer prestoServer, Session defaultSession) {
        this.prestoServer = (TestingPrestoServer)Preconditions.checkNotNull((Object)prestoServer, (Object)"prestoServer is null");
        this.defaultSession = (Session)Preconditions.checkNotNull((Object)defaultSession, (Object)"defaultSession is null");
        this.httpClient = new JettyHttpClient(new HttpClientConfig().setConnectTimeout(new Duration(1.0, TimeUnit.DAYS)).setIdleTimeout(new Duration(10.0, TimeUnit.DAYS)));
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    protected abstract ResultsSession<T> getResultSession(Session var1);

    public T execute(@Language(value="SQL") String sql) {
        return this.execute(this.defaultSession, sql);
    }

    public T execute(Session session, @Language(value="SQL") String sql) {
        ResultsSession<T> resultsSession = this.getResultSession(session);
        Throwable throwable = null;
        try (StatementClient client = new StatementClient(this.httpClient, QUERY_RESULTS_CODEC, session.toClientSession(this.prestoServer.getBaseUrl(), true), sql);){
            Object results;
            while (client.isValid()) {
                results = client.current();
                resultsSession.addResults((QueryResults)results);
                client.advance();
            }
            if (!client.isFailed()) {
                results = resultsSession.build(client.getSetSessionProperties(), client.getResetSessionProperties());
                return (T)results;
            }
            try {
                QueryError error = client.finalResults().getError();
                assert (error != null);
                if (error.getFailureInfo() != null) {
                    throw error.getFailureInfo().toException();
                }
                throw new RuntimeException("Query failed: " + error.getMessage());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public List<QualifiedTableName> listTables(Session session, String catalog, String schema) {
        return this.prestoServer.getMetadata().listTables(session, new QualifiedTablePrefix(catalog, schema));
    }

    public boolean tableExists(Session session, String table) {
        QualifiedTableName name = new QualifiedTableName(session.getCatalog(), session.getSchema(), table);
        return this.prestoServer.getMetadata().getTableHandle(session, name).isPresent();
    }

    public Session getDefaultSession() {
        return this.defaultSession;
    }

    public TestingPrestoServer getServer() {
        return this.prestoServer;
    }

    protected List<Type> getTypes(List<Column> columns) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(columns, this.columnTypeGetter()));
    }

    protected Function<Column, Type> columnTypeGetter() {
        return new Function<Column, Type>(){

            public Type apply(Column column) {
                String typeName = column.getType();
                Type type = AbstractTestingPrestoClient.this.prestoServer.getMetadata().getType(TypeSignature.parseTypeSignature((String)typeName));
                if (type == null) {
                    throw new AssertionError((Object)("Unhandled type: " + typeName));
                }
                return type;
            }
        };
    }
}

