/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.testing;

import com.facebook.presto.server.testing.TestingPrestoServer;
import com.facebook.presto.server.testing.TestingPrestoServerLauncherOptions;
import com.facebook.presto.spi.Plugin;
import io.airlift.airline.Command;
import io.airlift.airline.Help;
import io.airlift.airline.HelpOption;
import io.airlift.airline.SingleCommand;
import io.airlift.airline.model.CommandMetadata;
import javax.inject.Inject;

@Command(name="testing_presto_server", description="Testing Presto Server Launcher")
public class TestingPrestoServerLauncher {
    @Inject
    CommandMetadata commandMetadata;
    @Inject
    public HelpOption helpOption;
    @Inject
    TestingPrestoServerLauncherOptions options = new TestingPrestoServerLauncherOptions();

    private static void waitForInterruption() {
        try {
            Thread.currentThread().join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void run() throws Exception {
        try (TestingPrestoServer server = new TestingPrestoServer();){
            for (String pluginClass : this.options.getPluginClassNames()) {
                Plugin plugin = (Plugin)Class.forName(pluginClass).getConstructor(new Class[0]).newInstance(new Object[0]);
                server.installPlugin(plugin);
            }
            for (TestingPrestoServerLauncherOptions.Catalog catalog : this.options.getCatalogs()) {
                server.createCatalog(catalog.getCatalogName(), catalog.getConnectorName());
            }
            System.out.println(server.getAddress());
            TestingPrestoServerLauncher.waitForInterruption();
        }
    }

    public static void main(String[] args) throws Exception {
        TestingPrestoServerLauncher launcher = (TestingPrestoServerLauncher)SingleCommand.singleCommand(TestingPrestoServerLauncher.class).parse(args);
        if (launcher.helpOption.showHelpIfRequested()) {
            return;
        }
        try {
            launcher.validateOptions();
        }
        catch (IllegalStateException e) {
            System.out.println("ERROR: " + e.getMessage());
            System.out.println();
            Help.help((CommandMetadata)launcher.commandMetadata);
            return;
        }
        launcher.run();
    }

    private void validateOptions() {
        this.options.validate();
    }
}

