/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.teradata.functions.dateformat;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.teradata.functions.DateFormat;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.List;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Token;

public class DateFormatParser {
    private DateFormatParser() {
    }

    public static DateTimeFormatter createDateTimeFormatter(String format, Mode mode) {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        boolean formatContainsHourOfAMPM = false;
        block13: for (Token token : DateFormatParser.tokenize(format)) {
            switch (token.getType()) {
                case 9: {
                    builder.appendLiteral(token.getText());
                    continue block13;
                }
                case 1: {
                    builder.appendValue(ChronoField.DAY_OF_MONTH, mode.getMinTwoPositionFieldWidth(), 2, SignStyle.NOT_NEGATIVE);
                    continue block13;
                }
                case 2: {
                    builder.appendValue(ChronoField.HOUR_OF_DAY, mode.getMinTwoPositionFieldWidth(), 2, SignStyle.NOT_NEGATIVE);
                    continue block13;
                }
                case 3: {
                    builder.appendValue(ChronoField.HOUR_OF_AMPM, mode.getMinTwoPositionFieldWidth(), 2, SignStyle.NOT_NEGATIVE);
                    formatContainsHourOfAMPM = true;
                    continue block13;
                }
                case 5: {
                    builder.appendValue(ChronoField.MINUTE_OF_HOUR, mode.getMinTwoPositionFieldWidth(), 2, SignStyle.NOT_NEGATIVE);
                    continue block13;
                }
                case 4: {
                    builder.appendValue(ChronoField.MONTH_OF_YEAR, mode.getMinTwoPositionFieldWidth(), 2, SignStyle.NOT_NEGATIVE);
                    continue block13;
                }
                case 6: {
                    builder.appendValue(ChronoField.SECOND_OF_MINUTE, mode.getMinTwoPositionFieldWidth(), 2, SignStyle.NOT_NEGATIVE);
                    continue block13;
                }
                case 8: {
                    builder.appendValueReduced((TemporalField)ChronoField.YEAR, 2, 2, 2000);
                    continue block13;
                }
                case 7: {
                    builder.appendValue(ChronoField.YEAR, 4);
                    continue block13;
                }
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Failed to tokenize string [%s] at offset [%d]", token.getText(), token.getCharPositionInLine()));
        }
        try {
            if (formatContainsHourOfAMPM) {
                builder.parseDefaulting(ChronoField.HOUR_OF_AMPM, 0L).parseDefaulting(ChronoField.AMPM_OF_DAY, 0L);
            } else {
                builder.parseDefaulting(ChronoField.HOUR_OF_DAY, 0L);
            }
            return builder.parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter();
        }
        catch (UnsupportedOperationException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }

    public static List<? extends Token> tokenize(String format) {
        DateFormat lexer = new DateFormat((CharStream)new ANTLRInputStream(format));
        return lexer.getAllTokens();
    }

    public static enum Mode {
        PARSER(1),
        FORMATTER(2);

        private final int minTwoPositionFieldWidth;

        public int getMinTwoPositionFieldWidth() {
            return this.minTwoPositionFieldWidth;
        }

        private Mode(int value) {
            this.minTwoPositionFieldWidth = value;
        }
    }
}

