/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.teradata.functions;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.DateTimeEncoding;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.teradata.functions.dateformat.DateFormatParser;
import com.google.common.base.Throwables;
import io.airlift.concurrent.ThreadLocalCache;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormatter;

public final class TeradataDateFunctions {
    private static final ThreadLocalCache<Slice, DateTimeFormatter> DATETIME_FORMATTER_CACHE = new ThreadLocalCache(100, format -> DateFormatParser.createDateTimeFormatter(format.toStringUtf8()));
    private static final ISOChronology[] CHRONOLOGIES = new ISOChronology[TimeZoneKey.MAX_TIME_ZONE_KEY + 1];

    private TeradataDateFunctions() {
    }

    @Description(value="Formats a timestamp")
    @ScalarFunction(value="to_char")
    @SqlType(value="varchar")
    public static Slice toChar(ConnectorSession session, @SqlType(value="timestamp with time zone") long timestampWithTimeZone, @SqlType(value="varchar") Slice formatString) {
        DateTimeFormatter formatter = ((DateTimeFormatter)DATETIME_FORMATTER_CACHE.get((Object)formatString)).withChronology((Chronology)CHRONOLOGIES[DateTimeEncoding.unpackZoneKey((long)timestampWithTimeZone).getKey()]).withLocale(session.getLocale());
        return Slices.utf8Slice((String)formatter.print(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone)));
    }

    @Description(value="Converts a string to a DATE data type")
    @ScalarFunction(value="to_date")
    @SqlType(value="date")
    public static long toDate(ConnectorSession session, @SqlType(value="varchar") Slice dateTime, @SqlType(value="varchar") Slice formatString) {
        try {
            long millis = TeradataDateFunctions.parseMillis(TimeZoneKey.UTC_KEY, session.getLocale(), dateTime, formatString);
            return TimeUnit.MILLISECONDS.toDays(millis);
        }
        catch (Throwable t) {
            Throwables.throwIfInstanceOf((Throwable)t, Error.class);
            Throwables.throwIfInstanceOf((Throwable)t, PrestoException.class);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
        }
    }

    @Description(value="Converts a string to a TIMESTAMP data type")
    @ScalarFunction(value="to_timestamp")
    @SqlType(value="timestamp")
    public static long toTimestamp(ConnectorSession session, @SqlType(value="varchar") Slice dateTime, @SqlType(value="varchar") Slice formatString) {
        return TeradataDateFunctions.parseMillis(session, dateTime, formatString);
    }

    private static long parseMillis(ConnectorSession session, Slice dateTime, Slice formatString) {
        TimeZoneKey timeZoneKey = TimeZoneKey.UTC_KEY;
        if (session.isLegacyTimestamp()) {
            timeZoneKey = session.getTimeZoneKey();
        }
        return TeradataDateFunctions.parseMillis(timeZoneKey, session.getLocale(), dateTime, formatString);
    }

    private static long parseMillis(TimeZoneKey timeZoneKey, Locale locale, Slice dateTime, Slice formatString) {
        DateTimeFormatter formatter = ((DateTimeFormatter)DATETIME_FORMATTER_CACHE.get((Object)formatString)).withChronology((Chronology)CHRONOLOGIES[timeZoneKey.getKey()]).withLocale(locale);
        try {
            return formatter.parseMillis(dateTime.toString(StandardCharsets.UTF_8));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }

    static {
        for (TimeZoneKey timeZoneKey : TimeZoneKey.getTimeZoneKeys()) {
            DateTimeZone dateTimeZone = DateTimeZone.forID((String)timeZoneKey.getId());
            TeradataDateFunctions.CHRONOLOGIES[timeZoneKey.getKey()] = ISOChronology.getInstance((DateTimeZone)dateTimeZone);
        }
    }
}

