/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.teradata.functions;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.DateTimeEncoding;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.teradata.functions.dateformat.DateFormatParser;
import com.facebook.presto.type.TimestampOperators;
import com.facebook.presto.util.DateTimeZoneIndex;
import com.facebook.presto.util.ThreadLocalCache;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.StandardCharsets;
import org.joda.time.Chronology;
import org.joda.time.format.DateTimeFormatter;

public final class TeradataDateFunctions {
    private static final ThreadLocalCache<Slice, DateTimeFormatter> DATETIME_FORMATTER_CACHE = new ThreadLocalCache<Slice, DateTimeFormatter>(100){

        protected DateTimeFormatter load(Slice format) {
            String formatString = format.toStringUtf8();
            return DateFormatParser.createDateTimeFormatter(formatString);
        }
    };

    private TeradataDateFunctions() {
    }

    @Description(value="Formats a timestamp")
    @ScalarFunction(value="to_char")
    @SqlType(value="varchar")
    public static Slice toChar(ConnectorSession session, @SqlType(value="timestamp with time zone") long timestampWithTimeZone, @SqlType(value="varchar") Slice formatString) {
        DateTimeFormatter formatter = ((DateTimeFormatter)DATETIME_FORMATTER_CACHE.get((Object)formatString)).withChronology((Chronology)DateTimeZoneIndex.unpackChronology((long)timestampWithTimeZone)).withLocale(session.getLocale());
        return Slices.utf8Slice((String)formatter.print(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone)));
    }

    @Description(value="Converts a string to a DATE data type")
    @ScalarFunction(value="to_date")
    @SqlType(value="date")
    public static long toDate(ConnectorSession session, @SqlType(value="varchar") Slice dateTime, @SqlType(value="varchar") Slice formatString) {
        return TimestampOperators.castToDate((ConnectorSession)session, (long)TeradataDateFunctions.parseMillis(session, dateTime, formatString));
    }

    @Description(value="Converts a string to a TIMESTAMP data type")
    @ScalarFunction(value="to_timestamp")
    @SqlType(value="timestamp")
    public static long toTimestamp(ConnectorSession session, @SqlType(value="varchar") Slice dateTime, @SqlType(value="varchar") Slice formatString) {
        return TeradataDateFunctions.parseMillis(session, dateTime, formatString);
    }

    private static long parseMillis(ConnectorSession session, Slice dateTime, Slice formatString) {
        DateTimeFormatter formatter = ((DateTimeFormatter)DATETIME_FORMATTER_CACHE.get((Object)formatString)).withChronology((Chronology)DateTimeZoneIndex.getChronology((TimeZoneKey)session.getTimeZoneKey())).withLocale(session.getLocale());
        try {
            return formatter.parseMillis(dateTime.toString(StandardCharsets.UTF_8));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }
}

