/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.teradata.functions;

import com.facebook.presto.operator.Description;
import com.facebook.presto.operator.scalar.ScalarFunction;
import com.facebook.presto.operator.scalar.StringFunctions;
import com.facebook.presto.type.LiteralParameters;
import com.facebook.presto.type.SqlType;
import com.google.common.io.BaseEncoding;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public final class TeradataStringFunctions {
    private TeradataStringFunctions() {
    }

    @Description(value="Returns index of first occurrence of a substring (or 0 if not found)")
    @ScalarFunction(value="index")
    @SqlType(value="bigint")
    public static long index(@SqlType(value="varchar") Slice string, @SqlType(value="varchar") Slice substring) {
        return StringFunctions.stringPosition((Slice)string, (Slice)substring);
    }

    @Description(value="suffix starting at given index")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice substring(@SqlType(value="varchar(x)") Slice utf8, @SqlType(value="bigint") long start) {
        return StringFunctions.substr((Slice)utf8, (long)start);
    }

    @Description(value="substring of given length starting at an index")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice substring(@SqlType(value="varchar(x)") Slice utf8, @SqlType(value="bigint") long start, @SqlType(value="bigint") long length) {
        return StringFunctions.substr((Slice)utf8, (long)start, (long)length);
    }

    @Description(value="Returns the hexadecimal representation of the UTF-16BE encoding of the argument")
    @ScalarFunction(value="char2hexint")
    @SqlType(value="varchar")
    public static Slice char2HexInt(@SqlType(value="varchar") Slice string) {
        Slice utf16 = Slices.wrappedBuffer((ByteBuffer)StandardCharsets.UTF_16BE.encode(string.toStringUtf8()));
        String encoded = BaseEncoding.base16().encode(utf16.getBytes());
        return Slices.utf8Slice((String)encoded);
    }
}

