/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.testing;

import com.facebook.presto.spark.testing.Processes;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DockerCompose {
    private final File composeYaml;

    public DockerCompose(File composeYaml) {
        Objects.requireNonNull(composeYaml, "composeYaml is null");
        Preconditions.checkArgument((composeYaml.exists() && composeYaml.isFile() ? 1 : 0) != 0, (String)"file does not exist: %s", (Object)composeYaml);
        Preconditions.checkArgument((boolean)composeYaml.canRead(), (String)"file is not readable: %s", (Object)composeYaml);
        this.composeYaml = composeYaml;
    }

    public void verifyInstallation() throws InterruptedException {
        Preconditions.checkState((Processes.execute("docker", "--version") == 0 ? 1 : 0) != 0, (Object)"docker is not installed");
        Preconditions.checkState((Processes.execute("docker", "compose", "--version") == 0 ? 1 : 0) != 0, (Object)"docker compose is not installed");
    }

    public void pull() throws InterruptedException {
        int exitCode = this.execute("pull");
        Preconditions.checkState((exitCode == 0 ? 1 : 0) != 0, (String)"pull existed with code: %s", (int)exitCode);
    }

    public Process up(Map<String, Integer> services) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        parameters.add((Object[])new String[]{"up", "--force-recreate", "--abort-on-container-exit"});
        services.forEach((service, scale) -> parameters.add((Object[])new String[]{"--scale", String.format("%s=%s", service, scale)}));
        parameters.addAll(services.keySet());
        return this.start((List<String>)parameters.build());
    }

    public void down() throws InterruptedException {
        int exitCode = this.execute("down");
        Preconditions.checkState((exitCode == 0 ? 1 : 0) != 0, (String)"down exited with code: %s", (int)exitCode);
    }

    public String getContainerAddress(String service) throws InterruptedException {
        String containerId = this.getContainerId(service);
        return Processes.executeForOutput("docker", "inspect", "-f", "{{range .NetworkSettings.Networks}}{{.IPAddress}}{{end}}", containerId).trim();
    }

    public int run(String ... parameters) throws InterruptedException {
        return this.run((List<String>)ImmutableList.copyOf((Object[])parameters));
    }

    public int run(List<String> parameters) throws InterruptedException {
        ImmutableList.Builder args = ImmutableList.builder();
        args.add((Object[])new String[]{"run", "--rm"});
        args.addAll(parameters);
        return this.execute((List<String>)args.build());
    }

    private String getContainerId(String service) throws InterruptedException {
        List<String> containerIds = this.getContainerIds();
        for (String containerId : containerIds) {
            String output = Processes.executeForOutput("docker", "ps", "-q", "--filter", String.format("id=%s", containerId), "--filter", String.format("name=%s", service));
            if (output.isEmpty()) continue;
            return containerId;
        }
        throw new IllegalArgumentException(String.format("container not found: %s", service));
    }

    private List<String> getContainerIds() throws InterruptedException {
        String output = this.executeForOutput("ps", "-q");
        return Splitter.on((char)'\n').trimResults().omitEmptyStrings().splitToList((CharSequence)output);
    }

    private int execute(String ... args) throws InterruptedException {
        return this.execute((List<String>)ImmutableList.copyOf((Object[])args));
    }

    private int execute(List<String> args) throws InterruptedException {
        return Processes.waitForProcess(this.start(args));
    }

    private String executeForOutput(String ... args) throws InterruptedException {
        return this.executeForOutput((List<String>)ImmutableList.copyOf((Object[])args));
    }

    private String executeForOutput(List<String> args) throws InterruptedException {
        return Processes.executeForOutput((List<String>)ImmutableList.builder().add((Object[])new String[]{"docker", "compose", "-f", this.composeYaml.getAbsolutePath()}).addAll(args).build());
    }

    private Process start(List<String> args) {
        return Processes.startProcess((List<String>)ImmutableList.builder().add((Object[])new String[]{"docker", "compose", "-f", this.composeYaml.getAbsolutePath()}).addAll(args).build());
    }
}

