/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.testing;

import com.facebook.airlift.log.Logger;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Processes {
    private static final Logger log = Logger.get(Processes.class);

    private Processes() {
    }

    public static String executeForOutput(String ... command) throws InterruptedException {
        return Processes.executeForOutput((List<String>)ImmutableList.copyOf((Object[])command));
    }

    public static String executeForOutput(List<String> command) throws InterruptedException {
        String result;
        String commandString = Joiner.on((String)" ").join(command);
        log.info("Running: %s", new Object[]{commandString});
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        Process process = Processes.startProcess(processBuilder);
        Processes.closeInput(process);
        Processes.pipeStderr(commandString, process);
        try (InputStream inputStream = process.getInputStream();){
            result = CharStreams.toString((Readable)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        int exitCode = Processes.waitForProcess(process);
        Preconditions.checkState((exitCode == 0 ? 1 : 0) != 0, (String)"[%s] process existed with status: %s", (Object)commandString, (int)exitCode);
        return result;
    }

    public static int execute(String ... command) throws InterruptedException {
        return Processes.execute((List<String>)ImmutableList.copyOf((Object[])command));
    }

    public static int execute(List<String> command) throws InterruptedException {
        log.info("Running: %s", new Object[]{Joiner.on((String)" ").join(command)});
        return Processes.waitForProcess(Processes.startProcess(command));
    }

    public static int waitForProcess(Process process) throws InterruptedException {
        try {
            return process.waitFor();
        }
        catch (InterruptedException e) {
            Processes.destroyProcess(process);
            throw e;
        }
    }

    public static Process startProcess(List<String> command) {
        String commandString = Joiner.on((String)" ").join(command);
        log.info("Starting: %s", new Object[]{commandString});
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        Process process = Processes.startProcess(processBuilder);
        Processes.closeInput(process);
        Processes.pipeStdout(commandString, process);
        Processes.pipeStderr(commandString, process);
        return process;
    }

    public static Process startProcess(ProcessBuilder processBuilder) {
        try {
            return processBuilder.start();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void destroyProcess(Process process) {
        if (!process.isAlive()) {
            return;
        }
        process.destroy();
        for (int i = 0; i < 5 && process.isAlive(); ++i) {
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        process.destroyForcibly();
    }

    private static void pipeStdout(String command, Process process) {
        Processes.pipe("PIPE STDOUT: " + command, process.getInputStream(), System.out);
    }

    private static void pipeStderr(String command, Process process) {
        Processes.pipe("PIPE STDERR: " + command, process.getErrorStream(), System.err);
    }

    private static void closeInput(Process process) {
        try {
            process.getOutputStream().close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void pipe(String name, InputStream input, OutputStream output) {
        Thread thread = new Thread(() -> {
            try {
                ByteStreams.copy((InputStream)input, (OutputStream)output);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        thread.setName(name);
        thread.start();
    }
}

