/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.classloader_interface;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.spark.MapOutputTracker;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;

public class PrestoSparkUtils {
    private PrestoSparkUtils() {
    }

    public static <T> Collection<T> asJavaCollection(Iterable<T> iterable) {
        return JavaConversions.asJavaCollection(iterable);
    }

    public static <T> List<T> seqAsJavaList(Seq<T> iterable) {
        return JavaConversions.seqAsJavaList(iterable);
    }

    public static <T> Buffer<T> asScalaBuffer(List<T> list) {
        return JavaConversions.asScalaBuffer(list);
    }

    public static Collection<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> getMapSizesByExecutorId(MapOutputTracker mapOutputTracker, int shuffleId, int startPartitionId, int endPartitionId) {
        return PrestoSparkUtils.convertCollection(PrestoSparkUtils.asJavaCollection(mapOutputTracker.getMapSizesByExecutorId(shuffleId, startPartitionId, endPartitionId).toList()));
    }

    public static <T> scala.collection.immutable.Seq<T> toImmutableSeq(Seq<T> seq) {
        if (seq instanceof scala.collection.immutable.Seq) {
            return (scala.collection.immutable.Seq)seq;
        }
        List<T> javaList = PrestoSparkUtils.seqAsJavaList(seq);
        return PrestoSparkUtils.asScalaBuffer(javaList).toList();
    }

    public static Collection<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> convertCollection(Collection<Tuple2<BlockManagerId, Seq<Tuple2<BlockId, Object>>>> inputCollection) {
        return inputCollection.stream().map(entry -> new Tuple2((Object)((BlockManagerId)entry._1()), PrestoSparkUtils.convertTuple2SeqToTuple3Seq((Seq<Tuple2<BlockId, Object>>)((Seq)entry._2()), null))).collect(Collectors.toList());
    }

    public static Seq<Tuple3<BlockId, Object, Object>> convertTuple2SeqToTuple3Seq(Seq<Tuple2<BlockId, Object>> tuple2Seq, Object thirdElement) {
        List tuple3List = PrestoSparkUtils.seqAsJavaList(tuple2Seq).stream().map(tuple2 -> new Tuple3((Object)((BlockId)tuple2._1), tuple2._2, thirdElement)).collect(Collectors.toList());
        return PrestoSparkUtils.asScalaBuffer(tuple3List).toSeq();
    }
}

