/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.classloader_interface;

import java.io.Serializable;
import java.util.Objects;

public class PrestoSparkShuffleStats
implements Serializable {
    private final int fragmentId;
    private final int taskId;
    private final Operation operation;
    private final long processedRows;
    private final long processedRowBatches;
    private final long processedBytes;
    private final long elapsedWallTimeMills;

    public PrestoSparkShuffleStats(int fragmentId, int taskId, Operation operation, long processedRows, long processedRowBatches, long processedBytes, long elapsedWallTimeMills) {
        this.fragmentId = fragmentId;
        this.taskId = taskId;
        this.operation = Objects.requireNonNull(operation, "operation is null");
        PrestoSparkShuffleStats.checkArgument(processedRows >= 0L, "processedRows must be greater than or equal to zero: %s", processedRows);
        this.processedRows = processedRows;
        PrestoSparkShuffleStats.checkArgument(processedRowBatches >= 0L, "processedRowBatches must be greater than or equal to zero: %s", processedRowBatches);
        this.processedRowBatches = processedRowBatches;
        PrestoSparkShuffleStats.checkArgument(processedBytes >= 0L, "processedBytes must be greater than or equal to zero: %s", processedBytes);
        this.processedBytes = processedBytes;
        PrestoSparkShuffleStats.checkArgument(elapsedWallTimeMills >= 0L, "elapsedWallTimeMills must be greater than or equal to zero: %s", elapsedWallTimeMills);
        this.elapsedWallTimeMills = elapsedWallTimeMills;
    }

    public int getFragmentId() {
        return this.fragmentId;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public long getProcessedRows() {
        return this.processedRows;
    }

    public long getProcessedRowBatches() {
        return this.processedRowBatches;
    }

    public long getProcessedBytes() {
        return this.processedBytes;
    }

    public long getElapsedWallTimeMills() {
        return this.elapsedWallTimeMills;
    }

    public String toString() {
        return "";
    }

    private static void checkArgument(boolean condition, String message, Object ... args) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    public static enum Operation {
        READ,
        WRITE;

    }
}

